/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.guice.bridge.internal;

import com.google.inject.BindingAnnotation;
import com.google.inject.MembersInjector;
import com.google.inject.TypeLiteral;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import jakarta.inject.Qualifier;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.LinkedList;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.guice.bridge.api.HK2Inject;

public class HK2ToGuiceTypeListenerImpl
implements TypeListener {
    private final ServiceLocator locator;

    public HK2ToGuiceTypeListenerImpl(ServiceLocator locator) {
        this.locator = locator;
    }

    private static boolean isQualifier(Annotation anno) {
        Class<? extends Annotation> annoClass = anno.annotationType();
        return annoClass.isAnnotationPresent(Qualifier.class) || annoClass.isAnnotationPresent(BindingAnnotation.class);
    }

    public <I> void hear(TypeLiteral<I> literal, TypeEncounter<I> encounter) {
        Class clazz = literal.getRawType();
        HashSet<String> dupFinder = new HashSet<String>();
        for (Class walkingClass = clazz; walkingClass != null; walkingClass = walkingClass.getSuperclass()) {
            for (Field field : walkingClass.getDeclaredFields()) {
                if (dupFinder.contains(field.getName())) continue;
                dupFinder.add(field.getName());
                if (!field.isAnnotationPresent(HK2Inject.class)) continue;
                LinkedList<Annotation> qualifiers = new LinkedList<Annotation>();
                for (Annotation anno : field.getAnnotations()) {
                    if (!HK2ToGuiceTypeListenerImpl.isQualifier(anno)) continue;
                    qualifiers.add(anno);
                }
                encounter.register(new HK2FieldInjector(this.locator, field.getGenericType(), qualifiers.toArray(new Annotation[qualifiers.size()]), field));
            }
        }
    }

    private static class HK2FieldInjector<T>
    implements MembersInjector<T> {
        private final ServiceLocator locator;
        private final Type requiredType;
        private final Annotation[] qualifiers;
        private final Field field;

        private HK2FieldInjector(ServiceLocator locator, Type requiredType, Annotation[] qualifiers, Field field) {
            this.locator = locator;
            this.requiredType = requiredType;
            this.qualifiers = qualifiers;
            this.field = field;
            field.setAccessible(true);
        }

        public void injectMembers(T arg0) {
            ServiceHandle handle = this.locator.getServiceHandle(this.requiredType, this.qualifiers);
            if (handle == null) {
                throw new IllegalStateException("Could not find a service of type " + this.requiredType);
            }
            Object injectMe = handle.getService();
            try {
                this.field.set(arg0, injectMe);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

