/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.util;

import ca.sqlpower.enterprise.client.SPServerInfo;
import ca.sqlpower.object.CleanupExceptions;
import ca.sqlpower.object.SPListener;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.sqlobject.SQLObject;
import ca.sqlpower.util.UserPrompter;
import ca.sqlpower.util.UserPrompterFactory;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.ServletContext;
import org.apache.log4j.Logger;

public class SQLPowerUtils {
    private static final Logger logger = Logger.getLogger(SQLPowerUtils.class);

    public static boolean areEqual(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    public static boolean hierarchyContains(SPObject root, SPObject child) {
        return SQLPowerUtils.getAncestorList(child).contains(root);
    }

    public static String escapeXML(String src) {
        if (src == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer(src.length() + 10);
        int n = src.length();
        for (int i = 0; i < n; ++i) {
            char ch = src.charAt(i);
            if (ch == '\'') {
                sb.append("&apos;");
                continue;
            }
            if (ch == '\"') {
                sb.append("&quot;");
                continue;
            }
            if (ch == '&') {
                sb.append("&amp;");
                continue;
            }
            if (ch == '<') {
                sb.append("&lt;");
                continue;
            }
            if (ch == '>') {
                sb.append("&gt;");
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public static String escapeNewLines(String src) {
        if (src == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer(src.length() + 10);
        int n = src.length();
        for (int i = 0; i < n; ++i) {
            char ch = src.charAt(i);
            sb.append(ch == '\n' ? "&amp;crlf;" : Character.valueOf(ch));
        }
        return sb.toString();
    }

    public static String unEscapeNewLines(String src) {
        if (src == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer(src.length() + 10);
        int n = src.length();
        for (int i = 0; i < n; ++i) {
            char ch = src.charAt(i);
            if (ch == '&') {
                if (src.length() - i > 6 && "&crlf;".equals(src.substring(i, i + 6))) {
                    sb.append("\n");
                    i += 5;
                    continue;
                }
                sb.append(ch);
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public static void logPropertyChange(@Nonnull Logger logger, @Nullable String message, @Nonnull PropertyChangeEvent evt) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(message + ": " + evt.getPropertyName() + " \"" + evt.getOldValue() + "\" -> \"" + evt.getNewValue() + "\""));
        }
    }

    public static long copyStream(InputStream source, OutputStream output) throws IOException {
        int next;
        long total = 0L;
        while ((next = source.read()) != -1) {
            output.write(next);
            ++total;
        }
        output.flush();
        return total;
    }

    public static CleanupExceptions cleanupSPObject(SPObject o) {
        CleanupExceptions exceptions = new CleanupExceptions();
        exceptions.add(o.cleanup());
        for (SPObject sPObject : o.getChildren()) {
            exceptions.add(SQLPowerUtils.cleanupSPObject(sPObject));
        }
        return exceptions;
    }

    public static List<SPObject> getAncestorList(SPObject o) {
        ArrayList<SPObject> ancestors = new ArrayList<SPObject>();
        for (SPObject parent = o.getParent(); parent != null; parent = parent.getParent()) {
            ancestors.add(0, parent);
        }
        return ancestors;
    }

    public static <T extends SPObject> T findByUuid(SPObject root, String uuid, Class<T> expectedType) {
        return (T)((SPObject)expectedType.cast(SQLPowerUtils.findRecursively(root, uuid)));
    }

    private static SPObject findRecursively(SPObject startWith, String uuid) {
        if (startWith == null) {
            throw new IllegalArgumentException("Cannot search a null object for children with the uuid " + uuid);
        }
        if (uuid.equals(startWith.getUUID())) {
            return startWith;
        }
        List<? extends SPObject> children = startWith instanceof SQLObject ? ((SQLObject)startWith).getChildrenWithoutPopulating() : startWith.getChildren();
        for (SPObject sPObject : children) {
            SPObject found = SQLPowerUtils.findRecursively(sPObject, uuid);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    public static void listenToHierarchy(SPObject root, SPListener spcl) {
        root.addSPListener(spcl);
        if (root.allowsChildren()) {
            List<? extends SPObject> children = root instanceof SQLObject ? ((SQLObject)root).getChildrenWithoutPopulating() : root.getChildren();
            for (SPObject sPObject : children) {
                SQLPowerUtils.listenToHierarchy(sPObject, spcl);
            }
        }
    }

    public static void listenToShallowHierarchy(SPListener listener, SPObject root) {
        root.addSPListener(listener);
        logger.debug((Object)("listenToShallowHierarchy: \"" + root.getName() + "\" (" + root.getClass().getName() + ") children: " + root.getChildren()));
        for (SPObject sPObject : root.getChildren()) {
            sPObject.addSPListener(listener);
        }
    }

    public static void unlistenToHierarchy(SPObject root, SPListener spcl) {
        root.removeSPListener(spcl);
        if (root.allowsChildren()) {
            List<? extends SPObject> children = root instanceof SQLObject ? ((SQLObject)root).getChildrenWithoutPopulating() : root.getChildren();
            for (SPObject sPObject : children) {
                SQLPowerUtils.unlistenToHierarchy(sPObject, spcl);
            }
        }
    }

    public static void printSubtree(PrintWriter out, SPObject startWith) {
        SQLPowerUtils.printSubtree(out, startWith, 0);
    }

    private static void printSubtree(PrintWriter out, SPObject startWith, int indentDepth) {
        out.printf("%s%s \"%s\" (%s)\n", SQLPowerUtils.spaces(indentDepth * 2), startWith.getClass().getSimpleName(), startWith.getName(), startWith.getUUID());
        for (SPObject sPObject : startWith.getChildren()) {
            SQLPowerUtils.printSubtree(out, sPObject, indentDepth + 1);
        }
    }

    private static String spaces(int n) {
        StringBuilder sb = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            sb.append(" ");
        }
        return sb.toString();
    }

    public static String serviceInfoSummary(SPServerInfo si) {
        return si.getName() + " (" + si.getServerAddress() + ":" + si.getPort() + ")";
    }

    public static void displayCleanupErrors(@Nonnull CleanupExceptions cleanupObject, UserPrompterFactory upf) {
        if (upf != null) {
            if (!cleanupObject.isCleanupSuccessful()) {
                StringBuffer message = new StringBuffer();
                message.append("The following errors occurred during closing\n");
                for (String error : cleanupObject.getErrorMessages()) {
                    message.append("   " + error + "\n");
                }
                for (Exception exception : cleanupObject.getExceptions()) {
                    message.append("   " + exception.getMessage() + "\n");
                    logger.error((Object)"Exception during cleanup", (Throwable)exception);
                }
                UserPrompter up = upf.createUserPrompter(message.toString(), UserPrompterFactory.UserPromptType.MESSAGE, UserPrompter.UserPromptOptions.OK, UserPrompter.UserPromptResponse.OK, null, "OK");
                up.promptUser(new Object[0]);
            }
        } else {
            SQLPowerUtils.logCleanupErrors(cleanupObject);
        }
    }

    public static void logCleanupErrors(@Nonnull CleanupExceptions cleanupObject) {
        for (String error : cleanupObject.getErrorMessages()) {
            logger.debug((Object)("Exception during cleanup, " + error));
        }
        for (Exception exception : cleanupObject.getExceptions()) {
            logger.error((Object)"Exception during cleanup", (Throwable)exception);
        }
    }

    public static URI resolveConfiguredPath(ServletContext context, String path) {
        if (path.contains("://")) {
            try {
                return new URI(path);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Configured path " + path + " looks like a URI, but isn't. " + "Check your typing.", e);
            }
        }
        return SQLPowerUtils.resolveConfiguredFilePath(context, path).toURI();
    }

    public static File resolveConfiguredFilePath(ServletContext context, String path) {
        if (path.startsWith("webapp:")) {
            if (context == null) {
                throw new IllegalArgumentException("Path specifications starting with 'webapp:' are only allowed in web applications");
            }
            String contextPath = path.substring("webapp:".length());
            String realPath = context.getRealPath(contextPath);
            if (realPath == null) {
                throw new IllegalArgumentException("Webapp path " + path + " could not be resolved. " + "Check that it is valid, and ensure this webapp has " + "been deployed in \"exploded\" mode.");
            }
            File file = new File(realPath);
            if (!file.exists()) {
                throw new IllegalArgumentException("Webapp path " + path + " resolved to " + file.getAbsolutePath() + ", which does not exist. Check that the path is valid, " + "and ensure this webapp has been deployed in \"exploded\" mode.");
            }
            return file;
        }
        File file = new File(path);
        return file;
    }

    public static <T extends SPObject> T getAncestor(SPObject so, Class<T> ancestorType) {
        while (so != null) {
            if (so.getClass().equals(ancestorType) || ancestorType.isAssignableFrom(so.getClass())) {
                return (T)((SPObject)ancestorType.cast(so));
            }
            so = so.getParent();
        }
        return null;
    }

    public static Throwable rootCause(Throwable t) {
        while (t.getCause() != null) {
            t = t.getCause();
        }
        return t;
    }

    public static String exceptionStackToString(Throwable throwable) {
        Throwable t = throwable;
        StringWriter stringWriter = new StringWriter();
        PrintWriter traceWriter = new PrintWriter(stringWriter);
        do {
            t.printStackTrace(traceWriter);
            if (SQLPowerUtils.rootCause(t) instanceof SQLException) {
                if ((t = ((SQLException)SQLPowerUtils.rootCause(t)).getNextException()) == null) continue;
                traceWriter.println("Next Exception:");
                continue;
            }
            t = null;
        } while (t != null);
        traceWriter.close();
        return stringWriter.toString();
    }
}

