<-- This file is part 2 of the GNU version of
    The Collaborative International Dictionary of English (GCIDE)

    Copyright (C) 1992-2012 Patrick J. Cassidy
    Copyright (C) 2012-2024 Sergey Poznyakoff

    GCIDE is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 3, or (at your option)
    any later version.

    GCIDE is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this copy of GCIDE.  If not, see <http://www.gnu.org/licenses/>.
-->

<p><-- p. 109 pr=SA --></p>

<p><centered><point26>B.</point26></centered></p>

<p><ent>B</ent><br/
<hw>B</hw> <pr>(b<emac/)</pr> <def>is the second letter of the English
alphabet. (See <xex>Guide to Pronunciation</xex>, <sect/<sect/ 196,
220.) It is etymologically related to <it>p</it>, <it>v</it>,
<it>f</it>, <it>w</it>, and <it>m</it>, letters representing sounds
having a close organic affinity to its own sound; as in Eng.
<xex>b</xex>ursar and <xex>p</xex>urser; Eng. <xex>b</xex>ear and Lat.
<xex>f</xex>erre; Eng. sil<xex>v</xex>er and Ger. sil<xex>b</xex>er;
Lat. cu<xex>b</xex>itum and It. go<xex>m</xex>ito; Eng.
se<xex>v</xex>en, Anglo-Saxon seo<xex>f</xex>on, Ger. sie<xex>b</xex>en,
Lat. se<xex>p</xex>tem, Gr.<grk>"epta`</grk>, Sanskrit
sa<xex>p</xex>tan. The form of letter B is Roman, from the Greek B
(<xex>Beta</xex>), of Semitic origin. The small b was formed by gradual
change from the capital B.</def><br/
[<source>1913 Webster</source>]</p>

<p><note>In <fld>(Music)</fld>, B is the nominal of the seventh tone in
the model major scale (the scale of C major), or of the second tone in
it's relative minor scale (that of A minor). B<flat/ stands for B flat,
the tone a half step, or semitone, lower than B. In German, B stands for
our B<flat/, while our B natural is called H (pronounced
h<aum/).</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>B-52</ent><br/
<hw>B-52</hw> <pos>n.</pos> <def>A large long-range bomber airplane of
the U. S. military aircraft fleet; <it>B-</it> stands for bomber. It has
the capability of delivering nuclear weapons.</def><br/
[<source>WordNet 1.5</source> <source>+PJC</source>]</p>

<p><ent>Ba</ent><br/
<hw>Ba</hw> <pr>(b<aum/)</pr>, <pos>v. t.</pos> <ety>[Cf. OF.
<ets>baer</ets> to open the mouth, F. <ets>bayer</ets>.]</ety> <def>To
kiss.</def> <mark>[Obs.]</mark> <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baa</ent><br/
<hw>Baa</hw> <pr>(b<aum/)</pr>, <pos>v. i.</pos> <ety>[Cf. G.
<ets>b<aum/en</ets>; an imitative word.]</ety> <def>To cry baa, or bleat
as a sheep.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>He treble <qex>baas</qex> for help, but none can get.</q>
<rj><qau>Sir P. Sidney.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baa</ent><br/
<hw>Baa</hw> <pr>(b<aum/)</pr>, <pos>n.</pos>; <plu><it>pl.</it>
<plw>Baas</plw> <pr>(b<aum/z)</pr>.</plu> <ety>[Cf. G.
<ets>b<aum/</ets>.]</ety> <def>The cry or bleating of a sheep; a
bleat.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baaing</ent><br/
<hw>Baa"ing</hw>, <pos>n.</pos> <def>The bleating of a sheep.</def>
<rj><au>Marryat.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baal</ent><br/
<hw>Ba"al</hw> <pr>(b<amac/"<ait/l)</pr>, <pos>n.</pos>; <plu>Heb. pl.
<plw>Baalim</plw> <pr>(-<icr/m)</pr>.</plu> <ety>[Heb. <ets>ba'al</ets>
lord.]</ety> <sn>1.</sn> <fld>(Myth.)</fld> <def>The supreme male
divinity of the Phoenician and Canaanitish nations.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ The name of this god occurs in the Old Testament and
elsewhere with qualifying epithets subjoined, answering to the different
ideas of his character; as, <xex>Baal</xex>-berith (the Covenant Baal),
<xex>Baal</xex>-zebub (Baal of the fly).</note><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <pluf>pl.</pluf> <def>The whole class of divinities to
whom the name Baal was applied.</def> <rj><au>Judges x. 6.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baalism</ent><br/
<hw>Ba"al*ism</hw> <pr>(-<icr/z'm)</pr>, <pos>n.</pos> <def>Worship of
Baal; idolatry.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baalite</ent><br/
<ent>Baalist</ent><br/
<mhw>{ <hw>Ba"al*ist</hw> <pr>(<?/)</pr>, <hw>Ba"al*ite</hw>
<pr>(<?/)</pr>, }</mhw> <pos>n.</pos> <def>A worshiper of Baal; a
devotee of any false religion; an idolater.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bab</ent><br/
<hw>Bab</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Per.]</ety> <def>Lit.,
gate; -- a title given to the founder of Babism, and taken from that of
<etsep>Bab-ud-Din</etsep>, assumed by him.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Baba</ent><br/
\'d8<hw>Ba"ba</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[F.]</ety> <def>A
kind of plum cake.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>babassu</ent><br/
<hw>babassu</hw> <pos>n.</pos> <sn>1.</sn> <def>a tall feather palm of
northern Brazil (<spn>Orbignya barbosiana</spn>) with hard-shelled nuts
yielding a valuable oil (<prod><col><b>babassu oil</b></col></prod>) and
a kind of vegetable ivory.</def><br/
<syn><b>Syn. --</b> babassu palm, coco de macao, <spn>Orbignya
phalerata</spn>, <spn>Orbignya spesiosa</spn>, <spn>Orbignya
martiana</spn>.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>babbitting</ent><br/
<ent>babbiting</ent><br/
<mhw><hw>babbiting</hw>, <hw>babbitting</hw></mhw> <pos>n.</pos>
<def>lining a surface or bearing with babbitt metal.</def><br/
<syn><b>Syn. --</b> babbitting</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Babbitt</ent><br/
<hw>Bab"bitt</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <def>To line with
Babbitt metal.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Babbitt metal</ent><br/
<hw>Bab"bitt met`al</hw> <pr>(<?/)</pr>. <ety>[From the inventor,
<person>Isaac <etsep>Babbitt</etsep></person> of Massachusetts.]</ety>
<def>A soft white alloy of variable composition (as a nine parts of tin
to one of copper, or of fifty parts of tin to five of antimony and one
of copper) used in bearings to diminish friction.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Babble</ent><br/
<hw>Bab"ble</hw> <pr>(b<acr/b"b'l)</pr>, <pos>v. i.</pos>
<vmorph>[<pos>imp. & p. p.</pos> <conjf>Babbled</conjf>
<pr>(b<acr/b"b'ld)</pr>; <pos>p. pr. & vb. n.</pos>
<conjf>Babbling</conjf>.]</vmorph> <ety>[Cf. LG. <ets>babbeln</ets>, D.
<ets>babbelen</ets>, G. <ets>bappeln</ets>, <ets>bappern</ets>, F.
<ets>babiller</ets>, It. <ets>babbolare</ets>; prob. orig., to keep
saying <ets>ba</ets>, imitative of a child learning to talk.]</ety>
<sn>1.</sn> <def>To utter words indistinctly or unintelligibly; to utter
inarticulate sounds; as a child <xex>babbles</xex>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To talk incoherently; to utter unmeaning
words.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To talk much; to chatter; to prate.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>To make a continuous murmuring noise, as shallow
water running over stones.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>In every <qex>babbling</qex> brook he finds a friend.</q>
<rj><qau>Wordsworth.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ Hounds are said to <xex>babble</xex>, or to be
<xex>babbling</xex>, when they are too noisy after having found a good
scent.</note><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- To prate; prattle; chatter; gossip.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Babble</ent><br/
<hw>Bab"ble</hw>, <pos>v. t.</pos> <sn>1.</sn> <def>To utter in an
indistinct or incoherent way; to repeat, as words, in a childish way
without understanding.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>These [words] he used to <qex>babble</qex> in all companies.</q>
<rj><qau>Arbuthnot.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To disclose by too free talk, as a secret.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Babble</ent><br/
<hw>Bab"ble</hw>, <pos>n.</pos> <sn>1.</sn> <def>Idle talk; senseless
prattle; gabble; twaddle.</def> <ldquo/This is mere moral
<xex>babble</xex>.<rdquo/ <rj><au>Milton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Inarticulate speech; constant or confused
murmur.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The <qex>babble</qex> of our young children.</q>
<rj><qau>Darwin.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The <qex>babble</qex> of the stream.</q>
<rj><qau>Tennyson.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Babblement</ent><br/
<hw>Bab"ble*ment</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>Babble.</def>
<rj><au>Hawthorne.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Babbler</ent><br/
<hw>Bab"bler</hw> <pr>(<?/)</pr>, <pos>n.</pos> <sn>1.</sn> <def>An idle
talker; an irrational prater; a teller of secrets.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Great <qex>babblers</qex>, or talkers, are not fit for trust.</q>
<rj><qau>L'Estrange.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A hound too noisy on finding a good scent.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Zool.)</fld> <def>A name given to any one of a
family (<fam>Timalin<ae/</fam>) of thrushlike birds, having a chattering
note.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Babblery</ent><br/
<hw>Bab"ble*ry</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>Babble.</def>
<mark>[Obs.]</mark> <rj><au>Sir T. More.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Babe</ent><br/
<hw>Babe</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[Cf. Ir.
<ets>bab</ets>, <ets>baban</ets>, W. <ets>baban</ets>,
<ets>maban</ets>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>An infant; a young child of either sex; a
baby.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A doll for children.</def>
<rj><au>Spenser.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Babehood</ent><br/
<hw>Babe"hood</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>Babyhood.</def>
<mark>[R.]</mark> <rj><au>Udall.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Babel</ent><br/
<hw>Ba"bel</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[Heb.
<ets>B<amac/bel</ets>, the name of the capital of Babylonia; in Genesis
associated with the idea of <ldquo/confusion.<rdquo/]</ety> <sn>1.</sn>
<def>The city and tower in the land of Shinar, where the confusion of
languages took place.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Therefore is the name of it called <qex>Babel</qex>.</q>
<rj><qau>Gen. xi. 9.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Hence: A place or scene of noise and confusion; a
confused mixture of sounds, as of voices or languages.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>That <qex>babel</qex> of strange heathen languages.</q>
<rj><qau>Hammond.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The grinding <qex>babel</qex> of the street</q>. <rj><qau>R. L.
Stevenson.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Babery</ent><br/
<hw>Bab"er*y</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[Perh. orig. for
<ets>baboonery</ets>. Cf. <er>Baboon</er>, and also
<er>Babe</er>.]</ety> <def>Finery of a kind to please a child.</def>
<mark>[Obs.]</mark> <ldquo/Painted <xex>babery</xex>.<rdquo/ <rj><au>Sir
P. Sidney.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Babion</ent><br/
<ent>Babian</ent><br/
<mhw>{ <hw>Ba"bi*an</hw> <pr>(<?/)</pr>, <hw>Ba"bi*on</hw> }</mhw>
<pr>(<?/)</pr>, <pos>n.</pos> <ety>[See <er>Baboon</er>.]</ety> <def>A
baboon.</def> <mark>[Obs.]</mark> <rj><au>B. Jonson.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Babillard</ent><br/
\'d8<hw>Bab"il*lard</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[F., a
babbler.]</ety> <fld>(Zool.)</fld> <def>The lesser whitethroat of
Europe; -- called also <altname>babbling warbler</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Babingtonite</ent><br/
<hw>Bab"ing*ton*ite</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[From Dr.
<ets>Babbington</ets>.]</ety> <fld>(Min.)</fld> <def>A mineral occurring
in triclinic crystals approaching pyroxene in angle, and of a greenish
black color. It is a silicate of iron, manganese, and lime.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Babirussa</ent><br/
<ent>Babiroussa</ent><br/
<mhw>{ \'d8<hw>Bab`i*rous"sa</hw>, \'d8<hw>Bab`i*rus"sa</hw>}</mhw>
<pr>(<?/)</pr>, <pos>n.</pos> <ety>[F. <ets>babiroussa</ets>, fr. Malay
<ets>b<amac/b<imac/</ets> hog + <ets>r<umac/sa</ets> deer.]</ety>
<fld>(Zool.)</fld> <def>A large hoglike quadruped (<spn>Sus
babirussa</spn>, <it>syn.</it> <spn>Porcus babirussa</spn>) of the East
Indies, sometimes domesticated; the Indian hog. Its upper canine teeth
or tusks are large and recurved.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Babish</ent><br/
<hw>Bab"ish</hw> <pr>(<?/)</pr>, <pos>a.</pos> <def>Like a babe; a
childish; babyish.</def> <mark>[R.]</mark> <ldquo/<xex>Babish</xex>
imbecility.<rdquo/ <au>Drayton.</au> -- <wordforms><wf>Bab"ish*ly</wf>,
<pos>adv.</pos> -- <wf>Bab"ish*ness</wf>, <pos>n.</pos>
<mark>[R.]</mark></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Babiism</ent><br/
<ent>Babism</ent><br/
<mhw>{ <hw>Bab"ism</hw> <pr>(?)</pr>, <hw>Bab"i*ism</hw> <pr>(?)</pr>
}</mhw>, <pos>n.</pos> <def>The doctrine of a modern religious
pantheistical sect in Persia, which was founded, about 1844, by
<person>Mirza Ali Mohammed ibn Rabhik</person> (1820 -- 1850), who
assumed the title of <person>Bab-ed-Din</person> (Per., Gate of the
Faith). Babism is a mixture of Muslim, Christian, Jewish, and Parsi
elements. This doctrine forbids concubinage and polygamy, and frees
women from many of the degradations imposed upon them among the orthodox
Muslims. Mendicancy, the use of intoxicating liquors and drugs, and
slave dealing, are forbidden; asceticism is discountenanced.</def> --
<wordforms><wf>Bab"ist</wf>, <pos>n.</pos></wordforms><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Babist</ent><br/
<hw>Bab"ist</hw>, <pos>n.</pos> <def>A believer in Babism.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bablah</ent><br/
\'d8<hw>Bab"lah</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[Cf. Per.
<ets>bab<umac/l</ets> a species of mimosa yielding gum arabic.]</ety>
<def>The rind of the fruit of several East Indian species of acacia;
neb-neb. It contains gallic acid and tannin, and is used for dyeing
drab.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Babu</ent><br/
<ent>Baboo</ent><br/
<mhw>{ \'d8<hw>Ba"boo</hw>, \'d8<hw>Ba"bu</hw> }</mhw>
<pr>(b<aum/"b<oomac/)</pr>, <pos>n.</pos> <ety>[Hind.
<ets>b<amac/b<umac/</ets>.]</ety> <def>A Hindu gentleman; a native clerk
who writes English; also, a Hindu title equivalent to the English
<sig>Mr.</sig> or <sig>Esquire</sig>.</def>
<rj><au>Whitworth.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baboon</ent><br/
<hw>Bab*oon"</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[OE.
<ets>babewin</ets>, <ets>baboin</ets>, fr. F. <ets>babouin</ets>, or LL.
<ets>babewynus</ets>. Of unknown origin; cf. D. <ets>baviaan</ets>, G.
<ets>pavian</ets>, baboon, F. <ets>babine</ets> lip of ape, dogs, etc.,
dial. G. <ets>b<aum/ppe</ets> mouth.]</ety> <fld>(Zool.)</fld> <def>One
of the Old World Quadrumana, of the genera <gen>Cynocephalus</gen> and
<gen>Papio</gen>; the dog-faced ape. Baboons have dog-like muzzles and
large canine teeth, cheek pouches, a short tail, and naked callosities
on the buttocks. They are mostly African. See <er>Mandrill</er>, and
<er>Chacma</er>, and <er>Drill</er> an ape.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baboonery</ent><br/
<hw>Bab*oon"ery</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>Baboonish
behavior.</def> <rj><au>Marryat.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baboonish</ent><br/
<hw>Bab*oon"ish</hw>, <pos>a.</pos> <def>Like a baboon.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Babool</ent><br/
<ent>Babul</ent><br/
<mhw>{ <hw>Ba*bul"</hw>, <hw>Ba*bool"</hw> <pr>(?)</pr> }</mhw>,
<pos>n.</pos> <ety>[See <er>Bablah</er>.]</ety> <fld>(Bot.)</fld>
<def>Any one of several species of <gen>Acacia</gen>, esp. <spn>Acacia
Arabica</spn>, which yields a gum used as a substitute for true gum
arabic.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>In place of Putney's golden gorse<br/
The sickly <qex>babul</qex> blooms.</q> <rj><qau>Kipling.</qau></rj><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Baby</ent><br/
<hw>Ba"by</hw> <pr>(b<amac/"b<ycr/)</pr>, <pos>n.</pos>;
<plu><it>pl.</it> <plw>Babies</plw> <pr>(-b<icr/z)</pr>.</plu>
<ety>[Dim. of <ets>babe</ets>.]</ety> <def>An infant or young child of
either sex; a babe.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A small image of an infant; a doll.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Babies in the eyes</b></col>, <cd>the minute reflection
which one sees of one's self in the eyes of another.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><q>She clung about his neck, gave him ten kisses,<br/
Toyed with his locks, looked <qex>babies in his eyes</qex>.</q>
<rj><qau>Heywood.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baby</ent><br/
<hw>Ba"by</hw>, <pos>a.</pos> <def>Pertaining to, or resembling, an
infant; young or little; <as>as, <ex>baby</ex> swans</as>.</def>
<ldquo/<xex>Baby</xex> figure<rdquo/ <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baby</ent><br/
<hw>Ba"by</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos>
<conjf>Babied</conjf> <pr>(b<amac/"b<emac/d)</pr>; <pos>p. pr. & vb.
n.</pos> <conjf>Babying</conjf>.]</vmorph> <def>To treat like a young
child; to keep dependent; to humor; to fondle.</def>
<rj><au>Young.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>baby-blue-eyes</ent><br/
<hw>baby-blue-eyes</hw> <pos>n.</pos> <sn>1.</sn> <def>delicate
California annual having blue flowers marked with dark spots.</def><br/
<syn><b>Syn. --</b> baby blue-eyes, Nemophila menziesii</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>baby-faced</ent><br/
<hw>baby-faced</hw> <pos>adj.</pos> <sn>1.</sn> <def>having a face
resembling that of a baby</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Baby farm</ent><br/
<hw>Ba"by farm`</hw> <pr>(<?/)</pr>. <def>A place where the nourishment
and care of babies are offered for hire.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baby farmer</ent><br/
<hw>Ba"by farm`er</hw> <pr>(<?/)</pr>. <def>One who keeps a baby
farm.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baby farming</ent><br/
<hw>Ba"by farm`ing</hw>. <def>The business of keeping a baby
farm.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Babyhood</ent><br/
<hw>Ba"by*hood</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>The state or
period of infancy.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Babyhouse</ent><br/
<hw>Ba"by*house`</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>A place for
children's dolls and dolls' furniture.</def>
<rj><au>Swift.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Babyish</ent><br/
<hw>Ba"by*ish</hw>, <pos>a.</pos> <def>Like a baby; childish; puerile;
simple.</def> -- <wordforms><wf>Ba"by*ish*ly</wf>, <pos>adv.</pos> --
<wf>Ba"by*ish*ness</wf>, <pos>n.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Babyism</ent><br/
<hw>Ba"by*ism</hw> <pr>(<?/)</pr>, <pos>n.</pos> <sn>1.</sn> <def>The
state of being a baby.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A babyish manner of acting or speaking.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baby jumper</ent><br/
<hw>Ba"by jump`er</hw> <pr>(<?/)</pr>. <def>A hoop suspended by an
elastic strap, in which a young child may be held secure while amusing
itself by jumping on the floor.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Babylonian</ent><br/
<hw>Bab`y*lo"ni*an</hw> <pr>(<?/)</pr>, <pos>a.</pos> <def>Of or
pertaining to the real or to the mystical Babylon, or to the ancient
kingdom of Babylonia; Chaldean.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Babylonian</ent><br/
<hw>Bab`y*lo"ni*an</hw>, <pos>prop. n.</pos> <sn>1.</sn> <def>An
inhabitant of Babylonia (which included Chaldea); a Chaldean.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>An astrologer; -- so called because the Chaldeans
were remarkable for the study of astrology.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Babylonical</ent><br/
<ent>Babylonic</ent><br/
<mhw>{ <hw>Bab`y*lon"ic</hw> <pr>(<?/)</pr>, <hw>Bab`y*lon"ic*al</hw>
<pr>(<?/)</pr>, }</mhw> <pos>a.</pos> <sn>1.</sn> <def>Pertaining to
Babylon, or made there; <as>as, <ex>Babylonic</ex> garments, carpets, or
hangings</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Tumultuous; disorderly.</def> <mark>[Obs.]</mark>
<rj><au>Sir J. Harrington.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Babylonish</ent><br/
<hw>Bab"y*lo`nish</hw> <pr>(<?/)</pr>, <pos>a.</pos> <sn>1.</sn> <def>Of
or pertaining to, or made in, Babylon or Babylonia.</def> <ldquo/A
<xex>Babylonish</xex> garment.<rdquo/ <rj><au>Josh. vii.
21.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Pertaining to the Babylon of <au>Revelation xiv.
8.</au></def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Pertaining to Rome and papal power.</def>
<mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>The . . . injurious nickname of <qex>Babylonish</qex>.</q>
<rj><qau>Gage.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>Confused; Babel-like.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Babyrussa</ent><br/
<ent>Babyroussa</ent><br/
<mhw>{ \'d8<hw>Bab`y*rous"sa</hw>, \'d8<hw>Bab`y*rus"sa</hw> }</mhw>
<pr>(<?/)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <def>See
<er>Babiroussa</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Babyship</ent><br/
<hw>Ba"by*ship</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>The quality of
being a baby; the personality of an infant.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>baby-sit</ent><br/
<hw>baby-sit</hw> <pos>v.</pos> <def>act as a baby-sitter</def><br/
<syn><b>Syn. --</b> babysit, sit</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>baby-sitter</ent><br/
<ent>babysitter</ent><br/
<mhw><hw>babysitter</hw>, <hw>baby-sitter</hw></mhw> <pos>n.</pos>
<def>A person engaged to care for children when the parents are not
home.</def><br/
<syn><b>Syn. --</b> sitter</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>babysitting</ent><br/
<hw>babysitting</hw> <pos>n.</pos> <def>the work of a baby sitter;
caring for children when their parents are not home.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>baby-walker</ent><br/
<hw>baby-walker</hw> <pos>n.</pos> <def>a framework on small wheels or
casters designed to support small children while they are learning to
walk, and usually having a fabric support that permits the child to sit.
Called also <altname>walker</altname> and
<altname>go-cart</altname>.</def><br/
<syn><b>Syn. --</b> walker, go-cart</syn><br/
[<source>WordNet 1.5</source> <source>+PJC</source>]</p>

<p><ent>Bac</ent><br/
<hw>Bac</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[F. See <er>Back</er> a
vat.]</ety> <sn>1.</sn> <def>A broad, flat-bottomed ferryboat, usually
worked by a rope.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A vat or cistern. See 1st <er>Back</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>bacca</ent><br/
<hw>bac"ca</hw> <pos>n.</pos> <sn>1.</sn> <def>an indehiscent fruit
derived from a single ovary having one or many seeds within a fleshy
wall or pericarp: e. g. grape; tomato; cranberry.</def><br/
<syn><b>Syn. --</b> simple fruit</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Baccalaureate</ent><br/
<hw>Bac"ca*lau"re*ate</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[NL.
<ets>baccalaureatus</ets>, fr. LL. <ets>baccalaureus</ets> a bachelor of
arts, fr. <ets>baccalarius</ets>, but as if fr. L. <ets>bacca
lauri</ets> bayberry, from the practice of the bachelor's wearing a
garland of bayberries. See <er>Bachelor</er>.]</ety> <sn>1.</sn>
<def>The degree of bachelor of arts (B.A. or A.B.), the first or lowest
academical degree conferred by universities and colleges.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A baccalaureate sermon.</def>
<mark>[U.S.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baccalaureate</ent><br/
<hw>Bac`ca*lau"re*ate</hw>, <pos>a.</pos> <def>Pertaining to a bachelor
of arts.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Baccalaureate sermon</b></col>, <cd>in some American
colleges, a sermon delivered as a farewell discourse to a graduating
class.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baccarat</ent><br/
<ent>Baccara</ent><br/
<mhw>{ \'d8<hw>Bac`ca*ra"</hw>, <hw>Bac`ca*rat"</hw> }</mhw>
<pr>(<?/)</pr>, <pos>n.</pos> <ety>[F.]</ety> <def>A French game of
cards, played by a banker and punters.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Backare</ent><br/
<ent>Baccare</ent><br/
<mhw>{ <hw>Bac*ca"re</hw>, <hw>Bac*ka"re</hw> }</mhw> <pr>(<?/)</pr>,
<pos>interj.</pos> <def>Stand back! give place! -- a cant word of the
Elizabethan writers, probably in ridicule of some person who pretended
to a knowledge of Latin which he did not possess.</def><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>Baccare</qex>! you are marvelous forward.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baccate</ent><br/
<hw>Bac"cate</hw> <pr>(<?/)</pr>, <pos>a.</pos> <ety>[L.
<ets>baccatus</ets>, fr. L. <ets>bacca</ets> berry.]</ety>
<fld>(Bot.)</fld> <def>Pulpy throughout, like a berry; -- said of
fruits.</def> <rj><au>Gray.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baccated</ent><br/
<hw>Bac"ca*ted</hw> <pr>(<?/)</pr>, <pos>a.</pos> <sn>1.</sn>
<def>Having many berries.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Set or adorned with pearls.</def>
<mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bacchanal</ent><br/
<hw>Bac"cha*nal</hw> <pr>(<?/)</pr>, <pos>a.</pos> <ety>[L.
<ets>Bacchanalis</ets>. See <er>Bacchanalia</er>.]</ety> <sn>1.</sn>
<def>Relating to Bacchus or his festival.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Engaged in drunken revels; drunken and riotous or
noisy.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bacchanal</ent><br/
<hw>Bac"cha*nal</hw> <pr>(b<acr/k"k<adot/*n<ait/l)</pr>, <pos>n.</pos>
<sn>1.</sn> <def>A devotee of Bacchus; one who indulges in drunken
revels; one who is noisy and riotous when intoxicated; a carouser.</def>
<ldquo/Tipsy <xex>bacchanals</xex>.<rdquo/ <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <pluf>pl.</pluf> <def>The festival of Bacchus; the
bacchanalia.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Drunken revelry; an orgy.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>A song or a dance in honor of
<persfn>Bacchus</persfn>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bacchanalia</ent><br/
\'d8<hw>Bac`cha*na"li*a</hw>
<pr>(b<acr/k`k<adot/*n<amac/"l<icr/*<adot/)</pr>, <pos>n. pl.</pos>
<ety>[L. <ets>Bacchanal</ets> a place devoted to Bacchus; in the pl.
<ets>Bacchanalia</ets> a feast of Bacchus, fr. <ets>Bacchus</ets> the
god of wine, Gr. <grk>Ba`kchos</grk>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <fld>(Myth.)</fld> <def>A feast or an orgy in honor of
Bacchus.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Hence: A drunken feast; drunken revels; an
orgy.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bacchanalian</ent><br/
<hw>Bac`cha*na"li*an</hw> <pr>(b<acr/k`k<adot/*n<amac/"l<icr/*<ait/n;
106)</pr>, <pos>a.</pos> <def>Of or pertaining to the festival of
Bacchus; relating to or given to reveling and drunkenness.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Even <qex>bacchanalian</qex> madness has its charms.</q>
<rj><qau>Cowper.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bacchanalian</ent><br/
<hw>Bac`cha*na"li*an</hw>, <pos>n.</pos> <def>A bacchanal; a drunken
reveler.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bacchanalianism</ent><br/
<hw>Bac`cha*na"li*an*ism</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>The
practice of bacchanalians; bacchanals; drunken revelry.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bacchant</ent><br/
<hw>Bac"chant</hw> <pr>(<?/)</pr>, <pos>n.</pos>; <plu><it>pl.</it> E.
<plw>Bacchants</plw>, L. <plw>Bacchantes</plw>.</plu> <ety>[L.
<ets>bacchans</ets>, <ets>-antis</ets>, p. pr. of <ets>bacchari</ets> to
celebrate the festival of Bacchus.]</ety> <sn>1.</sn> <def>A priest of
Bacchus.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A bacchanal; a reveler.</def>
<rj><au>Croly.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bacchant</ent><br/
<hw>Bac"chant</hw>, <pos>a.</pos> <def>Bacchanalian; fond of drunken
revelry; wine-loving; reveling; carousing.</def>
<rj><au>Byron.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bacchante</ent><br/
<hw>Bac"chante</hw> <pr>(<?/)</pr>, <pos>n.</pos>; <plu>L. pl.
<plw>Bacchantes</plw>.</plu> <sn>1.</sn> <def>A priestess of
Bacchus.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A female bacchanal.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bacchantic</ent><br/
<hw>Bac*chan"tic</hw> <pr>(<?/)</pr>, <pos>a.</pos>
<def>Bacchanalian.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bacchical</ent><br/
<ent>Bacchic</ent><br/
<mhw>{ <hw>Bac"chic</hw> <pr>(<?/)</pr>, <hw>Bac"chic*al</hw>
<pr>(<?/)</pr> }</mhw>, <pos>a.</pos> <ety>[L. <ets>Bacchicus</ets>, Gr.
<grk>Bakchiko`s</grk>.]</ety> <def>Of or relating to Bacchus; hence,
jovial, or riotous, with intoxication; riotously drunken; -- used of
revelrous gatherings.</def><br/
<syn><b>Syn. --</b> bacchanalian, bacchanal, bibulous, carousing,
drunken(prenominal), orgiastic, riotous</syn><br/
[<source>1913 Webster</source> + <source>WordNet 1.5</source>]</p>

<p><ent>Bacchius</ent><br/
\'d8<hw>Bac*chi"us</hw> <pr>(<?/)</pr>, <pos>n.</pos>; <plu><it>pl.</it>
<plw>Bacchii</plw> <pr>(<?/)</pr>.</plu> <ety>[L. <ets>Bacchius</ets>
pes, Gr. <grk>"o Bakchei^os</grk> (sc. <grk>poy`s</grk> foot).]</ety>
<fld>(Pros.)</fld> <def>A metrical foot composed of a short syllable and
two long ones; according to some, two long and a short.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bacchus</ent><br/
<hw>Bac"chus</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[L., fr. Gr.
<grk>Ba`kchos</grk>.]</ety> <fld>(Myth.)</fld> <def>The god of wine, son
of <persfn>Jupiter</persfn> and <persfn>Semele</persfn>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bacciferous</ent><br/
<hw>Bac*cif"er*ous</hw> <pr>(<?/)</pr>, <pos>a.</pos> <ety>[L.
<ets>baccifer</ets>; <ets>bacca</ets> berry + <ets>ferre</ets> to
bear.]</ety> <def>Producing berries.</def> <ldquo/
<xex>Bacciferous</xex> trees.<rdquo/ <rj><au>Ray.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bacciform</ent><br/
<hw>Bac"ci*form</hw> <pr>(<?/)</pr>, <pos>a.</pos> <ety>[L.
<ets>bacca</ets> berry + <ets>-form</ets>.]</ety> <def>Having the form
of a berry.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baccivorous</ent><br/
<hw>Bac*civ"o*rous</hw> <pr>(<?/)</pr>, <pos>a.</pos> <ety>[L.
<ets>bacca</ets> berry + <ets>vorare</ets> to devour.]</ety>
<fld>(Zool.)</fld> <def>Eating, or subsisting on, berries; <as>as,
<ex>baccivorous</ex> birds</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bace</ent><br/
<hw>Bace</hw> <pr>(<?/)</pr>, <pos>n., a., & v.</pos> <def>See
<er>Base</er>.</def> <mark>[Obs.]</mark> <rj><au>Spenser.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Backarack</ent><br/
<ent>Bacharach</ent><br/
<mhw>{<hw>Bach"a*rach</hw>, <hw>Back"a*rack</hw> }</mhw> <pr>(<?/)</pr>,
<pos>n.</pos> <def>A kind of wine made at <etsep>Bacharach</etsep> on
the Rhine.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bachelor</ent><br/
<hw>Bach"e*lor</hw> <pr>(b<acr/ch"<esl/*l<etil/r)</pr>, <pos>n.</pos>
<ety>[OF. <ets>bacheler</ets> young man, F. <ets>bachelier</ets> (cf.
Pr. <ets>bacalar</ets>, Sp. <ets>bachiller</ets>, Pg.
<ets>bacharel</ets>, It. <ets>baccalare</ets>), LL.
<ets>baccalarius</ets> the tenant of a kind of farm called
<ets>baccalaria</ets>, a soldier not old or rich enough to lead his
retainers into battle with a banner, a person of an inferior academical
degree aspiring to a doctorate. In the latter sense, it was afterward
changed to baccalaureus. See <er>Baccalaureate</er>,
<pos>n.</pos>]</ety> <sn>1.</sn> <def>A man of any age who has not been
married.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>As merry and mellow an old <qex>bachelor</qex> as ever followed a
hound.</q> <rj><qau>W. Irving.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>An unmarried woman.</def> <mark>[Obs.]</mark>
<rj><au>B. Jonson.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 110 pr=SA --></p>

<p><sn>3.</sn> <def>A person who has taken the first or lowest degree in
the liberal arts, or in some branch of science, at a college or
university; <as>as, a <ex>bachelor</ex> of arts</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>A knight who had no standard of his own, but fought
under the standard of another in the field; often, a young
knight.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>In the companies of London tradesmen, one not yet
admitted to wear the livery; a junior member.</def>
<mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <fld>(Zool.)</fld> <def>A kind of bass, an edible
fresh-water fish (<spn>Pomoxys annularis</spn>) of the southern United
States.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>bachelor-at-arms</ent><br/
<hw>bachelor-at-arms</hw> <pos>n.</pos> <def>a knight of the lowest
order; he was permitted to display only a pennon.</def><br/
<syn><b>Syn. --</b> knight bachelor, bachelor</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Bachelordom</ent><br/
<hw>Bach"e*lor*dom</hw> <pr>(b<acr/ch"<esl/*l<etil/r*d<ucr/m)</pr>,
<pos>n.</pos> <def>The state of bachelorhood; the whole body of
bachelors.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bachelorhood</ent><br/
<hw>Bach"e*lor*hood</hw> <pr>(-h<oocr/d)</pr>, <pos>n.</pos> <def>The
state or condition of being a bachelor; bachelorship.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bachelorism</ent><br/
<hw>Bach"e*lor*ism</hw> <pr>(-<icr/z'm)</pr>, <pos>n.</pos>
<def>Bachelorhood; also, a manner or peculiarity belonging to
bachelors.</def> <rj><au>W. Irving.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bachelor's button</ent><br/
<hw>Bach"e*lor's but"ton</hw> <pr>(<?/)</pr>, <fld>(Bot.)</fld> <def>A
plant with flowers shaped like buttons; especially, several species of
<gen>Ranunculus</gen>, and the cornflower (<spn>Centaurea cyanus</spn>)
and globe amaranth (<gen>Gomphrena</gen>).</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ <ex>Bachelor's buttons</ex>, a name given to several
flowers <ldquo/from their similitude to the jagged cloathe buttons,
anciently worne in this kingdom,<rdquo/ according to Johnson's
<au>Gerarde, p. 472 (1633)</au>; but by other writers ascribed to
<ldquo/a habit of country fellows to carry them in their pockets to
divine their success with their sweethearts.<rdquo/ <rj><au>Dr.
Prior.</au></rj> </note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bachelorship</ent><br/
<hw>Bach"e*lor*ship</hw>, <pos>n.</pos> <def>The state of being a
bachelor.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bachelry</ent><br/
<hw>Bach"el*ry</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[OF.
<ets>bachelerie</ets>.]</ety> <def>The body of young aspirants for
knighthood.</def> <mark>[Obs.]</mark> <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bacillar</ent><br/
<hw>Ba*cil"lar</hw> <pr>(<?/)</pr>, <pos>a.</pos> <ety>[L.
<ets>bacillum</ets> little staff.]</ety> <fld>(Biol.)</fld> <sn>1.</sn>
<def>Shaped like a rod or staff.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Biol.)</fld> <def>Pertaining to, or produced by,
the organism bacillus; bacillary.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Bacillariae</ent><br/
\'d8<hw>Bac"il*la`ri*<ae/</hw> <pr>(<?/)</pr>, <pos>n. pl.</pos>
<ety>[NL., fr. L. <ets>bacillum</ets>, dim. of <ets>baculum</ets>
stick.]</ety> <fld>(Biol.)</fld> <def>See <er>Diatom</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bacillary</ent><br/
<hw>Bac"il*la*ry</hw> <pr>(<?/)</pr>, <pos>a.</pos> <sn>1.</sn> <def>Of
or pertaining to little rods; rod-shaped.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Biol.)</fld> <def>Of or pertaining to bacilli;
produced by, or containing, bacilli; bacillar; <as>as, a
<ex>bacillary</ex> disease</as>.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>bacilli</ent><br/
<hw>bacilli</hw> <pos>n.</pos> <def>plural of <er>bacillus</er>; usually
designating aerobic rod-shaped spore-producing bacteria; they often
occur in chainlike formations.</def><br/
<syn><b>Syn. --</b> bacillus</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Bacilliform</ent><br/
<hw>Ba*cil"li*form</hw> <pr>(<?/)</pr>, <pos>a.</pos> <ety>[L.
<ets>bacillum</ets> little staff + <ets>-form</ets>.]</ety>
<def>Rod-shaped.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bacillus</ent><br/
<hw>Ba*cil"lus</hw> <pr>(<?/)</pr>, <pos>n.</pos>; <plu><it>pl.</it>
<plw>Bacilli</plw> <pr>(<?/)</pr>.</plu> <ety>[NL., for L.
<xex>bacillum</xex>. See <er>Bacillari<ae/</er>.]</ety>
<fld>(Biol.)</fld> <def>A variety of bacterium; a microscopic,
rod-shaped vegetable organism.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>bacitracin</ent><br/
<hw>bacitracin</hw> <pos>n.</pos> <fu>(1940)</fu>
<ety>[<ets>Baci</ets>llus + Margaret <ets>Trac</ets>y, (a child whose
tissues contained <spn>Bacillus subtilis</spn>) + <ets>-in</ets>.
<au>RHUD.</au>]</ety> <def>a polypeptide antibacterial antibiotic of
known chemical structure effective against several types of
Gram-positive organisms, and usually used topically for superficial
local infection.</def> <note>It is produced by <spn>Bacillus
subtilis</spn> and <spn>Bacillus licheniformis</spn>, and as produced
commercially is composed of several closely related substances. The
predominant component, <stype>Bacitracin A</stype>, has a formula
<chform>C60H103N17O16S</chform>, and contains D-ornithine,
D-phenylalanine and D-glutamine residues as well as the L-isomers of
leucine, isoleucine, histidine, asparagine and aspartic acid.</note>
<au>[MI11]</au><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Back</ent><br/
<hw>Back</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[F. <ets>bac</ets>: cf.
Arm. <ets>bag</ets>, <ets>bak</ets> a bark, D. <ets>bak</ets> tray,
bowl.]</ety> <sn>1.</sn> <def>A large shallow vat; a cistern, tub, or
trough, used by brewers, distillers, dyers, picklers, gluemakers, and
others, for mixing or cooling wort, holding water, hot glue,
etc.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><mcol><col><b>Hop back</b></col>, <col><b>Jack
back</b></col></mcol>, <cd>the cistern which receives the infusion of
malt and hops from the copper.</cd> -- <col><b>Wash back</b></col>,
<cd>a vat in which distillers ferment the wort to form wash.</cd> --
<col><b>Water back</b></col>, <cd>a cistern to hold a supply of water;
esp. a small cistern at the back of a stove, or a group of pipes set in
the fire box of a stove or furnace, through which water circulates and
is heated.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A ferryboat. See <er>Bac</er>, 1.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Back</ent><br/
<hw>Back</hw> <pr>(b<acr/k)</pr>, <pos>n.</pos> <ety>[AS.
<ets>b<ae/c</ets>, <ets>bac</ets>; akin to Icel., Sw., & LG.
<ets>bak</ets>, Dan. <ets>bag</ets>; cf. OHG. <ets>bahho</ets> ham, Skr.
<ets>bhaj</ets> to turn, OSlav. <ets>b<emac/g<ucr/</ets> flight. Cf.
<er>Bacon</er>.]</ety> <sn>1.</sn> <def>In human beings, the hinder part
of the body, extending from the neck to the end of the spine; in other
animals, that part of the body which corresponds most nearly to such
part of a human being; <as>as, the <ex>back</ex> of a horse, fish, or
lobster</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>An extended upper part, as of a mountain or
ridge.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>[The mountains] their broad bare <qex>backs</qex> upheave<br/
Into the clouds.</q> <rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>The outward or upper part of a thing, as opposed to
the inner or lower part; <as>as, the <ex>back</ex> of the hand, the
<ex>back</ex> of the foot, the <ex>back</ex> of a hand
rail</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Methought Love pitying me, when he saw this,<br/
Gave me your hands, the <qex>backs</qex> and palms to kiss.</q>
<rj><qau>Donne.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>The part opposed to the front; the hinder or rear
part of a thing; <as>as, the <ex>back</ex> of a book; the <ex>back</ex>
of an army; the <ex>back</ex> of a chimney</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>The part opposite to, or most remote from, that
which fronts the speaker or actor; or the part out of sight, or not
generally seen; <as>as, the <ex>back</ex> of an island, of a hill, or of
a village</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <def>The part of a cutting tool on the opposite side from
its edge; <as>as, the <ex>back</ex> of a knife, or of a
saw</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>7.</sn> <def>A support or resource in reserve.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>This project<br/
Should have a <qex>back</qex> or second, that might hold,<br/
If this should blast in proof.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>8.</sn> <fld>(Naut.)</fld> <def>The keel and keelson of a
ship.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>9.</sn> <fld>(Mining)</fld> <def>The upper part of a lode, or the
roof of a horizontal underground passage.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>10.</sn> <def>A garment for the back; hence, clothing.</def>
<mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>A <qex>bak</qex> to walken inne by daylight.</q>
<rj><qau>Chaucer.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Behind one's back</b></col>, <cd>when one is absent;
without one's knowledge; <as>as, to ridicule a person <ex>behind his
back</ex></as>.</cd> -- <mcol><col><b>Full back</b></col>, <col><b>Half
back</b></col>, <col><b>Quarter back</b></col></mcol>
<fld>(Football)</fld>, <cd>players stationed behind those in the front
line.</cd> -- <mcol><col><b>To be on one's back</b></col> <it>or</it>
<col><b>To lie on one's back</b></col></mcol>, <cd>to be helpless.</cd>
-- <mcol><col><b>To put one's back up</b></col> <it>or</it> <col><b>to
get one's back up</b></col></mcol>, <cd>to assume an attitude of
obstinate resistance (from the action of a cat when attacked).</cd>
<mark>[Colloq.]</mark> -- <col><b>To see the back of</b></col>, <cd>to
get rid of.</cd> -- <col><b>To turn the back</b></col>, <cd>to go away;
to flee.</cd> -- <col><b>To turn the back on one</b></col>, <cd>to
forsake or neglect him.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Back</ent><br/
<hw>Back</hw>, <pos>a.</pos> <sn>1.</sn> <def>Being at the back or in
the rear; distant; remote; <as>as, the <ex>back</ex> door; <ex>back</ex>
settlements</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Being in arrear; overdue; <as>as, <ex>back</ex>
rent</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Moving or operating backward; <as>as, <ex>back</ex>
action</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Back blocks</b></col>, <cd>Australian pastoral country
which is remote from the seacoast or from a river.</cd> [<source>Webster
1913 Suppl.</source>] -- <col><b>Back charges</b></col>, <cd>charges
brought forward after an account has been made up.</cd> -- <col><b>Back
filling</b></col> <fld>(Arch.)</fld>, <cd>the mass of materials used in
filling up the space between two walls, or between the inner and outer
faces of a wall, or upon the haunches of an arch or vault.</cd> --
<col><b>Back pressure</b></col>. <fld>(Steam Engine)</fld> <cd>See under
<er>Pressure</er>.</cd> -- <col><b>Back rest</b></col>, <cd>a guide
attached to the slide rest of a lathe, and placed in contact with the
work, to steady it in turning.</cd> -- <col><b>Back slang</b></col>,
<cd>a kind of slang in which every word is written or pronounced
backwards; as, <xex>nam</xex> for <xex>man</xex>.</cd> -- <col><b>Back
stairs</b></col>, <cd>stairs in the back part of a house; private
stairs. Also used adjectively. See <er>Back stairs</er>,
<er>Backstairs</er>, and <er>Backstair</er>, in the Vocabulary.</cd> --
<col><b>Back step</b></col> <fld>(Mil.)</fld>, <cd>the retrograde
movement of a man or body of men, without changing front.</cd> --
<col><b>Back stream</b></col>, <cd>a current running against the main
current of a stream; an eddy.</cd> -- <col><b>To take the back
track</b></col>, <cd>to retrace one's steps; to retreat.</cd>
<mark>[Colloq.]</mark></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Back</ent><br/
<hw>Back</hw> <pr>(b<acr/k)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. &
p. p.</pos> <conjf>Backed</conjf> <pr>(b<acr/kt)</pr>; <pos>p. pr. & vb.
n.</pos> <conjf>Backing</conjf>.]</vmorph><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>To get upon the back of; to mount.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>I will <qex>back</qex> him [a horse] straight.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To place or seat upon the back.</def>
<mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>Great Jupiter, upon his eagle <qex>backed</qex>,<br/
Appeared to me.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To drive or force backward; to cause to retreat or
recede; <as>as, to <ex>back</ex> oxen</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>To make a back for; to furnish with a back; <as>as,
to <ex>back</ex> books</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>To adjoin behind; to be at the back of.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>A garden . . . with a vineyard <qex>backed</qex>.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The chalk cliffs which <qex>back</qex> the beach.</q>
<rj><qau>Huxley.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <def>To write upon the back of; <as>as, to <ex>back</ex>
a letter</as>; to indorse; <as>as, to <ex>back</ex> a note or legal
document</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>7.</sn> <def>To support; to maintain; to second or strengthen by
aid or influence; <as>as, to <ex>back</ex> a friend</as>.</def>
<ldquo/The Parliament would be <xex>backed</xex> by the people.<rdquo/
<rj><au>Macaulay.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Have still found it necessary to <qex>back</qex> and fortify their
laws with rewards and punishments.</q> <rj><qau>South.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The mate <qex>backed</qex> the captain manfully.</q>
<rj><qau>Blackw. Mag.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>8.</sn> <def>To bet on the success of; -- as, to <xex>back</xex>
a race horse.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>To back an anchor</b></col> <fld>(Naut.)</fld>, <cd>to
lay down a small anchor ahead of a large one, the cable of the small one
being fastened to the crown of the large one.</cd> -- <col><b>To back
the field</b></col>, <cd>in horse racing, to bet against a particular
horse or horses, that some one of all the other horses, collectively
designated <ldquo/the field<rdquo/, will win.</cd> -- <col><b>To back
the oars</b></col>, <cd>to row backward with the oars.</cd> --
<col><b>To back a rope</b></col>, <cd>to put on a preventer.</cd> --
<col><b>To back the sails</b></col>, <cd>to arrange them so as to cause
the ship to move astern.</cd> -- <col><b>To back up</b></col>, <cd>to
support; to sustain; <as>as, to <ex>back up</ex> one's
friends</as>.</cd> -- <col><b>To back a warrant</b></col>
<fld>(Law)</fld>, <cd>is for a justice of the peace, in the county where
the warrant is to be executed, to sign or indorse a warrant, issued in
another county, to apprehend an offender.</cd> -- <col><b>To back
water</b></col> <fld>(Naut.)</fld>, <cd>to reverse the action of the
oars, paddles, or propeller, so as to force the boat or ship
backward.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Back</ent><br/
<hw>Back</hw>, <pos>v. i.</pos> <sn>1.</sn> <def>To move or go backward;
<as>as, the horse refuses to <ex>back</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Naut.)</fld> <def>To change from one quarter to
another by a course opposite to that of the sun; -- used of the
wind.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Sporting)</fld> <def>To stand still behind another
dog which has pointed; -- said of a dog.</def> <mark>[Eng.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>To back and fill</b></col>, <cd>to manage the sails of a
ship so that the wind strikes them alternately in front and behind, in
order to keep the ship in the middle of a river or channel while the
current or tide carries the vessel against the wind.</cd> Hence:
(<mark>Fig.</mark>) <cd>To take opposite positions alternately; to
assert and deny.</cd> <mark>[Colloq.]</mark> -- <mcol><col><b>To back
out</b></col>, <col><b>To back down</b></col></mcol>, <cd>to retreat or
withdraw from a promise, engagement, or contest; to recede.</cd>
<mark>[Colloq.]</mark></cs><br/
[<source>1913 Webster</source>]</p>

<p><q>Cleon at first . . . was willing to go; but, finding that he
[Nicias] was in earnest, he tried to <qex>back out</qex>.</q>
<rj><qau>Jowett (Thucyd. )</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Back</ent><br/
<hw>Back</hw>, <pos>adv.</pos> <ety>[Shortened from
<ets>aback</ets>.]</ety> <sn>1.</sn> <def>In, to, or toward, the rear;
<as>as, to stand <ex>back</ex>; to step <ex>back</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To the place from which one came; to the place or
person from which something is taken or derived; <as>as, to go
<ex>back</ex> for something left behind; to go <ex>back</ex> to one's
native place; to put a book <ex>back</ex> after reading
it</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To a former state, condition, or station; <as>as, to
go <ex>back</ex> to private life; to go <ex>back</ex> to
barbarism</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>(Of time) In times past; ago.</def> <ldquo/Sixty or
seventy years <xex>back</xex>.<rdquo/ <rj><au>Gladstone.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>Away from contact; by reverse movement.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The angel of the Lord . . . came, and rolled <qex>back</qex> the
stone from the door.</q> <rj><qau>Matt. xxviii. 2.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <def>In concealment or reserve; in one's own possession;
<as>as, to keep <ex>back</ex> the truth; to keep <ex>back</ex> part of
the money due to another</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>7.</sn> <def>In a state of restraint or hindrance.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The Lord hath kept thee <qex>back</qex> from honor.</q>
<rj><qau>Numb. xxiv. 11.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>8.</sn> <def>In return, repayment, or requital.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>What have I to give you <qex>back</qex>?</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>9.</sn> <def>In withdrawal from a statement, promise, or
undertaking; <as>as, he took <ex>back</ex> the offensive
words</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>10.</sn> <def>In arrear; <as>as, to be <ex>back</ex> in one's
rent</as>.</def> <mark>[Colloq.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Back and forth</b></col>, <cd>backwards and forwards; to
and fro.</cd> -- <col><b>To go back on</b></col>, <cd>to turn back from;
to abandon; to betray; <as>as, <ex>to go back on</ex> a friend; <ex>to
go back on</ex> one's professions</as>.</cd>
<mark>[Colloq.]</mark></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>backache</ent><br/
<hw>back"ache</hw> <pos>n.</pos> <def>an ache localized in the
back.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>back-and-forth</ent><br/
<hw>back"-and-forth`</hw> <pos>n.</pos> <def>a discussion;
give-and-take.</def><br/
[<source>PJC</source>]</p>

<p><ent>Backarack</ent><br/
<hw>Back"a*rack</hw> <pr>(b<acr/k"<adot/*r<acr/k)</pr>, <pos>n.</pos>
<def>See <er>Bacharach</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Backare</ent><br/
<hw>Bac*ka"re</hw> <pr>(<?/)</pr>, <pos>interj.</pos> <def>Same as
<er>Baccare</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Backband</ent><br/
<hw>Back"band`</hw> <pr>(b<acr/k"b<acr/nd)</pr>, <pos>n.</pos> <ety>[2nd
<ets>back</ets>, n. + <ets>band</ets>.]</ety> <fld>(Saddlery)</fld>
<def>The band which passes over the back of a horse and holds up the
shafts of a carriage.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>backbench</ent><br/
<hw>back"bench</hw> <pr>(b<acr/k"b<ecr/nch)</pr>, <pos>n.</pos>
<sn>1.</sn> <def>any of the seats occupied by backbenchers in the House
of Commons of Great Britain.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>backbencher</ent><br/
<hw>backbencher</hw> <pr>(b<acr/k"b<ecr/nch*<etil/r)</pr>, <pos>n.</pos>
<def>a member of the House of Commons of Great Britain who is not a
party leader.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>backbend</ent><br/
<hw>back"bend</hw> <pr>(b<acr/k"b<ecr/nd)</pr>, <pos>n.</pos>
<sn>1.</sn> <def>an acrobatic feat in which the trunk is bent backward
from a standing position until the hands touch the floor.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Backbite</ent><br/
<hw>Back"bite`</hw>, <pos>v. t.</pos> <ety>[2d <ets>back</ets>, n. +
<ets>bite</ets>.]</ety> <def>To wound by clandestine detraction; to
censure meanly or spitefully (an absent person); to slander or speak
evil of (one absent).</def> <rj><au>Spenser.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Backbite</ent><br/
<hw>Back"bite`</hw>, <pos>v. i.</pos> <def>To censure or revile the
absent.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>They are arrant knaves, and will <qex>backbite</qex>.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Backbiter</ent><br/
<hw>Back"bit`er</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>One who
backbites; a secret calumniator or detractor.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Backbiting</ent><br/
<hw>Back"bit`ing</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>Secret slander;
detraction.</def><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>Backbiting</qex>, and bearing of false witness.</q>
<rj><qau>Piers Plowman.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Backboard</ent><br/
<hw>Back"board`</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[2d
<ets>back</ets>, n. + <ets>board</ets>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>A board which supports the back when one is
sitting;</def> <specif>specifically,</specif> <def>the board athwart the
after part of a boat.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A board serving as the back part of anything, as of
a wagon.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>A thin stuff used for the backs of framed pictures,
mirrors, etc.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>A board attached to the rim of a water wheel to
prevent the water from running off the floats or paddles into the
interior of the wheel.</def> <rj><au>W. Nicholson.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>A board worn across the back to give erectness to
the figure.</def> <rj><au>Thackeray.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Backbond</ent><br/
<hw>Back"bond`</hw> <pr>(b<acr/k"b<ocr/nd`)</pr>, <pos>n.</pos>
<ety>[<ets>Back</ets>, adv. + <ets>bond</ets>.]</ety> <fld>(Scots
Law)</fld> <def>An instrument which, in conjunction with another making
an absolute disposition, constitutes a trust.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Backbone</ent><br/
<hw>Back"bone"</hw> <pr>(b<acr/k"b<omac/n`)</pr>, <pos>n.</pos> <ety>[2d
<ets>back</ets>, n. + <ets>bone</ets>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>The column of bones in the back which sustains and
gives firmness to the frame; the spine; the vertebral or spinal
column.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Anything like , or serving the purpose of, a
backbone.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The lofty mountains on the north side compose the granitic axis,
or <qex>backbone</qex> of the country.</q>
<rj><qau>Darwin.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>We have now come to the <qex>backbone</qex> of our subject.</q>
<rj><qau>Earle.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Firmness; moral principle; steadfastness.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Shelley's thought never had any <qex>backbone</qex>.</q>
<rj><qau>Shairp.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>To the backbone</b></col>, <cd>through and through;
thoroughly; entirely.</cd> <ldquo/Staunch <xex>to the
backbone</xex>.<rdquo/ <rj><au>Lord Lytton.</au></rj></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Backboned</ent><br/
<hw>Back"boned"</hw> <pr>(<?/)</pr>, <pos>a.</pos>
<def>Vertebrate.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Backcast</ent><br/
<hw>Back"cast`</hw> <pr>(b<acr/k"k<adot/st`)</pr>, <pos>n.</pos>
<ety>[<ets>Back</ets>, adv. + <ets>cast</ets>.]</ety> <def>Anything
which brings misfortune upon one, or causes failure in an effort or
enterprise; a reverse.</def> <mark>[Scot.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>backdate</ent><br/
<hw>back"date</hw> <pos>v. t.</pos> <sn>1.</sn> <def>to make effective
from an earlier date; to make retroactive.</def> <illu>The increase in
tax was <ex>backdated</ex> to January.</illu><br/
<syn><b>Syn. --</b> back-date</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><sn>2.</sn> <def>to affix a date earlier than the present date; --
sometimes done for fraudulent purposes. Opposite of
<ant>postdate</ant>.</def><br/
<syn><b>Syn. --</b> back-date; predate; antedate.</syn><br/
[<source>PJC</source>]</p>

<p><note><ex>Backdate</ex> is sometimes used incorrectly for
postdate.</note></p>

<p><ent>Back door</ent><br/
<hw>Back" door"</hw> <pr>(<?/)</pr>. <def>A door in the back part of a
building; hence, an indirect way.</def> <rj><au>Atterbury.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Backdoor</ent><br/
<hw>Back"door"</hw>, <pos>a.</pos> <def>Acting from behind and in
concealment; backstairs; <as>as, <ex>backdoor</ex>
intrigues</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Backdown</ent><br/
<hw>Back"down`</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>A receding or
giving up; a complete surrender.</def> <mark>[Colloq.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>backdrop</ent><br/
<hw>back"drop</hw> <pos>n.</pos> <sn>1.</sn> <def>the scenery hung at
back of stage. Also called in Britain
<altname>backcloth</altname>.</def><br/
<syn><b>Syn. --</b> background, backcloth</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><sn>2.</sn> <def>the background, setting, or circumstances of an
event; <as>as, the <ex>backdrop</ex> for the summit
meeting</as>.</def><br/
[<source>PJC</source>]</p>

<p><ent>Backed</ent><br/
<hw>Backed</hw> <pr>(b<acr/kt)</pr>, <pos>a.</pos> <def>Having a back;
fitted with a back; <as>as, a <ex>backed</ex> electrotype or stereotype
plate</as>. Used in composition; <as>as, broad-<ex>backed</ex>;
hump-<ex>backed</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Backer</ent><br/
<hw>Back"er</hw> <pr>(b<acr/k"<etil/r)</pr>, <pos>n.</pos> <def>One who,
or that which, backs; especially one who backs a person or thing in a
contest.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Backfall</ent><br/
<hw>Back"fall`</hw> <pr>(b<acr/k"f<add/l`)</pr>, <pos>n.</pos> <ety>[2d
<ets>back</ets>, n. + <ets>fall</ets>.]</ety> <def>A fall or throw on
the back in wrestling.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>back fire</ent><br/
<ent>backfire</ent><br/
<mhw><hw>backfire</hw>, <hw>back fire</hw></mhw>. <sn>1.</sn> <def>A
fire started ahead of a forest or prairie fire to burn only against the
wind, so that when the two fires meet both must go out for lack of
fuel.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><sn>2.</sn> <sd>(a)</sd> <def>A premature explosion in the cylinder
of a gas or oil engine during the exhaust or the compression stroke,
tending to drive the piston in a direction reverse to that in which it
should travel; also called a <altname>knock</altname> or
<altname>ping</altname>.</def> <sd>(b)</sd> <def>an explosion in the
exhaust passages of an internal combustion engine.</def><br/
[<source>Webster 1913 Suppl.</source> <source>+PJC</source>]</p>

<p><ent>Back-fire</ent><br/
<ent>Backfire</ent><br/
<mhw><hw>Back"fire`</hw> <hw>Back"-fire`</hw></mhw>, <pos>v. i.</pos>
<sn>1.</sn> <fld>(Engin.)</fld> <def>To have or experience a back fire
or back fires; -- said of an internal-combustion engine.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><sn>2.</sn> <def>Of a Bunsen or similar air-fed burner, to light so
that the flame proceeds from the internal gas jet instead of from the
external jet of mixed gas and air.</def> --
<wordforms><wf>Back"-fir`ing</wf>, <pos>n.</pos></wordforms><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>back-formation</ent><br/
<hw>back"-for*ma`tion</hw> <pos>n.</pos> <fld>(Linguistics)</fld>
<sn>1.</sn> <def>a word invented (usually unwittingly by subtracting an
affix) on the assumption that a familiar word derives from it, such as
<examp>emote</examp> from emotion.</def><br/
[<source>WordNet 1.5</source> <source>+PJC</source>]</p>

<p><sn>2.</sn> <def>the process of inventing a
back-formation{1}.</def><br/
[<source>PJC</source>]</p>

<p><ent>Backfriend</ent><br/
<hw>Back"friend`</hw> <pr>(<?/)</pr>, <pos>n.</pos>
<ety>[<ets>Back</ets>, n. or adv. + <ets>friend</ets>.]</ety> <def>A
secret enemy.</def> <mark>[Obs.]</mark> <rj><au>South.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>backgammon</ent><br/
<hw>back"gam`mon</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[Origin
unknown; perhaps fr. Dan. <ets>bakke</ets> tray + E. <ets>game</ets>; or
very likely the first part is from E. <ets>back</ets>, adv., and the
game is so called because the men are often set <ets>back</ets>.]</ety>
<def>A game of chance and skill, played by two persons on a
<ldquo/board<rdquo/ marked off into twenty-four spaces called
<ldquo/points<rdquo/. Each player has fifteen pieces, or
<ldquo/men<rdquo/, the movements of which from point to point are
determined by throwing dice. Formerly called
<altname>tables</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>backgammon board</b></col>, <cd>a board for playing
backgammon, often made in the form of two rectangular trays hinged
together, each tray containing two <ldquo/tables<rdquo/.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>backgammon</ent><br/
<hw>back`gam"mon</hw>, <pos>v. t.</pos> <def>In the game of backgammon,
to beat by ending the game before the loser is clear of his first
<ldquo/table<rdquo/. When played for betting purposes, the winner in
such a case scores three times the wagered amount.</def><br/
[<source>1913 Webster</source> <source>+PJC</source>]</p>

<p><ent>background</ent><br/
<hw>back"ground`</hw> <pr>(<?/)</pr>, <pos>n.</pos>
<ety>[<ets>Back</ets>, a. + <ets>ground</ets>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>Ground in the rear or behind, or in the distance, as
opposed to the <contr>foreground</contr>, or the ground in
<xex>front</xex>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Paint.)</fld> <def>The space which is behind and
subordinate to a portrait or group of figures.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ The distance in a picture is usually divided into
foreground, middle distance, and <xex>background</xex>.</note>
<rj><au>Fairholt.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Anything behind, serving as a foil; <as>as, the
statue had a <ex>background</ex> of red hangings</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>A place in obscurity or retirement, or out of
sight.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>I fancy there was a <qex>background</qex> of grinding and waiting
before Miss Torry could produce this highly finished . . .
performance.</q> <rj><qau>Mrs. Alexander.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>A husband somewhere in the <qex>background</qex>.</q>
<rj><qau>Thackeray.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>The set of conditions within which an action takes
place, including the social and physical conditions as well as the
psychological states of the participants; <as>as, within the
<ex>background</ex> of the massive budget deficits of the 1980's, new
spending programs had little chance of passage by the
congress</as>.</def><br/
[<source>PJC</source>]</p>

<p><sn>6.</sn> <def>The set of conditions that precede and affect an
action, such as the social and historical precedents for the event, as
well as the general background{5}; <as>as, against the
<ex>background</ex> of their expulsion by the Serbs, the desire of
Kosovars for vengeance is understandable though
regrettable</as>.</def><br/
[<source>PJC</source>]</p>

<p><sn>7.</sn> <fld>(Science)</fld> <def>The signals that may be
detected by a measurement which are not due to the phenomenon being
studied, and tend to make the measurement uncertain to a greater or
lesser degree.</def> <specif>Specifically:</specif> <fld>(Physics)</fld>
<def>Electronic noise present in a system using electronic measuring
instrument or in a telecommunications system, which may hide and which
must be differentiated from the desired signal; also called
<ecol><b>background noise</b></ecol> or
<altname>noise</altname>.</def><br/
[<source>PJC</source>]</p>

<p><sn>8.</sn> <fld>(Journalism)</fld> <def>An agreement between a
journalist and an interviewee that the name of the interviewee will not
be quoted in any publication, although the substance of the remarks may
be reported; -- often used in the phrase <ldquo/on background<rdquo/.
Compare <cref>deep background</cref>.</def><br/
[<source>PJC</source>]</p>

<p><cs><col><b>To place in the background</b></col>, <cd>to make of
little consequence.</cd> <col><b>To keep in the background</b></col>,
<cd>to remain unobtrusive, inconspicuous or out of sight; -- of
people.</cd> <col><b>deep background</b></col>, <fld>(Journalism)</fld>
<cd>the status of an interview which must not be quoted in a
publication, even without attribution. Compare
<er>background</er>{8}.</cd></cs><br/
[<source>1913 Webster</source> <source>+PJC</source>]</p>

<p><ent>backgrounding</ent><br/
<hw>back"ground*ing</hw> <pos>n.</pos> <fld>(Computers)</fld> <def>The
execution of low priority programs while higher priority programs are
not using the processing system.</def><br/
<syn><b>Syn. --</b> background processing</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Backhand</ent><br/
<hw>Back"hand`</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[<ets>Back</ets>,
adv. + <ets>hand</ets>.]</ety> <sn>1.</sn> <def>A kind of handwriting in
which the downward slope of the letters is from left to right.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Sports)</fld> <def>The stroke of a ball with a
racket or paddle, in which head of the racket starts from the side of
the body opposite to that of the arm in which the racket is held, and
proceeds forward to meet the ball. Contrasted with
<contr>forehand</contr>.</def><br/
[<source>PJC</source>]</p>

<p><ent>Backhand</ent><br/
<hw>Back"hand`</hw>, <pos>a.</pos> <sn>1.</sn> <def>Sloping from left to
right; -- said of handwriting.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Backhanded; indirect; oblique.</def>
<mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Backhanded</ent><br/
<hw>Back"hand`ed</hw>, <pos>a.</pos> <sn>1.</sn> <def>With the hand
turned backward; <as>as, a <ex>backhanded</ex> blow</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Indirect; awkward; insincere; sarcastic; <as>as, a
<ex>backhanded</ex> compliment</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Turned back, or inclining to the left; <as>as,
<ex>backhanded</ex> letters</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>backhanded</ent><br/
<hw>back"hand`ed</hw>, <pos>a. & adv.</pos> <fld>(Sport)</fld>
<def>Stroked with a backhand{2}; <as>as, a <ex>backhanded</ex>
drive</as>.</def><br/
[<source>PJC</source>]</p>

<p><ent>Backhandedness</ent><br/
<hw>Back"hand`ed*ness</hw>, <pos>n.</pos> <def>State of being
backhanded; the using of backhanded or indirect methods.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Backhander</ent><br/
<hw>Back"hand`er</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>A backhanded
blow.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Backheel</ent><br/
<hw>Back"heel`</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Wrestling)</fld>
<def>A method of tripping by getting the leg back of the opponent's heel
on the outside and pulling forward while pushing his body back; a throw
made in this way.</def> -- <def2><pos>v. t.</pos> <def>To trip (a
person) in this way.</def></def2><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Backhouse</ent><br/
<hw>Back"house`</hw> <pr>(<?/)</pr>, <pos>n.</pos>
<ety>[<ets>Back</ets>, a. + <ets>house</ets>.]</ety> <def>A building
behind the main building.</def> <specif>Specifically:</specif> <def>A
privy; an outhouse; a necessary.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Backing</ent><br/
<hw>Back"ing</hw>, <pos>n.</pos> <sn>1.</sn> <def>The act of moving
backward, or of putting or moving anything backward.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>That which is behind, and forms the back of,
anything, usually giving strength or stability.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Support or aid given to a person or cause.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <fld>(Bookbinding)</fld> <def>The preparation of the back
of a book with glue, etc., before putting on the cover.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Backjoint</ent><br/
<hw>Back"joint`</hw> <pr>(b<acr/k"joint`)</pr>, <pos>n.</pos>
<ety>[<ets>Back</ets>, a. or adv. + <ets>joint</ets>.]</ety>
<fld>(Arch.)</fld> <def>A rebate or chase in masonry left to receive a
permanent slab or other filling.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Backlash</ent><br/
<hw>Back"lash`</hw> <pr>(b<acr/k"l<acr/sh`)</pr>, <pos>n.</pos>
<ety>[<ets>Back</ets>, adv. + <ets>lash</ets>.]</ety> <sn>1.</sn>
<fld>(Mech.)</fld> <def>The distance through which one part of connected
machinery, as a wheel, piston, or screw, can be moved without moving the
connected parts, resulting from looseness in fitting or from wear; also,
the jarring or reflex motion caused in badly fitting machinery by
irregularities in velocity or a reverse of motion.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A strong and sudden reverse movement in a moving
part of a machine.</def><br/
[<source>PJC</source>]</p>

<p><sn>3.</sn> <def>A strong popular reaction serving to counter the
effect of an action; -- used especially of adverse reactions to social
or political developments.</def><br/
[<source>PJC</source>]</p>

<p><ent>Backless</ent><br/
<hw>Back"less</hw>, <pos>a.</pos> <def>Without a back.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Backlog</ent><br/
<hw>Back"log`</hw> <pr>(b<acr/k"l<ocr/g`; 115)</pr>, <pos>n.</pos>
<ety>[<ets>Back</ets>, a. + <ets>log</ets>.]</ety> <sn>1.</sn> <def>A
large stick of wood, forming the back of a fire on the hearth.
Contrasted to <contr>forestick</contr>.</def> <mark>[U.S.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>There was first a <qex>backlog</qex>, from fifteen to four and
twenty inches in diameter and five feet long, imbedded in the ashes.</q>
<rj><qau>S. G. Goodrich.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>An accumulation (of tasks or of materials) that were
not performed or processed at the normal time and require attention;
<as>as, unexpected demand led to a large <ex>backlog</ex> of unfilled
orders; politically motivated delays led to a large <ex>backlog</ex> of
unconfirmed judicial appointments</as>.</def><br/
[<source>PJC</source>]</p>

<p><ent>backpack</ent><br/
<hw>back"pack</hw> <pos>n.</pos> <def>a bag carried on the back,
supported by straps looped over the shoulders.</def><br/
<syn><b>Syn. --</b> knapsack; rucksack; haversack.</syn>
[<source>WordNet 1.5</source>]</p>

<p><ent>backpack</ent><br/
<hw>back"pack</hw> <pos>v. i.</pos> <def>to hike while carrying a
backpack; -- often used in the form <altname>go backpacking</altname>;
<as>as, to <ex>backpack</ex> through the forest</as>.</def><br/
[<source>PJC</source>]</p>

<p><ent>backpacker</ent><br/
<hw>back"pack*er</hw> <pos>n.</pos> <def>one who backpacks; <as>as, two
<ex>backpackers</ex> were mauled by bears in Yellowstone this
week</as>.</def><br/
[<source>PJC</source>]</p>

<p><ent>backpedal</ent><br/
<hw>back"ped*al</hw> <pos>v. i.</pos> <sn>1.</sn> <def>pedal backwards,
as on a bicycle.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><sn>2.</sn> <def>step backwards, in boxing.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><sn>3.</sn> <def>modify one' opinion, usually by making it less
strong or adding qualifications.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Backplate</ent><br/
<ent>Backpiece</ent><br/
<mhw>{ <hw>Back"piece`</hw> <pr>(<?/)</pr>, <hw>Back"plate`</hw>
<pr>(<?/)</pr>, }</mhw> <pos>n.</pos> <ety>[<ets>Back</ets>, n. or a. +
<ets>piece</ets>, <ets>plate</ets>. ]</ety> <sn>1.</sn> <def>A piece, or
plate which forms the back of anything, or which covers the
back.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <specif>Specifically:</specif> <def>A piece of plate
armor protecting the back; -- it is worn as part of a
<partof>cuirass</partof>.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><-- p. 111 pr=SA --></p>

<p><ent>Backrag</ent><br/
<ent>Backrack</ent><br/
<mhw>{ <hw>Back"rack</hw> <pr>(b<acr/k"r<acr/k)</pr>, <hw>Back"rag</hw>
<pr>(b<acr/k"r<acr/g)</pr>, }</mhw> <pos>n.</pos> <def>See
<er>Bacharach</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>backrest</ent><br/
<hw>back"rest</hw> <pos>n.</pos> <sn>1.</sn> <def>a support that you can
lean against while sitting.</def><br/
<syn><b>Syn. --</b> back.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>backroom</ent><br/
<hw>backroom</hw> <pos>n.</pos> <sn>1.</sn> <def>the meeting place of a
group of leaders who make their decisions via private
negotiations.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Backs</ent><br/
<hw>Backs</hw> <pr>(b<acr/ks)</pr>, <pos>n. pl.</pos> <def>Among leather
dealers, the thickest and stoutest tanned hides.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Backsaw</ent><br/
<hw>Back"saw`</hw> <pr>(b<acr/k"s<add/`)</pr>, <pos>n.</pos> <ety>[2d
<ets>back</ets>, n. + <ets>saw</ets>.]</ety> <def>A saw (as a tenon saw)
whose blade is stiffened by an added metallic back.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Backset</ent><br/
<hw>Back"set`</hw> <pr>(b<acr/k"s<ecr/t`)</pr>, <pos>n.</pos>
<ety>[<ets>Back</ets>, adv. + <ets>set</ets>.]</ety> <sn>1.</sn> <def>A
check; a relapse; a discouragement; a setback.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Whatever is thrown back in its course, as
water.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Slackwater, or the <qex>backset</qex> caused by the overflow.</q>
<rj><qau>Harper's Mag.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Backset</ent><br/
<hw>Back"set`</hw>, <pos>v. t.</pos> <def>To plow again, in the fall; --
said of prairie land broken up in the spring.</def> <mark>[Western
U.S.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Backsettler</ent><br/
<hw>Back"set"tler</hw> <pr>(b<acr/k"s<ecr/t"l<etil/r)</pr>,
<pos>n.</pos> <ety>[<ets>Back</ets>, a. + <ets>settler</ets>.]</ety>
<def>One living in the back or outlying districts of a
community.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The English <qex>backsettlers</qex> of Leinster and Munster.</q>
<rj><qau>Macaulay.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Backshish</ent><br/
<ent>Backsheesh</ent><br/
<mhw>{ \'d8<hw>Back"sheesh`</hw>, \'d8<hw>Back"shish`</hw> }</mhw>
<pr>(<?/)</pr>, <pos>n.</pos> <ety>[Pers. <ets>bakhsh<imac/sh</ets>, fr.
<ets>bakhsh<imac/dan</ets> to give.]</ety> <def>In Egypt and the Turkish
empire, a relatively small amount of money given for services rendered
(as by a waiter); a gratuity; a <ldquo/tip<rdquo/.</def><br/
<syn><b>Syn. --</b> gratuity, tip, baksheesh, bakshish,
bakshis.</syn><br/
[<source>1913 Webster</source> + <source>WordNet 1.5</source>]</p>

<p><ent>Backside</ent><br/
<hw>Back"side`</hw> <pr>(b<acr/k"s<imac/d`)</pr>, <pos>n.</pos>
<ety>[<ets>Back</ets>, a. + <ets>side</ets>.]</ety> <def>The hinder
part, posteriors, or rump of a person or animal.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ <xex>Backside</xex> (one word) was formerly used of the
rear part or side of any thing or place, but in such senses is now two
words.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Backsight</ent><br/
<hw>Back"sight`</hw> <pr>(b<acr/k"s<imac/t`)</pr>, <pos>n.</pos>
<ety>[<ets>Back</ets>, adv. + <ets>sight</ets>.]</ety>
<fld>(Surv.)</fld> <def>The reading of the leveling staff in its
unchanged position when the leveling instrument has been taken to a new
position; a sight directed backwards to a station previously occupied.
Cf. <er>Foresight</er>, <pos>n.</pos>, 3.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Backslide</ent><br/
<hw>Back"slide"</hw> <pr>(b<acr/k"sl<imac/d"; 277)</pr>, <pos>v.
i.</pos> <vmorph>[<pos>imp.</pos> <conjf>Backslid</conjf>
<pr>(<?/)</pr>; <pos>p. p.</pos> <conjf>Backslidden</conjf>
<pr>(<?/)</pr>, <conjf>Backslid</conjf>; <pos>p. pr. & vb. n.</pos>
<conjf>Backsliding</conjf>.]</vmorph> <ety>[<ets>Back</ets>, adv. +
<ets>slide</ets>.]</ety> <def>To slide back; to fall away; esp. to
abandon gradually the faith and practice of a religion that has been
professed.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Backslider</ent><br/
<hw>Back"slid"er</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>One who
backslides.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Backsliding</ent><br/
<hw>Back"slid"ing</hw>, <pos>a.</pos> <def>Slipping back; falling back
into sin or error; sinning.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Turn, O <qex>backsliding</qex> children, saith the Lord.</q>
<rj><qau>Jer. iii. 14.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Backsliding</ent><br/
<hw>Back"slid"ing</hw>, <pos>n.</pos> <def>The act of one who
backslides; abandonment of faith or duty.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Our <qex>backslidings</qex> are many.</q> <rj><qau>Jer. xiv.
7.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>backspacer</ent><br/
<ent>backspace</ent><br/
<mhw><hw>backspace</hw>, <hw>backspacer</hw></mhw> <pos>n.</pos>
<sn>1.</sn> <def>The key on a typewriter or other keyboard used for back
spacing.</def><br/
<syn><b>Syn. --</b> backspace key.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>backspace</ent><br/
<hw>backspace</hw>, <pos>v. i.</pos> <def>In typing text, to press the
backspace key so as to reposition the carriage or cursor on the previous
space.</def><br/
[<source>PJC</source>]</p>

<p><ent>Backstaff</ent><br/
<hw>Back"staff`</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>An instrument
formerly used for taking the altitude of the heavenly bodies, but now
superseded by the quadrant and sextant; -- so called because the
observer turned his back to the body observed.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>backstage</ent><br/
<hw>back"stage</hw> <pos>n.</pos> <fld>(theater)</fld> <def>the area on
the stage out of sight of the audience.</def><br/
<syn><b>Syn. --</b> wing, wings, offstage.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>backstage</ent><br/
<hw>backs"tage</hw> <pos>adj.</pos> <def>concealed from the public; in
private.</def><br/
<syn><b>Syn. --</b> behind the scenes.</syn>
[<source>WordNet 1.5</source>]</p>

<p><ent>Back stairs</ent><br/
<ent>Backstairs</ent><br/
<mhw><hw>Back"stairs`</hw>, <hw>Back" stairs`</hw></mhw>.
<pr>(b<acr/k"st<acir/rz`)</pr> <pos>n.</pos> <def>Stairs in the back
part of a house, as distinguished from the <contr>front stairs</contr>;
a second staircase at the rear of a building; hence, a private or
indirect way.</def><br/
[<source>1913 Webster</source> + <source>WordNet 1.5</source>]</p>

<p><ent>Backstair</ent><br/
<ent>Backstairs</ent><br/
<mhw>{ <hw>Back"stairs`</hw>, <hw>Back"stair`</hw> }</mhw>,
<pos>a.</pos> <def>Private; indirect; secret; conducted with secrecy;
intriguing; -- as if finding access by the back stairs; <as>as,
<ex>backstairs</ex> gossip</as>.</def><br/
<syn><b>Syn. --</b> clandestine, cloak-and-dagger, hugger-mugger,
hush-hush, on the quiet(predicate), secret, subterranean, surreptitious,
undercover, underground.</syn><br/
[<source>1913 Webster</source> + <source>WordNet 1.5</source>]</p>

<p><q>A <qex>backstairs</qex> influence.</q>
<rj><qau>Burke.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Female caprice and <qex>backstair</qex> influence.</q>
<rj><qau>Trevelyan.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Backstay</ent><br/
<hw>Back"stay`</hw> <pr>(b<acr/k"st<amac/`)</pr>, <pos>n.</pos>
<ety>[<ets>Back</ets>, a. or n. + <ets>stay</ets>.]</ety> <sn>1.</sn>
<fld>(Naut.)</fld> <def>A rope or stay extending from the masthead to
the side of a ship, slanting a little aft, to assist the shrouds in
supporting the mast.</def> <mark>[Often used in the plural.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A rope or strap used to prevent excessive forward
motion.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Backster</ent><br/
<hw>Back"ster</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[See
<er>Baxter</er>.]</ety> <def>A baker.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Backstitch</ent><br/
<hw>Back"stitch`</hw> <pr>(<?/)</pr>, <pos>n.</pos>
<ety>[<ets>Back</ets>, adv. + <ets>stitch</ets>.]</ety> <def>A stitch
made by setting the needle back of the end of the last stitch, and
bringing it out in front of the end.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Backstitch</ent><br/
<hw>Back"stitch`</hw>, <pos>v. t.</pos> <def>To sew with backstitches;
<as>as, to <ex>backstitch</ex> a seam</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Backstop</ent><br/
<hw>Back"stop`</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn> <def>In
baseball, a fence, prop. at least 90 feet behind the home base, to stop
the balls that pass the catcher; also, the catcher himself.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><sn>2.</sn> <def>In rounders, the player who stands immediately
behind the striking base.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><sn>3.</sn> <def>In cricket, the longstop; also, the wicket
keeper.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Backstress</ent><br/
<hw>Back"stress</hw> <pr>(b<acr/k"str<ecr/s)</pr>, <pos>n.</pos> <def>A
female baker.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>backstroke</ent><br/
<hw>back"stroke`</hw> <pos>n.</pos> <sn>1.</sn> <def>a swimming stroke
that resembles the crawl except the swimmer lies on his or her back. It
is usually executed with backward-moving circular arm strokes and a
flutter kick.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>backswept</ent><br/
<hw>back"swept`</hw> <pos>adj.</pos> <def>aligned from front to back;
slanted toward the back; -- used of hair.</def><br/
<syn><b>Syn. --</b> sweptback.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Backsword</ent><br/
<hw>Back"sword`</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[2d
<ets>back</ets>, <pos>n.</pos> + <ets>sword</ets>.]</ety> <sn>1.</sn>
<def>A sword with one sharp edge.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>In England, a stick with a basket handle, used in
rustic amusements; also, the game in which the stick is used. Also
called <xex>singlestick</xex>.</def> <rj><au>Halliwell.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>backswimmer</ent><br/
<hw>back"swim`mer</hw> <pos>n.</pos> <def>any of numerous predaceous
aquatic insects of the family <fam>Notonectidae</fam> (such as
<styp><spn>Notonecta undulata</spn></styp>) that swim on their backs and
may inflict painful bites; -- also called <altname>boat
bug</altname>.</def> <au>[RHUD]</au><br/
[<source>WordNet 1.5</source> <source>+PJC</source>]</p>

<p><ent>back-to-back</ent><br/
<hw>back-to-back</hw> <pos>adj.</pos> <sn>1.</sn> <def>occurring
immediately one after the other; consecutive.</def>
<illu><ex>back-to-back</ex> home runs</illu><br/
<syn><b>Syn. --</b> consecutive.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><sn>2.</sn> <def>oriented with the backs toward each other, and
sometimes touching.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>back up</ent><br/
<hw>back" up</hw>, <pos>v. i.</pos> <sn>1.</sn> <def>to move in a
reverse direction; -- used of vehicles or animals.</def><br/
[<source>PJC</source>]</p>

<p><sn>2.</sn> <def>to accumulate due to a blockage of flow; <as>as, a
traffic <ex>backup</ex> due to an accident; a sewage
<ex>backup</ex></as>.</def><br/
[<source>PJC</source>]</p>

<p><ent>back up</ent><br/
<hw>back" up</hw>, <pos>v. t.</pos> <sn>1.</sn> <def>to serve as a
backup{3} for (another person or persons); <as>as, the patrolmen
<ex>backed up</ex> the detectives as they went inside to make the
arrest; the center fielder <ex>backed up</ex> the shortstop on the
play</as>.</def><br/
[<source>PJC</source>]</p>

<p><sn>2.</sn> <fld>(Computers)</fld> <def>to make a backup{5} of;
<as>as, the sysop <ex>backed up</ex> the purchasing data files every
night</as>.</def><br/
[<source>PJC</source>]</p>

<p><ent>backup</ent><br/
<hw>back"up</hw>, <pos>n.</pos> <sn>1.</sn> <def>anything kept in
reserve to serve as a substitute in case of failure or unavailability of
the normal or primary object; -- used for devices, plans, people, etc.
Also used attributively; <as>as, there was no <ex>backup</ex> for the
electrical supply; a <ex>backup</ex> motor; a <ex>backup</ex>
generator</as>.</def><br/
[<source>PJC</source>]</p>

<p><sn>2.</sn> <fld>(Music)</fld> <def>a musician or group of musicians
accompanying a soloist, whether vocalists or instrumentalists.</def><br/
<syn><b>Syn. --</b> accompaniment.</syn>
[<source>PJC</source>]</p>

<p><sn>3.</sn> <def>a person or group of persons serving as
reinforcement for another or others; <as>as, the policeman called for
<ex>backup</ex> when he was fired on</as>.</def><br/
[<source>PJC</source>]</p>

<p><sn>4.</sn> <def>an accumulation, overflow, or reverse flow (in
traffic or a liquid flow system) caused by a stoppage or other
malfunction.</def><br/
[<source>PJC</source>]</p>

<p><sn>5.</sn> <fld>(Computers)</fld> <def>A copy of a program or data
from a computer onto a data-storage medium, usually one that may be
removed to safe storage at a distance from the computer; it is used to
preserve data for use in the contingency that the original data on the
computer may be lost or become unusable. A backup that is removed from
the building housing the computer system (to provide protection against
loss of data in a disastrous event such as a fire) is called
<styp><ecol><b>off-site backup</b></ecol></styp>. Also used
attributively; <as>as, <ex>backup</ex> copy</as>.</def><br/
[<source>PJC</source>]</p>

<p><sn>6.</sn> <fld>(Computers)</fld> <def>The act or process of
creating a backup{5}; <as>as, they performed a full system
<ex>backup</ex> every weekend</as>.</def><br/
[<source>PJC</source>]</p>

<p><ent>Backwards</ent><br/
<ent>Backward</ent><br/
<mhw>{ <hw>Back"ward</hw> <pr>(<?/)</pr>, <hw>Back"wards</hw>
<pr>(<?/)</pr>, }</mhw> <pos>adv.</pos> <ety>[<ets>Back</ets>, adv. +
<ets>-ward</ets>.]</ety> <sn>1.</sn> <def>With the back in advance or
foremost; <as>as, to ride <ex>backward</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Toward the back; toward the rear; <as>as, to throw
the arms <ex>backward</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>On the back, or with the back downward.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Thou wilt fall <qex>backward</qex>.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>Toward, or in, past time or events; ago.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Some reigns <qex>backward</qex>.</q>
<rj><qau>Locke.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>By way of reflection; reflexively.</def> <rj><au>Sir
J. Davies.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <def>From a better to a worse state, as from honor to
shame, from religion to sin.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The work went <qex>backward</qex>.</q>
<rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>7.</sn> <def>In a contrary or reverse manner, way, or direction;
contrarily; <as>as, to read <ex>backwards</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>We might have . . . beat them <qex>backward</qex> home.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Backward</ent><br/
<hw>Back"ward</hw>, <pos>a.</pos> <sn>1.</sn> <def>Directed to the back
or rear; <as>as, <ex>backward</ex> glances</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Unwilling; averse; reluctant; hesitating;
loath.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>For wiser brutes were <qex>backward</qex> to be slaves.</q>
<rj><qau>Pope.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Not well advanced in learning; not quick of
apprehension; dull; inapt; <as>as, a <ex>backward</ex> child</as>.</def>
<ldquo/The <xex>backward</xex> learner.<rdquo/
<rj><au>South.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>Late or behindhand; <as>as, a <ex>backward</ex>
season</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>Not advanced in civilization; undeveloped; <as>as,
the country or region is in a <ex>backward</ex> state</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <def>Already past or gone; bygone.</def>
<mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>And flies unconscious o'er each <qex>backward</qex> year.</q>
<rj><qau>Byron.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Backward</ent><br/
<hw>Back"ward</hw>, <pos>n.</pos> <def>The state behind or past.</def>
<mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>In the dark <qex>backward</qex> and abysm of time.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Backward</ent><br/
<hw>Back"ward</hw>, <pos>v. t.</pos> <def>To keep back; to hinder.</def>
<mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Backwardation</ent><br/
<hw>Back`war*da"tion</hw> <pr>(<?/)</pr>, <pos>n.</pos>
<ety>[<ets>Backward</ets>, v. t. + <ets>-ation</ets>.]</ety> <fld>(Stock
Exchange)</fld> <def>The seller's postponement of delivery of stock or
shares, with the consent of the buyer, upon payment of a premium to the
latter; -- also, the premium so paid. See <er>Contango</er>.</def>
<rj><au>Biddle.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Backwardly</ent><br/
<hw>Back"ward*ly</hw> <pr>(<?/)</pr>, <pos>adv.</pos> <sn>1.</sn>
<def>Reluctantly; slowly; aversely.</def> <mark>[Obs.]</mark>
<rj><au>Sir P. Sidney.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Perversely; ill.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>And does he think so <qex>backwardly</qex> of me?</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>backwardness</ent><br/
<hw>back"ward*ness</hw>, <pos>n.</pos> <def>The state of being
backward.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>backwash</ent><br/
<hw>back"wash`</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <sn>1.</sn> <def>To
clean the oil from (wool) after combing.</def>
<rj><au>Ash.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Chem.)</fld> <def>To clean (a filter, a
chromatography column, a water softener, etc.) by passing liquid through
in the reverse of the normal direction of flow. This procedure dislodges
particles which clog the pores of the filter or column packing, removing
them from the filter or column.</def><br/
[<source>PJC</source>]</p>

<p><ent>backwash</ent><br/
<hw>back"wash`</hw> <pr>(<?/)</pr>, <pos>n.</pos> <sn>1.</sn> <def>The
flow of water propelled backward by the propeller, paddle wheel, or oars
of a boat.</def><br/
[<source>PJC</source>]</p>

<p><sn>2.</sn> <fld>(Aeron.)</fld> <def>The backward flowing air within
the wash of an airplane, caused mostly by the engine.</def><br/
[<source>PJC</source>]</p>

<p><ent>Backwater</ent><br/
<hw>Back"wa`ter</hw> <pr>(<?/)</pr>, <pos>n.</pos>
<ety>[<ets>Back</ets>, a. or adv. + <ets>-water</ets>. ]</ety>
<sn>1.</sn> <def>Water turned back in its course by an obstruction, an
opposing current, or the flow of the tide, as in a sewer or river
channel, or across a river bar.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>An accumulation of water overflowing the low lands,
caused by an obstruction.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Water thrown back by the turning of a waterwheel, or
by the paddle wheels of a steamer.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Backwoods</ent><br/
<hw>Back"woods"</hw> <pr>(<?/)</pr>, <pos>n. pl.</pos>
<ety>[<ets>Back</ets>, a. + <ets>woods</ets>.]</ety> <def>The forests or
partly cleared grounds on the frontiers.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Backwoodsman</ent><br/
<hw>Back"woods"man</hw> <pr>(<?/)</pr>, <pos>n.</pos>; <plu><it>pl.</it>
<plw>Backwoodsmen</plw> <pr>(<?/)</pr>.</plu> <def>A man living in the
forest in or beyond the new settlements, especially on the western
frontiers of the United States in former times.</def> <rj><au>Fisher
Ames.</au></rj><br/
[<source>1913 Webster</source> <source>+PJC</source>]</p>

<p><ent>Backworm</ent><br/
<hw>Back"worm`</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[2d
<ets>back</ets>, n. + <ets>worm</ets>.]</ety> <def>A disease of hawks.
See <er>Filanders</er>.</def> <rj><au>Wright.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bacon</ent><br/
<hw>Ba"con</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[OF.
<ets>bacon</ets>, fr. OHG. <ets>bacho</ets>, <ets>bahho</ets>, flitch of
bacon, ham; akin to E. <ets>back</ets>. Cf. <ets>Back</ets> the back
side.]</ety> <def>The back and sides of a pig salted and smoked;
formerly, the flesh of a pig salted or fresh.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Bacon beetle</b></col> <fld>(Zool.)</fld>, <cd>a beetle
(<spn>Dermestes lardarius</spn>) which, especially in the larval state,
feeds upon bacon, woolens, furs, etc. See <er>Dermestes</er>.</cd> --
<col><b>To save one's bacon</b></col>, <cd>to save one's self or
property from harm or loss.</cd> <mark>[Colloq.]</mark></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Roger Bacon</ent><br/
<ent>Bacon</ent><br/
<mhw><hw>Bacon</hw>, <hw>Roger Bacon</hw></mhw> <pos>prop. n.</pos>
<def>Roger Bacon. A celebrated English philosopher of the thirteenth
century. Born at or near Ilchester, Somersetshire, about 1214: died
probably at Oxford in 1294. He is credited with a recognition of the
importance of experiment in answering questions about the natural world,
recognized the potential importance of gunpowder and explosives
generally, and wrote comments about several of the physical sciences
that anticipated facts proven by experiment only much later.</def><br/
[<source>PJC</source>]</p>

<p><q>The Franciscan monk, Roger Bacon (c. 1214 - 1294) was an important
transitional figure in chemistry as he was trained in the alchemical
tradition, but introduced many of the modern concepts of experimental
science. Bacon believed that experiment was necessary to support theory,
but for him the theory as presented in the Bible was true and the
experiment only underlined that truth. One of Bacon's lasting
contributions was his references to gunpowder, bringing this discovery
to the general attention of literate Europeans.<br/
<br/
Gunpowder had been known for centuries in China, being used for
fireworks and incendiary grenades. Gunpowder is a simple mixture of
charcoal, sulfur, and potassium nitrate (known generally as saltpeter).
Saltpeter is a major component of guano (bird droppings) and may be
recovered from privies where it will crystallize. By 1324, Europeans had
discovered the art of using gunpowder to fire a projectile, marking the
end of the period of castles and knights in armor.</q> <qau>Prof. Tom
Bitterwolf, Univ. of Idaho (Post-class notes, 1999).</qau><br/
[<source>PJC</source>]</p>

<p><q>Roger Bacon was Born at or near Ilchester, Somersetshire, about
1214: died probably at Oxford in 1294. He was educated at Oxford and
Paris (whence he appears to have returned to England about 1250), and
joined the Franciscan order. In 1257 he was sent by his superiors to
Paris where he was kept in close confinement for several years. About
1265 he was invited by Pope Clement IV. to write a general treatise on
the sciences, in answer to which he composed his chief work, the "Opus
Majus." He was in England in 1268. In 1278 his writings were condemned
as heretical by a council of his order, in consequence of which he was
again placed in confinement. He was at liberty in 1292. Besides the
"Opus Majus," his most notable works are "Opus Minus," "Opus Tertium,"
and "Compendium Philosophiae." See Siebert, "Roger Bacon," 1861; Held,
"Roger Bacon's Praktische Philosophie," 1881; and L. Schneider, "Roger
Bacon," 1873.</q> <qau>Century Dict. 1906.</qau><br/
[<source>PJC</source>]</p>

<p><q> Dr. Whewell says that Roger Bacon's Opus Majus is "the
encyclopedia and Novam Organon of the Thirteenth Century, a work equally
wonderful with regard to its general scheme and to the special treatises
with which the outlines of the plans are filled up. The professed object
of the work is to urge the necessity of a reform in the mode of
philosophizing, to set forth the reasons why knowledge had not made a
greater progress, to draw back attention to the sources of knowledge
which had been unwisely neglected, to discover other sources which were
yet almost untouched, and to animate men in the undertaking by a
prospect of the vast advantages which it offered. In the development of
this plan all the leading portions of science are expanded in the most
complete shape which they had at that time assumed; and improvements of
a very wide and striking kind are proposed in some of the principal
branches of study. Even if the work had no leading purposes it would
have been highly valuable as a treasure of the most solid knowledge and
soundest speculations of the time; even if it bad contained no such
details it would have been a work most remarkable for its general views
and scope."</q> <qau>James J. Walsh (Thirteenth Greatest of Centuries,
1913.)</qau><br/
[<source>PJC</source>]</p>

<p><ent>Francis Bacon</ent><br/
<ent>Bacon</ent><br/
<mhw><hw>Bacon</hw>, <hw>Francis Bacon</hw></mhw> <pos>prop. n.</pos>
<def>Francis Bacon. A celebrated English philosopher, jurist, and
statesman, son of Sir Nicholas Bacon. Born at York House, London, Jan.
22, 1561: died at Highgate, April 9, 1626, created <altname>Baron
Verulam</altname> July 12, 1618, and <altname>Viscount St.
Albans</altname> Jan. 27, 1621: commonly, but incorrectly, called
<altname>Lord Bacon</altname>. He studied at Trinity College, Cambridge,
April, 1573, to March, 1575, and at Gray's Inn 1575; became attached to
the embassy of Sir Amias Paulet in France in 1576; was admitted to the
bar in 1582; entered Parliament in 1584; was knighted in 1603; became
solicitor-general in 1607, and attorney-general in 1613; was made a
privy councilor in 1616, lord keeper in 1617, and lord chancellor in
1618; and was tried in 1621 for bribery, condemned, fined, and removed
from office. A notable incident of his career was his connection with
the Earl of Essex, which began in July, 1591, remained an intimate
friendship until the fall of Essex (1600-01), and ended in Bacon's
active efforts to secure the conviction of the earl for treason. (See
Essex.) His great fame rests upon his services as a reformer of the
methods of scientific investigation; and though his relation to the
progress of knowledge has been exaggerated and misunderstood, his
reputation as one of the chief founders of modern inductive science is
well grounded. His chief works are the "Advancement of Learning,"
published in English as "The Two Books of Francis Bacon of the
Proficience and Advancement of Learning Divine and Human," in 1605; the
"Novum organum sive indicia vera de interpretatione naturae," published
in Latin, 1620, as a "second part" of the (incomplete) "Instauratio
magna"; the "De dignitate et augmentis scientiarum," published in Latin
in 1623; "Historia Ventorum" (1622), "Historia Vitae et Mortis" (1623),
"Historia Densi et Rari" (posthumously, 1658), "Sylva Sylvarum"
(posthumously, 1627), "New Atlantis," "Essays" (1597, 1612, 1625), "De
Sapientia Veterum" (1609), "Apothegms New and Old," "History of Henry
VII." (1622). Works edited by Ellis, Spedding, and Heath (7 vols. 1857);
Life by Spedding (7 vols. 1861, 2 vols. 1878). See Shakspere.</def>
<au>Century Dict. 1906.</au><br/
[<source>PJC</source>]</p>

<p><ent>Baconian</ent><br/
<hw>Ba*co"ni*an</hw> <pr>(<?/)</pr>, <pos>a.</pos> <def>Of or pertaining
to Lord Francis Bacon, or to his system of philosophy.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baconian</ent><br/
<hw>Ba*co"ni*an</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn> <def>One
who adheres to the philosophy of Lord Bacon.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><sn>2.</sn> <def>One who maintains that Lord Bacon is the author of
the works commonly attributed to Shakespeare.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><cs><col><b>Baconian method</b></col>, <cd>the inductive method. See
<er>Induction</er>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>bacteremia</ent><br/
<hw>bac`ter*e"mi*a</hw> <pr>(b<acr/k*t<emac/r*<emac/"m<emac/*<adot/
<it>or</it> b<acr/k`t<ucr/*r<emac/"m<emac/*<adot/)</pr>, <pos>n.</pos>
<def>The presence of bacteria in the blood.</def><br/
<syn><b>Syn. --</b> bacteriemia.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>bacteremic</ent><br/
<hw>bacteremic</hw> <pos>adj.</pos> <def>Of or pertaining to
bacteremia.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Bacteria</ent><br/
<hw>Bac*te"ri*a</hw> <pr>(<?/)</pr>, <pos>n. pl.</pos> <def>See
<er>Bacterium</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bacterial</ent><br/
<hw>Bac*te"ri*al</hw> <pr>(<?/)</pr>, <pos>a.</pos> <fld>(Biol.)</fld>
<def>Of, pertaining to, or caused by bacteria.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bactericidal</ent><br/
<hw>Bac*te"ri*ci`dal</hw> <pr>(<?/)</pr>, <pos>a.</pos> <def>Destructive
of bacteria.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bactericide</ent><br/
<hw>Bac*te"ri*cide</hw> <pr>(b<acr/k*t<emac/"r<icr/*s<imac/d)</pr>,
<pos>n.</pos> <ety>[<ets>Bacterium</ets> + L. <ets>caedere</ets> to
kill]</ety> <fld>(Biol.)</fld> <def>Same as
<er>Germicide</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>bacteriemia</ent><br/
<hw>bac*teri*e"mi*a</hw>
<pr>(b<acr/k*t<etil/r*<emac/*<emac/"m<emac/*<adot/)</pr> <pos>n.</pos>
<def>The presence of bacteria in the blood; same as
<er>bacteremia</er>.</def><br/
[<source>PJC</source>]</p>

<p><ent>Bacterin</ent><br/
<hw>Bac"te*rin</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Med.)</fld> <def>A
bacterial vaccine.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Bacteriological</ent><br/
<hw>Bac*te"ri*o*log`ic*al</hw>
<pr>(b<acr/k*t<emac/`r<icr/*<osl/*l<ocr/j"<icr/*k<ait/l)</pr>,
<pos>a.</pos> <def>Of or pertaining to bacteriology; <as>as,
<ex>bacteriological</ex> studies</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bacteriologist</ent><br/
<hw>Bac*te"ri*ol`o*gist</hw>, <pos>n.</pos> <def>One skilled in
bacteriology.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bacteriology</ent><br/
<hw>Bac*te"ri*ol`o*gy</hw> <pr>(<?/)</pr>, <pos>n.</pos>
<ety>[<ets>Bacterium</ets> + <ets>-logy</ets>.]</ety> <fld>(Biol.)</fld>
<def>The branch of microbiology relating to bacteria.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bacteriolysis</ent><br/
\'d8<hw>Bac*te`ri*ol"y*sis</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[NL.;
fr. Gr. <grk>bakth`rion</grk>, <grk>ba`ktron</grk>, a staff + <?/ a
loosing.]</ety> <sn>1.</sn> <def>Chemical decomposition brought about by
bacteria without the addition of oxygen.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><sn>2.</sn> <def>The destruction or dissolution of bacterial
cells.</def> -- <wordforms><wf>Bac*te`ri*o*lyt"ic</wf> <pr>(#)</pr>,
<pos>a.</pos></wordforms><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>bacteriophage</ent><br/
<hw>bacteriophage</hw> <pos>n. sing. & pl.</pos> <def>a virus which
infects bacteria; -- also colloquially called <altname>phage</altname>
in laboratory jargon.</def> <note>Bacteriophages are of many varieties,
generally specific for one or a narrow range of bacterial species, and
almost every bacterium is susceptible to at least one bacteriophage.
They may have DNA or RNA as their genetic component. Certain types of
bacteriophage, called <styp><col><b>temperate
bacteriophage</b></col></styp>, may infect but not kill their host
bacteria, residing in and replicating either as a plasmid or integrated
into the host genome. Under certain conditions, a resident temperate
phage may become induced to multiply rapidly and vegetatively, killing
and lysing its host bacterium, and producing multiple progeny. The
<stype>lambda phage</stype> of <spn>Eschericia coli</spn>, much studied
in biochemical and genetic research, is of the temperate
type.</note><br/
[<source>PJC</source>]</p>

<p><ent>bacteriophagous</ent><br/
<ent>bacteriophagic</ent><br/
<mhw><hw>bacteriophagic</hw> <hw>bacteriophagous</hw></mhw>
<pos>adj.</pos> <sn>1.</sn> <def>of or pertaining to
bacteriophage.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Bacterioscopic</ent><br/
<hw>Bac*te`ri*o*scop"ic</hw> <pr>(<?/)</pr>, <pos>a.</pos>
<fld>(Biol.)</fld> <def>Relating to bacterioscopy; <as>as, a
<ex>bacterioscopic</ex> examination</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bacterioscopist</ent><br/
<hw>Bac*te`ri*os"co*pist</hw> <pr>(<?/)</pr>, <pos>n.</pos>
<fld>(Biol.)</fld> <def>One skilled in bacterioscopic
examinations.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bacterioscopy</ent><br/
<hw>Bac*te`ri*os"co*py</hw>
<pr>(b<acr/k*t<emac/`r<icr/*<ocr/s"k<osl/*p<ycr/)</pr>, <pos>n.</pos>
<ety>[<ets>Bacterium</ets> + <ets>-scopy</ets>; fr. Gr.
<grk>bakth`rion</grk>, <grk>ba`ktron</grk>, a staff +
<grk>skopei^n</grk> to view.]</ety> <fld>(Biol.)</fld> <sn>1.</sn>
<def>The application of a knowledge of bacteria for their detection and
identification, as in the examination of polluted water.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Microscopic examination or investigation of
bacteria.</def> -- <wordforms><wf>Bac*te`ri*o*scop"ic</wf> <pr>(#)</pr>,
<pos>a.</pos> -- <wf>*scop"ic*al*ly</wf> <pr>(#)</pr>, <pos>adv.</pos>
-- <wf>Bac*te`ri*os"co*pist</wf> <pr>(#)</pr>,
<pos>n.</pos></wordforms><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>bacteriostasis</ent><br/
<hw>bacteriostasis</hw> <pos>n.</pos> <def>inhibition of the growth of
bacteria, without outright killing of the organism.</def><br/
[<source>WordNet 1.5</source> <source>+PJC</source>]</p>

<p><ent>bacteriostat</ent><br/
<hw>bacteriostat</hw> <pos>n.</pos> <def>a chemical or biological
material that inhibits bacterial growth.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>bacteriostatic</ent><br/
<hw>bacteriostatic</hw> <pos>adj.</pos> <sn>1.</sn> <def>of or
pertaining to bacteriostasis or a bacteriostat.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><sn>2.</sn> <def>causing bacteriostasis; -- said of chemical
substances, such as certain antibacterial agents.</def><br/
[<source>PJC</source>]</p>

<p><note><hand/ Substances, such as antibiotics, which inhibit bacterial
growth are usually classified as bacteriostatic or bacteriocidal
depending on the rate at which bacteria exposed to the agents{4} die.
The rates of death of bacteria exposed to antibacterial agents{4} are,
however, dependent on the concentration of the agent{4}, and form a
continuum with some antibacterial agents{4} of intermediate type. The
penicillins are considered as typical bactericidal agents, and
chloramphenicol or the sulfa drugs as typical bacteriostatic agents. In
general, inhibitors of cell-wall synthesis will be bactericidal and many
inhibitors of protein synthesis are classed as bacteriostatic, but some
of the aminoglycosides also kill bacteria rapidly.</note><br/
[<source>PJC</source>]</p>

<p><ent>bacterise</ent><br/
<hw>bacterise</hw> <pos>v.</pos> <def>to subject to the action of
bacteria.</def><br/
<syn><b>Syn. --</b> bacterize.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Bacterium</ent><br/
<hw>Bac*te"ri*um</hw> <pr>(b<acr/k*t<emac/"r<icr/*<ucr/m)</pr>,
<pos>n.</pos>; <plu><it>pl.</it> <plw>Bacteria</plw>
<pr>(b<acr/k*t<emac/"r<icr/*<adot/)</pr>.</plu> <ety>[NL., fr. Gr.
<grk>bakth`rion</grk>, <grk>ba`ktron</grk>, a staff: cf. F.
<ets>bact<eacute/rie</ets>.]</ety> <fld>(Biol.)</fld> <def>A microscopic
single-celled organism having no distinguishable nucleus, belonging to
the kingdom Monera. Bacteria have varying shapes, usually taking the
form of a jointed rodlike filament, or a small sphere, but also in
certain cases having a branched form. Bacteria are destitute of
chlorophyll, but in those members of the phylum
<phylum>Cyanophyta</phylum> (the blue-green algae) other light-absorbing
pigments are present. They are the smallest of microscopic organisms
which have their own metabolic processes carried on within cell
membranes, viruses being smaller but not capable of living freely. The
bacteria are very widely diffused in nature, and multiply with marvelous
rapidity, both by fission and by spores. Bacteria may require oxygen for
their energy-producing metabolism, and these are called
<stype>aerobes</stype>; or may multiply in the absence of oxygen, these
forms being <stype>anaerobes</stype>. Certain species are active agents
in fermentation, while others appear to be the cause of certain
infectious diseases. The branch of science with studies bacteria is
<er>bacteriology</er>, being a division of <er>microbiology</er>. See
<er>Bacillus</er>.</def><br/
[<source>1913 Webster</source> <source>+PJC</source>]</p>

<p><ent>bacterize</ent><br/
<hw>bacterize</hw> <pos>v.</pos> <def>to subject to the action of
bacteria.</def><br/
<syn><b>Syn. --</b> bacterise.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Bacteroidal</ent><br/
<ent>Bacteroid</ent><br/
<mhw>{ <hw>Bac"te*roid</hw> <pr>(<?/)</pr>, <hw>Bac`te*roid"al</hw>
<pr>(<?/)</pr>, }</mhw> <pos>a.</pos> <ety>[<ets>Bacterium</ets> +
<ets>-oid</ets>.]</ety> <fld>(Biol.)</fld> <def>Resembling bacteria;
<as>as, <ex>bacteroid</ex> particles</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bactrian</ent><br/
<hw>Bac"tri*an</hw> <pr>(<?/)</pr>, <pos>a.</pos> <def>Of or pertaining
to Bactria in Asia.</def> -- <def2><pos>n.</pos> <def>A native of
Bactria.</def></def2><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Bactrian camel</b></col>, <cd>the two-humped
camel.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bacule</ent><br/
<hw>Bac"ule</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[F.]</ety>
<fld>(Fort.)</fld> <def>See <er>Bascule</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>baculiform</ent><br/
<hw>baculiform</hw> <pos>adj.</pos> <def>shaped like a rod.</def><br/
<syn><b>Syn. --</b> baccilar, bacillary, bacilliform,
rod-shaped.</syn><br/
[<source>WordNet 1.5</source> <source>+PJC</source>]</p>

<p><ent>Baculine</ent><br/
<hw>Bac"u*line</hw> <pr>(<?/)</pr>, <pos>a.</pos> <ety>[L.
<ets>baculum</ets> staff.]</ety> <def>Of or pertaining to the rod or
punishment with the rod.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baculite</ent><br/
<hw>Bac"u*lite</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[L.
<ets>baculum</ets> stick, staff; cf. F. <ets>baculite</ets>.]</ety>
<fld>(Paleon.)</fld> <def>A cephalopod of the extinct genus
<gen>Baculites</gen>, found fossil in the Cretaceous rocks. It is like
an uncoiled ammonite.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baculometry</ent><br/
<hw>Bac`u*lom"e*try</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[L.
<ets>baculum</ets> staff + <ets>-metry</ets>.]</ety> <def>Measurement of
distance or altitude by a staff or staffs.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bad</ent><br/
<hw>Bad</hw> <pr>(b<acr/d)</pr>, <pos>imp.</pos> <mord>of
<er>Bid</er>.</mord> <def>Bade.</def> <mark>[Obs.]</mark>
<rj><au>Dryden.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bad</ent><br/
<hw>Bad</hw> <pr>(b<acr/d)</pr>, <pos>a.</pos>
<amorph>[<pos>Compar.</pos> <adjf>Worse</adjf> <pr>(w<ucir/s)</pr>;
<pos>superl.</pos> <adjf>Worst</adjf> <pr>(w<ucir/st)</pr>.]</amorph>
<ety>[Probably fr. AS. <ets>b<ae/ddel</ets> hermaphrodite; cf.
<ets>b<ae/dling</ets> effeminate fellow.]</ety> <def>Wanting good
qualities, whether physical or moral; injurious, hurtful, inconvenient,
offensive, painful, unfavorable, or defective, either physically or
morally; evil; vicious; wicked; -- the opposite of <ant>good</ant>;
<as>as, a <ex>bad</ex> man; <ex>bad</ex> conduct; <ex>bad</ex> habits;
<ex>bad</ex> soil; <ex>bad</ex> air; <ex>bad</ex> health; a <ex>bad</ex>
crop; <ex>bad</ex> news</as>.</def><br/
<note> Sometimes used substantively.</note><br/
[<source>1913 Webster</source>]</p>

<p><q>The strong antipathy of good to <qex>bad</qex>.</q>
<rj><qau>Pope.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- Pernicious; deleterious; noxious; baneful;
injurious; hurtful; evil; vile; wretched; corrupt; wicked; vicious;
imperfect.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Badaud</ent><br/
\'d8<hw>Ba`daud"</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F.]</ety> <def>A
person given to idle observation of everything, with wonder or
astonishment; a credulous or gossipy idler.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>A host of stories . . . dealing chiefly with the subject of his
great wealth, an ever delightful topic to the <qex>badauds</qex> of
Paris.</q> <rj><qau>Pall Mall Mag.</qau></rj><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Badder</ent><br/
<hw>Bad"der</hw> <pr>(<?/)</pr>, <def><pos>compar.</pos> of
<er>Bad</er>, <pos>a.</pos></def> <mark>[Obs.]</mark>
<rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Badderlocks</ent><br/
<hw>Bad"der*locks</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[Perh. for
<ets>Balderlocks</ets>, fr. <ets>Balder</ets> the Scandinavian
deity.]</ety> <fld>(Bot.)</fld> <def>A large black seaweed (<spn>Alaria
esculenta</spn>) sometimes eaten in Europe; -- also called
<altname>murlins</altname>, <altname>honeyware</altname>, and
<altname>henware</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baddish</ent><br/
<hw>Bad"dish</hw>, <pos>a.</pos> <def>Somewhat bad; inferior.</def>
<rj><au>Jeffrey.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bade</ent><br/
<hw>Bade</hw> <pr>(b<acr/d)</pr>. <def>A form of the past tense of
<er>Bid</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Badge</ent><br/
<hw>Badge</hw> <pr>(b<acr/j)</pr>, <pos>n.</pos> <ety>[LL.
<ets>bagea</ets>, <ets>bagia</ets>, sign, prob. of German origin; cf.
AS. <ets>be<aacute/g</ets>, <ets>be<aacute/h</ets>, bracelet, collar,
crown, OS. <ets>b<omac/g-</ets> in comp., AS. <ets>b<umac/gan</ets> to
bow, bend, G. <ets>biegen</ets>. See <er>Bow</er> to bend.]</ety>
<sn>1.</sn> <def>A distinctive mark, token, sign, or cognizance, worn on
the person; <as>as, the <ex>badge</ex> of a society; the <ex>badge</ex>
of a policeman</as>.</def> <ldquo/Tax gatherers, recognized by their
official <xex>badges</xex>.<rdquo/ <rj><au>Prescott.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Something characteristic; a mark; a token.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Sweet mercy is nobility's true <qex>badge</qex>.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Naut.)</fld> <def>A carved ornament on the stern of
a vessel, containing a window or the representation of one.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Badge</ent><br/
<hw>Badge</hw> <pr>(b<acr/j)</pr>, <pos>v. t.</pos> <def>To mark or
distinguish with a badge.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Badgeless</ent><br/
<hw>Badge"less</hw>, <pos>a.</pos> <def>Having no badge.</def>
<rj><au>Bp. Hall.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Badger</ent><br/
<hw>Badg"er</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[Of uncertain
origin; perh. fr. an old verb <ets>badge</ets> to lay up provisions to
sell again.]</ety> <def>An itinerant licensed dealer in commodities used
for food; a hawker; a huckster; -- formerly applied especially to one
who bought grain in one place and sold it in another.</def> <mark>[Now
dialectic, Eng.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Badger</ent><br/
<hw>Badg"er</hw>, <pos>n.</pos> <ety>[OE. <ets>bageard</ets>, prob. fr.
<ets>badge</ets> + <ets>-ard</ets>, in reference to the white mark on
its forehead. See <er>Badge</er>,<pos>n.</pos>]</ety> <sn>1.</sn> <def>A
carnivorous quadruped of the genus <gen>Meles</gen> or of an allied
genus. It is a burrowing animal, with short, thick legs, and long claws
on the fore feet. One species (<spn>Meles meles</spn> <it>or</it>
<spn>Meles vulgaris</spn>), called also <altname>brock</altname>,
inhabits the north of Europe and Asia; another species (<spn>Taxidea
taxus</spn> <it>or</it> <spn>Taxidea Americana</spn> <it>or</it>
<spn>Taxidea Labradorica</spn>) inhabits the northern parts of North
America. See <er>Teledu</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A brush made of badgers' hair, used by
artists.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Badger dog</b></col>. <fld>(Zool.)</fld> <cd>See
<er>Dachshund</er>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Badger</ent><br/
<hw>Badg"er</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos>
<conjf>Badgered</conjf> <pr>(<?/)</pr>; <pos>p. pr. & vb. n.</pos>
<conjf>Badgering</conjf>.]</vmorph> <ety>[For sense 1, see 2d
<er>Badger</er>; for 2, see 1st <er>Badger</er>.]</ety> <sn>1.</sn>
<def>To tease or annoy, as a badger when baited; to worry or irritate
persistently.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To beat down; to cheapen; to barter; to
bargain.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Badgerer</ent><br/
<hw>Badg"er*er</hw> <pr>(<?/)</pr>, <pos>n.</pos> <sn>1.</sn> <def>One
who badgers.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A kind of dog used in badger baiting.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Badger game</ent><br/
<hw>Badg"er game</hw>. <def>The method of blackmailing by decoying a
person into a compromising situation and extorting money by threats of
exposure.</def> <mark>[Cant]</mark><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Badgering</ent><br/
<hw>Badg"er*ing</hw>, <pos>n.</pos> <sn>1.</sn> <def>The act of one who
badgers.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The practice of buying wheat and other kinds of food
in one place and selling them in another for a profit.</def>
<mark>[Prov. Eng.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Badger-legged</ent><br/
<hw>Badg"er-legged`</hw> <pr>(<?/)</pr>, <pos>a.</pos> <def>Having legs
of unequal length, as the badger was thought to have.</def>
<rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Badger State</ent><br/
<hw>Badger State</hw>. <def>Wisconsin; -- a nickname.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Badiaga</ent><br/
\'d8<hw>Bad`i*a"ga</hw> <pr>(b<acr/d`<icr/<amac/"g<adot/ <it>or</it>
b<adot/d*y<aum/"g<adot/)</pr>, <pos>n.</pos> <ety>[Russ.
<ets>badiaga</ets>.]</ety> <fld>(Zool.)</fld> <def>A fresh-water sponge
<gen>(Spongilla)</gen>, common in the north of Europe, the powder of
which is used to take away the livid marks of bruises.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Badian</ent><br/
\'d8<hw>Ba"di*an</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[F.
<ets>badiane</ets>, fr. Per. <ets>b<amac/di<amac/n</ets> anise.]</ety>
<fld>(Bot.)</fld> <def>An evergreen Chinese shrub of the Magnolia family
(<spn>Illicium anisatum</spn>), and its aromatic seeds; Chinese anise;
star anise.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Badigeon</ent><br/
<hw>Ba*di"geon</hw> <pr>(b<adot/*d<icr/j"<ucr/n)</pr>, <pos>n.</pos>
<ety>[F.]</ety> <def>A cement or distemper paste (as of plaster and
powdered freestone, or of sawdust and glue or lime) used by sculptors,
builders, and workers in wood or stone, to fill holes, cover defects,
finish a surface, etc.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Badinage</ent><br/
\'d8<hw>Ba`di`nage"</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[F., fr.
<ets>badiner</ets> to joke, OF. to trifle, be silly, fr.
<ets>badin</ets> silly.]</ety> <def>Playful raillery; banter.</def>
<ldquo/He . . . indulged himself only in an elegant
<xex>badinage</xex>.<rdquo/ <rj><au>Warburton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bad lands</ent><br/
<hw>Bad" lands"</hw> <pr>(<?/)</pr>. <def>Barren regions, especially in
the western United States, where horizontal strata (Tertiary deposits)
have been often eroded into fantastic forms, and much intersected by
ca<ntil/ons, and where lack of wood, water, and forage increases the
difficulty of traversing the country, whence the name, first given by
the Canadian French, <ets>Mauvaises Terres</ets> (bad lands).</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Badly</ent><br/
<hw>Bad"ly</hw>, <pos>adv.</pos> <def>In a bad manner; poorly; not well;
unskillfully; imperfectly; unfortunately; grievously; so as to cause
harm; disagreeably; seriously.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ <xex>Badly</xex> is often used colloquially for
<xex>very much</xex> or <xex>very greatly</xex>, with words signifying
<xex>to want</xex> or <xex>need</xex>.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Badminton</ent><br/
<hw>Bad"min*ton</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[From the name
of the seat of the Duke of Beaufort in England.]</ety> <sn>1.</sn>
<def>A game, similar to lawn tennis, played with shuttlecocks.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A preparation of claret, spiced and
sweetened.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Badness</ent><br/
<hw>Bad"ness</hw>, <pos>n.</pos> <def>The state of being bad.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baenomere</ent><br/
\'d8<hw>B<ae/"no*mere</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[Gr.
<grk>bai`nein</grk> to walk + <ets>-mere</ets>.]</ety>
<fld>(Zool.)</fld> <def>One of the somites (arthromeres) that make up
the thorax of Arthropods.</def> <rj><au>Packard.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baenopod</ent><br/
<hw>B<ae/"no*pod</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[Gr.
<grk>bai`nein</grk> to walk + <ets>-pod</ets>.]</ety> <fld>(Zool.)</fld>
<def>One of the thoracic legs of Arthropods.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baenosome</ent><br/
\'d8<hw>B<ae/"no*some</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[Gr.
<grk>bai`nein</grk> to walk + <ets>-some</ets> body.]</ety>
<fld>(Zool.)</fld> <def>The thorax of Arthropods.</def>
<rj><au>Packard.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baetulus</ent><br/
\'d8<hw>B<ae/"tu*lus</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu>pl.
<plw>B<ae/tuli</plw> <pr>(#)</pr></plu>. <ety>[L., fr. Gr.
<grk>bai`tylos</grk> a sacred meteorite.]</ety> <fld>(Antiq.)</fld>
<def>A meteorite, or similar rude stone artificially shaped, held sacred
or worshiped as of divine origin.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>All the evidence goes to prove that these menhirs are
<qex>b<ae/tuli</qex>, i. e., traditional and elementary images of the
deity.</q> <rj><qau>I. Gonino (Perrot & Chipiez).</qau></rj><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Baff</ent><br/
<hw>Baff</hw> <pr>(b<acr/f)</pr>, <pos>n.</pos> <sn>1.</sn> <def>A blow;
a stroke; thud.</def> <mark>[Scot.]</mark> <rj><au>H.
Miller.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <specif>specif.</specif> <fld>(Golf)</fld>, <def>a stroke
in which the sole of the club hits the ground and drives the ball
aloft.</def> <mark>[Scot. or Golf]</mark><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Baff</ent><br/
<hw>Baff</hw> <pr>(b<acr/f)</pr>, <pos>v. t. & i.</pos> <ety>[Scot.,
prob. imitative; cf. G. <ets>baff</ets>, interj. imitating the sound of
a shot.]</ety> <def>To strike; to beat; to make a baff.</def>
<mark>[Scot. or Golf]</mark><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Baffle</ent><br/
<hw>Baf"fle</hw> <pr>(b<acr/f"f'l)</pr>, <pos>v. t.</pos>
<vmorph>[<pos>imp. & p. p.</pos> <conjf>Baffled</conjf> (-f'ld); <pos>p.
pr. & vb. n.</pos> <conjf>Baffling</conjf>
<pr>(-fl<icr/ng)</pr>.]</vmorph> <ety>[Cf. Lowland Scotch
<ets>bauchle</ets> to treat contemptuously, <ets>bauch</ets> tasteless,
abashed, jaded, Icel. <ets>b<amac/gr</ets> uneasy, poor, or
<ets>b<amac/gr</ets>, n., struggle, <ets>b<ae/gja</ets> to push, treat
harshly, OF. <ets>beffler</ets>, <ets>beffer</ets>, to mock, deceive,
dial. G. <ets>b<aum/ppe</ets> mouth, <ets>beffen</ets> to bark,
chide.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>To cause to undergo a disgraceful punishment, as a
recreant knight.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>He by the heels him hung upon a tree,<br/
And <qex>baffled</qex> so, that all which passed by<br/
The picture of his punishment might see.</q>
<rj><qau>Spenser.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To check by shifts and turns; to elude; to
foil.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The art that <qex>baffles</qex> time's tyrannic claim.</q>
<rj><qau>Cowper.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To check by perplexing; to disconcert, frustrate, or
defeat; to thwart.</def> <ldquo/A <xex>baffled</xex> purpose.<rdquo/
<rj><au>De Quincey.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>A suitable scripture ready to repel and <qex>baffle</qex> them
all.</q> <rj><qau>South.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Calculations so difficult as to have <qex>baffled</qex>, until
within a . . . recent period, the most enlightened nations.</q>
<rj><qau>Prescott.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The mere intricacy of a question should not <qex>baffle</qex>
us.</q> <rj><qau>Locke.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Baffling wind</b></col> <fld>(Naut.)</fld>, <cd>one that
frequently shifts from one point to another.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- To balk; thwart; foil; frustrate;
defeat.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baffle</ent><br/
<hw>Baf"fle</hw>, <pos>v. i.</pos> <sn>1.</sn> <def>To practice
deceit.</def> <mark>[Obs.]</mark> <rj><au>Barrow.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To struggle against in vain; <as>as, a ship
<ex>baffles</ex> with the winds</as>.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baffle</ent><br/
<hw>Baf"fle</hw>, <pos>n.</pos> <sn>1.</sn> <def>A defeat by artifice,
shifts, and turns; discomfiture.</def> <mark>[R.]</mark> <ldquo/A
<xex>baffle</xex> to philosophy.<rdquo/ <rj><au>South.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Engin.)</fld> <sd>(a)</sd> <def>A deflector, as a
plate or wall, so arranged across a furnace or boiler flue as to mingle
the hot gases and deflect them against the substance to be heated.</def>
<sd>(b)</sd> <def>A grating or plate across a channel or pipe conveying
water, gas, or the like, by which the flow is rendered more uniform in
different parts of the cross section of the stream; -- used in measuring
the rate of flow, as by means of a weir.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><sn>2.</sn> <fld>(Coal Mining)</fld> <def>A lever for operating the
throttle valve of a winding engine.</def> <mark>[Local, U.
S.]</mark><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>baffled</ent><br/
<hw>baffled</hw> <pos>adj.</pos> <def>not understanding.</def><br/
<syn><b>Syn. --</b> uncomprehending.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><sn>2.</sn> <def>discouraged by failure to accomplish a goal and
uncertain how to proceed; -- used especially of feelings of defeat and
discouragement.</def><br/
<syn><b>Syn. --</b> balked, discomfited, discouraged,
frustrated.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Bafflement</ent><br/
<hw>Baf"fle*ment</hw> <pr>(b<acr/f"f'l*m<eit/nt)</pr>, <pos>n.</pos>
<def>The process or act of baffling, or of being baffled; frustration;
check.</def></p>

<p><ent>Baffler</ent><br/
<hw>Baf"fler</hw> <pr>(b<acr/f"fl<etil/r)</pr>, <pos>n.</pos> <def>One
who, or that which, baffles.</def><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 112 pr=SA --></p>

<p><ent>Baffling</ent><br/
<hw>Baf"fling</hw> <pr>(b<acr/f"fl<icr/ng)</pr>, <pos>a.</pos>
<def>Frustrating; discomfiting; disconcerting; <as>as, <ex>baffling</ex>
currents, winds, tasks</as>.</def> -- <wordforms><wf>Baff"ling*ly</wf>,
<pos>adv.</pos> -- <wf>Baff"ling*ness</wf>,
<pos>n.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baffy</ent><br/
<hw>Baff"y</hw> <pr>(b<adot/f"<ycr/)</pr>, <pos>n.</pos> <ety>[See
<er>Baff</er>, <pos>v. t.</pos>]</ety> <fld>(Golf)</fld> <def>A short
wooden club having a deeply concave face, seldom used.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Baft</ent><br/
<hw>Baft</hw> <pr>(b<acr/ft)</pr>. <pos>n.</pos> <def>Same as
<er>Bafta</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bafta</ent><br/
<hw>Baf"ta</hw> <pr>(b<acr/f"t<adot/)</pr>, <pos>n.</pos> <ety>[Cf. Per.
<ets>baft</ets> woven, wrought.]</ety> <def>A coarse stuff, usually of
cotton, originally made in India. Also, an imitation of this fabric made
for export.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bag</ent><br/
<hw>Bag</hw> <pr>(b<acr/g)</pr>, <pos>n.</pos> <ety>[OE.
<ets>bagge</ets>; cf. Icel. <ets>baggi</ets>, and also OF.
<ets>bague</ets>, bundle, LL. <ets>baga</ets>.]</ety> <sn>1.</sn> <def>A
sack or pouch, used for holding anything; <as>as, a <ex>bag</ex> of meal
or of money</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A sac, or dependent gland, in animal bodies,
containing some fluid or other substance; <as>as, the <ex>bag</ex> of
poison in the mouth of some serpents; the <ex>bag</ex> of a
cow</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>A sort of silken purse formerly tied about men's
hair behind, by way of ornament.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>The quantity of game bagged.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <fld>(Com.)</fld> <def>A certain quantity of a commodity,
such as it is customary to carry to market in a sack; <as>as, a
<ex>bag</ex> of pepper or hops; a <ex>bag</ex> of coffee</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Bag and baggage</b></col>, <cd>all that belongs to
one.</cd> -- <col><b>To give one the bag</b></col>, <cd>to disappoint
him.</cd> <mark>[Obs.]</mark> <rj><au>Bunyan.</au></rj></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bag</ent><br/
<hw>Bag</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos>
<conjf>Bagged</conjf> <pr>(b<acr/gd)</pr>; <pos>p. pr. & vb. n.</pos>
<conjf>Bagging</conjf>]</vmorph> <sn>1.</sn> <def>To put into a bag;
<as>as, to <ex>bag</ex> hops</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To seize, capture, or entrap; <as>as, to
<ex>bag</ex> an army; to <ex>bag</ex> game</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To furnish or load with a bag or with a well filled
bag.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>A bee <qex>bagged</qex> with his honeyed venom.</q>
<rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bag</ent><br/
<hw>Bag</hw>, <pos>v. i.</pos> <sn>1.</sn> <def>To swell or hang down
like a full bag; <as>as, the skin <ex>bags</ex> from containing morbid
matter</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To swell with arrogance.</def> <mark>[Obs.]</mark>
<rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To become pregnant.</def> <mark>[Obs.]</mark>
<rj><au>Warner. (Alb. Eng.).</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bagasse</ent><br/
\'d8<hw>Ba*gasse"</hw> <pr>(b<adot/*g<acr/s")</pr>, <pos>n.</pos>
<ety>[F.]</ety> <def>Sugar cane, as it comes crushed from the mill. It
is then dried and used as fuel. Also extended to the refuse of beetroot
sugar.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bagatelle</ent><br/
\'d8<hw>Bag`a*telle"</hw> <pr>(b<acr/g`<adot/*t<ecr/l")</pr>,
<pos>n.</pos> <ety>[F., fr. It. <ets>bagatella</ets>; cf. Prov. It.
<ets>bagata</ets> trifle, OF. <ets>bague</ets>, Pr. <ets>bagua</ets>,
bundle. See <er>Bag</er>, <pos>n.</pos>]</ety> <sn>1.</sn> <def>A
trifle; a thing of no importance.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Rich trifles, serious <qex>bagatelles</qex>.</q>
<rj><qau>Prior.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A game played on an oblong board, having, at one
end, cups or arches into or through which balls are to be driven by a
rod held in the hand of the player.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baghdad</ent><br/
<hw>Baghdad</hw> <pos>prop. n.</pos> <fld>(Geography)</fld> <def>The
capital <isa>city</isa> of <country>Iraq</country>. Population (2000) =
nk.</def><br/
[<source>PJC</source>]</p>

<p><ent>bagel</ent><br/
<hw>ba"gel</hw> <pr>(b<amac/"g'l)</pr>, <pos>n.</pos> <ety>[Yiddish
<ets>beygl</ets>, prob. fr. dial. G. <ets>Beugel</ets>.
<au>RHUD</au>]</ety> <def>a glazed leavened doughnut-shaped roll with a
hard crust.</def> <note>A similar roll in Russia is called a
<it>bublik</it>.</note><br/
[<source>WordNet 1.5</source> <source>+PJC</source>]</p>

<p><ent>bagful</ent><br/
<hw>bag"ful</hw> <pr>(b<acr/g"f<usdot/l)</pr>, <pos>n.</pos> <def>The
quantity that a bag will hold; <as>as, he ate a <ex>bagful</ex> of
popcorn</as>.</def><br/
<syn><b>Syn. --</b> bag.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>baggage</ent><br/
<hw>bag"gage</hw> <pr>(b<acr/g"g<asl/j)</pr>, <pos>n.</pos> <ety>[F.
<ets>bagage</ets>, from OF. <ets>bague</ets> bundle. In senses 6 and 7
cf. F. <ets>bagasse</ets> a prostitute. See <er>Bag</er>,
<pos>n.</pos>]</ety> <sn>1.</sn> <def>The clothes, tents, utensils, and
provisions of an army.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ <ldquo/The term itself is made to apply chiefly to
articles of clothing and to small personal effects.<rdquo/
<rj><au>Farrow.</au></rj></note><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The trunks, valises, satchels, etc., which a
traveler carries with him on a journey; luggage.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The baronet's <qex>baggage</qex> on the roof of the coach.</q>
<rj><qau>Thackeray.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>We saw our <qex>baggage</qex> following below.</q>
<rj><qau>Johnson.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ The English usually call this
<altname>luggage</altname>.</note><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Purulent matter.</def> <mark>[Obs.]</mark>
<rj><au>Barrough.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>Trashy talk.</def> <mark>[Obs.]</mark>
<rj><au>Ascham.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>A man of bad character.</def> <mark>[Obs.]</mark>
<rj><au>Holland.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <def>A woman of loose morals; a prostitute.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>A disreputable, daring, laughing, painted French
<qex>baggage</qex>.</q> <rj><qau>Thackeray.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>7.</sn> <def>A romping, saucy girl.</def> <mark>[Playful]</mark>
<rj><au>Goldsmith.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baggage master</ent><br/
<hw>Bag"gage mas`ter</hw> <pr>(<?/)</pr>. <def>One who has charge of the
baggage at a railway station or upon a line of public travel.</def>
<mark>[U.S.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baggager</ent><br/
<hw>Bag"ga*ger</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>One who takes
care of baggage; a camp follower.</def> <mark>[Obs.]</mark> <rj><au>Sir
W. Raleigh.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baggala</ent><br/
\'d8<hw>Bag"ga*la</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[Ar.
<ldquo/fem. of <ets>baghl</ets> a mule.<rdquo/ <au>Balfour</au>.]</ety>
<fld>(Naut.)</fld> <def>A two-masted Arab or Indian trading vessel, used
in the Indian Ocean.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baggily</ent><br/
<hw>Bag"gi*ly</hw> <pr>(<?/)</pr>, <pos>adv.</pos> <def>In a loose,
baggy way.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bagging</ent><br/
<hw>Bag"ging</hw>, <pos>n.</pos> <sn>1.</sn> <def>Cloth or other
material for bags.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The act of putting anything into, or as into, a
bag.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>The act of swelling; swelling.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bagging</ent><br/
<hw>Bag"ging</hw>, <pos>n.</pos> <ety>[Etymol. uncertain.]</ety>
<def>Reaping peas, beans, wheat, etc., with a chopping stroke.</def>
<mark>[Eng.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baggy</ent><br/
<hw>Bag"gy</hw> <pr>(<?/)</pr>, <pos>a.</pos> <def>Resembling a bag;
loose or puffed out, or pendent, like a bag; flabby; <as>as,
<ex>baggy</ex> trousers; <ex>baggy</ex> cheeks</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bag lady</ent><br/
<hw>Bag" la`dy</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>a homeless woman
who carries all her possessions with her in bags.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Bagman</ent><br/
<hw>Bag"man</hw> <pr>(<?/)</pr>, <pos>n.</pos>; <plu><it>pl.</it>
<plw>Bagmen</plw> <pr>(<?/)</pr>.</plu> <def>A commercial traveler; one
employed to solicit orders for manufacturers and tradesmen.</def>
<rj><au>Thackeray.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bag net</ent><br/
<hw>Bag" net`</hw> <pr>(b<acr/g" n<ecr/t`)</pr>, <pos>n.</pos> <def>A
bag-shaped net for catching fish.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bagnio</ent><br/
<hw>Bagn"io</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[It.
<ets>bagno</ets>, fr. L. <ets>balneum</ets>. Cf. <er>Bain</er>.]</ety>
<sn>1.</sn> <def>A house for bathing, sweating, etc.; -- also, in
Turkey, a prison for slaves.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A brothel; a stew; a house of
prostitution.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bagpipe</ent><br/
<hw>Bag"pipe</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>A musical wind
instrument, now used chiefly in the Highlands of Scotland.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ It consists of a leather bag, which receives the air by
a tube that is stopped by a valve; and three sounding pipes, into which
the air is pressed by the performer. Two of these pipes produce fixed
tones, namely, the bass, or key tone, and its fifth, and form together
what is called the <part>drone</part>; the third, or
<part>chanter</part>, gives the melody.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bagpipe</ent><br/
<hw>Bag"pipe</hw>, <pos>v. t.</pos> <def>To make to look like a
bagpipe.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>To bagpipe the mizzen</b></col> <fld>(Naut.)</fld>,
<cd>to lay it aback by bringing the sheet to the mizzen rigging.</cd>
<rj><au>Totten.</au></rj></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bagpiper</ent><br/
<hw>Bag"pip`er</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>One who plays on
a bagpipe; a piper.</def> <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bagreef</ent><br/
<hw>Bag"reef`</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[<ets>Bag</ets> +
<ets>reef</ets>.]</ety> <fld>(Naut.)</fld> <def>The lower reef of fore
and aft sails; also, the upper reef of topsails.</def> <rj><au>Ham. Nav.
Encyc.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bague</ent><br/
\'d8<hw>Bague</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[F., a ring]</ety>
<fld>(Arch.)</fld> <def>The annular molding or group of moldings
dividing a long shaft or clustered column into two or more
parts.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baguette</ent><br/
<ent>Baguet</ent><br/
<mhw>{ <hw>Ba*guet"</hw>, <hw>Ba*guette"</hw> }</mhw> <pr>(<?/)</pr>,
<pos>n.</pos> <ety>[F. <ets>baguette</ets>, prop. a rod<?/ It.
<ets>bacchetta</ets>, fr. L. <ets>baculum</ets> stick, staff.]</ety>
<sn>1.</sn> <fld>(Arch.)</fld> <def>A small molding, like the astragal,
but smaller; a bead.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Zool.)</fld> <def>One of the minute bodies seen in
the divided nucleoli of some Infusoria after conjugation.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bagwig</ent><br/
<hw>Bag"wig"</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>A wig, in use in
the 18th century, with the hair at the back of the head in a
bag.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bagworm</ent><br/
<hw>Bag"worm`</hw> <pr>(<?/)</pr>, <pos>n.</pos> <fld>(Zool.)</fld>
<def>One of several lepidopterous insects which construct, in the larval
state, a baglike case which they carry about for protection. One species
(<spn>Plat<oe/ceticus Gloveri</spn>) feeds on the orange tree. See
<er>Basket worm</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bah</ent><br/
<hw>Bah</hw> <pr>(<?/)</pr>, <pos>interj.</pos> <def>An exclamation
expressive of extreme contempt.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Twenty-five years ago the vile ejaculation, <qex>Bah</qex>! was
utterly unknown to the English public.</q> <rj><qau>De
Quincey.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bahaudur</ent><br/
<ent>Bahadur</ent><br/
<mhw>{ \'d8<hw>Ba*ha"dur</hw> \'d8<hw>Ba*hau"dur</hw> }</mhw>
<pr>(?)</pr>, <pos>n.</pos> <altsp>[Written also
<asp>bahawder</asp>.]</altsp> <ety>[Hind. <ets>bah<amac/dur</ets> hero,
champion.]</ety> <def>A title of respect or honor given to European
officers in East Indian state papers, and colloquially, and among the
natives, to distinguished officials and other important
personages.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Bahai</ent><br/
<hw>Ba*hai"</hw> <pr>(b<adot/*h<imac/")</pr>, <pos>n.</pos>; <plu>pl.
<er>Bahais</er> <pr>(-h<imac/z)</pr>.</plu> <def>A member of the sect of
the Babis consisting of the adherents of <persfn>Baha</persfn>
(<person>Mirza Husain Ali</person>, entitled <ldquo/Baha 'u
'llah,<rdquo/ or, <ldquo/the Splendor of God<rdquo/), the elder half
brother of <person>Mirza Yahya</person> of Nur, who succeeded the Bab as
the head of the Babists. <persfn>Baha</persfn> in 1863 declared himself
the supreme prophet of the sect, and became its recognized head. There
are upwards of 20,000 Bahais in the United States.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Bahaism</ent><br/
<hw>Ba*ha"ism</hw> <pr>(?)</pr>, <pos>n.</pos> <def>The religious tenets
or practices of the Bahais.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Bahar</ent><br/
\'d8<hw>Ba*har"</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[Ar.
<ets>bah<amac/r</ets>, from <ets>bahara</ets> to charge with a
load.]</ety> <def>A weight used in certain parts of the East Indies,
varying considerably in different localities, the range being from 223
to 625 pounds.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bahrain</ent><br/
<hw>Bahrain</hw> <pos>n.</pos> <sn>1.</sn> <def>an island in the Persian
Gulf.</def><br/
<syn><b>Syn. --</b> Bahrein.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><sn>2.</sn> <def>an island country in the Persian Gulf.</def><br/
<syn><b>Syn. --</b> Bahrein.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Bahraini</ent><br/
<hw>Bahraini</hw> <pos>n.</pos> <sn>1.</sn> <def>a native or inhabitant
of Bahrain.</def><br/
<syn><b>Syn. --</b> Bahreini.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Bahraini</ent><br/
<hw>Bahraini</hw> <pos>adj.</pos> <sn>1.</sn> <def>of or pertaining to
Bahrain (definition 2).</def> <illu>The <ex>Bahraini</ex> ruling
families</illu><br/
[<source>WordNet 1.5</source>]</p>

<p><sn>2.</sn> <def>of, pertaining to, or characteristic of
Bahrain.</def> <illu><ex>Bahraini</ex> beaches.</illu><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Bahrein</ent><br/
<hw>Bahrein</hw> <pos>n.</pos> <def>an island in the Persian Gulf; same
as <er>Bahrain</er>.</def><br/
<syn><b>Syn. --</b> Bahrain.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><sn>2.</sn> <def>an island country in the Persian Gulf.</def><br/
<syn><b>Syn. --</b> Bahrain.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Bahreini</ent><br/
<hw>Bahreini</hw> <pos>n.</pos> <def>a native or inhabitant of
Bahrain.</def><br/
<syn><b>Syn. --</b> Bahraini.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Baic</ent><br/
<ent>Bai</ent><br/
<mhw><hw>Bai</hw>, <hw>Baic</hw></mhw> <pos>n.</pos> <def>a language
spoken in the Dali region of Yunnan.</def><br/
<syn><b>Syn. --</b> Baic.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Baigne</ent><br/
<hw>Baigne</hw> <pr>(b<amac/n)</pr>, <pos>v. t.</pos> <ety>[F.
<ets>baigner</ets> to bathe, fr. L. <ets>balneum</ets> bath.]</ety>
<def>To soak or drench.</def> <mark>[Obs.]</mark>
<rj><qau>Carew.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baignoire</ent><br/
\'d8<hw>Bai`gnoire"</hw> <pr>(?)</pr>, <pos>n.</pos> <altsp>[Written
also <asp>baignoir</asp>.]</altsp> <ety>[F., lit., bath tub.]</ety>
<def>A box of the lowest tier in a theater.</def> <rj><au>Du
Maurier.</au></rj><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Bail</ent><br/
<hw>Bail</hw> <pr>(b<amac/l)</pr>, <pos>n.</pos> <ety>[F.
<ets>baille</ets> a bucket, pail; cf. LL. <ets>bacula</ets>, dim. of
<ets>bacca</ets> a sort of vessel. Cf. <er>Bac</er>.]</ety> <def>A
bucket or scoop used in bailing water out of a boat.</def>
<mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>The <qex>bail</qex> of a canoe . . . made of a human skull.</q>
<rj><qau>Capt. Cook.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bail</ent><br/
<hw>Bail</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos>
<conjf>Bailed</conjf> <pr>(b<amac/ld)</pr>; <pos>p. pr. & vb. n.</pos>
<conjf>Bailing</conjf>.]</vmorph> <sn>1.</sn> <def>To lade; to dip and
throw; -- usually with <xex>out</xex>; <as>as, to <ex>bail</ex> water
out of a boat</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Buckets . . . to <qex>bail</qex> out the water.</q> <rj><qau>Capt.
J. Smith.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To dip or lade water from; -- often with
<xex>out</xex> to express completeness; <as>as, to <ex>bail</ex> a
boat</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>By the help of a small bucket and our hats we <qex>bailed</qex>
her out.</q> <rj><qau>R. H. Dana, Jr.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bail</ent><br/
<hw>Bail</hw>, <pos>v. t.</pos> <ety>[OF. <ets>bailler</ets> to give, to
deliver, fr. L. <ets>bajulare</ets> to bear a burden, keep in custody,
fr. <ets>bajulus</ets> he who bears burdens.]</ety> <sn>1.</sn> <def>To
deliver; to release.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>Ne none there was to rescue her, ne none to <qex>bail</qex>.</q>
<rj><qau>Spenser.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Law)</fld> <sd>(a)</sd> <def>To set free, or
deliver from arrest, or out of custody, on the undertaking of some other
person or persons that he or they will be responsible for the
appearance, at a certain day and place, of the person bailed.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ The word is applied to the magistrate or the surety. The
magistrate <xex>bails</xex> (but <xex>admits to bail</xex> is commoner)
a man when he liberates him from arrest or imprisonment upon bond given
with sureties. The surety <xex>bails</xex> a person when he procures his
release from arrest by giving bond for his appearance.</note>
<rj><au>Blackstone.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sd>(b)</sd> <def>To deliver, as goods in trust, for some special
object or purpose, upon a contract, expressed or implied, that the trust
shall be faithfully executed on the part of the bailee, or person
intrusted; <as>as, to <ex>bail</ex> cloth to a tailor to be made into a
garment; to <ex>bail</ex> goods to a carrier</as>.</def>
<rj><au>Blackstone. Kent.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bail</ent><br/
<hw>Bail</hw>, <pos>n.</pos> <ety>[OF. <ets>bail</ets> guardian,
administrator, fr. L. <ets>bajulus</ets>. See <er>Bail</er> to
deliver.]</ety> <sn>1.</sn> <def>Custody; keeping.</def>
<mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>Silly Faunus now within their <qex>bail</qex>.</q>
<rj><qau>Spenser.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Law)</fld> <sd>(a)</sd> <def>The person or persons
who procure the release of a prisoner from the custody of the officer,
or from imprisonment, by becoming surety for his appearance in
court.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The <qex>bail</qex> must be real, substantial bondsmen.</q>
<rj><qau>Blackstone.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>A. and B. were <qex>bail</qex> to the arrest in a suit at law.</q>
<rj><qau>Kent.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sd>(b)</sd> <def>The security given for the appearance of a prisoner
in order to obtain his release from custody of the officer; <as>as, the
man is out on <ex>bail</ex>; to go <ex>bail</ex> for any
one</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Excessive <qex>bail</qex> ought not to be required.</q>
<rj><qau>Blackstone.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bail</ent><br/
<hw>Bail</hw>, <pos>n.</pos> <ety>[OE. <ets>beyl</ets>; cf. Dan.
<ets>b<oum/ile</ets> a bending, ring, hoop, Sw. <ets>b<oum/gel</ets>,
<ets>bygel</ets>, and Icel. <ets>beyla</ets> hump, swelling, akin to E.
<ets>bow</ets> to bend.]</ety> <sn>1.</sn> <def>The arched handle of a
kettle, pail, or similar vessel, usually movable.</def>
<rj><au>Forby.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A half hoop for supporting the cover of a carrier's
wagon, awning of a boat, etc.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bail</ent><br/
<hw>Bail</hw>, <pos>n.</pos> <ety>[OF. <ets>bail</ets>,
<ets>baille</ets>. See <er>Bailey</er>.]</ety> <sn>1.</sn> (Usually
<pluf>pl.</pluf>) <def>A line of palisades serving as an exterior
defense.</def> <altsp>[Written also <asp>bayle</asp>.]</altsp>
<mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The outer wall of a feudal castle. Hence: The space
inclosed by it; the outer court.</def> <rj><au>Holinshed.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>A certain limit within a forest.</def>
<mark>[Eng.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>A division for the stalls of an open
stable.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <fld>(Cricket)</fld> <def>The top or cross piece (or
either of the two cross pieces) of the wicket.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bailable</ent><br/
<hw>Bail"a*ble</hw> <pr>(<?/)</pr>, <pos>a.</pos> <sn>1.</sn>
<def>Having the right or privilege of being admitted to bail, upon bond
with sureties; -- used of persons.</def> <ldquo/He's
<xex>bailable</xex>, I'm sure.<rdquo/ <rj><au>Ford.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Admitting of bail; <as>as, a <ex>bailable</ex>
offense</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>That can be delivered in trust; <as>as,
<ex>bailable</ex> goods</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bail bond</ent><br/
<hw>Bail" bond`</hw> <pr>(b<amac/l" b<ocr/nd`)</pr>. <fld>(Law)</fld>
<sd>(a)</sd> <def>A bond or obligation given by a prisoner and his
surety, to insure the prisoner's appearance in court, at the return of
the writ.</def> <sd>(b)</sd> <def>Special bail in court to abide the
judgment.</def> <rj><au>Bouvier.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bailee</ent><br/
<hw>Bail`ee"</hw> <pr>(b<amac/l`<emac/")</pr>, <pos>n.</pos> <ety>[OF.
<ets>baill<eacute/</ets>, p. p. of <ets>bailler</ets>. See <er>Bail</er>
to deliver.]</ety> <fld>(Law)</fld> <def>The person to whom goods are
committed in trust, and who has a temporary possession and a qualified
property in them, for the purposes of the trust.</def>
<rj><au>Blackstone.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ In penal statutes the word includes those who receive
goods for another in good faith.</note> <rj><au>Wharton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bailer</ent><br/
<hw>Bail"er</hw> <pr>(<?/)</pr>, <pos>n.</pos> <fld>(Law)</fld> <def>See
<er>Bailor</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bailer</ent><br/
<hw>Bail"er</hw>, <pos>n.</pos> <sn>1.</sn> <def>One who bails or
lades.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A utensil, as a bucket or cup, used in bailing; a
machine for bailing water out of a pit.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bailey</ent><br/
<hw>Bai"ley</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[The same word as
<ets>bail</ets> line of palisades; cf. LL. <ets>ballium</ets> bailey,
OF. <ets>bail</ets>, <ets>baille</ets>, a palisade, <ets>baillier</ets>
to inclose, shut.]</ety> <sn>1.</sn> <def>The outer wall of a feudal
castle.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The space immediately within the outer wall of a
castle or fortress.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>A prison or court of justice; -- used in certain
proper names; <as>as, the <ex>Old Bailey</ex> in London; the <ex>New
Bailey</ex> in Manchester</as>.</def> <mark>[Eng.]</mark> <rj><au>Oxf.
Gloss.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bailie</ent><br/
<hw>Bail"ie</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[See
<er>Bailiff</er>.]</ety> <def>An officer in Scotland, whose office
formerly corresponded to that of sheriff, but now corresponds to that of
an English alderman.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bailiff</ent><br/
<hw>Bail"iff</hw> <pr>(b<amac/l"<icr/f)</pr>, <pos>n.</pos> <ety>[OF.
<ets>baillif</ets>, F. <ets>bailli</ets>, custodian, magistrate, fr. L.
<ets>bajulus</ets> porter. See <er>Bail</er> to deliver.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>Originally, a person put in charge of something;
especially, a chief officer, magistrate, or keeper, as of a county,
town, hundred, or castle; one to whom powers of custody or care are
intrusted.</def> <rj><au>Abbott.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Lausanne is under the canton of Berne, governed by a
<qex>bailiff</qex> sent every three years from the senate.</q>
<rj><qau>Addison.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Eng. Law)</fld> <def>A sheriff's deputy, appointed
to make arrests, collect fines, summon juries, etc.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ In American law the term <xex>bailiff</xex> is seldom
used except sometimes to signify a sheriff's officer or constable, or a
party liable to account to another for the rent and profits of real
estate.</note> <rj><au>Burrill.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>An overseer or under steward of an estate, who
directs husbandry operations, collects rents, etc.</def>
<mark>[Eng.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bailiffwick</ent><br/
<hw>Bail"iff*wick</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>See
<er>Bailiwick</er>.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bailiwick</ent><br/
<hw>Bail"i*wick</hw> <pr>(<?/)</pr>, <pos>n.</pos>
<ety>[<ets>Bailie</ets>, <ets>bailiff</ets> + <ets>wick</ets> a
village.]</ety> <fld>(Law)</fld> <def>The precincts within which a
bailiff has jurisdiction; the limits of a bailiff's authority.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baillie</ent><br/
<hw>Bail"lie</hw> <pr>(<?/)</pr>, <pos>n.</pos> <sn>1.</sn>
<def>Bailiff.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Same as <er>Bailie</er>.</def>
<mark>[Scot.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bailment</ent><br/
<hw>Bail"ment</hw> <pr>(<?/)</pr>, <pos>n.</pos> <sn>1.</sn>
<fld>(Law)</fld> <def>The action of bailing a person accused.</def><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>Bailment</qex> . . . is the saving or delivery of a man out
of prison before he hath satisfied the law.</q>
<rj><qau>Dalton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Law)</fld> <def>A delivery of goods or money by one
person to another in trust, for some special purpose, upon a contract,
expressed or implied, that the trust shall be faithfully executed.</def>
<rj><au>Blackstone.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ In a general sense it is sometimes used as comprehending
all duties in respect to property.</note> <rj><au>Story.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bailor</ent><br/
<hw>Bail`or"</hw> <pr>(<?/)</pr>, <pos>n.</pos> <fld>(Law)</fld>
<def>One who delivers goods or money to another in trust.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bailpiece</ent><br/
<hw>Bail"piece`</hw> <pr>(<?/)</pr>, <pos>n.</pos> <fld>(Law)</fld>
<def>A piece of parchment, or paper, containing a recognizance or bail
bond.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baily's beads</ent><br/
<hw>Bai"ly's beads</hw> <pr>(?)</pr>. <fld>(Astron.)</fld> <def>A row of
bright spots observed in connection with total eclipses of the sun. Just
before and after a total eclipse, the slender, unobscured crescent of
the sun's disk appears momentarily like a row of bright spots resembling
a string of beads. The phenomenon (first fully described by Francis
Baily, 1774 -- 1844) is thought to be an effect of irradiation, and of
inequalities of the moon's edge.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Bain</ent><br/
<hw>Bain</hw> <pr>(b<amac/n; as F., b<acr/N)</pr>, <pos>n.</pos>
<ety>[F. <ets>bain</ets>, fr. L. <ets>balneum</ets>. Cf.
<er>Bagnio</er>.]</ety> <def>A bath; a bagnio.</def> <mark>[Obs.]</mark>
<rj><au>Holland.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bain-marie</ent><br/
\'d8<hw>Bain`-ma`rie"</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[F.]</ety>
<def>A vessel for holding hot water in which another vessel may be
heated without scorching its contents; -- used for warming or preparing
food or pharmaceutical preparations.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bairam</ent><br/
<hw>Bai*ram"</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Turk.
<ets>ba<ium/r<amac/m</ets>.]</ety> <def>Either of two Muslim festivals,
of which one (the <stype>Lesser Bairam</stype>) is held at the close of
the fast called Ramadan, and the other (the <stype>Greater
Bairam</stype>) seventy days after the fast.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Bairn</ent><br/
<hw>Bairn</hw> <pr>(b<acir/rn)</pr>, <pos>n.</pos> <ety>[Scot.
<ets>bairn</ets>, AS. <ets>bearn</ets>, fr. <ets>beran</ets> to bear;
akin to Icel., OS., & Goth. <ets>barn</ets>. See <er>Bear</er> to
support.]</ety> <def>A child.</def> <mark>[Scot. & Prov.
Eng.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>Has he not well provided for the <qex>bairn</qex>?</q>
<rj><qau>Beau. & Fl.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baisemains</ent><br/
<hw>Baise"mains`</hw> <pr>(<?/)</pr>, <pos>n. pl.</pos> <ety>[F., fr.
<ets>baiser</ets> to kiss + <ets>mains</ets> hands.]</ety>
<def>Respects; compliments.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bait</ent><br/
<hw>Bait</hw> <pr>(b<amac/t)</pr>, <pos>n.</pos> <ety>[Icel.
<ets>beita</ets> food, <ets>beit</ets> pasture, akin to AS.
<ets>b<amac/t</ets> food, Sw. <ets>bete</ets>. See <er>Bait</er>,
<pos>v. t.</pos>]</ety> <sn>1.</sn> <def>Any substance, esp. food, used
in catching fish, or other animals, by alluring them to a hook, snare,
inclosure, or net.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Anything which allures; a lure; enticement;
temptation.</def> <rj><au>Fairfax.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>A portion of food or drink, as a refreshment taken
on a journey; also, a stop for rest and refreshment.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>A light or hasty luncheon.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Bait bug</b></col> <fld>(Zool.)</fld>, <cd>a crustacean
of the genus <gen>Hippa</gen> found burrowing in sandy beaches. See
<er>Anomura</er>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bait</ent><br/
<hw>Bait</hw> <pr>(b<amac/t)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. &
p. p.</pos> <conjf>Baited</conjf>; <pos>p. pr. & vb. n.</pos>
<conjf>Baiting</conjf>.]</vmorph> <ety>[OE. <ets>baiten</ets>,
<ets>beit<emac/n</ets>, to feed, harass, fr. Icel. <ets>beita</ets>,
orig., to cause to bite, fr. <ets>b<imac/ta</ets>. <root/87. See
<er>Bite</er>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>To provoke and harass; esp., to harass or torment
for sport; <as>as, to <ex>bait</ex> a bear with dogs; to <ex>bait</ex> a
bull</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To give a portion of food and drink to, upon the
road; <as>as, to <ex>bait</ex> horses</as>.</def>
<rj><au>Holland.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To furnish or cover with bait, as a trap or
hook.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>A crooked pin . . . <qex>baited</qex> with a vile earthworm.</q>
<rj><qau>W. Irving.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bait</ent><br/
<hw>Bait</hw> <pr>(b<amac/t)</pr>, <pos>v. i.</pos> <def>To stop to take
a portion of food and drink for refreshment of one's self or one's
beasts, on a journey.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Evil news rides post, while good news <qex>baits</qex>.</q>
<rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>My lord's coach conveyed me to Bury, and thence <qex>baiting</qex>
at Newmarket.</q> <rj><qau>Evelyn.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bait</ent><br/
<hw>Bait</hw> <pr>(b<amac/t)</pr>, <pos>v. i.</pos> <ety>[F. <ets>battre
de l'aile</ets> (or <ets>des ailes</ets>), to flap or flutter. See
<er>Batter</er>, <pos>v. t.</pos>]</ety> <def>To flap the wings; to
flutter as if to fly; or to hover, as a hawk when she stoops to her
prey.</def> <ldquo/Kites that <xex>bait</xex> and beat.<rdquo/
<rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baiter</ent><br/
<hw>Bait"er</hw> <pr>(b<amac/t"<etil/r)</pr>, <pos>n.</pos> <def>One who
baits; a tormentor.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>baiting</ent><br/
<hw>baiting</hw> <pr>(b<amac/t"<icr/ng)</pr>, <pos>n.</pos>
<def>harassment, especially of a tethered animal.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Baize</ent><br/
<hw>Baize</hw> <pr>(b<amac/z)</pr>, <pos>n.</pos> <ety>[For
<ets>bayes</ets>, pl. fr. OF. <ets>baie</ets>; cf. F. <ets>bai</ets>
bay-colored. See <er>Bay</er> a color.]</ety> <def>A coarse woolen stuff
with a long nap; -- usually dyed in plain colors.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>A new black <qex>baize</qex> waistcoat lined with silk.</q>
<rj><qau>Pepys.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bajocco</ent><br/
\'d8<hw>Ba*joc"co</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[It., fr.
<ets>bajo</ets> brown, bay, from its color.]</ety> <def>A small copper
coin formerly current in the Roman States, worth about a cent and a
half.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bake</ent><br/
<hw>Bake</hw> <pr>(b<amac/k)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. &
p. p.</pos> <conjf>Baked</conjf> <pr>(b<amac/kt)</pr>; <pos>p. pr. & vb.
n.</pos> <conjf>Baking</conjf>.]</vmorph> <ety>[AS. <ets>bacan</ets>;
akin to D. <ets>bakken</ets>, OHG. <ets>bacchan</ets>, G.
<ets>backen</ets>, Icel. & Sw. <ets>baka</ets>, Dan. <ets>bage</ets>,
Gr. <grk>fw`gein</grk> to roast.]</ety> <sn>1.</sn> <def>To prepare, as
food, by cooking in a dry heat, either in an oven or under coals, or on
heated stone or metal; <as>as, to <ex>bake</ex> bread, meat,
apples</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ <xex>Baking</xex> is the term usually applied to that
method of cooking which exhausts the moisture in food more than roasting
or broiling; but the distinction of meaning between roasting and baking
is not always observed.</note><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To dry or harden (anything) by subjecting to heat,
<as>as, to <ex>bake</ex> bricks; the sun <ex>bakes</ex> the
ground</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To harden by cold.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The earth . . . is <qex>baked</qex> with frost.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>They <qex>bake</qex> their sides upon the cold, hard stone.</q>
<rj><qau>Spenser.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bake</ent><br/
<hw>Bake</hw>, <pos>v. i.</pos> <sn>1.</sn> <def>To do the work of
baking something; <as>as, she brews, washes, and
<ex>bakes</ex></as>.</def> <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To be baked; to become dry and hard in heat; <as>as,
the bread <ex>bakes</ex>; the ground <ex>bakes</ex> in the hot
sun</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bake</ent><br/
<hw>Bake</hw>, <pos>n.</pos> <def>The process, or result, of
baking.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>baked</ent><br/
<hw>baked</hw> <pr>(b<amac/kt)</pr>, <pos>adj.</pos> <sn>2.</sn>
<def>dried out by heat or excessive exposure to sunlight.</def><br/
<syn><b>Syn. --</b> adust, parched, scorched, sunbaked.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><sn>2.</sn> <def>cooked with dry heat in an oven; -- of bread and
pastries.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Bakehouse</ent><br/
<hw>Bake"house`</hw> <pr>(b<amac/k"hous`)</pr>, <pos>n.</pos> <ety>[AS.
<ets>b<ae/ch<umac/s</ets>. See <er>Bake</er>, <pos>v. t.</pos>, and
<er>House</er>.]</ety> <def>A house for baking; a bakery.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bakelite</ent><br/
<hw>Bakelite</hw> <pos>n.</pos> <def>a thermosetting plastic used in
electric insulators and for making plastic ware and telephone receivers
etc.</def> <mark>[trademark]</mark> <br/
[<source>WordNet 1.5</source>]</p>

<p><-- p. 113 pr=SA --></p>

<p><ent>Baked-meat</ent><br/
<ent>Bakemeat</ent><br/
<mhw>{ <hw>Bake"meat`</hw> <pr>(b<amac/k"m<emac/t`)</pr>,
<hw>Baked"-meat`</hw> <pr>(b<amac/kt"-)</pr>, }</mhw> <pos>n.</pos>
<def>A pie; baked food.</def> <mark>[Obs.]</mark> <rj><au>Gen. xl.
17.</au> <au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baken</ent><br/
<hw>Bak"en</hw> <pr>(<?/)</pr>, <def><pos>p. p.</pos> of
<er>Bake</er>.</def> <mark>[Obs. or Archaic]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baker</ent><br/
<hw>Bak"er</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[AS.
<ets>b<ae/cere</ets>. See <er>Bake</er>, <pos>v. t.</pos>]</ety>
<sn>1.</sn> <def>One whose business it is to bake bread, biscuit,
etc.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A portable oven in which baking is done.</def>
<mark>[U.S.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>A baker's dozen</b></col>, <cd>thirteen.</cd> --
<col><b>Baker foot</b></col>, <cd>a distorted foot.</cd>
<mark>[Obs.]</mark> <au>Jer. Taylor.</au> -- <col><b>Baker's
itch</b></col>, <cd>a rash on the back of the hand, caused by the
irritating properties of yeast.</cd> -- <col><b>Baker's salt</b></col>,
<cd>the subcarbonate of ammonia, sometimes used instead of soda, in
making bread.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baker-legged</ent><br/
<hw>Bak"er-legged`</hw> <pr>(<?/)</pr>, <pos>a.</pos> <def>Having legs
that bend inward at the knees.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bakery</ent><br/
<hw>Bak"er*y</hw> <pr>(<?/)</pr>, <pos>n.</pos> <sn>1.</sn> <def>The
trade of a baker.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A place for baking bread; a bakehouse.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baking</ent><br/
<hw>Bak"ing</hw>, <pos>n.</pos> <sn>1.</sn> <def>The act or process of
cooking in an oven, or of drying and hardening by heat or
cold.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The quantity baked at once; a batch; <as>as, a
<ex>baking</ex> of bread</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Baking powder</b></col>, <cd>a substitute for yeast,
usually consisting of an acid, a carbonate, and a little farinaceous
matter.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bakingly</ent><br/
<hw>Bak"ing*ly</hw>, <pos>adv.</pos> <def>In a hot or baking
manner.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bakistre</ent><br/
<hw>Bak"is*tre</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[See
<er>Baxter</er>.]</ety> <def>A baker.</def> <mark>[Obs.]</mark>
<rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bakshish</ent><br/
<ent>Baksheesh</ent><br/
<mhw>{ \'d8<hw>Bak"sheesh`</hw>, <hw>Bak"shish`</hw> }</mhw>
<pr>(<?/)</pr>, <pos>n.</pos> <def>Same as
<er>Backsheesh</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>baksheesh</ent><br/
<hw>baksheesh</hw> <pos>n.</pos> <sn>1.</sn> <def>A relatively small
amount of money given for services rendered (as by a waiter). Same as
<er>Backsheesh</er>.</def><br/
<syn><b>Syn. --</b> gratuity, tip, bakshish, bakshis,
backsheesh.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>bakshis</ent><br/
<hw>bakshis</hw> <pos>n.</pos> <sn>1.</sn> <def>A relatively small
amount of money given for services rendered (as by a waiter). Same as
<er>Backsheesh</er>.</def><br/
<syn><b>Syn. --</b> gratuity, tip, baksheesh, bakshish,
backsheesh.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>bakshish</ent><br/
<hw>bakshish</hw> <pos>n.</pos> <sn>1.</sn> <def>A relatively small
amount of money given for services rendered (as by a waiter). Same as
<er>Backsheesh</er>.</def><br/
<syn><b>Syn. --</b> gratuity, tip, baksheesh, bakshis,
backsheesh.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Baku</ent><br/
<hw>Baku</hw> <pos>prop. n.</pos> <fld>(Geography)</fld> <def>The
capital <isa>city</isa> of <country>Azerbaijan</country>. Population
(2000) = 1,713,300.</def><br/
[<source>PJC</source>]</p>

<p><ent>Balaam</ent><br/
<hw>Ba"laam</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>A paragraph
describing something wonderful, used to fill out a newspaper column; --
an allusion to the miracle of Balaam's ass speaking.</def> <au>Numb.
xxii. 30.</au> <mark>[Cant]</mark><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Balaam basket or box</b></col> <fld>(Print.)</fld>,
<cd>the receptacle for rejected articles.</cd> <rj><au>Blackw.
Mag.</au></rj></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Balachong</ent><br/
\'d8<hw>Bal"a*chong</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[Malay
<ets>b<amac/lach<amac/n</ets>.]</ety> <def>A condiment formed of small
fishes or shrimps, pounded up with salt and spices, and then dried. It
is much esteemed in China.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>balaclava</ent><br/
<hw>balaclava</hw> <pos>n.</pos> <def>close-fitting and woolen and
covers all of the head but the face.</def><br/
<syn><b>Syn. --</b> balaclava helmet.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Balaena</ent><br/
<hw>Balaena</hw> <pos>n.</pos> <def>type genus of the Balaenidae:
Greenland whales.</def><br/
<syn><b>Syn. --</b> genus Balaena.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Balaeniceps</ent><br/
<hw>Balaeniceps</hw> <pos>n.</pos> <def>type genus of the
Balaenicipitidae: shoebills.</def><br/
<syn><b>Syn. --</b> genus Balaeniceps.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Balaenicipitidae</ent><br/
<hw>Balaenicipitidae</hw> <pos>n.</pos> <def>a family comprising the
shoebills.</def><br/
<syn><b>Syn. --</b> family Balaenicipitidae.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Balaenidae</ent><br/
<hw>Balaenidae</hw> <pos>n.</pos> <def>a family comprising the right
whales.</def><br/
<syn><b>Syn. --</b> family Balaenidae.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Balaenoidea</ent><br/
\'d8<hw>Bal`<ae/*noi"de*a</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[NL.,
from L. <ets>balaena</ets> whale + <ets>-oid</ets>.]</ety>
<fld>(Zool.)</fld> <def>A division of the Cetacea, including the right
whale and all other whales having the mouth fringed with baleen. See
<er>Baleen</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Balaenoptera</ent><br/
<hw>Balaenoptera</hw> <pos>n.</pos> <def>the type genus of the
Balaenopteridae.</def><br/
<syn><b>Syn. --</b> genus Balaenoptera.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Balaenopteridae</ent><br/
<hw>Balaenopteridae</hw> <pos>n.</pos> <sn>1.</sn> <def>rorquals; blue
whales.</def><br/
<syn><b>Syn. --</b> family Balaenopteridae.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>balalaika</ent><br/
<hw>balalaika</hw> <pos>n.</pos> <ety>[Russian.]</ety> <def>a stringed
instrument of Russian origin that has a triangular body and three
strings.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Balance</ent><br/
<hw>Bal"ance</hw> <pr>(b<acr/l"<ait/ns)</pr>, <pos>n.</pos> <ety>[OE.
<ets>balaunce</ets>, F. <ets>balance</ets>, fr. L. <ets>bilanx</ets>,
<ets>bilancis</ets>, having two scales; <ets>bis</ets> twice (akin to E.
<sig>two</sig>) + <ets>lanx</ets> plate, scale.]</ety> <sn>1.</sn>
<def>An apparatus for weighing.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ In its simplest form, a balance consists of a beam or
lever supported exactly in the middle, having two scales or basins of
equal weight suspended from its extremities. Another form is that of the
<xex>Roman balance</xex>, our steelyard, consisting of a lever or beam,
suspended near one of its extremities, on the longer arm of which a
counterpoise slides. The name is also given to other forms of apparatus
for weighing bodies, as to the combinations of levers making up platform
scales; and even to devices for weighing by the elasticity of a
spring.</note><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Act of weighing mentally; comparison;
estimate.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>A fair <qex>balance</qex> of the advantages on either side.</q>
<rj><qau>Atterbury.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Equipoise between the weights in opposite
scales.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>The state of being in equipoise; equilibrium; even
adjustment; steadiness.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>And hung a bottle on each side<br/
To make his <qex>balance</qex> true.</q> <rj><qau>Cowper.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The order and <qex>balance</qex> of the country were
destroyed.</q> <rj><qau>Buckle.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>English workmen completely lose their <qex>balance</qex>.</q>
<rj><qau>J. S. Mill.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>An equality between the sums total of the two sides
of an account; <as>as, to bring one's accounts to a
<ex>balance</ex></as>; -- also, the excess on either side; <as>as, the
<ex>balance</ex> of an account</as>.</def> <ldquo/A <xex>balance</xex>
at the banker's.<rdquo/ <rj><au>Thackeray.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>I still think the <qex>balance</qex> of probabilities leans
towards the account given in the text.</q> <rj><qau>J.
Peile.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <fld>(Horol.)</fld> <def>A balance wheel, as of a watch,
or clock. See <er>Balance wheel</er> (in the Vocabulary).</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>7.</sn> <fld>(Astron.)</fld> <sd>(a)</sd> <def>The constellation
<xex>Libra</xex>.</def> <sd>(b)</sd> <def>The seventh sign in the
Zodiac, called <xex>Libra</xex>, which the sun enters at the equinox in
September.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>8.</sn> <def>A movement in dancing. See <er>Balance</er>, <pos>v.
t.</pos>, 8.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Balance electrometer</b></col>, <cd>a kind of balance,
with a poised beam, which indicates, by weights suspended from one arm,
the mutual attraction of oppositely electrified surfaces.</cd>
<au>Knight.</au> -- <col><b>Balance fish</b></col>. <fld>(Zool.)</fld>
<cd>See <er>Hammerhead</er>.</cd> -- <col><b>Balance knife</b></col>,
<cd>a carving or table knife the handle of which overbalances the blade,
and so keeps it from contact with the table.</cd> -- <col><b>Balance of
power</b></col> <fld>(Politics)</fld>, <cd>such an adjustment of power
among sovereign states that no one state is in a position to interfere
with the independence of the others; international equilibrium; also,
the ability (of a state or a third party within a state) to control the
relations between sovereign states or between dominant parties in a
state.</cd> -- <col><b>Balance sheet</b></col> <fld>(Bookkeeping)</fld>,
<cd>a paper showing the balances of the open accounts of a business, the
debit and credit balances footing up equally, if the system of accounts
be complete and the balances correctly taken.</cd> -- <col><b>Balance
thermometer</b></col>, <cd>a thermometer mounted as a balance so that
the movement of the mercurial column changes the inclination of the
tube. With the aid of electrical or mechanical devices adapted to it, it
is used for the automatic regulation of the temperature of rooms warmed
artificially, and as a fire alarm.</cd> -- <col><b>Balance of
torsion</b></col>. <cd>See <er>Torsion Balance</er>.</cd> --
<col><b>Balance of trade</b></col> <fld>(Pol. Econ.)</fld>, <cd>an
equilibrium between the money values of the exports and imports of a
country; or more commonly, the amount required on one side or the other
to make such an equilibrium.</cd> -- <col><b>Balance valve</b></col>,
<cd>a valve whose surfaces are so arranged that the fluid pressure
tending to seat, and that tending to unseat, the valve, are nearly in
equilibrium; esp., a puppet valve which is made to operate easily by the
admission of steam to both sides. See <er>Puppet valve</er>.</cd> --
<col><b>Hydrostatic balance</b></col>. <cd>See under
<er>Hydrostatic</er>.</cd> -- <col><b>To lay in balance</b></col>,
<cd>to put up as a pledge or security.</cd> <mark>[Obs.]</mark>
<au>Chaucer.</au> -- <col><b>To strike a balance</b></col>, <cd>to find
out the difference between the debit and credit sides of an
account.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Balance</ent><br/
<hw>Bal"ance</hw> <pr>(b<acr/l"<ait/ns)</pr>, <pos>v. t.</pos>
<vmorph>[<pos>imp. & p. p.</pos> <conjf>Balanced</conjf>
<pr>(b<acr/l"<ait/nst)</pr>; <pos>p. pr. & vb. n.</pos>
<conjf>Balancing</conjf> <pr>(b<acr/l"<ait/n*s<icr/ng)</pr>.]</vmorph>
<ety>[From <er>Balance</er>, <pos>n.</pos>: cf. F.
<ets>balancer</ets>.]</ety> <sn>1.</sn> <def>To bring to an equipoise,
as the scales of a balance by adjusting the weights; to weigh in a
balance.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To support on a narrow base, so as to keep from
falling; <as>as, to <ex>balance</ex> a plate on the end of a cane; to
<ex>balance</ex> one's self on a tight rope</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To equal in number, weight, force, or proportion; to
counterpoise, counterbalance, counteract, or neutralize.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>One expression . . . must check and <qex>balance</qex>
another.</q> <rj><qau>Kent.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>To compare in relative force, importance, value,
etc.; to estimate.</def><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>Balance</qex> the good and evil of things.</q>
<rj><qau>L'Estrange.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>To settle and adjust, as an account; to make two
accounts equal by paying the difference between them.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>I am very well satisfied that it is not in my power to
<qex>balance</qex> accounts with my Maker.</q>
<rj><qau>Addison.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <def>To make the sums of the debits and credits of an
account equal; -- said of an item; <as>as, this payment, or credit,
<ex>balances</ex> the account</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>7.</sn> <def>To arrange accounts in such a way that the sum total
of the debits is equal to the sum total of the credits; <as>as, to
<ex>balance</ex> a set of books</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>8.</sn> <fld>(Dancing)</fld> <def>To move toward, and then back
from, reciprocally; <as>as, to <ex>balance</ex> partners</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>9.</sn> <fld>(Naut.)</fld> <def>To contract, as a sail, into a
narrower compass; <as>as, to <ex>balance</ex> the boom
mainsail</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Balanced valve</b></col>. <cd>See <er>Balance valve</er>,
under <er>Balance</er>, <pos>n.</pos></cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- To poise; weigh; adjust; counteract; neutralize;
equalize.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Balance</ent><br/
<hw>Bal"ance</hw>, <pos>v. i.</pos> <sn>1.</sn> <def>To have equal
weight on each side; to be in equipoise; <as>as, the scales
<ex>balance</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To fluctuate between motives which appear of equal
force; to waver; to hesitate.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>He would not <qex>balance</qex> or err in the determination of his
choice.</q> <rj><qau>Locke.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Dancing)</fld> <def>To move toward a person or
couple, and then back.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Balanceable</ent><br/
<hw>Bal"ance*a*ble</hw> <pr>(<?/)</pr>, <pos>a.</pos> <def>Such as can
be balanced.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>balanced</ent><br/
<hw>bal"anced</hw> <pos>adj.</pos> <def>being in a state of proper
balance or equilibrium; -- opposite of <ant>unbalanced</ant>.</def>
<illu>the carefully <ex>balanced</ex> seesaw</illu> <illu>a properly
<ex>balanced</ex> symphony orchestra</illu> <illu>a <ex>balanced</ex>
assessment of intellectual and cultural history</illu> <illu>a
<ex>balanced</ex> blend of whiskeys</illu> <illu>the educated man shows
a <ex>balanced</ex> development of all his powers</illu> [Narrower
terms: <stype>counterbalanced, counter-balanced, counterpoised</stype>;
<stype>well-balanced</stype>; <stype>poised</stype>] [Related terms:
<hascons>stable --- (maintaining equilibrium)</hascons>]<br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Balancement</ent><br/
<hw>Bal"ance*ment</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>The act or
result of balancing or adjusting; equipoise; even adjustment of
forces.</def> <mark>[R.]</mark> <rj><au>Darwin.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Balancer</ent><br/
<hw>Bal"an*cer</hw> <pr>(<?/)</pr>, <pos>n.</pos> <sn>1.</sn> <def>One
who balances, or uses a balance.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Zool.)</fld> <def>In Diptera, the rudimentary
posterior wing.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Balancereef</ent><br/
<hw>Bal"ance*reef`</hw> <pr>(<?/)</pr>, <pos>n.</pos> <fld>(Naut.)</fld>
<def>The last reef in a fore-and-aft sail, taken to steady the
ship.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Balance wheel</ent><br/
<hw>Bal"ance wheel`</hw> <pr>(<?/)</pr>. <sn>1.</sn>
<fld>(Horology)</fld> <sd>(a)</sd> <def>A wheel which regulates the
beats or pulses of a watch or chronometer, answering to the pendulum of
a clock; -- often called simply a <altname>balance</altname>.</def>
<sd>(b)</sd> <def>A ratchet-shaped scape wheel, which in some watches is
acted upon by the axis of the balance wheel proper (in those watches
called a <xex>balance</xex>).</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Mach.)</fld> <def>A wheel which imparts regularity
to the movements of any engine or machine; a fly wheel.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Balaniferous</ent><br/
<hw>Bal`a*nif"er*ous</hw> <pr>(<?/)</pr>, <pos>a.</pos> <ety>[L.
<ets>balanus</ets> acorn + <ets>-ferous</ets>.]</ety> <def>Bearing or
producing acorns.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Balanite</ent><br/
<hw>Bal"a*nite</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[L.
<ets>balanus</ets> acorn: cf. F. <ets>balanite</ets>.]</ety>
<fld>(Paleon.)</fld> <def>A fossil balanoid shell.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Balanoglossus</ent><br/
\'d8<hw>Bal`a*no*glos"sus</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[NL.,
fr. Gr. <grk>ba`lanos</grk> acorn + <grk>glw^ssa</grk> tongue.]</ety>
<fld>(Zool.)</fld> <def>A peculiar marine worm. See
<er>Enteropneusta</er>, and <er>Tornaria</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Balanoid</ent><br/
<hw>Bal"a*noid</hw> <pr>(<?/)</pr>, <pos>a.</pos> <ety>[Gr.
<grk>ba`lanos</grk> acorn + <ets>-oid</ets>.]</ety> <fld>(Zool.)</fld>
<def>Resembling an acorn; -- applied to a group of barnacles having
shells shaped like acorns. See <er>Acornshell</er>, and
<er>Barnacle</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Balas ruby</ent><br/
<hw>Bal"as ru`by</hw> <pr>(<?/)</pr>. <ety>[OE. <ets>bales</ets>,
<ets>balais</ets>, F. <ets>balais</ets>, LL. <ets>balascus</ets>, fr.
Ar. <ets>balakhsh</ets>, so called from <ets>Badakhshan</ets>,
<ets>Balashan</ets>, or <ets>Balaxiam</ets>, a place in the neighborhood
of Samarkand, where this ruby is found.]</ety> <fld>(Min.)</fld> <def>A
variety of spinel ruby, of a pale rose red, or inclining to orange. See
<er>Spinel</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Balata</ent><br/
<hw>Bal"a*ta</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Sp., prob. fr.
native name.]</ety> <sn>1.</sn> <def>A West Indian sapotaceous tree
(<spn>Bumelia retusa</spn>).</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><sn>2.</sn> <def>The bully tree (<spn>Minusops globosa</spn>); also,
its milky juice (<prod><col><b>balata gum</b></col></prod>), which when
dried constitutes an elastic gum called <altname>chicle</altname>, or
<altname>chicle gum</altname>.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Balaustine</ent><br/
<hw>Ba*laus"tine</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[L.
<ets>balaustium</ets>, Gr. <grk>balay`stion</grk>.]</ety>
<fld>(Bot.)</fld> <def>The pomegranate tree (<spn>Punica
granatum</spn>). The bark of the root, the rind of the fruit, and the
flowers are used medicinally.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Balayeuse</ent><br/
\'d8<hw>Ba`la`yeuse"</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F., lit., a
female sweeper.]</ety> <def>A protecting ruffle or frill, as of silk or
lace, sewed close to the lower edge of a skirt on the inside.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Balbucinate</ent><br/
<ent>Balbutiate</ent><br/
<mhw>{ <hw>Bal*bu"ti*ate</hw> <pr>(<?/)</pr>, <hw>Bal*bu"ci*nate</hw>
<pr>(<?/)</pr>, }</mhw> <pos>v. i.</pos> <ety>[L. <ets>balbutire</ets>,
fr. <ets>balbus</ets> stammering: cf. F. <ets>balbutier</ets>.]</ety>
<def>To stammer.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Balbuties</ent><br/
\'d8<hw>Bal*bu"ti*es</hw> <pr>(<?/)</pr>, <pos>n.</pos>
<fld>(Med.)</fld> <def>The defect of stammering; also, a kind of
incomplete pronunciation.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Balcon</ent><br/
<hw>Bal"con</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>A balcony.</def>
<mark>[Obs.]</mark> <rj><au>Pepys.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Balconied</ent><br/
<hw>Bal"co*nied</hw> <pr>(<?/)</pr>, <pos>a.</pos> <def>Having
balconies.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Balcony</ent><br/
<hw>Bal"co*ny</hw> <pr>(b<acr/l"k<osl/*n<ycr/; 277)</pr>, <pos>n.</pos>;
<plu><it>pl.</it> <plw>Balconies</plw>
<pr>(b<acr/l"k<osl/*n<icr/z)</pr>.</plu> <ety>[It. <ets>balcone</ets>;
cf. It. <ets>balco</ets>, <ets>palco</ets>, scaffold, fr. OHG.
<ets>balcho</ets>, <ets>palcho</ets>, beam, G. <ets>balken</ets>. See
<er>Balk</er> beam.]</ety> <sn>1.</sn> <fld>(Arch.)</fld> <def>A
platform projecting from the wall of a building, usually resting on
brackets or consoles, and inclosed by a parapet; <as>as, a
<ex>balcony</ex> in front of a window</as>. Also, a projecting gallery
in places of amusement; <as>as, the <ex>balcony</ex> in a
theater</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A projecting gallery once common at the stern of
large ships.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ <ldquo/The accent has shifted from the second to the
first syllable within these twenty years.<rdquo/</note> <rj><au>Smart
(1836).</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bald</ent><br/
<hw>Bald</hw> <pr>(b<add/ld)</pr>, <pos>a.</pos> <ety>[OE.
<ets>balled</ets>, <ets>ballid</ets>, perh. the p. p. of <ets>ball</ets>
to reduce to the roundness or smoothness of a ball, by removing hair.
<root/85. But cf. W. <ets>bali</ets> whiteness in a horse's
forehead.]</ety> <sn>1.</sn> <def>Destitute of the natural or common
covering on the head or top, as of hair, feathers, foliage, trees, etc.;
<as>as, a <ex>bald</ex> head; a <ex>bald</ex> oak</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>On the <qex>bald</qex> top of an eminence.</q>
<rj><qau>Wordsworth.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Destitute of ornament; unadorned; bare;
literal.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>In the preface to his own <qex>bald</qex> translation.</q>
<rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Undisguised.</def> <ldquo/ <xex>Bald</xex>
egotism.<rdquo/ <rj><au>Lowell.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>Destitute of dignity or value; paltry; mean.</def>
<mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <fld>(Bot.)</fld> <def>Destitute of a beard or awn;
<as>as, <ex>bald</ex> wheat</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <fld>(Zool.)</fld> <sd>(a)</sd> <def>Destitute of the
natural covering.</def> <sd>(b)</sd> <def>Marked with a white spot on
the head; bald-faced.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Bald buzzard</b></col> <fld>(Zool.)</fld>, <cd>the
fishhawk or osprey.</cd> -- <col><b>Bald coot</b></col>
<fld>(Zool.)</fld>, <cd>a name of the European coot (<spn>Fulica
atra</spn>), alluding to the bare patch on the front of the
head.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baldachin</ent><br/
<hw>Bal"da*chin</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[LL.
<ets>baldachinus</ets>, <ets>baldechinus</ets>, a canopy of rich silk
carried over the host; fr. <ets>Bagdad</ets>, It. <ets>Baldacco</ets>, a
city in Turkish Asia from whence these rich silks came: cf. It.
<ets>baldacchino</ets>. Cf. <er>Baudekin</er>.]</ety> <sn>1.</sn> <def>A
rich brocade; baudekin.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Arch.)</fld> <def>A structure in form of a canopy,
sometimes supported by columns, and sometimes suspended from the roof or
projecting from the wall; generally placed over an altar; <as>as, the
<ex>baldachin</ex> in St. Peter's</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>A portable canopy borne over shrines, etc., in
procession.</def><br/
[<source>1913 Webster</source>]</p>

<p><altsp>[Written also <asp>baldachino</asp>, <asp>baldaquin</asp>,
etc.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bald eagle</ent><br/
<hw>Bald" ea"gle</hw> <pr>(<?/)</pr>. <fld>(Zool.)</fld> <def>The
white-headed eagle (<spn>Hali<ae/etus leucocephalus</spn>) of America.
The young, until several years old, lack the white feathers on the
head.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ The <xex>bald eagle</xex> is represented in the coat of
arms, and on the coins, of the United States.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Balder</ent><br/
<hw>Bal"der</hw> <pr>(b<add/l"d<etil/r)</pr>, <pos>prop. n.</pos>
<ety>[Icel. <ets>Baldr</ets>, akin to E. <ets>bold</ets>.]</ety>
<fld>(Scan. Myth.)</fld> <def>The most beautiful and beloved of the
gods; the god of peace; the son of <persfn>Odin</persfn> and
<persfn>Freya</persfn>.</def> <altsp>[Written also
<asp>Baldur</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><ent>Balderdash</ent><br/
<hw>Bal"der*dash</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[Of uncertain
origin: cf. Dan. <ets>balder</ets> noise, clatter, and E.
<ets>dash</ets>; hence, perhaps, unmeaning noise, then hodgepodge,
mixture; or W. <ets>baldorduss</ets> a prattling, <ets>baldordd</ets>,
<ets>baldorddi</ets>, to prattle.]</ety> <sn>1.</sn> <def>A worthless
mixture, especially of liquors.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Indeed beer, by a mixture of wine, hath lost both name and nature,
and is called <qex>balderdash</qex>.</q> <rj><qau>Taylor (Drink and
Welcome).</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Senseless jargon; ribaldry; nonsense;
trash.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Balderdash</ent><br/
<hw>Bal"der*dash</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <def>To mix or
adulterate, as liquors.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The wine merchants of Nice brew and <qex>balderdash</qex>, and
even<br/
mix it with pigeon's dung and quicklime.</q>
<rj><qau>Smollett.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bald-faced</ent><br/
<hw>Bald"-faced`</hw> <pr>(<?/)</pr>, <pos>a.</pos> <def>Having a white
face or a white mark on the face, as a stag.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baldhead</ent><br/
<hw>Bald"head`</hw> <pr>(<?/)</pr>, <pos>n.</pos> <sn>1.</sn> <def>A
person whose head is bald.</def> <rj><au>2 Kings ii. 23.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Zool.)</fld> <def>A white-headed variety of
pigeon.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>bald-headed</ent><br/
<ent>baldheaded</ent><br/
<mhw><hw>bald"head`ed</hw>, <hw>bald"-head`ed</hw></mhw>, <pos>a.</pos>
<def>Having a bald head; lacking hair on all or most of the scalp; --
also called <altname>bald</altname> and <altname>bald-pated</altname>;
<as>as, a <ex>bald-headed</ex> gentleman</as>.</def><br/
[<source>1913 Webster</source> <source>+PJC</source>]</p>

<p><ent>Baldly</ent><br/
<hw>Bald"ly</hw>, <pos>adv.</pos> <def>Nakedly; without reserve;
inelegantly.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baldness</ent><br/
<hw>Bald"ness</hw>, <pos>n.</pos> <def>The state or condition of being
bald; <as>as, <ex>baldness</ex> of the head; <ex>baldness</ex> of
style</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>This gives to their syntax a peculiar character of simplicity and
<qex>baldness</qex>.</q> <rj><qau>W. D. Whitney.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baldpate</ent><br/
<hw>Bald"pate`</hw> <pr>(<?/)</pr>, <pos>n.</pos> <sn>1.</sn> <def>A
baldheaded person.</def> <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Zool.)</fld> <def>The American widgeon (<spn>Anas
Americana</spn>).</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baldpated</ent><br/
<ent>Baldpate</ent><br/
<mhw>{ <hw>Bald"pate`</hw> <pr>(<?/)</pr>, <hw>Bald"pat`ed</hw>
<pr>(<?/)</pr>, }</mhw> <pos>a.</pos> <def>Destitute of hair on the
head; baldheaded.</def> <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baldrib</ent><br/
<hw>Bald"rib`</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>A piece of pork
cut lower down than the sparerib, and destitute of fat.</def>
<mark>[Eng.]</mark> <rj><au>Southey.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baldric</ent><br/
<hw>Bal"dric</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[OE.
<ets>baudric</ets>, <ets>bawdrik</ets>, through OF. (cf. F.
<ets>baudrier</ets> and LL. <ets>baldringus</ets>,
<ets>baldrellus</ets>), from OHG. <ets>balderich</ets>, cf.
<ets>balz</ets>, <ets>palz</ets>, akin to E. <ets>belt</ets>. See
<er>Belt</er>, <pos>n.</pos>]</ety> <def>A broad belt, sometimes richly
ornamented, worn over one shoulder, across the breast, and under the
opposite arm; it is used to support a sword or bugle by the left hip;
less properly, any belt.</def> <altsp>[Also spelt <asp>bawdrick</asp>
and <asp>baldrick</asp>.]</altsp><br/
[<source>1913 Webster</source> + <source>WordNet 1.5</source>]</p>

<p><q>A radiant <qex>baldric</qex> o'er his shoulder tied<br/
Sustained the sword that glittered at his side.</q>
<rj><qau>Pope.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baldwin</ent><br/
<hw>Bald"win</hw> <pr>(<?/)</pr>, <pos>n.</pos> <fld>(Bot.)</fld> <def>A
kind of reddish, moderately acid, winter apple.</def>
<mark>[U.S.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>baldy</ent><br/
<hw>baldy</hw> <pos>n.</pos> <def>a person who has a bald head; -- a
deprecatory term.</def><br/
<syn><b>Syn. --</b> baldhead, baldpate.</syn><br/
[<source>WordNet 1.5</source> <source>+PJC</source>]</p>

<p><ent>Bale</ent><br/
<hw>Bale</hw> <pr>(b<amac/l)</pr>, <pos>n.</pos> <ety>[OE.
<ets>bale</ets>, OF. <ets>bale</ets>, F. <ets>balle</ets>, LL.
<ets>bala</ets>, fr. OHG. <ets>balla</ets>, <ets>palla</ets>,
<ets>pallo</ets>, G. <ets>ball</ets>, <ets>balle</ets>,
<ets>ballen</ets>, ball, round pack; cf. D. <ets>baal</ets>. Cf.
<er>Ball</er> a round body.]</ety> <def>A bundle or package of goods in
a cloth cover, and corded for storage or transportation; also, a bundle
of straw, hay, etc., put up compactly for transportation.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Bale of dice</b></col>, <cd>a pair of dice.</cd>
<mark>[Obs.]</mark> <rj><au>B. Jonson.</au></rj></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bale</ent><br/
<hw>Bale</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos>
<conjf>Baled</conjf> <pr>(b<amac/ld)</pr>; <pos>p. pr. & vb. n.</pos>
<conjf>Baling</conjf>.]</vmorph> <def>To make up in a bale.</def>
<rj><au>Goldsmith.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bale</ent><br/
<hw>Bale</hw>, <pos>v. t.</pos> <def>See <er>Bail</er>, <pos>v.
t.</pos>, to lade.</def><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 114 pr=SA --></p>

<p><ent>Bale</ent><br/
<hw>Bale</hw> <pr>(b<amac/l)</pr>, <pos>n.</pos> <ety>[AS.
<ets>bealo</ets>, <ets>bealu</ets>, <ets>balu</ets>; akin to OS.
<ets>balu</ets>, OHG. <ets>balo</ets>, Icel. <ets>b<oum/l</ets>, Goth.
<ets>balweins</ets>.]</ety> <sn>1.</sn> <def>Misery; calamity;
misfortune; sorrow.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Let now your bliss be turned into <qex>bale</qex>.</q>
<rj><qau>Spenser.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Evil; an evil, pernicious influence; something
causing great injury.</def> <mark>[Now chiefly poetic]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Balearic</ent><br/
<hw>Bal`e*ar"ic</hw> <pr>(b<acr/l`<esl/*<acr/r"<icr/k)</pr>,
<pos>a.</pos> <ety>[L. <ets>Balearicus</ets>, fr. Gr.
<grk>baliarei^s</grk> the Balearic Islands.]</ety> <def>Of or pertaining
to the isles of Majorca, Minorca, Ivica, etc., in the Mediterranean Sea,
off the coast of Valencia.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Balearic crane</b></col>. <fld>(Zool.)</fld> <cd>See
<er>Crane</er>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baleen</ent><br/
<hw>Ba*leen"</hw> <pr>(b<adot/*l<emac/n")</pr>, <pos>n.</pos> <ety>[F.
<ets>baleine</ets> whale and whalebone, L. <ets>balaena</ets> a whale;
cf. Gr. <grk>fa`laina</grk>. ]</ety> <fld>(Zool. & Com.)</fld>
<def>Plates or blades of <ldquo/whalebone,<rdquo/ from two to twelve
feet long, and sometimes a foot wide, which in certain whales
(<fam>Bal<ae/noidea</fam>) are attached side by side along the upper
jaw, and form a fringelike sieve by which the food is retained in the
mouth.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Balefire</ent><br/
<hw>Bale"fire`</hw> <pr>(b<amac/l"f<imac/r)</pr>, <pos>n.</pos>
<ety>[AS. <ets>b<aemac/lf<ymac/r</ets> the fire of the funeral pile;
<ets>b<aemac/l</ets> fire, flame (akin to Icel. <ets>b<amac/l</ets>,
OSlav. <ets>b<emac/l<ucr/</ets>, white, Gr. <grk>falo`s</grk> bright,
white, Skr. <ets>bh<amac/la</ets> brightness) + <ets>f<ymac/r</ets>, E.
<ets>fire</ets>.]</ety> <def>A signal fire; an alarm fire.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Sweet Teviot! on thy silver tide<br/
The glaring <qex>balefires</qex> blaze no more.</q> <rj><qau>Sir W.
Scott.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baleful</ent><br/
<hw>Bale"ful</hw> <pr>(b<amac/l"f<usdot/l)</pr>, <pos>a.</pos> <ety>[AS.
<ets>bealoful</ets>. See <er>Bale</er> misery.]</ety> <sn>1.</sn>
<def>Full of deadly or pernicious influence; destructive.</def>
<ldquo/<xex>Baleful</xex> enemies.<rdquo/ <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Four infernal rivers that disgorge<br/
Into the burning lake their <qex>baleful</qex> streams.</q>
<rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Full of grief or sorrow; woeful; sad.</def>
<mark>[Archaic]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Balefully</ent><br/
<hw>Bale"ful*ly</hw>, <pos>adv.</pos> <def>In a baleful manner;
perniciously.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Balefulness</ent><br/
<hw>Bale"ful*ness</hw>, <pos>n.</pos> <def>The quality or state of being
baleful.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Balisaur</ent><br/
\'d8<hw>Bal"i*sa`ur</hw> <pr>(b<acr/l"<icr/*s<aum/`<oomac/r)</pr>,
<pos>n.</pos> <ety>[Hind.]</ety> <fld>(Zool.)</fld> <def>A badgerlike
animal of India (<spn>Arctonyx collaris</spn>).</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Balister</ent><br/
<hw>Bal"is*ter</hw> <pr>(b<acr/l"<icr/s*t<etil/r <it>or</it>
b<adot/*l<icr/s"t<etil/r)</pr>, <pos>n.</pos> <ety>[OF.
<ets>balestre</ets>. See <er>Ballista</er>.]</ety> <def>A
crossbow.</def> <mark>[Obs.]</mark> <rj><au>Blount.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Balistidae</ent><br/
<hw>Balistidae</hw> <pos>n.</pos> <sn>1.</sn> <def>a natural family
comprising the triggerfishes.</def><br/
<syn><b>Syn. --</b> family <fam>Balistidae</fam>.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Balistoid</ent><br/
<hw>Bal"is*toid</hw> <pr>(<?/)</pr>, <pos>a.</pos> <fld>(Zool.)</fld>
<def>Like a fish of the genus <gen>Balistes</gen>; of the family
<fam>Balistid<ae/</fam>. See <er>Filefish</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Balistraria</ent><br/
\'d8<hw>Bal`is*tra"ri*a</hw> <pr>(<?/)</pr>, <pos>n.</pos>
<ety>[LL.]</ety> <fld>(Anc. Fort.)</fld> <def>A narrow opening, often
cruciform, through which arrows might be discharged.</def>
<rj><au>Parker.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Balize</ent><br/
\'d8<hw>Ba*lize"</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[F.
<ets>balise</ets>; cf. Sp. <ets>balisa</ets>.]</ety> <def>A pole or a
frame raised as a sea beacon or a landmark.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Balk</ent><br/
<hw>Balk</hw> <pr>(b<add/k)</pr>, <pos>n.</pos> <ety>[AS.
<ets>balca</ets> beam, ridge; akin to Icel. <ets>b<amac/lkr</ets>
partition, <ets>bj<amac/lki</ets> beam, OS. <ets>balko</ets>, G.
<ets>balken</ets>; cf. Gael. <ets>balc</ets> ridge of earth between two
furrows. Cf. <er>Balcony</er>, <er>Balk</er>, <pos>v. t.</pos>, 3d
<er>Bulk</er>.]</ety> <sn>1.</sn> <def>A ridge of land left unplowed
between furrows, or at the end of a field; a piece missed by the plow
slipping aside.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Bad plowmen made <qex>balks</qex> of such ground.</q>
<rj><qau>Fuller.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A great beam, rafter, or timber; esp., the tie-beam
of a house. The loft above was called <ldquo/the balks.<rdquo/</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Tubs hanging in the <qex>balks</qex>.</q>
<rj><qau>Chaucer.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Mil.)</fld> <def>One of the beams connecting the
successive supports of a trestle bridge or bateau bridge.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>A hindrance or disappointment; a check.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>A <qex>balk</qex> to the confidence of the bold undertaker.</q>
<rj><qau>South.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>A sudden and obstinate stop; a failure.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <fld>(Baseball)</fld> <def>A deceptive gesture of the
pitcher, as if to deliver the ball. It is illegal and is penalized by
allowing the runners on base to advance one base.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Balk line</b></col> <fld>(Billiards)</fld>, <cd>a line
across a billiard table near one end, marking a limit within which the
cue balls are placed in beginning a game; also, a line around the table,
parallel to the sides, used in playing a particular game, called the
<xex>balk line</xex> game.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Balk</ent><br/
<hw>Balk</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos>
<conjf>Balked</conjf> <pr>(b<add/kt)</pr>; <pos>p. pr. & vb. n.</pos>
<conjf>Balking</conjf>.]</vmorph> <ety>[From <er>Balk</er> a beam; orig.
to put a balk or beam in one's way, in order to stop or hinder. Cf., for
sense 2, AS. <xex>on balcan legan</xex> to lay in heaps.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>To leave or make balks in.</def> <mark>[Obs.]</mark>
<rj><au>Gower.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To leave heaped up; to heap up in piles.</def>
<mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>Ten thousand bold Scots, two and twenty knights,<br/
<qex>Balk'd</qex> in their own blood did Sir Walter see.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To omit, miss, or overlook by chance.</def>
<mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>To miss intentionally; to avoid; to shun; to refuse;
to let go by; to shirk.</def> <mark>[Obs. or Obsolescent]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>By reason of the contagion then in London, we <qex>balked</qex>
the inns.</q> <rj><qau>Evelyn.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Sick he is, and keeps his bed, and <qex>balks</qex> his meat.</q>
<rj><qau>Bp. Hall.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Nor doth he any creature <qex>balk</qex>,<br/
But lays on all he meeteth.</q> <rj><qau>Drayton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>To disappoint; to frustrate; to foil; to baffle; to
thwart; <as>as, to <ex>balk</ex> expectation</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>They shall not <qex>balk</qex> my entrance.</q>
<rj><qau>Byron.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Balk</ent><br/
<hw>Balk</hw>, <pos>v. i.</pos> <sn>1.</sn> <def>To engage in
contradiction; to be in opposition.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>In strifeful terms with him to <qex>balk</qex>.</q>
<rj><qau>Spenser.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To stop abruptly and stand still obstinately; to
jib; to stop short; to swerve; <as>as, the horse
<ex>balks</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ This has been regarded as an Americanism, but it occurs
in Spenser's <ldquo/Fa<eum/rie Queene,<rdquo/ Book IV., 10,
xxv.</note><br/
[<source>1913 Webster</source>]</p>

<p><q>Ne ever ought but of their true loves talkt,<br/
Ne ever for rebuke or blame of any <qex>balkt</qex>.</q><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Baseball)</fld> <def>to commit a balk{6}; -- of a
pitcher.</def><br/
[<source>PJC</source>]</p>

<p><ent>Balk</ent><br/
<hw>Balk</hw>, <pos>v. i.</pos> <ety>[Prob. from D. <ets>balken</ets> to
bray, bawl.]</ety> <def>To indicate to fishermen, by shouts or signals
from shore, the direction taken by the shoals of herring.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>balkanize</ent><br/
<hw>balkanize</hw> <pos>v.</pos> <sn>1.</sn> <def>to divide a territory
into small, hostile states.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Balkans</ent><br/
<hw>Balkans</hw> <pos>prop. n. pl.</pos> <sn>1.</sn> <def>The countries
occupying the Balkan Peninsula.</def><br/
<syn><b>Syn. --</b> Balkan countries, Balkan nations, Balkan
states.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><sn>2.</sn> <def>The Balkan mountains.</def><br/
[<source>PJC</source>]</p>

<p><ent>balked</ent><br/
<hw>balked</hw> <pos>adj.</pos> <sn>1.</sn> <def>Same as
<er>baffled</er>.</def><br/
<syn><b>Syn. --</b> baffled, discomfited, discouraged,
frustrated.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Balker</ent><br/
<hw>Balk"er</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[See 2d
<er>Balk</er>.]</ety> <def>One who, or that which, balks.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Balker</ent><br/
<hw>Balk"er</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[See last
<er>Balk</er>.]</ety> <def>A person who stands on a rock or eminence to
espy the shoals of herring, etc., and to give notice to the men in boats
which way they pass; a conder; a huer.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>balkiness</ent><br/
<hw>balkiness</hw> <pos>n.</pos> <sn>1.</sn> <def>likely to stop
abruptly and unexpectedly.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>balkline</ent><br/
<hw>balkline</hw> <pos>n.</pos> <sn>1.</sn> <def>line across a billiard
table behind which the cue balls are placed at the start of a
game.</def><br/
<syn><b>Syn. --</b> baulk line, string line.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Balkingly</ent><br/
<hw>Balk"ing*ly</hw>, <pos>adv.</pos> <def>In a manner to balk or
frustrate.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Balkish</ent><br/
<hw>Balk"ish</hw>, <pos>a.</pos> <def>Uneven; ridgy.</def>
<mark>[R.]</mark> <rj><au>Holinshed.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Balky</ent><br/
<hw>Balk"y</hw> <pr>(b<add/k"<ycr/)</pr>, <pos>a.</pos> <def>Apt to
balk; <as>as, a <ex>balky</ex> horse</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ball</ent><br/
<hw>Ball</hw> <pr>(b<add/l)</pr>, <pos>n.</pos> <ety>[OE.
<ets>bal</ets>, <ets>balle</ets>; akin to OHG. <ets>balla</ets>,
<ets>palla</ets>, G. <ets>ball</ets>, Icel. <ets>b<oum/llr</ets>, ball;
cf. F. <ets>balle</ets>. Cf. 1st <er>Bale</er>, <pos>n.</pos>,
<er>Pallmall</er>.]</ety> <sn>1.</sn> <def>Any round or roundish body or
mass; a sphere or globe; <as>as, a <ex>ball</ex> of twine; a
<ex>ball</ex> of snow</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A spherical body of any substance or size used to
play with, as by throwing, knocking, kicking, etc.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>A general name for games in which a ball is thrown,
kicked, or knocked. See <er>Baseball</er>, and
<er>Football</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>Any solid spherical, cylindrical, or conical
projectile of lead or iron, to be discharged from a firearm; <as>as, a
cannon <ex>ball</ex>; a rifle <ex>ball</ex></as>; -- often used
collectively; <as>as, powder and <ex>ball</ex></as>. Spherical balls for
the smaller firearms are commonly called
<stype>bullets</stype>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <fld>(Pyrotechnics & Mil.)</fld> <def>A flaming, roundish
body shot into the air; a case filled with combustibles intended to
burst and give light or set fire, or to produce smoke or stench; <as>as,
a fire <ex>ball</ex>; a stink <ex>ball</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <fld>(Print.)</fld> <def>A leather-covered cushion,
fastened to a handle called a <xex>ballstock</xex>; -- formerly used by
printers for inking the form, but now superseded by the
roller.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>7.</sn> <def>A roundish protuberant portion of some part of the
body; <as>as, the <ex>ball</ex> of the thumb; the <ex>ball</ex> of the
foot</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>8.</sn> <fld>(Far.)</fld> <def>A large pill, a form in which
medicine is commonly given to horses; a bolus.</def>
<rj><au>White.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>9.</sn> <def>The globe or earth.</def>
<rj><au>Pope.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Move round the dark terrestrial <qex>ball</qex>.</q>
<rj><qau>Addison.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>10.</sn> <fld>(Baseball)</fld> <def>A pitched ball, not struck at
by the batter, which fails to pass over the home plate at a height not
greater than the batter's shoulder nor less than his knee (i.e. it is
outside the strike zone). If the pitcher pitches four balls before three
strikes are called, the batter advances to first base, and the action of
pitching four balls is called a <partof>walk</partof>.</def><br/
[<source>Webster 1913 Suppl.</source> <source>+PJC</source>]</p>

<p><sn>10.</sn> <def>a testicle; usually used in the plural.</def>
<mark>[vulgar]</mark> <br/
[<source>PJC</source>]</p>

<p><sn>11.</sn> <pluf>pl.</pluf> <def>courage; nerve.</def>
<mark>[vulgar]</mark> <br/
[<source>PJC</source>]</p>

<p><cs><col><b>Ball and socket joint</b></col>, <cd>a joint in which a
ball moves within a socket, so as to admit of motion in every direction
within certain limits.</cd> -- <col><b>Ball bearings</b></col>, <cd>a
mechanical device for lessening the friction of axle bearings by means
of small loose metal balls.</cd> -- <col><b>Ball cartridge</b></col>,
<cd>a cartridge containing a ball, as distinguished from a blank
cartridge, containing only powder.</cd> -- <col><b>Ball cock</b></col>,
<cd>a faucet or valve which is opened or closed by the fall or rise of a
ball floating in water at the end of a lever.</cd> -- <col><b>Ball
gudgeon</b></col>, <cd>a pivot of a spherical form, which permits
lateral deflection of the arbor or shaft, while retaining the pivot in
its socket.</cd> <au>Knight.</au> -- <col><b>Ball lever</b></col>,
<cd>the lever used in a ball cock.</cd> -- <col><b>Ball of the
eye</b></col>, <cd>the eye itself, as distinguished from its lids and
socket; -- formerly, the pupil of the eye.</cd> -- <col><b>Ball
valve</b></col> <fld>(Mach.)</fld>, <cd>a contrivance by which a ball,
placed in a circular cup with a hole in its bottom, operates as a
valve.</cd> -- <col><b>Ball vein</b></col> <fld>(Mining)</fld>, <cd>a
sort of iron ore, found in loose masses of a globular form, containing
sparkling particles.</cd> -- <mcol><col><b>Three balls</b></col>, or
<col><b>Three golden balls</b></col></mcol>, <cd>a pawnbroker's sign or
shop.</cd> -- <col><b>on the ball</b></col> <cd>alert; competent and
knowledgeable.</cd> -- <col><b>to carry the ball</b></col> <cd>to carry
on the task; to assume the responsibility.</cd> -- <col><b>to drop the
ball</b></col> <cd>to fail to perform as expected; to fail to live up to
a responsibility.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- See <er>Globe</er>.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ball</ent><br/
<hw>Ball</hw>, <pos>v. i.</pos> <vmorph>[<pos>imp. & p. p.</pos>
<conjf>Balled</conjf> <pr>(b<add/ld)</pr>; <pos>p. pr. & vb. n.</pos>
<conjf>Balling</conjf>.]</vmorph> <def>To gather balls which cling to
the feet, as of damp snow or clay; to gather into balls; <as>as, the
horse <ex>balls</ex>; the snow <ex>balls</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ball</ent><br/
<hw>Ball</hw>, <pos>v. t.</pos> <sn>1.</sn> <fld>(Metal.)</fld> <def>To
heat in a furnace and form into balls for rolling.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To form or wind into a ball; <as>as, to
<ex>ball</ex> cotton</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ball</ent><br/
<hw>Ball</hw>, <pos>n.</pos> <ety>[F. <ets>bal</ets>, fr. OF.
<ets>baler</ets> to dance, fr. LL. <ets>ballare</ets>. Of uncertain
origin; cf. Gr. <grk>ba`llein</grk> to toss or throw, or
<grk>pa`llein</grk>, <grk>pa`llesqai</grk>, to leap, bound,
<grk>balli`zein</grk> to dance, jump about; or cf. 1st <er>Ball</er>,
<pos>n.</pos>]</ety> <sn>1.</sn> <def>A social assembly for the purpose
of dancing; -- usually applied to an occasion lavish or
formal.</def><br/
[<source>1913 Webster</source> <source>+PJC</source>]</p>

<p><sn>2.</sn> <def>A very enjoyable time; <as>as, we had a
<ex>ball</ex> at the wedding</as>.</def><br/
[<source>PJC</source>]</p>

<p><ent>Ballad</ent><br/
<hw>Bal"lad</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[OE.
<ets>balade</ets>, OF. <ets>balade</ets>, F. <ets>ballade</ets>, fr. Pr.
<ets>ballada</ets> a dancing song, fr. <ets>ballare</ets> to dance; cf.
It. <ets>ballata</ets>. See 2d <er>Ball</er>, <pos>n.</pos>, and
<er>Ballet</er>.]</ety> <def>A popular kind of narrative poem, adapted
for recitation or singing; <as>as, the <ex>ballad</ex> of Chevy
Chase</as>; esp., a sentimental or romantic poem in short
stanzas.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ballad</ent><br/
<hw>Bal"lad</hw>, <pos>v. i.</pos> <def>To make or sing ballads.</def>
<mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ballad</ent><br/
<hw>Bal"lad</hw>, <pos>v. t.</pos> <def>To make mention of in
ballads.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ballade</ent><br/
<hw>Bal*lade"</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[See
<er>Ballad</er>, <pos>n.</pos>]</ety> <def>A form of French
versification, sometimes imitated in English, in which three or four
rhymes recur through three stanzas of eight or ten lines each, the
stanzas concluding with a refrain, and the whole poem with an
envoy.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ballader</ent><br/
<hw>Bal"lad*er</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>A writer of
ballads.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ballad monger</ent><br/
<hw>Bal"lad mon`ger</hw> <pr>(<?/)</pr>. <ety>[See
<er>Monger</er>.]</ety> <def>A seller or maker of ballads; a
poetaster.</def> <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Balladry</ent><br/
<hw>Bal"lad*ry</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[From
<er>Ballad</er>, <pos>n.</pos>]</ety> <def>Ballad poems; the subject or
style of ballads.</def> <ldquo/Base <xex>balladry</xex> is so
beloved.<rdquo/ <rj><au>Drayton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ballahou</ent><br/
<ent>Ballahoo</ent><br/
<mhw>{ <hw>Bal"la*hoo</hw>, <hw>Bal"la*hou</hw> }</mhw>
<pr>(b<acr/l"l<adot/*h<oomac/)</pr>, <pos>n.</pos> <def>A fast-sailing
schooner, used in the Bermudas and West Indies.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ballarag</ent><br/
<hw>Bal"la*rag</hw> <pr>(b<acr/l"l<adot/*r<acr/g)</pr>, <pos>v. t.</pos>
<ety>[Corrupted fr. <ets>bullirag</ets>.]</ety> <def>To bully; to
threaten.</def> <mark>[Low]</mark> <rj><au>T. Warton.</au></rj><br/
<syn><b>Syn. --</b> bullirag; bullyrag.</syn>
[<source>1913 Webster</source>]</p>

<p><ent>Ballast</ent><br/
<hw>Bal"last</hw> <pr>(b<acr/l"l<ait/st)</pr>, <pos>n.</pos> <ety>[D.
<ets>ballast</ets>; akin to Dan. <ets>baglast</ets>, <ets>ballast</ets>,
OSw. <ets>barlast</ets>, Sw. <ets>ballast</ets>. The first part is perh.
the same word as E. <ets>bare</ets>, adj.; the second is <ets>last</ets>
a burden, and hence the meaning <ets>a bare</ets>, or <ets>mere</ets>,
<ets>load</ets>. See <er>Bare</er>, <pos>a.</pos>, and <er>Last</er>
load.]</ety> <sn>1.</sn> <fld>(Naut.)</fld> <def>Any heavy substance, as
stone, iron, etc., put into the hold to sink a vessel in the water to
such a depth as to prevent capsizing.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Any heavy matter put into the car of a balloon to
give it steadiness.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Gravel, broken stone, etc., laid in the bed of a
railroad to make it firm and solid.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>The larger solids, as broken stone or gravel, used
in making concrete.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>Fig.: That which gives, or helps to maintain,
uprightness, steadiness, and security.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>It [piety] is the right <qex>ballast</qex> of prosperity.</q>
<rj><qau>Barrow.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Ballast engine</b></col>, <cd>a steam engine used in
excavating and for digging and raising stones and gravel for
ballast.</cd> -- <col><b>Ship in ballast</b></col>, <cd>a ship carrying
only ballast.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ballast</ent><br/
<hw>Bal"last</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos>
<conjf>Ballasted</conjf>; <pos>p. pr. & vb. n.</pos>
<conjf>Ballasting</conjf>.]</vmorph> <sn>1.</sn> <def>To steady, as a
vessel, by putting heavy substances in the hold.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To fill in, as the bed of a railroad, with gravel,
stone, etc., in order to make it firm and solid.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To keep steady; to steady, morally.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>'T is charity must <qex>ballast</qex> the heart.</q>
<rj><qau>Hammond.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ballastage</ent><br/
<hw>Bal"last*age</hw> <pr>(<?/)</pr>, <pos>n.</pos> <fld>(Law)</fld>
<def>A toll paid for the privilege of taking up ballast in a port or
harbor.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ballasting</ent><br/
<hw>Bal"last*ing</hw>, <pos>n.</pos> <def>That which is used for
steadying anything; ballast.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ballatry</ent><br/
<hw>Bal"la*try</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>See
<er>Balladry</er>.</def> <mark>[Obs.]</mark>
<rj><au>Milton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>balled</ent><br/
<hw>balled</hw> <pos>adj. prenom.</pos> <def>formed or gathered into a
ball.</def> <illu><ex>balled</ex> cotton</illu><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>ballerina</ent><br/
<hw>ballerina</hw> <pos>n.</pos> <def>A female ballet dancer.</def><br/
<syn><b>Syn. --</b> danseuse.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Ballet</ent><br/
\'d8<hw>Bal"let`</hw> <pr>(b<acr/l"l<asl/` <it>or</it> b<acr/l"l<ecr/t;
277)</pr>, <pos>n.</pos> <ety>[F., a dim. of <ets>bal</ets> dance. See
2d <er>Ball</er>, <pos>n.</pos>]</ety> <sn>1.</sn> <def>An artistic
dance performed as a theatrical entertainment, or an interlude, by a
number of persons, usually women. Sometimes, a scene accompanied by
pantomime and dancing.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The company of persons who perform the
ballet.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Mus.)</fld> <def>A light part song, or madrigal,
with a <xex>fa la</xex> burden or chorus, -- most common with the
Elizabethan madrigal composers; -- also spelled
<asp>ballett</asp>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <fld>(Her.)</fld> <def>A bearing in coats of arms,
representing one or more balls, which are denominated bezants, plates,
etc., according to color.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>balletic</ent><br/
<hw>balletic</hw> <pos>adj.</pos> <def>of or pertaining to
ballet{1}.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>ballet master</ent><br/
<hw>bal"let` mas"ter</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>a man who
trains ballet dancers.</def><br/
[<source>PJC</source>]</p>

<p><ent>ballet mistress</ent><br/
<hw>bal"let` mis"tress</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>a woman
who trains ballet dancers.</def><br/
[<source>PJC</source>]</p>

<p><ent>balletomane</ent><br/
<hw>balletomane</hw> <pos>n.</pos> <def>a ballet enthusiast.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>ballet slipper</ent><br/
<hw>ballet slipper</hw> <pos>n.</pos> <def>a heelless slipper
specifically designed to be worn by ballet dancers while
dancing.</def><br/
[<source>PJC</source>]</p>

<p><ent>Ball-flower</ent><br/
<hw>Ball"-flow`er</hw> <pr>(<?/)</pr>, <pos>n.</pos> <fld>(Arch.)</fld>
<def>An ornament resembling a ball placed in a circular flower, the
petals of which form a cup round it, -- usually inserted in a hollow
molding.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>ball-hawking</ent><br/
<hw>ball-hawking</hw> <pos>adj.</pos> <fld>(Baseball or basketball or
football)</fld> <def>skilled in stealing the ball or robbing a batter of
a hit; -- used of a Baseball or basketball or football player.</def>
<illu>a <ex>ball-hawking</ex> center fielder</illu><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Ballista</ent><br/
\'d8<hw>Bal*lis"ta</hw> <pr>(<?/)</pr>, <pos>n.</pos>; <plu><it>pl.</it>
<plw>Ballist<ae/</plw> <pr>(<?/)</pr>.</plu> <ety>[L.
<ets>ballista</ets>, <ets>balista</ets>, fr. Gr. <grk>ba`llein</grk> to
throw.]</ety> <def>An ancient military engine, in the form of a
crossbow, used for hurling large missiles.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ballister</ent><br/
<hw>Bal"lis*ter</hw> <pr>(b<acr/l"l<icr/s*t<etil/r <it>or</it>
b<acr/l*l<icr/s"t<etil/r)</pr>, <pos>n.</pos> <ety>[L.
<ets>ballista</ets>. Cf. <er>Balister</er>.]</ety> <def>A
crossbow.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ballistic</ent><br/
<hw>Bal*lis"tic</hw> <pr>(<?/)</pr>, <pos>a.</pos> <sn>1.</sn> <def>Of
or pertaining to the ballista, or to the art of hurling stones or
missile weapons by means of an engine.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Pertaining to ballistics{2}, or to a projectile in a
gravitational field.</def><br/
[<source>1913 Webster</source> <source>+PJC</source>]</p>

<p><sn>3.</sn> <def>frenzied; very angry; -- used mostly in the phrase
<col><b>go ballistic</b></col>.</def> <mark>[Colloq.]</mark> <br/
[<source>PJC</source>]</p>

<p><cs><col><b>Ballistic pendulum</b></col>, <cd>an instrument
consisting of a mass of wood or other material suspended as a pendulum,
for measuring the force and velocity of projectiles by means of the arc
through which their impact impels it.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>ballistic missile</ent><br/
<hw>bal*lis"tic mis`sile</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>A
rocket-propelled missile of long range which is guided only during the
powered portion of its flight, which usually takes only a small part of
the total flight time; -- contrasted with <contr>guided
missile</contr>.</def> <note>Ballistic missiles are sometimes referred
to by their range, such as an <styp><col><b>intercontinental ballistic
missile</b></col></styp> (<stype>ICBM</stype>) or an
<styp><col><b>intermediate range ballistic missile</b></col></styp>
(<stype>IRBM</stype>).</note><br/
[<source>PJC</source>]</p>

<p><ent>Ballistics</ent><br/
<hw>Bal*lis"tics</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[Cf. F.
<ets>balistique</ets>. See <er>Ballista</er>.]</ety> <def>The science or
art of hurling missile weapons by the use of an engine.</def>
<rj><au>Whewell.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The science treating the motion of projectiles in
flight, especially when they are in free fall within the earth's
gravitational field.</def><br/
[<source>PJC</source>]</p>

<p><sn>3.</sn> <def>The study of the characteristics of a cartridge
fired from a firearm, and of the processes occurring during the
discharge of a firearm.</def><br/
[<source>PJC</source>]</p>

<p><sn>4.</sn> <def>The division within a police department which
studies the characteristics of cartridges fired from a firearm; the
ballistics department. The characteristics of the weapons and bullets
fired may be used as evidence in criminal investigations.</def><br/
[<source>PJC</source>]</p>

<p><ent>Ballistite</ent><br/
<hw>Bal"lis*tite</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[See
<er>Ballista</er>.]</ety> <fld>(Chem.)</fld> <def>A smokeless powder
containing equal parts of soluble nitrocellulose and
nitroglycerin.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Ballium</ent><br/
\'d8<hw>Bal"li*um</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[LL.]</ety>
<def>See <er>Bailey</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Balloon</ent><br/
<hw>Bal*loon"</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[F.
<ets>ballon</ets>, aug. of <ets>balle</ets> ball: cf. It.
<ets>ballone</ets>. See 1st <er>Ball</er>, <pos>n.</pos>, and cf.
<er>Pallone</er>.]</ety> <sn>1.</sn> <def>A bag made of silk or other
light material, and filled with hydrogen gas or heated air, so as to
rise and float in the atmosphere; especially, one with a car attached
for a<eum/rial navigation.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Arch.)</fld> <def>A ball or globe on the top of a
pillar, church, etc., as at St. Paul's, in London.</def>
<mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Chem.)</fld> <def>A round vessel, usually with a
short neck, to hold or receive whatever is distilled; a glass vessel of
a spherical form.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <fld>(Pyrotechnics)</fld> <def>A bomb or shell.</def>
<mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>A game played with a large inflated ball.</def>
<mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <fld>(Engraving)</fld> <def>The outline inclosing words
represented as coming from the mouth of a pictured figure.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Air balloon</b></col>, <cd>a balloon for a<eum/rial
navigation.</cd> -- <col><b>Balloon frame</b></col> <fld>(Carp.)</fld>,
<cd>a house frame constructed altogether of small timber.</cd> --
<col><b>Balloon net</b></col>, <cd>a variety of woven lace in which the
weft threads are twisted in a peculiar manner around the
warp.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Balloon</ent><br/
<hw>Bal*loon"</hw>, <pos>v. t.</pos> <def>To take up in, or as if in, a
balloon.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Balloon</ent><br/
<hw>Bal*loon"</hw>, <pos>v. i.</pos> <sn>1.</sn> <def>To go up or voyage
in a balloon.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To expand, or puff out, like a balloon.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ballooned</ent><br/
<hw>Bal*looned"</hw> <pr>(<?/)</pr>, <pos>a.</pos> <def>Swelled out like
a balloon.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ballooner</ent><br/
<hw>Bal*loon"er</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>One who goes up
in a balloon; an a<eum/ronaut.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>balloon fish</ent><br/
<ent>balloonfish</ent><br/
<mhw><hw>bal*loon"fish`</hw>, <hw>bal*loon" fish`</hw></mhw>
<pr>(<?/)</pr>. <fld>(Zool.)</fld> <def>A fish of the genus
<gen>Diodon</gen> (such as <spn>Diodon holocanthus</spn>) or the genus
<gen>Tetraodon</gen>, having the power of distending its body by taking
air or water into its dilatable esophagus. It is similar to but smaller
than the porcupinefish. See <er>Globefish</er>, and <er>Bur
fish</er>.</def><br/
[<source>1913 Webster</source> + <source>WordNet 1.5</source>]</p>

<p><ent>Ballooning</ent><br/
<hw>Bal*loon"ing</hw>, <pos>n.</pos> <sn>1.</sn> <def>The art or
practice of managing balloons or voyaging in them; the sport of riding
in balloons.</def><br/
<syn>balloonry (archaic)</syn><br/
[<source>1913 Webster</source> <source>+PJC</source>]</p>

<p><sn>2.</sn> <fld>(Stock Exchange)</fld> <def>The process of
temporarily raising the value of a stock, as by fictitious sales.</def>
<mark>[U.S.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ballooning spider</ent><br/
<hw>Bal*loon"ing spi"der</hw> <pr>(<?/)</pr>. <fld>(Zool.)</fld> <def>A
spider which has the habit of rising into the air. Many kinds (esp.
species of <gen>Lycosa</gen>) do this while young by ejecting threads of
silk until the force of the wind upon them carries the spider
aloft.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Balloonist</ent><br/
<hw>Bal*loon"ist</hw>, <pos>n.</pos> <def>An a<eum/ronaut.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Balloonry</ent><br/
<hw>Bal*loon"ry</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>The art or
practice of ascending in a balloon; an older term for
<er>ballooning</er>.</def> <mark>[Archaic]</mark><br/
[<source>1913 Webster</source> <source>+PJC</source>]</p>

<p><ent>Ballot</ent><br/
<hw>Bal"lot</hw> <pr>(b<acr/l"l<ucr/t)</pr>, <pos>n.</pos> <ety>[F.
<ets>ballotte</ets>, fr. It. <ets>ballotta</ets>. See <er>Ball</er>
round body.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>Originally, a ball used for secret voting. Hence:
Any printed or written ticket used in voting.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The act of secret voting, whether by balls, written
or printed ballots or tickets, or by use of a voting machine; the system
of voting secretly.</def><br/
[<source>1913 Webster</source> <source>+PJC</source>]</p>

<p><q>The insufficiency of the <qex>ballot</qex>.</q>
<rj><qau>Dickens.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 115 pr=SA --></p>

<p><sn>3.</sn> <def>The whole number of votes cast at an election, or in
a given territory or electoral district.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>the official list of candidates competing in an
election.</def> <illu>There are no women on the
<ex>ballot</ex>.</illu><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Ballot box</b></col>, <sd>(a)</sd> <cd>a box for
receiving ballots.</cd> <sd>(b)</sd> <cd>the act, process or system of
voting secretly; same as <er>ballot</er>{2}.</cd> <ldquo/The question
will be resolved by the <ex>ballot box</ex>.<rdquo/</cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ballot</ent><br/
<hw>Bal"lot</hw> <pr>(b<acr/l"l<ucr/t)</pr>, <pos>v. i.</pos>
<vmorph>[<pos>imp. & p. p.</pos> <conjf>Balloted</conjf>; <pos>p. pr. &
vb. n.</pos> <conjf>Balloting</conjf>.]</vmorph> <ety>[F.
<ets>ballotter</ets> to toss, to ballot, or It. <ets>ballottare</ets>.
See <er>Ballot</er>, <pos>n.</pos>]</ety> <def>To vote or decide by
ballot; <as>as, to <ex>ballot</ex> for a candidate</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ballot</ent><br/
<hw>Bal"lot</hw>, <pos>v. t.</pos> <def>To vote for or in opposition
to.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>None of the competitors arriving to a sufficient number of balls,
they fell to <qex>ballot</qex> some others.</q> <rj><qau>Sir H.
Wotton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ballotade</ent><br/
<hw>Bal"lo*tade`</hw> <pr>(b<acr/l"l<osl/*t<aum/d` <it>or</it>
b<acr/l"l<osl/*t<amac/d`)</pr>, <pos>n.</pos> <ety>[F.
<ets>ballottade</ets>, fr. <ets>ballotter</ets> to toss. See
<er>Ballot</er>, <pos>v. i.</pos>]</ety> <fld>(Man.)</fld> <def>A leap
of a horse, as between two pillars, or upon a straight line, so that
when his four feet are in the air, he shows only the shoes of his hind
feet, without jerking out.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ballotage</ent><br/
<hw>Bal"lot*age</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F.
<ets>ballottage</ets>.]</ety> <def>In France, a second ballot taken
after an indecisive first ballot to decide between two or several
candidates; a <altname>runoff election</altname>.</def><br/
[<source>Webster 1913 Suppl.</source> <source>+PJC</source>]</p>

<p><ent>Ballotation</ent><br/
<hw>Bal`lo*ta"tion</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>Voting by
ballot.</def> <mark>[Obs.]</mark> <rj><au>Sir H. Wotton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Balloter</ent><br/
<hw>Bal"lot*er</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>One who votes by
ballot.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ballotin</ent><br/
<hw>Bal"lo*tin</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[F.]</ety>
<def>An officer who has charge of a ballot box.</def>
<mark>[Obs.]</mark> <rj><au>Harrington.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ballow</ent><br/
<hw>Bal"low</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>A cudgel.</def>
<mark>[Obs.]</mark> <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>ballplayer</ent><br/
<hw>ballplayer</hw> <pos>n.</pos> <sn>1.</sn> <def>an athlete who plays
baseball.</def><br/
<syn><b>Syn. --</b> baseball player.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>ballpoint</ent><br/
<hw>ballpoint</hw> <pos>n.</pos> <def>a pen which has a small metal ball
as point of transfer of ink to paper, at the tip of a cylindrical and
non-refillable reservoir of ink; -- short for <altname>ballpoint
pen</altname>.</def><br/
<syn><b>Syn. --</b> ballpoint pen, ballpen, Biro.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Ballproof</ent><br/
<hw>Ball"proof`</hw> <pr>(<?/)</pr>, <pos>a.</pos> <def>Incapable of
being penetrated by balls from firearms; bulletproof.</def><br/
[<source>1913 Webster</source> <source>+PJC</source>]</p>

<p><ent>Ballroom</ent><br/
<hw>Ball"room`</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>A room for balls
or dancing.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>balls</ent><br/
<hw>balls</hw>, <pos>interj.</pos> <def>nonsense.</def><br/
[<source>PJC</source>]</p>

<p><ent>ball-shaped</ent><br/
<hw>ball-shaped</hw> <pos>adj.</pos> <def>shaped like a
sphere.</def><br/
<syn><b>Syn. --</b> global, globose, globular, orbicular, spheric,
spherical.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>balls-up</ent><br/
<hw>balls-up</hw> <pos>n.</pos> <def>something badly botched or muddled;
a foul-up.</def> <mark>[British]</mark> <br/
<syn><b>Syn. --</b> ballup, cockup, mess-up, foul-up.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>ballup</ent><br/
<hw>ballup</hw> <pos>n.</pos> <def>same as <er>balls-up</er>.</def>
<mark>[British]</mark> <br/
<syn><b>Syn. --</b> balls-up, cockup, mess-up, foul-up.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>bally</ent><br/
<hw>bally</hw> <pos>adj. prenom.</pos> <def>an informal
intensifier.</def><br/
<syn><b>Syn. --</b> blinking(prenominal), bloody(prenominal),
crashing(prenominal), flaming(prenominal),
fucking(prenominal)[vulgar].</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>ballyhoo</ent><br/
<hw>bal"ly*hoo</hw> <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos>
<conjf>ballyhooed</conjf> <pr>(<?/)</pr>; <pos>p. pr. & vb. n.</pos>
<conjf>ballyhooing</conjf> <pr>(<?/)</pr>.]</vmorph> <def>to advertize
or publicize noisily or blatantly.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>ballyhoo</ent><br/
<hw>bal"ly*hoo</hw> <pos>n.</pos> <def>noisy or blatant advertizing or
publicity.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>ballyrag</ent><br/
<hw>ballyrag</hw> <pos>v.</pos> <def>to be bossy towards; same as
<er>bullyrag</er>.</def><br/
<syn><b>Syn. --</b> strong-arm, bully, browbeat, bullyrag, bullirag,
ballarag, boss around, hector, push around.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Balm</ent><br/
<hw>Balm</hw> <pr>(b<aum/m)</pr>, <pos>n.</pos> <ety>[OE.
<ets>baume</ets>, OF. <ets>bausme</ets>, <ets>basme</ets>, F.
<ets>baume</ets>, L. <ets>balsamum</ets> balsam, from Gr.
<grk>ba`lsamon</grk>; perhaps of Semitic origin; cf. Heb.
<ets>b<amac/s<amac/m</ets>. Cf. <er>Balsam</er>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <fld>(Bot.)</fld> <def>An aromatic plant of the genus
<gen>Melissa</gen>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The resinous and aromatic exudation of certain trees
or shrubs.</def> <rj><au>Dryden.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Any fragrant ointment.</def>
<rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>Anything that heals or that mitigates pain.</def>
<ldquo/<xex>Balm</xex> for each ill.<rdquo/ <rj><au>Mrs.
Hemans.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Balm cricket</b></col> <fld>(Zool.)</fld>, <cd>the
European cicada.</cd> <au>Tennyson.</au> -- <col><b>Balm of
Gilead</b></col> <fld>(Bot.)</fld>, <cd>a small evergreen African and
Asiatic tree of the terebinthine family (<spn>Balsamodendron
Gileadense</spn>). Its leaves yield, when bruised, a strong aromatic
scent; and from this tree is obtained the <xex>balm of Gilead</xex> of
the shops, or <xex>balsam of Mecca</xex>. This has a yellowish or
greenish color, a warm, bitterish, aromatic taste, and a fragrant smell.
It is valued as an unguent and cosmetic by the Turks. The fragrant herb
<spn>Dracocephalum Canariense</spn> is familiarly called <xex>balm of
Gilead</xex>, and so are the American trees, <spn>Populus
balsamifera</spn>, variety <varn>candicans</varn> (balsam poplar), and
<spn>Abies balsamea</spn> (balsam fir).</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Balm</ent><br/
<hw>Balm</hw>, <pos>v. t.</pos> <def>To anoint with balm, or with
anything medicinal.</def> <specif>Hence:</specif> <def>To soothe; to
mitigate.</def> <mark>[Archaic]</mark> <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Balmify</ent><br/
<hw>Balm"i*fy</hw> <pr>(<?/)</pr>, <pos>v. t.</pos>
<ety>[<ets>Balm</ets> + <ets>-fy</ets>.]</ety> <def>To render
balmy.</def> <mark>[Obs.]</mark> <rj><au>Cheyne.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Balmily</ent><br/
<hw>Balm"i*ly</hw>, <pos>adv.</pos> <def>In a balmy manner.</def>
<rj><au>Coleridge.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Balmoral</ent><br/
<hw>Bal*mor"al</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[From
<ets>Balmoral</ets> Castle, in Aberdeenshire, Scotland.]</ety>
<sn>1.</sn> <def>A long woolen petticoat, worn immediately under the
dress.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A kind of stout walking shoe, laced in
front.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>A man who uses his <qex>balmorals</qex> to tread on your toes.</q>
<rj><qau>George Eliot.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Balmy</ent><br/
<hw>Balm"y</hw> <pr>(<?/)</pr>, <pos>a.</pos> <sn>1.</sn> <def>Having
the qualities of balm; odoriferous; aromatic; assuaging; soothing;
refreshing; mild; <as>as, <ex>balmy</ex> weather</as>.</def> <ldquo/The
<xex>balmy</xex> breeze.<rdquo/ <rj><au>Tickell.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Tired nature's sweet restorer, <qex>balmy</qex> sleep!</q>
<rj><qau>Young.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Producing balm.</def> <ldquo/The <xex>balmy</xex>
tree.<rdquo/ <rj><au>Pope.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Highly eccentric or crazy.</def>
<mark>[Informal]</mark><br/
<syn><b>Syn. --</b> batty.</syn><br/
[<source>PJC</source>]</p>

<p><syn><b>Syn.</b> -- Fragrant; sweet-scented; odorous; spicy;
refreshing; soothing.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Balneal</ent><br/
<hw>Bal"ne*al</hw> <pr>(<?/)</pr>, <pos>a.</pos> <ety>[L.
<ets>balneum</ets> bath.]</ety> <def>Of or pertaining to a bath.</def>
<rj><au>Howell.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Balneary</ent><br/
<hw>Bal"ne*a*ry</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[L.
<ets>balnearium</ets>, fr. <ets>balneum</ets> bath.]</ety> <def>A
bathing room.</def> <rj><au>Sir T. Browne.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Balneation</ent><br/
<hw>Bal`ne*a"tion</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[LL.
<ets>balneare</ets> to bathe, fr. L. <ets>balneum</ets> bath.]</ety>
<def>The act of bathing.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Balneatory</ent><br/
<hw>Bal"ne*a*to*ry</hw> <pr>(<?/)</pr>, <pos>a.</pos> <ety>[L.
<ets>balneatorius</ets>.]</ety> <def>Belonging to a bath.</def>
<mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Balneography</ent><br/
<hw>Bal`ne*og"ra*phy</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[L.
<ets>balneum</ets> bath + <ets>-graphy</ets>.]</ety> <def>A description
of baths.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Balneology</ent><br/
<hw>Bal`ne*ol"o*gy</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[L.
<ets>balneum</ets> bath + <ets>-logy</ets>.]</ety> <def>A treatise on
baths; the science of bathing.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>balneotherapy</ent><br/
<hw>bal`ne*o*ther"a*py</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[L.
<ets>balneum</ets> bath + Gr. <grk>qerapey`ein</grk> to heal.]</ety>
<def>The treatment of disease by baths.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>baloney</ent><br/
<hw>ba*lo"ney</hw> <pr>(<?/)</pr>, <pos>n.</pos> <sn>1.</sn>
<ety>[Believed to be derived form <ets>balogna</ets>, but perhaps also
influenced by <ets>blarney</ets>.]</ety> <def>nonsense; foolishness;
bunk; -- also used as an interjection.</def> <altsp>[Also spelled
<asp>boloney</asp>.]</altsp> <mark>[slang]</mark><br/
[<source>PJC</source>]</p>

<p><q>No matter how thin you slice it, it's still
<qex>baloney</qex>!</q> <rj><qau>Al Smith.</qau></rj><br/
[<source>PJC</source>]</p>

<p><sn>2.</sn> <def>informal variant of <er>bologna{2}</er>, for
<altname>bologna sausage</altname>.</def> <mark>[informal]</mark> <br/
[<source>PJC</source>]</p>

<p><ent>Balopticon</ent><br/
<hw>Bal*op"ti*con</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr.
<grk>balei^n</grk> to throw + <ets>stereopticon</ets>.]</ety> <def>See
<er>Projector</er>, below.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Balotade</ent><br/
<hw>Bal"o*tade`</hw> <pr>(b<acr/l"l<osl/*t<aum/d` <it>or</it>
b<acr/l"l<osl/*t<amac/d`)</pr>, <pos>n.</pos> <def>See
<er>Ballotade</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Balsa</ent><br/
\'d8<hw>Bal"sa</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[Sp. or Pg.
<ets>balsa</ets>.]</ety> <fld>(Naut.)</fld> <def>A raft or float, used
principally on the Pacific coast of South America.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Balsam</ent><br/
<hw>Bal"sam</hw> <pr>(b<add/l"s<ait/m)</pr>, <pos>n.</pos> <ety>[L.
<ets>balsamum</ets> the balsam tree or its resin, Gr.
<grk>ba`lsamon</grk>. See <er>Balm</er>, <pos>n.</pos>]</ety>
<sn>1.</sn> <def>A resin containing more or less of an essential or
volatile oil.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ The balsams are aromatic resinous substances, flowing
spontaneously or by incision from certain plants. A great variety of
substances pass under this name, but the term is now usually restricted
to resins which, in addition to a volatile oil, contain benzoic and
cinnamic acid. Among the true balsams are the balm of Gilead, and the
balsams of copaiba, Peru, and Tolu. There are also many pharmaceutical
preparations and resinous substances, possessed of a balsamic smell, to
which the name <xex>balsam</xex> has been given.</note><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Bot.)</fld> <sd>(a)</sd> <def>A species of tree
(<spn>Abies balsamea</spn>).</def> <sd>(b)</sd> <def>An annual garden
plant (<spn>Impatiens balsamina</spn>) with beautiful flowers;
balsamine.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Anything that heals, soothes, or restores.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Was not the people's blessing a <qex>balsam</qex> to thy
blood?</q> <rj><qau>Tennyson.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Balsam apple</b></col> <fld>(Bot.)</fld>, <cd>an East
Indian plant (<spn>Momordica balsamina</spn>), of the gourd family, with
red or orange-yellow cucumber-shaped fruit of the size of a walnut, used
as a vulnerary, and in liniments and poultices.</cd> -- <col><b>Balsam
fir</b></col> <fld>(Bot.)</fld>, <cd>the American coniferous tree,
<spn>Abies balsamea</spn>, from which the useful Canada balsam is
derived.</cd> -- <col><b>Balsam of copaiba</b></col>. <cd>See
<er>Copaiba</er>.</cd> -- <col><b>Balsam of Mecca</b></col>, <cd>balm of
Gilead.</cd> -- <col><b>Balsam of Peru</b></col>, <cd>a reddish brown,
syrupy balsam, obtained from a Central American tree (<spn>Myroxylon
Pereir<ae/</spn> and used as a stomachic and expectorant, and in the
treatment of ulcers, etc. It was long supposed to be a product of
Peru.</cd> -- <col><b>Balsam of Tolu</b></col>, <cd>a reddish or
yellowish brown semisolid or solid balsam, obtained from a South
American tree (<spn>Myroxylon toluiferum</spn>). It is highly fragrant,
and is used as a stomachic and expectorant.</cd> -- <col><b>Balsam
tree</b></col>, <cd>any tree from which balsam is obtained, esp. the
<spn>Abies balsamea</spn>.</cd> -- <mcol><col><b>Canada
balsam</b></col>, <col><b>Balsam of fir</b></col></mcol>, <cd>Canada
turpentine, a yellowish, viscid liquid, which, by time and exposure,
becomes a transparent solid mass. It is obtained from the balm of Gilead
(or balsam) fir (<spn>Abies balsamea</spn>) by breaking the vesicles
upon the trunk and branches. See <er>Balm</er>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Balsam</ent><br/
<hw>Bal"sam</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <def>To treat or
anoint with balsam; to relieve, as with balsam; to render
balsamic.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Balsamation</ent><br/
<hw>Bal`sam*a"tion</hw> <pr>(b<add/l`s<ait/m*<amac/"sh<ucr/n <it>or</it>
b<acr/l`s<ait/m*<amac/"sh<ucr/n)</pr>, <pos>n.</pos> <sn>1.</sn>
<def>The act of imparting balsamic properties.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The art or process of embalming.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Balsamical</ent><br/
<ent>Balsamic</ent><br/
<mhw>{ <hw>Bal*sam"ic</hw> <pr>(b<add/l*s<acr/m"<icr/k <it>or</it>
b<acr/l*s<acr/m"<icr/k; 277)</pr>, <hw>Bal*sam"ic*al</hw>
<pr>(<?/)</pr>, }</mhw> <pos>a.</pos> <ety>[Cf. F.
<ets>balsamique</ets>.]</ety> <def>Having the qualities of balsam;
containing, or resembling, balsam; soft; mitigative; soothing;
restorative.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Balsamiferous</ent><br/
<hw>Bal`sam*if"er*ous</hw> <pr>(b<add/l`s<ait/m*<icr/f"<etil/r*<ucr/s
<it>or</it> b<acr/l`s<ait/m*<icr/f"<etil/r*<ucr/s)</pr>, <pos>a.</pos>
<ety>[<ets>Balsam</ets> + <ets>-ferous</ets>.]</ety> <def>Producing
balsam.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Balsaminaceae</ent><br/
<hw>Balsaminaceae</hw> <pos>n.</pos> <def>a natural family comprising
the balsams, distinguished from the family <fam>Geraniaceae</fam> by the
irregular flowers.</def><br/
<syn><b>Syn. --</b> family Balsaminaceae, balsam family.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Balsamine</ent><br/
<hw>Bal"sam*ine</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[Cf. F.
<ets>balsamine</ets>, fr. Gr. <grk>balsami`nh</grk> balsam plant.]</ety>
<fld>(Bot.)</fld> <def>The <spn>Impatiens balsamina</spn>, or garden
balsam.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Balsamorhiza</ent><br/
<hw>Balsamorhiza</hw> <pos>n.</pos> <def>genus of coarse West American
herbs with large roots containing an aromatic balsam.</def><br/
<syn><b>Syn. --</b> genus Balsamorhiza.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Balsamous</ent><br/
<hw>Bal"sam*ous</hw> <pr>(<?/)</pr>, <pos>a.</pos> <def>Having the
quality of balsam; containing balsam.</def> <ldquo/A
<xex>balsamous</xex> substance.<rdquo/ <rj><au>Sterne.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>balsamroot</ent><br/
<hw>balsamroot</hw> <pos>n.</pos> <def>a plant of the genus
<gen>Balsamorhiza</gen> having white-downy leaves in a basal rosette and
yellow flowers and long balsam-scented taproots.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Balter</ent><br/
<hw>Bal"ter</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <ety>[Etymol.
uncertain. Cf. <er>Bloodboltered</er>.]</ety> <def>To stick
together.</def> <mark>[Obs.]</mark> <rj><au>Holland.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baltic</ent><br/
<hw>Bal"tic</hw> <pr>(<?/)</pr>, <pos>a.</pos> <ety>[NL. mare
<ets>Balticum</ets>, fr. L. <ets>balteus</ets> belt, from certain
straits or channels surrounding its isles, called belts. See
<er>Belt</er>.]</ety> <def>Of or pertaining to the sea which separates
Norway and Sweden from Jutland, Denmark, and Germany; situated on the
Baltic Sea.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baltimore oriole</ent><br/
<ent>Baltimore bird</ent><br/
<mhw>{ <hw>Bal"ti*more bird`</hw> <pr>(<?/)</pr>, <hw>Bal"ti*more
o"ri*ole</hw> <pr>(<?/)</pr>. }</mhw> <fld>(Zool.)</fld> <def>A common
bird (<spn>Icterus galbula</spn>) of eastern and central America and
Canada, named after <person>Lord <etsep>Baltimore</etsep></person>,
because its colors (black and orange red) are like those of his coat of
arms; -- called also <altname>golden robin</altname>. It winters in the
American tropics.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baluster</ent><br/
<hw>Bal"us*ter</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[F.
<ets>balustre</ets>, It. <ets>balaustro</ets>, fr. L.
<ets>balaustium</ets> the flower of the wild pomegranate, fr. Gr.
<grk>balay`stion</grk>; -- so named from the similarity of form.]</ety>
<fld>(Arch.)</fld> <def>A small column or pilaster, used as a support to
the rail of an open parapet, to guard the side of a staircase, or the
front of a gallery. See <er>Balustrade</er>.</def> <altsp>[Corrupted
into <asp>banister</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><ent>Balustered</ent><br/
<hw>Bal"us*tered</hw> <pr>(-t<etil/rd)</pr>, <pos>a.</pos> <def>Having
balusters.</def> <rj><au>Dryden.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Balustrade</ent><br/
<hw>Bal"us*trade`</hw> <pr>(-tr<amac/d`)</pr>, <pos>n.</pos> <ety>[F.
<ets>balustrade</ets>, It. <ets>balaustrata</ets> fr.
<ets>balaustro</ets>. See <er>Baluster</er>.]</ety> <fld>(Arch.)</fld>
<def>A row of balusters topped by a rail, serving as an open parapet, as
along the edge of a balcony, terrace, bridge, or the eaves of a
building, or as a guard railing on a staircase; -- it serves as a guard
to prevent people from falling.</def><br/
<syn><b>Syn. --</b> bannister, banister, balusters, handrail, guard
rail.</syn><br/
[<source>1913 Webster</source> <source>+PJC</source>]</p>

<p><ent>Balzac</ent><br/
<hw>Balzac</hw> <pos>n.</pos> <def>Honore de Balzac, a French novelist;
b. 1799, d. 1850.</def> <mark>[Person]</mark> <br/
<syn><b>Syn. --</b> Honore Balzac.</syn>
[<source>WordNet 1.5</source> <source>+PJC</source>]</p>

<p><ent>Balzacian</ent><br/
<hw>Balzacian</hw> <pos>adj.</pos> <def>of, pertaining to, or
characteristic of Honore Balzac.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>bam</ent><br/
<hw>bam</hw> <pr>(b<acr/m)</pr>, <pos>n.</pos> <ety>[Prob. a contr. of
<ets>bamboozle</ets>.]</ety> <def>An imposition; a cheat; a hoax.</def>
<rj><au>Garrick.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>To relieve the tedium, he kept plying them with all manner of
<qex>bams</qex>.</q> <rj><qau>Prof. Wilson.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bam</ent><br/
<hw>Bam</hw>, <pos>v. t.</pos> <def>To cheat; to wheedle.</def>
<mark>[Slang]</mark> <rj><au>Foote.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bamako</ent><br/
<hw>Bamako</hw> <pos>prop. n.</pos> <fld>(Geography)</fld> <def>The
capital <isa>city</isa> of <country>Mali</country>. Population (2000) =
746,000.</def><br/
[<source>PJC</source>]</p>

<p><ent>Bambino</ent><br/
\'d8<hw>Bam*bi"no</hw> <pr>(b<aum/m*b<emac/"n<osl/)</pr>, <pos>n.</pos>;
<plu><it>It. pl.</it> <plw>-ni</plw> <pr>(#)</pr></plu>. <ety>[It., a
little boy, fr. <ets>bambo</ets> silly; cf. Gr. <grk>bambali`zein</grk>,
<grk>bambai`nein</grk>, to chatter.]</ety> <sn>1.</sn> <def>A child or
baby; esp., a representation in art of the infant Christ wrapped in
swaddling clothes.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><sn>2.</sn> <fld>(Sports)</fld> <def>George Herman Ruth ("Babe"
Ruth), the baseball player; -- usu. in the form <ldquo/the
bambino<rdquo/.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bambocciade</ent><br/
<hw>Bam*boc`ci*ade"</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[It.
<ets>bambocciata</ets>, fr. <ets>Bamboccio</ets> a nickname of Peter Van
Laer, a Dutch genre painter; properly, a child, simpleton, puppet, fr.
<ets>bambo</ets> silly.]</ety> <fld>(Paint.)</fld> <def>A representation
of a grotesque scene from common or rustic life.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bamboo</ent><br/
<hw>Bam*boo"</hw> <pr>(b<acr/m*b<oomac/")</pr>, <pos>n.</pos>
<ety>[Malay <ets>bambu</ets>, <ets>mambu</ets>.]</ety> <fld>(Bot.)</fld>
<def>A plant of the family of grasses, and genus <gen>Bambusa</gen>,
growing in tropical countries.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ The most useful species is <spn>Bambusa
arundinacea</spn>, which has a woody, hollow, round, straight, jointed
stem, and grows to the height of forty feet and upward. The flowers grow
in large panicles, from the joints of the stalk, placed three in a
parcel, close to their receptacles. Old stalks grow to five or six
inches in diameter, and are so hard and durable as to be used for
building, and for all sorts of furniture, for water pipes, and for poles
to support palanquins. The smaller stalks are used for walking sticks,
flutes, etc.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bamboo</ent><br/
<hw>Bam*boo"</hw>, <pos>v. t.</pos> <def>To flog with the
bamboo.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bamboozle</ent><br/
<hw>Bam*boo"zle</hw> <pr>(b<acr/m*b<oomac/"z'l)</pr>, <pos>v. t.</pos>
<vmorph>[<pos>imp. & p. p.</pos> <conjf>Bamboozled</conjf>
<pr>(b<acr/m*b<oomac/"z'ld)</pr>; <pos>p. pr. & vb. n.</pos>
<conjf>Bamboozling</conjf>
<pr>(b<acr/m*b<oomac/"zl<icr/ng)</pr>.]</vmorph> <ety>[Said to be of
Gipsy origin.]</ety> <def>To deceive by trickery; to cajole by confusing
the senses; to hoax; to mystify; to humbug.</def> <mark>[Colloq.]</mark>
<rj><au>Addison.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>What oriental tomfoolery is <qex>bamboozling</qex> you?</q>
<rj><qau>J. H. Newman.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bamboozler</ent><br/
<hw>Bam*boo"zler</hw> <pr>(b<acr/m*b<oomac/"zl<etil/r)</pr>,
<pos>n.</pos> <def>A swindler; one who deceives by trickery.</def>
<mark>[Colloq.]</mark> <rj><au>Arbuthnot.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bambuseae</ent><br/
<hw>Bambuseae</hw> <pos>prop. n.</pos> <def>A tribe of plants comprising
the bamboos.</def><br/
<syn><b>Syn. --</b> tribe Bambuseae.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Ban</ent><br/
\'d8<hw>Ban</hw> <pr>(b<acr/n)</pr>, <pos>n.</pos> <def>A kind of fine
muslin, made in the East Indies from the fiber of the banana leaf
stalks.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ban</ent><br/
<hw>Ban</hw> <pr>(b<acr/n)</pr>, <pos>n.</pos> <ety>[AS. <ets>bann</ets>
command, edict; akin to D. <ets>ban</ets>, Icel. <ets>bann</ets>, Dan.
<ets>band</ets>, OHG. <ets>ban</ets>, G. <ets>bann</ets>, a public
proclamation, as of interdiction or excommunication, Gr.
<grk>fa`nai</grk> to say, L. <ets>fari</ets> to speak, Skr.
<ets>bhan</ets> to speak; cf. F. <ets>ban</ets>, LL. <ets>bannum</ets>,
of G. origin. <root/86. Cf. <er>Abandon</er>, <er>Fame</er>.]</ety>
<sn>1.</sn> <def>A public proclamation or edict; a public order or
notice, mandatory or prohibitory; a summons by public
proclamation.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Feudal & Mil.)</fld> <def>A calling together of the
king's (esp. the French king's) vassals for military service; also, the
body of vassals thus assembled or summoned. In present usage, in France
and Prussia, the most effective part of the population liable to
military duty and not in the standing army.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <pluf>pl.</pluf> <def>Notice of a proposed marriage,
proclaimed in church. See <er>Banns</er> (the common spelling in this
sense).</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>An interdiction, prohibition, or proscription.</def>
<ldquo/Under <xex>ban</xex> to touch.<rdquo/
<rj><au>Milton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>A curse or anathema.</def> <ldquo/Hecate's
<xex>ban</xex>.<rdquo/ <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <def>A pecuniary mulct or penalty laid upon a delinquent
for offending against a ban; as, a mulct paid to a bishop by one guilty
of sacrilege or other crimes.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Ban of the empire</b></col> <fld>(German Hist.)</fld>,
<cd>an imperial interdict by which political rights and privileges, as
those of a prince, city, or district, were taken away.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ban</ent><br/
<hw>Ban</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos>
<conjf>Banned</conjf> <pr>(b<acr/nd)</pr>; <pos>p. pr. & vb. n.</pos>
<conjf>Banning</conjf>.]</vmorph> <ety>[OE. <ets>bannen</ets>,
<ets>bannien</ets>, to summon, curse, AS. <ets>bannan</ets> to summon;
akin to Dan. <ets>bande</ets>, <ets>forbande</ets>, to curse, Sw.
<ets>banna</ets> to revile, <ets>bannas</ets> to curse. See <er>Ban</er>
an edict, and cf. <er>Banish</er>.]</ety> <sn>1.</sn> <def>To curse; to
invoke evil upon.</def> <rj><au>Sir W. Scott.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To forbid; to interdict.</def>
<rj><au>Byron.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ban</ent><br/
<hw>Ban</hw>, <pos>v. i.</pos> <def>To curse; to swear.</def>
<mark>[Obs.]</mark> <rj><au>Spenser.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ban</ent><br/
<hw>Ban</hw>, <pos>n.</pos> <ety>[Serv. <ets>ban</ets>; cf. Russ. & Pol.
<ets>pan</ets> a master, lord, Per. <ets>ban</ets>.]</ety> <def>An
ancient title of the warden of the eastern marches of Hungary; now, a
title of the viceroy of Croatia and Slavonia.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Banal</ent><br/
<hw>Ban"al</hw> <pr>(<?/)</pr>, <pos>a.</pos> <ety>[F., fr.
<ets>ban</ets> an ordinance.]</ety> <def>Commonplace; trivial;
hackneyed; trite.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Banality</ent><br/
<hw>Ba*nal"i*ty</hw> <pr>(<?/)</pr>, <pos>n.</pos>; <plu><it>pl.</it>
<plw>Banalities</plw> <pr>(<?/)</pr>.</plu> <ety>[F.
<ets>banalit<eacute/</ets>. See <er>Banal</er>.]</ety> <def>Something
commonplace, hackneyed, or trivial; the commonplace, in
speech.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The highest things were thus brought down to the
<qex>banalities</qex> of discourse.</q> <rj><qau>J.
Morley.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Banana</ent><br/
<hw>Ba*na"na</hw> <pr>(b<adot/*n<aum/"n<adot/; 277)</pr>, <pos>n.</pos>
<ety>[Sp. <ets>banana</ets>, name of the fruit.]</ety> <fld>(Bot.)</fld>
<def>A perennial herbaceous plant of almost treelike size (<spn>Musa
sapientum</spn>); also, its edible fruit. See <er>Musa</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ The banana has a soft, herbaceous stalk, with leaves of
great length and breadth. The flowers grow in bunches, covered with a
sheath of a green or purple color; the fruit is five or six inches long,
and over an inch in diameter; the pulp is soft, and of a luscious taste,
and is eaten either raw or cooked. This plant is a native of tropical
countries, and furnishes an important article of food.</note><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Banana bird</b></col> <fld>(Zool.)</fld>, <cd>a small
American bird (<spn>Icterus leucopteryx</spn>), which feeds on the
banana.</cd> -- <col><b>Banana quit</b></col> <fld>(Zool.)</fld>, <cd>a
small bird of tropical America, of the genus <gen>Certhiola</gen>,
allied to the creepers.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Banana solution</ent><br/
<hw>Ba*na"na so*lu"tion</hw>. <def>A solution used as a vehicle in
applying bronze pigments. In addition to acetone, benzine, and a little
pyroxylin, it contains amyl acetate, which gives it the odor of
bananas.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Banat</ent><br/
<hw>Ban"at</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[Cf. F. & G.
<ets>banat</ets>. See <er>Ban</er> a warden.]</ety> <def>The territory
governed by a ban.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bank</ent><br/
<ent>Bancus</ent><br/
<ent>Banc</ent><br/
<mhw>{ <hw>Banc</hw> <pr>(<?/)</pr>, \'d8<hw>Ban"cus</hw>
<pr>(<?/)</pr>, <hw>Bank</hw> <pr>(<?/)</pr>, }</mhw> <pos>n.</pos>
<ety>[OF. <ets>banc</ets>, LL. <ets>bancus</ets>. See <er>Bank</er>,
<pos>n.</pos>]</ety> <def>A bench; a high seat, or seat of distinction
or judgment; a tribunal or court.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><mcol><col><b>In banc</b></col>, <col><b>In banco</b></col> (the
ablative of <xex>bancus</xex>), <col><b>In bank</b></col></mcol>, <cd>in
full court, or with full judicial authority; <as>as, sittings <ex>in
banc</ex> (distinguished from sittings at <cref>nisi
prius</cref>)</as>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bancal</ent><br/
\'d8<hw>Ban*cal"</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu>pl.
<plw>-cales</plw> <pr>(#)</pr></plu>. <ety>[Sp., fr. <ets>banca</ets>,
<ets>banco</ets>, bench. Cf. <er>Bench</er>.]</ety> <def>An ornamental
covering, as of carpet or leather, for a bench or form.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Banco</ent><br/
\'d8<hw>Ban"co</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[It. See
<er>Bank</er>.]</ety> <def>A bank, especially that of Venice.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ This term is used in some parts of Europe to indicate
bank money, as distinguished from the current money, when this last has
become depreciated.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Band</ent><br/
<hw>Band</hw> <pr>(b<acr/nd)</pr>, <pos>n.</pos> <ety>[OE.
<ets>band</ets>, <ets>bond</ets>, Icel. <ets>band</ets>; akin to G.,
Sw., & D. <ets>band</ets>, OHG. <ets>bant</ets>, Goth. <ets>bandi</ets>,
Skr. <ets>bandha</ets> a binding, <ets>bandh</ets> to bind, for
<ets>bhanda</ets>, <ets>bhandh</ets>, also to E. <ets>bend</ets>,
<ets>bind</ets>. In sense 7, at least, it is fr. F. <ets>bande</ets>,
from OHG. <ets>bant</ets>. <root/90. See <er>Bind</er>, <pos>v.
t.</pos>, and cf. <er>Bend</er>, <er>Bond</er>, 1st
<er>Bandy</er>.]</ety> <sn>1.</sn> <def>A fillet, strap, or any narrow
ligament with which a thing is encircled, or fastened, or by which a
number of things are tied, bound together, or confined; a
fetter.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Every one's <qex>bands</qex> were loosed.</q> <rj><qau>Acts xvi.
26.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Arch.)</fld> <sd>(a)</sd> <def>A continuous tablet,
stripe, or series of ornaments, as of carved foliage, of color, or of
brickwork, etc.</def> <sd>(b)</sd> <def>In Gothic architecture, the
molding, or suite of moldings, which encircles the pillars and small
shafts.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>That which serves as the means of union or
connection between persons; a tie.</def> <ldquo/To join in Hymen's
<xex>bands</xex>.<rdquo/ <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>A linen collar or ruff worn in the 16th and 17th
centuries.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <pluf>pl.</pluf> <def>Two strips of linen hanging from
the neck in front as part of a clerical, legal, or academic
dress.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <def>A narrow strip of cloth or other material on any
article of dress, to bind, strengthen, ornament, or complete it.</def>
<ldquo/<xex>Band</xex> and gusset and seam.<rdquo/
<rj><au>Hood.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 116 pr=SA --></p>

<p><sn>7.</sn> <def>A company of persons united in any common design,
especially a body of armed men.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Troops of horsemen with his <qex>bands</qex> of foot.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>8.</sn> <def>A number of musicians who play together upon
portable musical instruments, especially those making a loud sound, as
certain wind instruments (trumpets, clarinets, etc.), and drums, or
cymbals; <as>as, a high school's marching <ex>band</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>9.</sn> <fld>(Bot.)</fld> <def>A space between elevated lines or
ribs, as of the fruits of umbelliferous plants.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>10.</sn> <fld>(Zool.)</fld> <def>A stripe, streak, or other mark
transverse to the axis of the body.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>11.</sn> <fld>(Mech.)</fld> <def>A belt or strap.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>12.</sn> <def>A bond.</def> <mark>[Obs.]</mark> <ldquo/Thy oath
and <xex>band</xex>.<rdquo/ <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>13.</sn> <def>Pledge; security.</def> <mark>[Obs.]</mark>
<rj><au>Spenser.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Band saw</b></col>, <cd>a saw in the form of an endless
steel belt, with teeth on one edge, running over wheels.</cd> --
<col><b>big band</b></col>, <cd>a band that is the size of an orchestra,
usually playing mostly jazz or swing music. The <ex>big band</ex>
typically features both ensemble and solo playing, sometimes has a lead
singer, and is often located in a night club where the patrons may dance
to its music. The <ex>big bands</ex> were popular from the late 1920's
to the 1940's. Contrasted with <er>combo</er>, which has fewer
players.</cd></cs><br/
[<source>1913 Webster</source> <source>+PJC</source>]</p>

<p><ent>Band</ent><br/
<hw>Band</hw> <pr>(b<acr/nd)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. &
p. p.</pos> <conjf>Banded</conjf>; <pos>p. pr. & vb. n.</pos>
<conjf>Banding</conjf>.]</vmorph> <sn>1.</sn> <def>To bind or tie with a
band.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To mark with a band.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To unite in a troop, company, or confederacy.</def>
<ldquo/<xex>Banded</xex> against his throne.<rdquo/
<rj><au>Milton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><mcol><col><b>Banded architrave</b></col>, <col><b>Banded
pier</b></col>, <col><b>Banded shaft</b></col>, etc.</mcol>
<fld>(Arch.)</fld>, <cd>an architrave, pier, shaft, etc., of which the
regular profile is interrupted by blocks or projections crossing it at
right angles.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Band</ent><br/
<hw>Band</hw>, <pos>v. i.</pos> <def>To confederate for some common
purpose; to unite; to conspire together.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Certain of the Jews <qex>banded</qex> together.</q> <rj><qau>Acts
xxiii. 12.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Band</ent><br/
<hw>Band</hw>, <pos>v. t.</pos> <def>To bandy; to drive away.</def>
<mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Band</ent><br/
<hw>Band</hw>, <def><pos>imp.</pos> of <er>Bind</er>.</def>
<mark>[Obs.]</mark> <rj><qau>Spenser.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bandage</ent><br/
<hw>Band"age</hw> <pr>(b<acr/nd"<asl/j)</pr>, <pos>n.</pos> <ety>[F.
<ets>bandage</ets>, fr. <ets>bande</ets>. See <er>Band</er>.]</ety>
<sn>1.</sn> <def>A fillet or strip of woven material, used in dressing
and binding up wounds, etc.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Something resembling a bandage; that which is bound
over or round something to cover, strengthen, or compress it; a
ligature.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Zeal too had a place among the rest, with a <qex>bandage</qex>
over her eyes.</q> <rj><qau>Addison.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bandage</ent><br/
<hw>Band"age</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos>
<conjf>Bandaged</conjf> <pr>(b<acr/nd"<asl/jd)</pr>; <pos>p. pr. & vb.
n.</pos> <conjf>Bandaging</conjf>
<pr>(b<acr/nd"<asl/*j<icr/ng)</pr>.]</vmorph> <def>To bind, dress, or
cover, with a bandage; <as>as, to <ex>bandage</ex> the
eyes</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Band Aid</ent><br/
<ent>band-aid</ent><br/
<ent>Band-Aid</ent><br/
<mhw><hw>Band"-Aid`</hw>, <hw>band"-aid`</hw>, <hw>Band" Aid</hw></mhw>
<pr>(b<acr/nd"<amac/d`)</pr> <pos>n.</pos> <ety>[from a
Trademark.]</ety> <def>An adhesive bandage, composed of a short ribbon
of cloth or plastic with an adhesive coating on one side, and having a
patch of gauze at the center. It is used to cover small cuts, abrasions,
or blisters on the skin, and may be easily applied to and removed from
the skin with no additional material. Originally a trademark, the term
has been popularly used generically.</def> <mark>[trademark]</mark><br/
[<source>WordNet 1.5</source>]</p>

<p><sn>2.</sn> <def>A hurried repair; a temporary fix for a minor
problem.</def> <note>The term has been used metaphorically to mean an
<sig>ineffective cosmetic solution</sig>, when used on a serious
problem.</note><br/
<syn><b>Syn. --</b> quick fix, quickie, quicky.</syn><br/
[<source>WordNet 1.5</source> <source>+PJC</source>]</p>

<p><ent>Bandala</ent><br/
\'d8<hw>Ban*da"la</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>A fabric made
in Manila from the older leaf sheaths of the <prodby>abaca</prodby>
(<spn>Musa textilis</spn>).</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bandana</ent><br/
<ent>Bandanna</ent><br/
<mhw>{ <hw>Ban*dan"na</hw>, <hw>Ban*dan"a</hw> }</mhw> <pr>(<?/)</pr>,
<pos>n.</pos> <ety>[Hind. <ets>b<amac/ndhn<umac/</ets> a mode of dyeing
in which the cloth is tied in different places so as to prevent the
parts tied from receiving the dye. Cf. <er>Band</er>,
<pos>n.</pos>]</ety> <sn>1.</sn> <def>A species of silk or cotton
handkerchief, having a uniformly dyed ground, usually of red or blue,
with white or yellow figures of a circular, lozenge, or other simple
form; -- it is often used as a neckerchief. The term is also used for
any large and brightly colored handkerchief.</def><br/
[<source>1913 Webster</source> + <source>WordNet 1.5</source>]</p>

<p><sn>2.</sn> <specif>Hence:</specif> <def>Any scarf worn on the neck
or head, usually of large size.</def><br/
[<source>PJC</source>]</p>

<p><sn>3.</sn> <def>A style of calico printing, in which white or bright
spots are produced upon cloth previously dyed of a uniform red or dark
color, by discharging portions of the color by chemical means, while the
rest of the cloth is under pressure.</def> <rj><au>Ure.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bandbox</ent><br/
<hw>Band"box`</hw> <pr>(b<acr/nd"b<ocr/ks`)</pr>, <pos>n.</pos> <def>A
light box of pasteboard or thin wood, usually cylindrical, for holding
ruffs (the <xex>bands</xex> of the 17th century), collars, caps,
bonnets, etc.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bandeau</ent><br/
\'d8<hw>Ban*deau"</hw> <pr>(b<acr/n*d<omac/"; b<acr/n"d<omac/)</pr>,
<pos>n.</pos>; <plu><it>pl.</it> <plw>Bandeaux</plw>
<pr>(b<acr/n*d<omac/z")</pr></plu>. <ety>[F.]</ety> <def>A narrow band
or fillet, as for the hair, part of a headdress, etc.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><q>Around the edge of this cap was a stiff <qex>bandeau</qex> of
leather.</q> <rj><qau>Sir W. Scott.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>bandelette</ent><br/
<ent>Bandlet</ent><br/
<ent>Bandelet</ent><br/
<mhw>{ <hw>Band"e*let</hw> <pr>(<?/)</pr>, <hw>Band"let</hw>,
<hw>bandelette</hw> }</mhw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[F.
<ets>bandelette</ets>, dim. of <ets>bande</ets>. See <er>Band</er>,
<pos>n.</pos>, and cf. <er>Bendlet</er>.]</ety> <fld>(Arch.)</fld>
<def>A small band or fillet; any little band or flat molding, compassing
a column, like a ring, and usually at the top of the column; an
annulet.</def> <rj><au>Gwilt.</au></rj><br/
<syn><b>Syn. --</b> annulet, bandelette, bandlet, square and
rabbet.</syn><br/
[<source>1913 Webster</source> + <source>WordNet 1.5</source>]</p>

<p><ent>Bander</ent><br/
<hw>Band"er</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>One banded with
others.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Banderilla</ent><br/
\'d8<hw>Ban`de*ril"la</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Sp., dim.
of <ets>bandera</ets> banner. See <er>Banner</er>, and cf.
<er>Banderole</er>.]</ety> <def>A barbed dart carrying a banderole which
the banderillero thrusts into the neck or shoulder of the bull in a
bullfight.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Banderillero</ent><br/
\'d8<hw>Ban`de*ril*le"ro</hw> <pr>(?)</pr>, <pos>n.</pos>
<ety>[Sp.]</ety> <def>One who thrusts in the banderillas in
bullfighting.</def> <rj><au>W. D. Howells.</au></rj><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Bandrol</ent><br/
<ent>Banderole</ent><br/
<mhw>{ <hw>Band"e*role</hw> <pr>(<?/)</pr>, <hw>Band"rol</hw> }</mhw>
<pr>(<?/)</pr>, <pos>n.</pos> <ety>[F. <ets>banderole</ets>, dim. of
<ets>bandi<egrave/re</ets>, <ets>banni<egrave/re</ets>, banner; cf. It.
<ets>banderuola</ets> a little banner. See <er>Banner</er>.]</ety>
<def>A little banner, flag, or streamer.</def> <altsp>[Written also
<asp>bannerol</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><q>From the extremity of which fluttered a small <qex>banderole</qex>
or streamer bearing a cross.</q> <rj><qau>Sir W. Scott.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Band fish</ent><br/
<hw>Band" fish`</hw> <pr>(<?/)</pr>. <fld>(Zool.)</fld> <def>A small red
fish of the genus <gen>Cepola</gen>; the ribbon fish.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bandicoot</ent><br/
<hw>Ban"di*coot</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[A corruption of
the native name.]</ety> <fld>(Zool.)</fld> <sd>(a)</sd> <def>A species
of very large rat (<spn>Mus giganteus</spn>), found in India and Ceylon.
It does much injury to rice fields and gardens.</def> <sd>(b)</sd>
<def>A ratlike marsupial animal (genus <gen>Perameles</gen>) of several
species, found in Australia and Tasmania.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>banding</ent><br/
<hw>banding</hw> <pos>n.</pos> <def>A strip or stripe of a contrasting
color or material.</def><br/
<syn><b>Syn. --</b> band, stripe.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Banding plane</ent><br/
<hw>Band"ing plane`</hw> <pr>(<?/)</pr>. <def>A plane used for cutting
out grooves and inlaying strings and bands in straight and circular
work.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bandit</ent><br/
<hw>Ban"dit</hw> <pr>(b<acr/n"d<icr/t)</pr>, <pos>n.</pos>;
<plu><it>pl.</it> <plw>Bandits</plw> <pr>(b<acr/n"d<icr/ts)</pr>,
<it>or</it> <plw>Banditti</plw> <pr>(b<acr/n*d<icr/t"t<icr/)</pr>.</plu>
<ety>[It. <ets>bandito</ets> outlaw, p. p. of <ets>bandire</ets> to
proclaim, to banish, to proscribe, LL. <ets>bandire</ets>,
<ets>bannire</ets>. See <er>Ban</er> an edict, and cf.
<er>Banish</er>.]</ety> <def>An outlaw; a brigand.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>No savage fierce, <qex>bandit</qex>, or mountaineer.</q>
<rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ The plural <xex>banditti</xex> was formerly used as a
collective noun.</note><br/
[<source>1913 Webster</source>]</p>

<p><q>Deerstealers are ever a desperate <qex>banditti</qex>.</q>
<rj><qau>Sir W. Scott.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bandle</ent><br/
<hw>Ban"dle</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[Ir.
<ets>bannlamh</ets> cubit, fr. <ets>bann</ets> a measure +
<ets>lamh</ets> hand, arm.]</ety> <def>An Irish measure of two feet in
length.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>bandleader</ent><br/
<hw>band"lead`er</hw> <pos>n.</pos> <def>The leader of a dance
band.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Bandlet</ent><br/
<hw>Band"let</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>Same as
<er>Bandelet</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bandmaster</ent><br/
<hw>Band"mas`ter</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>The conductor
of a musical band.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bandog</ent><br/
<hw>Ban"dog`</hw> <pr>(b<acr/n"d<ocr/g`; 115)</pr>, <pos>n.</pos>
<ety>[<ets>Band</ets> + <ets>dog</ets>, i.e., bound dog.]</ety> <def>A
mastiff or other large and fierce dog, usually kept chained or tied
up.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The keeper entered leading his <qex>bandog</qex>, a large
bloodhound, tied in a leam, or band, from which he takes his name.</q>
<rj><qau>Sir W. Scott.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bandolier</ent><br/
<ent>Bandoleer</ent><br/
<mhw>{ <hw>Ban`do*leer"</hw>, <hw>Ban`do*lier"</hw> }</mhw>
<pr>(<?/)</pr>, <pos>n.</pos> <ety>[F. <ets>bandouli<egrave/re</ets>
(cf. It. <ets>bandoliera</ets>, Sp. <ets>bandolera</ets>), fr. F.
<ets>bande</ets> band, Sp. & It. <ets>banda</ets>. See <er>Band</er>,
<pos>n.</pos>]</ety> <sn>1.</sn> <def>A broad leather belt formerly worn
by soldiers over the right shoulder and across the breast under the left
arm. Originally it was used for supporting the musket and twelve cases
for charges, but later only as a cartridge belt.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>One of the leather or wooden cases in which the
charges of powder were carried.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bandoline</ent><br/
<hw>Ban"do*line</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[Perh. allied to
<ets>band</ets>.]</ety> <def>A glutinous pomatum for the hair.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bandon</ent><br/
<hw>Ban"don</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[OF.
<ets>bandon</ets>. See <er>Abandon</er>.]</ety> <def>Disposal; control;
license.</def> <mark>[Obs.]</mark> <rj><au>Rom. of R.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bandore</ent><br/
<hw>Ban"dore</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[Sp.
<ets>bandurria</ets>, fr. L. <ets>pandura</ets>, <ets>pandurium</ets>, a
musical instrument of three strings, fr. Gr. <grk>pandoy^ra</grk> a
three-stringed musical instrument. Cf. <er>Pandore</er>, <er>Banjo</er>,
<er>Mandolin</er>.]</ety> <def>A musical stringed instrument, similar in
form to a guitar; a pandore. It is now obsolete, but see
<er>bandura</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bandrol</ent><br/
<hw>Band"rol</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>Same as
<er>Banderole</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>bandura</ent><br/
<hw>ban*dur"a</hw> <pr>(b<acr/n*d<oomac/r"<adot/)</pr>, <pos>n.</pos>
<ety>[See <er>bandore</er>.]</ety> <def>A traditional Ukrainian stringed
musical instrument shaped like a lute, having many strings.</def><br/
[<source>PJC</source>]</p>

<p><ent>bandwagon</ent><br/
<hw>bandwagon</hw> <pos>n.</pos> <sn>1.</sn> <def>A popular trend that
attracts growing support.</def> <ldquo/when they saw how things were
going everybody jumped on the <ex>bandwagon</ex>.<rdquo/<br/
[<source>WordNet 1.5</source>]</p>

<p><sn>2.</sn> <def>A large ornate wagon for carrying a musical
band.</def> <ldquo/the <ex>bandwagon</ex> led the circus
parade<rdquo/<br/
[<source>WordNet 1.5</source>]</p>

<p><ent>bandwidth</ent><br/
<hw>band"width`</hw> <pos>n.</pos> <def>The maximum rate of information
transfer (measured in bits/second) that can be carried by a
communication channel.</def> <ldquo/The <ex>bandwidth</ex> of an analog
telephone line is less than 100 kilobits per second.<rdquo/<br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Bandy</ent><br/
<hw>Ban"dy</hw> <pr>(b<acr/n"d<ycr/)</pr>, <pos>n.</pos> <ety>[Telugu
<ets>ba<nsdot/<dsdot/i</ets>.]</ety> <def>A carriage or cart used in
India, esp. one drawn by bullocks.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bandy</ent><br/
<hw>Ban"dy</hw>, <pos>n.</pos>; <plu><it>pl.</it> <plw>Bandies</plw>
<pr>(-d<icr/z)</pr>.</plu> <ety>[Cf. F. <ets>band<eacute/</ets>, p. p.
of <ets>bander</ets> to bind, to bend (a bow), to bandy, fr.
<ets>bande</ets>. See <er>Band</er>, <pos>n.</pos>]</ety> <sn>1.</sn>
<def>A club bent at the lower part for striking a ball at play; a hockey
stick.</def> <rj><au>Johnson.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The game played with such a club; hockey; shinney;
bandy ball.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bandy</ent><br/
<hw>Ban"dy</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos>
<conjf>Bandied</conjf> <pr>(b<acr/n"d<esl/d)</pr>; <pos>p. pr. & vb.
n.</pos> <conjf>Bandying</conjf>.]</vmorph> <sn>1.</sn> <def>To beat to
and fro, as a ball in playing at bandy.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Like tennis balls <qex>bandied</qex> and struck upon us . . . by
rackets from without.</q> <rj><qau>Cudworth.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To give and receive reciprocally; to exchange.</def>
<ldquo/To <xex>bandy</xex> hasty words.<rdquo/
<rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To toss about, as from person to person; to
circulate freely in a light manner; -- of ideas, facts, rumors,
etc.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Let not obvious and known truth be <qex>bandied</qex> about in a
disputation.</q> <rj><qau>I. Watts.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bandy</ent><br/
<hw>Ban"dy</hw>, <pos>v. i.</pos> <def>To contend, as at some game in
which each strives to drive the ball his own way.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Fit to <qex>bandy</qex> with thy lawless sons.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bandy</ent><br/
<hw>Ban"dy</hw>, <pos>a.</pos> <def>Bent; crooked; curved laterally,
esp. with the convex side outward; <as>as, a <ex>bandy</ex>
leg</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bandy-legged</ent><br/
<hw>Ban"dy-legged`</hw> <pr>(<?/)</pr>, <pos>a.</pos> <def>Having
crooked legs.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bane</ent><br/
<hw>Bane</hw> <pr>(b<amac/n)</pr>, <pos>n.</pos> <ety>[OE.
<ets>bane</ets> destruction, AS. <ets>bana</ets> murderer; akin to Icel.
<ets>bani</ets> death, murderer, OHG. <ets>bana</ets> murder,
<ets>bano</ets> murderer, Goth. <ets>banja</ets> stroke, wound, Gr.
<grk>foney`s</grk> murderer, <grk>fo`nos</grk> murder, OIr.
<ets>bath</ets> death, <ets>benim</ets> I strike. <root/31.]</ety>
<sn>1.</sn> <def>That which destroys life, esp. poison of a deadly
quality.</def> <mark>[Obs. except in combination, as in
rats<ex>bane</ex>, hen<ex>bane</ex>, etc.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Destruction; death.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>The cup of deception spiced and tempered to their
<qex>bane</qex>.</q> <rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Any cause of ruin, or lasting injury; harm;
woe.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Money, thou <qex>bane</qex> of bliss, and source of woe.</q>
<rj><qau>Herbert.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>A disease in sheep, commonly termed the
<altname>rot</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- Poison; ruin; destruction; injury;
pest.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bane</ent><br/
<hw>Bane</hw>, <pos>v. t.</pos> <def>To be the bane of; to ruin.</def>
<mark>[Obs.]</mark> <rj><au>Fuller.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baneberry</ent><br/
<hw>Bane"ber`ry</hw> <pr>(<?/)</pr>, <pos>n.</pos> <fld>(Bot.)</fld>
<def>A genus <gen>(Act<ae/a)</gen> of plants, of the order
<ord>Ranunculace<ae/</ord>, native in the north temperate zone. The red
or white berries are poisonous.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baneful</ent><br/
<hw>Bane"ful</hw> <pr>(<?/)</pr>, <pos>a.</pos> <def>Having poisonous
qualities; deadly; destructive; injurious; noxious; pernicious.</def>
<ldquo/<xex>Baneful</xex> hemlock.<rdquo/ <au>Garth.</au>
<ldquo/<xex>Baneful</xex> wrath.<rdquo/ <au>Chapman.</au><br/
[<source>1913 Webster</source>]</p>

<p> -- <wordforms><wf>Bane"ful*ly</wf>, <pos>adv.</pos>
--<wf>Bane"ful*ness</wf>, <pos>n.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Banewort</ent><br/
<hw>Bane"wort</hw> <pr>(<?/)</pr>, <pos>n.</pos> <fld>(Bot.)</fld>
<def>Deadly nightshade.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bang</ent><br/
<hw>Bang</hw> <pr>(b<acr/ng)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. &
p. p.</pos> <conjf>Banged</conjf>; <pos>p. pr. & vb. n.</pos>
<conjf>Banging</conjf>.]</vmorph> <ety>[Icel. <ets>banga</ets> to
hammer; akin to Dan. <ets>banke</ets> to beat, Sw.
<ets>b<aring/ngas</ets> to be impetuous, G. <ets>bengel</ets> club,
clapper of a bell.]</ety> <sn>1.</sn> <def>To beat, as with a club or
cudgel; to treat with violence; to handle roughly.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The desperate tempest hath so <qex>banged</qex> the Turks.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To beat or thump, or to cause (something) to hit or
strike against another object, in such a way as to make a loud noise;
<as>as, to <ex>bang</ex> a drum or a piano; to <ex>bang</ex> a door
(against the doorpost or casing) in shutting it</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To have sexual intercourse with; to fuck; -- usually
used with the male as a subject. Considered vulgar or obscene.</def>
<mark>[vulgar slang]</mark> <br/
[<source>PJC</source>]</p>

<p><ent>Bang</ent><br/
<hw>Bang</hw>, <pos>v. i.</pos> <sn>1.</sn> <def>To make a loud noise,
as if with a blow or succession of blows; <as>as, the window blind
<ex>banged</ex> and waked me; he was <ex>banging</ex> on the
piano</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To have sexual intercourse; to fuck. Considered
vulgar and obscene.</def> <mark>[vulgar slang]</mark> <br/
[<source>PJC</source>]</p>

<p><ent>Bang</ent><br/
<hw>Bang</hw>, <pos>n.</pos> <sn>1.</sn> <def>A blow as with a club; a
heavy blow.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Many a stiff thwack, many a <qex>bang</qex>.</q>
<rj><qau>Hudibras.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The loud sound produced by a sudden concussion or
explosion.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>A surge of pleasure; a thrill; -- usually used in
the phrase <ecol><b>get a bang out of</b></ecol>; <as>as, I always get a
<ex>bang</ex> out of watching an ice skater do a quadruple
jump</as>.</def> <mark>[informal]</mark> <br/
<syn><b>Syn. --</b> kick{5}.</syn><br/
[<source>PJC</source>]</p>

<p><sn>4.</sn> <fld>(Printing & Computers)</fld> <def>An exclamation
point; -- used in verbal descriptions of text, in printing and in
computer technology; <as>as, his email address is tom <ex>bang</ex>
stanford dot edu (i.e. tom!stanford.edu)</as>.</def>
<mark>[slang]</mark><br/
[<source>PJC</source>]</p>

<p><sn>5.</sn> <def>An instance of sexual intercourse; a fuck.
Considered vulgar and obscene.</def> <mark>[vulgar slang]</mark> <br/
[<source>PJC</source>]</p>

<p><ent>Bang</ent><br/
<hw>Bang</hw>, <pos>v. t.</pos> <def>To cut squarely across, as the tail
of a horse, or the forelock of human beings; to cut (the
hair).</def><br/
[<source>1913 Webster</source>]</p>

<p><q>His hair <qex>banged</qex> even with his eyebrows.</q>
<rj><qau>The Century Mag.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bang</ent><br/
<hw>Bang</hw>, <pos>n.</pos> <def>The short, front hair combed down over
the forehead, esp. when cut squarely across; a false front of hair
similarly worn; -- usually used in the plural; <as>as, her
<ex>bangs</ex> came down almost to her eyes</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>His hair cut in front like a young lady's <qex>bang</qex>.</q>
<rj><qau>W. D. Howells.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bangue</ent><br/
<ent>Bang</ent><br/
<mhw>{ <hw>Bang</hw>, <hw>Bangue</hw> }</mhw> <pr>(<?/)</pr>,
<pos>n.</pos> <def>See <er>Bhang</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Banging</ent><br/
<hw>Bang"ing</hw>, <pos>a.</pos> <def>Huge; great in size.</def>
<mark>[Colloq.]</mark> <rj><au>Forby.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bangkok</ent><br/
<hw>Bangkok</hw> <pos>prop. n.</pos> <fld>(Geography)</fld> <def>The
capital <isa>city</isa> of <country>Thailand</country>. Population
(2000) = 5,882,000.</def><br/
[<source>PJC</source>]</p>

<p><ent>Bangladesh</ent><br/
<hw>Bangladesh</hw> <pos>prop. n.</pos> <def>An independent Asian
country on the Bay of Bengal that was once part of India and then part
of Pakistan (called East Pakistan).</def><br/
<syn><b>Syn. --</b> Bangla Desh, East Pakistan.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Bangladeshi</ent><br/
<hw>Bangladeshi</hw> <pos>prop. n.</pos> <def>A native or inhabitant of
Bangladesh.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Bangladeshi</ent><br/
<hw>Bangladeshi</hw> <pos>prop. adj.</pos> <def>Of, pertaining to, or
characteristic of Bangladesh.</def> <illu><ex>Bangladeshi</ex>
dialects</illu><br/
<syn><b>Syn. --</b> East Pakistani.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Bangle</ent><br/
<hw>Ban"gle</hw> <pr>(b<acr/<nsm/"g'l)</pr>, <pos>v. t.</pos> <ety>[From
1st <er>Bang</er>.]</ety> <def>To waste by little and little; to fritter
away.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bangle</ent><br/
<hw>Ban"gle</hw>, <pos>n.</pos> <ety>[Hind. <ets>bangr<imac/</ets>
bracelet, bangle.]</ety> <def>An ornamental circlet, of glass, gold,
silver, or other material, worn mostly by women, upon the wrist or
ankle; a ring bracelet. It differs from other bracelets in being rigid
and not articulated, in contrast to bracelets made of links.</def><br/
[<source>1913 Webster</source> <source>+PJC</source>]</p>

<p><cs><col><b>Bangle ear</b></col>, <cd>a loose hanging ear of a horse,
like that of a spaniel.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>bangtail</ent><br/
<hw>bang"tail</hw> <pos>n.</pos> <sn>1.</sn> <def>a horse bred for
racing.</def><br/
<syn><b>Syn. --</b> racehorse, race horse.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Bangui</ent><br/
<hw>Bangui</hw> <pos>prop. n.</pos> <fld>(Geography)</fld> <def>The
capital <isa>city</isa> of <country>Central African Republic</country>.
Population (2000) = 706,000.</def><br/
[<source>PJC</source>]</p>

<p><ent>Banian</ent><br/
<hw>Ban"ian</hw> <pr>(b<acr/n"y<ait/n <it>or</it> b<acr/n*y<acr/n";
277)</pr>, <pos>n.</pos> <ety>[Skr. <ets>banij</ets> merchant. The tree
was so named by the English, because used as a market place by the
merchants.]</ety> <sn>1.</sn> <def>A Hindu trader, merchant, cashier, or
money changer.</def> <altsp>[Written also
<asp>banyan</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A man's loose gown, like that worn by the
Banians.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Bot.)</fld> <def>The Indian fig. See
<er>Banyan</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Banian days</b></col> <fld>(Naut.)</fld>, <cd>days in
which the sailors have no flesh meat served out to them. This use seems
to be borrowed from the Banians or Banya race, who eat no
flesh.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Banish</ent><br/
<hw>Ban"ish</hw> <pr>(b<acr/n"<icr/sh)</pr>, <pos>v. t.</pos>
<vmorph>[<pos>imp. & p. p.</pos> <conjf>Banished</conjf>
<pr>(b<acr/n"<icr/sht)</pr>; <pos>p. pr. & vb. n.</pos>
<conjf>Banishing</conjf>.]</vmorph> <ety>[OF. <ets>banir</ets>, F.
<ets>bannir</ets>, LL. <ets>bannire</ets>, fr. OHG. <ets>bannan</ets> to
summon, fr. <ets>ban</ets> ban. See <er>Ban</er> an edict, and
<er>Finish</er>, <pos>v. t.</pos>]</ety> <sn>1.</sn> <def>To condemn to
exile, or compel to leave one's country, by authority of the ruling
power.</def> <ldquo/We <xex>banish</xex> you our territories.<rdquo/
<rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To drive out, as from a home or familiar place; --
used with <xex>from</xex> and <xex>out of</xex>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>How the ancient Celtic tongue came to be <qex>banished</qex> from
the Low Countries in Scotland.</q> <rj><qau>Blair.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To drive away; to compel to depart; to dispel.</def>
<ldquo/<xex>Banish</xex> all offense.<rdquo/ <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- To <er>Banish</er>, <er>Exile</er>,
<er>Expel</er>.</syn> <usage>The idea of a coercive removal from a place
is common to these terms. A man is <xex>banished</xex> when he is forced
by the government of a country (be he a foreigner or a native) to leave
its borders. A man is <xex>exiled</xex> when he is driven into
banishment from his <xex>native</xex> country and home. Thus to
<xex>exile</xex> is to <xex>banish</xex>, but to <xex>banish</xex> is
not always to <xex>exile</xex>. To <xex>expel</xex> is to eject or
banish summarily or authoritatively, and usually under circumstances of
disgrace; <as>as, to <ex>expel</ex> from a college; <ex>expelled</ex>
from decent society</as>.</usage><br/
[<source>1913 Webster</source>]</p>

<p><ent>Banisher</ent><br/
<hw>Ban"ish*er</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>One who
banishes.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Banishment</ent><br/
<hw>Ban"ish*ment</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[Cf. F.
<ets>bannissement</ets>.]</ety> <def>The act of banishing, or the state
of being banished.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>He secured himself by the <qex>banishment</qex> of his
enemies.</q> <rj><qau>Johnson.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Round the wide world in <qex>banishment</qex> we roam.</q>
<rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- Expatriation; ostracism; expulsion; proscription;
exile; outlawry.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Banister</ent><br/
<hw>Ban"is*ter</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[A corruption of
<ets>baluster</ets>.]</ety> <sn>1.</sn> <def>A baluster.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> (<singf>sing.</singf> or <pluf>pl.</pluf>) <def>The
balustrade of a staircase. Formerly used in this sense mostly in the
plural, now mostly in the singular.</def> <altsp>[Also spelled
<asp>bannister</asp>.]</altsp><br/
[<source>1913 Webster</source> <source>+PJC</source>]</p>

<p><q>He struggled to ascend the pulpit stairs, holding hard on the
<qex>banisters</qex>.<rj> <qau>Sir W. Scott.</qau></rj></q></p>

<p><ent>banjo</ent><br/
<hw>ban"jo</hw> <pos>n.</pos> <ety>[Formerly also <ets>banjore</ets> and
<ets>banjer</ets>; corrupted from <ets>bandore</ets>, through negro
slave pronunciation.]</ety> <def>A stringed musical instrument having a
head and neck like the guitar, and a circular body like a tambourine. It
has five strings, and is played with the fingers and hands.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Banjul</ent><br/
<hw>Banjul</hw> <pos>prop. n.</pos> <fld>(Geography)</fld> <def>The
capital <isa>city</isa> of <country>Gambia</country>. Population (2000)
= 44,188,.</def><br/
[<source>PJC</source>]</p>

<p><ent>Bank</ent><br/
<hw>Bank</hw> <pr>(b<acr/<nsm/k)</pr>, <pos>n.</pos> <ety>[OE.
<ets>banke</ets>; akin to E. <ets>bench</ets>, and prob. of Scand.
origin; cf. Icel. <ets>bakki</ets>. See <er>Bench</er>.]</ety>
<sn>1.</sn> <def>A mound, pile, or ridge of earth, raised above the
surrounding level; hence, anything shaped like a mound or ridge of
earth; <as>as, a <ex>bank</ex> of clouds; a <ex>bank</ex> of
snow</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>They cast up a <qex>bank</qex> against the city.</q> <rj><qau>2
Sam. xx. 15.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A steep acclivity, as the slope of a hill, or the
side of a ravine.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>The margin of a watercourse; the rising ground
bordering a lake, river, or sea, or forming the edge of a cutting, or
other hollow.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Tiber trembled underneath her <qex>banks</qex>.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>An elevation, or rising ground, under the sea; a
shoal, shelf, or shallow; <as>as, the <ex>banks</ex> of
Newfoundland</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <fld>(Mining)</fld> <sd>(a)</sd> <def>The face of the
coal at which miners are working.</def> <sd>(b)</sd> <def>A deposit of
ore or coal, worked by excavations above water level.</def> <sd>(c)</sd>
<def>The ground at the top of a shaft; <as>as, ores are brought to
<ex>bank</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <fld>(A<eum/ronautics)</fld> <def>The lateral inclination
of an a<eum/roplane as it rounds a curve; <as>as, a <ex>bank</ex> of
45<deg/ is easy; a <ex>bank</ex> of 90<deg/ is dangerous</as>.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><sn>7.</sn> <def>A group or series of objects arranged near together;
<as>as, a <ex>bank</ex> of electric lamps, etc.</as></def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><sn>8.</sn> <def>The tilt of a roadway or railroad, at a curve in the
road, designed to counteract centrifugal forces acting on vehicles
moving rapidly around the curve, thus reducing the danger of overturning
during a turn.</def><br/
[<source>PJC</source>]</p>

<p><cs><col><b>Bank beaver</b></col> <fld>(Zool.)</fld>, <cd>the
otter.</cd> <mark>[Local, U.S.]</mark> -- <col><b>Bank
swallow</b></col>, <cd>a small American and European swallow
(<spn>Clivicola riparia</spn>) that nests in a hole which it excavates
in a bank.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bank</ent><br/
<hw>Bank</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos>
<conjf>Banked</conjf>(b<acr/<nsm/kt); <pos>p. pr. & vb. n.</pos>
<conjf>Banking</conjf>.]</vmorph> <sn>1.</sn> <def>To raise a mound or
dike about; to inclose, defend, or fortify with a bank; to embank.</def>
<ldquo/<xex>Banked</xex> well with earth.<rdquo/
<rj><au>Holland.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To heap or pile up; <as>as, to <ex>bank</ex>
sand</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To pass by the banks of.</def> <mark>[Obs.]</mark>
<rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <fld>(Engineering)</fld> <def>To build (a roadway or
railroad) with an inclination at a curve in the road, so as to
counteract centrifugal forces acting on vehicles moving rapidly around
the curve, thus reducing the danger of vehicles overturning at a curve;
<as>as, the raceway was steeply <ex>banked</ex> at the
curves</as>.</def><br/
[<source>PJC</source>]</p>

<p><cs><mcol><col><b>To bank a fire</b></col>, <col><b>To bank up a
fire</b></col></mcol>, <cd>to cover the coals or embers with ashes or
cinders, thus keeping the fire low but alive.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bank</ent><br/
<hw>Bank</hw>, <pos>n.</pos> <ety>[Prob. fr. F. <ets>banc</ets>. Of
German origin, and akin to E. <ets>bench</ets>. See
<er>Bench</er>.]</ety> <sn>1.</sn> <def>A bench, as for rowers in a
galley; also, a tier of oars.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Placed on their <qex>banks</qex>, the lusty Trojan sweep<br/
Neptune's smooth face, and cleave the yielding deep.</q>
<rj><qau>Waller.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Law)</fld> <sd>(a)</sd> <def>The bench or seat upon
which the judges sit.</def> <sd>(b)</sd> <def>The regular term of a
court of law, or the full court sitting to hear arguments upon questions
of law, as distinguished from a sitting at <xex>Nisi Prius</xex>, or a
court held for jury trials. See <er>Banc</er>.</def>
<rj><au>Burrill.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Printing)</fld> <def>A sort of table used by
printers.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <fld>(Music)</fld> <def>A bench, or row of keys belonging
to a keyboard, as in an organ.</def> <rj><au>Knight.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bank</ent><br/
<hw>Bank</hw>, <pos>n.</pos> <ety>[F. <ets>banque</ets>, It.
<ets>banca</ets>, orig. bench, table, counter, of German origin, and
akin to E. <ets>bench</ets>; cf. G. <ets>bank</ets> bench, OHG.
<ets>banch</ets>. See <er>Bench</er>, and cf. <er>Banco</er>,
<er>Beach</er>.]</ety> <sn>1.</sn> <def>An establishment for the
custody, loan, exchange, or issue, of money, and for facilitating the
transmission of funds by drafts or bills of exchange; an institution
incorporated for performing one or more of such functions, or the
stockholders (or their representatives, the directors), acting in their
corporate capacity.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The building or office used for banking
purposes.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>A fund to be used in transacting business,
especially a joint stock or capital.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Let it be no <qex>bank</qex> or common stock, but every man be
master of his own money.</q> <rj><qau>Bacon.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <fld>(Gaming)</fld> <def>The sum of money or the checks
which the dealer or banker has as a fund, from which to draw his stakes
and pay his losses.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>In certain games, as dominoes, a fund of pieces from
which the players are allowed to draw; in Monopoly, the fund of money
used to pay bonuses due to the players, or to which they pay
fines.</def><br/
[<source>1913 Webster</source> <source>+PJC</source>]</p>

<p><sn>6.</sn> <def>a place where something is stored and held available
for future use;</def> <specif>specifically</specif>, <def>an
organization that stores biological products for medical needs; <as>as,
a blood <ex>bank</ex>, an organ <ex>bank</ex>, a sperm
<ex>bank</ex></as>.</def><br/
[<source>PJC</source>]</p>

<p><cs><col><b>Bank credit</b></col>, <cd>a credit by which a person who
has given the required security to a bank has liberty to draw to a
certain extent agreed upon.</cd> -- <col><b>Bank of deposit</b></col>,
<cd>a bank which receives money for safe keeping.</cd> -- <col><b>Bank
of issue</b></col>, <cd>a bank which issues its own notes payable to
bearer.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bank</ent><br/
<hw>Bank</hw>, <pos>v. t.</pos> <def>To deposit in a bank.</def>
<rj><au>Johnson.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bank</ent><br/
<hw>Bank</hw>, <pos>v. i.</pos> <sn>1.</sn> <def>To keep a bank; to
carry on the business of a banker.</def><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 117 pr=SA --></p>

<p><sn>2.</sn> <def>To deposit money in a bank; to have an account with
a banker.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bank</ent><br/
<hw>Bank</hw>, <pos>v. i.</pos> <fld>(A<eum/ronautics)</fld> <def>To
tilt sidewise in rounding a curve; -- said of a flying machine, an
a<eum/rocurve, or the like.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Bankable</ent><br/
<hw>Bank"a*ble</hw> <pr>(b<acr/<nsm/k"<adot/*b'l)</pr>, <pos>a.</pos>
<def>Receivable at a bank.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bank bill</ent><br/
<hw>Bank" bill`</hw> <pr>(b<acr/<nsm/k" b<icr/l`)</pr>. <sn>1.</sn>
<def>In America (and formerly in England), a promissory note of a bank
payable to the bearer on demand, and used as currency; a bank
note.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>In England, a note, or a bill of exchange, of a
bank, payable to order, and usually at some future specified time. Such
bills are negotiable, but form, in the strict sense of the term, no part
of the currency.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bank book</ent><br/
<hw>Bank" book`</hw> <pr>(b<acr/<nsm/k" b<oocr/k`)</pr>. <def>A book
kept by a depositor, in which an officer of a bank enters the debits and
credits of the depositor's account with the bank.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bank discount</ent><br/
<hw>Bank discount</hw>. <def>A sum equal to the interest at a given rate
on the principal (face) of a bill or note from the time of discounting
until it becomes due.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Banker</ent><br/
<hw>Bank"er</hw> <pr>(b<acr/<nsm/k"<etil/r)</pr>, <pos>n.</pos><ety>[See
the nouns <er>Bank</er> and the verbs derived from them.]</ety>
<sn>1.</sn> <def>One who conducts the business of banking; one who,
individually, or as a member of a company, keeps an establishment for
the deposit or loan of money, or for traffic in money, bills of
exchange, etc.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A money changer.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>The dealer, or one who keeps the bank in a gambling
house.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>A vessel employed in the cod fishery on the banks of
Newfoundland.</def> <rj><au>Crabb.</au> <au>J. Q. Adams.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>A ditcher; a drain digger.</def> <mark>[Prov.
Eng.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <def>The stone bench on which masons cut or square their
work.</def> <rj><au>Weale.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bankeress</ent><br/
<hw>Bank"er*ess</hw> <pr>(b<acr/<nsm/k"<etil/r*<ecr/s)</pr>,
<pos>n.</pos> <def>A female banker.</def>
<rj><au>Thackeray.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bankia</ent><br/
<hw>Bankia</hw> <pos>n.</pos> <def>a genus consisting of giant
shipworms.</def><br/
<syn><b>Syn. --</b> genus <gen>Bankia</gen>.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Banking</ent><br/
<hw>Bank"ing</hw>, <pos>n.</pos> <def>The business of a bank or of a
banker.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Banking house</b></col>, <cd>an establishment or office
in which, or a firm by whom, banking is done.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>bank note</ent><br/
<ent>banknote</ent><br/
<mhw><hw>bank"note`</hw>, <hw>bank" note`</hw></mhw>
<pr>(b<acr/<nsm/k"n<omac/t`)</pr>. <sn>1.</sn> <def>A promissory note
issued by a bank or banking company, payable to the bearer on demand.
See also sense 4.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ In the United States popularly called a <altname>bank
bill</altname>.</note><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Formerly, a promissory note made by a banker, or
banking company, payable to a specified person at a fixed date; a bank
bill. See <er>Bank bill</er>, 2.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>A promissory note payable at a bank.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>A promissory note issued by an authorized bank,
payable to the bearer on demand and intended to circulate as
government-authorized money; in the United States such notes may only be
issued by a Federal Reserve Bank; <as>as, he peeled off five
one-thousand-zloty banknotes</as>.</def><br/
<syn><b>Syn. --</b> bill, note, government note, bank bill, banker's
bill, bank note, Federal Reserve note, greenback.</syn><br/
[<source>1913 Webster</source> <source>+PJC</source>]</p>

<p><ent>bank on</ent><br/
<hw>bank on</hw>, <pos>v. t.</pos> <def>Depend on; be confident
of.</def><br/
[<source>PJC</source>]</p>

<p><ent>bankroll</ent><br/
<hw>bankroll</hw> <pos>n.</pos> <sn>1.</sn> <def>the money carried on
one's person.</def> <rdquo/He shot his <ex>bankroll</ex> on a bob-tailed
nag.<rdquo/<br/
<syn><b>Syn. --</b> roll, wad.</syn><br/
[<source>WordNet 1.5</source> <source>+PJC</source>]</p>

<p><sn>2.</sn> <def>one's total supply of money; funds.</def><br/
[<source>PJC</source>]</p>

<p><ent>bankroll</ent><br/
<hw>bankroll</hw> <pos>v. t.</pos> <def>To pay the costs of; <as>as, Who
will <ex>bankroll</ex> the restoration of the former East German
economy?</as>.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Bankrupt</ent><br/
<hw>Bank"rupt</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[F.
<ets>banqueroute</ets>, fr. It. <ets>bancarotta</ets> bankruptcy;
<ets>banca</ets> bank (fr. OHG. <ets>banch</ets>, G. <ets>bank</ets>,
bench) + <ets>rotta</ets> broken, fr. L. <ets>ruptus</ets>, p. p. of
<ets>rumpere</ets> to break. At Florence, it is said, the bankrupt had
his bench (i.e., money table) broken. See 1st <er>Bank</er>, and
<er>Rupture</er>, <pos>n.</pos>]</ety> <sn>1.</sn> <fld>(Old Eng.
Law)</fld> <def>A trader who secretes himself, or does certain other
acts tending to defraud his creditors.</def>
<rj><au>Blackstone.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A trader who becomes unable to pay his debts; an
insolvent trader; popularly, any person who is unable to pay his debts;
an insolvent person.</def> <rj><au>M<lsquo/Culloch.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Law)</fld> <def>A person who, in accordance with
the terms of a law relating to bankruptcy, has been judicially declared
to be unable to meet his liabilities.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ In England, until the year 1861 none but a
<ldquo/trader<rdquo/ could be made a bankrupt; a non-trader failing to
meet his liabilities being an <ldquo/insolvent<rdquo/. But this
distinction was abolished by the Bankruptcy Act of 1861. The laws of
1841 and 1867 of the United States relating to bankruptcy applied this
designation <ex>bankrupt</ex> to others besides those engaged in
trade.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bankrupt</ent><br/
<hw>Bank"rupt</hw>, <pos>a.</pos> <sn>1.</sn> <def>Being a bankrupt or
in a condition of bankruptcy; unable to pay, or legally discharged from
paying, one's debts; <as>as, a <ex>bankrupt</ex>
merchant</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Depleted of money; not having the means of meeting
pecuniary liabilities; <as>as, a <ex>bankrupt</ex>
treasury</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Relating to bankrupts and bankruptcy.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>Destitute of, or wholly wanting (something once
possessed, or something one should possess).</def>
<ldquo/<xex>Bankrupt</xex> in gratitude.<rdquo/
<rj><au>Sheridan.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Bankrupt law</b></col>, <cd>a law by which the property
of a person who is unable or unwilling to pay his debts may be taken and
distributed to his creditors, and by which a person who has made a full
surrender of his property, and is free from fraud, may be discharged
from the legal obligation of his debts. See <er>Insolvent</er>,
<pos>a.</pos></cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bankrupt</ent><br/
<hw>Bank"rupt</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos>
<conjf>Bankrupted</conjf>; <pos>p. pr. & vb. n.</pos>
<conjf>Bankrupting</conjf>.]</vmorph> <def>To make bankrupt; to bring
financial ruin upon; to impoverish.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bankruptcy</ent><br/
<hw>Bank"rupt*cy</hw> <pr>(<?/)</pr>, <pos>n.</pos>; <plu><it>pl.</it>
<plw>Bankruptcies</plw> <pr>(<?/)</pr>.</plu> <sn>1.</sn> <def>The state
of being actually or legally bankrupt.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The act or process of becoming a bankrupt.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Complete loss; -- followed by
<xex>of</xex>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bankside</ent><br/
<hw>Bank"side`</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>The slope of a
bank, especially of the bank of a stream.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bank-sided</ent><br/
<hw>Bank"-sid`ed</hw> <pr>(<?/)</pr>, <pos>a.</pos> <fld>(Naut.)</fld>
<def>Having sides inclining inwards, as a ship; -- opposed to
<contr>wall-sided</contr>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bank swallow</ent><br/
<hw>Bank" swal"low</hw> <pr>(<?/)</pr>. <def>See under 1st
<er>Bank</er>, <pos>n.</pos></def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Banlieue</ent><br/
\'d8<hw>Ban"li*eue`</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[F., fr. LL.
<ets>bannum leucae</ets>, <ets>banleuca</ets>; <ets>bannum</ets>
jurisdiction + <ets>leuca</ets> league.]</ety> <def>The territory
without the walls, but within the legal limits, of a town or city.</def>
<rj><au>Brande & C.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Banner</ent><br/
<hw>Ban"ner</hw> <pr>(b<acr/n"n<etil/r)</pr>, <pos>n.</pos> <ety>[OE.
<ets>banere</ets>, OF. <ets>baniere</ets>, F.
<ets>banni<egrave/re</ets>, <ets>bandi<egrave/re</ets>, fr. LL.
<ets>baneria</ets>, <ets>banderia</ets>, fr. <ets>bandum</ets> banner,
fr. OHG. <ets>bant</ets> band, strip of cloth; cf. <ets>bindan</ets> to
bind, Goth. <ets>bandwa</ets>, <ets>bandwo</ets>, a sign. See
<er>Band</er>, <pos>n.</pos>]</ety> <sn>1.</sn> <def>A kind of flag
attached to a spear or pike by a crosspiece, and used by a chief as his
standard in battle.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Hang out our <qex>banners</qex> on the outward walls.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A large piece of silk or other cloth, with a device
or motto, extended on a crosspiece, and borne in a procession, or
suspended in some conspicuous place.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Any flag or standard; <as>as, the star-spangled
<ex>banner</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Banner fish</b></col> <fld>(Zool.)</fld>, <cd>a large
fish of the genus <gen>Histiophorus</gen>, of the Swordfish family,
having a broad bannerlike dorsal fin; the sailfish. One species
(<spn>Histiophorus Americanus</spn>) inhabits the <geog>North
Atlantic</geog>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bannered</ent><br/
<hw>Ban"nered</hw> <pr>(<?/)</pr>, <pos>a.</pos> <def>Furnished with, or
bearing, banners.</def> <ldquo/A <xex>bannered</xex> host.<rdquo/
<rj><au>Milton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Banneret</ent><br/
<hw>Ban"ner*et</hw> <pr>(<?/)</pr>, <pos>n.</pos><ety>[OE.
<ets>baneret</ets>, OF. <ets>baneret</ets>, F. <ets>banneret</ets>;
properly a dim. of OF. <ets>baniere</ets>. See
<er>Banner</er>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>Originally, a knight who led his vassals into the
field under his own banner; -- commonly used as a title of
rank.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A title of rank, conferred for heroic deeds, and
hence, an order of knighthood; also, the person bearing such title or
rank.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ The usual mode of conferring the rank on the field of
battle was by cutting or tearing off the point of the pennon or pointed
flag on the spear of the candidate, thereby making it a
banner.</note><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>A civil officer in some Swiss cantons.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>A small banner.</def> <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bannerol</ent><br/
<hw>Ban"ner*ol</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>A banderole; esp.
a banner displayed at a funeral procession and set over the tomb. See
<er>Banderole</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>banning-order</ent><br/
<hw>banning-order</hw> <pos>n.</pos> <def>an order that bans
something.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>bannister</ent><br/
<hw>bannister</hw> <pos>n.</pos> <def>same as
<er>banister</er>.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Bannition</ent><br/
<hw>Ban*ni"tion</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[LL.
<ets>bannitio</ets>. See <er>Banish</er>.]</ety> <def>The act of
expulsion.</def> <mark>[Obs.]</mark> <rj><au>Abp. Laud.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bannock</ent><br/
<hw>Ban"nock</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[Gael.
<ets>bonnach</ets>.]</ety> <def>A kind of cake or bread, in shape flat
and roundish, commonly made of oatmeal or barley meal and baked on an
iron plate, or griddle; -- used in Scotland and the northern counties of
England.</def> <rj><au>Jamieson.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Bannock fluke</b></col>, <cd>the turbot.</cd>
<mark>[Scot.]</mark></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bannockburn</ent><br/
<hw>Bannockburn</hw> <pos>prop. n.</pos> <def>A battle in which the
Scots under <person>Robert the Bruce</person> defeated the English and
assured the independence of Scotland.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Banns</ent><br/
<hw>Banns</hw> <pr>(b<acr/nz)</pr>, <pos>n. pl.</pos> <ety>[See
<er>Ban</er>.]</ety> <def>Notice of a proposed marriage, proclaimed in a
church, or other place prescribed by law, in order that any person may
object, if he knows of just cause why the marriage should not take
place.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Banquet</ent><br/
<hw>Ban"quet</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[F., a feast, prop.
a dim. of <ets>banc</ets> bench; cf. It. <ets>banchetto</ets>, dim. of
<ets>banco</ets> a bench, counter. See <er>Bank</er> a bench, and cf.
<er>Banquette</er>.]</ety> <sn>1.</sn> <def>A feast; a sumptuous
entertainment of eating and drinking; often, a complimentary or
ceremonious feast, followed by speeches.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A dessert; a course of sweetmeats; a sweetmeat or
sweetmeats.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>We'll dine in the great room, but let the music<br/
And <qex>banquet</qex> be prepared here.</q>
<rj><qau>Massinger.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Banquet</ent><br/
<hw>Ban"quet</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos>
<conjf>Banqueted</conjf>; <pos>p. pr. & vb. n.</pos>
<conjf>Banqueting</conjf>.]</vmorph> <def>To treat with a banquet or
sumptuous entertainment of food; to feast.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Just in time to <qex>banquet</qex><br/
The illustrious company assembled there.</q>
<rj><qau>Coleridge.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Banquet</ent><br/
<hw>Ban"quet</hw>, <pos>v. i.</pos> <sn>1.</sn> <def>To regale one's
self with good eating and drinking; to feast.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Were it a draught for Juno when she <qex>banquets</qex>,<br/
I would not taste thy treasonous offer.</q>
<rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To partake of a dessert after a feast.</def>
<mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>Where they did both sup and <qex>banquet</qex>.</q>
<rj><qau>Cavendish.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>banqueting</ent><br/
<hw>banqueting</hw> <pos>n.</pos> <def>Eating an elaborate meal (often
accompanied by entertainment).</def><br/
<syn><b>Syn. --</b> feasting.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Banquette</ent><br/
<hw>Ban*quette"</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A bench or seat
for passengers on the top of a diligence or other public
vehicle.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>My brother-in-law . . . took refuge in the
<qex>banquette</qex>.</q> <rj><qau>Mrs. Howe.</qau></rj><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Banquetter</ent><br/
<hw>Ban"quet*ter</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>One who
banquets; one who feasts or makes feasts.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Banquette</ent><br/
<hw>Ban*quette"</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[F. See
<er>Banquet</er>, <pos>n.</pos>]</ety> <sn>1.</sn> <fld>(Fort.)</fld>
<def>A raised way or foot bank, running along the inside of a parapet,
on which musketeers stand to fire upon the enemy.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Arch.)</fld> <def>A narrow window seat; a raised
shelf at the back or the top of a buffet or dresser.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Banshie</ent><br/
<ent>Banshee</ent><br/
<mhw>{ <hw>Ban"shee</hw>, <hw>Ban"shie</hw> <pr>(?)</pr> }</mhw>,
<pos>n.</pos> <ety>[Gael. <ets>bean-shith</ets> fairy; Gael. & Ir.
<ets>bean</ets> woman + Gael. <ets>sith</ets> fairy.]</ety> <fld>(Celtic
Folklore)</fld> <def>A supernatural being supposed to warn a family of
the approaching death of one of its members, by wailing or singing in a
mournful voice, as under the windows of the house.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Banstickle</ent><br/
<hw>Ban"stic`kle</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[OE.
<ets>ban</ets>, <ets>bon</ets>, bone + <ets>stickle</ets> prickle,
sting. See <er>Bone</er>, <pos>n.</pos>, <er>Stickleback</er>.]</ety>
<fld>(Zool.)</fld> <def>A small fish, the three-spined
stickleback.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bantam</ent><br/
<hw>Ban"tam</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>A variety of small
barnyard fowl, with feathered legs, probably brought from Bantam, a
district of Java.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bantam work</ent><br/
<hw>Ban"tam work`</hw>. <def>Carved and painted work in imitation of
Japan ware.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Banteng</ent><br/
\'d8<hw>Ban"teng</hw> <pr>(<?/)</pr>, <pos>n.</pos> <fld>(Zool.)</fld>
<def>The wild ox of Java (<spn>Bibos Banteng</spn>).</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Banter</ent><br/
<hw>Ban"ter</hw> <pr>(b<acr/n"t<etil/r)</pr>, <pos>v. t.</pos>
<vmorph>[<pos>imp. & p. p.</pos> <conjf>Bantered</conjf>
<pr>(b<acr/n"t<etil/rd)</pr>; <pos>p. pr. & vb. n.</pos>
<conjf>Bantering</conjf>.]</vmorph> <ety>[Prob. corrupted fr. F.
<ets>badiner</ets> to joke, or perh. fr. E. <ets>bandy</ets> to beat to
and fro. See <er>Badinage</er>, and cf. <er>Barter</er> fr. OF.
<ets>barater</ets>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>To address playful good-natured ridicule to, -- the
person addressed, or something pertaining to him, being the subject of
the jesting; to rally; <as>as, he <ex>bantered</ex> me about my
credulity</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Hag-ridden by my own fancy all night, and then <qex>bantered</qex>
on my haggard looks the next day.</q> <rj><qau>W. Irving.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To jest about; to ridicule in speaking of, as some
trait, habit, characteristic, and the like.</def>
<mark>[Archaic]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>If they <qex>banter</qex> your regularity, order, and love of
study, <qex>banter</qex> in return their neglect of them.</q>
<rj><qau>Chatham.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To delude or trick, -- esp. by way of jest.</def>
<mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>We diverted ourselves with <qex>bantering</qex> several poor
scholars with hopes of being at least his lordship's chaplain.</q>
<rj><qau>De Foe.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>To challenge or defy to a match.</def>
<mark>[Colloq. Southern and Western U. S.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Banter</ent><br/
<hw>Ban"ter</hw>, <pos>n.</pos> <def>The act of bantering; joking or
jesting; humorous or good-humored raillery; pleasantry.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Part <qex>banter</qex>, part affection.</q>
<rj><qau>Tennyson.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Banterer</ent><br/
<hw>Ban"ter*er</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>One who banters
or rallies.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bantingism</ent><br/
<hw>Ban"ting*ism</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>A method of
reducing corpulence by avoiding food containing much farinaceous,
saccharine, or oily matter; -- so called from <person>William
<etsep>Banting</etsep></person> of London.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bantling</ent><br/
<hw>Bant"ling</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[Prob. for
<ets>bandling</ets>, from <ets>band</ets>, and meaning a child wrapped
in swaddling bands; or cf. G. <ets>b<aum/ntling</ets> a bastard, fr.
<ets>bank</ets> bench. Cf. <er>Bastard</er>, <pos>n.</pos>]</ety> <def>A
young or small child; an infant.</def> <mark>[Slightly contemptuous or
depreciatory.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>In what out of the way corners genius produces her
<qex>bantlings</qex>.</q> <rj><qau>W. Irving.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bantu</ent><br/
<hw>Ban"tu</hw> <pr>(?)</pr>, <pos>prop. n.</pos> <def>A member of one
of the great family of Negroid tribes occupying equatorial and southern
Africa. These tribes include, as important divisions, the Kafirs,
Damaras, Bechuanas, and many tribes whose names begin with
<xex>Aba-</xex>, <xex>Ama-</xex>, <xex>Ba-</xex>, <xex>Ma-</xex>,
<xex>Wa-</xex>, variants of the Bantu plural personal prefix
<xex>Aba-</xex>, as in <xex>Ba-ntu</xex>, or <xex>Aba-ntu</xex>, itself
a combination of this prefix with the syllable <xex>-ntu</xex>, a
person; or as in <stype>Watusi</stype>.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><sn>2.</sn> <def>the family of languages spoken by the Bantu people
(definition 1).</def><br/
[<source>PJC</source>]</p>

<p><ent>Bantu</ent><br/
<hw>Ban"tu</hw> <pos>adj.</pos> <sn>1.</sn> <def>Of or pertaining to the
Bantu language group Bantu (definition 2); <as>as, <ex>Bantu</ex>
languages</as>.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><sn>2.</sn> <def>of or pertaining to the Bantu people (definition
1).</def> <illu>The <ex>Bantu</ex> population of Sierra Leone</illu><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Banxring</ent><br/
<hw>Banx"ring</hw> <pr>(<?/)</pr>, <pos>n.</pos> <fld>(Zool.)</fld>
<def>An East Indian insectivorous mammal of the genus
<gen>Tupaia</gen>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Banyan</ent><br/
<hw>Ban"yan</hw> <pr>(b<acr/n"y<ait/n <it>or</it>
b<acr/n*y<acr/n")</pr>, <pos>n.</pos> <ety>[See <er>Banian</er>.]</ety>
<fld>(Bot.)</fld> <def>A tree of the same genus as the common fig, and
called the Indian fig (<spn>Ficus Indica</spn>), whose branches send
shoots to the ground, which take root and become additional trunks,
until it may be the tree covers some acres of ground and is able to
shelter thousands of men.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Banzai</ent><br/
\'d8<hw>Ban"zai"</hw> <pr>(?)</pr>, <pos>interj.</pos> <ety>[Jap.
<ets>banzai</ets>, <ets>banzei</ets>, ten thousand years,
forever.]</ety> <def>Lit., May you live ten thousand years; -- used in
salutation of the emperor and as a battle cry.</def>
<mark>[Japan]</mark><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Baobab</ent><br/
<hw>Ba"o*bab</hw> <pr>(b<amac/"<osl/*b<acr/b <it>or</it>
b<aum/"<osl/*b<acr/b)</pr>, <pos>n.</pos> <ety>[The native name.]</ety>
<fld>(Bot.)</fld> <def>A gigantic African tree (<spn>Adansonia
digitata</spn>), also naturalized in India. See
<er>Adansonia</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baphomet</ent><br/
<hw>Baph"o*met</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[A corruption of
<ets>Mahomet</ets> or <ets>Mohammed</ets>, the Arabian prophet: cf. Pr.
<ets>Bafomet</ets>, OSp. <ets>Mafomat</ets>, OPg.
<ets>Mafameda</ets>.]</ety> <def>An idol or symbolical figure which the
Templars were accused of using in their mysterious rites.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>baptise</ent><br/
<hw>bap"tise</hw> <pos>v. t.</pos> <def>same as
<er>baptize</er>.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Baptisia</ent><br/
<hw>Baptisia</hw> <pos>prop. n.</pos> <def>A genus of North American
plants with showy pealike flowers and an inflated pod.</def><br/
<syn><b>Syn. --</b> genus <gen>Baptisia</gen>.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Baptism</ent><br/
<hw>Bap"tism</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[OE.
<ets>baptim</ets>, <ets>baptem</ets>, OF. <ets>baptesme</ets>,
<ets>batisme</ets>, F. <ets>bapt<ecir/me</ets>, L. <ets>baptisma</ets>,
fr. Gr. <grk>ba`ptisma</grk>, fr. <grk>bapti`zein</grk> to baptize, fr.
<grk>ba`ptein</grk> to dip in water, akin to <grk>baqy`s</grk> deep,
Skr. <ets>g<amac/h</ets> to dip, bathe, <pos>v. i.</pos>]</ety> <def>The
act of baptizing; the application of water to a person, as a sacrament
or religious ceremony, by which he is initiated into the visible church
of Christ. This is performed by immersion, sprinkling, or
pouring.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baptismal</ent><br/
<hw>Bap*tis"mal</hw> <pr>(<?/)</pr>, <pos>a.</pos> <ety>[Cf. F.
<ets>baptismal</ets>.]</ety> <def>Pertaining to baptism; <as>as,
<ex>baptismal</ex> vows</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Baptismal name</b></col>, <cd>the Christian name, which
is given at baptism.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baptismally</ent><br/
<hw>Bap*tis"mal*ly</hw>, <pos>adv.</pos> <def>In a baptismal
manner.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baptist</ent><br/
<hw>Bap"tist</hw> <pr>(b<acr/p"t<icr/st)</pr>, <pos>n.</pos> <ety>[L.
<ets>baptista</ets>, Gr. <grk>baptisth`s</grk>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>One who administers baptism; -- specifically applied
to John, the forerunner of Christ.</def> <rj><au>Milton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>One of a denomination of Christians who deny the
validity of infant baptism and of sprinkling, and maintain that baptism
should be administered to believers alone, and should be by immersion.
See <er>Anabaptist</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><note>In doctrine the Baptists of this country [the United States]
are Calvinistic, but with much freedom and moderation.</note>
<rj><au>Amer. Cyc.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Freewill Baptists</b></col>, <cd>a sect of Baptists who
are Arminian in doctrine, and practice open communion.</cd> --
<col><b>Seventh-day Baptists</b></col>, <cd>a sect of Baptists who keep
the seventh day of the week, or Saturday, as the Sabbath. See
<er>Sabbatarian</er>. The Dunkers and Campbellites are also
Baptists.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baptistry</ent><br/
<ent>Baptistery</ent><br/
<mhw>{ <hw>Bap"tis*ter*y</hw> <pr>(<?/)</pr>,<hw>Bap"tis*try</hw>
}</mhw> <pr>(<?/)</pr>, <pos>n.</pos>; <plu><it>pl.</it>
<plw>Baptisteries</plw> <pr>(<?/)</pr>, <plw>Baptistries</plw>
<pr>(<?/)</pr>.</plu> <ety>[L. <ets>baptisterium</ets>, Gr.
<grk>baptisth`rion</grk>: cf. F. <ets>baptist<egrave/re</ets>.]</ety>
<fld>(Arch.)</fld> <sd>(a)</sd> <def>In early times, a separate
building, usually polygonal, used for baptismal services. Small churches
were often changed into baptisteries when larger churches were built
near.</def> <sd>(b)</sd> <def>A part of a church containing a font and
used for baptismal services.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baptistic</ent><br/
<hw>Bap*tis"tic</hw> <pr>(<?/)</pr>, <pos>a.</pos> <ety>[Gr.
<grk>baptistiko`s</grk>.]</ety> <def>Of or for baptism;
baptismal.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baptistical</ent><br/
<hw>Bap*tis"tic*al</hw> <pr>(<?/)</pr>, <pos>a.</pos>
<def>Baptistic.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baptizable</ent><br/
<hw>Bap*tiz"a*ble</hw> <pr>(<?/)</pr>, <pos>a.</pos> <def>Capable of
being baptized; fit to be baptized.</def> <rj><au>Baxter.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baptization</ent><br/
<hw>Bap`ti*za"tion</hw> <pr>(<?/)</pr>, <pos>n.</pos>
<def>Baptism.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>Their <qex>baptizations</qex> were null.</q> <rj><qau>Jer.
Taylor.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baptize</ent><br/
<hw>Bap*tize"</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. &
p. p.</pos> <conjf>Baptized</conjf> <pr>(<?/)</pr>; <pos>p. pr. & vb.
n.</pos> <conjf>Baptizing</conjf>.]</vmorph> <ety>[F.
<ets>baptiser</ets>, L. <ets>baptizare</ets>, fr. Gr.
<grk>bapti`zein</grk>. See <er>Baptism</er>.]</ety> <sn>1.</sn> <def>To
administer the sacrament of baptism to.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To christen (because a name is given to infants at
their baptism); to give a name to; to name.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>I'll be new <qex>baptized</qex>;<br/
Henceforth I never will be Romeo.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To sanctify; to consecrate.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baptizement</ent><br/
<hw>Bap*tize"ment</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>The act of
baptizing.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baptizer</ent><br/
<hw>Bap*tiz"er</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>One who
baptizes.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bar</ent><br/
<hw>Bar</hw> <pr>(b<aum/r)</pr>, <pos>n.</pos> <ety>[OE.
<ets>barre</ets>, F. <ets>barre</ets>, fr. LL. <ets>barra</ets>, W.
<ets>bar</ets> the branch of a tree, bar, <ets>baren</ets> branch, Gael.
& Ir. <ets>barra</ets> bar. <root/91.]</ety> <sn>1.</sn> <def>A piece of
wood, metal, or other material, long in proportion to its breadth or
thickness, used as a lever and for various other purposes, but
especially for a hindrance, obstruction, or fastening; <as>as, the
<ex>bars</ex> of a fence or gate; the <ex>bar</ex> of a
door</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Thou shalt make <qex>bars</qex> of shittim wood.</q> <rj><qau>Ex.
xxvi. 26.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>An indefinite quantity of some substance, so shaped
as to be long in proportion to its breadth and thickness; <as>as, a
<ex>bar</ex> of gold or of lead; a <ex>bar</ex> of soap</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Anything which obstructs, hinders, or prevents; an
obstruction; a barrier.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Must I new <qex>bars</qex> to my own joy create?</q>
<rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 118 pr=SA --></p>

<p><sn>4.</sn> <def>A bank of sand, gravel, or other matter, esp. at the
mouth of a river or harbor, obstructing navigation.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>Any railing that divides a room, or office, or hall
of assembly, in order to reserve a space for those having special
privileges; <as>as, the <ex>bar</ex> of the House of
Commons</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <fld>(Law)</fld> <sd>(a)</sd> <def>The railing that
incloses the place which counsel occupy in courts of justice. Hence, the
phrase <xex>at the bar of the court</xex> signifies <xex>in open
court</xex>.</def> <sd>(b)</sd> <def>The place in court where prisoners
are stationed for arraignment, trial, or sentence.</def> <sd>(c)</sd>
<def>The whole body of lawyers licensed in a court or district; the
legal profession.</def> <sd>(d)</sd> <def>A special plea constituting a
sufficient answer to plaintiff's action.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>7.</sn> <def>Any tribunal; <as>as, the <ex>bar</ex> of public
opinion; the <ex>bar</ex> of God</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>8.</sn> <def>A barrier or counter, over which liquors and food
are passed to customers; hence, the portion of the room behind the
counter where liquors for sale are kept.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>9.</sn> <fld>(Her.)</fld> <def>An ordinary, like a fess but
narrower, occupying only one fifth part of the field.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>10.</sn> <def>A broad shaft, or band, or stripe; <as>as, a
<ex>bar</ex> of light; a <ex>bar</ex> of color</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>11.</sn> <fld>(Mus.)</fld> <def>A vertical line across the staff.
Bars divide the staff into spaces which represent measures, and are
themselves called <xex>measures</xex>.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ A <xex>double bar</xex> marks the end of a strain or
main division of a movement, or of a whole piece of music; in psalmody,
it marks the end of a line of poetry. The term <xex>bar</xex> is very
often loosely used for <xex>measure</xex>, i.e., for such length of
music, or of silence, as is included between one bar and the next; as, a
passage of eight <xex>bars</xex>; two <xex>bars'</xex> rest.</note><br/
[<source>1913 Webster</source>]</p>

<p><sn>12.</sn> <fld>(Far.)</fld> <pluf>pl.</pluf> <sd>(a)</sd> <def>The
space between the tusks and grinders in the upper jaw of a horse, in
which the bit is placed.</def> <sd>(b)</sd> <def>The part of the crust
of a horse's hoof which is bent inwards towards the frog at the heel on
each side, and extends into the center of the sole.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>13.</sn> <fld>(Mining)</fld> <sd>(a)</sd> <def>A drilling or
tamping rod.</def> <sd>(b)</sd> <def>A vein or dike crossing a
lode.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>14.</sn> <fld>(Arch.)</fld> <sd>(a)</sd> <def>A gatehouse of a
castle or fortified town.</def> <sd>(b)</sd> <def>A slender strip of
wood which divides and supports the glass of a window; a sash
bar.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Bar shoe</b></col> <fld>(Far.)</fld>, <cd>a kind of
horseshoe having a bar across the usual opening at the heel, to protect
a tender frog from injury.</cd> -- <col><b>Bar shot</b></col>, <cd>a
double headed shot, consisting of a bar, with a ball or half ball at
each end; -- formerly used for destroying the masts or rigging in naval
combat.</cd> -- <col><b>Bar sinister</b></col> <fld>(Her.)</fld>, <cd>a
term popularly but erroneously used for <xex>baton</xex>, a mark of
illegitimacy. See <er>Baton</er>.</cd> -- <col><b>Bar tracery</b></col>
<fld>(Arch.)</fld>, <cd>ornamental stonework resembling bars of iron
twisted into the forms required.</cd> -- <col><b>Blank bar</b></col>
<fld>(Law)</fld>. <cd>See <er>Blank</er>.</cd> -- <col><b>Case at
bar</b></col> <fld>(Law)</fld>, <cd>a case presently before the court; a
case under argument.</cd> -- <col><b>In bar of</b></col>, <cd>as a
sufficient reason against; to prevent.</cd> -- <mcol><col><b>Matter in
bar</b></col>, or <col><b>Defence in bar</b></col></mcol>, <cd>any
matter which is a final defense in an action.</cd> -- <col><b>Plea in
bar</b></col>, <cd>a plea which goes to bar or defeat the plaintiff's
action absolutely and entirely.</cd> -- <col><b>Trial at bar</b></col>
<fld>(Eng. Law)</fld>, <cd>a trial before all the judges of one the
superior courts of Westminster, or before a quorum representing the full
court.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bar</ent><br/
<hw>Bar</hw> <pr>(b<aum/r)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. &
p. p.</pos> <conjf>Barred</conjf> (b<aum/rd); <pos>p. pr. & vb. n.</pos>
<conjf>Barring</conjf>.]</vmorph> <ety>[ F. <ets>barrer</ets>. See
<er>Bar</er>, <pos>n.</pos>]</ety> <sn>1.</sn> <def>To fasten with a
bar; <as>as, to <ex>bar</ex> a door or gate</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To restrict or confine, as if by a bar; to hinder;
to obstruct; to prevent; to prohibit; <as>as, to <ex>bar</ex> the
entrance of evil; distance <ex>bars</ex> our intercourse; the statute
<ex>bars</ex> my right; the right is <ex>barred</ex> by time; a release
<ex>bars</ex> the plaintiff's recovery</as>; -- sometimes with
<xex>up</xex>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>He barely looked the idea in the face, and hastened to
<qex>bar</qex> it in its dungeon.</q> <rj><qau>Hawthorne.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To except; to exclude by exception.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Nay, but I <qex>bar</qex> to-night: you shall not gauge me<br/
By what we do to-night.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>To cross with one or more stripes or
lines.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>For the sake of distinguishing the feet more clearly, I have
<qex>barred</qex> them singly.</q> <rj><qau>Burney.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baraca</ent><br/
<hw>Ba*ra"ca</hw> <pr>(?)</pr>, <pos>n.</pos> <def>An international,
interdenominational organization of Bible classes of young men; -- so
named in allusion to the Hebrew word <xex>Berachah</xex> (Meaning
<xex>blessing</xex>) occurring in <au>2 Chron. xx. 26</au> and <au>1
Chron. xii.</au></def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Barad</ent><br/
<hw>Bar"ad</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <?/ weight.]</ety>
<fld>(Physics)</fld> <def>The pressure of one dyne per square
centimeter; -- used as a unit of pressure.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Baresthesiometer</ent><br/
<ent>Baraesthesiometer</ent><br/
<mhw>{ <hw>Bar`<ae/s*the`si*om"e*ter</hw>,
<hw>Bar`es*the`si*om"e*ter</hw> <pr>(?)</pr> }</mhw>, <pos>n.</pos>
<ety>[Gr. <?/ weight + <ets><ae/sthesiometer</ets>.]</ety>
<fld>(Physiol.)</fld> <def>An instrument for determining the delicacy of
the sense of pressure.</def> --
<wordforms><wf>Bar`<ae/s*the`si*o*met"ric</wf>,
<wf>Bar`es*the`si*o*met"ric</wf> <pr>(#)</pr>,
<pos>a.</pos></wordforms><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Barathea</ent><br/
<hw>Bar`a*the"a</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A soft fabric with
a kind of basket weave and a diapered pattern.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Barb</ent><br/
<hw>Barb</hw> <pr>(b<aum/rb)</pr>, <pos>n.</pos> <ety>[F.
<ets>barbe</ets>, fr. L. <ets>barba</ets> beard. See <er>Beard</er>,
<pos>n.</pos>]</ety> <sn>1.</sn> <def>Beard, or that which resembles it,
or grows in the place of it.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The barbel, so called by reason of his <qex>barbs</qex>, or
wattles in his mouth.</q> <rj><qau>Walton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A muffler, worn by nuns and mourners.</def>
<mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <pluf>pl.</pluf> <def>Paps, or little projections, of the
mucous membrane, which mark the opening of the submaxillary glands under
the tongue in horses and cattle. The name is mostly applied when the
barbs are inflamed and swollen.</def> <altsp>[Written also
<asp>barbel</asp> and <asp>barble</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>The point that stands backward in an arrow,
fishhook, etc., to prevent it from being easily extracted. Hence:
Anything which stands out with a sharp point obliquely or crosswise to
something else.</def> <ldquo/Having two <xex>barbs</xex> or
points.<rdquo/ <rj><au>Ascham.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>A bit for a horse.</def> <mark>[Obs.]</mark>
<rj><au>Spenser.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <fld>(Zool.)</fld> <def>One of the side branches of a
feather, which collectively constitute the vane. See
<er>Feather</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>7.</sn> <fld>(Zool.)</fld> <def>A southern name for the
kingfishes of the eastern and southeastern coasts of the United States;
-- also improperly called <altname>whiting</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>8.</sn> <fld>(Bot.)</fld> <def>A hair or bristle ending in a
double hook.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>baranduki</ent><br/
<hw>baranduki</hw> <pos>n.</pos> <def>The terrestrial Siberian squirrel
(<spn>Eutamius sibiricus</spn>).</def><br/
<syn><b>Syn. --</b> baronduki, barunduki, burunduki, <spn>Eutamius
asiaticus</spn>.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>baragnosis</ent><br/
<hw>baragnosis</hw> <pos>n.</pos> <fld>(Med.)</fld> <def>the inability
to estimate the weight of an object.</def><br/
[<source>PJC</source>]</p>

<p><ent>Barb</ent><br/
<hw>Barb</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos>
<conjf>Barbed</conjf> <pr>(b<aum/rbd)</pr>; <pos>p. pr. & vb. n.</pos>
<conjf>Barbing</conjf>.]</vmorph> <sn>1.</sn> <def>To shave or dress the
beard of.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To clip; to mow.</def> <mark>[Obs.]</mark>
<rj><au>Marston.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To furnish with barbs, or with that which will hold
or hurt like barbs, as an arrow, fishhook, spear, etc.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>But rattling storm of arrows <qex>barbed</qex> with fire.</q>
<rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barb</ent><br/
<hw>Barb</hw>, <pos>n.</pos> <ety>[F. <ets>barbe</ets>, fr.
<ets>Barbarie</ets>.]</ety> <sn>1.</sn> <def>The Barbary horse, a
superior breed introduced from Barbary into Spain by the
Moors.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Zool.)</fld> <def>A blackish or dun variety of the
pigeon, originally brought from Barbary.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barb</ent><br/
<hw>Barb</hw>, <pos>n.</pos> <ety>[Corrupted fr. <ets>bard</ets>.]</ety>
<def>Armor for a horse. Same as 2d <er>Bard</er>, <pos>n.</pos>,
1.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barbacan</ent><br/
<hw>Bar"ba*can</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>See
<er>Barbican</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barbacanage</ent><br/
<hw>Bar"ba*can*age</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>See
<er>Barbicanage</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barbadian</ent><br/
<hw>Bar*ba"di*an</hw> <pr>(<?/)</pr>, <pos>a.</pos> <def>Of or
pertaining to Barbados.</def> -- <def2><pos>n.</pos> <def>A native of
Barbados.</def></def2><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barbadoes</ent><br/
<ent>Barbados</ent><br/
<mhw>{ <hw>Bar*ba"dos</hw> or <hw>Bar*ba"does</hw> }</mhw>
<pr>(<?/)</pr>, <pos>n.</pos> <def>A West Indian island, giving its name
to a disease, to a cherry, etc.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Barbados cherry</b></col> <fld>(Bot.)</fld>, <cd>a genus
of trees of the West Indies (<gen>Malpighia</gen>) with an agreeably
acid fruit resembling a cherry.</cd> -- <col><b>Barbados leg</b></col>
<fld>(Med.)</fld>, <cd>a species of elephantiasis incident to hot
climates.</cd> -- <col><b>Barbados nuts</b></col>, <cd>the seeds of the
<spn>Jatropha curcas</spn>, a plant growing in South America and
elsewhere. The seeds and their acrid oil are used in medicine as a
purgative. See <er>Physic nut</er>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barbara</ent><br/
\'d8<hw>Bar"ba*ra</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[Coined by
logicians.]</ety> <fld>(Logic)</fld> <def>The first word in certain
mnemonic lines which represent the various forms of the syllogism. It
indicates a syllogism whose three propositions are universal
affirmatives.</def> <rj><au>Whately.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barbarea</ent><br/
<hw>Barbarea</hw> <pos>n.</pos> <def>a genus of biennial or perennial
herbs of north temperate regions: winter cress.</def><br/
<syn><b>Syn. --</b> genus <gen>Barbarea.</gen>.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Barbaresque</ent><br/
<hw>Bar`ba*resque"</hw> <pr>(<?/)</pr>, <pos>a.</pos> <def>Barbaric in
form or style; <as>as, <ex>barbaresque</ex> architecture</as>.</def>
<rj><au>De Quincey.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barbarian</ent><br/
<hw>Bar*ba"ri*an</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[See
<er>Barbarous</er>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>A foreigner.</def> <mark>[Historical]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>Therefore if I know not the meaning of the voice, I shall be unto
him that speaketh a <qex>barbarian</qex>, and he that speaketh shall be
a <qex>barbarian</qex> unto me.</q> <rj><qau>1 Cor. xiv.
11.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A man in a rude, savage, or uncivilized
state.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>A person destitute of culture.</def> <rj><au>M.
Arnold.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>A cruel, savage, brutal man; one destitute of pity
or humanity.</def> <ldquo/Thou fell <xex>barbarian</xex>.<rdquo/
<rj><au>Philips.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barbarian</ent><br/
<hw>Bar*ba"ri*an</hw>, <pos>a.</pos> <def>Of, or pertaining to, or
resembling, barbarians; rude; uncivilized; barbarous; <as>as,
<ex>barbarian</ex> governments or nations</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barbaric</ent><br/
<hw>Bar*bar"ic</hw> <pr>(b<aum/r*b<acr/r"<icr/k)</pr>, <pos>a.</pos>
<ety>[L. <ets>barbaricus</ets> foreign, barbaric, Gr.
<grk>barbariko`s</grk>.]</ety> <sn>1.</sn> <def>Of, or from, barbarian
nations; foreign; -- often with reference to barbarous nations of
east.</def> <ldquo/<xex>Barbaric</xex> pearl and gold.<rdquo/
<rj><au>Milton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Of or pertaining to, or resembling, an uncivilized
person or people; barbarous; barbarian; destitute of refinement.</def>
<ldquo/Wild, <xex>barbaric</xex> music.<rdquo/ <rj><au>Sir W.
Scott.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>barbarisation</ent><br/
<hw>barbarisation</hw> <pos>n.</pos> <def>the act or process of
barbarizing; an act that makes people primitive and
uncivilized.</def><br/
<syn><b>Syn. --</b> barbarization.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>barbarise</ent><br/
<hw>barbarise</hw> <def>same as <er>barbarize</er>.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Barbarism</ent><br/
<hw>Bar"ba*rism</hw> <pr>(b<aum/r"b<adot/*r<icr/z'm)</pr>, <pos>n.</pos>
<ety>[L. <ets>barbarismus</ets>, Gr. <grk>barbarismo`s</grk>; cf. F.
<ets>barbarisme</ets>.]</ety> <sn>1.</sn> <def>An uncivilized state or
condition; rudeness of manners; ignorance of arts, learning, and
literature; barbarousness.</def> <rj><au>Prescott.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A barbarous, cruel, or brutal action; an
outrage.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>A heinous <qex>barbarism</qex> . . . against the honor of
marriage.</q> <rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>An offense against purity of style or language; any
form of speech contrary to the pure idioms of a particular language. See
<er>Solecism</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The Greeks were the first that branded a foreign term in any of
their writers with the odious name of <qex>barbarism</qex>.</q>
<rj><qau>G. Campbell.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barbarity</ent><br/
<hw>Bar*bar"i*ty</hw> <pr>(<?/)</pr>, <pos>n.</pos>; <plu><it>pl.</it>
<plw>Barbarities</plw> <pr>(<?/)</pr>.</plu> <ety>[From
<er>Barbarous</er>.]</ety> <sn>1.</sn> <def>The state or manner of a
barbarian; lack of civilization.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Cruelty; ferociousness; inhumanity.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Treating Christians with a <qex>barbarity</qex> which would have
shocked the very Moslem.</q> <rj><qau>Macaulay.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>A barbarous or cruel act.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>Barbarism; impurity of speech.</def>
<mark>[Obs.]</mark> <rj><au>Swift.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>barbarization</ent><br/
<hw>barbarization</hw> <pos>n.</pos> <sn>1.</sn> <def>the act or process
of barbarizing; an act that makes people primitive and
uncivilized.</def><br/
<syn><b>Syn. --</b> barbarisation.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Barbarize</ent><br/
<hw>Bar"ba*rize</hw> <pr>(<?/)</pr>, <pos>v. i.</pos> <vmorph>[<pos>imp.
& p. p.</pos> <conjf>Barbarized</conjf> <pr>(<?/)</pr>; <pos>p. pr. &
vb. n.</pos> <conjf>Barbarizing</conjf> <pr>(<?/)</pr>.]</vmorph><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>To become barbarous.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The Roman empire was <qex>barbarizing</qex> rapidly from the time
of Trajan.</q> <rj><qau>De Quincey.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To adopt a foreign or barbarous mode of
speech.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The ill habit . . . of wretched <qex>barbarizing</qex> against the
Latin and Greek idiom, with their untutored Anglicisms.</q>
<rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barbarize</ent><br/
<hw>Bar"ba*rize</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <ety>[Cf. F.
<ets>barbariser</ets>, LL. <ets>barbarizare</ets>.]</ety> <def>To make
barbarous.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The hideous changes which have <qex>barbarized</qex> France.</q>
<rj><qau>Burke.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barbarous</ent><br/
<hw>Bar"ba*rous</hw> <pr>(<?/)</pr>, <pos>a.</pos> <ety>[L.
<ets>barbarus</ets>, Gr. <grk>ba`rbaros</grk>, strange, foreign; later,
slavish, rude, ignorant; akin to L. <ets>balbus</ets> stammering, Skr.
<ets>barbara</ets> stammering, outlandish. Cf. <er>Brave</er>,
<pos>a.</pos>]</ety> <sn>1.</sn> <def>Being in the state of a barbarian;
uncivilized; rude; peopled with barbarians; <as>as, a <ex>barbarous</ex>
people; a <ex>barbarous</ex> country</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Foreign; adapted to a barbaric taste.</def>
<mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>Barbarous</qex> gold.</q> <rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Cruel; ferocious; inhuman; merciless.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>By their <qex>barbarous</qex> usage he died within a few days, to
the grief of all that knew him.</q> <rj><qau>Clarendon.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>Contrary to the pure idioms of a language.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>A <qex>barbarous</qex> expression</q> <rj><qau>G.
Campbell.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- Uncivilized; unlettered; uncultivated; untutored;
ignorant; merciless; brutal. See <er>Ferocious</er>.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barbarously</ent><br/
<hw>Bar"ba*rous*ly</hw>, <pos>adv.</pos> <def>In a barbarous
manner.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barbarousness</ent><br/
<hw>Bar"ba*rous*ness</hw>, <pos>n.</pos> <def>The quality or state of
being barbarous; barbarity; barbarism.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barbary</ent><br/
<hw>Bar"ba*ry</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[Fr. Ar.
<ets>Barbar</ets> the people of Barbary.]</ety> <def>The countries on
the north coast of Africa from Egypt to the Atlantic.</def>
<specif>Hence:</specif> <def>A Barbary horse; a barb.</def>
<mark>[Obs.]</mark> <specif>Also,</specif> <def>a kind of
pigeon.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Barbary ape</b></col> <fld>(Zool.)</fld>, <cd>an ape
(<spn>Macacus innuus</spn>) of north Africa and Gibraltar Rock, being
the only monkey inhabiting Europe. It is very commonly trained by
showmen.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>barbasco</ent><br/
<hw>barbasco</hw> <pos>n.</pos> <def>a West Indian shrub or small tree
(<spn>Jacquinia keyensis</spn>) having leathery saponaceous leaves and
extremely hard wood.</def><br/
<syn><b>Syn. --</b> joewood.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Barbastel</ent><br/
<hw>Bar"ba*stel`</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[F.
<ets>barbastelle</ets>.]</ety> <fld>(Zool.)</fld> <def>A European bat
(<spn>Barbastellus communis</spn>), with hairy lips.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barbate</ent><br/
<hw>Bar"bate</hw> <pr>(<?/)</pr>, <pos>a.</pos> <ety>[L.
<ets>barbatus</ets>, fr. <ets>barba</ets> beard. See <er>Barb</er>
beard.]</ety> <fld>(Bot.)</fld> <def>Bearded; beset with long and weak
hairs.</def> <rj><au>Gray.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barbated</ent><br/
<hw>Bar"ba*ted</hw> <pr>(<?/)</pr>, <pos>a.</pos> <def>Having barbed
points.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>A dart uncommonly <qex>barbated</qex>.</q> <rj><qau>T.
Warton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barbecue</ent><br/
<hw>Bar"be*cue</hw> <pr>(b<aum/"b<esl/*k<umac/)</pr>, <pos>n.</pos>
<ety>[In the language of the (Arawak or Taino) Indians of Guiana,
<ets>barbacoa</ets> a frame on which all kinds of flesh and fish are
roasted or smoke-dried.]</ety> <sn>1.</sn> <def>a framework of metal or
brick, usually with a grill on top, in which a fire is lighted and on
which food is cooked, usually outdoors; -- also called a
<altname>barbecue grill</altname>.</def><br/
[<source>PJC</source>]</p>

<p><sn>2.</sn> <def>A social entertainment, where people assemble,
usually in the open air, at which a meal is prepared on a barbecue
grill.</def><br/
[<source>1913 Webster</source> <source>+PJC</source>]</p>

<p><sn>3.</sn> <def>A floor, on which coffee beans are
sun-dried.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>A hog, ox, or other large animal roasted or broiled
whole for a feast.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barbecue</ent><br/
<hw>Bar"be*cue</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp.
& p. p.</pos> <conjf>Barbecued</conjf> <pr>(<?/)</pr>; <pos>p. pr. & vb.
n.</pos> <conjf>Barbecuing</conjf>.]</vmorph> <sn>1.</sn> <def>To dry or
cure by exposure on a frame or gridiron.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>They use little or no salt, but <qex>barbecue</qex> their game and
fish in the smoke.</q> <rj><qau>Stedman.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To roast or broil whole, as an ox or hog.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Send me, gods, a whole hog <qex>barbecued</qex>.</q>
<rj><qau>Pope.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>barbecued</ent><br/
<hw>barbecued</hw> <pos>adj.</pos> <def>Cooked on a barbecue.</def><br/
<syn><b>Syn. --</b> grilled.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>barbecuing</ent><br/
<hw>barbecuing</hw> <pos>n.</pos> <def>Roasting a large piece of meat on
a grill or a revolving spit out of doors over an open fire.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Barbed</ent><br/
<hw>Barbed</hw> <pr>(b<aum/rbd <it>or</it> b<aum/rb"<ecr/d)</pr>,
<pos>a.</pos> <ety>[See 4th <er>Barb</er>.]</ety> <def>Accoutered with
defensive armor; -- said of a horse. See <er>Barded</er> (which is the
proper form.)</def> <rj><au>Sir W. Raleigh.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barbed</ent><br/
<hw>Barbed</hw>, <pos>a.</pos> <def>Furnished with a barb or barbs;
<as>as, a <ex>barbed</ex> arrow; <ex>barbed</ex> wire</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Barbed wire</b></col>, <cd>a wire, or a strand of twisted
wires, armed with barbs or sharp points. It is used for
fences.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barbel</ent><br/
<hw>Bar"bel</hw> <pr>(b<aum/r"b<ecr/l)</pr>, <pos>n.</pos><ety>[OF.
<ets>barbel</ets>, F. <ets>barbeau</ets>, dim. of L. <ets>barbus</ets>
barbel, fr. <ets>barba</ets> beard. See 1st <er>Barb</er>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <fld>(Zool.)</fld> <def>A slender tactile organ on the
lips of certain fishes.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Zool.)</fld> <def>A large fresh-water fish
(<spn>Barbus vulgaris</spn>) found in many European rivers. Its upper
jaw is furnished with four barbels.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <pluf>pl.</pluf> <def>Barbs or paps under the tongues of
horses and cattle. See 1st <er>Barb</er>, 3.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>barbell</ent><br/
<hw>bar"bell`</hw> <pr>(b<aum/r"b<ecr/l`)</pr>, <pos>n.</pos> <def>A bar
to which heavy discs are attached at each end; -- it is used for
weightlifting exercises.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Barbellate</ent><br/
<hw>Bar"bel*late</hw> <pr>(b<aum/r"b<ecr/l*l<asl/t)</pr>, <pos>a.</pos>
<ety>[See 1st <er>Barb</er>.]</ety> <fld>(Bot.)</fld> <def>Having short,
stiff hairs, often barbed at the point.</def>
<rj><au>Gray.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barbellulate</ent><br/
<hw>Bar*bel"lu*late</hw> <pr>(b<aum/r*b<ecr/l"l<usl/*l<asl/t)</pr>,
<pos>a.</pos> <fld>(Bot.)</fld> <def>Barbellate with diminutive hairs or
barbs.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barber</ent><br/
<hw>Bar"ber</hw> <pr>(b<aum/r"b<etil/r)</pr>, <pos>n.</pos> <ety>[OE.
<ets>barbour</ets>, OF. <ets>barbeor</ets>, F. <ets>barbier</ets>, as if
fr. an assumed L. <ets>barbator</ets>, fr. <ets>barba</ets> beard. See
1st <er>Barb</er>.]</ety> <def>One whose occupation it is to shave or
trim the beard, and to cut and dress the hair of his patrons.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Barber's itch</b></col>. <cd>See under
<er>Itch</er>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ Formerly the barber practiced some offices of surgery,
such as letting blood and pulling teeth. Hence such terms as
<ecol><b>barber surgeon</b></ecol> (old form <col><b>barber
chirurgeon</b></col>), <col><b>barber surgery</b></col>, etc.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barber</ent><br/
<hw>Bar"ber</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos>
<conjf>Barbered</conjf> <pr>(b<aum/r"b<etil/rd)</pr>; <pos>p. pr. & vb.
n.</pos> <conjf>Barbering</conjf>.]</vmorph> <def>To shave and dress the
beard or hair of.</def> <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barber</ent><br/
<hw>Bar"ber</hw>, <pos>n.</pos> <fld>(Meteor.)</fld> <def>A storm
accompanied by driving ice spicules formed from sea water, esp. one
occurring on the Gulf of St. Lawrence; -- so named from the cutting ice
spicules.</def> <mark>[Canada]</mark><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Barber fish</ent><br/
<hw>Bar"ber fish</hw>. <fld>(Zool.)</fld> <def>See <er>Surgeon
fish</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barbermonger</ent><br/
<hw>Bar"ber*mon`ger</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>A fop.</def>
<mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>barbers pole</ent><br/
<ent>barber pole</ent><br/
<mhw><hw>barber pole</hw>, <hw>barbers pole</hw></mhw> <pos>n.</pos>
<def>a pole with red and white spiral stripes; -- usually found outside
a barbershop.</def> <note>It is often electrically powered, so as to be
turning when the barbershop is open for business and stationary when the
shop is closed. It symbolizes the practise of surgery, some aspects of
which which used to be performed by barbers.</note><br/
[<source>PJC</source>]</p>

<p><ent>Barberry</ent><br/
<hw>Bar"ber*ry</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[OE.
<ets>barbarin</ets>, <ets>barbere</ets>, OF. <ets>berbere</ets>.]</ety>
<fld>(Bot.)</fld> <def>A shrub of the genus <gen>Berberis</gen>, common
along roadsides and in neglected fields. <spn>Berberis vulgaris</spn> is
the species best known; its oblong red berries are made into a preserve
or sauce, and have been deemed efficacious in fluxes and fevers. The
bark dyes a fine yellow, esp. the bark of the root.</def> <altsp>[Also
spelt <asp>berberry</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><ent>barbershop</ent><br/
<hw>barbershop</hw> <pos>n.</pos> <def>a shop where a barber works,
especially one where men can get their hair cut.</def><br/
[<source>WordNet 1.5</source> <source>+PJC</source>]</p>

<p><ent>Barbet</ent><br/
<hw>Bar"bet</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[F.
<ets>barbet</ets>, fr. <ets>barbe</ets> beard, long hair of certain
animals. See <er>Barb</er> beard.]</ety> <fld>(Zool.)</fld> <sd>(a)</sd>
<def>A variety of small dog, having long curly hair.</def> <sd>(b)</sd>
<def>A bird of the family <fam>Bucconid<ae/</fam>, allied to the
Cuckoos, having a large, conical beak swollen at the base, and bearded
with five bunches of stiff bristles; the puff bird. It inhabits tropical
America and Africa.</def> <sd>(c)</sd> <def>A larva that feeds on
aphids.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barbette</ent><br/
<hw>Bar*bette"</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[F. Cf.
<er>Barbet</er>.]</ety> <fld>(Fort.)</fld> <def>A mound of earth or a
platform in a fortification, on which guns are mounted to fire over the
parapet.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><mcol><col><b>En barbette</b></col>, <col><b>In
barbette</b></col></mcol>, <cd>said of guns when they are elevated so as
to fire over the top of a parapet, and not through embrasures.</cd> --
<mcol><col><b>Barbette gun</b></col>, or <col><b>Barbette
battery</b></col></mcol>, <cd>a single gun, or a number of guns, mounted
<xex>in barbette</xex>, or partially protected by a parapet or
turret.</cd> -- <col><b>Barbette carriage</b></col>, <cd>a gun carriage
which elevates guns sufficiently to be <xex>in barbette</xex>. [See
<xex>Illust.</xex> of <er>Casemate</er>.]</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barbacan</ent><br/
<ent>Barbican</ent><br/
<mhw>{ <hw>Bar"bi*can</hw> <pr>(<?/)</pr>, <hw>Bar"ba*can</hw> }</mhw>
<pr>(<?/)</pr>, <pos>n.</pos> <ety>[OE. <ets>barbican</ets>,
<ets>barbecan</ets>, F. <ets>barbacane</ets>, LL. <ets>barbacana</ets>,
<ets>barbicana</ets>, of uncertain origin: cf. Ar. <ets>barbakh</ets>
aqueduct, sewer. F. <ets>barbacane</ets> also means, an opening to let
out water, loophole.]</ety> <sn>1.</sn> <fld>(Fort.)</fld> <def>A tower
or advanced work defending the entrance to a castle or city, as at a
gate or bridge. It was often large and strong, having a ditch and
drawbridge of its own.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>An opening in the wall of a fortress, through which
missiles were discharged upon an enemy.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barbacanage</ent><br/
<ent>Barbicanage</ent><br/
<mhw>{ <hw>Bar"bi*can*age</hw> <pr>(<?/)</pr>, <hw>Bar"ba*can*age</hw>
}</mhw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[LL.
<ets>barbicanagium</ets>. See <er>Barbican</er>.]</ety> <def>Money paid
for the support of a barbican.</def> <mark>[Obs.]</mark>
<rj><au>Bouvier.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barbicel</ent><br/
<hw>Bar"bi*cel</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[NL.
<ets>barbicella</ets>, dim. of L. <ets>barba</ets>. See 1st
<er>Barb</er>.]</ety> <fld>(Zool.)</fld> <def>One of the small hooklike
processes on the barbules of feathers.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barbiers</ent><br/
\'d8<hw>Bar"biers</hw> <pr>(<?/)</pr>, <pos>n.</pos> <fld>(Med.)</fld>
<def>A variety of paralysis, peculiar to India and the Malabar coast; --
considered by many to be the same as <altname>beriberi</altname> in a
chronic form.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barbigerous</ent><br/
<hw>Bar*big"er*ous</hw> <pr>(<?/)</pr>, <pos>a.</pos> <ety>[L.
<ets>barba</ets> a beard + <ets>-gerous</ets>.]</ety> <def>Having a
beard; bearded; hairy.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barbiton</ent><br/
\'d8<hw>Bar"bi*ton</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[L., fr. Gr.
<grk>ba`rbiton</grk>.]</ety> <fld>(Mus.)</fld> <def>An ancient Greek
instrument resembling a lyre.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barbituric acid</ent><br/
<hw>Bar`bi*tu"ric ac"id</hw> <pr>(<?/)</pr>. <fld>(Chem.)</fld> <def>A
white, crystalline substance, <chform>CH2(CO.NH)2.CO</chform>, derived
from alloxantin, also from malonic acid and urea, and regarded as a
substituted urea.</def><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 119 pr=SA --></p>

<p><ent>Barbison school</ent><br/
<ent>Barbizon school</ent><br/
<mhw>{ <hw>Bar`bi`zon" school</hw>, <it>or</it> <hw>Bar`bi`son"
school</hw>, <pr>(?)</pr> }</mhw>. <fld>(Painting)</fld> <def>A French
school of the middle of the 19th century centering in the village of
Barbizon near the forest of Fontainebleau. Its members went straight to
nature in disregard of academic tradition, treating their subjects
faithfully and with poetic feeling for color, light, and atmosphere. It
is exemplified, esp. in landscapes, by Corot, Rousseau, Daubigny, Jules
Dupr<eacute/, and Diaz. Associated with them are certain painters of
animals, as Troyon and Jaque, and of peasant life, as Millet and Jules
Breton.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Barble</ent><br/
<hw>Bar"ble</hw> <pr>(b<aum/r"b'l)</pr>, <pos>n.</pos> <def>See
<er>Barbel</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barbotine</ent><br/
<hw>Bar"bo*tine</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[F.]</ety>
<def>A paste of clay used in decorating coarse pottery in
relief.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barbre</ent><br/
<hw>Bar"bre</hw> <pr>(b<aum/r"b<etil/r)</pr>, <pos>a.</pos>
<def>Barbarian.</def> <mark>[Obs.]</mark> <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barbule</ent><br/
<hw>Bar"bule</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[L.
<ets>barbula</ets>, fr. <ets>barba</ets> beard.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>A very minute barb or beard.</def>
<rj><au>Booth.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Zool.)</fld> <def>One of the processes along the
edges of the barbs of a feather, by which adjacent barbs interlock. See
<er>Feather</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barcarolle</ent><br/
<hw>Bar"ca*rolle</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[F.
<ets>barcarolle</ets>, fr. It. <ets>barcaruola</ets>, fr.
<ets>barca</ets> bark, barge.]</ety> <fld>(Mus.)</fld> <sd>(a)</sd>
<def>A popular song or melody sung by Venetian gondoliers.</def>
<sd>(b)</sd> <def>A piece of music composed in imitation of such a
song.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barcon</ent><br/
<hw>Bar"con</hw> <pr>(b<aum/r"k<ocr/n)</pr>, <pos>n.</pos> <ety>[It.
<ets>barcone</ets>, fr. <ets>barca</ets> a bark.]</ety> <def>A vessel
for freight; -- used in the Mediterranean.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bard</ent><br/
<hw>Bard</hw> <pr>(b<aum/rd)</pr>, <pos>n.</pos> <ety>[Of Celtic origin;
cf. W. <ets>bardd</ets>, Arm. <ets>barz</ets>, Ir. & Gael.
<ets>bard</ets>, and F. <ets>barde</ets>.]</ety> <sn>1.</sn> <def>A
professional poet and singer, as among the ancient Celts, whose
occupation was to compose and sing verses in honor of the heroic
achievements of princes and brave men.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Hence: A poet; <as>as, the <ex>bard</ex> of
Avon</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barde</ent><br/
<ent>Bard</ent><br/
<mhw>{ <hw>Bard</hw>, <hw>Barde</hw> }</mhw> <pr>(b<aum/rd)</pr>,
<pos>n.</pos> <ety>[F. <ets>barde</ets>, of doubtful origin.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>A piece of defensive (or, sometimes, ornamental)
armor for a horse's neck, breast, and flanks; a barb. [Often in the
<pos>pl.</pos>]</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <pluf>pl.</pluf> <def>Defensive armor formerly worn by a
man at arms.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Cookery)</fld> <def>A thin slice of fat bacon used
to cover any meat or game.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bard</ent><br/
<hw>Bard</hw>, <pos>v. t.</pos> <fld>(Cookery)</fld> <def>To cover (meat
or game) with a thin slice of fat bacon.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barded</ent><br/
<hw>Bard"ed</hw>, <pos>p. a.</pos> <ety>[See <er>Bard</er> horse
armor.]</ety> <sn>1.</sn> <def>Accoutered with defensive armor; -- said
of a horse.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Her.)</fld> <def>Wearing rich caparisons.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Fifteen hundred men . . . <qex>barded</qex> and richly
trapped.</q> <rj><qau>Stow.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bardic</ent><br/
<hw>Bard"ic</hw>, <pos>a.</pos> <def>Of or pertaining to bards, or their
poetry.</def> <ldquo/The <qex>bardic</qex> lays of ancient
Greece.<rdquo/ <rj><au>G. P. Marsh.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bardiglio</ent><br/
\'d8<hw>Bar*di"glio</hw> <pr>(b<aum/r*d<emac/l"y<omac/)</pr>,
<pos>n.</pos> <ety>[It.]</ety> <def>An Italian marble of which the
principal varieties occur in the neighborhood of Carrara and in Corsica.
It commonly shows a dark gray or bluish ground traversed by
veins.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Bardish</ent><br/
<hw>Bard"ish</hw>, <pos>a.</pos> <def>Pertaining to, or written by, a
bard or bards.</def> <ldquo/<xex>Bardish</xex> impostures.<rdquo/
<rj><au>Selden.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bardism</ent><br/
<hw>Bard"ism</hw> <pr>(b<aum/rd"<icr/z'm)</pr>, <pos>n.</pos> <def>The
system of bards; the learning and maxims of bards.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bardling</ent><br/
<hw>Bard"ling</hw> <pr>(b<aum/rd"l<icr/ng)</pr>, <pos>n.</pos> <def>An
inferior bard.</def> <rj><au>J. Cunningham.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bardship</ent><br/
<hw>Bard"ship</hw>, <pos>n.</pos> <def>The state of being a
bard.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bare</ent><br/
<hw>Bare</hw> <pr>(b<acir/r)</pr>, <pos>a.</pos> <ety>[OE.
<ets>bar</ets>, <ets>bare</ets>, AS. <ets>b<ae/r</ets>; akin to D. & G.
<ets>baar</ets>, OHG. <ets>par</ets>, Icel. <ets>berr</ets>, Sw. & Dan.
<ets>bar</ets>, Oslav. <ets>bos<ucr/</ets> barefoot, Lith.
<ets>basas</ets>; cf. Skr. <ets>bh<amac/s</ets> to shine.
<root/85.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>Without clothes or covering; stripped of the usual
covering; naked; <as>as, his body is <ex>bare</ex>; the trees are
<ex>bare</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>With head uncovered; bareheaded.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>When once thy foot enters the church, be <qex>bare</qex>.</q>
<rj><qau>Herbert.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Without anything to cover up or conceal one's
thoughts or actions; open to view; exposed.</def><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>Bare</qex> in thy guilt, how foul must thou appear !</q>
<rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>Plain; simple; unadorned; without polish; bald;
meager.</def> <ldquo/Uttering <xex>bare</xex> truth.<rdquo/
<rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>Destitute; indigent; empty; unfurnished or scantily
furnished; -- used with <xex>of</xex> (rarely with <xex>in</xex>) before
the thing wanting or taken away; <as>as, a room <ex>bare</ex> of
furniture</as>.</def> <ldquo/A <xex>bare</xex> treasury.<rdquo/
<rj><au>Dryden.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <def>Threadbare; much worn.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>It appears by their <qex>bare</qex> liveries that they live by
your bare words.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>7.</sn> <def>Mere; alone; unaccompanied by anything else; <as>as,
a <ex>bare</ex> majority</as>.</def> <ldquo/The <xex>bare</xex>
necessaries of life.<rdquo/ <rj><au>Addison.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Nor are men prevailed upon by <qex>bare</qex> words.</q>
<rj><qau>South.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Under bare poles</b></col> <fld>(Naut.)</fld>, <cd>having
no sail set.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bare</ent><br/
<hw>Bare</hw>, <pos>n.</pos> <sn>1.</sn> <def>Surface; body;
substance.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>You have touched the very <qex>bare</qex> of naked truth.</q>
<rj><qau>Marston.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Arch.)</fld> <def>That part of a roofing slate,
shingle, tile, or metal plate, which is exposed to the
weather.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bare</ent><br/
<hw>Bare</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos>
<conjf>Bared</conjf>(b<acir/rd); <pos>p. pr. & vb. n.</pos>
<conjf>Baring</conjf>.]</vmorph> <ety>[AS. <ets>barian</ets>. See
<er>Bare</er>, <pos>a.</pos>]</ety> <def>To strip off the covering of;
to make bare; <as>as, to <ex>bare</ex> the breast</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bare</ent><br/
<hw>Bare</hw>. <def>Bore; the old preterit of <er>Bear</er>,
<pos>v.</pos></def><br/
[<source>1913 Webster</source>]</p>

<p><ent>bare-assed</ent><br/
<ent>bare-ass</ent><br/
<mhw><hw>bare-ass</hw> <pr>(b<acir/r"<acr/s`)</pr>, <hw>bare-assed</hw>
<pr>(b<acir/r"<acr/st`)</pr>,</mhw> <pos>adj.</pos> <def>completely
naked.</def> <mark>[informal]</mark><br/
<syn><b>Syn. --</b> in the altogether, in the buff, in the raw, raw,
peeled, naked as a jaybird, stark naked.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Bareback</ent><br/
<hw>Bare"back`</hw> <pr>(b<acir/r"b<acr/k`)</pr>, <pos>adv.</pos>
<def>On the bare back of a horse, without using a saddle; <as>as, to
ride <ex>bareback</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barebacked</ent><br/
<hw>Bare"backed`</hw> <pr>(b<acir/r"b<acr/kd`)</pr>, <pos>a.</pos>
<def>Having the back uncovered; <as>as, a <ex>barebacked</ex>
horse</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barebone</ent><br/
<hw>Bare"bone`</hw> <pr>(b<acir/r"b<omac/n`)</pr>, <pos>n.</pos> <def>A
very lean person; one whose bones show through the skin.</def>
<rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>bare bones</ent><br/
<hw>bare" bones`</hw> <pr>(b<acir/r" b<omac/nz`)</pr>, <pos>n.</pos>
<def>the absolute minimum necessary.</def><br/
[<source>PJC</source>]</p>

<p><ent>bare-bones</ent><br/
<hw>bare"-bones`</hw> <pr>(b<acir/r"b<omac/nz`)</pr>, <pos>a.</pos>
<def>having only the absolute minimum necessary; having only the
essential components.</def><br/
[<source>PJC</source>]</p>

<p><ent>bare-breasted</ent><br/
<hw>bare-breasted</hw> <pr>(b<acir/r"br<ecr/st`<ecr/d)</pr>,
<pos>adj.</pos> <def>wearing no covering for the breasts or featuring
such nudity.</def> <illu><ex>bare-breasted</ex> beauties parading along
the beach</illu>"<br/
<syn><b>Syn. --</b> braless, topless.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Barefaced</ent><br/
<hw>Bare"faced`</hw> <pr>(b<acir/r"f<amac/st`)</pr>, <pos>a.</pos>
<sn>1.</sn> <def>With the face uncovered; not masked.</def> <ldquo/You
will play <xex>barefaced</xex>.<rdquo/ <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Without concealment; undisguised.</def>
<specif>Hence:</specif> <def>Shameless; audacious; <as>as, a
<ex>barefaced</ex> lie</as>.</def> <ldquo/<xex>Barefaced</xex>
treason.<rdquo/ <rj><au>J. Baillie.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barefacedly</ent><br/
<hw>Bare"faced`ly</hw>, <pos>adv.</pos> <def>Openly; shamelessly.</def>
<rj><au>Locke.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barefacedness</ent><br/
<hw>Bare"faced`ness</hw>, <pos>n.</pos> <def>The quality of being
barefaced; shamelessness; assurance; audaciousness.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barefoot</ent><br/
<hw>Bare"foot</hw> <pr>(b<acir/r"f<oocr/t)</pr>, <pos>a. & adv.</pos>
<def>With the feet bare; without shoes or stockings.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barefooted</ent><br/
<hw>Bare"foot`ed</hw>, <pos>a.</pos> <def>Having the feet
bare.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barege</ent><br/
\'d8<hw>Ba*r<eacute/ge"</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[F.
<ets>bar<eacute/ge</ets>, so called from <ets>Bar<eacute/ges</ets>, a
town in the Pyrenees.]</ety> <def>A gauzelike fabric for ladies'
dresses, veils, etc. of worsted, silk and worsted, or cotton and
worsted.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barehanded</ent><br/
<hw>Bare"hand`ed</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>Having bare
hands.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barehead</ent><br/
<ent>Bareheaded</ent><br/
<mhw>{ <hw>Bare"head`ed</hw> <pr>(<?/)</pr>, <hw>Bare"head</hw> }</mhw>,
<pos>a. & adv.</pos> <def>Having the head uncovered; <as>as, a
<ex>bareheaded</ex> girl</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>bare-legged</ent><br/
<ent>Barelegged</ent><br/
<mhw><hw>Bare"legged`</hw>, <hw>bare-legged</hw></mhw> <pr>(<?/)</pr>,
<pos>a.</pos> <def>Having the legs bare.</def>
<illu><ex>bare-legged</ex> children on the beach</illu><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barely</ent><br/
<hw>Bare"ly</hw>, <pos>adv.</pos> <sn>1.</sn> <def>Without covering;
nakedly.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Without concealment or disguise.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Merely; only.</def><br/
[<source>1913 Webster</source>]</p>

<p><q><qperson>R.</qperson> For now his son is duke.<br/
<qperson>W.</qperson> <qex>Barely</qex> in title, not in revenue.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>But just; without any excess; with nothing to spare
(of quantity, time, etc.); hence, scarcely; hardly; <as>as, there was
<ex>barely</ex> enough for all; he <ex>barely</ex>
escaped</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barenecked</ent><br/
<hw>Bare"necked`</hw> <pr>(<?/)</pr>, <pos>a.</pos> <def>Having the neck
bare.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bareness</ent><br/
<hw>Bare"ness</hw>, <pos>n.</pos> <def>The state of being
bare.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baresark</ent><br/
<hw>Bare"sark</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[Literally,
<ets>bare sark</ets> or <ets>shirt</ets>.]</ety> <def>A Berserker, or
Norse warrior who fought without armor, or shirt of mail. Hence,
adverbially: Without shirt of mail or armor.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barfish</ent><br/
<hw>Bar"fish`</hw> <pr>(<?/)</pr>, <pos>n.</pos> <fld>(Zool.)</fld>
<def>Same as <er>Calico bass</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barful</ent><br/
<hw>Bar"ful</hw> <pr>(<?/)</pr>, <pos>a.</pos> <def>Full of
obstructions.</def> <mark>[Obs.]</mark> <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bargain</ent><br/
<hw>Bar"gain</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[OE.
<ets>bargayn</ets>, <ets>bargany</ets>, OF. <ets>bargaigne</ets>,
<ets>bargagne</ets>, prob. from a supposed LL. <ets>barcaneum</ets>, fr.
<ets>barca</ets> a boat which carries merchandise to the shore; hence,
to traffic to and fro, to carry on commerce in general. See
<er>Bark</er> a vessel. ]</ety> <sn>1.</sn> <def>An agreement between
parties concerning the sale of property; or a contract by which one
party binds himself to transfer the right to some property for a
consideration, and the other party binds himself to receive the property
and pay the consideration.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>A contract is a <qex>bargain</qex> that is legally binding.</q>
<rj><qau>Wharton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>An agreement or stipulation; mutual
pledge.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>And whon your honors mean to solemnize<br/
The <qex>bargain</qex> of your faith.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>A purchase; also ( when not qualified), a gainful
transaction; an advantageous purchase; <as>as, to buy a thing at a
<ex>bargain</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>The thing stipulated or purchased; also, anything
bought cheap.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>She was too fond of her most filthy <qex>bargain</qex>.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Bargain and sale</b></col> <fld>(Law)</fld>, <cd>a
species of conveyance, by which the bargainor contracts to convey the
lands to the bargainee, and becomes by such contract a trustee for and
seized to the use of the bargainee. The statute then completes the
purchase; <it>i. e.</it>, the bargain vests the use, and the statute
vests the possession.</cd> <au>Blackstone.</au> -- <col><b>Into the
bargain</b></col>, <cd>over and above what is stipulated; besides.</cd>
-- <col><b>To sell bargains</b></col>, <cd>to make saucy (usually
indelicate) repartees.</cd> <mark>[Obs.]</mark> <au>Swift.</au> --
<col><b>To strike a bargain</b></col>, <cd>to reach or ratify an
agreement.</cd> <ldquo/A bargain was <xex>struck</xex>.<rdquo/
<au>Macaulay.</au></cs><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- Contract; stipulation; purchase;
engagement.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bargain</ent><br/
<hw>Bar"gain</hw>, <pos>v. i.</pos> <ety>[OE. <ets>barganien</ets>, OF.
<ets>bargaigner</ets>, F. <ets>barguigner</ets>, to hesitate, fr. LL.
<ets>barcaniare</ets>. See <er>Bargain</er>, <pos>n.</pos>]</ety>
<def>To make a bargain; to make a contract for the exchange of property
or services; -- followed by <xex>with</xex> and <xex>for</xex>; <as>as,
to <ex>bargain</ex> with a farmer for a cow</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>So worthless peasants <qex>bargain</qex> for their wives.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bargain</ent><br/
<hw>Bar"gain</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos>
<conjf>Bargained</conjf> (<?/); <pos>p. pr. & vb. n.</pos>
<conjf>Bargaining</conjf>.]</vmorph> <def>To transfer for a
consideration; to barter; to trade; <as>as, to <ex>bargain</ex> one
horse for another</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>To bargain away</b></col>, <cd>to dispose of in a
bargain; -- usually with a sense of loss or disadvantage; as, to
<xex>bargain away</xex> one's birthright.</cd> <ldquo/The heir . . . had
somehow <xex>bargained away</xex> the estate.<rdquo/ <rj><au>G.
Eliot.</au></rj></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bargainee</ent><br/
<hw>Bar`gain*ee"</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[OF.
<ets>bargaign<eacute/</ets>, p. p. See <er>Bargain</er>, <pos>v.
i.</pos>]</ety> <fld>(Law)</fld> <def>The party to a contract who
receives, or agrees to receive, the property sold.</def>
<rj><au>Blackstone.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bargainer</ent><br/
<hw>Bar"gain*er</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>One who makes a
bargain; -- sometimes in the sense of <xex>bargainor</xex>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bargainor</ent><br/
<hw>Bar`gain*or"</hw> <pr>(<?/)</pr>, <pos>n.</pos> <fld>(Law)</fld>
<def>One who makes a bargain, or contracts with another; esp., one who
sells, or contracts to sell, property to another.</def>
<rj><au>Blackstone.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barge</ent><br/
<hw>Barge</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[OF. <ets>barge</ets>,
F. <ets>berge</ets>, fr. LL. <ets>barca</ets>, for <ets>barica</ets>
(not found), prob. fr. L. <ets>baris</ets> an Egyptian rowboat, fr. Gr.
<ets><?/</ets>, prob. fr. Egyptian: cf. Coptic <ets>bari</ets> a boat.
Cf. <er>Bark</er> a vessel.]</ety> <sn>1.</sn> <def>A pleasure boat; a
vessel or boat of state, elegantly furnished and decorated.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A large, roomy boat for the conveyance of passengers
or goods; <as>as, a ship's <ex>barge</ex>; a charcoal
<ex>barge</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>A large boat used by flag officers.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>A double-decked passenger or freight vessel, towed
by a steamboat.</def> <mark>[U.S.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>A large omnibus used for excursions.</def>
<mark>[Local, U.S.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bargeboard</ent><br/
<hw>Barge"board`</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[Perh. corrup.
of <ets>vergeboard</ets>; or cf. LL. <ets>bargus</ets> a kind of
gallows.]</ety> <def>A vergeboard.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bargecourse</ent><br/
<hw>Barge"course`</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[See
<er>Bargeboard</er>.]</ety> <fld>(Arch.)</fld> <def>A part of the tiling
which projects beyond the principal rafters, in buildings where there is
a gable.</def> <rj><au>Gwilt.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bargee</ent><br/
<hw>Bar*gee"</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>A bargeman.</def>
<mark>[Eng.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>bargello</ent><br/
<hw>bargello</hw> <pos>n.</pos> <def>a needlepoint stitch that produces
zigzag lines.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Bargeman</ent><br/
<hw>Barge"man</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>The man who
manages a barge, or one of the crew of a barge.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bargemastter</ent><br/
<hw>Barge"mast`ter</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>The
proprietor or manager of a barge, or one of the crew of a
barge.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barger</ent><br/
<hw>Bar"ger</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>The manager of a
barge.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barghest</ent><br/
<hw>Bar"ghest`</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[Perh. G.
<ets>berg</ets> mountain + <ets>geist</ets> demon, or <ets>b<aum/r</ets>
a bear + <ets>geist</ets>.]</ety> <def>A goblin, in the shape of a large
dog, portending misfortune.</def> <altsp>[Also written
<asp>barguest</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baria</ent><br/
<hw>Ba"ri*a</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[Cf.
<er>Barium</er>.]</ety> <fld>(Chem.)</fld> <def>Baryta.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baric</ent><br/
<hw>Bar"ic</hw> <pr>(<?/)</pr>, <pos>a.</pos> <fld>(Chem.)</fld> <def>Of
or pertaining to barium; <as>as, <ex>baric</ex> oxide</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baric</ent><br/
<hw>Bar"ic</hw>, <pos>a.</pos> <ety>[Gr. <ets><?/</ets> weight.]</ety>
<fld>(Physics)</fld> <def>Of or pertaining to weight, esp. to the weight
or pressure of the atmosphere as measured by the barometer.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barilla</ent><br/
<hw>Ba*ril"la</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[Sp.
<ets>barrilla</ets>.]</ety> <sn>1.</sn> <fld>(Bot.)</fld> <def>A name
given to several species of Salsola from which soda is made, by burning
the barilla in heaps and lixiviating the ashes.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Com.)</fld> <sd>(a)</sd> <def>The alkali produced
from the plant, being an impure carbonate of soda, used for making soap,
glass, etc., and for bleaching purposes.</def> <sd>(b)</sd> <def>Impure
soda obtained from the ashes of any seashore plant, or kelp.</def>
<rj><au>Ure.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Copper barilla</b></col> <fld>(Min.)</fld>, <cd>native
copper in granular form mixed with sand, an ore brought from Bolivia; --
called also <altname>Barilla de cobre</altname>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barillet</ent><br/
\'d8<hw>Bar"il*let</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[F., dim. of
<ets>baril</ets> barrel.]</ety> <def>A little cask, or something
resembling one.</def> <rj><au>Smart.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bar iron</ent><br/
<hw>Bar" i`ron</hw> <pr>(<?/)</pr>. <def>See under
<er>Iron</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barite</ent><br/
<hw>Ba"rite</hw> <pr>(<?/)</pr>, <pos>n.</pos> <fld>(Min.)</fld>
<def>Native sulphate of barium, a mineral occurring in transparent,
colorless, white to yellow crystals (generally tabular), also in
granular form, and in compact massive forms resembling marble. It has a
high specific gravity, and hence is often called <altname>heavy
spar</altname>. It is a common mineral in metallic veins.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baritone</ent><br/
<hw>Bar"i*tone</hw> <pr>(<?/)</pr>, <pos>a. & n.</pos> <def>See
<er>Barytone</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barium</ent><br/
<hw>Ba"ri*um</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[NL., fr. Gr.
<ets><grk>bary`s</grk></ets> heavy.]</ety> <fld>(Chem.)</fld> <def>One
of the elements, belonging to the alkaline earth group; a metal having a
silver-white color, and melting at a very high temperature. It is
difficult to obtain the pure metal, from the facility with which it
becomes oxidized in the air. Atomic weight, 137. Symbol, Ba. Its oxide
called <xex>baryta</xex>.</def> <altsp>[Rarely written
<asp>barytum</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ Some of the compounds of this element are remarkable for
their high specific gravity, as the sulphate, called <xex>heavy
spar</xex>, and the like. The oxide was called <xex>barote</xex>, by
Guyton de Morveau, which name was changed by Lavoisier to
<xex>baryta</xex>, whence the name of the metal.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bard</ent><br/
<hw>Bard</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[Akin to Dan. & Sw.
<ets>bark</ets>, Icel. <ets>b<oum/rkr</ets>, LG. & HG.
<ets>borke</ets>.]</ety> <sn>1.</sn> <def>The exterior covering of the
trunk and branches of a tree; the rind.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Specifically, Peruvian bark.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Bark bed</b></col>. <cd>See <er>Bark stove</er>
(below).</cd> -- <col><b>Bark pit</b></col>, <cd>a pit filled with bark
and water, in which hides are steeped in tanning.</cd> -- <col><b>Bark
stove</b></col> <fld>(Hort.)</fld>, <cd>a glazed structure for keeping
tropical plants, having a bed of tanner's bark (called a <xex>bark
bed</xex>) or other fermentable matter which produces a moist
heat.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bark</ent><br/
<hw>Bark</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos>
<conjf>Barked</conjf> (<?/); <pos>p. pr. & vb. n.</pos>
<conjf>Barking</conjf>.]</vmorph> <sn>1.</sn> <def>To strip the bark
from; to peel.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To abrade or rub off any outer covering from; as to
<xex>bark</xex> one's heel.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To girdle. See <er>Girdle</er>, <pos>v. t.</pos>,
3.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>To cover or inclose with bark, or as with bark;
<as>as, to <ex>bark</ex> the roof of a hut</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bark</ent><br/
<hw>Bark</hw>, <pos>v. i.</pos> <ety>[OE. <ets>berken</ets>, AS.
<ets>beorcan</ets>; akin to Icel. <ets>berkja</ets>, and prob. to E.
<ets>break</ets>.]</ety> <sn>1.</sn> <def>To make a short, loud,
explosive noise with the vocal organs; -- said of some animals, but
especially of dogs.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To make a clamor; to make importunate
outcries.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>They <qex>bark</qex>, and say the Scripture maketh heretics.</q>
<rj><qau>Tyndale.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Where there is the <qex>barking</qex> of the belly, there no other
commands will be heard, much less obeyed.</q>
<rj><qau>Fuller.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bark</ent><br/
<hw>Bark</hw>, <pos>n.</pos> <def>The short, loud, explosive sound
uttered by a dog; a similar sound made by some other animals.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barque</ent><br/
<ent>Bark</ent><br/
<mhw>{ <hw>Bark</hw>, <hw>Barque</hw> }</mhw> <pr>(<?/)</pr>,
<pos>n.</pos> <ety>[F. <ets>barque</ets>, fr. Sp. or It.
<ets>barca</ets>, fr. LL. <ets>barca</ets> for <ets>barica</ets>. See
<er>Barge</er>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>Formerly, any small sailing vessel, as a pinnace,
fishing smack, etc.; also, a rowing boat; a barge. Now applied
poetically to a sailing vessel or boat of any kind.</def>
<rj><au>Byron.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Naut.)</fld> <def>A three-masted vessel, having her
foremast and mainmast square-rigged, and her mizzenmast
schooner-rigged.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barkantine</ent><br/
<hw>Bark"an*tine</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>Same as
<er>Barkentine</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bark beetle</ent><br/
<hw>Bark" bee`tle</hw> <pr>(<?/)</pr>. <fld>(Zool.)</fld> <def>A small
beetle of many species (family <fam>Scolytid<ae/</fam>), which in the
larval state bores under or in the bark of trees, often doing great
damage.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barkbound</ent><br/
<hw>Bark"bound`</hw> <pr>(<?/)</pr>, <pos>a.</pos> <def>Prevented from
growing, by having the bark too firm or close.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barkeeper</ent><br/
<hw>Bar"keep`er</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>One who keeps or
tends a bar for the sale of liquors.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barken</ent><br/
<hw>Bark"en</hw> <pr>(<?/)</pr>, <pos>a.</pos> <def>Made of bark.</def>
<mark>[Poetic]</mark> <rj><au>Whittier.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barkentine</ent><br/
<hw>Bark"en*tine</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[See
<er>Bark</er>, <pos>n.</pos>, a vessel.]</ety> <fld>(Naut.)</fld> <def>A
threemasted vessel, having the foremast square-rigged, and the others
schooner-rigged. <altsp>[Spelled also <asp>barquentine</asp>,
<asp>barkantine</asp>, etc.]</altsp> See <xex>Illust.</xex> in
Append.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barker</ent><br/
<hw>Bark"er</hw> <pr>(<?/)</pr>, <pos>n.</pos> <sn>1.</sn> <def>An
animal that barks; hence, any one who clamors unreasonably.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>One who stands at the doors of shops to urge passers
by to make purchases.</def> <mark>[Cant, Eng.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>A pistol.</def> <mark>[Slang]</mark>
<rj><au>Dickens.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <fld>(Zool.)</fld> <def>The spotted redshank.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barker</ent><br/
<hw>Bark"er</hw>, <pos>n.</pos> <def>One who strips trees of their
bark.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barker's mill</ent><br/
<hw>Bark"er's mill`</hw> <pr>(<?/)</pr>. <ety>[From Dr.
<ets>Barker</ets>, the inventor.]</ety> <def>A machine, invented in the
17th century, worked by a form of reaction wheel. The water flows into a
vertical tube and gushes from apertures in hollow horizontal arms,
causing the machine to revolve on its axis.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barkery</ent><br/
<hw>Bark"er*y</hw> <pr>(-<etil/r*<ycr/)</pr>, <pos>n.</pos> <def>A
tanhouse.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barking irons</ent><br/
<hw>Bark"ing i`rons</hw> <pr>(<?/)</pr>. <sn>1.</sn> <def>Instruments
used in taking off the bark of trees.</def>
<rj><au>Gardner.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A pair of pistols.</def> <mark>[Slang]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barkless</ent><br/
<hw>Bark"less</hw>, <pos>a.</pos> <def>Destitute of bark.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bark louse</ent><br/
<hw>Bark" louse`</hw> <pr>(<?/)</pr>. <fld>(Zool.)</fld> <def>An insect
of the family <fam>Coccid<ae/</fam>, which infests the bark of trees and
vines.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ The wingless females assume the shape of scales. The
bark louse of the vine is <spn>Pulvinaria innumerabilis</spn>; that of
the pear is <spn>Lecanium pyri</spn>. See <er>Orange
scale</er>.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barky</ent><br/
<hw>Bark"y</hw> <pr>(<?/)</pr>, <pos>a.</pos> <def>Covered with, or
containing, bark.</def> <ldquo/The <xex>barky</xex> fingers of the
elm.<rdquo/ <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barley</ent><br/
<hw>Bar"ley</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[OE.
<ets>barli</ets>, <ets>barlich</ets>, AS. <ets>b<ae/rlic</ets>;
<ets>bere</ets> barley + <ets>l<imac/c</ets> (which is prob. the same as
E. <ets>like</ets>, adj., or perh. a form of AS. <ets>le<amac/c</ets>
leek). AS. <ets>bere</ets> is akin to Icel, <ets>barr</ets> barley,
Goth. <ets>barizeins</ets> made of barley, L. <ets>far</ets> spelt; cf.
W. <ets>barlys</ets> barley, <ets>bara</ets> bread. <?/92. Cf.
<er>Farina</er>, 6th <er>Bear</er>.]</ety> <fld>(Bot.)</fld> <def>A
valuable grain, of the family of grasses, genus <gen>Hordeum</gen>, used
for food, and for making malt, from which are prepared beer, ale, and
whiskey.</def><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 120 pr=SA --></p>

<p><cs><col><b>Barley bird</b></col> <fld>(Zool.)</fld>, <cd>the
siskin.</cd> -- <col><b>Barley sugar</b></col>, <cd>sugar boiled till it
is brittle (formerly with a decoction of barley) and candied.</cd> --
<col><b>Barley water</b></col>, <cd>a decoction of barley, used in
medicine, as a nutritive and demulcent.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barleybreak</ent><br/
<ent>Barleybrake</ent><br/
<mhw>{ <hw>Bar"ley*brake`</hw> <hw>Bar"ley*break`</hw> }</mhw>
<pr>(b<aum/r"l<ycr/*br<amac/k`)</pr>, <pos>n.</pos> <def>An ancient
rural game, commonly played round stacks of barley, or other grain, in
which some of the party attempt to catch others who run from a
goal.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barley-bree</ent><br/
<hw>Bar"ley-bree`</hw> <pr>(-br<emac/`)</pr>, <pos>n.</pos> <ety>[Lit.
barley broth. See <er>Brew</er>.]</ety> <def>Liquor made from barley;
strong ale.</def> <mark>[Humorous]</mark> <mark>[Scot.]</mark>
<rj><au>Burns.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barleycorn</ent><br/
<hw>Bar"ley*corn`</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[See
<er>Corn</er>.]</ety> <sn>1.</sn> <def>A grain or <ldquo/corn<rdquo/ of
barley.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Formerly , a measure of length, equal to the average
length of a grain of barley; the third part of an inch.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>John Barleycorn</b></col>, <cd>a humorous personification
of barley as the source of malt liquor or whisky.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barm</ent><br/
<hw>Barm</hw> <pr>(b<aum/rm)</pr>, <pos>n.</pos> <ety>[OE.
<ets>berme</ets>, AS. <ets>beorma</ets>; akin to Sw.
<ets>b<aum/rma</ets>, G. <ets>b<aum/rme</ets>, and prob. L.
<ets>fermentum</ets>. <root/93.]</ety> <def>Foam rising upon beer, or
other malt liquors, when fermenting, and used as leaven in making bread
and in brewing; yeast.</def> <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barm</ent><br/
<hw>Barm</hw>, <pos>n.</pos> <ety>[OE. <ets>bearm</ets>,
<ets>berm</ets>, <ets>barm</ets>, AS. <ets>bearm</ets>; akin to E.
<ets>bear</ets> to support.]</ety> <def>The lap or bosom.</def>
<mark>[Obs.]</mark> <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barmaid</ent><br/
<hw>Bar"maid`</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>A girl or woman
who attends the customers of a bar, as in a tavern or
beershop.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>A bouncing <qex>barmaid</qex>.</q> <rj><qau>W.
Irving.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barmaster</ent><br/
<hw>Bar"mas`ter</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[<ets>Berg</ets>
+ <ets>master</ets>: cf. G. <ets>Bergmeister</ets>.]</ety>
<def>Formerly, a local judge among miners; now, an officer of the
barmote.</def> <mark>[Eng.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barmcloth</ent><br/
<hw>Barm"cloth`</hw> <pr>(b<aum/rm"kl<ocr/th)</pr>, <pos>n.</pos>
<def>Apron.</def> <mark>[Obs.]</mark> <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barmecidal</ent><br/
<hw>Bar"me*ci`dal</hw> <pr>(<?/)</pr>, <pos>a.</pos> <ety>[See
<er>Barmecide</er>.]</ety> <def>Unreal; illusory.</def> <ldquo/A sort of
<xex>Barmecidal</xex> feast.<rdquo/ <rj><au>Hood.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barmecide</ent><br/
<hw>Bar"me*cide</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[A prince of the
<ets>Barmecide</ets> family, who, as related in the <ldquo/Arabian
Nights' Tales<rdquo/, pretended to set before the hungry Shacabac food,
on which the latter pretended to feast.]</ety> <def>One who proffers
some illusory advantage or benefit. Also used as an <pos>adj.</pos>:
Barmecidal.</def> <ldquo/A <xex>Barmecide</xex> feast.<rdquo/
<rj><au>Dickens.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barmote</ent><br/
<hw>Bar"mote`</hw> <pr>(b<aum/r"m<omac/t`)</pr>, <pos>n.</pos>
<ety>[<ets>Berg</ets> + <ets>mote</ets> meeting.]</ety> <def>A court
held in Derbyshire, in England, for deciding controversies between
miners.</def> <rj><au>Blount.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barmy</ent><br/
<hw>Barm"y</hw> <pr>(b<aum/rm"<ycr/)</pr>, <pos>a.</pos> <def>Full of
barm or froth; in a ferment.</def> <ldquo/<xex>Barmy</xex> beer.<rdquo/
<rj><au>Dryden.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barn</ent><br/
<hw>Barn</hw> <pr>(b<aum/rn)</pr>, <pos>n.</pos> <ety>[OE.
<ets>bern</ets>, AS. <ets>berern</ets>, <ets>bern</ets>; <ets>bere</ets>
barley + <ets>ern</ets>, <ets><ae/rn</ets>, a close place. <root/92. See
<er>Barley</er>.]</ety> <def>A covered building used chiefly for storing
grain, hay, and other productions of a farm. In the United States a part
of the barn is often used for stables.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Barn owl</b></col> <fld>(Zool.)</fld>, <cd>an owl of
Europe and America (<spn>Aluco flammeus</spn>, or <spn>Strix
flammea</spn>), which frequents barns and other buildings.</cd> --
<col><b>Barn swallow</b></col> <fld>(Zool.)</fld>, <cd>the common
American swallow (<spn>Hirundo horreorum</spn>), which attaches its nest
of mud to the beams and rafters of barns.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barn</ent><br/
<hw>Barn</hw>, <pos>v. t.</pos> <def>To lay up in a barn.</def>
<mark>[Obs.]</mark> <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Men . . . often <qex>barn</qex> up the chaff, and burn up the
grain.</q> <rj><qau>Fuller.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barn</ent><br/
<hw>Barn</hw>, <pos>n.</pos> <def>A child. See <er>Bairn</er>.</def>
<mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barnabite</ent><br/
<hw>Bar"na*bite</hw> <pr>(<?/)</pr>, <pos>n.</pos> <fld>(Eccl.
Hist.)</fld> <def>A member of a religious order, named from <person>St.
<etsep>Barnabas</etsep></person>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barnacle</ent><br/
<hw>Bar"na*cle</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[Prob. from E.
<ets>barnacle</ets> a kind of goose, which was popularly supposed to
grow from this shellfish; but perh. from LL. <ets>bernacula</ets> for
<ets>pernacula</ets>, dim. of <ets>perna</ets> ham, sea mussel; cf. Gr.
<grk>pe`rna</grk> ham. Cf. F. <ets>bernacle</ets>, <ets>barnacle</ets>,
E. <ets>barnacle</ets> a goose; and Ir. <ets>bairneach</ets>,
<ets>barneach</ets>, limpet.]</ety> <fld>(Zool.)</fld> <def>Any cirriped
crustacean adhering to rocks, floating timber, ships, etc., esp.
<sd>(a)</sd> the sessile species (genus <gen>Balanus</gen> and allies),
and <sd>(b)</sd> the stalked or goose barnacles (genus <gen>Lepas</gen>
and allies). See <er>Cirripedia</er>, and <er>Goose
barnacle</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Barnacle eater</b></col> <fld>(Zool.)</fld>, <cd>the
orange filefish.</cd> -- <col><b>Barnacle scale</b></col>
<fld>(Zool.)</fld>, <cd>a bark louse (<spn>Ceroplastes
cirripediformis</spn>) of the orange and quince trees in Florida. The
female scale curiously resembles a sessile barnacle in
form.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barnacle</ent><br/
<hw>Bar"na*cle</hw>, <pos>n.</pos> <ety>[See <er>Bernicle</er>.]</ety>
<def>A bernicle goose.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barnacle</ent><br/
<hw>Bar"na*cle</hw>, <pos>n.</pos> <ety>[OE. <ets>bernak</ets>,
<ets>bernacle</ets>; cf. OF. <ets>bernac</ets>, and Prov. F. (Berri)
<ets>berniques</ets>, spectacles.]</ety> <sn>1.</sn> <pluf>pl.</pluf>
<fld>(Far.)</fld> <def>An instrument for pinching a horse's nose, and
thus restraining him.</def> <note>[Formerly used in the
<pos>sing.</pos>]</note><br/
[<source>1913 Webster</source>]</p>

<p><q>The <qex>barnacles</qex> . . . give pain almost equal to that of
the switch.</q> <rj><qau>Youatt.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <pluf>pl.</pluf> <def>Spectacles; -- so called from their
resemblance to the barnacles used by farriers.</def> <mark>[Cant,
Eng.]</mark> <rj><au>Dickens.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>barnacled</ent><br/
<hw>barnacled</hw> <pos>adj.</pos> <sn>1.</sn> <def>covered with
barnacles.</def> <illu>the <ex>barnacled</ex> hull of a wrecked
ship</illu><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Barnburner</ent><br/
<hw>Barn"burn`er</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[So called in
allusion to the fable of the man who burned his barn in order to rid it
of rats.]</ety> <sn>1.</sn> <def>A member of the radical section of the
Democratic party in New York, about the middle of the 19th century,
which was hostile to extension of slavery, public debts, corporate
privileges, etc., and supported <person>Van Buren</person> against
<person>Cass</person> for president in 1848; -- opposed to
<contr>Hunker</contr>.</def> <mark>[Political Cant, U. S.]</mark><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><sn>2.</sn> <def>an impressively successful or unusually good
event.</def> <mark>[informal]</mark> <rdquo/The rock concert was a real
<xex>barnburner</xex>.<rdquo/<br/
[<source>WordNet 1.5</source>]</p>

<p><ent>barndoor</ent><br/
<hw>barndoor</hw> <pos>n.</pos> <def>An opaque adjustable flap on a lamp
fixture; used in photography to cut off light from particular
areas.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>barnful</ent><br/
<hw>barnful</hw> <pos>n.</pos> <sn>1.</sn> <def>The quantity that a barn
will hold.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Barnstorm</ent><br/
<hw>Barn"storm`</hw> <pr>(?)</pr>, <pos>v. i. & t.</pos>
<ety>[<ets>Barn</ets> + <ets>storm</ets>, v.]</ety> <sn>1.</sn> <def>To
travel from place to place, making brief stops.</def><br/
[<source>PJC</source>]</p>

<p><sn>2.</sn> <def>To fly an airplane from place to place, usually at
small airports, doing flying stunts or flying passengers for
sightseeing, for the purpose of earning money.</def><br/
[<source>PJC</source>]</p>

<p><sn>3.</sn> <def>to tour the country to solicit votes.</def><br/
<syn><b>Syn. --</b> whistlestop.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Barnstormer</ent><br/
<hw>Barn"storm`er</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[<ets>Barn</ets>
+ <ets>storm</ets>, v.]</ety> <sn>1.</sn> <def>An itinerant theatrical
player who plays in barns when a theatre is lacking; hence, an inferior
actor, or one who plays in the country away from the larger
cities.</def> -- <wordforms><wf>Barn"storm`ing</wf>, <pos>n.</pos>
<mark>[Theatrical Cant]</mark></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>an aviator who flies an airplane from place to
place, usually at small airports, doing flying stunts or flying
passengers for sightseeing, for the purpose of earning money. It was a
practise common in the early days of aviation, but by late 20th century
was seldom encountered.</def><br/
[<source>PJC</source>]</p>

<p><ent>Barnyard</ent><br/
<hw>Barn"yard`</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>A yard belonging
to a barn.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barocco</ent><br/
\'d8<hw>Ba*roc"co</hw> <pr>(<?/)</pr>, <pos>a.</pos> <ety>[It.]</ety>
<fld>(Arch.)</fld> <def>See <er>Baroque</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barocyclonometer</ent><br/
<hw>Bar`o*cy`clon*om"e*ter</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr.
<grk>ba`ros</grk> weight + <ets>cyclone</ets> +
<ets>-meter</ets>.]</ety> <fld>(Meteorol.)</fld> <def>An aneroid
barometer for use with accompanying graphic diagrams and printed
directions designed to aid mariners to interpret the indications of the
barometer so as to determine the existence of a violent storm at a
distance of several hundred miles.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Barogram</ent><br/
<hw>Bar"o*gram</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr.
<grk>ba`ros</grk> weight + <ets>-gram</ets>.]</ety> <fld>(Meteor.)</fld>
<def>A tracing, usually made by the barograph, showing graphically the
variations of atmospheric pressure for a given time.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Barograph</ent><br/
<hw>Bar"o*graph</hw> <pr>(b<adot/*r<omac/"k<osl/)</pr>, <pos>n.</pos>
<ety>[Gr. <grk>ba`ros</grk> weight + <ets>-graph</ets>.]</ety>
<fld>(Meteor.)</fld> <def>An instrument for recording automatically the
variations of atmospheric pressure.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baroko</ent><br/
<hw>Ba*ro"ko</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[A mnemonic
word.]</ety> <fld>(Logic)</fld> <def>A form or mode of syllogism of
which the first proposition is a universal affirmative, and the other
two are particular negatives.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barology</ent><br/
<hw>Ba*rol"o*gy</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[Gr.
<grk>ba`ros</grk> weight + <ets>-logy</ets>.]</ety> <def>The science of
weight or gravity.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baromacrometer</ent><br/
<hw>Bar`o*ma*crom"e*ter</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[Gr.
<grk>ba`ros</grk> weight + <grk>makro`s</grk> long +
<ets>-meter</ets>.]</ety> <fld>(Med.)</fld> <def>An instrument for
ascertaining the weight and length of a newborn infant.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barometer</ent><br/
<hw>Ba*rom"e*ter</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[Gr.
<grk>ba`ros</grk> weight + <ets>-meter</ets>: cf. F.
<ets>barom<egrave/tre</ets>.]</ety> <def>An instrument for determining
the weight or pressure of the atmosphere, and hence for judging of the
probable changes of weather, or for ascertaining the height of any
ascent.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ The barometer was invented by Torricelli at Florence
about 1643. It is made in its simplest form by filling a graduated glass
tube about 34 inches long with mercury and inverting it in a cup
containing mercury. The column of mercury in the tube descends until
balanced by the weight of the atmosphere, and its rise or fall under
varying conditions is a measure of the change in the atmospheric
pressure. At the sea level its ordinary height is about 30 inches (760
millimeters). See <er>Sympiesometer</er>.</note>
<rj><au>Nichol.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Aneroid barometer</b></col>. <cd>See <cref>Aneroid
barometer</cref>, under <er>Aneroid</er>.</cd> -- <col><b>Marine
barometer</b></col>, <cd>a barometer with tube contracted at bottom to
prevent rapid oscillations of the mercury, and suspended in gimbals from
an arm or support on shipboard.</cd> -- <col><b>Mountain
barometer</b></col>, <cd>a portable mercurial barometer with tripod
support, and long scale, for measuring heights.</cd> -- <col><b>Siphon
barometer</b></col>, <cd>a barometer having a tube bent like a hook with
the longer leg closed at the top. The height of the mercury in the
longer leg shows the pressure of the atmosphere.</cd> -- <col><b>Wheel
barometer</b></col>, <cd>a barometer with recurved tube, and a float,
from which a cord passes over a pulley and moves an index.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barometrical</ent><br/
<ent>Barometric</ent><br/
<mhw>{ <hw>Bar`o*met"ric</hw> <pr>(b<acr/r`<osl/*m<ecr/t"r<icr/k)</pr>,
<hw>Bar`o*met"ric*al</hw>
<pr>(b<acr/r`<osl/*m<ecr/t"r<icr/*k<ait/l)</pr>, }</mhw> <pos>a.</pos>
<def>Pertaining to the barometer; made or indicated by a barometer;
<as>as, <ex>barometric</ex> changes; <ex>barometrical</ex>
observations</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barometrically</ent><br/
<hw>Bar`o*met"ric*al*ly</hw>, <pos>adv.</pos> <def>By means of a
barometer, or according to barometric observations.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barometrograph</ent><br/
<hw>Bar`o*met"ro*graph</hw>
<pr>(b<acr/r`<osl/*m<ecr/t"r<osl/*gr<adot/f)</pr>, <pos>n.</pos>
<ety>[Gr. <grk>ba`ros</grk> weight + <grk>me`tron</grk> measure +
<ets>-graph</ets>.]</ety> <def>A form of barometer so constructed as to
inscribe of itself upon paper a record of the variations of atmospheric
pressure.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barometry</ent><br/
<hw>Ba*rom"e*try</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>The art or
process of making barometrical measurements.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barometz</ent><br/
<hw>Bar"o*metz</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[Cf. Russ.
<ets>baranets'</ets> clubmoss.]</ety> <fld>(Bot.)</fld> <def>The
woolly-skinned rhizoma or rootstock of a fern (<spn>Dicksonia
barometz</spn>), which, when specially prepared and inverted, somewhat
resembles a lamb; -- called also <altname>Scythian
lamb</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baron</ent><br/
<hw>Bar"on</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[OE.
<ets>baron</ets>, <ets>barun</ets>, OF. <ets>baron</ets>, accus. of
<ets>ber</ets>, F. <ets>baron</ets>, prob. fr. OHG. <ets>baro</ets> (not
found) bearer, akin to E. <ets>bear</ets> to support; cf. O. Frisian
<ets>bere</ets>, LL. <ets>baro</ets>, It. <ets>barone</ets>, Sp.
<ets>varon</ets>. From the meaning <ets>bearer</ets> (of burdens) seem
to have come the senses <ets>strong man</ets>, <ets>man</ets> (in
distinction from woman), which is the oldest meaning in French, and
lastly, <ets>nobleman</ets>. Cf. L. <ets>baro</ets>, simpleton. See
<er>Bear</er> to support.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>A title or degree of nobility; originally, the
possessor of a fief, who had feudal tenants under him; in modern times,
in France and Germany, a nobleman next in rank below a count; in
England, a nobleman of the lowest grade in the House of Lords, being
next below a viscount.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ <ldquo/The tenants in chief from the Crown, who held
lands of the annual value of four hundred pounds, were styled
<ex>Barons</ex>; and it is to them, and not to the members of the lowest
grade of the nobility (to whom the title at the present time belongs),
that reference is made when we read of the Barons of the early days of
England's history. . . . Barons are addressed as <lsquo/My Lord,' and
are styled <lsquo/Right Honorable.' All their sons and daughters are
<lsquo/Honorable.'<rdquo/</note> <rj><au>Cussans.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Old Law)</fld> <def>A husband; <as>as,
<ex>baron</ex> and <ex>feme</ex>, husband and wife</as>.</def>
<mark>[R.]</mark> <rj><au>Cowell.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Baron of beef</b></col>, <cd>two sirloins not cut asunder
at the backbone.</cd> -- <col><b>Barons of the Cinque Ports</b></col>,
<cd>formerly members of the House of Commons, elected by the seven
Cinque Ports, two for each port.</cd> -- <col><b>Barons of the
exchequer</b></col>, <cd>the judges of the Court of Exchequer, one of
the three ancient courts of England, now abolished.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baronage</ent><br/
<hw>Bar"on*age</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[OE.
<ets>barnage</ets>, <ets>baronage</ets>, OF. <ets>barnage</ets>, F.
<ets>baronnage</ets>; cf. LL. <ets>baronagium</ets>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>The whole body of barons or peers.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The <qex>baronage</qex> of the kingdom.</q> <rj><qau>Bp.
Burnet.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The dignity or rank of a baron.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>The land which gives title to a baron.</def>
<mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>baronduki</ent><br/
<hw>baronduki</hw> <pos>n.</pos> <def>same as <er>baranduki</er>; the
terrestrial Siberian squirrel.</def><br/
<syn><b>Syn. --</b> baranduki, barunduki, burunduki, Eutamius asiaticus,
Eutamius sibiricus.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Baroness</ent><br/
<hw>Bar"on*ess</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>A baron's wife;
also, a lady who holds the baronial title in her own right; <as>as, the
<ex>Baroness</ex> Burdett-Coutts</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baronet</ent><br/
<hw>Bar"on*et</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[<ets>Baron</ets>
+ <ets>-et</ets>.]</ety> <def>A dignity or degree of honor next below a
baron and above a knight, having precedency of all orders of knights
except those of the Garter. It is the lowest degree of honor that is
hereditary. The baronets are commoners.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ The order was founded by James I. in 1611, and is given
by patent. The word, however, in the sense of a <xex>lesser</xex> baron,
was in use long before. <ldquo/Baronets have the title of 'Sir' prefixed
to their Christian names; their surnames being followed by their
dignity, usually abbreviated <abbr>Bart.</abbr> Their wives are
addressed as 'Lady' or 'Madam'. Their sons are possessed of no title
beyond 'Esquire.'<rdquo/</note> <rj><au>Cussans.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baronetage</ent><br/
<hw>Bar"on*et*age</hw> <pr>(<?/)</pr>, <pos>n.</pos> <sn>1.</sn>
<def>State or rank of a baronet.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The collective body of baronets.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baronetcy</ent><br/
<hw>Bar"on*et*cy</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>The rank or
patent of a baronet.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barong</ent><br/
\'d8<hw>Ba*rong"</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Native
name.]</ety> <def>A kind of cutting weapon similar to a cleaver, with a
thick back and thin razorlike edge, used by the Moros of the Philippine
Islands.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Baronial</ent><br/
<hw>Ba*ro"ni*al</hw> <pr>(<?/)</pr>, <pos>a.</pos> <def>Pertaining to a
baron or a barony.</def> <ldquo/<xex>Baronial</xex> tenure.<rdquo/
<rj><au>Hallam.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barony</ent><br/
<hw>Bar"o*ny</hw> <pr>(<?/)</pr>, <pos>n.</pos>; <plu><it>pl.</it>
<plw>Baronies</plw> <pr>(<?/)</pr>.</plu> <ety>[OF. <ets>baronie</ets>,
F. <ets>baronnie</ets>, LL. <ets>baronia</ets>. See
<er>Baron</er>.]</ety> <sn>1.</sn> <def>The fee or domain of a baron;
the lordship, dignity, or rank of a baron.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>In Ireland, a territorial division, corresponding
nearly to the English <altname>hundred</altname>, and supposed to have
been originally the district of a native chief. There are 252 of these
baronies. In Scotland, an extensive freehold. It may be held by a
commoner.</def> <rj><au>Brande & C.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baroque</ent><br/
<hw>Ba*roque"</hw> <pr>(<?/)</pr>, <pos>a.</pos> <ety>[F.; cf. It.
<ets>barocco</ets>.]</ety> <fld>(Arch.)</fld> <sn>1.</sn> <def>of,
pertaining to, or characteristic of, an artistic style common in the
17th century, characterized by the use of complex and elaborate
ornamentation, curved rather than straight lines, and, in music a high
degree of embellishment.</def><br/
[<source>PJC</source>]</p>

<p><sn>2.</sn> <def>Hence, overly complicated, or ornamented to excess;
in bad taste; grotesque; odd.</def><br/
[<source>1913 Webster</source> <source>+PJC</source>]</p>

<p><sn>3.</sn> <def>Irregular in form; -- said esp. of a
pearl.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Baroscope</ent><br/
<hw>Bar"o*scope</hw> <pr>(b<acr/r"<osl/*sk<omac/p)</pr>, <pos>n.</pos>
<ety>[Gr. <grk>ba`ros</grk> weight + <ets>-scope</ets>: cf. F.
<ets>baroscope</ets>.]</ety> <def>Any instrument showing the changes in
the weight of the atmosphere; also, less appropriately, any instrument
that indicates or foreshadows changes of the weather, as a deep vial of
liquid holding in suspension some substance which rises and falls with
atmospheric changes.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baroscopical</ent><br/
<ent>Baroscopic</ent><br/
<mhw>{ <hw>Bar`o*scop"ic</hw> <pr>(<?/)</pr>, <hw>Bar`o*scop"ic*al</hw>
<pr>(<?/)</pr>, }</mhw> <pos>a.</pos> <def>Pertaining to, or determined
by, the baroscope.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barothermograph</ent><br/
<hw>Bar`o*ther"mo*graph</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr. <?/
weight + <ets>thermograph</ets>.]</ety> <def>An instrument for recording
both pressure and temperature, as of the atmosphere.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Barouche</ent><br/
<hw>Ba*rouche"</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[G.
<ets>barutsche</ets>, It. <ets>baroccio</ets>, <ets>biroccio</ets>, LL.
<ets>barrotium</ets>, fr. L. <ets>birotus</ets> two-wheeled; <ets>bi- =
bis</ets> twice + <ets>rota</ets> wheel.]</ety> <def>A four-wheeled
carriage, with a falling top, a seat on the outside for the driver, and
two double seats on the inside arranged so that the sitters on the front
seat face those on the back seat.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barouchet</ent><br/
<hw>Ba`rou*chet"</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>A kind of light
barouche.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barpost</ent><br/
<hw>Bar"post`</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>A post sunk in the
ground to receive the bars closing a passage into a field.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barque</ent><br/
<hw>Barque</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>Same as 3d
<er>Bark</er>, <pos>n.</pos></def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barracan</ent><br/
<hw>Bar"ra*can</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[F.
<ets>baracan</ets>, <ets>bouracan</ets> (cf. Pr. <ets>barracan</ets>,
It. <ets>baracane</ets>, Sp. <ets>barragan</ets>, Pg.
<ets>barregana</ets>, LL. <ets>barracanus</ets>), fr. Ar.
<ets>barrak<amac/n</ets> a kind of black gown, perh. fr. Per.
<ets>barak</ets> a garment made of camel's hair.]</ety> <def>A thick,
strong stuff, somewhat like camlet; -- still used for outer garments in
the Levant.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barrack</ent><br/
<hw>Bar"rack</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[F.
<ets>baraque</ets>, fr. It. <ets>baracca</ets> (cf. Sp.
<ets>barraca</ets>), from LL. <ets>barra</ets> bar. See <er>Bar</er>,
<pos>n.</pos>]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <fld>(Mil.)</fld> <def>A building for soldiers,
especially when in garrison. Commonly in the <pluf>pl.</pluf>,
originally meaning temporary huts, but now usually applied to a
permanent structure or set of buildings.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>He lodged in a miserable hut or <qex>barrack</qex>, composed of
dry branches and thatched with straw.</q>
<rj><qau>Gibbon.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A movable roof sliding on four posts, to cover hay,
straw, etc.</def> <mark>[Local, U.S.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barrack</ent><br/
<hw>Bar"rack</hw>, <pos>v. t.</pos> <def>To supply with barracks; to
establish in barracks; <as>as, to <ex>barrack</ex>
troops</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barrack</ent><br/
<hw>Bar"rack</hw>, <pos>v. i.</pos> <def>To live or lodge in
barracks.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barraclade</ent><br/
<hw>Bar"ra*clade</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[D.
<ets>baar</ets>, OD. <ets>baer</ets>, naked, bare + <ets>kleed</ets>
garment, <it>i. e.</it>, cloth undressed or without nap.]</ety> <def>A
home-made woolen blanket without nap.</def> <mark>[Local, New
York]</mark> <rj><au>Bartlett.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barracoon</ent><br/
<hw>Bar"ra*coon`</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[Sp. or Pg.
<ets>barraca</ets>. See <er>Barrack</er>.]</ety> <def>A slave warehouse,
or an inclosure where slaves are quartered temporarily.</def> <rj><au>Du
Chaillu.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barracouta</ent><br/
<ent>Barracuda</ent><br/
<mhw>{ <hw>Bar`ra*cu"da</hw> <pr>(<?/)</pr>, <hw>Bar`ra*cou"ta</hw>
<pr>(<?/)</pr>, }</mhw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Native
name.]</ety> <fld>(Zool.)</fld> <def>Any of several voracious pikelike
marine fishes allied to the gray mullets, constituting the genus
<gen>Sphyr<ae/na</gen> and family <fam>Sphyr<ae/nid<ae/</fam>. The great
barracuda (<spn>Sphyr<ae/na barracuda</spn>) of the West Indies,
Florida, etc., is often six feet or more long, and as dangerous as a
shark. In Cuba its flesh is reputed to be poisonous. <spn>Sphyr<ae/na
Argentea</spn> of the Pacific coast and <spn>Sphyr<ae/na
sphyr<ae/na</spn> of Europe are smaller species, and are used as
food.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><note><hand/ That of Europe and our Atlantic coast is
<spn>Sphyr<ae/na spet</spn> (or <spn>Sphyr<ae/na vulgaris</spn>); a
southern species is <spn>Sphyr<ae/na picuda</spn>; the Californian is
<spn>Sphyr<ae/na argentea</spn>.</note><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Zool.)</fld> <def>A large edible fresh-water fish
of Australia and New Zealand (<spn>Thyrsites atun</spn>).</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barrage</ent><br/
<hw>Bar"rage</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[F., fr.
<ets>barrer</ets> to bar, from <ets>barre</ets> bar.]</ety>
<fld>(Engin.)</fld> <def>An artificial bar or obstruction placed in a
river or watercourse to increase the depth of water; <as>as, the
<ex>barrages</ex> of the Nile</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barramundi</ent><br/
<hw>Bar`ra*mun"di</hw> <pr>(?)</pr>, <pos>n.</pos> <altsp>[Written also
<asp>barramunda</asp>.]</altsp> <ety>[Native name.]</ety>
<fld>(Zool.)</fld> <sd>(a)</sd> <def>A remarkable Australian fresh-water
ganoid fish of the genus <gen>Ceratodus</gen>.</def> <sd>(b)</sd>
<def>An Australian river fish (<spn>Osteoglossum
Leichhardtii</spn>).</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Barranca</ent><br/
\'d8<hw>Bar*ran"ca</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[Sp.]</ety>
<def>A ravine caused by heavy rains or a watercourse.</def> <mark>[Texas
& N. Mex.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barras</ent><br/
\'d8<hw>Bar"ras</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[F.]</ety>
<def>A resin, called also <altname>galipot</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barrator</ent><br/
<hw>Bar"ra*tor</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[OE.
<ets>baratour</ets>, OF. <ets>barateor</ets> deceiver, fr. OF.
<ets>barater</ets>, <ets>bareter</ets>, to deceive, cheat, barter. See
<er>Barter</er>, <pos>v. i.</pos>]</ety> <def>One guilty of
barratry.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barratrous</ent><br/
<hw>Bar"ra*trous</hw> <pr>(<?/)</pr>, <pos>a.</pos> <fld>(Law)</fld>
<def>Tainted with, or constituting, barratry.</def> --
<wordforms><wf>Bar"ra*trous*ly</wf>, <pos>adv.</pos></wordforms>
<rj><au>Kent.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barratry</ent><br/
<hw>Bar"ra*try</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[Cf. F.
<ets>baraterie</ets>, LL. <ets>barataria</ets>. See <er>Barrator</er>,
and cf. <er>Bartery</er>.]</ety> <sn>1.</sn> <fld>(Law)</fld> <def>The
practice of exciting and encouraging lawsuits and quarrels.</def>
<altsp>[Also spelt <asp>barretry</asp>.]</altsp> <rj><au>Coke.
Blackstone.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Mar. Law)</fld> <def>A fraudulent breach of duty or
willful act of known illegality on the part of a master of a ship, in
his character of master, or of the mariners, to the injury of the owner
of the ship or cargo, and without his consent. It includes every breach
of trust committed with dishonest purpose, as by running away with the
ship, sinking or deserting her, etc., or by embezzling the cargo.</def>
<rj><au>Kent.</au> <au>Park.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Scots Law)</fld> <def>The crime of a judge who is
influenced by bribery in pronouncing judgment.</def>
<rj><au>Wharton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barred owl</ent><br/
<hw>Barred" owl"</hw> <pr>(<?/)</pr>. <fld>(Zool.)</fld> <def>A large
American owl (<spn>Syrnium nebulosum</spn>); -- so called from the
transverse bars of a dark brown color on the breast.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barrel</ent><br/
<hw>Bar"rel</hw> <pr>(b<acr/r"r<ecr/l)</pr>, <pos>n.</pos><ety>[OE.
<ets>barel</ets>, F. <ets>baril</ets>, prob. fr. <ets>barre</ets> bar.
Cf. <er>Barricade</er>.]</ety> <sn>1.</sn> <def>A round vessel or cask,
of greater length than breadth, and bulging in the middle, made of
staves bound with hoops, and having flat ends or heads; <as>as, a
cracker <ex>barrel</ex></as>. Sometimes applied to a similar cylindrical
container made of metal, usually called a <contr>drum</contr>.</def><br/
[<source>1913 Webster</source> <source>+PJC</source>]</p>

<p><sn>2.</sn> <def>The quantity which constitutes a full barrel. This
varies for different articles and also in different places for the same
article, being regulated by custom or by law. A barrel of wine is
31<frac12/ gallons; a barrel of flour is 196 pounds.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>A solid drum, or a hollow cylinder or case; <as>as,
the <ex>barrel</ex> of a windlass; the <ex>barrel</ex> of a watch,
within which the spring is coiled</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 121 pr=SA --></p>

<p><sn>4.</sn> <def>A metallic tube, as of a gun, from which a
projectile is discharged.</def> <rj><au>Knight.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>A jar.</def> <mark>[Obs.]</mark> <rj><au>1 Kings
xvii. 12.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <fld>(Zool.)</fld> <def>The hollow basal part of a
feather.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Barrel bulk</b></col> <fld>(Com.)</fld>, <cd>a measure
equal to five cubic feet, used in estimating capacity, as of a vessel
for freight.</cd> -- <col><b>Barrel drain</b></col> <fld>(Arch.)</fld>,
<cd>a drain in the form of a cylindrical tube.</cd> -- <col><b>Barrel of
a boiler</b></col>, <cd>the cylindrical part of a boiler, containing the
flues.</cd> -- <col><b>Barrel of the ear</b></col> <fld>(Anat.)</fld>,
<cd>the tympanum, or tympanic cavity.</cd> -- <col><b>Barrel
organ</b></col>, <cd>an instrument for producing music by the action of
a revolving cylinder.</cd> -- <col><b>Barrel vault</b></col>. <cd>See
under <er>Vault</er>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barrel</ent><br/
<hw>Bar"rel</hw> <pr>(b<acr/r"r<ecr/l)</pr>, <pos>v. t.</pos>
<vmorph>[<pos>imp. & p. p.</pos> <conjf>Barreled</conjf>
<pr>(-r<ecr/ld)</pr>, or <conjf>Barrelled</conjf>; <pos>p. pr. & vb.
n.</pos> <conjf>Barreling</conjf>, or
<conjf>Barrelling</conjf>.]</vmorph> <def>To put or to pack in a barrel
or barrels.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>barrel cactus</ent><br/
<hw>bar"rel cac"tus</hw> <pr>(b<acr/r"r<ecr/l k<acr/k"t<ucr/s)</pr>,
<pos>n.</pos>; <plu>pl. <plw>barrel cacti</plw> <pr>(b<acr/r"r<ecr/l
k<acr/k"t<imac/)</pr></plu>. <def>any of several large cacti native to
the southwestern U. S. and Mexico, having a short cylindrical form with
deep vertical ribs and bearing sharp spines. They are classed in the
genera <gen>Ferocactus</gen> and <gen>Echinocactus</gen>.</def><br/
[<source>PJC</source>]</p>

<p><ent>Barrelled</ent><br/
<ent>Barreled</ent><br/
<mhw>{ <hw>Bar"reled</hw>, <hw>Bar"relled</hw> }</mhw> <pr>(<?/)</pr>,
<pos>a.</pos> <sn>1.</sn> <def>Having a barrel; -- used in composition;
<as>as, a double-<ex>barreled</ex> gun</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>put in or stored in a barrel; ; <as>as,
<ex>barreled</ex> beer</as>; -- opposite of
<ant>unbarreled</ant>.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><sn>3.</sn> <def>tapered toward both ends; -- of an arrow.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>barrelfish</ent><br/
<hw>barrelfish</hw> <pos>n.</pos> <def>A blackish fish (<spn>Hyperglyphe
perciformis</spn>) of New England waters.</def><br/
<syn><b>Syn. --</b> black rudderfish.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>barrelful</ent><br/
<hw>barrelful</hw> <pos>n.</pos> <def>The quantity that a barrel (of any
size) will hold.</def><br/
<syn><b>Syn. --</b> barrel.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>barrelhouse</ent><br/
<hw>barrelhouse</hw> <pos>n.</pos> <def>A cheap drinking and dancing
establishment.</def><br/
<syn><b>Syn. --</b> honky-tonk.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Barrel process</ent><br/
<hw>Bar"rel proc"ess</hw>. <fld>(Metal.)</fld> <def>A process of
extracting gold or silver by treating the ore in a revolving barrel, or
drum, with mercury, chlorine, cyanide solution, or other
reagent.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Barren</ent><br/
<hw>Bar"ren</hw> <pr>(b<acr/r"r<eit/n)</pr>, <pos>a.</pos> <ety>[OE.
<ets>barein</ets>, OF. <ets>brehaing</ets>, fem. <ets>brehaigne</ets>,
<ets>baraigne</ets>, F. <ets>br<eacute/haigne</ets>; of uncertain
origin; cf. Arm. <ets>br<eacute/kha<ntil/</ets>,
<ets>markha<ntil/</ets>, sterile; LL. <ets>brana</ets> a sterile mare,
principally in Aquitanian and Spanish documents; Bisc. <ets>barau</ets>,
<ets>baru</ets>, fasting.]</ety> <sn>1.</sn> <def>Incapable of producing
offspring; producing no young; sterile; -- said of women and female
animals.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>She was <qex>barren</qex> of children.</q> <rj><qau>Bp.
Hall.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Not producing vegetation, or useful vegetation;
sterile.</def> <ldquo/<xex>Barren</xex> mountain tracts.<rdquo/
<rj><au>Macaulay.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Unproductive; fruitless; unprofitable;
empty.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Brilliant but <qex>barren</qex> reveries.</q>
<rj><qau>Prescott.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Some schemes will appear <qex>barren</qex> of hints and
matter.</q> <rj><qau>Swift.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>Mentally dull; stupid.</def>
<rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Barren flower</b></col>, <cd>a flower which has only
stamens without a pistil, or which has neither stamens nor pistils.</cd>
-- <col><b>Barren Grounds</b></col> <fld>(Geog.)</fld>, <cd>a vast tract
in British America northward of the forest regions.</cd> --
<col><b>Barren Ground bear</b></col> <fld>(Zool.)</fld>, <cd>a peculiar
bear, inhabiting the Barren Grounds, now believed to be a variety of the
brown bear of Europe.</cd> -- <col><b>Barren Ground caribou</b></col>
<fld>(Zool.)</fld>, <cd>a small reindeer (<spn>Rangifer
Gr<oe/nlandicus</spn>) peculiar to the Barren Grounds and
Greenland.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barren</ent><br/
<hw>Bar"ren</hw>, <pos>n.</pos> <sn>1.</sn> <def>A tract of barren
land.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <pluf>pl.</pluf> <def>Elevated lands or plains on which
grow small trees, but not timber; <as>as, pine <ex>barrens</ex>; oak
<ex>barrens</ex></as>. They are not necessarily sterile, and are often
fertile.</def> <mark>[Amer.]</mark> <rj><au>J. Pickering.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barrenly</ent><br/
<hw>Bar"ren*ly</hw>, <pos>adv.</pos> <def>Unfruitfully;
unproductively.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barrenness</ent><br/
<hw>Bar"ren*ness</hw>, <pos>n.</pos> <def>The condition of being barren;
sterility; unproductiveness.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>A total <qex>barrenness</qex> of invention.</q>
<rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barrenwort</ent><br/
<hw>Bar"ren*wort`</hw> <pr>(<?/)</pr>, <pos>n.</pos> <fld>(Bot.)</fld>
<def>An herbaceous plant of the Barberry family (<spn>Epimedium
alpinum</spn>), having leaves that are bitter and said to be
sudorific.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barret</ent><br/
<hw>Bar"ret</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[F.
<ets>barrette</ets>, LL. <ets>barretum</ets> a cap. See
<er>Berretta</er>, and cf. <er>Biretta</er>.]</ety> <def>A kind of cap
formerly worn by soldiers; -- called also <altname>barret cap</altname>.
Also, the flat cap worn by Roman Catholic ecclesiastics.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>barretter</ent><br/
<hw>bar"ret*ter</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[OF.
<ets>bareter</ets> to exchange. Cf. <er>Barter</er>.]</ety> <sn>1.</sn>
<fld>(Electronics)</fld> <def>a resistor inserted into a circuit to
compensate for changes (such as those arising from temperature
fluctuations); a thermal cymoscope.</def> <syn><b>Syn. --</b> ballast
resistor.</syn><br/
[<source>Webster 1913 Suppl.</source> + <source>WordNet 1.5</source>]</p>

<p><note><hand/ The original form consisted of an extremely fine
platinum wire loop attached to terminals and inclosed in a small glass
or silver bulb. It operates by increased resistance when subjected to
the influence of an electric current. In a later variety, called the
<col><b>liquid barretter</b></col>, wire is replace by a column of
liquid in a very fine capillary tube. A recent version has a resistor
composed of an iron wire in a glass bulb containing hydrogen, with the
temperature variation of resistance such that the current passing
through it remains constant over a wide range of applied
voltages.</note><br/
[<source>Webster 1913 Suppl.</source> + <source>PJC</source>]</p>

<p><ent>Barricade</ent><br/
<hw>Bar`ri*cade"</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[F.
<ets>barricade</ets>, fr. Sp. <ets>barricada</ets>, orig. a barring up
with casks; fr. <ets>barrica</ets> cask, perh. fr. LL. <ets>barra</ets>
bar. See <er>Bar</er>, <pos>n.</pos>, and cf. <er>Barrel</er>,
<pos>n.</pos>]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <fld>(Mil.)</fld> <def>A fortification, made in haste, of
trees, earth, palisades, wagons, or anything that will obstruct the
progress or attack of an enemy. It is usually an obstruction formed in
streets to block an enemy's access.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Any bar, obstruction, or means of defense.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Such a <qex>barricade</qex> as would greatly annoy, or absolutely
stop, the currents of the atmosphere.</q>
<rj><qau>Derham.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barricade</ent><br/
<hw>Bar`ri*cade"</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos>
<conjf>Barricaded</conjf>; <pos>p. pr. & vb. n.</pos>
<conjf>Barricading</conjf>.]</vmorph> <ety>[Cf. F.
<ets>barricader</ets>. See <er>Barricade</er>, <pos>n.</pos>]</ety>
<def>To fortify or close with a barricade or with barricades; to stop
up, as a passage; to obstruct; <as>as, the workmen <ex>barricaded</ex>
the streets of Paris</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The further end whereof [a bridge] was <qex>barricaded</qex> with
barrels.</q> <rj><qau>Hakluyt.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barricader</ent><br/
<hw>Bar`ri*cad"er</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>One who
constructs barricades.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barricado</ent><br/
<hw>Bar`ri*ca"do</hw> <pr>(<?/)</pr>, <pos>n. & v. t.</pos> <def>See
<er>Barricade</er>.</def> <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barrier</ent><br/
<hw>Bar"ri*er</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[OE.
<ets>barrere</ets>, <ets>barere</ets>, F. <ets>barri<egrave/re</ets>,
fr. <ets>barre</ets> bar. See <er>Bar</er>, <pos>n.</pos>]</ety>
<sn>1.</sn> <fld>(Fort.)</fld> <def>A carpentry obstruction, stockade,
or other obstacle made in a passage in order to stop an enemy.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A fortress or fortified town, on the frontier of a
country, commanding an avenue of approach.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <pluf>pl.</pluf> <def>A fence or railing to mark the
limits of a place, or to keep back a crowd.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>No sooner were the <qex>barriers</qex> opened, than he paced into
the lists.</q> <rj><qau>Sir W. Scott.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>Any obstruction; anything which hinders approach or
attack.</def> <ldquo/Constitutional <xex>barriers</xex>.<rdquo/
<rj><au>Hopkinson.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>Any limit or boundary; a line of
separation.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>'Twixt that [instinct] and reason, what a nice
<qex>barrier</qex>!</q> <rj><qau>Pope.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Barrier gate</b></col>, <cd>a heavy gate to close the
opening through a barrier.</cd> -- <col><b>Barrier reef</b></col>, <cd>a
form of coral reef which runs in the general direction of the shore, and
incloses a lagoon channel more or less extensive.</cd> -- <col><b>To
fight at barriers</b></col>, <cd>to fight with a barrier between, as a
martial exercise.</cd> <mark>[Obs.]</mark></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barrigudo</ent><br/
\'d8<hw>Bar`ri*gu"do</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[Native
name, fr. Sp. <ets>barrigudo</ets> big-bellied.]</ety>
<fld>(Zool.)</fld> <def>A large, dark-colored, South American monkey, of
the genus <gen>Lagothrix</gen>, having a long prehensile tail.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>barring</ent><br/
<hw>bar"ring</hw> <pos>n.</pos> <def>the act of excluding someone by a
negative vote or veto.</def><br/
<syn><b>Syn. --</b> blackball.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Barringout</ent><br/
<hw>Bar`ring*out"</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>The act of
closing the doors of a schoolroom against a schoolmaster; -- a boyish
mode of rebellion in schools.</def> <rj><au>Swift.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barrio</ent><br/
\'d8<hw>Bar"ri*o</hw> <pr>(?)</pr>, <pos>n.</pos>; <plu>pl.
<plw>Barrios</plw> <pr>(#)</pr></plu>. <ety>[Sp.]</ety> <def>In Spain
and countries colonized by Spain, a village, ward, or district outside a
town or city to whose jurisdiction it belongs; in Spanish-speaking areas
of cities in the United States, it is a neighborhood, ward, or quarter
inside a town.</def><br/
[<source>Webster 1913 Suppl.</source> <source>+PJC</source>]</p>

<p><ent>Barrister</ent><br/
<hw>Bar"ris*ter</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[From
<er>Bar</er>, <pos>n.</pos>]</ety> <def>Counselor at law; a counsel
admitted to plead at the bar, and undertake the public trial of causes,
as distinguished from an attorney or solicitor. See
<er>Attorney</er>.</def> <mark>[Eng.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barroom</ent><br/
<hw>Bar"room`</hw> <pr>(<?/)</pr>, <pos>n.</pos> <sn>1.</sn> <def>A room
containing a bar or counter at which liquors are sold.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>a commercial establishment where alcoholic drinks
are served over a counter.</def> <syn><b>Syn. --</b> bar-room, bar,
saloon, ginmill, taproom.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Barrow</ent><br/
<hw>Bar"row</hw> <pr>(b<acr/r"r<osl/)</pr>, <pos>n.</pos> <ety>[OE.
<ets>barow</ets>, fr. AS. <ets>beran</ets> to bear. See <er>Bear</er> to
support, and cf. <er>Bier</er>.]</ety> <sn>1.</sn> <def>A support having
handles, and with or without a wheel, on which heavy or bulky things can
be transported by hand. See <er>Handbarrow</er>, and
<er>Wheelbarrow</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Salt Works)</fld> <def>A wicker case, in which salt
is put to drain.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barrow</ent><br/
<hw>Bar"row</hw> <pr>(b<acr/r"r<osl/)</pr>, <pos>n.</pos> <ety>[OE.
<ets>barow</ets>, <ets>bargh</ets>, AS. <ets>bearg</ets>,
<ets>bearh</ets>; akin to Icel. <ets>b<oum/rgr</ets>, OHG.
<ets>barh</ets>, <ets>barug</ets>, G. <ets>barch</ets>. <root/95.]</ety>
<def>A hog, esp. a male hog castrated.</def>
<rj><au>Holland.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barrow</ent><br/
<hw>Bar"row</hw>, <pos>n.</pos> <ety>[OE. <ets>bergh</ets>, AS.
<ets>beorg</ets>, <ets>beorh</ets>, hill, sepulchral mound; akin to G.
<ets>berg</ets> mountain, Goth. <ets>bairgahei</ets> hill, hilly
country, and perh. to Skr. <ets>b<rsdot/hant</ets> high, OIr.
<ets>brigh</ets> mountain. Cf. <er>Berg</er>, <er>Berry</er> a mound,
and <er>Borough</er> an incorporated town.]</ety> <sn>1.</sn> <def>A
large mound of earth or stones over the remains of the dead; a
tumulus.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Mining)</fld> <def>A heap of rubbish, attle,
etc.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barrowist</ent><br/
<hw>Bar"row*ist</hw>, <pos>n.</pos> <fld>(Eccl. Hist.)</fld> <def>A
follower of <person>Henry <etsep>Barrowe</etsep></person>, one of the
founders of Independency or Congregationalism in England. Barrowe was
executed for nonconformity in 1593.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barrulet</ent><br/
<hw>Bar"ru*let</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[Dim. of
<ets>bar</ets>, n.]</ety> <fld>(Her.)</fld> <def>A diminutive of the
bar, having one fourth its width.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barruly</ent><br/
<hw>Bar"ru*ly</hw> <pr>(<?/)</pr>, <pos>a.</pos> <fld>(Her.)</fld>
<def>Traversed by barrulets or small bars; -- said of the
field.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barry</ent><br/
<hw>Bar"ry</hw> <pr>(<?/)</pr>, <pos>a.</pos> <fld>(Her.)</fld>
<def>Divided into bars; -- said of the field.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barse</ent><br/
<hw>Barse</hw> <pr>(b<aum/rs)</pr>, <pos>n.</pos> <ety>[AS.
<ets>bears</ets>, <ets>b<ae/rs</ets>, akin to D. <ets>baars</ets>, G.
<ets>bars</ets>, <ets>barsch</ets>. Cf. 1st <er>Bass</er>,
<pos>n.</pos>]</ety> <def>The common perch. See 1st <er>Bass</er>.</def>
<mark>[Prov. Eng.]</mark> <rj><au>Halliwell.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bart.</ent><br/
<hw>Bart.</hw> <pos>n.</pos> <def>an abbreviation of
<er>baronet</er>.</def> <mark>[Abbrev.]</mark> <ldquo/Since he was a
baronet he had to be addressed as <person>Sir Henry Jones,
Bart.</person><ldquo/<br/
<syn><b>Syn. --</b> baronet.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Bartender</ent><br/
<hw>Bar"tend`er</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>A
barkeeper.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barter</ent><br/
<hw>Bar"ter</hw> <pr>(b<aum/r"t<etil/r)</pr>, <pos>v. i.</pos>
<vmorph>[<pos>imp. & p. p.</pos> <conjf>Bartered</conjf>
(b<aum/r"t<etil/rd); <pos>p. pr. & vb. n.</pos>
<conjf>Bartering</conjf>.]</vmorph> <ety>[OE. <ets>bartren</ets>, OF.
<ets>barater</ets>, <ets>bareter</ets>, to cheat, exchange, perh. fr.
Gr. <grk>pra`ttein</grk> to do, deal (well or ill), use practices or
tricks, or perh. fr. Celtic; cf. Ir. <ets>brath</ets> treachery, W.
<ets>brad</ets>. Cf. <er>Barrator</er>.]</ety> <def>To traffic or trade,
by exchanging one commodity for another, in distinction from a
<xex>sale</xex> and <xex>purchase</xex>, in which money is paid for the
commodities transferred; to truck.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barter</ent><br/
<hw>Bar"ter</hw>, <pos>v. t.</pos> <def>To trade or exchange in the way
of barter; to exchange (frequently for an unworthy consideration); to
traffic; to truck; -- sometimes followed by <xex>away</xex>; <as>as, to
<ex>barter</ex> away goods or honor</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barter</ent><br/
<hw>Bar"ter</hw>, <pos>n.</pos> <sn>1.</sn> <def>The act or practice of
trafficking by exchange of commodities; an exchange of goods.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The spirit of huckstering and <qex>barter</qex>.</q>
<rj><qau>Burke.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The thing given in exchange.</def><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- Exchange; dealing; traffic; trade;
truck.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barterer</ent><br/
<hw>Bar"ter*er</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>One who
barters.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bartery</ent><br/
<hw>Bar"ter*y</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>Barter.</def>
<mark>[Obs.]</mark> <rj><au>Camden.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barth</ent><br/
<hw>Barth</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[Etymol.
unknown.]</ety> <def>A place of shelter for cattle.</def> <mark>[Prov.
Eng.]</mark> <rj><au>Halliwell.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bartholomew tide</ent><br/
<hw>Bar*thol"o*mew tide`</hw> <pr>(<?/)</pr>. <def>Time of the festival
of <person>St. Bartholomew</person>, August 24th.</def>
<rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bartizan</ent><br/
<hw>Bar"ti*zan`</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[Cf.
<er>Brettice</er>.]</ety> <fld>(Arch.)</fld> <def>A small, overhanging
structure for lookout or defense, usually projecting at an angle of a
building or near an entrance gateway.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bartlett</ent><br/
<hw>Bart"lett</hw> <pr>(<?/)</pr>, <pos>n.</pos> <fld>(Bot.)</fld>
<def>A Bartlett pear, a favorite kind of pear, which originated in
England about 1770, and was called <altname>Williams'
Bonchr<eacute/tien</altname>. It was brought to America, and distributed
by <person>Mr. Enoch Bartlett</person>, of Dorchester,
Massachusetts.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barton</ent><br/
<hw>Bar"ton</hw> <pr>(b<aum/r"t<ucr/n)</pr>, <pos>n.</pos> <ety>[AS.
<ets>beret<umac/n</ets> courtyard, grange; <ets>bere</ets> barley +
<ets>t<umac/n</ets> an inclosure.]</ety> <sn>1.</sn> <def>The demesne
lands of a manor; also, the manor itself.</def> <mark>[Eng.]</mark>
<rj><au>Burton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A farmyard.</def> <mark>[Eng.]</mark>
<rj><au>Southey.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bartram</ent><br/
<hw>Bar"tram</hw> <pr>(<?/)</pr>, <pos>n.</pos> <fld>(Bot.)</fld>
<def>See <er>Bertram</er>.</def> <rj><au>Johnson.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barway</ent><br/
<hw>Bar"way`</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>A passage into a
field or yard, closed by bars made to take out of the posts.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barwise</ent><br/
<hw>Bar"wise`</hw> <pr>(<?/)</pr>, <pos>adv.</pos> <fld>(Her.)</fld>
<def>Horizontally.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barwood</ent><br/
<hw>Bar"wood`</hw> <pr>(b<aum/r"w<oocr/d`)</pr>, <pos>n.</pos> <def>A
red wood of a leguminous tree (<spn>Baphia nitida</spn>), from Angola
and the Gabon in Africa. It is used as a dyewood, and also for ramrods,
violin bows and turner's work.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>barycenter</ent><br/
<hw>barycenter</hw> <pos>n.</pos> <def>the point representing the mean
position of the matter in a body.</def><br/
<syn><b>Syn. --</b> centroid, center of mass.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Barycentric</ent><br/
<hw>Bar`y*cen"tric</hw> <pr>(<?/)</pr>, <pos>a.</pos> <ety>[Gr.
<grk>bary`s</grk> heavy + <grk>ke`ntron</grk> center.]</ety> <def>Of or
pertaining to the center of gravity. See <cref>Barycentric
calculus</cref>, under <er>Calculus</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>baryon</ent><br/
<hw>baryon</hw> <pos>n.</pos> <sn>1.</sn> <def>any of the elementary
particles having a mass equal to or greater than that of a proton and
that participate in strong interactions; a hadron with a baryon number
of +1.</def><br/
<syn><b>Syn. --</b> heavy particle.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Baryphony</ent><br/
<hw>Ba*ryph"o*ny</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[Gr.
<grk>bary`s</grk> heavy + <grk>fwnh`</grk> a sound, voice.]</ety>
<fld>(Med.)</fld> <def>Difficulty of speech.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barysphere</ent><br/
<hw>Bar"y*sphere</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Gr.
<grk>bary`s</grk> heavy + <ets>sphere</ets>.]</ety> <fld>(Geol.)</fld>
<def>The heavy interior portion of the earth, within the
lithosphere.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Baryta</ent><br/
<hw>Ba*ry"ta</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[Gr.
<grk>bary`s</grk> heavy. Cf. <er>Baria</er>.]</ety> <fld>(Chem.)</fld>
<def>An oxide of barium (or barytum); a heavy earth with a specific
gravity above 4.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barytes</ent><br/
<hw>Ba*ry"tes</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[Gr.
<grk>bary`s</grk> heavy: cf. Gr. <grk>bary`ths</grk> heaviness, F.
<ets>baryte</ets>.]</ety> <fld>(Min.)</fld> <def>Barium sulphate,
generally called <altname>heavy spar</altname> or
<altname>barite</altname>. See <er>Barite</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barytic</ent><br/
<hw>Ba*ryt"ic</hw> <pr>(<?/)</pr>, <pos>a.</pos> <def>Of or pertaining
to baryta.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baryto-calcite</ent><br/
<hw>Ba*ry"to-cal"cite</hw> <pr>(<?/)</pr>, <pos>n.</pos>
<ety>[<ets>Baryta</ets> + <ets>calcite</ets>.]</ety> <fld>(Min.)</fld>
<def>A mineral of a white or gray color, occurring massive or
crystallized. It is a compound of the carbonates of barium and
calcium.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baritone</ent><br/
<ent>Barytone</ent><br/
<mhw>{ <hw>Bar"y*tone</hw>, <hw>Bar"i*tone</hw> }</mhw> <pr>(<?/)</pr>,
<pos>a.</pos> <ety>[Gr. <grk>bary`tonos</grk>; <grk>bary`s</grk> heavy +
<grk>to`nos</grk> tone.]</ety> <sn>1.</sn> <fld>(Mus.)</fld> <def>Grave
and deep, as a kind of male voice.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Greek Gram.)</fld> <def>Not marked with an accent
on the last syllable, the grave accent being understood.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baritone</ent><br/
<ent>Barytone</ent><br/
<mhw>{ <hw>Bar"y*tone</hw>, <hw>Bar"i*tone</hw> }</mhw>, <pos>n.</pos>
<ety>[F. <ets>baryton</ets>: cf. It. <ets>baritono</ets>.]</ety>
<sn>1.</sn> <fld>(Mus.)</fld> <sd>(a)</sd> <def>A male voice, the
compass of which partakes of the common bass and the tenor, but which
does not descend as low as the one, nor rise as high as the other.</def>
<sd>(b)</sd> <def>A person having a voice of such range.</def>
<sd>(c)</sd> <def>The viola di gamba, now entirely disused.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Greek Gram.)</fld> <def>A word which has no accent
marked on the last syllable, the grave accent being
understood.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Barytum</ent><br/
<hw>Ba*ry"tum</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[NL.]</ety>
<fld>(Chem.)</fld> <def>The metal barium. See <er>Barium</er>.</def>
<mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Basal</ent><br/
<hw>Ba"sal</hw> <pr>(<?/)</pr>, <pos>a.</pos> <def>Relating to, or
forming, the base.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Basal cleavage</b></col>. <cd>See under
<er>Cleavage</er>.</cd> -- <col><b>Basal plane</b></col>
<fld>(Crystallog.)</fld>, <cd>a plane parallel to the lateral or
horizontal axis.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Basal-nerved</ent><br/
<hw>Ba"sal-nerved`</hw> <pr>(<?/)</pr>, <pos>a.</pos> <fld>(Bot.)</fld>
<def>Having the nerves radiating from the base; -- said of
leaves.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Basalt</ent><br/
<hw>Ba*salt"</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[L.
<ets>basaltes</ets> (an African word), a dark and hard species of marble
found in Ethiopia: cf. F. <ets>basalte</ets>.]</ety> <sn>1.</sn>
<fld>(Geol.)</fld> <def>A rock of igneous origin, consisting of augite
and triclinic feldspar, with grains of magnetic or titanic iron, and
also bottle-green particles of olivine frequently
disseminated.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ It is usually of a greenish black color, or of some dull
brown shade, or black. It constitutes immense beds in some regions, and
also occurs in veins or dikes cutting through other rocks. It has often
a prismatic structure as at the Giant's Causeway, in Ireland, where the
columns are as regular as if the work of art. It is a very tough and
heavy rock, and is one of the best materials for macadamizing
roads.</note><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>An imitation, in pottery, of natural basalt; a kind
of black porcelain.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Basaltic</ent><br/
<hw>Ba*salt"ic</hw> <pr>(<?/)</pr>, <pos>a.</pos> <ety>[Cf. F.
<ets>basaltique</ets>.]</ety> <def>Pertaining to basalt; formed of, or
containing, basalt; as <xex>basaltic</xex> lava.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Basaltiform</ent><br/
<hw>Ba*salt"i*form</hw> <pr>(<?/)</pr>, <pos>a.</pos>
<ety>[<ets>Basalt</ets> + <ets>-form</ets>.]</ety> <def>In the form of
basalt; columnar.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Basaltoid</ent><br/
<hw>Ba*salt"oid</hw> <pr>(<?/)</pr>, <pos>a.</pos>
<ety>[<ets>Basalt</ets> + <ets>-oid</ets>.]</ety> <def>Formed like
basalt; basaltiform.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Basan</ent><br/
<hw>Bas"an</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>Same as
<er>Basil</er>, a sheepskin.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Basanite</ent><br/
<hw>Bas"a*nite</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[L.
<ets>basanites</ets> lapis, Gr. <grk>ba`sanos</grk> the touchstone: cf.
F. <ets>basanite</ets>.]</ety> <fld>(Min.)</fld> <def>Lydian stone, or
black jasper, a variety of siliceous or flinty slate, of a grayish or
bluish black color. It is employed to test the purity of gold, the
amount of alloy being indicated by the color left on the stone when
rubbed by the metal.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Basbleu</ent><br/
\'d8<hw>Bas`bleu"</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[F., fr.
<ets>bas</ets> stocking + <ets>bleu</ets> blue.]</ety> <def>A
bluestocking; a literary woman.</def> <mark>[Somewhat
derisive]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bascinet</ent><br/
<hw>Bas"ci*net</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[OE.
<ets>bacinet</ets>, <ets>basnet</ets>, OF. <ets>bassinet</ets>,
<ets>bacinet</ets>, F. <ets>bassinet</ets>, dim. of OF.
<ets>bacin</ets>, F. <ets>bassin</ets>, a helmet in the form of a
basin.]</ety> <def>A light helmet, at first open, but later made with a
visor.</def> <altsp>[Written also <asp>basinet</asp>,
<asp>bassinet</asp>, <asp>basnet</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bascule</ent><br/
<hw>Bas"cule</hw> <pr>(b<acr/s"k<usl/l)</pr>, <pos>n.</pos> <ety>[F., a
seesaw.]</ety> <def>In mechanics, an apparatus on the principle of the
seesaw, in which one end rises as the other falls.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Bascule bridge</b></col>, <cd>a counterpoise or balanced
drawbridge, which is opened by sinking the counterpoise and thus lifting
the footway into the air.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Base</ent><br/
<hw>Base</hw> <pr>(b<amac/s)</pr>, <pos>a.</pos> <ety>[OE.
<ets>bass</ets>, F. <ets>bas</ets>, low, fr. LL. <ets>bassus</ets>
thick, fat, short, humble; cf. L. <ets>Bassus</ets>, a proper name, and
W. <ets>bas</ets> shallow. Cf. <er>Bass</er> a part in music.]</ety>
<sn>1.</sn> <def>Of little, or less than the usual, height; of low
growth; <as>as, <ex>base</ex> shrubs</as>.</def> <mark>[Archaic]</mark>
<rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Low in place or position.</def> <mark>[Obs.]</mark>
<rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Of humble birth; or low degree; lowly; mean.</def>
<mark>[Archaic]</mark> <ldquo/A peasant and <xex>base</xex>
swain.<rdquo/ <rj><au>Bacon.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>Illegitimate by birth; bastard.</def>
<mark>[Archaic]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>Why bastard? wherefore <qex>base</qex>?</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>Of little comparative value, as metal inferior to
gold and silver, the precious metals.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <def>Alloyed with inferior metal; debased; <as>as,
<ex>base</ex> coin; <ex>base</ex> bullion</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>7.</sn> <def>Morally low. Hence: Low-minded; unworthy; without
dignity of sentiment; ignoble; mean; illiberal; menial; <as>as, a
<ex>base</ex> fellow; <ex>base</ex> motives; <ex>base</ex>
occupations</as>.</def> <ldquo/A cruel act of a <xex>base</xex> and a
cowardish mind.<rdquo/ <au>Robynson (More's Utopia).</au>
<ldquo/<xex>Base</xex> ingratitude.<rdquo/ <rj><au>Milton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>8.</sn> <def>Not classical or correct.</def>
<ldquo/<xex>Base</xex> Latin.<rdquo/ <rj><au>Fuller.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>9.</sn> <def>Deep or grave in sound; <as>as, the <ex>base</ex>
tone of a violin</as>.</def> <altsp>[In this sense, commonly written
<asp>bass.</asp>]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><sn>10.</sn> <fld>(Law)</fld> <def>Not held by honorable service;
<as>as, a <ex>base</ex> estate, one held by services not honorable; held
by villenage. Such a tenure is called <ex>base</ex>, or low, and the
tenant, a <ex>base</ex> tenant</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Base fee</b></col>, <cd>formerly, an estate held at the
will of the lord; now, a qualified fee. See note under <er>Fee</er>,
<pos>n.</pos>, 4.</cd> -- <col><b>Base metal</b></col>. <cd>See under
<er>Metal</er>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- Dishonorable; worthless; ignoble; low-minded;
infamous; sordid; degraded.</syn> <usage> -- <er>Base</er>,
<er>Vile</er>, <er>Mean</er>. These words, as expressing moral
qualities, are here arranged in the order of their strength, the
strongest being placed first. <xex>Base</xex> marks a high degree of
moral turpitude; <xex>vile</xex> and <xex>mean</xex> denote, in
different degrees, the lack of what is valuable or worthy of esteem.
What is <xex>base</xex> excites our abhorrence; what is <xex>vile</xex>
provokes our disgust or indignation; what is <xex>mean</xex> awakens
contempt. <xex>Base</xex> is opposed to high-minded; <xex>vile</xex>, to
noble; <xex>mean</xex>, to liberal or generous. Ingratitude is
<xex>base</xex>; sycophancy is <xex>vile</xex>; undue compliances are
<xex>mean</xex>.</usage><br/
[<source>1913 Webster</source>]</p>

<p><ent>Base</ent><br/
<hw>Base</hw>, <pos>n.</pos> <ety>[F. <ets>base</ets>, L.
<ets>basis</ets>, fr. Gr. <grk>ba`sis</grk> a stepping, step, a base,
pedestal, fr. <grk>bai`nein</grk> to go, step, akin to E.
<ets>come</ets>. Cf. <er>Basis</er>, and see <er>Come</er>.]</ety>
<sn>1.</sn> <def>The bottom of anything, considered as its support, or
that on which something rests for support; the foundation; <as>as, the
<ex>base</ex> of a statue</as>.</def> <ldquo/The <xex>base</xex> of
mighty mountains.<rdquo/ <rj><au>Prescott.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Fig.: The fundamental or essential part of a thing;
the essential principle; a groundwork.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Arch.)</fld> <sd>(a)</sd> <def>The lower part of a
wall, pier, or column, when treated as a separate feature, usually in
projection, or especially ornamented.</def> <sd>(b)</sd> <def>The lower
part of a complete architectural design, as of a monument; also, the
lower part of any elaborate piece of furniture or decoration.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <fld>(Bot.)</fld> <def>That extremity of a leaf, fruit,
etc., at which it is attached to its support.</def><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 122 pr=SA --></p>

<p><sn>5.</sn> <fld>(Chem.)</fld> <def>The positive, or non-acid
component of a salt; a substance which, combined with an acid,
neutralizes the latter and forms a salt; -- applied also to the
hydroxides of the positive elements or radicals, and to certain organic
bodies resembling them in their property of forming salts with
acids.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <fld>(Pharmacy)</fld> <def>The chief ingredient in a
compound.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>7.</sn> <fld>(Dyeing)</fld> <def>A substance used as a
mordant.</def> <rj><au>Ure.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>8.</sn> <fld>(Fort.)</fld> <def>The exterior side of the polygon,
or that imaginary line which connects the salient angles of two adjacent
bastions.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>9.</sn> <fld>(Geom.)</fld> <def>The line or surface constituting
that part of a figure on which it is supposed to stand.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>10.</sn> <fld>(Math.)</fld> <def>The number from which a
mathematical table is constructed; <as>as, the <ex>base</ex> of a system
of logarithms</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>11.</sn> <ety>[See <er>Base</er> low.]</ety> <def>A low, or deep,
sound. <fld>(Mus.)</fld> <sd>(a)</sd> The lowest part; the deepest male
voice. <sd>(b)</sd> One who sings, or the instrument which plays,
base.</def> <altsp>[Now commonly written <asp>bass</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><q>The trebles squeak for fear, the <qex>bases</qex> roar.</q>
<rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>12.</sn> <fld>(Mil.)</fld> <def>A place or tract of country,
protected by fortifications, or by natural advantages, from which the
operations of an army proceed, forward movements are made, supplies are
furnished, etc.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>13.</sn> <fld>(Mil.)</fld> <def>The smallest kind of
cannon.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><sn>14.</sn> <fld>(Zool.)</fld> <def>That part of an organ by which
it is attached to another more central organ.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>15.</sn> <fld>(Crystallog.)</fld> <def>The basal plane of a
crystal.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>16.</sn> <fld>(Geol.)</fld> <def>The ground mass of a rock,
especially if not distinctly crystalline.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>17.</sn> <fld>(Her.)</fld> <def>The lower part of the field. See
<er>Escutcheon</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>18.</sn> <def>The housing of a horse.</def>
<mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><sn>19.</sn> <pluf>pl.</pluf> <def>A kind of skirt (often of velvet
or brocade, but sometimes of mailed armor) which hung from the middle to
about the knees, or lower.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><sn>20.</sn> <def>The lower part of a robe or petticoat.</def>
<mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><sn>21.</sn> <def>An apron.</def> <mark>[Obs.]</mark> <ldquo/Bakers
in their linen <xex>bases</xex>.<rdquo/ <rj><au>Marston.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>22.</sn> <def>The point or line from which a start is made; a
starting place or a goal in various games.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>To their appointed <qex>base</qex> they went.</q>
<rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>23.</sn> <fld>(Surv.)</fld> <def>A line in a survey which, being
accurately determined in length and position, serves as the origin from
which to compute the distances and positions of any points or objects
connected with it by a system of triangles.</def>
<rj><au>Lyman.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>24.</sn> <def>A rustic play; -- called also <altname>prisoner's
base</altname>, <altname>prison base</altname>, or
<altname>bars</altname>.</def> <ldquo/To run the country
<xex>base</xex>.<rdquo/ <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>25.</sn> <fld>(Baseball)</fld> <def>Any one of the four bounds
which mark the circuit of the infield.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Altern base</b></col>. <cd>See under
<er>Altern</er>.</cd> -- <col><b>Attic base</b></col>.
<fld>(Arch.)</fld> <cd>See under <er>Attic</er>.</cd> -- <col><b>Base
course</b></col>. <fld>(Arch.)</fld> <sd>(a)</sd> <cd>The first or lower
course of a foundation wall, made of large stones or a mass of concrete;
-- called also <altname>foundation course</altname>. <sd>(b)</sd> The
architectural member forming the transition between the basement and the
wall above.</cd> -- <col><b>Base hit</b></col> <fld>(Baseball)</fld>,
<cd>a hit, by which the batsman, without any error on the part of his
opponents, is able to reach the first base without being put out.</cd>
-- <col><b>Base line</b></col>. <sd>(a)</sd> <cd>A main line taken as a
base, as in surveying or in military operations.</cd> <sd>(b)</sd> <cd>A
line traced round a cannon at the rear of the vent.</cd> -- <col><b>Base
plate</b></col>, <cd>the foundation plate of heavy machinery, as of the
steam engine; the bed plate.</cd> -- <col><b>Base ring</b></col>
<fld>(Ordnance)</fld>, <cd>a projecting band of metal around the breech,
connected with the body of the gun by a concave molding.</cd> <au>H. L.
Scott.</au></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Base</ent><br/
<hw>Base</hw> <pr>(b<amac/s)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. &
p. p.</pos> <conjf>Based</conjf> <pr>(b<amac/sd)</pr>; <pos>p. pr. & vb.
n.</pos> <conjf>Basing</conjf>.]</vmorph> <ety>[From <er>Base</er>,
<pos>n.</pos>]</ety> <def>To put on a base or basis; to lay the
foundation of; to found, as an argument or conclusion; -- used with
<ptcl>on</ptcl> or <ptcl>upon</ptcl>.</def> <rj><au>Bacon.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Base</ent><br/
<hw>Base</hw>, <pos>v. t.</pos> <ety>[See <er>Base</er>, <pos>a.</pos>,
and cf. <er>Abase</er>.]</ety> <sn>1.</sn> <def>To abase; to let, or
cast, down; to lower.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>If any . . . <qex>based</qex> his pike.</q> <rj><qau>Sir T.
North.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To reduce the value of; to debase.</def>
<mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>Metals which we can not <qex>base</qex>.</q>
<rj><qau>Bacon.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baseball</ent><br/
<hw>Base"ball"</hw> <pr>(<?/)</pr>, <pos>n.</pos> <sn>1.</sn> <def>A
game of ball, so called from the bases or bounds (four in number) which
designate the circuit which each player must endeavor to make after
striking the ball.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The ball used in this game.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baseboard</ent><br/
<hw>Base"board</hw> <pr>(<?/)</pr>, <pos>n.</pos> <fld>(Arch.)</fld>
<def>A board, or other woodwork, carried round the walls of a room and
touching the floor, to form a base and protect the plastering; -- also
called <xex>washboard</xex> (in England), <xex>mopboard</xex>, and
<xex>scrubboard</xex>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baseborn</ent><br/
<hw>Base"born`</hw> <pr>(<?/)</pr>, <pos>a.</pos> <sn>1.</sn> <def>Born
out of wedlock.</def> <rj><au>Gay.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Born of low parentage.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Vile; mean.</def> <ldquo/Thy <xex>baseborn</xex>
heart.<rdquo/ <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Base-burner</ent><br/
<hw>Base"-burn`er</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>A furnace or
stove in which the fuel is contained in a hopper or chamber, and is fed
to the fire as the lower stratum is consumed.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Base-court</ent><br/
<hw>Base"-court`</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[F.
<ets>basse-cour</ets>. See <er>Base</er>, <pos>a.</pos>, and
<er>Court</er>, <pos>n.</pos>]</ety> <sn>1.</sn> <def>The secondary,
inferior, or rear courtyard of a large house; the outer court of a
castle.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Law)</fld> <def>An inferior court of law, not of
record.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Based</ent><br/
<hw>Based</hw> <pr>(b<amac/sd)</pr>, <pos>p. p.</pos> & <pos>a.</pos>
<sn>1.</sn> <def>Having a base, or having as a base; supported; <as>as,
broad-<ex>based</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <ety>[See <er>Base</er>, <pos>n.</pos>, 18-21.]</ety>
<def>Wearing, or protected by, bases.</def> <mark>[Obs.]</mark>
<ldquo/<xex>Based</xex> in lawny velvet.<rdquo/ <rj><au>E.
Hall.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Basedow's disease</ent><br/
<hw>Ba"se*dow's dis*ease"</hw> <pr>(<?/)</pr>. <ety>[Named for
<person>Dr. <etsep>Basedow</etsep></person>, a German physician.]</ety>
<fld>(Med.)</fld> <def>A disease characterized by enlargement of the
thyroid gland, prominence of the eyeballs, and inordinate action of the
heart; -- called also <altname>exophthalmic goiter</altname>.</def>
<rj><au>Flint.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>base-forming</ent><br/
<hw>base-forming</hw> <pos>adj.</pos> <sn>1.</sn> <def>causing formation
of an alkali.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Baselard</ent><br/
<hw>Bas"e*lard</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[OF.
<ets>baselarde</ets>, LL. <ets>basillardus</ets>.]</ety> <def>A short
sword or dagger, worn in the fifteenth century.</def> <altsp>[Written
also <asp>baslard</asp>.]</altsp> <rj><au>Fairholt.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baseless</ent><br/
<hw>Base"less</hw>, <pos>a.</pos> <def>Without a base; having no
foundation or support.</def> <ldquo/The <xex>baseless</xex> fabric of
this vision.<rdquo/ <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>baseline</ent><br/
<hw>baseline</hw> <pos>n.</pos> <sn>1.</sn> <def>an imaginary line or
standard by which things are measured or compared; <as>as, they
established a <ex>baseline</ex> for the budget</as>.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><sn>2.</sn> <def>the back line at each end of a tennis
court.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><sn>3.</sn> <fld>(Baseball)</fld> <def>the lines between bases on a
baseball field along which a baseball player must run while running the
bases.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><sn>4.</sn> <def>a measurement that represents the value of a
physical quantity (such as a voltage, or a level of radioactivity) in
the absence of effects from other variables in a measurement, test or
experiment; a control value.</def><br/
[<source>PJC</source>]</p>

<p><sn>5.</sn> <def>any horizontal line in a plot, graph, or diagram, or
on a visual display in an electronic device, used as a reference point
to which other values are referred.</def><br/
[<source>PJC</source>]</p>

<p><ent>Basely</ent><br/
<hw>Base"ly</hw>, <pos>adv.</pos> <sn>1.</sn> <def>In a base manner;
with despicable meanness; dishonorably; shamefully.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Illegitimately; in bastardy.</def>
<mark>[Archaic]</mark> <rj><au>Knolles.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Basement</ent><br/
<hw>Base"ment</hw> <pr>(b<amac/sm<eit/nt)</pr>, <pos>n.</pos> <ety>[F.
<ets>soubassement</ets>. Of uncertain origin. Cf. <er>Base</er>,
<pos>a.</pos>, <er>Bastion</er>.]</ety> <fld>(Arch.)</fld> <def>The
outer wall of the ground story of a building, or of a part of that
story, when treated as a distinct substructure. (See <er>Base</er>,
<pos>n.</pos>, 3 <sd>(a)</sd>.) Hence: The rooms of a ground floor,
collectively.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Basement membrane</b></col> <fld>(Anat.)</fld>, <cd>a
delicate membrane composed of a single layer of flat cells, forming the
substratum upon which, in many organs, the epithelioid cells are
disposed.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baseness</ent><br/
<hw>Base"ness</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>The quality or
condition of being base; degradation; vileness.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>I once did hold it a <qex>baseness</qex> to write fair.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Basenet</ent><br/
<hw>Bas"e*net</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>See
<er>Bascinet</er>.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>base pair</ent><br/
<hw>base" pair`</hw> <pr>(b<amac/s" p<acir/r`)</pr>, <pos>n.</pos>
<fld>(Biochemistry, Genetics)</fld> <def>a unit of double-stranded DNA
or RNA consisting of two complementary bases on opposing strands of the
double-stranded polynucleotide, bound together by hydrogen bonds and
other non-covalent chemical forces. The bases comprising the base pairs
are adenine, thymine, cytidine, and guanine. In normal DNA, the base
adenine on one strand of DNA pairs with thymine on the opposite strand,
and cytosine on one strand pairs with guanine on the opposite strand.
The term <ex>base pair</ex> usually includes the sugar (ribose or
deoxyribose) and the phosphate bound to each base to form a nucleotide
unit. One <ex>base pair</ex> is sometimes used as a unit of length or
size for DNA, and in this usage is abbreviated <abbr>bp</abbr>; <as>as,
a 100-bp fragment of DNA</as>. A length of 1000 base pairs is a kilobase
pair or <abbr>kbp</abbr>.</def><br/
[<source>PJC</source>]</p>

<p><ent>base price</ent><br/
<hw>base" price`</hw> <pr>(b<amac/s" pr<imac/s`)</pr>, <pos>n.</pos>
<def>the initial price of something (goods or services) without the
additional charges that may be added, such as handling or shipping
charges, sales tax, optional equipment charges, etc.</def><br/
[<source>PJC</source>]</p>

<p><ent>Base viol</ent><br/
<hw>Base" vi`ol</hw> <pr>(<?/)</pr>. <def>See <er>Bass
viol</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bash</ent><br/
<hw>Bash</hw> <pr>(<?/)</pr>, <pos>v. t. & i.</pos> <ety>[OE.
<ets>baschen</ets>, <ets>baissen</ets>. See <er>Abash</er>.]</ety>
<def>To abash; to disconcert or be disconcerted or put out of
countenance.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>His countenance was bold and <qex>bashed</qex> not.</q>
<rj><qau>Spenser.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bash</ent><br/
<hw>Bash</hw> <pr>(?)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p.
p.</pos> <conjf>Bashed</conjf>; <pos>p. pr. & vb. n.</pos>
<conjf>Bashing</conjf>.]</vmorph> <ety>[Perh. of imitative origin; or
cf. Dan. <ets>baske</ets> to strike, <ets>bask</ets> a blow, Sw.
<ets>basa</ets> to beat, <ets>bas</ets> a beating.]</ety> <def>To strike
heavily; to beat; to crush.</def> <mark>[Prov. Eng. & Scot.]</mark>
<rj><au>Hall Caine.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>Bash</qex> her open with a rock.</q>
<rj><qau>Kipling.</qau></rj><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Bash</ent><br/
<hw>Bash</hw> <pr>(?)</pr>, <pos>n.</pos> <sn>1.</sn> <def>a forceful
blow, especially one that does damage to its target.</def><br/
[<source>PJC</source>]</p>

<p><sn>2.</sn> <def>a elaborate or lively social gathering or
party.</def><br/
[<source>PJC</source>]</p>

<p><ent>Bashaw</ent><br/
<hw>Ba*shaw"</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[See
<er>Pasha</er>.]</ety> <sn>1.</sn> <def>A Turkish title of honor, now
written <asp>pasha</asp>. See <er>Pasha</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Fig.: A magnate or grandee.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Zool.)</fld> <def>A very large siluroid fish
(<spn>Leptops olivaris</spn>) of the Mississippi valley; -- also called
<altname>goujon</altname>, <altname>mud cat</altname>, and
<altname>yellow cat</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bashful</ent><br/
<hw>Bash"ful</hw> <pr>(b<acr/sh"f<usdot/l)</pr>, <pos>a.</pos> <ety>[See
<er>Bash</er>.]</ety> <sn>1.</sn> <def>Abashed; daunted; dismayed.</def>
<mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Very modest, or modest to excess; constitutionally
disposed to shrink from public notice; indicating extreme or excessive
modesty; shy; <as>as, a <ex>bashful</ex> person, action,
expression</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- Diffident; retiring; reserved; shamefaced;
sheepish.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bashfully</ent><br/
<hw>Bash"ful*ly</hw>, <pos>adv.</pos> <def>In a bashful
manner.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bashfulness</ent><br/
<hw>Bash"ful*ness</hw>, <pos>n.</pos> <def>The quality of being
bashful.</def><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- <er>Bashfulness</er>, <er>Modesty</er>,
<er>Diffidence</er>, <er>Shyness</er>.</syn> <usage> <xex>Modesty</xex>
arises from a low estimate of ourselves; <xex>bashfulness</xex> is an
<xex>abashment</xex> or agitation of the spirits at coming into contact
with others; <xex>diffidence</xex> is produced by an undue degree of
self-distrust; <xex>shyness</xex> usually arises from an excessive
self-consciousness, and a painful impression that every one is looking
at us. <xex>Modesty</xex> of deportment is becoming in all;
<xex>bashfulness</xex> often gives rise to mistakes and blundering;
<xex>diffidence</xex> in society frequently makes a man a burden to
himself; <xex>shyness</xex> usually produces a reserve or distance which
is often mistaken for haughtiness.</usage><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bashi-bazouk</ent><br/
\'d8<hw>Bash"i-ba*zouk"</hw>
<pr>(b<acr/sh"<icr/*b<adot/*z<oomac/k")</pr>, <pos>n.</pos>
<ety>[Turkish, light-headed, a foolish fellow.]</ety> <def>A soldier
belonging to the irregular troops of the Turkish army.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bashless</ent><br/
<hw>Bash"less</hw>, <pos>a.</pos> <def>Shameless; unblushing.</def>
<mark>[Obs.]</mark> <rj><au>Spenser.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bashyle</ent><br/
<hw>Bas"hyle</hw> <pr>(<?/)</pr>, <pos>n.</pos> <fld>(Chem.)</fld>
<def>See <er>Basyle</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Basi-</ent><br/
<hw>Ba"si-</hw> <pr>(<?/)</pr>. <def>A combining form, especially in
anatomical and botanical words, to indicate <xex>the base</xex> or
<xex>position at or near a base</xex>; <xex>forming a base</xex>;
<xex>as</xex>, <xex>basi</xex>branchials, the most ventral of the
cartilages or bones of the branchial arches; <xex>basi</xex>cranial,
situated at the base of the cranium; <xex>basi</xex>facial,
<xex>basi</xex>temporal, etc.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Basic</ent><br/
<hw>Ba"sic</hw> <pr>(<?/)</pr>, <pos>a.</pos> <sn>1.</sn>
<fld>(Chem.)</fld> <sd>(a)</sd> <def>Relating to a base; performing the
office of a base in a salt.</def> <sd>(b)</sd> <def>Having the base in
excess, or the amount of the base atomically greater than that of the
acid, or exceeding in proportion that of the related neutral salt.</def>
<sd>(c)</sd> <def>Apparently alkaline, as certain normal salts which
exhibit alkaline reactions with test paper.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Min.)</fld> <def>Said of crystalline rocks which
contain a relatively low percentage of silica, as basalt.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Basic salt</b></col> <fld>(Chem.)</fld>, <cd>a salt
formed from a base or hydroxide by the partial replacement of its
hydrogen by a negative or acid element or radical.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>BASIC</ent><br/
<hw>BASIC</hw> <pos>n.</pos> <sn>1.</sn> <fld>(Computers)</fld>
<ety>[<ets>B</ets>eginner's <ets>A</ets>ll-purpose <ets>S</ets>ymbolic
<ets>I</ets>ruction <ets>C</ets>.]</ety> <def>an artificial computer
language with a relatively simplified instruction set.</def>
<note>Writing a program in BASIC or other higher computer languages is
simpler than writing in assembly language. See also <er>programming
language</er>, <er>FORTRAN</er>.</note><br/
[<source>PJC</source>]</p>

<p><ent>Basicerite</ent><br/
<hw>Ba*sic"er*ite</hw> <pr>(b<adot/*s<icr/s"<etil/r*<omac/t)</pr>,
<pos>n.</pos> <ety>[<ets>Basi-</ets> + Gr. <grk>ke`ras</grk> horn,
antenna.]</ety> <fld>(Zool.)</fld> <def>The second joint of the
antenn<ae/ of crustaceans.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Basicity</ent><br/
<hw>Ba*sic"i*ty</hw>, <pos>n.</pos> <fld>(Chem.)</fld> <sd>(a)</sd>
<def>The quality or state of being a base.</def> <sd>(b)</sd> <def>The
power of an acid to unite with one or more atoms or equivalents of a
base, as indicated by the number of replaceable hydrogen atoms contained
in the acid.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Basic process</ent><br/
<hw>Ba"sic proc"ess</hw>. <fld>(Iron Metal.)</fld> <def>A Bessemer or
open-hearth steel-making process in which a lining that is basic, or not
siliceous, is used, and additions of basic material are made to the
molten charge during treatment. Opposed to <contr><cref>acid
process</cref></contr>, above. Called also <altname>Thomas
process</altname>.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>basics</ent><br/
<hw>basics</hw> <pos>n. pl.</pos> <sn>1.</sn> <def>a statement of
fundamental facts or principles.</def><br/
<syn><b>Syn. --</b> ABC, ABC's, ABCs, rudiments.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><sn>2.</sn> <def>principles from which other truths can be derived;
<as>as, let's get down to <ex>basics</ex></as>.</def><br/
<syn><b>Syn. --</b> fundamentals, fundamental principle, basic
principle, bedrock.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Basic slag</ent><br/
<hw>Basic slag</hw>. <def>A by-product from the manufacture of steel by
the basic process, used as a fertilizer. It is rich in lime and contains
14 to 20 per cent of phosphoric acid. Called also <altname>Thomas
slag</altname>, <altname>phosphatic slag</altname>, and
<altname>odorless phosphate</altname>.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Basic steel</ent><br/
<hw>Basic steel</hw>. <def>Steel produced by the basic
process.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>basidial</ent><br/
<hw>basidial</hw> <pos>adj.</pos> <def>of or pertaining to a
basidium.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>basidiolichen</ent><br/
<hw>basidiolichen</hw> <pos>n.</pos> <def>a lichen in which the fungus
component is a basidiomycete.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>basidiomycete</ent><br/
<hw>ba*sid`i*o*my"cete</hw> <pos>n.</pos> <sn>1.</sn> <def>any of
various fungi of the subdivision Basidiomycota.</def><br/
<syn><b>Syn. --</b> basidiomycetous fungi.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Basidiomycetes</ent><br/
\'d8<hw>Ba*sid`i*o*my*ce"tes</hw> <pr>(?)</pr>, <pos>n. pl.</pos> <def>a
phylum of fungi with the Basidiomycota</def><br/
[<source>Webster 1913 Suppl.</source> <source>+PJC</source>]</p>

<p><ent>basidiomycetous</ent><br/
<hw>basidiomycetous</hw> <pos>adj.</pos> <def>of or pertaining to
basidiomycetes.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Basidiomycota</ent><br/
\'d8<hw>Ba*sid`i*o*my*co"ta</hw> <pr>(?)</pr>, <pos>n. pl.</pos>
<fld>(Bot.)</fld> <ety>[NL., fr. NL. & E. <ets>basidium</ets> + Gr. <?/,
<?/, fungus.]</ety> <fld>(Bot.)</fld> <def>A large subdivision of the
kingdom <it>Fungi</it> coextensive with the phylum
<phylum>Basidiomycetes</phylum>, characterized by having the spores
borne on a basidium. It embraces those fungi best known to the public,
such as mushrooms, toadstools, etc. Among the classes of the
Basidiomycota are: <styp><class>Gasteromycetes</class></styp>
(puffballs); <styp><class>Tiliomycetes</class></styp> (comprising the
orders <ord>Ustilaginales</ord> (smuts) and <ord>Uredinales</ord>
(rusts)); and <styp><class>Hymenomycetes</class></styp> (mushrooms;
toadstools; agarics; bracket fungi).</def> <note>In the 1913 Webster,
the Basidiomycetes were defined as "co<oum/rdinate with the
<phylum>Ascomycetes</phylum>", and other fungal phyla (the
<phylum>Zygomycota</phylum> and <phylum>Deuteromycota</phylum>) were not
mentioned.</note><br/
<syn><b>Syn. --</b> Basidiomycota, subdivision Basidiomycota,
subdivision Basidiomycotina.</syn><br/
[<source>Webster 1913 Suppl.</source> <source>+PJC</source>]</p>

<p><ent>Basidiomycotina</ent><br/
<hw>Basidiomycotina</hw> <pos>n.</pos> <def>same as
<er>Basidiomycota</er>.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Basidiospore</ent><br/
<hw>Ba*sid"i*o*spore</hw> <pr>(<?/)</pr>, <pos>n.</pos>
<ety>[<ets>Basidium</ets> + <ets>spore</ets>.]</ety> <fld>(Bot.)</fld>
<def>A spore borne by a basidium.</def> --
<wordforms><wf>Ba*sid`i*o*spor"ous</wf> <pr>(<?/)</pr>,
<pos>a.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>basidiosporous</ent><br/
<hw>basidiosporous</hw> <pos>adj.</pos> <def>of or pertaining to a
basidiospore.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Basidium</ent><br/
\'d8<hw>Ba*sid"i*um</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[NL., dim.
of Gr. <grk>ba`sis</grk> base.]</ety> <fld>(Bot.)</fld> <def>A special
oblong or pyriform cell, with slender branches, which bears the spores
in that division of fungi called <xex>Basidiomycetes</xex>, of which the
common mushroom is an example.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Basifier</ent><br/
<hw>Ba"si*fi`er</hw> <pr>(<?/)</pr>, <pos>n.</pos> <fld>(Chem.)</fld>
<def>That which converts into a salifiable base.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Basifugal</ent><br/
<hw>Ba*sif"u*gal</hw> <pr>(<?/)</pr>, <pos>a.</pos>
<ety>[<ets>Base</ets>,<pos>n.</pos>+ L. <ets>fugere</ets> to
flee.]</ety> <fld>(Bot.)</fld> <def>Tending or proceeding away from the
base; <as>as, a <ex>basifugal</ex> growth</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Basify</ent><br/
<hw>Ba"si*fy</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <ety>[<ets>Base</ets>
+ <ets>-fy</ets>.]</ety> <fld>(Chem.)</fld> <def>To convert into a
salifiable base.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Basigynium</ent><br/
\'d8<hw>Ba`si*gyn"i*um</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[NL., fr.
Gr. <grk>ba`sis</grk> base + <grk>gynh`</grk> woman.]</ety>
<fld>(Bot.)</fld> <def>The pedicel on which the ovary of certain
flowers, as the passion flower, is seated; a carpophore or
thecaphore.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Basihyal</ent><br/
<hw>Ba`si*hy"al</hw> <pr>(<?/)</pr>, <pos>a.</pos>
<ety>[<ets>Basi-</ets> + Gr. <upsilon/ (the letter
<ldquo/upsilon<rdquo/); from the shape.]</ety> <fld>(Anat.)</fld>
<def>Noting two small bones, forming the body of the inverted hyoid
arch.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Basihyoid</ent><br/
<hw>Ba`si*hy"oid</hw> <pr>(<?/)</pr>, <pos>n.</pos>
<ety>[<ets>Basi-</ets> + <ets>hyoid</ets>.]</ety> <fld>(Anat.)</fld>
<def>The central tongue bone.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Basil</ent><br/
<hw>Bas"il</hw> <pr>(b<acr/z"<icr/l)</pr>, <pos>n.</pos> <ety>[Cf. F.
<ets>basile</ets> and E. <er>Bezel</er>.]</ety> <def>The slope or angle
to which the cutting edge of a tool, as a plane, is ground.</def>
<rj><au>Grier.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Basil</ent><br/
<hw>Bas"il</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos>
<conjf>Basiled</conjf> (<?/); <pos>p. pr. & vb. n.</pos>
<conjf>Basiling</conjf>.]</vmorph> <def>To grind or form the edge of to
an angle.</def> <rj><au>Moxon.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Basil</ent><br/
<hw>Bas"il</hw>, <pos>n.</pos> <ety>[F. <ets>basilic</ets>, fr. L.
<ets>basilicus</ets> royal, Gr. <grk>basiliko`s</grk> fr.
<grk>basiley`s</grk> king.]</ety> <fld>(Bot.)</fld> <def>The name given
to several aromatic herbs of the Mint family, but chiefly to the common
or sweet basil (<spn>Ocymum basilicum</spn>), and the bush basil, or
lesser basil (<spn>Ocymum minimum</spn>), the leaves of which are used
in cookery. The name is also given to several kinds of mountain mint
(<gen>Pycnanthemum</gen>).</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Basil thyme</b></col>, <cd>a name given to the fragrant
herbs <spn>Calamintha Acinos</spn> and <spn>Calamintha
Nepeta</spn>.</cd> -- <col><b>Wild basil</b></col>, <cd>a plant
(<spn>Calamintha clinopodium</spn>) of the Mint family.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Basil</ent><br/
<hw>Bas"il</hw> <pr>(b<acr/z"<icr/l)</pr>, <pos>n.</pos> <ety>[Corrupt.
from E. <ets>basan</ets>, F. <ets>basane</ets>, LL. <ets>basanium</ets>,
<ets>bazana</ets>, fr. Ar. <ets>bith<amac/na</ets>, prop.,
lining.]</ety> <def>The skin of a sheep tanned with bark.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Basilary</ent><br/
<ent>Basilar</ent><br/
<mhw>{ <hw>Bas"i*lar</hw> <pr>(<?/)</pr>, <hw>Bas"i*la*ry</hw>
<pr>(<?/)</pr>, }</mhw> <pos>a.</pos> <ety>[F. <ets>basilaire</ets>, fr.
L. <ets>basis</ets>. See <er>Base</er>, <pos>n.</pos>]</ety> <sn>1.</sn>
<def>Relating to, or situated at, the base.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Lower; inferior; applied to impulses or springs of
action.</def> <mark>[R.]</mark> <ldquo/<xex>Basilar</xex>
instincts.<rdquo/ <rj><au>H. W. Beecher.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>basileus</ent><br/
<hw>basileus</hw> <pos>n.</pos> <def>a ruler of the eastern Roman
Empire.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Basilic</ent><br/
<hw>Ba*sil"ic</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[F.
<ets>basilique</ets>.]</ety> <def>Basilica.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Basilical</ent><br/
<ent>Basilic</ent><br/
<mhw>{ <hw>Ba*sil"ic</hw> <pr>(<?/)</pr>, <hw>Ba*sil"ic*al</hw>
<pr>(<?/)</pr>, }</mhw> <pos>a.</pos> <ety>[See
<er>Basilica</er>.]</ety> <sn>1.</sn> <def>Royal; kingly; also,
basilican.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Anat.)</fld> <def>Pertaining to certain parts,
anciently supposed to have a specially important function in the animal
economy, as the middle vein of the right arm.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Basilica</ent><br/
<hw>Ba*sil"i*ca</hw> <pr>(<?/)</pr>, <pos>n.</pos>; <plu><it>pl.</it>
<plw>Basilicas</plw> <pr>(<?/)</pr>; sometimes <plw>Basilic<ae/</plw>
<pr>(-s<emac/)</pr>.</plu> <ety>[L. <ets>basilica</ets>, Gr.
<grk>basilikh`</grk> (sc. <grk>o'iki`a</grk> or <grk>stoa`</grk> fr.
<grk>basiliko`s</grk> royal, fr. <grk>basiley`s</grk> king.]</ety>
<sn>1.</sn> <def>Originally, the palace of a king; but afterward, an
apartment provided in the houses of persons of importance, where
assemblies were held for dispensing justice; and hence, any large hall
used for this purpose.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Arch.)</fld> <sd>(a)</sd> <def>A building used by
the Romans as a place of public meeting, with court rooms, etc.,
attached.</def> <sd>(b)</sd> <def>A church building of the earlier
centuries of Christianity, the plan of which was taken from the basilica
of the Romans. The name is still applied to some churches by way of
honorary distinction.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Basilica</ent><br/
<hw>Ba*sil"i*ca</hw>, <pos>n.</pos> <def>A digest of the laws of
Justinian, translated from the original Latin into Greek, by order of
<xex>Basil</xex> I., in the ninth century.</def> <rj><au>P.
Cyc.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Basilican</ent><br/
<hw>Ba*sil"i*can</hw> <pr>(<?/)</pr>, <pos>a.</pos> <def>Of, relating
to, or resembling, a basilica; basilical.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>There can be no doubt that the first churches in Constantinople
were in the <qex>basilican</qex> form.</q>
<rj><qau>Milman.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Basilicok</ent><br/
<hw>Ba*sil"i*cok</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[OF.
<ets>basilicoc</ets>.]</ety> <def>The basilisk.</def>
<mark>[Obs.]</mark> <rj><au>Chaucer</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Basilicon</ent><br/
\'d8<hw>Ba*sil"i*con</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[L.
<ets>basilicon</ets>, Gr. <grk>basiliko`n</grk> neut. of
<grk>basiliko`s</grk>: cf. F. <ets>basilicon</ets>. See
<er>Basilica</er>.]</ety> <fld>(Med.)</fld> <def>An ointment composed of
wax, pitch, resin, and olive oil, lard, or other fatty
substance.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Basilisk</ent><br/
<hw>Bas"i*lisk</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[L.
<ets>basiliscus</ets>, Gr. <grk>basili`skos</grk> little king, kind of
serpent, dim. of <grk>basiley`s</grk> king; -- so named from some
prominences on the head resembling a crown.]</ety> <sn>1.</sn> <def>A
fabulous serpent, or dragon. The ancients alleged that its hissing would
drive away all other serpents, and that its breath, and even its look,
was fatal. See <er>Cockatrice</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Make me not sighted like the <qex>basilisk</qex>.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Zool.)</fld> <def>A lizard of the genus
<gen>Basiliscus</gen>, belonging to the family
<fam>Iguanid<ae/</fam>.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ This genus is remarkable for a membranous bag rising
above the occiput, which can be filled with air at pleasure; also for an
elevated crest along the back, that can be raised or depressed at
will.</note><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Mil.)</fld> <def>A large piece of ordnance, so
called from its supposed resemblance to the serpent of that name, or
from its size.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Basin</ent><br/
<hw>Ba"sin</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[OF.
<ets>bacin</ets>, F. <ets>bassin</ets>, LL. <ets>bacchinus</ets>, fr.
<ets>bacca</ets> a water vessel, fr. L. <ets>bacca</ets> berry, in
allusion to the round shape; or perh. fr. Celtic. Cf.
<er>Bac</er>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>A hollow vessel or dish, to hold water for washing,
and for various other uses.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The quantity contained in a basin.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>A hollow vessel, of various forms and materials,
used in the arts or manufactures, as that used by glass grinders for
forming concave glasses, by hatters for molding a hat into shape,
etc.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>A hollow place containing water, as a pond, a dock
for ships, a little bay.</def> <rj><au>Pope</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <fld>(Physical Geog.)</fld> <sd>(a)</sd> <def>A circular
or oval valley, or depression of the surface of the ground, the lowest
part of which is generally occupied by a lake, or traversed by a
river.</def> <sd>(b)</sd> <def>The entire tract of country drained by a
river, or sloping towards a sea or lake.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <fld>(Geol.)</fld> <def>An isolated or circumscribed
formation, particularly where the strata dip inward, on all sides,
toward a center; -- especially applied to the coal formations, called
<stype>coal basins</stype> or <stype>coal fields</stype>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>basinal</ent><br/
<hw>basinal</hw> <pos>adj.</pos> <def>of or pertaining to a
basin.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Basined</ent><br/
<hw>Ba"sined</hw> <pr>(<?/)</pr>, <pos>a.</pos> <def>Inclosed in a
basin.</def> <ldquo/<xex>Basined</xex> rivers.<rdquo/
<rj><au>Young.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Basinet</ent><br/
<hw>Bas"i*net</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>Same as
<er>Bascinet</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Basioccipital</ent><br/
<hw>Ba`si*oc*cip"i*tal</hw> <pr>(<?/)</pr>, <pos>a.</pos>
<ety>[<ets>Basi-</ets> + <ets>occipital</ets>.]</ety> <fld>(Anat.)</fld>
<def>Of or pertaining to the bone in the base of the cranium, frequently
forming a part of the occipital in the adult, but usually distinct in
the young.</def> -- <def2><pos>n.</pos> <def>The basioccipital
bone.</def></def2><br/
[<source>1913 Webster</source>]</p>

<p><ent>Basion</ent><br/
\'d8<hw>Ba"si*on</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[Gr.
<grk>ba`sis</grk> a base.]</ety> <fld>(Anat.)</fld> <def>The middle of
the anterior margin of the great foramen of the skull.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Basipodite</ent><br/
<hw>Ba*sip"o*dite</hw> <pr>(<?/)</pr>, <pos>n.</pos>
<ety>[<ets>Basi-</ets> + <grk>poy`s</grk>, <grk>podo`s</grk>,
foot.]</ety> <fld>(Anat.)</fld> <def>The basal joint of the legs of
Crustacea.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Basipterygium</ent><br/
\'d8<hw>Ba*sip`te*ryg"i*um</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[NL.,
fr. Gr. <grk>ba`sis</grk> a base + <grk>ptery`gion</grk> a fin.]</ety>
<fld>(Anat.)</fld> <def>A bar of cartilage at the base of the embryonic
fins of some fishes. It develops into the metapterygium.</def> --
<wordforms><wf>Ba*sip`ter*yg"i*al</wf> <pr>(<?/)</pr>,
<pos>a.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Basipterygoid</ent><br/
<hw>Ba`sip*ter"y*goid</hw> <pr>(<?/)</pr>, <pos>a. & n.</pos>
<ety>[<ets>Basi-</ets> + <ets>pterygoid</ets>.]</ety> <fld>(Anat.)</fld>
<def>Applied to a protuberance of the base of the sphenoid
bone.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Basis</ent><br/
<hw>Ba"sis</hw> <pr>(b<amac/"s<icr/s)</pr>, <pos>n.</pos>;
<plu><it>pl.</it> <plw>Bases</plw> <pr>(b<amac/"s<emac/z)</pr>.</plu>
<ety>[L. <ets>basis</ets>, Gr. <grk>ba`sis</grk>. See <er>Base</er>,
<pos>n.</pos>]</ety> <sn>1.</sn> <def>The foundation of anything; that
on which a thing rests.</def> <rj><au>Dryden.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The pedestal of a column, pillar, or statue.</def>
<mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>If no <qex>basis</qex> bear my rising name.</q>
<rj><qau>Pope.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 123 pr=SA --></p>

<p><sn>3.</sn> <def>The groundwork; the first or fundamental principle;
that which supports.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The <qex>basis</qex> of public credit is good faith.</q>
<rj><qau>A. Hamilton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>The principal component part of a thing.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Basisolute</ent><br/
<hw>Ba*sis"o*lute</hw> <pr>(b<adot/*s<icr/s"<osl/*l<umac/t)</pr>,
<pos>a.</pos> <ety>[<ets>Basi-</ets> + <ets>solute</ets>, a.]</ety>
<fld>(Bot.)</fld> <def>Prolonged at the base, as certain
leaves.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Basisphenoidal</ent><br/
<ent>Basisphenoid</ent><br/
<mhw>{ <hw>Ba`si*sphe"noid</hw> <pr>(<?/)</pr>,
<hw>Ba`si*sphe*noid"al</hw> <pr>(<?/)</pr>, }</mhw> <pos>a.</pos>
<ety>[<ets>Basi-</ets> + <ets>sphenoid</ets>.]</ety> <fld>(Anat.)</fld>
<def>Of or pertaining to that part of the base of the cranium between
the basioccipital and the presphenoid, which usually ossifies separately
in the embryo or in the young, and becomes a part of the sphenoid in the
adult.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Basisphenoid</ent><br/
<hw>Ba`si*sphe"noid</hw>, <pos>n.</pos> <fld>(Anat.)</fld> <def>The
basisphenoid bone.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bask</ent><br/
<hw>Bask</hw> <pr>(b<adot/sk)</pr>, <pos>v. i.</pos> <vmorph>[<pos>imp.
& p. p.</pos> <conjf>Basked</conjf> <pr>(b<adot/skt)</pr>; <pos>p. pr. &
vb. n.</pos> <conjf>Basking</conjf>.]</vmorph> <ety>[OScand.
<ets>ba<edh/ask</ets> to bathe one's self, or perh. <ets>bakask</ets> to
bake one's self, <ets>sk</ets> being reflexive. See <er>Bath</er>,
<pos>n.</pos>, <er>Bake</er>, <pos>v. t.</pos>]</ety> <def>To lie in
warmth; to be exposed to genial heat.</def><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>Basks</qex> in the glare, and stems the tepid wave.</q>
<rj><qau>Goldsmith.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bask</ent><br/
<hw>Bask</hw>, <pos>v. t.</pos> <def>To warm by continued exposure to
heat; to warm with genial heat.</def><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>Basks</qex> at the fire his hairy strength.</q>
<rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Basket</ent><br/
<hw>Bas"ket</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[Of unknown origin.
The modern Celtic words seem to be from the English.]</ety> <sn>1.</sn>
<def>A vessel made of osiers or other twigs, cane, rushes, splints, or
other flexible material, interwoven.</def> <ldquo/Rude
<xex>baskets</xex> . . . woven of the flexile willow.<rdquo/
<rj><au>Dyer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The contents of a basket; as much as a basket
contains; <as>as, a <ex>basket</ex> of peaches</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Arch.)</fld> <def>The bell or vase of the
Corinthian capital.</def> <mark>[Improperly so used.]</mark>
<rj><au>Gwilt.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>The two back seats facing one another on the outside
of a stagecoach.</def> <mark>[Eng.]</mark>
<rj><au>Goldsmith.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>A container shaped like a basket{1}, even if made of
solid material rather than woven; -- the top is often, but not always,
open and without a lid.</def><br/
[<source>PJC</source>]</p>

<p><sn>6.</sn> <def>a vessel suspended below a balloon, designed to
carry people or measuring instruments for scientific research.</def>
<note>The earliest balloons designed to carry people often had small
vessels of woven flexible vegetable materials to hold the passengers,
which resembled large baskets{1}, from which the name was
derived.</note><br/
[<source>PJC</source>]</p>

<p><sn>7.</sn> <fld>(Basketball)</fld> <def>A goal{3} consisting of a
short cylindrical net suspended from a circular rim, which itself is
attached at about ten feet above floor level to a backboard, placed at
the end of a basketball court. In professional basketball, two such
<ex>baskets</ex> are used, one at each end of the court, and each team
may score only by passing the ball though its own <ex>basket</ex>. In
informal games, only one such <ex>basket</ex> is often used.</def><br/
[<source>PJC</source>]</p>

<p><sn>8.</sn> <fld>(Basketball)</fld> <def>An instance of scoring
points by throwing the basketball through the basket; <as>as, he threw
four <ex>baskets</ex> in the first quarter</as>; -- the ball must pass
through the basket from above in order to score points.</def><br/
[<source>PJC</source>]</p>

<p><cs><col><b>Basket fish</b></col> <fld>(Zool.)</fld>, <cd>an ophiuran
of the genus <gen>Astrophyton</gen>, having the arms much branched. See
<er>Astrophyton</er>.</cd> -- <col><b>Basket hilt</b></col>, <cd>a hilt
with a covering wrought like basketwork to protect the hand.</cd>
<au>Hudibras.</au> <specif>Hence,</specif>
<wordforms><col><b>Basket-hilted</b></col>, <pos>a.</pos></wordforms> --
<col><b>Basket work</b></col>, <cd>work consisting of plaited osiers or
twigs.</cd> -- <col><b>Basket worm</b></col> <fld>(Zool.)</fld>, <cd>a
lepidopterous insect of the genus <gen>Thyridopteryx</gen> and allied
genera, esp. <spn>Thyridopteryx ephemer<ae/formis</spn>. The larva makes
and carries about a bag or basket-like case of silk and twigs, which it
afterwards hangs up to shelter the pupa and wingless adult females.</cd>
-- <col><b>collection basket</b></col>, <cd>a small basket{1} mounted on
the end of a pole, used in churches to collect donations from those
attending a church service; -- the long pole allows the collector to
hold the basket in front of those at the end of the pew, while the
collector remains in the aisle.</cd> <col><b>waste basket</b></col>,
<cd>a basket{4} used to hold waste matter, such as discarded paper,
commonly shaped like a truncated cone, with the wide end open and at the
top. Vessels of other shapes, such as oblong containers, are also called
<ex>waste baskets</ex>.</cd></cs><br/
[<source>1913 Webster</source> <source>+PJC</source>]</p>

<p><ent>Basket</ent><br/
<hw>Bas"ket</hw>, <pos>v. t.</pos> <def>To put into a basket.</def>
<mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Basketball</ent><br/
<hw>Bas"ket*ball`</hw>, <pos>n.</pos> <sn>1.</sn> <def>A ball game,
usually played indoors in an area called the basketball court, in which
two opposing teams of five players each contest with each other to toss
a large inflated ball (the basketball) into opposite goals (baskets)
resembling baskets, each typically a cylindrical mesh suspended from a
circular rim which is held ten feet above the court. A goal scored by
passing the basketball through the basket may count from one to three
points, depending on the situation in which it was thrown.</def><br/
<syn><b>Syn. --</b> basketball game.</syn><br/
[<source>Webster 1913 Suppl.</source> <source>WordNet 1.5</source> <source>+PJC</source>]</p>

<p><sn>2.</sn> <def>The inflatable ball used in the game of
basketball.</def><br/
[<source>PJC</source>]</p>

<p><ent>Basketful</ent><br/
<hw>Bas"ket*ful</hw> <pr>(<?/)</pr>, <pos>n.</pos>; <plu><it>pl.</it>
<plw>Basketfuls</plw> <pr>(<?/)</pr>.</plu> <def>As much as a basket
will contain.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Basketry</ent><br/
<hw>Bas"ket*ry</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>The art of making
baskets; also, baskets, taken collectively.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Basking shark</ent><br/
<hw>Bask"ing shark`</hw> <pr>(<?/)</pr>. <fld>(Zool.)</fld> <def>One of
the largest species of sharks (<spn>Cetorhinus maximus</spn>), so called
from its habit of basking in the sun; the <altname>liver
shark</altname>, or <altname>bone shark</altname>. It inhabits the
northern seas of Europe and America, and grows to a length of more than
forty feet. It is a harmless species.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Basnet</ent><br/
<hw>Bas"net</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>Same as
<er>Bascinet</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Basommatophora</ent><br/
\'d8<hw>Ba*som`ma*toph"o*ra</hw>
<pr>(b<adot/*s<ocr/m`m<adot/*t<ocr/f"<osl/*r<adot/)</pr>, <pos>n.
pl.</pos> <ety>[NL., fr. Gr. <grk>ba`sis</grk> base + <grk>'o`mma</grk>
eye + <grk>fe`rein</grk> to bear.]</ety> <fld>(Zool.)</fld> <def>A group
of Pulmonifera having the eyes at the base of the tentacles, including
the common pond snails.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bason</ent><br/
<hw>Ba"son</hw> <pr>(b<amac/"s'n)</pr>, <pos>n.</pos> <def>A
basin.</def> <mark>[Obs. or Special form]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Basque</ent><br/
<hw>Basque</hw> <pr>(b<adot/sk)</pr>, <pos>a.</pos> <ety>[F.]</ety>
<def>Pertaining to Biscay, its people, or their language.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Basque</ent><br/
<hw>Basque</hw> <pr>(b<adot/sk)</pr>, <pos>n.</pos> <ety>[F.]</ety>
<sn>1.</sn> <def>One of a race, of unknown origin, inhabiting a region
on the Bay of Biscay in Spain and France.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The language spoken by the Basque people.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>A part of a lady's dress, resembling a jacket with a
short skirt; -- probably so called because this fashion of dress came
from the <xex>Basques</xex>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Basquish</ent><br/
<hw>Basqu"ish</hw> <pr>(<?/)</pr>, <pos>a.</pos> <ety>[F.
<ets>Basque</ets> Biscayan: cf. G. <ets>Baskisch</ets>.]</ety>
<def>Pertaining to the country, people, or language of Biscay;
Basque</def> <mark>[Obs.]</mark> <rj><au>Sir T. Browne.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bas-relief</ent><br/
<hw>Bas`-re*lief"</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[F.
<ets>bas-relief</ets>; <ets>bas</ets> low + <ets>relief</ets> raised
work, <ets>relever</ets> to raise: cf. It.
<ets>bassorilievo</ets>.]</ety> <def>Low relief; sculpture, the figures
of which project less than half of their true proportions; -- called
also <altname>bass-relief</altname> and
<altname>basso-rilievo</altname>. See <er>Alto-rilievo</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bass</ent><br/
<hw>Bass</hw> <pr>(b<adot/s)</pr>, <pos>n.</pos>; <plu><it>pl.</it>
<plw>Bass</plw>, and sometimes <plw>Basses</plw>
<pr>(b<adot/s"<ecr/z)</pr>.</plu> <ety>[A corruption of
<ets>barse</ets>.]</ety> <fld>(Zool.)</fld> <sn>1.</sn> <def>An edible,
spiny-finned fish, esp. of the genera <gen>Roccus</gen>,
<gen>Labrax</gen>, and related genera. There are many species.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ The common European bass is <spn>Labrax lupus</spn>.
American species are: the striped bass (<spn>Roccus lineatus</spn>);
white or silver bass of the lakes (<spn>Roccus chrysops</spn>); brass or
yellow bass (<spn>Roccus interruptus</spn>).</note><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The two American fresh-water species of black bass
(genus <gen>Micropterus</gen>). See <er>Black bass</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Species of <gen>Serranus</gen>, the sea bass and
rock bass. See <er>Sea bass</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>The southern, red, or channel bass (<spn>Sci<ae/na
ocellata</spn>). See <er>Redfish</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ The name is also applied to many other fishes. See
<cref>Calico bass</cref>, under <er>Calico</er>.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bass</ent><br/
<hw>Bass</hw>, <pos>n.</pos> <ety>[A corruption of
<ets>bast</ets>.]</ety> <sn>1.</sn> <fld>(Bot.)</fld> <def>The linden or
lime tree, sometimes wrongly called <altname>whitewood</altname>; also,
its bark, which is used for making mats. See <er>Bast</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <pr>(Pron. <?/)</pr> <def>A hassock or thick
mat.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bass</ent><br/
<hw>Bass</hw> <pr>(b<amac/s)</pr>, <pos>n.</pos> <ety>[F.
<ets>basse</ets>, fr. <ets>bas</ets> low. See <er>Base</er>,
<pos>a.</pos>]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>A bass, or deep, sound or tone.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Mus.)</fld> <sd>(a)</sd> <def>The lowest part in a
musical composition.</def> <sd>(b)</sd> <def>One who sings, or the
instrument which plays, bass.</def> <altsp>[Written also
<asp>base</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Thorough bass</b></col>. <cd>See <er>Thorough
bass</er>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bass</ent><br/
<hw>Bass</hw>, <pos>a.</pos> <def>Deep or grave in tone.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Bass clef</b></col> <fld>(Mus.)</fld>, <cd>the character
placed at the beginning of the staff containing the bass part of a
musical composition.</cd> [See <xex>Illust.</xex> under <er>Clef</er>.]
-- <col><b>Bass voice</b></col>, <cd>a deep-sounding voice; a voice
fitted for singing bass.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bass</ent><br/
<hw>Bass</hw>, <pos>v. t.</pos> <def>To sound in a deep tone.</def>
<mark>[R.]</mark> <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bassaw</ent><br/
<ent>Bassa</ent><br/
<mhw>{ <hw>Bas"sa</hw> <pr>(<?/)</pr>, <hw>Bas*saw"</hw> }</mhw>
<pr>(<?/)</pr>, <pos>n.</pos> <def>See <er>Bashaw</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bassariscidae</ent><br/
<hw>Bassariscidae</hw> <pos>n.</pos> <def>a division of mammals, in some
classifications considered a separate family.</def><br/
<syn><b>Syn. --</b> subfamily Bassariscidae.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Bassariscus</ent><br/
<hw>Bassariscus</hw> <pos>n.</pos> <def>a genus comprising the
cacomistles. See <er>bassarisk</er>.</def><br/
<syn><b>Syn. --</b> genus Bassariscus.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>bassarisk</ent><br/
<hw>bassarisk</hw> <pos>n.</pos> <def>A raccoonlike omnivorous mammal
(<spn>Bassariscus astutus</spn>) of Mexico and southwestern U. S. having
a long bushy tail with black and white rings.</def><br/
<syn><b>Syn. --</b> cacomistle, cacomixle, coon cat, raccoon fox,
ringtail, ring-tailed cat, civet cat, miner's cat.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Bass drum</ent><br/
<hw>Bass` drum"</hw> <pr>(<?/)</pr>. <fld>(Mus.)</fld> <def>The largest
of the different kinds of drums, having two heads, and emitting a deep,
grave sound. See <er>Bass</er>, <pos>a.</pos></def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Basset</ent><br/
<hw>Bas"set</hw> <pr>(b<acr/s"s<ecr/t <it>or</it>
b<acr/s*s<ecr/t")</pr>, <pos>n.</pos> <ety>[F. <ets>bassette</ets>, fr.
It. <ets>bassetta</ets>. Cf. <er>Basso</er>.]</ety> <def>A game at
cards, resembling the modern faro, said to have been invented at
Venice.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Some dress, some dance, some play, not to forget<br/
Your piquet parties, and your dear <qex>basset</qex>.</q>
<rj><qau>Rowe.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Basset</ent><br/
<hw>Bas"set</hw> <pr>(b<acr/s"s<ecr/t)</pr>, <pos>a.</pos> <ety>[Cf. OF.
<ets>basset</ets> somewhat low, dim. of <ets>bas</ets> low.]</ety>
<fld>(Geol.)</fld> <def>Inclined upward; <as>as, the <ex>basset</ex>
edge of strata</as>.</def> <rj><au>Lyell.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Basset</ent><br/
<hw>Bas"set</hw>, <pos>n.</pos> <fld>(Geol.)</fld> <def>The edge of a
geological stratum at the surface of the ground; the outcrop.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Basset</ent><br/
<hw>Bas"set</hw>, <pos>v. i.</pos> <vmorph>[<pos>imp. & p. p.</pos>
<conjf>Basseted</conjf>; <pos>p. pr. & vb. n.</pos>
<conjf>Basseting</conjf>.]</vmorph> <fld>(Geol.)</fld> <def>To incline
upward so as to appear at the surface; to crop out; <as>as, a vein of
coal <ex>bassets</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Basseterre</ent><br/
<hw>Basseterre</hw> <pos>prop. n.</pos> <fld>(Geography)</fld> <def>The
capital <isa>city</isa> of <country>St. Kitts and Nevis</country>.
Population (2000) = 19,000.</def><br/
[<source>PJC</source>]</p>

<p><ent>Basset horn</ent><br/
<hw>Bas"set horn`</hw> <pr>(b<acr/s"s<ecr/t h<ocir/rn`)</pr>. <ety>[See
<er>Basset</er>, <pos>a.</pos>]</ety> <fld>(Mus.)</fld> <def>An
instrument blown with a reed, and resembling a clarinet, but of much
greater compass, embracing nearly four octaves; The corno di
bassetto.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Basset hound</ent><br/
<hw>Bas"set hound`</hw> <pr>(<?/)</pr>. <ety>[F.
<ets>basset</ets>.]</ety> <fld>(Zool.)</fld> <def>A small kind of hound
with a long body and short legs, used as an earth dog.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Basseting</ent><br/
<hw>Bas"set*ing</hw>, <pos>n.</pos> <def>The upward direction of a vein
in a mine; the emergence of a stratum at the surface.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bassetto</ent><br/
\'d8<hw>Bas*set"to</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[It.,
<pos>adj.</pos>, somewhat low; <pos>n.</pos>, counter tenor. See
<er>Basso</er>.]</ety> <fld>(Mus.)</fld> <def>A tenor or small bass
viol.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bass horn</ent><br/
<hw>Bass" horn"</hw> <pr>(<?/)</pr>. <fld>(Mus.)</fld> <def>A
modification of the bassoon, much deeper in tone.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>bassine</ent><br/
<hw>bassine</hw> <pos>n.</pos> <sn>1.</sn> <def>Coarse leaf fiber from
palmyra palms used in making brushes and brooms.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Bassinet</ent><br/
<hw>Bas"si*net</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[Cf. F.
<ets>bassinet</ets>, dim. of <ets>bassin</ets>. See <er>Basin</er>, and
cf. <er>Bascinet</er>.]</ety> <sn>1.</sn> <def>A wicker basket, with a
covering or hood over one end, in which young children are placed as in
a cradle.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>See <er>Bascinet</er>.</def> <rj><au>Lord
Lytton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Basso</ent><br/
\'d8<hw>Bas"so</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[It., fr. LL.
<ets>bassus</ets>. See <er>Base</er>, <pos>a.</pos>]</ety>
<fld>(Mus.)</fld> <sd>(a)</sd> <def>The bass or lowest part; <as>as, to
sing <ex>basso</ex></as>.</def> <sd>(b)</sd> <def>One who sings the
lowest part.</def> <sd>(c)</sd> <def>The double bass, or
<altname>contrabasso</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>\'d8Basso continuo</b></col> <pr>(<?/)</pr>. <ety>[It.,
bass continued.]</ety> <fld>(Mus.)</fld> <cd>A bass part written out
continuously, while the other parts of the harmony are indicated by
figures attached to the bass; continued bass.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bassock</ent><br/
<hw>Bas"sock</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>A hassock. See 2d
<er>Bass</er>, 2.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bassoon</ent><br/
<hw>Bas*soon"</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[F.
<ets>basson</ets>, fr. <ets>basse</ets> bass; or perh. fr. <ets>bas
son</ets> low sound. See <er>Bass</er> a part in music. ]</ety>
<fld>(Mus.)</fld> <def>A wind instrument of the double reed kind,
furnished with holes, which are stopped by the fingers, and by keys, as
in flutes. It forms the natural bass to the oboe, clarinet,
etc.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ Its compass comprehends three octaves. For convenience
of carriage it is divided into two parts; whence it is also called a
<xex>fagot</xex>.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bassoonist</ent><br/
<hw>Bas*soon"ist</hw>, <pos>n.</pos> <def>A performer on the
bassoon.</def> <rj><au>Busby.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Basso-relievo</ent><br/
<ent>Basso-rilievo</ent><br/
<mhw>{ \'d8<hw>Bas"so-ri*lie"vo</hw> <pr>(<?/)</pr>,
<hw>Bas"so-re*lie"vo</hw> }</mhw> <pr>(<?/)</pr>, <pos>n.</pos>
<ety>[It. <ets>basso-rilievo</ets>.]</ety> <def>Same as
<er>Bas-relief</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bassorin</ent><br/
<hw>Bas"so*rin</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[Cf. F.
<ets>bassorine</ets>.]</ety> <fld>(Chem.)</fld> <def>A constituent part
of a species of gum from <gen>Bassora</gen>, as also of gum tragacanth
and some gum resins. It is one of the amyloses.</def>
<rj><au>Ure.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bass-relief</ent><br/
<hw>Bass"-re*lief`</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>Same as
<er>Bas-relief</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bass viol</ent><br/
<hw>Bass" vi`ol</hw> <pr>(<?/)</pr>. <fld>(Mus.)</fld> <def>A stringed
instrument of the viol family, used for playing bass. See 3d
<er>Bass</er>, <pos>n.</pos>, and <er>Violoncello</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Basswood</ent><br/
<hw>Bass"wood`</hw> <pr>(<?/)</pr>, <pos>n.</pos> <fld>(Bot.)</fld>
<def>The bass (<gen>Tilia</gen>) or its wood; especially, <spn>Tilia
Americana</spn>. See <er>Bass</er>, the lime tree.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>All the bowls were made of <qex>basswood</qex>,<br/
White and polished very smoothly.</q>
<rj><qau>Longfellow.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bast</ent><br/
<hw>Bast</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[AS.
<ets>b<ae/st</ets>; akin to Icel., Sw., Dan., D., & G. <ets>bast</ets>,
of unknown origin. Cf. <er>Bass</er> the tree.]</ety> <sn>1.</sn>
<def>The inner fibrous bark of various plants; esp. of the lime tree;
hence, matting, cordage, etc., made therefrom.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A thick mat or hassock. See 2d <er>Bass</er>,
2.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Basta</ent><br/
\'d8<hw>Bas"ta</hw> <pr>(<?/)</pr>, <pos>interj.</pos> <ety>[It.]</ety>
<def>Enough; stop.</def> <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bastard</ent><br/
<hw>Bas"tard</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[OF.
<ets>bastard</ets>, <ets>bastart</ets>, F. <ets>b<acir/tard</ets>, prob.
fr. OF. <ets>bast</ets>, F. <ets>b<acir/t</ets>, a packsaddle used as a
bed by the muleteers (fr. LL. <ets>bastum</ets>) + <ets>-ard</ets>. OF.
fils de <ets>bast</ets> son of the packsaddle; as the muleteers were
accustomed to use their saddles for beds in the inns. See Cervantes,
<ldquo/Don Quixote,<rdquo/ chap. 16; and cf. G. <ets>bankert</ets>, fr.
<ets>bank</ets> bench.]</ety> <sn>1.</sn> <def>A <ldquo/natural<rdquo/
child; a child begotten and born out of wedlock; an illegitimate child;
one born of an illicit union.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ By the civil and canon laws, and by the laws of many of
the United States, a <xex>bastard</xex> becomes a legitimate child by
the intermarriage of the parents at any subsequent time. But by those of
England, and of some states of the United States, a child, to be
legitimate, must at least be <xex>born</xex> after the lawful
marriage.</note> <rj><au>Kent. Blackstone.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Sugar Refining)</fld> <sd>(a)</sd> <def>An inferior
quality of soft brown sugar, obtained from the sirups that have already
had several boilings.</def> <sd>(b)</sd> <def>A large size of mold, in
which sugar is drained.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>A sweet Spanish wine like muscatel in
flavor.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Brown <qex>bastard</qex> is your only drink.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>A writing paper of a particular size. See
<er>Paper</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bastard</ent><br/
<hw>Bas"tard</hw> <pr>(<?/)</pr>, <pos>a.</pos> <sn>1.</sn>
<def>Begotten and born out of lawful matrimony; illegitimate. See
<er>Bastard</er>, <pos>n.</pos>, note.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Lacking in genuineness; spurious; false; adulterate;
-- applied to things which resemble those which are genuine, but are
really not so.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>That <qex>bastard</qex> self-love which is so vicious in itself,
and productive of so many vices.</q> <rj><qau>Barrow.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Of an unusual or irregular make or proportion;
<as>as, a <ex>bastard</ex> musket; a <ex>bastard</ex>
culverin</as>.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <fld>(Print.)</fld> <def>Abbreviated, as the half title
in a page preceding the full title page of a book.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Bastard ashlar</b></col> <fld>(Arch.)</fld>, <cd>stones
for ashlar work, roughly squared at the quarry.</cd> -- <col><b>Bastard
file</b></col>, <cd>a file intermediate between the coarsest and the
second cut.</cd> -- <col><b>Bastard type</b></col> <fld>(Print.)</fld>,
<cd>type having the face of a larger or a smaller size than the body;
<it>e. g.</it>, a nonpareil face on a brevier body.</cd> --
<col><b>Bastard wing</b></col> <fld>(Zool.)</fld>, <cd>three to five
quill feathers on a small joint corresponding to the thumb in some
mammalia; the alula.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bastard</ent><br/
<hw>Bas"tard</hw>, <pos>v. t.</pos> <def>To bastardize.</def>
<mark>[Obs.]</mark> <rj><au>Bacon.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>bastardisation</ent><br/
<hw>bastardisation</hw> <pos>n.</pos> <def>An act that debases or
corrupts.</def> <mark>[chiefly Brit.]</mark><br/
<syn><b>Syn. --</b> bastardization.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>bastardise</ent><br/
<hw>bastardise</hw> <pos>v. t.</pos> <def>Same as
<er>bastardize</er>.</def> <mark>[chiefly Brit.]</mark><br/
[<source>PJC</source>]</p>

<p><ent>Bastardism</ent><br/
<hw>Bas"tard*ism</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>The state of
being a bastard; bastardy.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>bastardization</ent><br/
<hw>bastardization</hw> <pos>n.</pos> <def>An act that debases or
corrupts.</def><br/
<syn><b>Syn. --</b> bastardisation.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Bastardize</ent><br/
<hw>Bas"tard*ize</hw> <pr>(<?/)</pr>, <pos>v. t.</pos>
<vmorph>[<pos>imp. & p. p.</pos> <conjf>Bastardized</conjf> (<?/);
<pos>p. pr. & vb. n.</pos> <conjf>Bastardizing</conjf>.]</vmorph>
<sn>1.</sn> <def>To make or prove to be a bastard; to stigmatize as a
bastard; to declare or decide legally to be illegitimate.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The law is so indulgent as not to <qex>bastardize</qex> the child,
if born, though not begotten, in lawful wedlock.</q>
<rj><qau>Blackstone.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To beget out of wedlock.</def> <mark>[R.]</mark>
<rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>to change something (for example, art forms) so that
its value declines; to debase.</def><br/
<syn><b>Syn. --</b> bastardise.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>bastardized</ent><br/
<hw>bastardized</hw> <pos>adj.</pos> <fld>(Arts)</fld> <def>deriving
from more than one source or style.</def> <hascons>impure (vs. pure) ---
(combined with extraneous elements)</hascons><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Bastardly</ent><br/
<hw>Bas"tard*ly</hw>, <pos>a.</pos> <def>Bastardlike; baseborn;
spurious; corrupt.</def> <mark>[Obs.]</mark> -- <def2><pos>adv.</pos>
<def>In the manner of a bastard; spuriously.</def>
<mark>[Obs.]</mark></def2> <rj><au>Shak. Donne.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bastardy</ent><br/
<hw>Bas"tar*dy</hw> <pr>(<?/)</pr>, <pos>n.</pos> <sn>1.</sn> <def>The
state of being a bastard; illegitimacy.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The procreation of a bastard child.</def>
<rj><au>Wharton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baste</ent><br/
<hw>Baste</hw> <pr>(b<amac/st)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp.
& p. p.</pos> <conjf>Basted</conjf>; <pos>p. pr. & vb. n.</pos>
<conjf>Basting</conjf>.]</vmorph> <ety>[Cf. Icel. <ets>beysta</ets> to
strike, powder; Sw. <ets>basa</ets> to beat with a rod: perh. akin to E.
<ets>beat</ets>.]</ety> <sn>1.</sn> <def>To beat with a stick; to
cudgel.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>One man was <qex>basted</qex> by the keeper for carrying some
people over on his back through the waters.</q>
<rj><qau>Pepys.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Cookery)</fld> <def>To sprinkle flour and salt and
drip butter or fat on, as on meat in roasting.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To mark with tar, as sheep.</def> <mark>[Prov.
Eng.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baste</ent><br/
<hw>Baste</hw>, <pos>v. t.</pos> <ety>[OE. <ets>basten</ets>, OF.
<ets>bastir</ets>, F. <ets>b<acir/tir</ets>, prob. fr. OHG.
<ets>bestan</ets> to sew, MHG. <ets>besten</ets> to bind, fr. OHG.
<ets>bast</ets> bast. See <er>Bast</er>.]</ety> <def>To sew loosely, or
with long stitches; -- usually, that the work may be held in position
until sewed more firmly.</def> <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bastille</ent><br/
<ent>Bastile</ent><br/
<mhw>{ <hw>Bas*tile"</hw> <hw>Bas*tille"</hw> }</mhw>
<pr>(b<adot/s*t<emac/l" <it>or</it> b<adot/s"t<esl/l; 277)</pr>,
<pos>n.</pos> <ety>[F. <ets>bastille</ets> fortress, OF.
<ets>bastir</ets> to build, F. <ets>b<acir/tir</ets>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <fld>(Feud. Fort.)</fld> <def>A tower or an elevated
work, used for the defense, or in the siege, of a fortified
place.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The high <qex>bastiles</qex> . . . which overtopped the walls.</q>
<rj><qau>Holland.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def><ldquo/The Bastille<rdquo/, formerly a castle or
fortress in Paris, used as a prison, especially for political offenders;
hence, a rhetorical name for a prison.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bastinade</ent><br/
<hw>Bas`ti*nade"</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>See
<er>Bastinado</er>, <pos>n.</pos></def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bastinade</ent><br/
<hw>Bas`ti*nade"</hw>, <pos>v. t.</pos> <def>To bastinado.</def>
<mark>[Archaic]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bastinado</ent><br/
<hw>Bas`ti*na"do</hw> <pr>(<?/)</pr>, <pos>n.</pos>; <plu><it>pl.</it>
<plw>Bastinadoes</plw> <pr>(<?/)</pr>.</plu> <ety>[Sp.
<ets>bastonada</ets> (cf. F. <ets>bastonnade</ets>), fr.
<ets>baston</ets> (cf. F. <ets>b<acir/ton</ets>) a stick or staff. See
<er>Baston</er>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>A blow with a stick or cudgel.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A sound beating with a stick or cudgel.
Specifically: A form of punishment among the Turks, Chinese, and others,
consisting in beating an offender on the soles of his feet.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bastinado</ent><br/
<hw>Bas`ti*na"do</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos>
<conjf>Bastinadoed</conjf> <pr>(<?/)</pr>; <pos>p. pr. & vb. n.</pos>
<conjf>Bastinadoing</conjf>.]</vmorph> <def>To beat with a stick or
cudgel, especially on the soles of the feet.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>basting</ent><br/
<hw>basting</hw> <pos>n.</pos> <sn>1.</sn> <def>Loose temporary
stitches.</def><br/
<syn><b>Syn. --</b> baste, tacking.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><sn>2.</sn> <fld>(Cookery)</fld> <def>The act or process of
moistening a roast as it is cooking.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Bastion</ent><br/
<hw>Bas"tion</hw> <pr>(b<acr/s"ch<ucr/n; 106)</pr>, <pos>n.</pos>
<ety>[F. <ets>bastion</ets> (cf. It. <ets>bastione</ets>), fr. LL.
<ets>bastire</ets> to build (cf. F. <ets>b<acir/tir</ets>, It.
<ets>bastire</ets>), perh. from the idea of support for a weight, and
akin to Gr. <grk>basta`zein</grk> to lift, carry, and to E.
<ets>baston</ets>, <ets>baton</ets>.]</ety> <fld>(Fort.)</fld> <def>A
work projecting outward from the main inclosure of a fortification,
consisting of two faces and two flanks, and so constructed that it is
able to defend by a flanking fire the adjacent curtain, or wall which
extends from one bastion to another. Two adjacent <xex>bastions</xex>
are connected by the <xex>curtain</xex>, which joins the flank of one
with the adjacent flank of the other. The distance between the flanks of
a bastion is called the <xex>gorge</xex>. A <xex>lunette</xex> is a
detached bastion. See <er>Ravelin</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bastioned</ent><br/
<hw>Bas"tioned</hw> <pr>(<?/)</pr>, <pos>a.</pos> <def>Furnished with a
bastion; having bastions.</def><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 124 pr=SA --></p>

<p><ent>Basto</ent><br/
<hw>Bas"to</hw> <pr>(b<adot/s"t<osl/)</pr>, <pos>n.</pos>
<ety>[Sp.]</ety> <def>The ace of clubs in quadrille and omber.</def>
<rj><au>Pope.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baston</ent><br/
<hw>Bas"ton</hw> <pr>(b<acr/s"t<ucr/n)</pr>, <pos>n.</pos> <ety>[OF.
<ets>baston</ets>, F. <ets>b<acir/ton</ets>, LL. <ets>basto</ets>. See
<er>Bastion</er>, and cf. <er>Baton</er>, and 3d
<er>Batten</er>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>A staff or cudgel.</def> <mark>[Obs.]</mark>
<ldquo/To fight with blunt <xex>bastons</xex>.<rdquo/
<rj><au>Holland.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Her.)</fld> <def>See <er>Baton</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>An officer bearing a painted staff, who formerly was
in attendance upon the king's court to take into custody persons
committed by the court.</def> <rj><au>Mozley & W.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Basutos</ent><br/
<hw>Ba*su"tos</hw> <pr>(?)</pr>, <pos>n. pl.</pos>; <sing><it>sing.</it>
<singw>Basuto</singw> <pr>(<?/)</pr>.</sing> <fld>(Ethnol.)</fld> <def>A
warlike South African people of the Bantu stock, divided into many
tribes, at one time subjected by the English. They formerly practiced
cannibalism, but have now adopted many European customs.</def><br/
[<source>Webster 1913 Suppl.</source> <source>+PJC</source>]</p>

<p><ent>Basyle</ent><br/
<hw>Bas"yle</hw> <pr>(b<acr/s"<icr/l <it>or</it> b<amac/s"<icr/l)</pr>,
<pos>n.</pos> <ety>[Gr. <grk>ba`sis</grk> base + <grk>"y`lh</grk> wood.
See <er>-yl</er>.]</ety> <fld>(Chem.)</fld> <def>A positive or nonacid
constituent of compound, either elementary, or, if compound, performing
the functions of an element.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Basylous</ent><br/
<hw>Bas"y*lous</hw> <pr>(<?/)</pr>, <pos>a.</pos> <def>Pertaining to, or
having the nature of, a basyle; electro-positive; basic; -- opposed to
<contr>chlorous</contr>.</def> <rj><au>Graham.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bat</ent><br/
<hw>Bat</hw> <pr>(b<acr/t)</pr>, <pos>n.</pos> <ety>[OE.
<ets>batte</ets>, <ets>botte</ets>, AS. <ets>batt</ets>; perhaps fr. the
Celtic; cf. Ir. <ets>bat</ets>, <ets>bata</ets>, stick, staff; but cf.
also F. <ets>batte</ets> a beater (thing), wooden sword,
<ets>battre</ets> to beat.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>A large stick; a club; specifically, a piece of wood
with one end thicker or broader than the other, used in playing
baseball, cricket, etc.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>In badminton, tennis, and similar games, a
racket.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><sn>3.</sn> <def>A sheet of cotton used for filling quilts or
comfortables; batting.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>A part of a brick with one whole end; a
brickbat.</def><br/
[<source>1913 Webster</source> <source>+PJC</source>]</p>

<p><sn>5.</sn> <fld>(Mining)</fld> <def>Shale or bituminous shale.</def>
<rj><au>Kirwan.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <def>A stroke; a sharp blow.</def> <mark>[Colloq. or
Slang]</mark><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><sn>7.</sn> <def>A stroke of work.</def> <mark>[Scot. & Prov.
Eng.]</mark><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><sn>8.</sn> <def>Rate of motion; speed.</def> <mark>[Colloq.]</mark>
<ldquo/A vast host of fowl . . . making at full <xex>bat</xex> for the
North Sea.<rdquo/ <rj><au>Pall Mall Mag.</au></rj><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><sn>9.</sn> <def>A spree; a jollification.</def> <mark>[Slang, U.
S.]</mark><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><sn>10.</sn> <def>Manner; rate; condition; state of health.</def>
<mark>[Scot. & Prov. Eng.]</mark><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><cs><col><b>Bat bolt</b></col> <fld>(Machinery)</fld>, <cd>a bolt
barbed or jagged at its butt or tang to make it hold the more
firmly.</cd> <rj><au>Knight.</au></rj></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bat</ent><br/
<hw>Bat</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos>
<conjf>Batted</conjf> <pr>(b<acr/t"t<ecr/d)</pr>; <pos>p. pr. & vb.
n.</pos> <conjf>Batting</conjf>.]</vmorph> <def>To strike or hit with a
bat or a pole; to cudgel; to beat.</def> <rj><au>Holland.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bat</ent><br/
<hw>Bat</hw>, <pos>v. i.</pos> <def>To use a bat, as in a game of
baseball; when used with a numerical postmodifier it indicates a
baseball player's performance (as a decimal) at bat; <as>as, he
<ex>batted</ex> .270 in 1993 (i.e. he got safe hits in 27 percent of his
official turns at bat)</as>.</def><br/
[<source>1913 Webster</source> <source>+PJC</source>]</p>

<p><ent>Bat</ent><br/
<hw>Bat</hw>, <pos>v. t. & i.</pos> <sn>1.</sn> <def>To bate or flutter,
as a hawk.</def> <mark>[Obs. or Prov. Eng.]</mark><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><sn>2.</sn> <def>To wink.</def> <mark>[Local, U. S. & Prov
Eng.]</mark><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Bat</ent><br/
<hw>Bat</hw>, <pos>n.</pos> <ety>[Corrupt. from OE. <ets>back</ets>,
<ets>backe</ets>, <ets>balke</ets>; cf. Dan. aften-<ets>bakke</ets>
(<tran>aften</tran> evening), Sw. natt-<ets>backa</ets>
(<tran>natt</tran> night), Icel. le<edh/r-<ets>blaka</ets>
(<tran>le<edh/r</tran> leather), Icel. <ets>blaka</ets> to
flutter.]</ety> <fld>(Zool.)</fld> <def>One of the
<ord>Chiroptera</ord>, an order of flying mammals, in which the wings
are formed by a membrane stretched between the elongated fingers, legs,
and tail. The common bats are small and insectivorous. See
<er>Chiroptera</er> and <er>Vampire</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Silent <qex>bats</qex> in drowsy clusters cling.</q>
<rj><qau>Goldsmith.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Bat tick</b></col> <fld>(Zool.)</fld>, <cd>a wingless,
dipterous insect of the genus <gen>Nycteribia</gen>, parasitic on
bats.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bat</ent><br/
\'d8<hw>Bat</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Siamese.]</ety>
<def>Same as <er>Tical</er>, <pos>n.</pos>, 1.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Batable</ent><br/
<hw>Bat"a*ble</hw> <pr>(<?/)</pr>, <pos>a.</pos> <ety>[Abbrev. from
<ets>debatable</ets>.]</ety> <def>Disputable.</def>
<mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ The border land between England and Scotland, being
formerly a subject of contention, was called <xex>batable</xex> or
<xex>debatable</xex> ground.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Batailled</ent><br/
<hw>Bat"ailled</hw> <pr>(<?/)</pr>, <pos>a.</pos> <def>Embattled.</def>
<mark>[Obs.]</mark> <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Batardeau</ent><br/
\'d8<hw>Ba`tar*deau"</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[F.]</ety>
<sn>1.</sn> <def>A cofferdam.</def> <rj><au>Brande & C.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Mil.)</fld> <def>A wall built across the ditch of a
fortification, with a sluice gate to regulate the height of water in the
ditch on both sides of the wall.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Batata</ent><br/
<ent>Batatas</ent><br/
<mhw>{ \'d8<hw>Ba*ta"tas</hw> <pr>(<?/)</pr>, \'d8<hw>Ba*ta"ta</hw>
<pr>(<?/)</pr>, }</mhw> <pos>n.</pos> <def>An aboriginal American name
for the sweet potato (<spn>Ipom<ae/a batatas</spn>).</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Batavian</ent><br/
<hw>Ba*ta"vi*an</hw> <pr>(<?/)</pr>, <pos>a.</pos> <sn>1.</sn> <def>Of
or pertaining to the Batavi, an ancient Germanic tribe.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Of or pertaining to Batavia or Holland; <as>as, a
<ex>Batavian</ex> legion</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Batavian Republic</b></col>, <cd>the name given to
Holland by the French after its conquest in 1795.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Batavian</ent><br/
<hw>Ba*ta"vi*an</hw>, <pos>n.</pos> <def>A native or inhabitant of
Batavia or Holland.</def> <mark>[R.]</mark>
<rj><au>Bancroft.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>batboy</ent><br/
<hw>bat"boy`</hw> <pr>(b<acr/t"boi`)</pr>, <pos>n.</pos>
<fld>(Baseball)</fld> <def>A boy who holds the bats and presents the bat
to a batter when the batter is going to the batter's box to bat. The
batboy sometimes also keeps other team equipment.</def><br/
[<source>PJC</source>]</p>

<p><ent>Batch</ent><br/
<hw>Batch</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[OE. <ets>bache</ets>,
<ets>bacche</ets>, fr. AS. <ets>bacan</ets> to bake; cf. G.
<ets>geb<aum/ck</ets> and D. <ets>baksel</ets>. See <er>Bake</er>,
<pos>v. t.</pos>]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>The quantity of bread baked at one time.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A quantity of anything produced at one operation; a
group or collection of persons or things of the same kind; <as>as, a
<ex>batch</ex> of letters; the next <ex>batch</ex> of
business</as>.</def> <ldquo/A new <xex>batch</xex> of Lords.<rdquo/
<rj><au>Lady M. W. Montagu.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bate</ent><br/
<hw>Bate</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[Prob. abbrev. from
<ets>debate</ets>.]</ety> <def>Strife; contention.</def>
<mark>[Obs.]</mark> <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bate</ent><br/
<hw>Bate</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos>
<conjf>Bated</conjf>; <pos>p. pr. & vb. n.</pos>
<conjf>Bating</conjf>.]</vmorph> <ety>[From <ets>abate</ets>.]</ety>
<sn>1.</sn> <def>To lessen by retrenching, deducting, or reducing; to
abate; to beat down; to lower.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>He must either <qex>bate</qex> the laborer's wages, or not employ
or not pay him.</q> <rj><qau>Locke.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To allow by way of abatement or deduction.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>To whom he <qex>bates</qex> nothing of what he stood upon with the
parliament.</q> <rj><qau>South.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To leave out; to except.</def>
<mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>Bate</qex> me the king, and, be he flesh and blood,<br/
He lies that says it.</q> <rj><qau>Beau. & Fl.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>To remove.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>About autumn <qex>bate</qex> the earth from about the roots of
olives, and lay them bare.</q> <rj><qau>Holland.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>To deprive of.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>When baseness is exalted, do not <qex>bate</qex><br/
The place its honor for the person's sake.</q>
<rj><qau>Herbert.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bate</ent><br/
<hw>Bate</hw>, <pos>v. i.</pos> <sn>1.</sn> <def>To remit or retrench a
part; -- with <xex>of</xex>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Abate thy speed, and I will <qex>bate</qex> of mine.</q>
<rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To waste away.</def> <mark>[Obs.]</mark>
<rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bate</ent><br/
<hw>Bate</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <def>To attack; to
bait.</def> <mark>[Obs.]</mark> <rj><au>Spenser.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bate</ent><br/
<hw>Bate</hw>, <def><pos>imp.</pos> of <er>Bite</er>.</def>
<mark>[Obs.]</mark> <rj><au>Spenser.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bate</ent><br/
<hw>Bate</hw>, <pos>v. i.</pos> <ety>[F. <ets>battre des ailes</ets> to
flutter. Cf. <er>Bait</er> to flutter.]</ety> <def>To flutter as a hawk;
to bait.</def> <mark>[Obs.]</mark> <rj><au>Bacon.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bate</ent><br/
<hw>Bate</hw>, <pos>n.</pos> <fld>(Jewish Antiq.)</fld> <def>See 2d
<er>Bath</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bate</ent><br/
<hw>Bate</hw>, <pos>n.</pos> <ety>[Cf. Sw. <ets>beta</ets> maceration,
soaking, G. <ets>beize</ets>, and E. <ets>bite</ets>.]</ety> <def>An
alkaline solution consisting of the dung of certain animals; -- employed
in the preparation of hides; grainer.</def>
<rj><au>Knight.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bate</ent><br/
<hw>Bate</hw>, <pos>v. t.</pos> <def>To steep in bate, as hides, in the
manufacture of leather.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bateau</ent><br/
\'d8<hw>Ba*teau"</hw> <pr>(<?/)</pr>, <pos>n.</pos>; <plu><it>pl.</it>
<plw>Bateaux</plw> <pr>(<?/)</pr>.</plu> <ety>[F. <ets>bateau</ets>, LL.
<ets>batellus</ets>, fr. <ets>battus</ets>, <ets>batus</ets>, boat,
which agrees with AS. <ets>b<amac/t</ets> boat: cf. W. <ets>bad</ets>
boat. See <er>Boat</er>, <pos>n.</pos>]</ety> <def>A boat; esp. a
flat-bottomed, clumsy boat used on the Canadian lakes and rivers.</def>
<altsp>[Written also, but less properly,
<asp>batteau</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Bateau bridge</b></col>, <cd>a floating bridge supported
by bateaux.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bated</ent><br/
<hw>Bat"ed</hw> <pr>(<?/)</pr>, <pos>a.</pos> <def>Reduced; lowered;
restrained; <as>as, to speak with <ex>bated</ex> breath</as>.</def>
<rj><au>Macaulay.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bateful</ent><br/
<hw>Bate"ful</hw> <pr>(<?/)</pr>, <pos>a.</pos> <def>Exciting
contention; contentious.</def> <mark>[Obs.]</mark> <ldquo/It did
<xex>bateful</xex> question frame.<rdquo/ <rj><au>Sidney.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bateless</ent><br/
<hw>Bate"less</hw>, <pos>a.</pos> <def>Not to be abated.</def>
<mark>[Obs.]</mark> <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Batement</ent><br/
<hw>Bate"ment</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[For
<er>Abatement</er>. See 2d <er>Bate</er>.]</ety> <def>Abatement;
diminution.</def> <rj><au>Moxon.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Batement light</b></col> <fld>(Arch.)</fld>, <cd>a window
or one division of a window having vertical sides, but with the sill not
horizontal, as where it follows the rake of a staircase.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Batfish</ent><br/
<hw>Bat"fish`</hw> <pr>(<?/)</pr>, <pos>n.</pos> <fld>(Zool.)</fld>
<def>A name given to several species of fishes:</def> <sd>(a)</sd>
<def>The <spn>Malthe vespertilio</spn> of the Atlantic coast.</def>
<sd>(b)</sd> <def>The flying gurnard of the Atlantic
(<spn>Cephalacanthus spinarella</spn>).</def> <sd>(c)</sd> <def>The
California batfish or sting ray (<spn>Myliobatis
Californicus</spn>.)</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Batfowler</ent><br/
<hw>Bat"fowl`er</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>One who
practices or finds sport in batfowling.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Batfowling</ent><br/
<hw>Bat"fowl`ing</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[From
<er>Bat</er> a stick.]</ety> <def>A mode of catching birds at night, by
holding a torch or other light, and beating the bush or perch where they
roost. The birds, flying to the light, are caught with nets or
otherwise.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Batful</ent><br/
<hw>Bat"ful</hw> <pr>(b<acr/t"f<usdot/l)</pr>, <pos>a.</pos> <ety>[Icel.
<ets>bati</ets> amelioration, <ets>batna</ets> to grow better; akin to
AS. <ets>bet</ets> better. Goth. <ets>ga-batnan</ets> to profit.
<root/255. Cf. <er>Batten</er>, <pos>v. i.</pos>,
<er>Better</er>.]</ety> <def>Rich; fertile.</def> <mark>[Obs.]</mark>
<ldquo/<xex>Batful</xex> valleys.<rdquo/ <rj><au>Drayton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bath</ent><br/
<hw>Bath</hw> <pr>(b<adot/th; 61)</pr>, <pos>n.</pos>; <plu><it>pl.</it>
<plw>Baths</plw> <pr>(b<adot/<th/z)</pr>.</plu> <ety>[AS.
<ets>b<ae/<edh/</ets>; akin to OS. & Icel. <ets>ba<edh/</ets>, Sw.,
Dan., D., & G. <ets>bad</ets>, and perh. to G. <ets>b<aum/hen</ets> to
foment.]</ety> <sn>1.</sn> <def>The act of exposing the body, or part of
the body, for purposes of cleanliness, comfort, health, etc., to water,
vapor, hot air, or the like; <as>as, a cold or a hot <ex>bath</ex>; a
medicated <ex>bath</ex>; a steam <ex>bath</ex>; a hip
<ex>bath</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Water or other liquid for bathing.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>A receptacle or place where persons may immerse or
wash their bodies in water.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>A building containing an apartment or a series of
apartments arranged for bathing.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Among the ancients, the public <qex>baths</qex> were of amazing
extent and magnificence.</q> <rj><qau>Gwilt.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <fld>(Chem.)</fld> <def>A medium, as heated sand, ashes,
steam, hot air, through which heat is applied to a body.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <fld>(Photog.)</fld> <def>A solution in which plates or
prints are immersed; also, the receptacle holding the
solution.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ <xex>Bath</xex> is used adjectively or in combination,
in an obvious sense <xex>of</xex> or <xex>for baths</xex> or
<xex>bathing</xex>; as, <xex>bath</xex>room, <xex>bath</xex> tub,
<xex>bath</xex> keeper.</note><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Douche bath</b></col>. <cd>See <er>Douche</er>.</cd> --
<col><b>Order of the Bath</b></col>, <cd>a high order of British
knighthood, composed of three classes, viz., knights grand cross,
knights commanders, and knights companions, abbreviated thus: G. C. B.,
K. C. B., K. B.</cd> -- <col><b>Russian bath</b></col>, <cd>a kind of
vapor bath which consists in a prolonged exposure of the body to the
influence of the steam of water, followed by washings and
shampooings.</cd> -- <col><b>Turkish bath</b></col>, <cd>a kind of bath
in which a profuse perspiration is produced by hot air, after which the
body is washed and shampooed.</cd> -- <col><b>Bath house</b></col>,
<cd>a house used for the purpose of bathing; -- also a small house, near
a bathing place, where a bather undresses and dresses.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bath</ent><br/
<hw>Bath</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[Heb.]</ety> <def>A
Hebrew measure containing the tenth of a homer, or five gallons and
three pints, as a measure for liquids; and two pecks and five quarts, as
a dry measure.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bath</ent><br/
<hw>Bath</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>A city in the west of
England, resorted to for its hot springs, which has given its name to
various objects.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Bath brick</b></col>, <cd>a preparation of calcareous
earth, in the form of a brick, used for cleaning knives, polished metal,
etc.</cd> -- <col><b>Bath chair</b></col>, <cd>a kind of chair on
wheels, as used by invalids at Bath.</cd> <ldquo/People walked out, or
drove out, or were pushed out in their <xex>Bath chairs</xex>.<rdquo/
<au>Dickens.</au> -- <col><b>Bath metal</b></col>, <cd>an alloy
consisting of four and a half ounces of zinc and one pound of
copper.</cd> -- <col><b>Bath note</b></col>, <cd>a folded writing paper,
8 1/2 by 14 inches.</cd> -- <col><b>Bath stone</b></col>, <cd>a species
of limestone (o<oum/lite) found near Bath, used for
building.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bathe</ent><br/
<hw>Bathe</hw> <pr>(b<amac/<th/)</pr>, <pos>v. t.</pos>
<vmorph>[<pos>imp. & p. p.</pos> <conjf>Bathed</conjf>
<pr>(b<amac/<th/d)</pr>; <pos>p. pr. & vb. n.</pos>
<conjf>Bathing</conjf>.]</vmorph> <ety>[OE. <ets>ba<edh/ien</ets>, AS.
<ets>ba<edh/ian</ets>, fr. <ets>b<ae/<edh/</ets> bath. See 1st
<er>Bath</er>, and cf. <er>Bay</er> to bathe.]</ety> <sn>1.</sn> <def>To
wash by immersion, as in a bath; to subject to a bath.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Chancing to <qex>bathe</qex> himself in the River Cydnus.</q>
<rj><qau>South.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To lave; to wet.</def> <ldquo/The lake which
<xex>bathed</xex> the foot of the Alban mountain.<rdquo/ <rj><au>T.
Arnold.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To moisten or suffuse with a liquid.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>And let us <qex>bathe</qex> our hands in C<ae/sar's blood.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>To apply water or some liquid medicament to; <as>as,
to <ex>bathe</ex> the eye with warm water or with sea water; to
<ex>bathe</ex> one's forehead with camphor</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>To surround, or envelop, as water surrounds a person
immersed.</def> <ldquo/The rosy shadows <xex>bathe</xex> me. <rdquo/
<au>Tennyson.</au> <ldquo/The bright sunshine <xex>bathing</xex> all the
world.<rdquo/ <au>Longfellow.</au><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bathe</ent><br/
<hw>Bathe</hw> <pr>(<?/)</pr>, <pos>v. i.</pos> <sn>1.</sn> <def>To
bathe one's self; to take a bath or baths.</def> <ldquo/They
<xex>bathe</xex> in summer.<rdquo/ <rj><au>Waller.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To immerse or cover one's self, as in a bath.</def>
<ldquo/To <xex>bathe</xex> in fiery floods.<rdquo/ <au>Shak.</au>
<ldquo/<xex>Bathe</xex> in the dimples of her cheek.<rdquo/
<au>Lloyd.</au><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To bask in the sun.</def> <mark>[Obs.]</mark>
<rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bathe</ent><br/
<hw>Bathe</hw>, <pos>n.</pos> <def>The immersion of the body in water;
<as>as, to take one's usual <ex>bathe</ex></as>.</def> <rj><au>Edin.
Rev.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bather</ent><br/
<hw>Bath"er</hw> <pr>(b<amac/<th/"<etil/r)</pr>, <pos>n.</pos> <def>One
who bathes.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bathetic</ent><br/
<hw>Ba*thet"ic</hw> <pr>(<?/)</pr>, <pos>a.</pos> <def>Having the
character of bathos.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>bathhouse</ent><br/
<hw>bathhouse</hw> <pos>n.</pos> <sn>1.</sn> <def>a building containing
dressing rooms for bathers.</def><br/
<syn><b>Syn. --</b> bathing machine.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><sn>2.</sn> <def>a building containing public baths.</def><br/
<syn><b>Syn. --</b> bagnio.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Bathing</ent><br/
<hw>Bath"ing</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>Act of taking a
bath or baths.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Bathing machine</b></col>, <cd>a small room on wheels, to
be driven into the water, for the convenience of bathers, who undress
and dress therein.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bathmism</ent><br/
<hw>Bath"mism</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>See <er>Vital
force</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>batholite</ent><br/
<hw>batholite</hw> <pos>n.</pos> <def>A large mass of intrusive igneous
rock believed to have solidified deep within the earth.</def><br/
<syn><b>Syn. --</b> batholith, pluton, plutonic rock.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>batholith</ent><br/
<hw>bath"o*lith</hw> <pr>(b<acr/th"<osl/*l<icr/th)</pr>, <pos>n.</pos>
<ety>[Gr. <grk>baqo`s</grk> depth + <ets>-lith</ets>.]</ety> <def>A
large mass of intrusive igneous rock believed to have solidified deep
within the earth.</def><br/
<syn><b>Syn. --</b> batholite, pluton, plutonic rock.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>batholithic</ent><br/
<hw>batholithic</hw> <pos>adj.</pos> <def>Of or pertaining to a
batholith.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Bathometer</ent><br/
<hw>Ba*thom"e*ter</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[Gr.
<grk>baqo`s</grk> depth + <ets>-meter</ets>.]</ety> <def>An instrument
for measuring depths, esp. one for taking soundings without a sounding
line.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bathorse</ent><br/
<hw>Bat"horse`</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[F.
<ets>b<acir/t</ets> packsaddle (cheval de <ets>b<acir/t</ets> packhorse)
+ E. <ets>horse</ets>. See <er>Bastard</er>.]</ety> <def>A horse which
carries an officer's baggage during a campaign.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bathos</ent><br/
<hw>Ba"thos</hw> <pr>(b<amac/"th<ocr/s)</pr>, <pos>n.</pos> <ety>[Gr.
<grk>ba`qos</grk> depth, fr. <grk>baqy`s</grk> deep.]</ety>
<fld>(Rhet.)</fld> <def>A ludicrous descent from the elevated to the
low, in writing or speech; anticlimax.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>bath-towel</ent><br/
<ent>bath towel</ent><br/
<mhw><hw>bath towel</hw>, <hw>bath-towel</hw></mhw> <pos>n.</pos> <def>a
large towel used to dry oneself after a bath.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>bathtub</ent><br/
<hw>bath"tub</hw> <pos>n.</pos> <def>A relatively large tub used to take
a bath, usually a permanent fixture in a bathroom; it is an open
container that is filled with water, in which a person immerses himself
for the purpose of washing the body.</def><br/
<syn><b>Syn. --</b> bath, tub.</syn><br/
[<source>WordNet 1.5</source> <source>+PJC</source>]</p>

<p><ent>bathyal</ent><br/
<hw>bathyal</hw> <pos>adj.</pos> <def>of or pertaining to
bathymetry.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Bathybius</ent><br/
\'d8<hw>Ba*thyb"i*us</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[NL., fr.
Gr. <grk>baqy`s</grk> deep + <grk>bi`os</grk> life]</ety>
<fld>(Zool.)</fld> <def>A name given by <person>Prof. Huxley</person> to
a gelatinous substance found in mud dredged from the Atlantic and
preserved in alcohol. He supposed that it was free living protoplasm,
covering a large part of the ocean bed. It is now known that the
substance is of chemical, not of organic, origin.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bathyergidae</ent><br/
<hw>Bath`y*erg"id*ae</hw> <pos>n.</pos> <def>a natural family including
the mole rats and sand rats.</def><br/
<syn><b>Syn. --</b> family <fam>Bathyergidae</fam>.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Bathyergus</ent><br/
<hw>Bath`y*erg"us</hw> <pos>n.</pos> <def>a genus consisting of the mole
rats.</def><br/
<syn><b>Syn. --</b> genus <gen>Bathyergus</gen>.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Bathygraphic</ent><br/
<hw>Bath`y*graph"ic</hw> <pr>(?)</pr>, <pos>a.</pos> <ety>[Gr.
<grk>baqy`s</grk> deep + <ets>graphic</ets>.]</ety> <def>Descriptive of
the ocean depth; <as>as, a <ex>bathygraphic</ex> chart</as>.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Bathymetrical</ent><br/
<ent>Bathymetric</ent><br/
<mhw>{ <hw>Bath`y*met"ric</hw> <pr>(<?/)</pr>,
<hw>Bath`y*met"ric*al</hw> <pr>(<?/)</pr>, }</mhw> <pos>a.</pos>
<def>Pertaining to bathymetry; relating to the measurement of depths,
especially of depths in the sea.</def> --
<wordforms><wf>Bath`y*met"ric*al*ly</wf>,
<pos>adv.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bathymetry</ent><br/
<hw>Ba*thym"e*try</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[Gr.
<grk>ba`qos</grk> depth + <ets>-metry</ets>.]</ety> <def>The art or
science of sounding, or measuring depths in the sea.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>bathyscaphe</ent><br/
<ent>bathyscaph</ent><br/
<mhw><hw>bath"y*scaph</hw>, <hw>bath"y*scaphe</hw></mhw> <pos>n.</pos>
<def>navigable deep diving vessel for underwater exploration.</def><br/
<syn><b>Syn. --</b> bathyscape.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>bathysphere</ent><br/
<hw>bath"y*sphere</hw> <pos>n.</pos> <def>a spherical deep diving
apparatus (lowered by a cable) for underwater exploration; it is
constructed with a strong steel shell to withstand high pressures at the
ocean bottom.</def><br/
[<source>WordNet 1.5</source> <source>+PJC</source>]</p>

<p><ent>Batidaceae</ent><br/
<hw>Batidaceae</hw> <pos>n.</pos> <def>a natural family coextensive with
genus <gen>Batis</gen>; the saltworts.</def><br/
<syn><b>Syn. --</b> family <fam>Batidaceae</fam>, saltwort
family.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>batik</ent><br/
<hw>batik</hw> <pos>n.</pos> <sn>1.</sn> <def>A dyed fabric with designs
drawn on by applying a removable wax where the dye is not
wanted.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><sn>2.</sn> <def>The method used to create a batik{1}; using wax to
allow drawing or printing of designs on a fabric.</def><br/
[<source>PJC</source>]</p>

<p><ent>Bating</ent><br/
<hw>Bat"ing</hw> <pr>(<?/)</pr>, <pos>prep.</pos> <ety>[Strictly p. pr.
of <er>Bate</er> to abate.]</ety> <def>With the exception of;
excepting.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>We have little reason to think that they bring many ideas with
them, <qex>bating</qex> some faint ideas of hunger and thirst.</q>
<rj><qau>Locke.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Batis</ent><br/
<hw>Batis</hw> <pos>n.</pos> <def>A small genus of plants constituting
the family <fam>Batidaceae</fam>: low straggling dioecious
shrubs.</def><br/
<syn><b>Syn. --</b> genus <gen>Batis</gen>.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Batiste</ent><br/
<hw>Ba*tiste"</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[F.
<ets>batiste</ets>, from the name of the alleged first maker,
<etsep>Baptiste</etsep> of Cambrai. <au>Littr<eacute/.</au>]</ety>
<def>Originally, cambric or lawn of fine linen; now applied also to
cloth of similar texture made of cotton.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Batlet</ent><br/
<hw>Bat"let</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[<ets>Bat</ets>
stick + <ets>-let</ets>.]</ety> <def>A short bat for beating clothes in
washing them; -- called also <altname>batler</altname>, <altname>batling
staff</altname>, <altname>batting staff</altname>.</def>
<rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Batman</ent><br/
\'d8<hw>Bat"man</hw> <pr>(b<acr/t"m<acr/n)</pr>, <pos>n.</pos>
<ety>[Turk. <ets>ba<tsdot/man</ets>.]</ety> <def>A weight used in the
East, varying according to the locality; in Turkey, the greater batman
is about 157 pounds, the lesser only a fourth of this; at Aleppo and
Smyrna, the batman is 17 pounds.</def> <rj><au>Simmonds.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Batman</ent><br/
<hw>Bat"man</hw> <pr>(b<add/"m<ait/n <it>or</it> b<acr/t"m<ait/n)</pr>,
<pos>n.</pos>; <plu><it>pl.</it> <plw>Batmen</plw>
<pr>(b<acr/t"m<eit/n)</pr>.</plu> <ety>[F. <ets>b<acir/t</ets>
packsaddle + E. <ets>man</ets>. Cf. <er>Bathorse</er>.]</ety> <def>A man
who has charge of a bathorse and his load.</def>
<rj><au>Macaulay.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Batoidei</ent><br/
\'d8<hw>Ba*toi"de*i</hw> <pr>(<?/)</pr>, <pos>n. pl.</pos> <ety>[NL.,
fr. Gr. <grk>ba`tos</grk> a kind of ray + <ets>-oid</ets>.]</ety>
<fld>(Zool.)</fld> <def>The division of fishes which includes the rays
and skates.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baton</ent><br/
<hw>Bat"on</hw> <pr>(b<acr/t"<ucr/n, F. b<aum/`t<ocir/N"; 277)</pr>,
<pos>n.</pos> <ety>[F. <ets>b<acir/ton</ets>. See
<er>Baston</er>.]</ety> <sn>1.</sn> <def>A staff or truncheon, used for
various purposes; <as>as, the <ex>baton</ex> of a field marshal; the
<ex>baton</ex> of a conductor in musical performances</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>He held the <qex>baton</qex> of command.</q>
<rj><qau>Prescott.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Her.)</fld> <def>An ordinary with its ends cut off,
borne sinister as a mark of bastardy, and containing one fourth in
breadth of the bend sinister; -- called also <altname>bastard
bar</altname>. See <er>Bend sinister</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Batoon</ent><br/
<hw>Ba*toon"</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>See <er>Baton</er>,
and <er>Baston</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bat printing</ent><br/
<hw>Bat" print`ing</hw> <pr>(<?/)</pr>. <fld>(Ceramics)</fld> <def>A
mode of printing on glazed ware.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Batrachia</ent><br/
\'d8<hw>Ba*tra"chi*a</hw> <pr>(<?/)</pr>, <pos>n. pl.</pos> <ety>[NL.,
fr. Gr. <grk>batra`cheios</grk> belonging to a frog, fr.
<grk>ba`trachos</grk> frog.]</ety> <fld>(Zool.)</fld> <def>The order of
amphibians which includes the frogs and toads; the Anura. Sometimes the
word is used in a wider sense as equivalent to Amphibia.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Batrachian</ent><br/
<hw>Ba*tra"chi*an</hw> <pr>(<?/)</pr>, <pos>a.</pos> <fld>(Zool.)</fld>
<def>Pertaining to the Batrachia.</def> -- <def2><pos>n.</pos> <def>One
of the Batrachia.</def></def2><br/
[<source>1913 Webster</source>]</p>

<p><ent>Batrachoid</ent><br/
<hw>Bat"ra*choid</hw> <pr>(<?/)</pr>, <pos>a.</pos>
<ety>[<ets>Batrachia</ets> + <ets>-oid</ets>.]</ety> <fld>(Zool.)</fld>
<def>Froglike. Specifically: Of or pertaining to the
<spn>Batrachid<ae/</spn>, a family of marine fishes, including the
toadfish. Some have poisonous dorsal spines.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Batrachomyomachy</ent><br/
<hw>Bat`ra*cho*my*om"a*chy</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[Gr.
<grk>batrachomyomachi`a</grk>; <grk>ba`trachos</grk> frog +
<grk>my^s</grk> mouse + <grk>ma`chh</grk> battle.]</ety> <def>The battle
between the frogs and mice; -- a Greek parody on the Iliad, of uncertain
authorship.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Batrachophagous</ent><br/
<hw>Bat`ra*choph"a*gous</hw> <pr>(<?/)</pr>, <pos>a.</pos> <ety>[Gr.
<grk>ba`trachos</grk> frog + <grk>fagei^n</grk> to eat.]</ety>
<def>Feeding on frogs.</def> <rj><au>Quart. Rev.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>bats</ent><br/
<hw>bats</hw> <pr>(b<acr/ts)</pr>, <pos>a.</pos> <def>Crazy; insane;
loony; demented; batty.</def><br/
[<source>PJC</source>]</p>

<p><ent>Batsman</ent><br/
<hw>Bats"man</hw> <pr>(<?/)</pr>, <pos>n.</pos>; <plu><it>pl.</it>
<plw>Batsmen</plw> <pr>(<?/)</pr>.</plu> <def>The one who wields the bat
in cricket, baseball, etc.; in baseball, the <ex>batsman</ex> is usually
called the <altname>batter</altname>.</def><br/
[<source>1913 Webster</source> <source>+PJC</source>]</p>

<p><ent>Batwing</ent><br/
<ent>Bat's-wing</ent><br/
<mhw>{<hw>Bat's"-wing"</hw> <pr>(<?/)</pr> or <hw>Bat"wing</hw> }</mhw>,
<pos>a.</pos> <def>Shaped like a bat's wing; <as>as, a
<ex>bat's-wing</ex> burner</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Batta</ent><br/
\'d8<hw>Bat"ta</hw> <pr>(b<acr/t"t<adot/)</pr>, <pos>n.</pos>
<ety>[Prob. through Pg. for Canarese <ets>bhatta</ets> rice in the
husk.]</ety> <def>Extra pay; esp. an extra allowance to an English
officer serving in India.</def> <rj><au>Whitworth.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 125 pr=SA --></p>

<p><ent>Batta</ent><br/
\'d8<hw>Bat"ta</hw> <pr>(b<acr/t"t<adot/)</pr>, <pos>n.</pos>
<ety>[Hind. <ets>ba<tsdot/<tsdot/a</ets>.]</ety> <def>Rate of exchange;
also, the discount on uncurrent coins.</def> <mark>[India]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Battable</ent><br/
<hw>Bat"ta*ble</hw> <pr>(<?/)</pr>, <pos>a.</pos> <ety>[See
<er>Batful</er>.]</ety> <def>Capable of cultivation; fertile;
productive; fattening.</def> <mark>[Obs.]</mark>
<rj><au>Burton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Battailant</ent><br/
<hw>Bat"tail*ant</hw> <pr>(<?/)</pr>, <pos>a.</pos> <ety>[F.
<ets>bataillant</ets>, p. pr. See <er>Battle</er>, <pos>v. i.</pos>
]</ety> <mark>[Obs.]</mark> <def>Prepared for battle; combatant;
warlike.</def> <au>Spenser.</au> -- <def2><pos>n.</pos> <def>A
combatant.</def></def2> <rj><au>Shelton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Battailous</ent><br/
<hw>Bat"tail*ous</hw> <pr>(<?/)</pr>, <pos>a.</pos> <ety>[OF.
<ets>bataillos</ets>, fr. <ets>bataille</ets>. See <er>Battle</er>,
<pos>n.</pos>]</ety> <def>Arrayed for battle; fit or eager for battle;
warlike.</def> <mark>[Obs.]</mark> <ldquo/In <xex>battailous</xex>
aspect.<rdquo/ <rj><au>Milton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Battalia</ent><br/
<hw>Bat*tal"ia</hw> <pr>(b<acr/t*t<amac/l"y<adot/; 106)</pr>,
<pos>n.</pos> <ety>[LL. <ets>battalia</ets> battle, a body of troops.
See <er>Battle</er>, <pos>n.</pos>]</ety> <sn>1.</sn> <def>Order of
battle; disposition or arrangement of troops (brigades, regiments,
battalions, etc.), or of a naval force, for action.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>A drawing up the armies in <qex>battalia</qex>.</q> <rj><qau>Jer.
Taylor.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>An army in battle array; also, the main battalia or
body.</def> <mark>[Obs.]</mark> <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Battalion</ent><br/
<hw>Bat*tal"ion</hw> <pr>(b<acr/t*t<acr/l"y<ucr/n; 106)</pr>,
<pos>n.</pos> <ety>[F. <ets>bataillon</ets>, fr. It.
<ets>battaglione</ets>. See <er>Battalia</er>.]</ety> <sn>1.</sn> <def>A
body of troops; esp. a body of troops or an army in battle array.</def>
<mark>[archaic]</mark> <ldquo/The whole <xex>battalion</xex>
views.<rdquo/ <rj><au>Milton.</au></rj><br/
[<source>1913 Webster</source> <source>+PJC</source>]</p>

<p><sn>2.</sn> <fld>(Mil.)</fld> <def>An infantry command of two or more
companies, which is the tactical unit of the infantry, or the smallest
command which is self-supporting upon the battlefield, and also the unit
in which the strength of the infantry of an army is expressed.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ In the United States army, since April 29, 1898, a
<xex>battalion</xex> consists of four companies, and three battalions
form a regiment. The term is also applied to two or more batteries of
artillery combined into a single command.</note><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Battalion</ent><br/
<hw>Bat*tal"ion</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <def>To form into
battalions.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Battel</ent><br/
<hw>Bat"tel</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[Obs. form. of
<er>Battle</er>.]</ety> <fld>(Old Eng. Law)</fld> <def>A single combat;
<as>as, trial by <ex>battel</ex></as>. See <cref>Wager of battel</cref>,
under <er>Wager</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Battel</ent><br/
<hw>Bat"tel</hw>, <pos>n.</pos> <ety>[Of uncertain etymology.]</ety>
<def>Provisions ordered from the buttery; also, the charges for them; --
only in the <pluf>pl.</pluf>, except when used adjectively.</def>
<mark>[Univ. of Oxford, Eng.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Battel</ent><br/
<hw>Bat"tel</hw>, <pos>v. i.</pos> <def>To be supplied with provisions
from the buttery.</def> <mark>[Univ. of Oxford, Eng.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Battel</ent><br/
<hw>Bat"tel</hw>, <pos>v. t.</pos> <ety>[Cf. <er>Batful</er>,
<er>Batten</er>, <pos>v. i.</pos>]</ety> <def>To make fertile.</def>
<mark>[Obs.]</mark> <ldquo/To <xex>battel</xex> barren land.<rdquo/
<rj><au>Ray.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Battel</ent><br/
<hw>Bat"tel</hw>, <pos>a.</pos> <def>Fertile; fruitful;
productive.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>A <qex>battel</qex> soil for grain, for pasture good.</q>
<rj><qau>Fairfax.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Battler</ent><br/
<ent>Batteler</ent><br/
<mhw>{ <hw>Bat"tel*er</hw> <pr>(<?/)</pr>, <hw>Bat"tler</hw> }</mhw>
<pr>(<?/)</pr>, <pos>n.</pos> <ety>[See 2d <er>Battel</er>,
<pos>n.</pos>]</ety> <def>A student at Oxford who is supplied with
provisions from the buttery; formerly, one who paid for nothing but what
he called for, answering nearly to a <altname>sizar</altname> at
Cambridge.</def> <rj><au>Wright.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Batten</ent><br/
<hw>Bat"ten</hw> <pr>(b<acr/t"t'n)</pr>, <pos>v. t.</pos>
<vmorph>[<pos>imp. & p. p.</pos> <conjf>Battened</conjf>
<pr>(b<acr/t"t'nd)</pr>; <pos>p. pr. & vb. n.</pos>
<conjf>Battening</conjf>.]</vmorph> <ety>[See <er>Batful</er>.]</ety>
<sn>1.</sn> <def>To make fat by plenteous feeding; to fatten.</def>
<ldquo/<xex>Battening</xex> our flocks.<rdquo/
<rj><au>Milton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To fertilize or enrich, as land.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Batten</ent><br/
<hw>Bat"ten</hw>, <pos>v. i.</pos> <def>To grow fat; to grow fat in ease
and luxury; to glut one's self.</def> <rj><au>Dryden.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The pampered monarch lay <qex>battening</qex> in ease.</q>
<rj><qau>Garth.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Skeptics, with a taste for carrion, who <qex>batten</qex> on the
hideous facts in history, -- persecutions, inquisitions.</q>
<rj><qau>Emerson.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Batten</ent><br/
<hw>Bat"ten</hw>, <pos>n.</pos> <ety>[F. <ets>b<acir/ton</ets> stick,
staff. See <er>Baton</er>.]</ety> <def>A strip of sawed stuff, or a
scantling;</def> <specif>as,</specif> <sd>(a)</sd> <pluf>pl.</pluf>
<fld>(Com. & Arch.)</fld> <def>Sawed timbers about 7 by 2 1/2 inches and
not less than 6 feet long.</def> <au>Brande & C.</au> <sd>(b)</sd>
<fld>(Naut.)</fld> <def>A strip of wood used in fastening the edges of a
tarpaulin to the deck, also around masts to prevent chafing.</def>
<sd>(c)</sd> <def>A long, thin strip used to strengthen a part, to cover
a crack, etc.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Batten door</b></col> <fld>(Arch.)</fld>, <cd>a door made
of boards of the whole length of the door, secured by battens nailed
crosswise.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Batten</ent><br/
<hw>Bat"ten</hw>, <pos>v. t.</pos> <def>To furnish or fasten with
battens.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>To batten down</b></col>, <cd>to fasten down with
battens, as the tarpaulin over the hatches of a ship during a
storm.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Batten</ent><br/
<hw>Bat"ten</hw>, <pos>n.</pos> <ety>[F. <ets>battant</ets>. See
<er>Batter</er>, <pos>v. t.</pos>]</ety> <def>The movable bar of a loom,
which strikes home or closes the threads of a woof.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Battening</ent><br/
<hw>Bat"ten*ing</hw> <pr>(<?/)</pr>, <pos>n.</pos> <fld>(Arch.)</fld>
<def>Furring done with small pieces nailed directly upon the
wall.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Batter</ent><br/
<hw>Bat"ter</hw> <pr>(b<acr/t"t<etil/r)</pr>, <pos>v. t.</pos>
<vmorph>[<pos>imp. & p. p.</pos> <conjf>Battered</conjf>
<pr>(b<acr/t"t<etil/rd)</pr>; <pos>p. pr. & vb. n.</pos>
<conjf>Battering</conjf>.]</vmorph> <ety>[OE. <ets>bateren</ets>, OF.
<ets>batre</ets>, F. <ets>battre</ets>, fr. LL. <ets>battere</ets>, for
L. <ets>batuere</ets> to strike, beat; of unknown origin. Cf.
<er>Abate</er>, <er>Bate</er> to abate.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>To beat with successive blows; to beat repeatedly
and with violence, so as to bruise, shatter, or demolish; <as>as, to
<ex>batter</ex> a wall or rampart</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To wear or impair as if by beating or by hard
usage.</def> <ldquo/Each <xex>battered</xex> jade.<rdquo/
<rj><au>Pope.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Metallurgy)</fld> <def>To flatten (metal) by
hammering, so as to compress it inwardly and spread it
outwardly.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Batter</ent><br/
<hw>Bat"ter</hw>, <pos>n.</pos> <ety>[OE. <ets>batere</ets>,
<ets>batire</ets>; cf. OF. <ets>bateure</ets>, <ets>bature</ets>, a
beating. See <er>Batter</er>, <pos>v. t.</pos>]</ety> <sn>1.</sn> <def>A
semi-liquid mixture of several ingredients, as, flour, eggs, milk, etc.,
beaten together and used in cookery.</def> <rj><au>King.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Paste of clay or loam.</def>
<rj><au>Holland.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Printing)</fld> <def>A bruise on the face of a
plate or of type in the form.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Batter</ent><br/
<hw>Bat"ter</hw>, <pos>n.</pos> <def>A backward slope in the face of a
wall or of a bank; receding slope.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Batter rule</b></col>, <cd>an instrument consisting of a
rule or frame, and a plumb line, by which the batter or slope of a wall
is regulated in building.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Batter</ent><br/
<hw>Bat"ter</hw>, <pos>v. i.</pos> <fld>(Arch.)</fld> <def>To slope
gently backward.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Batter</ent><br/
<hw>Bat"ter</hw> <pr>(b<acr/t"t<etil/r)</pr>, <pos>n.</pos> <def>The one
who wields the bat in baseball; the one whose turn it is at bat;
formerly called the <altname>batsman</altname>.</def><br/
[<source>1913 Webster</source> <source>+PJC</source>]</p>

<p><ent>battered</ent><br/
<hw>battered</hw> <pos>adj.</pos> <sn>1.</sn> <def>In deplorable
condition; <as>as, the <ex>battered</ex> old Ford station
wagon</as>.</def><br/
<syn><b>Syn. --</b> beat-up, beaten-up, bedraggled, broken-down,
dilapidated, ramshackle, tumble-down, unsound.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><sn>2.</sn> <def>Hit or pounded repeatedly and violently with heavy
blows; <as>as, a <ex>battered</ex> old car</as>; antonym of
<ant>unbattered</ant>.</def> [Narrower terms: <stype>buffeted</stype>;
<stype>storm-tossed, tempest-tossed, tempest-tost,
tempest-swept</stype>]<br/
[<source>WordNet 1.5</source>]</p>

<p><sn>3.</sn> <def>Damaged especially by hard usage.</def> <illu>his
<ex>battered</ex> old hat</illu><br/
[<source>WordNet 1.5</source>]</p>

<p><sn>4.</sn> <def>beaten repeatedly; -- of people; <as>as, a
<ex>battered</ex> child; the <ex>battered</ex> woman syndrome; a
<ex>battered</ex> wife</as>.</def><br/
<syn><b>Syn. --</b> beaten.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Batterer</ent><br/
<hw>Bat"ter*er</hw> <pr>(b<acr/t"t<etil/r*<etil/r)</pr>, <pos>n.</pos>
<def>One who, or that which, batters.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>battering</ent><br/
<hw>bat"ter*ing</hw> <pos>n.</pos> <def>the act or process of subjecting
to strong repeated blows.</def><br/
<syn><b>Syn. --</b> banging.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Battering-ram</ent><br/
<hw>Bat"ter*ing-ram`</hw> <pr>(<?/)</pr>, <pos>n.</pos> <sn>1.</sn>
<fld>(Mil.)</fld> <def>An engine used in ancient times to beat down the
walls of besieged places.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ It was a large beam, with a head of iron, which was
sometimes made to resemble the head of a ram. It was suspended by ropes
to a beam supported by posts, and so balanced as to swing backward and
forward, and was impelled by men against the wall.</note>
<rj><au>Grose.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A blacksmith's hammer, suspended, and worked
horizontally.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Battering train</ent><br/
<hw>Bat"ter*ing train`</hw> <pr>(<?/)</pr>. <fld>(Mil.)</fld> <def>A
train of artillery for siege operations.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Battery</ent><br/
<hw>Bat"ter*y</hw> <pr>(<?/)</pr>, <pos>n.</pos>; <plu><it>pl.</it>
<plw>Batteries</plw> <pr>(<?/)</pr>.</plu> <ety>[F. <ets>batterie</ets>,
fr. <ets>battre</ets>. See <er>Batter</er>, <pos>v. t.</pos>]</ety>
<sn>1.</sn> <def>The act of battering or beating.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Law)</fld> <def>The unlawful beating of another. It
includes every willful, angry and violent, or negligent touching of
another's person or clothes, or anything attached to his person or held
by him.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Mil.)</fld> <sd>(a)</sd> <def>Any place where
cannon or mortars are mounted, for attack or defense.</def> <sd>(b)</sd>
<def>Two or more pieces of artillery in the field.</def> <sd>(c)</sd>
<def>A company or division of artillery, including the gunners, guns,
horses, and all equipments. In the United States, a battery of flying
artillery consists usually of six guns.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Barbette battery</b></col>. <cd>See
<er>Barbette</er>.</cd> -- <mcol><col><b>Battery d'enfilade</b></col>,
or <col><b>Enfilading battery</b></col></mcol>, <cd>one that sweeps the
whole length of a line of troops or part of a work.</cd> --
<col><b>Battery en <eacute/charpe</b></col>, <cd>one that plays
obliquely.</cd> -- <col><b>Battery gun</b></col>, <cd>a gun capable of
firing a number of shots simultaneously or successively without stopping
to load.</cd> -- <col><b>Battery wagon</b></col>, <cd>a wagon employed
to transport the tools and materials for repair of the carriages, etc.,
of the battery.</cd> -- <col><b>In battery</b></col>, <cd>projecting, as
a gun, into an embrasure or over a parapet in readiness for firing.</cd>
-- <col><b>Masked battery</b></col>, <cd>a battery artificially
concealed until required to open upon the enemy.</cd> --
<mcol><col><b>Out of battery</b></col>, or <col><b>From
battery</b></col></mcol>, <cd>withdrawn, as a gun, to a position for
loading.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <fld>(Elec.)</fld> <sd>(a)</sd> <def>A number of coated
jars (Leyden jars) so connected that they may be charged and discharged
simultaneously.</def> <sd>(b)</sd> <def>An apparatus for generating
voltaic electricity.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ In the <stype>trough battery</stype>, copper and zinc
plates, connected in pairs, divide the trough into cells, which are
filled with an acid or oxidizing liquid; the effect is exhibited when
wires connected with the two end-plates are brought together. In
<stype>Daniell's battery</stype>, the metals are zinc and copper, the
former in dilute sulphuric acid, or a solution of sulphate of zinc, the
latter in a saturated solution of sulphate of copper. A modification of
this is the common <stype>gravity battery</stype>, so called from the
automatic action of the two fluids, which are separated by their
specific gravities. In <stype>Grove's battery</stype>, platinum is the
metal used with zinc; two fluids are used, one of them in a porous cell
surrounded by the other. In <stype>Bunsen's</stype> or the <stype>carbon
battery</stype>, the carbon of gas coke is substituted for the platinum
of Grove's. In <stype>Leclanch<eacute/'s battery</stype>, the elements
are zinc in a solution of ammonium chloride, and gas carbon surrounded
with manganese dioxide in a porous cell. A <stype>secondary
battery</stype> is a battery which usually has the two plates of the
same kind, generally of lead, in dilute sulphuric acid, and which, when
traversed by an electric current, becomes charged, and is then capable
of giving a current of itself for a time, owing to chemical changes
produced by the charging current. A <stype>storage battery</stype> is a
kind of secondary battery used for accumulating and storing the energy
of electrical charges or currents, usually by means of chemical work
done by them; an accumulator.</note><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>A number of similar machines or devices in position;
an apparatus consisting of a set of similar parts; <as>as, a
<ex>battery</ex> of boilers, of retorts, condensers, etc.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <fld>(Metallurgy)</fld> <def>A series of stamps operated
by one motive power, for crushing ores containing the precious
metals.</def> <rj><au>Knight.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>7.</sn> <def>The box in which the stamps for crushing ore play up
and down.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>8.</sn> <fld>(Baseball)</fld> <def>The pitcher and catcher
together.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Batting</ent><br/
<hw>Bat"ting</hw> <pr>(<?/)</pr>, <pos>n.</pos> <sn>1.</sn> <def>The act
of one who bats; the management of a bat in playing games of ball.</def>
<rj><au>Mason.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Cotton in sheets, prepared for use in making quilts,
etc.; <as>as, cotton <ex>batting</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Battle</ent><br/
<hw>Bat"tle</hw> <pr>(<?/)</pr>, <pos>a.</pos> <def>Fertile. See
<er>Battel</er>, <pos>a.</pos></def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Battle</ent><br/
<hw>Bat"tle</hw>, <pos>n.</pos> <ety>[OE. <ets>bataille</ets>,
<ets>bataile</ets>, F. <ets>bataille</ets> battle, OF., battle,
battalion, fr. L. <ets>battalia</ets>, <ets>battualia</ets>, the
fighting and fencing exercises of soldiers and gladiators, fr.
<ets>batuere</ets> to strike, beat. Cf. <er>Battalia</er>, 1st
<er>Battel</er>, and see <er>Batter</er>, <pos>v. t.</pos> ]</ety>
<sn>1.</sn> <def>A general action, fight, or encounter, in which all the
divisions of an army are or may be engaged; an engagement; a
combat.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A struggle; a contest; <as>as, the <ex>battle</ex>
of life</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The whole intellectual <qex>battle</qex> that had at its center
the best poem of the best poet of that day.</q> <rj><qau>H.
Morley.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>A division of an army; a battalion.</def>
<mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>The king divided his army into three <qex>battles</qex>.</q>
<rj><qau>Bacon.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The cavalry, by way of distinction, was called the
<qex>battle</qex>, and on it alone depended the fate of every
action.</q> <rj><qau>Robertson.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>The main body, as distinct from the van and rear;
battalia.</def> <mark>[Obs.]</mark> <rj><au>Hayward.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ <ex>Battle</ex> is used adjectively or as the first part
of a self-explaining compound; as, <ex>battle</ex> brand, a
<ldquo/brand<rdquo/ or sword used in battle; <ex>battle</ex> cry;
<ex>battle</ex>field; <ex>battle</ex> ground; <ex>battle</ex> array;
<ex>battle</ex> song.</note><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Battle piece</b></col>, <cd>a painting, or a musical
composition, representing a battle.</cd> -- <col><b>Battle
royal</b></col>. <sd>(a)</sd> <cd>A fight between several gamecocks,
where the one that stands longest is the victor.</cd> <au>Grose.</au>
<sd>(b)</sd> <cd>A contest with fists or cudgels in which more than two
are engaged; a m<ecir/l<eacute/e.</cd> <au>Thackeray.</au> --
<col><b>Drawn battle</b></col>, <cd>one in which neither party gains the
victory.</cd> -- <col><b>To give battle</b></col>, <cd>to attack an
enemy.</cd> -- <col><b>To join battle</b></col>, <cd>to meet the attack;
to engage in battle.</cd> -- <col><b>Pitched battle</b></col>, <cd>one
in which the armies are previously drawn up in form, with a regular
disposition of the forces.</cd> -- <col><b>Wager of battle</b></col>.
<cd>See under <er>Wager</er>, <pos>n.</pos></cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- Conflict; encounter; contest; action.</syn>
<usage> <er>Battle</er>, <er>Combat</er>, <er>Fight</er>,
<er>Engagement</er>. These words agree in denoting a close encounter
between contending parties. <xex>Fight</xex> is a word of less dignity
than the others. Except in poetry, it is more naturally applied to the
encounter of a few individuals, and more commonly an accidental one; as,
a street <xex>fight</xex>. A <xex>combat</xex> is a close encounter,
whether between few or many, and is usually premeditated. A
<xex>battle</xex> is commonly more general and prolonged. An
<xex>engagement</xex> supposes large numbers on each side,
<xex>engaged</xex> or intermingled in the conflict.</usage><br/
[<source>1913 Webster</source>]</p>

<p><ent>Battle</ent><br/
<hw>Bat"tle</hw> <pr>(b<acr/t"t'l)</pr>, <pos>v. i.</pos>
<vmorph>[<pos>imp. & p. p.</pos> <conjf>Battled</conjf>
<pr>(-tl'd)</pr>; <pos>p. pr. & vb. n.</pos>
<conjf>Battling</conjf>.]</vmorph> <ety>[F. <ets>batailler</ets>, fr.
<ets>bataille</ets>. See <er>Battle</er>, <pos>n.</pos>]</ety> <def>To
join in battle; to contend in fight; <as>as, to <ex>battle</ex> over
theories</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>To meet in arms, and <qex>battle</qex> in the plain.</q>
<rj><qau>Prior.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Battle</ent><br/
<hw>Bat"tle</hw>, <pos>v. t.</pos> <def>To assail in battle; to
fight.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Battle-axe</ent><br/
<ent>Battle-ax</ent><br/
<mhw>{ <hw>Bat"tle-ax`</hw> <hw>Bat"tle-axe`</hw> }</mhw>
<pr>(-<acr/ks`)</pr>, <pos>n.</pos> <fld>(Mil.)</fld> <def>A kind of
broadax formerly used as an offensive weapon.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Battled</ent><br/
<hw>Bat"tled</hw> <pr>(<?/)</pr>, <pos>p. p.</pos> <def>Embattled.</def>
<mark>[Poetic]</mark> <rj><au>Tennyson.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>battledoor</ent><br/
<hw>bat"tle*door`</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[OE.
<ets>batyldour</ets>. A corrupted form of uncertain origin; cf. Sp.
<ets>batallador</ets> a great combatant, he who has fought many battles,
Pg. <ets>batalhador</ets>, Pr. <ets>batalhador</ets>, warrior, soldier,
fr. L. <ets>battalia</ets>; or cf. Pr. <ets>batedor</ets> batlet, fr.
<ets>batre</ets> to beat, fr. L. <ets>batuere</ets>. See
<er>Battle</er>, <pos>n.</pos>]</ety> <sn>1.</sn> <def>An instrument,
with a handle and a flat part covered with parchment or crossed with
catgut, used to strike a shuttlecock in play; also, the play of
battledoor and shuttlecock.</def> <altsp>[Also spelled
<asp>battledore</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <ety>[OE. <ets>battleder</ets>.]</ety> <def>A child's
hornbook.</def> <mark>[Obs.]</mark> <rj><au>Halliwell.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>battledore</ent><br/
<hw>bat"tle*dore</hw> <pos>n.</pos> <def>same as
<er>battledoor</er>.</def><br/
<syn><b>Syn. --</b> battledore and shuttlecock.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>battlefield</ent><br/
<hw>bat"tle*field</hw> <pos>n.</pos> <def>a region where a battle is
fought.</def><br/
<syn><b>Syn. --</b> battleground, field of battle, field.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>battlefront</ent><br/
<hw>bat"tle*front</hw> <pos>n.</pos> <def>the line along which opposing
armies face each other.</def><br/
<syn><b>Syn. --</b> front, front line.</syn><br/
[<source>WordNet 1.5</source> #here]</p>

<p><ent>battleground</ent><br/
<hw>bat"tle*ground</hw> <pos>n.</pos> <def>a region where a battle is
fought; same as <er>battlefield</er>.</def><br/
<syn><b>Syn. --</b> battlefield, field of battle, field.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>battle-hardened</ent><br/
<hw>battle-hardened</hw> <pos>a.</pos> <def>Experienced in combat, and
therefore more effective at fighting; -- used mostly of infantry troops;
<as>as, <ex>battle-hardened</ex> veterans</as>.</def><br/
<syn><b>Syn. --</b> combat-hardened, combat-tested.</syn><br/
[<source>PJC</source>]</p>

<p><ent>Battlement</ent><br/
<hw>Bat"tle*ment</hw> <pr>(-m<eit/nt)</pr>, <pos>n.</pos> <ety>[OE.
<ets>batelment</ets>; cf. OF. <ets>bataillement</ets> combat, fr.
<ets>batailler</ets>, also OF. <ets>bastillier</ets>,
<ets>bateillier</ets>, to fortify. Cf. <er>Battle</er>, <pos>n.</pos>,
<er>Bastile</er>, <er>Bastion</er>.]</ety> <fld>(Arch.)</fld>
<sd>(a)</sd> <def>One of the solid upright parts of a parapet in ancient
fortifications.</def> <sd>(b)</sd> <pluf>pl.</pluf> <def>The whole
parapet, consisting of alternate solids and open spaces. At first purely
a military feature, afterwards copied on a smaller scale with decorative
features, as for churches.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Battlemented</ent><br/
<hw>Bat"tle*ment*ed</hw> <pr>(-m<ecr/nt*<ecr/d)</pr>, <pos>a.</pos>
<def>Having battlements.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>A <qex>battlemented</qex> portal.</q> <rj><qau>Sir W.
Scott.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Battle range</ent><br/
<hw>Bat"tle range`</hw>. <fld>(Mil.)</fld> <def>The range within which
the fire of small arms is very destructive. With the magazine rifle,
this is six hundred yards.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>battleship</ent><br/
<hw>bat"tle*ship`</hw>. <fld>(Nav.)</fld> <ety>[shortened from
<ets>line-of-battle ship</ets>, i.e. the most heavily armored ship
suited to be in the front line of a naval battle.]</ety> <def>An
armor-plated warship built of steel and heavily armed, generally having
over ten thousand tons displacement, and intended to be fit to combat
the heaviest enemy ships in line of battle; the most heavily armed and
armored class of warship at any given time.</def><br/
[<source>Webster 1913 Suppl.</source> <source>+PJC</source>]</p>

<p><ent>Battologist</ent><br/
<hw>Bat*tol"o*gist</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>One who
battologizes.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Battologize</ent><br/
<hw>Bat*tol"o*gize</hw> <pr>(b<acr/t*t<ocr/l"l<osl/*j<imac/z)</pr>,
<pos>v. t.</pos> <def>To keep repeating needlessly; to iterate.</def>
<rj><au>Sir T. Herbert.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Battology</ent><br/
<hw>Bat*tol"o*gy</hw> <pr>(b<acr/t*t<ocr/l"l<osl/*j<ycr/)</pr>,
<pos>n.</pos> <ety>[F. <ets>battologie</ets>, fr. Gr.
<grk>battologi`a</grk>; <grk>ba`ttos</grk>; a stammerer +
<grk>lo`gos</grk> speech.]</ety> <def>A needless repetition of words in
speaking or writing.</def> <rj><au>Milton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Batton</ent><br/
<hw>Bat"ton</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>See <er>Batten</er>,
and <er>Baton</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Battue</ent><br/
\'d8<hw>Bat"tue`</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[F.
<ets>battue</ets>, fr. <ets>battre</ets> to beat. See <er>Batter</er>,
<pos>v. t.</pos>, and cf. <er>Battuta</er>.]</ety> <fld>(Hunting)</fld>
<sd>(a)</sd> <def>The act of beating the woods, bushes, etc., for
game.</def> <sd>(b)</sd> <def>The game itself.</def> <sd>(c)</sd>
<def>The wanton slaughter of game.</def> <rj><au>Howitt.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Batture</ent><br/
\'d8<hw>Bat`ture"</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[F., fr.
<ets>battre</ets> to beat.]</ety> <def>An elevated river bed or sea
bed.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Battuta</ent><br/
\'d8<hw>Bat*tu"ta</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[It.
<ets>battuta</ets>, fr. <ets>battere</ets> to beat.]</ety>
<fld>(Mus.)</fld> <def>The measuring of time by beating.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Batty</ent><br/
<hw>Bat"ty</hw> <pr>(b<acr/t"t<ycr/)</pr>, <pos>a.</pos> <sn>1.</sn>
<def>Belonging to, or resembling, a bat.</def> <ldquo/<xex>Batty</xex>
wings.<rdquo/ <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Crazy; demented; loony; nuts; <as>as, her constant
gabbing is driving me <ex>batty</ex></as>.</def>
<mark>[Colloq.]</mark><br/
<syn><b>Syn. --</b> bats.</syn><br/
[<source>PJC</source>]</p>

<p><ent>Batule</ent><br/
<hw>Bat"ule</hw> <pr>(b<acr/t"<umac/l <it>or</it>
b<adot/*t<oomac/l")</pr>, <pos>n.</pos> <def>A springboard in a circus
or gymnasium; -- called also <altname>batule board</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Batz</ent><br/
\'d8<hw>Batz</hw> <pr>(b<aum/ts)</pr>, <pos>n.</pos>; <plu><it>pl.</it>
<plw>Batzen</plw> <pr>(<?/)</pr>.</plu> <ety>[Ger. <ets>batz</ets>,
<ets>batze</ets>, <ets>batzen</ets>, a coin bearing the image of a bear,
Ger. <ets>b<aum/tz</ets>, <ets>betz</ets>, bear.]</ety> <def>A small
copper coin, with a mixture of silver, formerly current in some parts of
Germany and Switzerland. It was worth about four cents.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baubee</ent><br/
<hw>Bau*bee"</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>Same as
<er>Bawbee</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bauble</ent><br/
<hw>Bau"ble</hw> <pr>(b<add/"b'l)</pr>, <pos>n.</pos> <ety>[Cf. OF.
<ets>baubel</ets> a child's plaything, F. <ets>babiole</ets>, It.
<ets>babbola</ets>, LL. <ets>baubellum</ets> gem, jewel, L.
<ets>babulus</ets>, <ets>a baburrus</ets>, foolish.]</ety> <sn>1.</sn>
<def>A trifling piece of finery; a gewgaw; that which is gay and showy
without real value; a cheap, showy plaything.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The ineffective <qex>bauble</qex> of an Indian pagod.</q>
<rj><qau>Sheridan.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The fool's club.</def> <mark>[Obs.]</mark> <ldquo/A
<xex>fool's bauble</xex> was a short stick with a head ornamented with
an ass's ears fantastically carved upon it.<rdquo/
<rj><au>Nares.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baubling</ent><br/
<hw>Bau"bling</hw> <pr>(<?/)</pr>, <pos>a.</pos> <def>See
<er>Bawbling</er>.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>baud</ent><br/
<hw>baud</hw> <pr>(b<add/d or b<ocir/d)</pr>, <pos>n.</pos> <ety>[Named
after <person>J. M. E. <etsep>Baudot</etsep></person>, a French
inventor, died 1903.]</ety> <fld>(Computers, telecommunications)</fld>
<def>A unit of transmission speed for information conveyed over a
digital communications channel, usually taken as equal to the number of
bits of information transmitted per second. The speed in bauds indicates
the number of signalling events per second; however, since it is
necessary in most cases to transmit control information along with the
data, the <er>data signalling rate</er> may be smaller than the baud
rate.</def><br/
[<source>PJC</source>]</p>

<p><ent>Baudekin</ent><br/
<hw>Bau"de*kin</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[OE.
<ets>bawdekin</ets> rich silk stuff, OF. <ets>baudequin</ets>. See
<er>Baldachin</er>.]</ety> <def>The richest kind of stuff used in
garments in the Middle Ages, the web being gold, and the woof silk, with
embroidery; -- made originally at <city>Baghdad</city>.</def>
<altsp>[Spelt also <asp>baudkin</asp>, <asp>baudkyn</asp>,
<asp>bawdekin</asp>, and <asp>baldakin</asp>.]</altsp>
<rj><au>Nares.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baudrick</ent><br/
<hw>Bau"drick</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>A belt. See
<er>Baldric</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baulk</ent><br/
<ent>Bauk</ent><br/
<mhw>{ <hw>Bauk</hw>, <hw>Baulk</hw> }</mhw> <pr>(<?/)</pr>, <pos>n. &
v.</pos> <def>See <er>Balk</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baume</ent><br/
<hw>Bau`m<eacute/"</hw> <pr>(?)</pr>, <pos>a.</pos> <def>Designating or
conforming to either of the scales used by the French chemist
<person>Antoine <etsep>Baum<eacute/</etsep></person> in the graduation
of his hydrometers; of or relating to <persfn>Baum<eacute/'s</persfn>
scales or hydrometers. There are two Baum<eacute/ hydrometers. One,
which is used with liquids heavier than water, sinks to 0<deg/ in pure
water, and to 15<deg/ in a 15 per cent salt solution; the other, for
liquids lighter than water, sinks to 0<deg/ in a 10 per cent salt
solution and to 10<deg/ in pure water. In both cases the graduation,
based on the distance between these fundamental points, is continued
along the stem as far as desired.</def> <note>Since all the degrees on a
Baum<eacute/ scale are thus equal in length, while those on a
specific-gravity scale grow smaller as the density increases, there is
no simple relation between degrees Baum<eacute/ and specific gravity.
However, readings on Baum<eacute/s scale may be approximately reduced to
specific gravities by the following formul<ae/ (<it>x</it> in each case
being the reading on Baum<eacute/'s scale): <sd>(a)</sd> for liquids
heavier than water, <mathex>sp. gr. = 144 <divide/ (144 -
<it>x</it>)</mathex>; <sd>(b)</sd> for liquids lighter than water,
<mathex>sp. gr. = 144 <divide/ (134 + <it>x</it>)</mathex>.</note><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Baunscheidtism</ent><br/
<hw>Baun"scheidt*ism</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[From the
introducer, a German named
<persfn><etsep>Baunscheidt</etsep></persfn>.]</ety> <fld>(Med.)</fld>
<def>A form of acupuncture, followed by the rubbing of the part with a
stimulating fluid.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beauxite</ent><br/
<ent>Bauxite</ent><br/
<mhw>{ <hw>Baux"ite</hw>, <hw>Beaux"ite</hw> }</mhw>
<pr>(<?/)</pr>,<pos>n.</pos> <ety>[F., fr. <etsep>Baux</etsep> or
<etsep>Beaux</etsep>, near Arles.]</ety> <fld>(Min.)</fld> <def>A
ferruginous hydrate of alumina. It is the most commonly used ore for the
preparation of aluminum and alumina. It is also used for the lining of
furnaces which are exposed to intense heat.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>bauxitic</ent><br/
<hw>bauxitic</hw> <pos>adj.</pos> <def>Of or pertaining to
bauxite.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Bavardage</ent><br/
\'d8<hw>Ba`var`dage"</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[F.]</ety>
<def>Much talking; prattle; chatter.</def> <rj><au>Byron.</au></rj><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Bavaria</ent><br/
<hw>Ba*va"ri*a</hw> <pos>prop. n.</pos> <def>A state in southern
Germany.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Bavarian</ent><br/
<hw>Ba*va"ri*an</hw> <pr>(<?/)</pr>, <pos>a.</pos> <def>Of or pertaining
to Bavaria.</def> -- <def2><pos>n.</pos> <def>A native or an inhabitant
of Bavaria.</def></def2><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Bavarian cream</b></col>. <cd>See under
<er>Cream</er>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bavaroy</ent><br/
<hw>Bav"a*roy</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[F.
<ets>Bavarois</ets> Bavarian.]</ety> <def>A kind of cloak or
surtout.</def> <mark>[Obs.]</mark> <rj><au>Johnson.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Let the looped <qex>bavaroy</qex> the fop embrace.</q>
<rj><qau>Gay.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 126 pr=SA --></p>

<p><ent>Bavian</ent><br/
<hw>Ba"vi*an</hw> <pr>(b<amac/"v<icr/*<ait/n)</pr>, <pos>n.</pos>
<ety>[See <er>Baboon</er>.]</ety> <def>A baboon.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bavin</ent><br/
<hw>Bav"in</hw> <pr>(b<acr/v"<icr/n)</pr>, <pos>n.</pos> <ety>[Cf. Gael.
& Ir. <ets>baban</ets> tuft, tassel.]</ety> <sn>1.</sn> <def>A fagot of
brushwood, or other light combustible matter, for kindling fires; refuse
of brushwood.</def> <mark>[Obs. or Dial. Eng.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Impure limestone.</def> <mark>[Prov. Eng.]</mark>
<rj><au>Wright.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bawbee</ent><br/
<hw>Baw*bee"</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[Perh. corrupt. fr.
<ets>halfpenny</ets>.]</ety> <def>A halfpenny.</def> <altsp>[Spelt also
<asp>baubee</asp>.]</altsp> <mark>[Scot. & Prov. Eng.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bawble</ent><br/
<hw>Baw"ble</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>A trinket. See
<er>Bauble</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bawbling</ent><br/
<hw>Baw"bling</hw>, <pos>a.</pos> <def>Insignificant;
contemptible.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bawcock</ent><br/
<hw>Baw"cock</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[From F.
<ets>beau</ets> fine + E. <ets>cock</ets> (the bird); or more prob. fr.
OF. <ets>baud</ets> bold, gay + E. <ets>cock</ets>. Cf.
<er>Bawd</er>.]</ety> <def>A fine fellow; -- a term of endearment.</def>
<mark>[Obs.]</mark> <ldquo/How now, my <xex>bawcock</xex> ?<rdquo/
<rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bawd</ent><br/
<hw>Bawd</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[OE. <ets>baude</ets>,
OF. <ets>balt</ets>, <ets>baut</ets>, <ets>baude</ets>, bold, merry,
perh. fr. OHG. <ets>bald</ets> bold; or fr. Celtic, cf. W.
<ets>baw</ets> dirt. Cf. <er>Bold</er>, <er>Bawdry</er>.]</ety> <def>A
person who keeps a house of prostitution, or procures women for a lewd
purpose; a procurer or procuress; a lewd person; -- usually applied to a
woman.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bawd</ent><br/
<hw>Bawd</hw>, <pos>v. i.</pos> <def>To procure women for lewd
purposes.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bawdily</ent><br/
<hw>Bawd"i*ly</hw> <pr>(<?/)</pr>, <pos>adv.</pos> <def>Obscenely;
lewdly.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bawdiness</ent><br/
<hw>Bawd"i*ness</hw>, <pos>n.</pos> <def>Obscenity; lewdness.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bawdrick</ent><br/
<hw>Bawd"rick</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>A belt. See
<er>Baldric</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bawdry</ent><br/
<hw>Bawd"ry</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[OE.
<ets>baudery</ets>, OF. <ets>bauderie</ets>, <ets>balderie</ets>,
boldness, joy. See <er>Bawd</er>.]</ety> <sn>1.</sn> <def>The practice
of procuring women for the gratification of lust.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Illicit intercourse; fornication.</def>
<rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Obscenity; filthy, unchaste language.</def>
<ldquo/The pert style of the pit <xex>bawdry</xex>.<rdquo/
<rj><au>Steele.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bawdy</ent><br/
<hw>Bawd"y</hw>, <pos>a.</pos> <sn>1.</sn> <def>Dirty; foul; -- said of
clothes.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>It [a garment] is al <qex>bawdy</qex> and to-tore also.</q>
<rj><qau>Chaucer.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Obscene; filthy; unchaste.</def> <ldquo/A
<xex>bawdy</xex> story.<rdquo/ <rj><au>Burke.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bawdyhouse</ent><br/
<hw>Baw"dy*house`</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>A house of
prostitution; a house of ill fame; a brothel.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bawhorse</ent><br/
<hw>Baw"horse`</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>Same as
<er>Bathorse</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bawl</ent><br/
<hw>Bawl</hw> <pr>(b<add/l)</pr>, <pos>v. i.</pos> <vmorph>[<pos>imp. &
p. p.</pos> <conjf>Bawled</conjf> (b<add/ld); <pos>p. pr. & vb. n.</pos>
<conjf>Bawling</conjf>.]</vmorph> <ety>[Icel. <ets>baula</ets> to low,
bellow, as a cow; akin to Sw. <ets>b<oum/la</ets>; cf. AS
<ets>bellan</ets>, G. <ets>bellen</ets> to bark, E. <ets>bellow</ets>,
<ets>bull</ets>.]</ety> <sn>1.</sn> <def>To cry out with a loud, full
sound; to cry with vehemence, as in calling or exultation; to shout; to
vociferate.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To cry loudly, as a child from pain or
vexation.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bawl</ent><br/
<hw>Bawl</hw>, <pos>v. t.</pos> <def>To proclaim with a loud voice, or
by outcry, as a hawker or town-crier does.</def>
<rj><au>Swift.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bawl</ent><br/
<hw>Bawl</hw>, <pos>n.</pos> <def>A loud, prolonged cry; an
outcry.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bawler</ent><br/
<hw>Bawl"er</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>One who
bawls.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bawn</ent><br/
<hw>Bawn</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[Ir. & Gael.
<ets>babhun</ets> inclosure, bulwark.]</ety> <sn>1.</sn> <def>An
inclosure with mud or stone walls, for keeping cattle; a fortified
inclosure.</def> <mark>[Obs.]</mark> <rj><au>Spenser.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A large house.</def> <mark>[Obs.]</mark>
<rj><au>Swift.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bawrel</ent><br/
<hw>Baw"rel</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[Cf. It.
<ets>barletta</ets> a tree falcon, or hobby.]</ety> <def>A kind of
hawk.</def> <mark>[Obs.]</mark> <rj><au>Halliwell.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bawson</ent><br/
<ent>Bawsin</ent><br/
<mhw>{ <hw>Baw"sin</hw> <pr>(<?/)</pr>, <hw>Baw"son</hw> <pr>(<?/)</pr>,
}</mhw> <pos>n.</pos> <ety>[OE. <ets>bawson</ets>, <ets>baucyne</ets>,
badger (named from its color), OF. <ets>bauzan</ets>,
<ets>bau<cced/ant</ets>, <ets>bauchant</ets>, spotted with white, pied;
cf. It. <ets>balzano</ets>, F. <ets>balzan</ets>, a white-footed horse,
It. <ets>balza</ets> border, trimming, fr. L. <ets>balteus</ets> belt,
border, edge. Cf. <er>Belt</er>.]</ety> <sn>1.</sn> <def>A badger.</def>
<mark>[Obs.]</mark> <rj><au>B. Jonson.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A large, unwieldy person.</def> <mark>[Obs.]</mark>
<rj><au>Nares.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baxter</ent><br/
<hw>Bax"ter</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[OE.
<ets>bakestre</ets>, <ets>bakistre</ets>, AS. <ets>b<ae/cestre</ets>,
prop. fem. of <ets>b<ae/cere</ets> baker. See <er>Baker</er>.]</ety>
<def>A baker; originally, a female baker.</def> <mark>[Old Eng. &
Scotch]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bay</ent><br/
<hw>Bay</hw> <pr>(b<amac/)</pr>, <pos>a.</pos> <ety>[F. <ets>bai</ets>,
fr. L. <ets>badius</ets> brown, chestnut-colored; -- used only of
horses.]</ety> <def>Reddish brown; of the color of a chestnut; --
applied to the color of horses.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Bay cat</b></col> <fld>(Zool.)</fld>, <cd>a wild cat of
Africa and the East Indies (<spn>Felis aurata</spn>).</cd> --
<col><b>Bay lynx</b></col> <fld>(Zool.)</fld>, <cd>the common American
lynx (<spn>Lynx lynx</spn>, formerly <spn>Felis rufa</spn> or <spn>Lynx
rufa</spn>).</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bay</ent><br/
<hw>Bay</hw>, <pos>n.</pos> <ety>[F. <ets>baie</ets>, fr. LL.
<ets>baia</ets>. Of uncertain origin: cf. Ir. & Gael. <ets>badh</ets> or
<ets>bagh</ets> bay, harbor, creek; Bisc. <ets>baia</ets>,
<ets>baiya</ets>, harbor, and F. <ets>bayer</ets> to gape, open the
mouth.]</ety> <sn>1.</sn> <fld>(Geog.)</fld> <def>An inlet of the sea,
usually smaller than a gulf, but of the same general
character.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ The name is not used with much precision, and is often
applied to large tracts of water, around which the land forms a curve;
as, Hudson's <ex>Bay</ex>. The name is not restricted to tracts of water
with a narrow entrance, but is used for any recess or inlet between
capes or headlands; as, the <ex>Bay</ex> of Biscay.</note><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A small body of water set off from the main body; as
a compartment containing water for a wheel; the portion of a canal just
outside of the gates of a lock, etc.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>A recess or indentation shaped like a bay.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>A principal compartment of the walls, roof, or other
part of a building, or of the whole building, as marked off by the
buttresses, vaulting, mullions of a window, etc.; one of the main
divisions of any structure, as the part of a bridge between two
piers.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>A compartment in a barn, for depositing hay, or
grain in the stalks.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <def>A kind of mahogany obtained from Campeachy
Bay.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Sick bay</b></col>, <cd>in vessels of war, that part of a
deck appropriated to the use of the sick.</cd>
<rj><au>Totten.</au></rj></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bay</ent><br/
<hw>Bay</hw>, <pos>n.</pos> <ety>[F. <ets>baie</ets> a berry, the fruit
of the laurel and other trees, fr. L. <ets>baca</ets>, <ets>bacca</ets>,
a small round fruit, a berry, akin to Lith. <ets>bapka</ets> laurel
berry.]</ety> <sn>1.</sn> <def>A berry, particularly of the
laurel.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The laurel tree (<spn>Laurus nobilis</spn>). Hence,
in the plural, an honorary garland or crown bestowed as a prize for
victory or excellence, anciently made or consisting of branches of the
laurel.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The patriot's honors and the poet's <qex>bays</qex>.</q>
<rj><qau>Trumbull.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>A tract covered with bay trees.</def> <mark>[Local,
U. S.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Bay leaf</b></col>, <cd>the leaf of the bay tree
(<spn>Laurus nobilis</spn>). It has a fragrant odor and an aromatic
taste, and is used for flavoring in food.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bay</ent><br/
<hw>Bay</hw>, <pos>v. i.</pos> <vmorph>[<pos>imp. & p. p.</pos>
<conjf>Bayed</conjf> <pr>(b<amac/d)</pr>; <pos>p. pr. & vb. n.</pos>
<conjf>Baying</conjf>.]</vmorph> <ety>[OE. <ets>bayen</ets>,
<ets>abayen</ets>, OF. <ets>abaier</ets>, F. <ets>aboyer</ets>, to bark;
of uncertain origin.]</ety> <def>To bark, as a dog with a deep voice
does, at his game.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The hounds at nearer distance hoarsely <qex>bayed</qex>.</q>
<rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bay</ent><br/
<hw>Bay</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <def>To bark at; hence, to
follow with barking; to bring or drive to bay; <as>as, to <ex>bay</ex>
the bear</as>.</def> <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bay</ent><br/
<hw>Bay</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[See <er>Bay</er>,
<pos>v. i.</pos>]</ety> <sn>1.</sn> <def>Deep-toned, prolonged
barking.</def> <ldquo/The <xex>bay</xex> of curs.<rdquo/
<rj><au>Cowper.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <ety>[OE. <ets>bay</ets>, <ets>abay</ets>, OF.
<ets>abai</ets>, F. <ets>aboi</ets> barking, pl. <ets>abois</ets>, prop.
the extremity to which the stag is reduced when surrounded by the dogs,
barking (<ets>aboyant</ets>); <ets>aux abois</ets> at bay.]</ety> <def>A
state of being obliged to face an antagonist or a difficulty, when
escape has become impossible.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Embolden'd by despair, he stood at <qex>bay</qex>.</q>
<rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The most terrible evils are just kept at <qex>bay</qex> by
incessant efforts.</q> <rj><qau>I. Taylor</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bay</ent><br/
<hw>Bay</hw>, <pos>v. t.</pos> <ety>[Cf. OE. <ets>b<ae/wen</ets> to
bathe, and G. <ets>b<aum/hen</ets> to foment.]</ety> <def>To
bathe.</def> <mark>[Obs.]</mark> <rj><au>Spenser.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bay</ent><br/
<hw>Bay</hw>, <pos>n.</pos> <def>A bank or dam to keep back
water.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bay</ent><br/
<hw>Bay</hw>, <pos>v. t.</pos> <def>To dam, as water; -- with
<xex>up</xex> or <xex>back</xex>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baya</ent><br/
\'d8<hw>Ba"ya</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[Native
name.]</ety> <fld>(Zool.)</fld> <def>The East Indian weaver bird
(<spn>Ploceus Philippinus</spn>).</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bayatte</ent><br/
<ent>Bayad</ent><br/
<mhw>{ \'d8<hw>Ba*yad"</hw> <pr>(<?/)</pr>, <hw>Ba*yatte"</hw> }</mhw>
<pr>(<?/)</pr>, <pos>n.</pos> <ety>[Ar. <ets>bayad</ets>.]</ety>
<fld>(Zool.)</fld> <def>A large, edible, siluroid fish of the Nile, of
two species (<spn>Bagrina bayad</spn> and <spn>Bagrina
docmac</spn>).</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bayadere</ent><br/
<hw>Ba`ya*dere"</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[F., from Pg.
<ets>bailadeira</ets> a female dancer, <ets>bailar</ets> to
dance.]</ety> <def>A female dancer in the East Indies.</def>
<altsp>[Written also <asp>bajadere</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bayamo</ent><br/
<hw>Ba*ya"mo</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Meteor.)</fld>
<def>A violent thunder squall occurring on the south coast of Cuba, esp.
near Bayamo. The gusts, called <xex>bayamo winds</xex>, are modified
foehn winds.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Bay-antler</ent><br/
<hw>Bay"-ant`ler</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[See
<er>Bez-Antler</er>.]</ety> <fld>(Zool.)</fld> <def>The second tine of a
stag's horn. See under <er>Antler</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bayard</ent><br/
<hw>Bay"ard</hw> <pr>(<?/)</pr>, <pos>n.</pos> <sn>1.</sn> <ety>[OF.
<ets>bayard</ets>, <ets>baiart</ets>, bay horse; <ets>bai</ets> bay +
<ets>-ard</ets>. See <er>Bay</er>, <pos>a.</pos>, and
<er>-ard</er>.]</ety> <def>Properly, a bay horse, but often any horse.
Commonly in the phrase <xex>blind bayard</xex>, an old blind
horse.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Blind <qex>bayard</qex> moves the mill.</q>
<rj><qau>Philips.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <ety>[Cf. F. <ets>bayeur</ets>, fr. <ets>bayer</ets> to
gape.]</ety> <def>A stupid, clownish fellow.</def> <mark>[Obs.]</mark>
<rj><au>B. Jonson.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bayardly</ent><br/
<hw>Bay"ard*ly</hw>, <pos>a.</pos> <def>Blind; stupid.</def>
<mark>[Obs.]</mark> <ldquo/A formal and <xex>bayardly</xex> round of
duties.<rdquo/ <rj><au>Goodman.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bayberry</ent><br/
<hw>Bay"ber*ry</hw> <pr>(<?/)</pr>, <pos>n.</pos> <fld>(Bot.)</fld>
<sd>(a)</sd> <def>The fruit of the bay tree or <spn>Laurus
nobilis</spn>.</def> <sd>(b)</sd> <def>A tree of the West Indies related
to the myrtle (<spn>Pimenta acris</spn>).</def> <sd>(c)</sd> <def>The
fruit of <spn>Myrica cerifera</spn> (wax myrtle); the shrub itself; --
called also <altname>candleberry tree</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Bayberry tallow</b></col>, <cd>a fragrant green wax
obtained from the bayberry or wax myrtle; -- called also <altname>myrtle
wax</altname>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Baybolt</ent><br/
<hw>Bay"bolt`</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>A bolt with a
barbed shank.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bayed</ent><br/
<hw>Bayed</hw> <pr>(<?/)</pr>, <pos>a.</pos> <def>Having a bay or
bays.</def> <ldquo/The large <xex>bayed</xex> barn.<rdquo/
<rj><au>Drayton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bayeux tapestry</ent><br/
<hw>Ba`yeux" tap"es*try</hw> <pr>(?)</pr>. <def>A piece of linen about 1
ft. 8 in. wide by 213 ft. long, covered with embroidery representing the
incidents of William the Conqueror's expedition to England, preserved in
the town museum of Bayeux in Normandy. It is probably of the 11th
century, and is attributed by tradition to Matilda, the Conqueror's
wife.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Bay ice</ent><br/
<hw>Bay" ice`</hw> <pr>(<?/)</pr>. <def>See under
<er>Ice</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bay leaf</ent><br/
<hw>Bay" leaf`</hw> <pr>(<?/)</pr>. <def>See under 3d
<er>Bay</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bayman</ent><br/
<hw>Bay"man</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Nav.)</fld> <def>In
the United States navy, a sick-bay nurse; -- now officially designated
as <altname>hospital apprentice</altname>.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Bayonet</ent><br/
<hw>Bay"o*net</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[F.
<ets>bayonnette</ets>, <ets>ba<ium/onnette</ets>; -- so called, it is
said, because the first bayonets were made at
<etsep>Bayonne</etsep>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <fld>(Mil.)</fld> <def>A pointed instrument of the dagger
kind fitted on the muzzle of a musket or rifle, so as to give the
soldier increased means of offense and defense.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ Originally, the bayonet was made with a handle, which
required to be fitted into the bore of the musket after the soldier had
fired.</note><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Mach.)</fld> <def>A pin which plays in and out of
holes made to receive it, and which thus serves to engage or disengage
parts of the machinery.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Bayonet clutch</b></col>. <cd>See <er>Clutch</er>.</cd>
-- <col><b>Bayonet joint</b></col>, <cd>a form of coupling similar to
that by which a bayonet is fixed on the barrel of a musket.</cd>
<rj><au>Knight.</au></rj> -- <col><b>bayonet mount</b></col>,
<fld>(photography)</fld> <cd>a coupling mechanism for attaching
removable lenses to the body of a camera, using a <cref>bayonet
socket</cref>.</cd> -- <col><b>bayonet socket</b></col>, <cd>a coupling
mechanism for attaching matching cylindrical parts to each other, where
each of which has an arced L-shaped slot with the longer side
perpendicular to the axis of the cylinder, such that the slots slide
inside each other. There is also usually a knoblike projection on the
mount so that when the two parts to be connected are fully inserted in
proper alignment, they are locked in place. It is designed for rapid
coupling and decoupling, requiring the turning of one part through only
a small arc, in place of a screw-type arrangement, which requires
several full turns.</cd></cs><br/
[<source>1913 Webster</source> <source>+PJC</source>]</p>

<p><ent>Bayonet</ent><br/
<hw>Bay"o*net</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos>
<conjf>Bayoneted</conjf>; <pos>p. pr. & vb. n.</pos>
<conjf>Bayoneting</conjf>.]</vmorph> <sn>1.</sn> <def>To stab with a
bayonet.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To compel or drive by the bayonet.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>To <qex>bayonet</qex> us into submission.</q>
<rj><qau>Burke.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bayou</ent><br/
<hw>Bay"ou</hw> <pr>(<?/)</pr>, <pos>n.</pos>; <plu><it>pl.</it>
<plw>Bayous</plw> <pr>(<?/)</pr>.</plu> <ety>[North Am. Indian
<ets>bayuk</ets>, in F. spelling <ets>bayouc</ets>,
<ets>bayouque</ets>.]</ety> <def>An inlet from the Gulf of Mexico, from
a lake, or from a large river, sometimes sluggish, sometimes without
perceptible movement except from tide and wind.</def> <mark>[Southern U.
S.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>A dark slender thread of a <qex>bayou</qex> moves loiteringly
northeastward into a swamp of huge cypresses.</q> <rj><qau>G. W.
Cable.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bayou State</ent><br/
<hw>Bay"ou State`</hw> <pr>(?)</pr>. <def>Mississippi; -- a nickname,
from its numerous bayous.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Bay rum</ent><br/
<hw>Bay" rum"</hw> <pr>(<?/)</pr>. <def>A fragrant liquid, used for
cosmetic and medicinal purposes.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ The original bay rum, from the West Indies, is prepared,
it is believed, by distillation from the leaves of the bayberry
(<spn>Myrcia acris</spn>). The bay rum of the Pharmacop<oe/ia (spirit of
myrcia) is prepared from oil of myrcia (bayberry), oil of orange peel,
oil of pimento, alcohol, and water.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bayze</ent><br/
<ent>Bays</ent><br/
<mhw>{ <hw>Bays</hw>, <hw>Bayze</hw> }</mhw> <pr>(<?/)</pr>,
<pos>n.</pos> <def>See <er>Baize</er>.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bay salt</ent><br/
<hw>Bay" salt`</hw> <pr>(<?/)</pr>. <def>Salt which has been obtained
from sea water, by evaporation in shallow pits or basins, by the heat of
the sun; the large crystalline salt of commerce.</def> <rj><au>Bacon.
Ure.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bay State</ent><br/
<hw>Bay State</hw>. <def>Massachusetts, which had been called the Colony
of Massachusetts Bay; -- a nickname.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Bay tree</ent><br/
<hw>Bay" tree`</hw>. <def>A species of laurel. (<spn>Laurus
nobilis</spn>).</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bay window</ent><br/
<hw>Bay" win"dow</hw> <pr>(<?/)</pr>. <sn>1.</sn> <fld>(Arch.)</fld>
<def>A window forming a bay or recess in a room, and projecting outward
from the wall, either in a rectangular, polygonal, or semicircular form;
-- often corruptly called a <altname>bow window</altname>.</def><br/
<syn><b>Syn. --</b> bay window, bow window, bow-window.</syn><br/
[<source>1913 Webster</source> + <source>WordNet 1.5</source>]</p>

<p><sn>2.</sn> <def>a protruding abdomen.</def> <mark>[informal]</mark>
<br/
<syn><b>Syn. --</b> belly, paunch, pot, potbelly, corporation,
tummy.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Bay yarn</ent><br/
<hw>Bay" yarn`</hw> <pr>(<?/)</pr>. <def>Woolen yarn.</def> <mark>[Prov.
Eng.]</mark> <rj><au>Wright.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bazar</ent><br/
<ent>Bazaar</ent><br/
<mhw>{ <hw>Ba*zaar"</hw> <hw>Ba*zar"</hw> }</mhw>
<pr>(b<adot/*z<aum/r")</pr>, <pos>n.</pos> <ety>[Per.
<ets>b<amac/zar</ets> market.]</ety> <sn>1.</sn> <def>In the East, an
exchange, marketplace, or assemblage of shops where goods are exposed
for sale.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A spacious hall or suite of rooms for the sale of
goods, as at a fair.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>A fair for the sale of fancy wares, toys, etc.,
commonly for a charitable purpose.</def> <rj><au>Macaulay.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>B. C.</ent><br/
<ent>BC</ent><br/
<mhw><hw>BC</hw>, <hw>B. C.</hw></mhw> <pos>n.</pos> <def>before Christ;
used in reckoning dates before the supposed year Christ was born, i.e. 1
<sc>a. d.</sc>.</def> <br/
[<source>WordNet 1.5</source>]</p>

<p><ent>bdellium</ent><br/
<hw>bdel"lium</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[L., fr. Gr.
<grk>bde`llion</grk>; cf. Heb. <ets>b'dolakh</ets> bdellium (in sense
1).]</ety> <sn>1.</sn> <def>An unidentified substance mentioned in the
Bible (<au>Gen. ii. 12</au>, and <au>Num. xi. 7</au>), variously taken
to be a gum, a precious stone, or pearls, or perhaps a kind of amber
found in Arabia.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A gum resin of reddish brown color, brought from
India, Persia, and Africa.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ <stype>Indian bdellium</stype> or <stype>false
myrrh</stype> is an exudation from <spn>Balsamodendron Roxburghii</spn>.
Other kinds are known as <stype>African bdellium</stype>,
<stype>Sicilian bdellium</stype>, etc.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bdelloidea</ent><br/
\'d8<hw>Bdel*loi"de*a</hw> <pr>(<?/)</pr>, <pos>n. pl.</pos> <ety>[NL.,
fr. Gr. <grk>bde`lla</grk> leech + <ets>-oid</ets>.]</ety>
<fld>(Zool.)</fld> <def>The order of Annulata which includes the
leeches. See <er>Hirudinea</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bdellometer</ent><br/
<hw>Bdel*lom"e*ter</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[Gr.
<grk>bde`lla</grk> leech + <ets>-meter</ets>.]</ety> <fld>(Med.)</fld>
<def>A cupping glass to which are attached a scarificator and an
exhausting syringe.</def> <rj><au>Dunglison.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bdellomorpha</ent><br/
\'d8<hw>Bdel`lo*mor"pha</hw> <pr>(<?/)</pr>,<pos>n.</pos> <ety>[NL., fr.
Gr. <grk>bde`lla</grk> leech + <grk>morfh`</grk> form.]</ety>
<fld>(Zool.)</fld> <def>An order of Nemertina, including the large
leechlike worms (<gen>Malacobdella</gen>) often parasitic in
clams.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Be</ent><br/
<hw>Be</hw> <pr>(b<emac/)</pr>, <pos>v. i.</pos>
<vmorph>[<pos>imp.</pos> <conjf>Was</conjf> <pr>(w<ocr/z)</pr>; <pos>p.
p.</pos> <conjf>Been</conjf> <pr>(b<icr/n)</pr>; <pos>p. pr. & vb.
n.</pos> <conjf>Being</conjf>.]</vmorph> <ety>[OE. <ets>been</ets>,
<ets>beon</ets>, AS. <ets>be<oacute/n</ets> to be,
<ets>be<oacute/m</ets> I am; akin to OHG. <ets>bim</ets>,
<ets>pim</ets>, G. <ets>bin</ets>, I am, Gael. & Ir. <ets>bu</ets> was,
W. <ets>bod</ets> to be, Lith. <ets>bu-ti</ets>, O. Slav.
<ets>by-ti</ets>, to be, L. <ets>fu-i</ets> I have been,
<ets>fu-turus</ets> about to be, <ets>fo-re</ets> to be about to be, and
perh. to <ets>fieri</ets> to become, Gr. <grk>fy^nai</grk> to be born,
to be, Skr. <ets>bh<umac/</ets> to be. This verb is defective, and the
parts lacking are supplied by verbs from other roots, <ets>is</ets>,
<ets>was</ets>, which have no radical connection with <ets>be</ets>. The
various forms, <ets>am</ets>, <ets>are</ets>, <ets>is</ets>,
<ets>was</ets>, <ets>were</ets>, etc., are considered grammatically as
parts of the verb <ldquo/to be<rdquo/, which, with its conjugational
forms, is often called the <ets>substantive verb</ets>. <root/97. Cf.
<er>Future</er>, <er>Physic</er>.]</ety> <sn>1.</sn> <def>To exist
actually, or in the world of fact; to have existence.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>To <qex>be</qex> contents his natural desire.</q>
<rj><qau>Pope.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>To <qex>be</qex>, or not to <qex>be</qex>: that is the
question.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To exist in a certain manner or relation, -- whether
as a reality or as a product of thought; to exist as the subject of a
certain predicate, that is, as having a certain attribute, or as
belonging to a certain sort, or as identical with what is specified, --
a word or words for the predicate being annexed; <as>as, to <ex>be</ex>
happy; to <ex>be</ex> here; to <ex>be</ex> large, or strong; to
<ex>be</ex> an animal; to <ex>be</ex> a hero; to <ex>be</ex> a
nonentity; three and two <ex>are</ex> five; annihilation <ex>is</ex> the
cessation of existence; that <ex>is</ex> the man</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To take place; to happen; <as>as, the meeting
<ex>was</ex> on Thursday</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>To signify; to represent or symbolize; to answer
to.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The field <qex>is</qex> the world.</q> <rj><qau>Matt. xiii.
38.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The seven candlesticks which thou sawest <qex>are</qex> the seven
churches.</q> <rj><qau>Rev. i. 20.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ The verb <xex>to be</xex> (including the forms
<xex>is</xex>, <xex>was</xex>, etc.) is used in forming the passive
voice of other verbs; as, John has <ex>been</ex> struck by James. It is
also used with the past participle of many intransitive verbs to express
a state of the subject. But <xex>have</xex> is now more commonly used as
the auxiliary, though expressing a different sense; as, <ldquo/Ye have
come too late -- but ye <xex>are come</xex>. <rdquo/ <ldquo/The minstrel
boy to the war <xex>is gone</xex>.<rdquo/ The present and imperfect
tenses form, with the infinitive, a particular future tense, which
expresses necessity, duty, or purpose; as, government <xex>is</xex> to
be supported; we <xex>are</xex> to pay our just debts; the deed
<ex>is</ex> to be signed to-morrow.</note><br/
[<source>1913 Webster</source>]</p>

<p><note><xex>Have</xex> or <xex>had been</xex>, followed by
<xex>to</xex>, implies movement. <ldquo/I <xex>have been to</xex>
Paris.<rdquo/ <au>Sydney Smith.</au> <ldquo/<xex>Have</xex> you
<xex>been to</xex> Franchard ?<rdquo/ <au>R. L.
Stevenson.</au></note><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ <xex>Been</xex>, or <xex>ben</xex>, was anciently the
plural of the indicative present. <ldquo/Ye <xex>ben</xex> light of the
world.<rdquo/ <au>Wyclif, Matt. v. 14.</au> Afterwards <xex>be</xex> was
used, as in our Bible: <ldquo/They that <xex>be</xex> with us are more
than they that <ex>be</ex> with them.<rdquo/ <au>2 Kings vi. 16.</au>
<xex>Ben</xex> was also the old infinitive: <ldquo/To <xex>ben</xex> of
such power.<rdquo/ <au>R. of Gloucester.</au> <xex>Be</xex> is used as a
form of the present subjunctive: <ldquo/But if it <xex>be</xex> a
question of words and names.<rdquo/ <au>Acts xviii. 15.</au> But the
indicative forms, <ex>is</ex> and <ex>are</ex>, with <ex>if</ex>, are
more commonly used.</note><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Be it so</b></col>, <cd>a phrase of supposition,
equivalent to <sig>suppose it to be so</sig>; or of permission,
signifying <sig>let it be so</sig>.</cd> <au>Shak.</au> -- <col><b>If so
be</b></col>, <cd>in case.</cd> -- <col><b>To be from</b></col>, <cd>to
have come from; as, <xex>from</xex> what place <xex>are</xex> you? I
<xex>am from</xex> Chicago.</cd> -- <col><b>To let be</b></col>, <cd>to
omit, or leave untouched; to let alone.</cd> <ldquo/<xex>Let be</xex>,
therefore, my vengeance to dissuade.<rdquo/
<rj><au>Spenser.</au></rj></cs><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- <er>To be</er>, <er>Exist</er>.</syn> <usage> The
verb <xex>to be</xex>, except in a few rare cases, like that of
Shakespeare's <ldquo/To <xex>be</xex>, or not to <xex>be</xex><rdquo/,
is used simply as a <xex>copula</xex>, to connect a subject with its
predicate; as, man <xex>is</xex> mortal; the soul <xex>is</xex>
immortal. The verb <xex>to exist</xex> is never properly used as a mere
copula, but points to things that <xex>stand forth</xex>, or have a
substantive being; as, when the soul is freed from all corporeal
alliance, then it truly <xex>exists</xex>. It is not, therefore,
properly synonymous with <ex>to be</ex> when used as a copula, though
occasionally made so by some writers for the sake of variety; as in the
phrase <ldquo/there <xex>exists</xex> [<xex>is</xex>] no reason for
laying new taxes.<rdquo/ We may, indeed, say, <ldquo/a friendship has
long <xex>existed</xex> between them,<rdquo/ instead of saying,
<ldquo/there has long <xex>been</xex> a friendship between them;<rdquo/
but in this case, <xex>exist</xex> is not a mere copula. It is used in
its appropriate sense to mark the friendship as having been long in
<xex>existence</xex>.</usage><br/
[<source>1913 Webster</source>]</p>

<p><ent>Be-</ent><br/
<hw>Be-</hw>. <ety>[AS. <ets>be</ets>, and in accented form
<ets>b<imac/</ets>, akin to OS. <ets>be</ets> and <ets>b<imac/</ets>,
OHG. <ets>bi</ets>, <ets>pi</ets>, and <ets>p<imac/</ets>, MHG.
<ets>be</ets> and <ets>b<imac/</ets>, G. <ets>be</ets> and
<ets>bei</ets>, Goth. <ets>bi</ets>, and perh. Gr. <grk>'amfi`</grk>
about (cf. AS. <ets>be</ets>se<oacute/n to look about). <root/203. Cf.
<er>By</er>, <er>Amb-</er>.]</ety> <def>A prefix, originally the same
word as <xex>by</xex>;</def> joined with verbs, it serves: <sd>(a)</sd>
<def>To intensify the meaning; <as>as, <ex>be</ex>spatter,
<ex>be</ex>stir</as>.</def> <sd>(b)</sd> <def>To render an intransitive
verb transitive; <as>as, <ex>be</ex>fall (to fall upon);
<ex>be</ex>speak (to speak for)</as>.</def> <sd>(c)</sd> <def>To make
the action of a verb particular or definite; <as>as, <ex>be</ex>get (to
get as offspring); <ex>be</ex>set (to set around)</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><note>It is joined with certain substantives, and a few adjectives,
to form verbs; as, <xex>be</xex>dew, <xex>be</xex>friend,
<xex>be</xex>night, <xex>be</xex>sot; <xex>be</xex>late (to make late);
<xex>be</xex>little (to make little). It also occurs in certain nouns,
adverbs, and prepositions, often with something of the force of the
preposition <xex>by</xex>, or <xex>about</xex>; as, <xex>be</xex>lief
(believe), <xex>be</xex>half, <xex>be</xex>quest (bequeath);
<xex>be</xex>cause, <xex>be</xex>fore, <xex>be</xex>neath,
<xex>be</xex>side, <xex>be</xex>tween.<br/
In some words the original force of <xex>be</xex> is obscured or lost;
as, in <xex>be</xex>come, <xex>be</xex>gin, <xex>be</xex>have,
<xex>be</xex>hoove, <xex>be</xex>long.</note><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 127 pr=SA --></p>

<p><ent>Beach</ent><br/
<hw>Beach</hw> <pr>(b<emac/ch)</pr>, <pos>n.</pos>; <plu><it>pl.</it>
<plw>Beaches</plw> <pr>(-<ecr/z)</pr>.</plu> <ety>[Cf. Sw.
<ets>backe</ets> hill, Dan. <ets>bakke</ets>, Icel. <ets>bakki</ets>
hill, bank. Cf. <er>Bank</er>.]</ety> <sn>1.</sn> <def>Pebbles,
collectively; shingle.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The shore of the sea, or of a lake, which is washed
by the waves; especially, a sandy or pebbly shore; the strand.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Beach flea</b></col> <fld>(Zool.)</fld>, <cd>the common
name of many species of amphipod Crustacea, of the family
<fam>Orchestid<ae/</fam>, living on the sea beaches, and leaping like
fleas.</cd> -- <col><b>Beach grass</b></col> <fld>(Bot.)</fld>, <cd>a
coarse grass (<spn>Ammophila arundinacea</spn>), growing on the sandy
shores of lakes and seas, which, by its interlaced running rootstocks,
binds the sand together, and resists the encroachment of the waves.</cd>
-- <col><b>Beach wagon</b></col>, <cd>a light open wagon with two or
more seats.</cd> -- <col><b>Raised beach</b></col>, <cd>an accumulation
of water-worn stones, gravel, sand, and other shore deposits, above the
present level of wave action, whether actually raised by elevation of
the coast, as in Norway, or left by the receding waters, as in many lake
and river regions.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beach</ent><br/
<hw>Beach</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos>
<conjf>Beached</conjf> <pr>(b<emac/cht)</pr>; <pos>p. pr. & vb. n.</pos>
<conjf>Beaching</conjf>.]</vmorph> <def>To run or drive (as a vessel or
a boat) upon a beach; to strand; <as>as, to <ex>beach</ex> a
ship</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beach comber</ent><br/
<hw>Beach" comb`er</hw> <pr>(<?/)</pr>. <def>A long, curling wave
rolling in from the ocean. See <er>Comber</er>.</def> <mark>[Amer.,
archaic]</mark><br/
[<source>1913 Webster</source> <source>+PJC</source>]</p>

<p><ent>beachcomber</ent><br/
<hw>beachcomber</hw>. <altsp>[Written also <asp>beach-comber</asp> or
<asp>beach comber</asp>.]</altsp> <fld>(Naut.)</fld> <sn>1.</sn> <def>A
vagrant seaman, usually of low character, who loiters about seaports,
particularly on the shores and islands of the Pacific Ocean.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><q>I was fortunate enough, however, to forgather with a Scotchman who
was a <qex>beach-comber</qex>.</q> <rj><qau>F. T. Bullen.</qau></rj><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><sn>2.</sn> <def>a vagrant living on a beach.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><sn>3.</sn> <def>a person who searches along a beach for objects of
value, such as lost objects or seashells.</def><br/
[<source>PJC</source>]</p>

<p><ent>Beached</ent><br/
<hw>Beached</hw> <pr>(b<emac/cht)</pr>, <pos>p. p. & a.</pos>
<sn>1.</sn> <def>Bordered by a beach.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The <qex>beached</qex> verge of the salt flood.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Driven on a beach; stranded; drawn up on a beach;
<as>as, the ship is <ex>beached</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>beachhead</ent><br/
<hw>beach"head`</hw> <pos>n.</pos> <def>an area in hostile territory
that has been occupied and is held to allow additional troops and
supplies to enter.</def><br/
<syn><b>Syn. --</b> bridgehead, foothold.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>beachlike</ent><br/
<hw>beach"like`</hw> <pos>adj.</pos> <def>having an extensive gently
sloping area of sand or gravel; -- of a shore or shoreline. Opposite of
<ant>cliffy</ant>.</def> [Narrower terms: <stype>gravelly, pebbly,
shingly</stype>]<br/
<syn><b>Syn. --</b> beachy.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>beachwear</ent><br/
<hw>beach"wear</hw> <pos>n.</pos> <def>clothing to be worn at a
beach.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Beachy</ent><br/
<hw>Beach"y</hw> <pr>(<?/)</pr>, <pos>a.</pos> <def>Having a beach or
beaches; formed by a beach or beaches; shingly.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The <qex>beachy</qex> girdle of the ocean.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beacon</ent><br/
<hw>Bea"con</hw> <pr>(b<emac/"k'n)</pr>, <pos>n.</pos> <ety>[OE.
<ets>bekene</ets>, AS. <ets>be<aacute/cen</ets>, <ets>b<emac/cen</ets>;
akin to OS. <ets>b<omac/kan</ets>, Fries. <ets>baken</ets>,
<ets>beken</ets>, sign, signal, D. <ets>baak</ets>, OHG.
<ets>bouhhan</ets>, G. <ets>bake</ets>; of unknown origin. Cf.
<er>Beckon</er>.]</ety> <sn>1.</sn> <def>A signal fire to notify of the
approach of an enemy, or to give any notice, commonly of
warning.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>No flaming <qex>beacons</qex> cast their blaze afar.</q>
<rj><qau>Gay.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A signal, such as that from a lighthouse, or a
conspicuous mark erected on an eminence near the shore, or moored in
shoal water, as a guide to mariners.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>A high hill near the shore.</def> <mark>[Prov.
Eng.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>That which gives notice of danger.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Modest doubt is called<br/
The <qex>beacon</qex> of the wise.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <fld>(Navigation)</fld> <def>a radio transmitter which
emits a characteristic signal indication its location, so that vehicles
may determine their exact location by locating the beacon with a radio
compass; -- also called <altname><col><b>radio
beacon</b></col></altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <mark>[fig.]</mark> <def>that which provides guidance or
inspiration; <as>the Constitution has been a <ex>beacon</ex> for civil
rights activists</as>.</def><br/
[<source>PJC</source>]</p>

<p><cs><col><b>Beacon fire</b></col>, <cd>a signal fire.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beacon</ent><br/
<hw>Bea"con</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos>
<conjf>Beaconed</conjf> <pr>(b<emac/"k'nd)</pr>; <pos>p. pr. & vb.
n.</pos> <conjf>Beaconing</conjf>.]</vmorph> <sn>1.</sn> <def>To give
light to, as a beacon; to light up; to illumine.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>That <qex>beacons</qex> the darkness of heaven.</q>
<rj><qau>Campbell.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To furnish with a beacon or beacons.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beaconage</ent><br/
<hw>Bea"con*age</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>Money paid for
the maintenance of a beacon; also, beacons, collectively.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beaconless</ent><br/
<hw>Bea"con*less</hw>, <pos>a.</pos> <def>Having no beacon.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bead</ent><br/
<hw>Bead</hw> <pr>(b<emac/d)</pr>, <pos>n.</pos> <ety>[OE.
<ets>bede</ets> prayer, prayer bead, AS. <ets>bed</ets>,
<ets>gebed</ets>, prayer; akin to D. <ets>bede</ets>, G.
<ets>bitte</ets>, AS. <ets>biddan</ets>, to ask, bid, G.
<ets>bitten</ets> to ask, and perh. to Gr. <grk>pei`qein</grk> to
persuade, L. <ets>fidere</ets> to trust. Beads are used by the Roman
Catholics to count their prayers, one bead being dropped down a string
every time a prayer is said. Cf. Sp. <ets>cuenta</ets> bead, fr.
<ets>contar</ets> to count. See <er>Bid</er>, in <ets>to bid
beads</ets>, and <er>Bide</er>.]</ety> <sn>1.</sn> <def>A prayer.</def>
<mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A little perforated ball, to be strung on a thread,
and worn for ornament; or used in a rosary for counting prayers, as by
Roman Catholics and Muslims, whence the phrases <ecol><b>to tell
beads</b></ecol>, <col><b>to be at one's beads</b></col>, <col><b>to bid
beads</b></col>, etc., meaning, to be at prayer.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Any small globular body</def>; as, <sd>(a)</sd>
<def>A bubble in spirits.</def> <sd>(b)</sd> <def>A drop of sweat or
other liquid.</def> <ldquo/Cold <xex>beads</xex> of midnight dew.<rdquo/
<au>Wordsworth.</au> <sd>(c)</sd> <def>A small knob of metal on a
firearm, used for taking aim (whence the expression <xex>to draw a
bead</xex>, for, to take aim).</def> <sd>(d)</sd> <fld>(Arch.)</fld>
<def>A small molding of rounded surface, the section being usually an
arc of a circle. It may be continuous, or broken into short
embossments.</def> <sd>(e)</sd> <fld>(Chem.)</fld> <def>A glassy drop of
molten flux, as borax or microcosmic salt, used as a solvent and color
test for several mineral earths and oxides, as of iron, manganese, etc.,
before the blowpipe; <as>as, the borax <ex>bead</ex>; the iron
<ex>bead</ex>, etc.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Bead and butt</b></col> <fld>(Carp.)</fld>, <cd>framing
in which the panels are flush, having beads stuck or run upon the two
edges.</cd> <au>Knight.</au> -- <col><b>Bead mold</b></col>, <cd>a
species of fungus or mold, the stems of which consist of single cells
loosely jointed together so as to resemble a string of beads.</cd>
<altsp>[Written also <asp>bead mould</asp>.]</altsp> -- <col><b>Bead
tool</b></col>, <cd>a cutting tool, having an edge curved so as to make
beads or beading.</cd> -- <col><b>Bead tree</b></col> <fld>(Bot.)</fld>,
<cd>a tree of the genus <gen>Melia</gen>, the best known species of
which (<spn>Melia azedarach</spn>), has blue flowers which are very
fragrant, and berries which are poisonous.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bead</ent><br/
<hw>Bead</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos>
<conjf>Beaded</conjf>; <pos>p. pr. & vb. n.</pos>
<conjf>Beading</conjf>.]</vmorph> <def>To ornament with beads or
beading.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bead</ent><br/
<hw>Bead</hw>, <pos>v. i.</pos> <def>To form beadlike bubbles.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>beaded</ent><br/
<hw>beaded</hw> <pos>adj.</pos> <sn>1.</sn> <def><pos>imp. & p. p.</pos>
of <er>bead</er>, <pos>v. t. & i.</pos>.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><sn>2.</sn> <def>covered with beads or jewels or sequins.</def><br/
<syn><b>Syn. --</b> beady, bejeweled, bejewelled, bespangled, gemmed,
jeweled, jewelled, sequined, spangled, spangly.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><sn>3.</sn> <def>appearing as if covered with beads; <as>as, Her face
was <ex>beaded</ex> with sweat</as>.</def><br/
[<source>PJC</source>]</p>

<p><ent>Bedehouse</ent><br/
<ent>Beadhouse</ent><br/
<mhw>{ <hw>Bead"house`</hw>, <hw>Bede"house`</hw> }</mhw>
<pr>(<?/)</pr>, <pos>n.</pos> <ety>[OE. <ets>bede</ets> prayer + E.
<ets>house</ets>. See <er>Bead</er>, <pos>n.</pos>]</ety> <def>An
almshouse for poor people who pray daily for their
benefactors.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beading</ent><br/
<hw>Bead"ing</hw>, <pos>n.</pos> <sn>1.</sn> <fld>(Arch.)</fld>
<def>Molding in imitation of beads.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The beads or bead-forming quality of certain
liquors; <as>as, the <ex>beading</ex> of a brand of
whisky</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beadle</ent><br/
<hw>Bea"dle</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[OE.
<ets>bedel</ets>, <ets>bidel</ets>, <ets>budel</ets>, OF.
<ets>bedel</ets>, F. <ets>bedeau</ets>, fr. OHG. <ets>butil</ets>,
<ets>putil</ets>, G. <ets>b<uum/ttel</ets>, fr. OHG. <ets>biotan</ets>,
G. <ets>bieten</ets>, to bid, confused with AS. <ets>bydel</ets>, the
same word as OHG. <ets>butil</ets>. See. <er>Bid</er>,
<pos>v.</pos>]</ety> <sn>1.</sn> <def>A messenger or crier of a court; a
servitor; one who cites or bids persons to appear and answer; -- called
also an <altname>apparitor</altname> or
<altname>summoner</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>An officer in a university, who precedes public
processions of officers and students.</def> <mark>[Eng.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ In this sense the archaic spellings <xex>bedel</xex>
(Oxford) and <xex>bedell</xex> (Cambridge) are preserved.</note><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>An inferior parish officer in England having a
variety of duties, as the preservation of order in church service, the
chastisement of petty offenders, etc.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beadlery</ent><br/
<hw>Bea"dle*ry</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>Office or
jurisdiction of a beadle.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beadleship</ent><br/
<hw>Bea"dle*ship</hw>, <pos>n.</pos> <def>The state of being, or the
personality of, a beadle.</def> <rj><au>A. Wood.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bead proof</ent><br/
<hw>Bead" proof`</hw> <pr>(<?/)</pr>. <sn>1.</sn> <def>Among distillers,
a certain degree of strength in alcoholic liquor, as formerly
ascertained by the floating or sinking of glass globules of different
specific gravities thrown into it; now ascertained by more accurate
meters.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A degree of strength in alcoholic liquor as shown by
beads or small bubbles remaining on its surface, or at the side of the
glass, when shaken.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beadroll</ent><br/
<hw>Bead"roll`</hw> <pr>(<?/)</pr>, <pos>n.</pos> <fld>(R. C. Ch.)</fld>
<def>A catalogue of persons, for the rest of whose souls a certain
number of prayers are to be said or counted off on the beads of a
chaplet; hence, a catalogue in general.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>On Fame's eternal <qex>beadroll</qex> worthy to be filed.</q>
<rj><qau>Spenser.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>It is quite startling, on going over the <qex>beadroll</qex> of
English worthies, to find how few are directly represented in the male
line.</q> <rj><qau>Quart. Rev.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bedesman</ent><br/
<ent>Beadsman</ent><br/
<mhw>{ <hw>Beads"man</hw>, <hw>Bedes"man</hw> }</mhw> <pr>(<?/)</pr>,
<pos>n.</pos>; <plu><it>pl.</it> <plw>-men</plw> <pr>(<?/)</pr>.</plu>
<def>A poor man, supported in a beadhouse, and required to pray for the
soul of its founder; an almsman.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Whereby ye shall bind me to be your poor <qex>beadsman</qex> for
ever unto Almighty God.</q> <rj><qau>Fuller.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beadsnake</ent><br/
<hw>Bead"snake`</hw> <pr>(<?/)</pr>, <pos>n.</pos> <fld>(Zool.)</fld>
<def>A small poisonous snake of North America (<spn>Elaps
fulvius</spn>), banded with yellow, red, and black.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bedeswoman</ent><br/
<ent>Beadswoman</ent><br/
<mhw>{ <hw>Beads"wom`an</hw>, <hw>Bedes"wom`an</hw> }</mhw>
<pr>(<?/)</pr>, <pos>n.</pos>; <plu><it>pl.</it> <plw>-women</plw>
<pr>(<?/)</pr>.</plu> <def>Fem. of <er>Beadsman</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beadwork</ent><br/
<hw>Bead"work`</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>Ornamental work
in beads.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beady</ent><br/
<hw>Bead"y</hw> <pr>(<?/)</pr>, <pos>a.</pos> <sn>1.</sn>
<def>Resembling beads; small, round, and glistening.</def>
<ldquo/<xex>Beady</xex> eyes.<rdquo/ <rj><au>Thackeray.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Covered or ornamented with, or as with,
beads.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Characterized by beads; <as>as, <ex>beady</ex>
liquor</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>beady-eyed</ent><br/
<hw>beady-eyed</hw> <pos>adj.</pos> <sn>1.</sn> <def>having eyes that
gleam with malice.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Beagle</ent><br/
<hw>Bea"gle</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[OE.
<ets>begele</ets>; perh. of Celtic origin; cf. Ir. & Gael.
<ets>beag</ets> small, little, W. <ets>bach</ets>. F. <ets>bigle</ets>
is from English.]</ety> <sn>1.</sn> <def>A small hound, or hunting dog,
twelve to fifteen inches high, used in hunting hares and other small
game. See <xex>Illustration</xex> in Appendix.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Fig.: A spy or detective; a constable.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>beagling</ent><br/
<hw>beagling</hw> <pos>n.</pos> <def>hunting rabbits with
beagles.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Beak</ent><br/
<hw>Beak</hw> <pr>(b<emac/k)</pr>, <pos>n.</pos> <ety>[OE.
<ets>bek</ets>, F. <ets>bec</ets>, fr. Celtic; cf. Gael. & Ir.
<ets>bac</ets>, <ets>bacc</ets>, <ets>hook</ets>, W.
<ets>bach</ets>.]</ety> <sn>1.</sn> <fld>(Zool.)</fld> <sd>(a)</sd>
<def>The bill or nib of a bird, consisting of a horny sheath, covering
the jaws. The form varies much according to the food and habits of the
bird, and is largely used in the classification of birds.</def>
<sd>(b)</sd> <def>A similar bill in other animals, as the turtles.</def>
<sd>(c)</sd> <def>The long projecting sucking mouth of some insects, and
other invertebrates, as in the Hemiptera.</def> <sd>(d)</sd> <def>The
upper or projecting part of the shell, near the hinge of a
bivalve.</def> <sd>(e)</sd> <def>The prolongation of certain univalve
shells containing the canal.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Anything projecting or ending in a point, like a
beak, as a promontory of land.</def> <rj><au>Carew.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Antiq.)</fld> <def>A beam, shod or armed at the end
with a metal head or point, and projecting from the prow of an ancient
galley, in order to pierce the vessel of an enemy; a beakhead.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <fld>(Naut.)</fld> <def>That part of a ship, before the
forecastle, which is fastened to the stem, and supported by the main
knee.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <fld>(Arch.)</fld> <def>A continuous slight projection
ending in an arris or narrow fillet; that part of a drip from which the
water is thrown off.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <fld>(Bot.)</fld> <def>Any process somewhat like the beak
of a bird, terminating the fruit or other parts of a plant.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>7.</sn> <fld>(Far.)</fld> <def>A toe clip. See <er>Clip</er>,
<pos>n.</pos> <fld>(Far.)</fld>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>8.</sn> <def>A magistrate or policeman.</def> <mark>[Slang,
Eng.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beaked</ent><br/
<hw>Beaked</hw> <pr>(b<emac/kt)</pr>, <pos>a.</pos> <sn>1.</sn>
<def>Having a beak or a beaklike point; beak-shaped.</def> <ldquo/Each
<xex>beaked</xex> promontory.<rdquo/ <rj><au>Milton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Biol.)</fld> <def>Furnished with a process or a
mouth like a beak; rostrate.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Beaked whale</b></col> <fld>(Zool.)</fld>, <cd>a cetacean
of the genus <gen>Hyperoodon</gen>; the bottlehead whale.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beaker</ent><br/
<hw>Beak"er</hw> <pr>(b<emac/k"<etil/r)</pr>, <pos>n.</pos> <ety>[OE.
<ets>biker</ets>; akin to Icel. <ets>bikarr</ets>, Sw.
<ets>b<aum/gare</ets>, Dan. <ets>baeger</ets>, G. <ets>becher</ets>, It.
<ets>bicchiere</ets>; -- all fr. LL. <ets>bicarium</ets>, prob. fr. Gr.
<grk>bi^kos</grk> wine jar, or perh. L. <ets>bacar</ets> wine vessel.
Cf. <er>Pitcher</er> a jug.]</ety> <sn>1.</sn> <def>A large drinking
cup, with a wide mouth, supported on a foot or standard.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>An open-mouthed, thin glass vessel, having a
projecting lip for pouring; -- used for holding solutions requiring
heat.</def> <rj><au>Knight.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beakhead</ent><br/
<hw>Beak"head`</hw> <pr>(<?/)</pr>, <pos>n.</pos> <sn>1.</sn>
<fld>(Arch.)</fld> <def>An ornament used in rich Norman doorways,
resembling a head with a beak.</def> <rj><au>Parker.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Naut.)</fld> <sd>(a)</sd> <def>A small platform at
the fore part of the upper deck of a vessel, which contains the water
closets of the crew.</def> <sd>(b)</sd> <fld>(Antiq.)</fld> <def>Same as
<er>Beak</er>, 3.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beakiron</ent><br/
<hw>Beak"i*ron</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[From
<er>Bickern</er>.]</ety> <def>A bickern; a bench anvil with a long beak,
adapted to reach the interior surfaces of sheet metal ware; the horn of
an anvil.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beal</ent><br/
<hw>Beal</hw> <pr>(b<emac/l)</pr>, <pos>n.</pos> <ety>[See <er>Boil</er>
a tumor.]</ety> <fld>(Med.)</fld> <def>A small inflammatory tumor; a
pustule.</def> <mark>[Prov. Eng.]</mark> <br/
[<source>1913 Webster</source>]</p>

<p><ent>Beal</ent><br/
<hw>Beal</hw>, <pos>v. i.</pos> <vmorph>[<pos>imp. & p. p.</pos>
<conjf>Bealed</conjf> <pr>(<?/)</pr>; <pos>p. pr. & vb. n.</pos>
<conjf>Bealing</conjf>.]</vmorph> <def>To gather matter; to swell and
come to a head, as a pimple.</def> <mark>[Prov. Eng.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Be-all</ent><br/
<hw>Be"-all`</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>The whole; all that
is to be.</def> <mark>[Poetic]</mark> <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beam</ent><br/
<hw>Beam</hw> <pr>(b<emac/m)</pr>, <pos>n.</pos> <ety>[AS.
<ets>be<aacute/m</ets> beam, post, tree, ray of light; akin to OFries.
<ets>b<amac/m</ets> tree, OS. <ets>b<omac/m</ets>, D. <ets>boom</ets>,
OHG. <ets>boum</ets>, <ets>poum</ets>, G. <ets>baum</ets>, Icel.
<ets>ba<edh/mr</ets>, Goth. <ets>bagms</ets> and Gr. <grk>fy^ma</grk> a
growth, <grk>fy^nai</grk> to become, to be. Cf. L. <ets>radius</ets>
staff, rod, spoke of a wheel, beam or ray, and G. <ets>strahl</ets>
arrow, spoke of a wheel, ray or beam, flash of lightning. <root/97. See
<er>Be</er>; cf. <er>Boom</er> a spar.]</ety> <sn>1.</sn> <def>Any large
piece of timber or iron long in proportion to its thickness, and
prepared for use.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>One of the principal horizontal timbers of a
building or ship.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The <qex>beams</qex> of a vessel are strong pieces of timber
stretching across from side to side to support the decks.</q>
<rj><qau>Totten.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>The width of a vessel; <as>as, one vessel is said to
have more <ex>beam</ex> than another</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>The bar of a balance, from the ends of which the
scales are suspended.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The doubtful <qex>beam</qex> long nods from side to side.</q>
<rj><qau>Pope.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>The principal stem or horn of a stag or other deer,
which bears the antlers, or branches.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <def>The pole of a carriage.</def> <mark>[Poetic]</mark>
<rj><au>Dryden.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>7.</sn> <def>A cylinder of wood, making part of a loom, on which
weavers wind the warp before weaving; also, the cylinder on which the
cloth is rolled, as it is woven; one being called the <xex>fore
beam</xex>, the other the <xex>back beam</xex>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>8.</sn> <def>The straight part or shank of an anchor.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>9.</sn> <def>The main part of a plow, to which the handles and
colter are secured, and to the end of which are attached the oxen or
horses that draw it.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>10.</sn> <fld>(Steam Engine)</fld> <def>A heavy iron lever having
an oscillating motion on a central axis, one end of which is connected
with the piston rod from which it receives motion, and the other with
the crank of the wheel shaft; -- called also <altname>working
beam</altname> or <altname>walking beam</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>11.</sn> <def>A ray or collection of parallel rays emitted from
the sun or other luminous body; <as>as, a <ex>beam</ex> of light, or of
heat</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>How far that little candle throws his <qex>beams</qex>!</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>12.</sn> <mark>(Fig.)</mark>: <def>A ray; a gleam; <as>as, a
<ex>beam</ex> of comfort</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Mercy with her genial <qex>beam</qex>.</q>
<rj><qau>Keble.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>13.</sn> <def>One of the long feathers in the wing of a hawk; --
called also <altname>beam feather</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Abaft the beam</b></col> <fld>(Naut.)</fld>, <cd>in an
arc of the horizon between a line that crosses the ship at right angles,
or in the direction of her beams, and that point of the compass toward
which her stern is directed.</cd> -- <col><b>Beam center</b></col>
<fld>(Mach.)</fld>, <cd>the fulcrum or pin on which the working beam of
an engine vibrates.</cd> -- <col><b>Beam compass</b></col>, <cd>an
instrument consisting of a rod or beam, having sliding sockets that
carry steel or pencil points; -- used for drawing or describing large
circles.</cd> -- <col><b>Beam engine</b></col>, <cd>a steam engine
having a working beam to transmit power, in distinction from one which
has its piston rod attached directly to the crank of the wheel
shaft.</cd> -- <col><b>Before the beam</b></col> <fld>(Naut.)</fld>,
<cd>in an arc of the horizon included between a line that crosses the
ship at right angles and that point of the compass toward which the ship
steers.</cd> -- <col><b>On the beam</b></col>, <cd>in a line with the
beams, or at right angles with the keel.</cd> -- <col><b>On the weather
beam</b></col>, <cd>on the side of a ship which faces the wind.</cd> --
<col><b>To be on her beam ends</b></col>, <cd>to incline, as a vessel,
so much on one side that her beams approach a vertical
position.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beam</ent><br/
<hw>Beam</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos>
<conjf>Beamed</conjf> <pr>(b<emac/md)</pr>; <pos>p. pr. & vb. n.</pos>
<conjf>Beaming</conjf>.]</vmorph> <def>To send forth; to emit; --
followed ordinarily by <ptcl>forth</ptcl>; <as>as, to <ex>beam</ex>
forth light</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beam</ent><br/
<hw>Beam</hw>, <pos>v. i.</pos> <def>To emit beams of light.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>He <qex>beamed</qex>, the daystar of the rising age.</q>
<rj><qau>Trumbull.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beambird</ent><br/
<hw>Beam"bird`</hw> <pr>(<?/)</pr>, <pos>n.</pos> <fld>(Zool.)</fld>
<def>A small European flycatcher (<spn>Muscicapa grisola</spn>), so
called because it often nests on a beam in a building.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beamed</ent><br/
<hw>Beamed</hw> <pr>(<?/)</pr>, <pos>a.</pos> <def>Furnished with beams,
as the head of a stag.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Tost his <qex>beamed</qex> frontlet to the sky.</q> <rj><qau>Sir
W. Scott.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beamful</ent><br/
<hw>Beam"ful</hw> <pr>(<?/)</pr>, <pos>a.</pos> <def>Beamy;
radiant.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beamily</ent><br/
<hw>Beam"i*ly</hw> <pr>(<?/)</pr>, <pos>adv.</pos> <def>In a beaming
manner.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beaminess</ent><br/
<hw>Beam"i*ness</hw>, <pos>n.</pos> <def>The state of being
beamy.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beaming</ent><br/
<hw>Beam"ing</hw>, <pos>a.</pos> <def>Emitting beams; radiant.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beamingly</ent><br/
<hw>Beam"ing*ly</hw>, <pos>adv.</pos> <def>In a beaming manner;
radiantly.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beamless</ent><br/
<hw>Beam"less</hw>, <pos>a.</pos> <sn>1.</sn> <def>Not having a
beam.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Not emitting light.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beamlet</ent><br/
<hw>Beam"let</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>A small beam of
light.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beam tree</ent><br/
<hw>Beam" tree`</hw> <pr>(<?/)</pr>. <ety>[AS. <ets>be<aacute/m</ets> a
tree. See <er>Beam</er>.]</ety> <fld>(Bot.)</fld> <def>A tree
(<spn>Pyrus aria</spn>) related to the apple.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beamy</ent><br/
<hw>Beam"y</hw> <pr>(<?/)</pr>, <pos>a.</pos> <sn>1.</sn> <def>Emitting
beams of light; radiant; shining.</def> <ldquo/<xex>Beamy</xex>
gold.<rdquo/ <rj><au>Tickell.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 128 pr=SA --></p>

<p><sn>2.</sn> <def>Resembling a beam in size and weight;
massy.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>His double-biting ax, and <qex>beamy</qex> spear.</q>
<rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Having horns, or antlers.</def><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>Beamy</qex> stags in toils engage.</q>
<rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bean</ent><br/
<hw>Bean</hw> <pr>(b<emac/n)</pr>, <pos>n.</pos> <ety>[OE.
<ets>bene</ets>, AS. <ets>be<aacute/n</ets>; akin to D. <ets>boon</ets>,
G. <ets>bohne</ets>, OHG. <ets>p<omac/na</ets>, Icel. <ets>baun</ets>,
Dan. <ets>b<oum/nne</ets>, Sw. <ets>b<oum/na</ets>, and perh. to Russ.
<ets>bob</ets>, L. <ets>faba</ets>.]</ety> <sn>1.</sn> <fld>(Bot.)</fld>
<def>A name given to the seed of certain leguminous herbs, chiefly of
the genera <gen>Faba</gen>, <gen>Phaseolus</gen>, and
<gen>Dolichos</gen>; also, to the herbs.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ The origin and classification of many kinds are still
doubtful. Among true beans are: the black-eyed bean and China bean,
included in <spn>Dolichos Sinensis</spn>; black Egyptian bean or
hyacinth bean, <spn>Dolichos Lablab</spn>; the common haricot beans,
kidney beans, string beans, and pole beans, all included in
<spn>Phaseolus vulgaris</spn>; the lower bush bean, <spn>Phaseolus
vulgaris</spn>, variety <varn>nanus</varn>; Lima bean, <spn>Phaseolus
lunatus</spn>; Spanish bean and scarlet runner, <spn>Phaseolus
multiflorus</spn>; Windsor bean, the common bean of England, <spn>Faba
vulgaris</spn>.</note><br/
[<source>1913 Webster</source>]</p>

<p>As an article of food beans are classed with vegetables.<br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The popular name of other vegetable seeds or fruits,
more or less resembling true beans.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Bean aphis</b></col> <fld>(Zool.)</fld>, <cd>a plant
louse (<spn>Aphis fab<ae/</spn>) which infests the bean plant.</cd> --
<col><b>Bean fly</b></col> <fld>(Zool.)</fld>, <cd>a fly found on bean
flowers.</cd> -- <col><b>Bean goose</b></col> <fld>(Zool.)</fld>, <cd>a
species of goose (<spn>Anser segetum</spn>).</cd> -- <col><b>Bean
weevil</b></col> <fld>(Zool.)</fld>, <cd>a small weevil that in the
larval state destroys beans. The American species is <spn>Bruchus
fab<ae/</spn>.</cd> -- <col><b>Florida bean</b></col> <fld>(Bot.)</fld>,
<cd>the seed of <spn>Mucuna urens</spn>, a West Indian plant. The seeds
are washed up on the Florida shore, and are often polished and made into
ornaments.</cd> -- <mcol><col><b>Ignatius bean</b></col>, or <col><b>St.
Ignatius's bean</b></col></mcol> <fld>(Bot.)</fld>, <cd>a species of
<gen>Strychnos</gen>.</cd> -- <col><b>Navy bean</b></col>, <cd>the
common dried white bean of commerce; probably so called because an
important article of food in the navy.</cd> -- <col><b>Pea
bean</b></col>, <cd>a very small and highly esteemed variety of the
edible white bean; -- so called from its size.</cd> -- <col><b>Sacred
bean</b></col>. <cd>See under <er>Sacred</er>.</cd> -- <col><b>Screw
bean</b></col>. <cd>See under <er>Screw</er>.</cd> -- <col><b>Sea
bean</b></col>. <sd>(a)</sd> <cd>Same as <er>Florida bean</er>.</cd>
<sd>(b)</sd> <cd>A red bean of unknown species used for ornament.</cd>
-- <mcol><col><b>Tonquin bean</b></col>, or <col><b>Tonka
bean</b></col></mcol>, <cd>the fragrant seed of <spn>Dipteryx
odorata</spn>, a leguminous tree.</cd> -- <col><b>Vanilla
bean</b></col>. <cd>See under <er>Vanilla</er>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>beanbag</ent><br/
<hw>bean"bag`</hw> <pos>n.</pos> <def>a small cloth bag filled with
dried beans; it is thrown from person to person in games.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>beanball</ent><br/
<hw>bean"ball`</hw> <pos>n.</pos> <def>a baseball deliberately thrown at
the batter's head.</def><br/
<syn><b>Syn. --</b> beaner.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Bean caper</ent><br/
<hw>Bean" ca`per</hw>. <fld>(Bot.)</fld> <def>A deciduous plant of warm
climates, generally with fleshy leaves and flowers of a yellow or
whitish yellow color, of the genus <gen>Zygophyllum</gen>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>beaner</ent><br/
<hw>beaner</hw> <pos>n.</pos> <def>a baseball deliberately thrown at the
batter's head.</def><br/
<syn><b>Syn. --</b> beanball.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>beanfeast</ent><br/
<hw>beanfeast</hw> <pos>n.</pos> <def>(British) an annual dinner party
given by an employer for the employees.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>beanie</ent><br/
<hw>beanie</hw> <pos>n.</pos> <def>a small skullcap; formerly worn by
schoolboys and college freshmen.</def><br/
<syn><b>Syn. --</b> beany.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>beano</ent><br/
<hw>beano</hw> <pos>n.</pos> <sn>1.</sn> <def>a game in which numbered
balls are drawn and random and players cover the corresponding numbers
on their cards.</def><br/
<syn><b>Syn. --</b> lotto, bingo, keno.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>beanstalk</ent><br/
<hw>beanstalk</hw> <pos>n.</pos> <sn>1.</sn> <def>stem of a bean
plant.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Bean trefoil</ent><br/
<hw>Bean" tre"foil</hw>. <fld>(Bot.)</fld> <def>A leguminous shrub of
southern Europe, with trifoliate leaves (<spn>Anagyris
foetida</spn>).</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>beany</ent><br/
<hw>bean"y</hw> <pos>n.</pos> <def>same as <er>beanie</er>.</def><br/
<syn><b>Syn. --</b> beanie.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Bear</ent><br/
<hw>Bear</hw> <pr>(b<acir/r)</pr>, <pos>v. t.</pos>
<vmorph>[<pos>imp.</pos> <conjf>Bore</conjf> <pr>(b<omac/r)</pr>
(formerly <conjf>Bare</conjf> <pr>(b<acir/r)</pr>); <pos>p. p.</pos>
<conjf>Born</conjf> <pr>(b<ocir/rn)</pr>, <conjf>Borne</conjf>
(b<omac/rn); <pos>p. pr. & vb. n.</pos>
<conjf>Bearing</conjf>.]</vmorph> <ety>[OE. <ets>beren</ets>, AS.
<ets>beran</ets>, <ets>beoran</ets>, to bear, carry, produce; akin to D.
<ets>baren</ets> to bring forth, G. <ets>geb<aum/ren</ets>, Goth.
<ets>ba<iacute/ran</ets> to bear or carry, Icel. <ets>bera</ets>, Sw.
<ets>b<aum/ra</ets>, Dan. <ets>b<ae/re</ets>, OHG. <ets>beran</ets>,
<ets>peran</ets>, L. <ets>ferre</ets> to bear, carry, produce, Gr.
<grk>fe`rein</grk>, OSlav. <ets>brati</ets> to take, carry, OIr.
<ets>berim</ets> I bear, Skr. <ets>bh<rsdot/</ets> to bear. <root/92.
Cf. <er>Fertile</er>.]</ety> <sn>1.</sn> <def>To support or sustain; to
hold up.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To support and remove or carry; to convey.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>I 'll <qex>bear</qex> your logs the while.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To conduct; to bring; -- said of persons.</def>
<mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>Bear</qex> them to my house.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>To possess and use, as power; to exercise.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Every man should <qex>bear</qex> rule in his own house.</q>
<rj><qau>Esther i. 22.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>To sustain; to have on (written or inscribed, or as
a mark), <as>as, the tablet <ex>bears</ex> this
inscription</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <def>To possess or carry, as a mark of authority or
distinction; to wear; <as>as, to <ex>bear</ex> a sword, badge, or
name</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>7.</sn> <def>To possess mentally; to carry or hold in the mind;
to entertain; to harbor</def> <rj><au>Dryden.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The ancient grudge I <qex>bear</qex> him.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>8.</sn> <def>To endure; to tolerate; to undergo; to
suffer.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Should such a man, too fond to rule alone,<br/
<qex>Bear</qex>, like the Turk, no brother near the throne.</q>
<rj><qau>Pope.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>I cannot <qex>bear</qex><br/
The murmur of this lake to hear.</q> <rj><qau>Shelley.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>My punishment is greater than I can <qex>bear</qex>.</q>
<rj><qau>Gen. iv. 13.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>9.</sn> <def>To gain or win.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>Some think to <qex>bear</qex> it by speaking a great word.</q>
<rj><qau>Bacon.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>She was . . . found not guilty, through <qex>bearing</qex> of
friends and bribing of the judge.</q> <rj><qau>Latimer.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>10.</sn> <def>To sustain, or be answerable for, as blame,
expense, responsibility, etc.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>He shall <qex>bear</qex> their iniquities.</q> <rj><qau>Is. liii.
11.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Somewhat that will <qex>bear</qex> your charges.</q>
<rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>11.</sn> <def>To render or give; to bring forward.</def>
<ldquo/Your testimony <xex>bear</xex><rdquo/
<rj><au>Dryden.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>12.</sn> <def>To carry on, or maintain; to have.</def> <ldquo/The
credit of <xex>bearing</xex> a part in the conversation.<rdquo/
<rj><au>Locke.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>13.</sn> <def>To admit or be capable of; that is, to suffer or
sustain without violence, injury, or change.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>In all criminal cases the most favorable interpretation should be
put on words that they can possibly <qex>bear</qex>.</q>
<rj><qau>Swift.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>14.</sn> <def>To manage, wield, or direct.</def> <ldquo/Thus must
thou thy body <xex>bear</xex>.<rdquo/ <au>Shak.</au> Hence: <def>To
behave; to conduct.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Hath he <qex>borne</qex> himself penitently in prison?</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>15.</sn> <def>To afford; to be to; to supply with.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>His faithful dog shall <qex>bear</qex> him company.</q>
<rj><qau>Pope.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>16.</sn> <def>To bring forth or produce; to yield; <as>as, to
<ex>bear</ex> apples; to <ex>bear</ex> children; to <ex>bear</ex>
interest</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Here dwelt the man divine whom Samos <qex>bore</qex>.</q>
<rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ In the passive form of this verb, the best modern usage
restricts the past participle <xex>born</xex> to the sense of
<xex>brought forth</xex>, while <xex>borne</xex> is used in the other
senses of the word. In the active form, <xex>borne</xex> alone is used
as the past participle.</note><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>To bear down</b></col>. <sd>(a)</sd> <cd>To force into a
lower place; to carry down; to depress or sink.</cd> <ldquo/His nose, .
. . large as were the others, <xex>bore</xex> them <xex>down</xex> into
insignificance.<rdquo/ <au>Marryat.</au> <sd>(b)</sd> <cd>To overthrow
or crush by force; <as>as, to <ex>bear down</ex> an enemy</as>.</cd> --
<col><b>To bear a hand</b></col>. <sd>(a)</sd> <cd>To help; to give
assistance.</cd> <sd>(b)</sd> <fld>(Naut.)</fld> <cd>To make haste; to
be quick.</cd> -- <col><b>To bear in hand</b></col>, <cd>to keep (one)
up in expectation, usually by promises never to be realized; to amuse by
false pretenses; to delude.</cd> <mark>[Obs.]</mark> <ldquo/How you were
<xex>borne in hand</xex>, how crossed.<rdquo/ <au>Shak.</au> --
<col><b>To bear in mind</b></col>, <cd>to remember.</cd> -- <col><b>To
bear off</b></col>. <sd>(a)</sd> <cd>To restrain; to keep from
approach.</cd> <sd>(b)</sd> <fld>(Naut.)</fld> <cd>To remove to a
distance; to keep clear from rubbing against anything; <as>as, to
<ex>bear off</ex> a blow; to <ex>bear off</ex> a boat</as>.</cd>
<sd>(c)</sd> <cd>To gain; to carry off, as a prize.</cd> <sd>(d)</sd>
<fld>(Backgammon)</fld> <cd>To remove from the backgammon board into the
home when the position of the piece and the dice provide the proper
opportunity; -- the goal of the game is to <ex>bear off</ex> all of
one's men before the opponent.</cd> -- <col><b>To bear one
hard</b></col>, <cd>to owe one a grudge.</cd> <mark>[Obs.]</mark>
<ldquo/C<ae/sar doth <xex>bear me hard</xex>.<rdquo/ <au>Shak.</au> --
<col><b>To bear out</b></col>. <sd>(a)</sd> <cd>To maintain and support
to the end; to defend to the last.</cd> <ldquo/Company only can
<xex>bear</xex> a man <xex>out</xex> in an ill thing.<rdquo/
<au>South.</au> <sd>(b)</sd> <cd>To corroborate; to confirm.</cd> --
<col><b>To bear up</b></col>, <cd>to support; to keep from falling or
sinking.</cd> <ldquo/Religious hope <xex>bears up</xex> the mind under
sufferings.<rdquo/ <au>Addison.</au></cs><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- To uphold; sustain; maintain; support; undergo;
suffer; endure; tolerate; carry; convey; transport; waft.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bear</ent><br/
<hw>Bear</hw> <pr>(b<acir/r)</pr>, <pos>v. i.</pos> <sn>1.</sn> <def>To
produce, as fruit; to be fruitful, in opposition to
barrenness.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>This age to blossom, and the next to <qex>bear</qex>.</q>
<rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To suffer, as in carrying a burden.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>But man is born to <qex>bear</qex>.</q>
<rj><qau>Pope.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To endure with patience; to be patient.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>I can not, can not <qex>bear</qex>.</q>
<rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>To press; -- with <xex>on</xex> or <xex>upon</xex>,
or <xex>against</xex>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>These men <qex>bear</qex> hard on the suspected party.</q>
<rj><qau>Addison.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>To take effect; to have influence or force; <as>as,
to bring matters to <ex>bear</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <def>To relate or refer; -- with <xex>on</xex> or
<xex>upon</xex>; as, how does this <xex>bear</xex> on the
question?</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>7.</sn> <def>To have a certain meaning, intent, or
effect.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Her sentence <qex>bore</qex> that she should stand a certain time
upon the platform.</q> <rj><qau>Hawthorne.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>8.</sn> <def>To be situated, as to the point of compass, with
respect to something else; <as>as, the land <ex>bears</ex> N. by
E.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>To bear against</b></col>, <cd>to approach for attack or
seizure; <as>as, a lion <ex>bears against</ex> his prey</as>.</cd>
<mark>[Obs.]</mark> -- <col><b>To bear away</b></col>
<fld>(Naut.)</fld>, <cd>to change the course of a ship, and make her run
before the wind.</cd> -- <col><b>To bear back</b></col>, <cd>to
retreat.</cd> <ldquo/<xex>Bearing back</xex> from the blows of their
sable antagonist.<rdquo/ <au>Sir W. Scott.</au> -- <col><b>To bear down
upon</b></col> <fld>(Naut.)</fld>, <cd>to approach from the windward
side; <as>as, the fleet <ex>bore down upon</ex> the enemy</as>.</cd> --
<col><b>To bear in with</b></col> <fld>(Naut.)</fld>, <cd>to run or tend
toward; <as>as, a ship <ex>bears in with</ex> the land</as>.</cd> --
<col><b>To bear off</b></col> <fld>(Naut.)</fld>, <cd>to steer away, as
from land.</cd> -- <col><b>To bear up</b></col>. <sd>(a)</sd> <cd>To be
supported; to have fortitude; to be firm; not to sink; <as>as, to
<ex>bear up</ex> under afflictions</as>.</cd> <sd>(b)</sd>
<fld>(Naut.)</fld> <cd>To put the helm up (or to windward) and so put
the ship before the wind; to bear away.</cd> <au>Hamersly.</au> --
<col><b>To bear upon</b></col> <fld>(Mil.)</fld>, <cd>to be pointed or
situated so as to affect; to be pointed directly against, or so as to
hit (the object); <as>as, to bring or plant guns so as to <ex>bear
upon</ex> a fort or a ship; the artillery <ex>bore upon</ex> the
center</as>.</cd> -- <col><b>To bear up to</b></col>, <cd>to tend or
move toward; <as>as, to <ex>bear up to</ex> one another</as>.</cd> --
<col><b>To bear with</b></col>, <cd>to endure; to be indulgent to; to
forbear to resent, oppose, or punish.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bear</ent><br/
<hw>Bear</hw> <pr>(b<emac/r)</pr>, <pos>n.</pos> <def>A bier.</def>
<mark>[Obs.]</mark> <rj><au>Spenser.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bear</ent><br/
<hw>Bear</hw> <pr>(b<acir/r)</pr>, <pos>n.</pos> <ety>[OE.
<ets>bere</ets>, AS. <ets>bera</ets>; akin to D. <ets>beer</ets>, OHG.
<ets>bero</ets>, <ets>pero</ets>, G. <ets>b<aum/r</ets>, Icel. & Sw.
<ets>bj<oum/rn</ets>, and possibly to L. <ets>fera</ets> wild beast, Gr.
<grk>fh`r</grk> beast, Skr. <ets>bhalla</ets> bear.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <fld>(Zool.)</fld> <def>Any species of the genus
<gen>Ursus</gen>, and of the closely allied genera. Bears are
plantigrade <ord>Carnivora</ord>, but they live largely on fruit and
insects.</def><br/
[<source>1913 Webster</source>]</p>

<p><note>The European brown bear (<spn>Ursus arctos</spn>), the white
polar bear (<spn>Ursus maritimus</spn>), the grizzly bear (<spn>Ursus
horribilis</spn>), the American black bear, and its variety the cinnamon
bear (<spn>Ursus Americanus</spn>), the Syrian bear (<spn>Ursus
Syriacus</spn>), and the sloth bear, are among the notable
species.</note><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Zool.)</fld> <def>An animal which has some
resemblance to a bear in form or habits, but no real affinity; <as>as,
the woolly <ex>bear</ex>; ant <ex>bear</ex>; water <ex>bear</ex>; sea
<ex>bear.</ex></as></def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Astron.)</fld> <def>One of two constellations in
the northern hemisphere, called respectively the <stype>Great
Bear</stype> and the <stype>Lesser Bear</stype>, or <stype>Ursa
Major</stype> and <stype>Ursa Minor</stype>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>Metaphorically: A brutal, coarse, or morose
person.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <fld>(Stock Exchange)</fld> <def>A person who sells
stocks or securities for future delivery in expectation of a fall in the
market.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ The <xex>bears</xex> and <xex>bulls</xex> of the Stock
Exchange, whose interest it is, the one to depress, and the other to
raise, stocks, are said to be so called in allusion to the bear's habit
of pulling down, and the bull's of tossing up.</note><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <fld>(Mach.)</fld> <def>A portable punching
machine.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>7.</sn> <fld>(Naut.)</fld> <def>A block covered with coarse
matting; -- used to scour the deck.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Australian bear</b></col>. <fld>(Zool.)</fld> <cd>See
<er>Koala</er>.</cd> -- <col><b>Bear baiting</b></col>, <cd>the sport of
baiting bears with dogs.</cd> -- <col><b>Bear caterpillar</b></col>
<fld>(Zool.)</fld>, <cd>the hairy larva of a moth, esp. of the genus
<gen>Euprepia</gen>.</cd> -- <col><b>Bear garden</b></col>. <sd>(a)</sd>
<cd>A place where bears are kept for diversion or fighting.</cd>
<sd>(b)</sd> <cd>Any place where riotous conduct is common or
permitted.</cd> <au>M. Arnold.</au> -- <col><b>Bear leader</b></col>,
<cd>one who leads about a performing bear for money; hence, a facetious
term for one who takes charge of a young man on his
travels.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bear</ent><br/
<hw>Bear</hw>, <pos>v. t.</pos> <fld>(Stock Exchange)</fld> <def>To
endeavor to depress the price of, or prices in; <as>as, to <ex>bear</ex>
a railroad stock; to <ex>bear</ex> the market</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bere</ent><br/
<ent>Bear</ent><br/
<mhw>{ <hw>Bear</hw>, <hw>Bere</hw> }</mhw> <pr>(b<emac/r)</pr>,
<pos>n.</pos> <ety>[AS. <ets>bere</ets>. See <er>Barley</er>.]</ety>
<fld>(Bot.)</fld> <def>Barley; the six-rowed barley or the four-rowed
barley, commonly the former (<spn>Hordeum hexastichon</spn> or
<spn>Hordeum vulgare</spn>).</def> <mark>[Obs. except in North of Eng.
and Scot.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bearable</ent><br/
<hw>Bear"a*ble</hw> <pr>(<?/)</pr>, <pos>a.</pos> <def>Capable of being
borne or endured; tolerable.</def> -- <wordforms><wf>Bear"a*bly</wf>,
<pos>adv.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bearberry</ent><br/
<hw>Bear"ber*ry</hw> <pr>(<?/)</pr>, <pos>n.</pos> <fld>(Bot.)</fld>
<def>A trailing plant of the heath family (<spn>Arctostaphylos
uva-ursi</spn>), having leaves which are tonic and astringent, and
glossy red berries of which bears are said to be fond.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bearbind</ent><br/
<hw>Bear"bind`</hw> <pr>(<?/)</pr>, <pos>n.</pos> <fld>(Bot.)</fld>
<def>The bindweed (<spn>Convolvulus arvensis</spn>).</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>bearcat</ent><br/
<hw>bear"cat`</hw> <pos>n.</pos> <def>an arboreal civet of Asia
(<spn>Arctictis bintourong</spn>) having a long prehensile tail and
shaggy black hair.</def><br/
<syn><b>Syn. --</b> binturong.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Beard</ent><br/
<hw>Beard</hw> <pr>(b<emac/rd)</pr>, <pos>n.</pos> <ety>[OE.
<ets>berd</ets>, AS. <ets>beard</ets>; akin to Fries. <ets>berd</ets>,
D. <ets>baard</ets>, G. <ets>bart</ets>, Lith. <ets>barzda</ets>, OSlav.
<ets>brada</ets>, Pol. <ets>broda</ets>, Russ. <ets>boroda</ets>, L.
<ets>barba</ets>, W. <ets>barf</ets>. Cf. 1st <er>Barb</er>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>The hair that grows on the chin, lips, and adjacent
parts of the human face, chiefly of male adults.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Zool.)</fld> <sd>(a)</sd> <def>The long hairs about
the face in animals, as in the goat.</def> <sd>(b)</sd> <def>The cluster
of small feathers at the base of the beak in some birds</def>
<sd>(c)</sd> <def>The appendages to the jaw in some Cetacea, and to the
mouth or jaws of some fishes.</def> <sd>(d)</sd> <def>The byssus of
certain shellfish, as the muscle.</def> <sd>(e)</sd> <def>The gills of
some bivalves, as the oyster.</def> <sd>(f)</sd> <def>In insects, the
hairs of the labial palpi of moths and butterflies.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Bot.)</fld> <def>Long or stiff hairs on a plant;
the awn; <as>as, the <ex>beard</ex> of grain</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>A barb or sharp point of an arrow or other
instrument, projecting backward to prevent the head from being easily
drawn out.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>That part of the under side of a horse's lower jaw
which is above the chin, and bears the curb of a bridle.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <fld>(Print.)</fld> <def>That part of a type which is
between the shoulder of the shank and the face.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>7.</sn> <def>An imposition; a trick.</def> <mark>[Obs.]</mark>
<rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Beard grass</b></col> <fld>(Bot.)</fld>, <cd>a coarse,
perennial grass of different species of the genus
<gen>Andropogon</gen>.</cd> -- <col><b>To one's beard</b></col>, <cd>to
one's face; in open defiance.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beard</ent><br/
<hw>Beard</hw> <pr>(b<emac/rd)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp.
& p. p.</pos> <conjf>Bearded</conjf>; <pos>p. pr. & vb. n.</pos>
<conjf>Bearding</conjf>.]</vmorph> <sn>1.</sn> <def>To take by the
beard; to seize, pluck, or pull the beard of (a man), in anger or
contempt.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To oppose to the face; to set at defiance.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>No admiral, <qex>bearded</qex> by these corrupt and dissolute
minions of the palace, dared to do more than mutter something about a
court martial.</q> <rj><qau>Macaulay.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To deprive of the gills; -- used only of oysters and
similar shellfish.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bearded</ent><br/
<hw>Beard"ed</hw>, <pos>a.</pos> <def>Having a beard.</def>
<ldquo/<xex>Bearded</xex> fellow.<rdquo/ <au>Shak.</au>
<ldquo/<xex>Bearded</xex> grain.<rdquo/ <au>Dryden.</au><br/
[<source>1913 Webster</source>]</p>

<p><cs><mcol><col><b>Bearded vulture</b></col>, <col><b>Bearded
eagle</b></col></mcol>. <fld>(Zool.)</fld> <cd>See
<er>Lammergeir</er>.</cd> -- <col><b>Bearded tortoise</b></col>.
<fld>(Zool.)</fld> <cd>See <er>Matamata</er>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beardie</ent><br/
<hw>Beard"ie</hw> <pr>(b<emac/rd"<ycr/)</pr>, <pos>n.</pos> <ety>[From
<er>Beard</er>, <pos>n.</pos>]</ety> <fld>(Zool.)</fld> <def>The bearded
loach (<spn>Nemachilus barbatus</spn>) of Europe.</def>
<mark>[Scot.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beardless</ent><br/
<hw>Beard"less</hw>, <pos>a.</pos> <sn>1.</sn> <def>Without a beard.
Hence: Not having arrived at puberty or manhood; youthful.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Destitute of an awn; <as>as, <ex>beardless</ex>
wheat</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beardlessness</ent><br/
<hw>Beard"less*ness</hw>, <pos>n.</pos> <def>The state or quality of
being destitute of beard.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>beardown</ent><br/
<hw>bear"down</hw> <pos>adj. prenom.</pos> <sn>1.</sn> <def>devoting
full strength and concentrated attention to.</def><br/
<syn><b>Syn. --</b> determined.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Bearer</ent><br/
<hw>Bear"er</hw> <pr>(b<acir/r"<etil/r)</pr>, <pos>n.</pos> <sn>1.</sn>
<def>One who, or that which, bears, sustains, or carries.</def>
<ldquo/<xex>Bearers</xex> of burdens.<rdquo/ <au>2 Chron. ii. 18.</au>
<ldquo/The <xex>bearer</xex> of unhappy news.<rdquo/
<rj><au>Dryden.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Specifically: One who assists in carrying a body to
the grave; a pallbearer.</def> <rj><au>Milton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>A palanquin carrier; also, a house servant.</def>
<mark>[India]</mark><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>A tree or plant yielding fruit; <as>as, a good
<ex>bearer</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <fld>(Com.)</fld> <def>One who holds a check, note,
draft, or other order for the payment of money; <as>as, pay to
<ex>bearer</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <fld>(Print.)</fld> <def>A strip of reglet or other
furniture to bear off the impression from a blank page; also, a type or
type-high piece of metal interspersed in blank parts to support the
plate when it is shaved.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bearherd</ent><br/
<hw>Bear"herd`</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>A man who tends a
bear.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bearhound</ent><br/
<hw>Bear"hound`</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>A hound for
baiting or hunting bears.</def> <rj><au>Carlyle.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bearing</ent><br/
<hw>Bear"ing</hw> <pr>(b<acir/r"<icr/ng)</pr>, <pos>n.</pos> <sn>1.</sn>
<def>The manner in which one bears or conducts one's self; mien;
behavior; carriage.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>I know him by his <qex>bearing</qex>.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Patient endurance; suffering without
complaint.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>The situation of one object, with respect to
another, such situation being supposed to have a connection with the
object, or influence upon it, or to be influenced by it; hence,
relation; connection.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>But of this frame, the <qex>bearings</qex> and the ties,<br/
The strong connections, nice dependencies.</q>
<rj><qau>Pope.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>Purport; meaning; intended significance;
aspect.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>The act, power, or time of producing or giving
birth; <as>as, a tree in full <ex>bearing</ex>; a tree past
<ex>bearing</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>[His mother] in travail of his <qex>bearing</qex>.</q> <rj><qau>R.
of Gloucester.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <fld>(Arch.)</fld> <sd>(a)</sd> <def>That part of any
member of a building which rests upon its supports; <as>as, a lintel or
beam may have four inches of <ex>bearing</ex> upon the wall</as>.</def>
<sd>(b)</sd> <def>The portion of a support on which anything
rests.</def> <sd>(c)</sd> <def>Improperly, the unsupported span; <as>as,
the beam has twenty feet of <ex>bearing</ex> between its
supports</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>7.</sn> <fld>(Mach.)</fld> <sd>(a)</sd> <def>The part of an axle
or shaft in contact with its support, collar, or boxing; the
journal.</def> <sd>(b)</sd> <def>The part of the support on which a
journal rests and rotates.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>8.</sn> <fld>(Her.)</fld> <def>Any single emblem or charge in an
escutcheon or coat of arms -- commonly in the <pluf>pl.</pluf></def><br/
[<source>1913 Webster</source>]</p>

<p><q>A carriage covered with armorial <qex>bearings</qex>.</q>
<rj><qau>Thackeray.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>9.</sn> <fld>(Naut.)</fld> <sd>(a)</sd> <def>The situation of a
distant object, with regard to a ship's position, as on the bow, on the
lee quarter, etc.; the direction or point of the compass in which an
object is seen; <as>as, the <ex>bearing</ex> of the cape was W. N.
W</as>.</def> <sd>(b)</sd> <pluf>pl.</pluf> <def>The widest part of a
vessel below the plank-sheer.</def> <sd>(c)</sd> <pluf>pl.</pluf>
<def>The line of flotation of a vessel when properly trimmed with cargo
or ballast.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Ball bearings</b></col>. <cd>See under
<er>Ball</er>.</cd> -- <col><b>To bring one to his bearings</b></col>,
<cd>to bring one to his senses.</cd> -- <col><b>To lose one's
bearings</b></col>, <cd>to become bewildered.</cd> -- <col><b>To take
bearings</b></col>, <cd>to ascertain by the compass the position of an
object; to ascertain the relation of one object or place to another; to
ascertain one's position by reference to landmarks or to the compass;
hence (<mark>Fig.</mark>), to ascertain the condition of things when one
is in trouble or perplexity.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- Deportment; gesture; mien; behavior; manner;
carriage; demeanor; port; conduct; direction; relation; tendency;
influence.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bearing cloth</ent><br/
<hw>Bear"ing cloth`</hw> <pr>(b<acir/r"<icr/ng kl<ocr/th`; 115)</pr>.
<def>A cloth with which a child is covered when carried to be
baptized.</def> <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bearing rein</ent><br/
<hw>Bear"ing rein`</hw> <pr>(<?/)</pr>. <def>A short rein looped over
the check hook or the hames to keep the horse's head up; -- called in
the United States a <xex>checkrein</xex>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bearing ring</ent><br/
<hw>Bear"ing ring`</hw>. <def>In a balloon, the braced wooden ring
attached to the suspension ropes at the bottom, functionally analogous
to the keel of a ship.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Bearish</ent><br/
<hw>Bear"ish</hw>, <pos>a.</pos> <sn>1.</sn> <def>Partaking of the
qualities of a bear; resembling a bear in temper or manners.</def>
<rj><au>Harris.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Stock market)</fld> <def>Fearful of or anticipating
falling prices, as in the stock market; <as>as, <ex>bearish</ex>
sentiment inhibited buying</as>.</def><br/
[<source>PJC</source>]</p>

<p><sn>3.</sn> <fld>(Stock market)</fld> <def>Tending to cause prices to
fall.</def> <ldquo/<ex>bearish</ex> news about inflation caused a sharp
drop in the Dow.<rdquo/<br/
[<source>PJC</source>]</p>

<p><sn>4.</sn> <specif>Hence:</specif> <def>Pessimistic.</def><br/
[<source>PJC</source>]</p>

<p><ent>Bearishness</ent><br/
<hw>Bear"ish*ness</hw>, <pos>n.</pos> <def>Behavior like that of a
bear.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>bear jam</ent><br/
<hw>bear jam</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>A <isa>traffic
jam</isa> caused by tourists stopping to look at bears near the road; --
a phenomenon once common in Yellowstone Park, Wyoming.</def>
<mark>[Colloq.]</mark><br/
[<source>PJC</source>]</p>

<p><ent>Bearn</ent><br/
<hw>Bearn</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>See
<er>Bairn</er>.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>bear's-breeches</ent><br/
<ent>Bear's-breech</ent><br/
<mhw><hw>Bear's"-breech`</hw>, <hw>bear's"-breech`es</hw></mhw>
<pr>(<?/)</pr>, <pos>n.</pos> <sn>1.</sn> <fld>(Bot.)</fld> <def>The
English cow parsnip (<spn>Heracleum sphondylium</spn>)</def> <rj><au>Dr.
Prior.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>a widely cultivated southern European acanthus
(<spn>Acanthus mollis</spn>) with whitish purple-veined flowers. See
<er>Acanthus</er>, <pos>n.</pos>, 1.</def><br/
<syn><b>Syn. --</b> bear's breech, bear's-breech, bear's breeches, sea
holly.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><-- p. 129 pr=SA --></p>

<p><ent>Bear's-ear</ent><br/
<hw>Bear's-ear`</hw> <pr>(b<acir/rz"<emac/r`)</pr>, <pos>n.</pos>
<fld>(Bot.)</fld> <def>A kind of primrose (<spn>Primula auricula</spn>),
so called from the shape of the leaf.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bear's-foot</ent><br/
<hw>Bear's"-foot`</hw> <pr>(-f<oocr/t`)</pr>, <pos>n.</pos>
<fld>(Bot.)</fld> <def>A species of hellebore (<spn>Helleborus
f<oe/tidus</spn>), with digitate leaves. It has an offensive smell and
acrid taste, and is a powerful emetic, cathartic, and
anthelmintic.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bearskin</ent><br/
<hw>Bear"skin`</hw> <pr>(<?/)</pr>, <pos>n.</pos> <sn>1.</sn> <def>The
skin of a bear.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A coarse, shaggy, woolen cloth for
overcoats.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>A cap made of bearskin, esp. one worn by
soldiers.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bear's-paw</ent><br/
<hw>Bear's"-paw`</hw> <pr>(<?/)</pr>, <pos>n.</pos> <fld>(Zool.)</fld>
<def>A large bivalve shell of the East Indies (<spn>Hippopus
maculatus</spn>), often used as an ornament.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bear State</ent><br/
<hw>Bear State</hw>. <def>Arkansas; -- a nickname, from the many bears
once inhabiting its forests.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Bear-trap dam</ent><br/
<hw>Bear"-trap` dam</hw>. <fld>(Engin.)</fld> <def>A kind of movable
dam, in one form consisting of two leaves resting against each other at
the top when raised and folding down one over the other when lowered,
for deepening shallow parts in a river.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Bearward</ent><br/
<hw>Bear"ward`</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[<ets>Bear</ets>
+ <ets>ward</ets> a keeper.]</ety> <def>A keeper of bears. See
<er>Bearherd</er>.</def> <mark>[R.]</mark> <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beast</ent><br/
<hw>Beast</hw> <pr>(b<emac/st)</pr>, <pos>n.</pos> <ety>[OE.
<ets>best</ets>, <ets>beste</ets>, OF. <ets>beste</ets>, F.
<ets>b<ecir/te</ets>, fr. L. <ets>bestia</ets>.]</ety> <sn>1.</sn>
<def>Any living creature; an animal; -- including man, insects,
etc.</def> <mark>[Obs.]</mark> <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Any four-footed animal, that may be used for labor,
food, or sport; <as>as, a <ex>beast</ex> of burden</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>A righteous man regardeth the life of his <qex>beast</qex>.</q>
<rj><qau>Prov. xii. 10.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>any animal other than a human; -- opposed to
<contr>man</contr>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>'Tain't a fit night out for man nor <qex>beast</qex>.</q><br/
<rj><qau>W. C. Fields.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>Fig.: A coarse, brutal, filthy, or degraded
fellow.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>A game at cards similar to loo.</def>
<mark>[Obs.]</mark> <rj><au>Wright.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <def>A penalty at beast, omber, etc. Hence: To be
beasted, to be beaten at beast, omber, etc.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Beast royal</b></col>, <cd>the lion.</cd>
<mark>[Obs.]</mark> <rj><au>Chaucer.</au></rj></cs><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- <er>Beast</er>, <er>Brute</er>.</syn> <usage>
When we use these words in a figurative sense, as applicable to human
beings, we think of <xex>beasts</xex> as mere animals governed by animal
appetite; and of <xex>brutes</xex> as being destitute of reason or moral
feeling, and governed by unrestrained passion. Hence we speak of
<xex>beastly</xex> appetites; <xex>beastly</xex> indulgences, etc.; and
of <xex>brutal</xex> manners; <xex>brutal</xex> inhumanity;
<xex>brutal</xex> ferocity. So, also, we say of a drunkard, that he
first made himself a <xex>beast</xex>, and then treated his family like
a <xex>brute</xex>.</usage><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beasthood</ent><br/
<hw>Beast"hood</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>State or nature
of a beast.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beastings</ent><br/
<hw>Beast"ings</hw> <pr>(<?/)</pr>, <pos>n. pl.</pos> <def>See
<er>Biestings</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beastlihead</ent><br/
<hw>Beast"li*head</hw> <pr>(<?/)</pr>, <pos>n.</pos>
<ety>[<ets>Beastly</ets> + <ets>-head</ets> state.]</ety>
<def>Beastliness.</def> <mark>[Obs.]</mark>
<rj><au>Spenser.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beastlike</ent><br/
<hw>Beast"like"</hw> <pr>(<?/)</pr>, <pos>a.</pos> <def>Like a
beast.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beastliness</ent><br/
<hw>Beast"li*ness</hw>, <pos>n.</pos> <def>The state or quality of being
beastly.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beastly</ent><br/
<hw>Beast"ly</hw> <pr>(b<emac/st"l<ycr/)</pr>, <pos>a.</pos> <sn>1.</sn>
<def>Pertaining to, or having the form, nature, or habits of, a
beast.</def><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>Beastly</qex> divinities and droves of gods.</q>
<rj><qau>Prior.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Characterizing the nature of a beast; contrary to
the nature and dignity of man; brutal; filthy.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The <qex>beastly</qex> vice of drinking to excess.</q>
<rj><qau>Swift.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Abominable; <as>as, <ex>beastly</ex>
weather</as>.</def> <mark>[Colloq. Eng.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- Bestial; brutish; irrational; sensual;
degrading.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beat</ent><br/
<hw>Beat</hw> <pr>(b<emac/t)</pr>, <pos>v. t.</pos>
<vmorph>[<pos>imp.</pos> <conjf>Beat</conjf>; <pos>p. p.</pos>
<conjf>Beat</conjf>, <conjf>Beaten</conjf> <pr>(<?/)</pr>; <pos>p. pr. &
vb. n.</pos> <conjf>Beating</conjf>.]</vmorph> <ety>[OE.
<ets>beaten</ets>, <ets>beten</ets>, AS. <ets>be<aacute/tan</ets>; akin
to Icel. <ets>bauta</ets>, OHG. <ets>b<omac/zan</ets>. Cf. 1st
<er>Butt</er>, <er>Button</er>.]</ety> <sn>1.</sn> <def>To strike
repeatedly; to lay repeated blows upon; <as>as, to <ex>beat</ex> one's
breast; to <ex>beat</ex> iron so as to shape it; to <ex>beat</ex> grain,
in order to force out the seeds; to <ex>beat</ex> eggs and sugar; to
<ex>beat</ex> a drum</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Thou shalt <qex>beat</qex> some of it [spices] very small.</q>
<rj><qau>Ex. xxx. 36.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>They did <qex>beat</qex> the gold into thin plates.</q>
<rj><qau>Ex. xxxix. 3.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To punish by blows; to thrash.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To scour or range over in hunting, accompanied with
the noise made by striking bushes, etc., for the purpose of rousing
game.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>To <qex>beat</qex> the woods, and rouse the bounding prey.</q>
<rj><qau>Prior.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>To dash against, or strike, as with water or
wind.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>A frozen continent . . . <qex>beat</qex> with perpetual
storms.</q> <rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>To tread, as a path.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Pass awful gulfs, and <qex>beat</qex> my painful way.</q>
<rj><qau>Blackmore.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <def>To overcome in a battle, contest, strife, race,
game, etc.; to vanquish, defeat, or conquer; to surpass or be superior
to.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>He <qex>beat</qex> them in a bloody battle.</q>
<rj><qau>Prescott.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>For loveliness, it would be hard to <qex>beat</qex> that.</q>
<rj><qau>M. Arnold.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>7.</sn> <def>To cheat; to chouse; to swindle; to defraud; --
often with <xex>out</xex>.</def> <mark>[Colloq.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><sn>8.</sn> <def>To exercise severely; to perplex; to
trouble.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Why should any one . . . <qex>beat</qex> his head about the Latin
grammar who does not intend to be a critic?</q>
<rj><qau>Locke.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>9.</sn> <fld>(Mil.)</fld> <def>To give the signal for, by beat of
drum; to sound by beat of drum; <as>as, to <ex>beat</ex> an alarm, a
charge, a parley, a retreat; to <ex>beat</ex> the general, the reveille,
the tattoo.</as> See <er>Alarm</er>, <er>Charge</er>, <er>Parley</er>,
etc.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>10.</sn> <def>to baffle or stump; to defy the comprehension of (a
person); <as>as, it <ex>beats</ex> me why he would do
that</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>11.</sn> <def>to evade, avoid, or escape (blame, taxes,
punishment); <as>as, to <ex>beat</ex> the rap (be acquitted); to
<ex>beat</ex> the sales tax by buying out of state</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>To beat down</b></col>, <cd>to haggle with (any one) to
secure a lower price; to force down.</cd> <mark>[Colloq.]</mark> --
<col><b>To beat into</b></col>, <cd>to teach or instill, by
repetition.</cd> -- <col><b>To beat off</b></col>, <cd>to repel or drive
back.</cd> -- <col><b>To beat out</b></col>, <cd>to extend by
hammering.</cd> -- <col><b>To beat out of</b></col> a thing, <cd>to
cause to relinquish it, or give it up.</cd> <ldquo/Nor can anything
<xex>beat</xex> their posterity <xex>out of it</xex> to this day.<rdquo/
<au>South.</au> -- <col><b>To beat the dust</b></col>. <fld>(Man.)</fld>
<sd>(a)</sd> <cd>To take in too little ground with the fore legs, as a
horse.</cd> <sd>(b)</sd> <cd>To perform curvets too precipitately or too
low.</cd> -- <col><b>To beat the hoof</b></col>, <cd>to walk; to go on
foot.</cd> -- <col><b>To beat the wing</b></col>, <cd>to flutter; to
move with fluttering agitation.</cd> -- <col><b>To beat time</b></col>,
<cd>to measure or regulate time in music by the motion of the hand or
foot.</cd> -- <col><b>To beat up</b></col>, <cd>to attack suddenly; to
alarm or disturb; as, to <xex>beat up</xex> an enemy's
quarters.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- To strike; pound; bang; buffet; maul; drub;
thump; baste; thwack; thrash; pommel; cudgel; belabor; conquer; defeat;
vanquish; overcome.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beat</ent><br/
<hw>Beat</hw>, <pos>v. i.</pos> <sn>1.</sn> <def>To strike repeatedly;
to inflict repeated blows; to knock vigorously or loudly.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The men of the city . . . <qex>beat</qex> at the door.</q>
<rj><qau>Judges. xix. 22.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To move with pulsation or throbbing.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>A thousand hearts <qex>beat</qex> happily.</q>
<rj><qau>Byron.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To come or act with violence; to dash or fall with
force; to strike anything, as rain, wind, and waves do.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Sees rolling tempests vainly <qex>beat</qex> below.</q>
<rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>They [winds] <qex>beat</qex> at the crazy casement.</q>
<rj><qau>Longfellow.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The sun <qex>beat</qex> upon the head of Jonah, that he fainted,
and wished in himself to die.</q> <rj><qau>Jonah iv. 8.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Public envy seemeth to <qex>beat</qex> chiefly upon ministers.</q>
<rj><qau>Bacon.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>To be in agitation or doubt.</def>
<mark>[Poetic]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>To still my <qex>beating</qex> mind.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <fld>(Naut.)</fld> <def>To make progress against the
wind, by sailing in a zigzag line or traverse.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <def>To make a sound when struck; <as>as, the drums
<ex>beat</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>7.</sn> <fld>(Mil.)</fld> <def>To make a succession of strokes on
a drum; <as>as, the drummers <ex>beat</ex> to call soldiers to their
quarters</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>8.</sn> <fld>(Acoustics & Mus.)</fld> <def>To sound with more or
less rapid alternations of greater and less intensity, so as to produce
a pulsating effect; -- said of instruments, tones, or vibrations, not
perfectly in unison.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>A beating wind</b></col> <fld>(Naut.)</fld>, <cd>a wind
which necessitates tacking in order to make progress.</cd> -- <col><b>To
beat about</b></col>, <cd>to try to find; to search by various means or
ways.</cd> <au>Addison.</au> -- <col><b>To beat about the
bush</b></col>, <cd>to approach a subject circuitously.</cd> --
<col><b>To beat up and down</b></col> <fld>(Hunting)</fld>, <cd>to run
first one way and then another; -- said of a stag.</cd> -- <col><b>To
beat up for recruits</b></col>, <cd>to go diligently about in order to
get helpers or participators in an enterprise.</cd> -- <col><b>To beat
the rap</b></col>, <cd>to be acquitted of an accusation; -- especially,
by some sly or deceptive means, rather than to be proven
innocent.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beat</ent><br/
<hw>Beat</hw> <pr>(<?/)</pr>, <pos>n.</pos> <sn>1.</sn> <def>A stroke; a
blow.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>He, with a careless <qex>beat</qex>,<br/
Struck out the mute creation at a heat.</q>
<rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A recurring stroke; a throb; a pulsation; <as>as, a
<ex>beat</ex> of the heart; the <ex>beat</ex> of the
pulse</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Mus.)</fld> <sd>(a)</sd> <def>The rise or fall of
the hand or foot, marking the divisions of time; a division of the
measure so marked. In the rhythm of music the <xex>beat</xex> is the
unit.</def> <sd>(b)</sd> <def>A transient grace note, struck immediately
before the one it is intended to ornament.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <fld>(Acoustics & Mus.)</fld> <def>A sudden swelling or
re<eum/nforcement of a sound, recurring at regular intervals, and
produced by the interference of sound waves of slightly different
periods of vibrations; applied also, by analogy, to other kinds of wave
motions; the pulsation or throbbing produced by the vibrating together
of two tones not quite in unison. See <er>Beat</er>, <pos>v. i.</pos>,
8.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>A round or course which is frequently gone over;
<as>as, a watchman's <ex>beat</ex></as>; analogously, for newspaper
reporters, the subject or territory that they are assigned to cover;
<as>as, the Washington <ex>beat</ex></as>.</def><br/
[<source>1913 Webster</source> <source>+PJC</source>]</p>

<p><sn>6.</sn> <def>A place of habitual or frequent resort.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>7.</sn> <def>A cheat or swindler of the lowest grade; -- often
emphasized by <xex>dead</xex>; <as>as, a <ex>dead beat</ex></as>; also,
<altname>deadbeat</altname>.</def> <mark>[Low]</mark><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Beat of drum</b></col> <fld>(Mil.)</fld>, <cd>a
succession of strokes varied, in different ways, for particular
purposes, as to regulate a march, to call soldiers to their arms or
quarters, to direct an attack, or retreat, etc.</cd> --
<mcol><col><b>Beat of a watch</b></col>, <it>or</it> <col><b>Beat of a
clock</b></col></mcol>, <cd>the stroke or sound made by the action of
the escapement. A clock is <xex>in beat</xex> or out <xex>of beat</xex>,
according as the stroke is at equal or unequal intervals.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beat</ent><br/
<hw>Beat</hw>, <pos>a.</pos> <def>Weary; tired; fatigued;
exhausted.</def> <mark>[Colloq.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>Quite <qex>beat</qex>, and very much vexed and disappointed.</q>
<rj><qau>Dickens.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beat</ent><br/
<hw>Beat</hw>, <pos>n.</pos> <sn>1.</sn> <def>One that beats, or
surpasses, another or others; <as>as, the <ex>beat</ex> of
him</as>.</def> <mark>[Colloq.]</mark><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><sn>2.</sn> <def>The act of one that beats a person or thing</def>;
as: <sd>(a)</sd> <fld>(Newspaper Cant)</fld> <def>The act of obtaining
and publishing a piece of news by a newspaper before its competitors;
also, the news itself; -- also called a <altname>scoop</altname> or
<altname>exclusive</altname>.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><q>It's a <qex>beat</qex> on the whole country.</q>
<rj><qau>Scribner's Mag.</qau></rj><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><sd>(b)</sd> <fld>(Hunting)</fld> <def>The act of scouring, or
ranging over, a tract of land to rouse or drive out game; also, those so
engaged, collectively.</def> <ldquo/Driven out in the course of a
<xex>beat</xex>.<rdquo/ <rj><au>Encyc. of Sport.</au></rj><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><q>Bears coming out of holes in the rocks at the last moment, when
the <qex>beat</qex> is close to them.</q> <rj><qau>Encyc. of
Sport.</qau></rj><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><sd>(c)</sd> <fld>(Fencing)</fld> <def>A smart tap on the adversary's
blade.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>beatable</ent><br/
<hw>beat"a*ble</hw> <pos>adj.</pos> <def>capable of being
defeated.</def><br/
<syn><b>Syn. --</b> vanquishable, vincible.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Beaten</ent><br/
<hw>Beat"en</hw> <pr>(b<emac/t"'n; 95)</pr>, <pos>a.</pos> <sn>1.</sn>
<def>Made smooth by beating or treading; worn by use.</def> <ldquo/A
broad and <xex>beaten</xex> way.<rdquo/ <au>Milton.</au>
<ldquo/<xex>Beaten</xex> gold.<rdquo/ <au>Shak.</au> <ldquo/off the
<xex>beaten</xex> track.<rdquo/<br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Vanquished; defeated; conquered; baffled.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Exhausted; tired out.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>Become common or trite; <as>as, a <ex>beaten</ex>
phrase</as>.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>Tried; practiced.</def> <mark>[Obs.]</mark>
<rj><au>Beau. & Fl.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>beaten-up</ent><br/
<hw>beaten-up</hw> <pos>adj.</pos> <def>worn by use into a deplorable
condition.</def> <illu>the <ex>beaten-up</ex> old Ford</illu><br/
<syn><b>Syn. --</b> battered, beat-up, bedraggled, broken-down,
dilapidated, ramshackle, tumble-down, unsound.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Beater</ent><br/
<hw>Beat"er</hw> <pr>(b<emac/t"<etil/r)</pr>, <pos>n.</pos> <sn>1.</sn>
<def>One who, or that which, beats.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A person who beats up game for the hunters.</def>
<rj><au>Black.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beath</ent><br/
<hw>Beath</hw> <pr>(b<emac/<th/)</pr>, <pos>v. t.</pos> <ety>[AS.
<ets>be<edh/ian</ets> to foment.]</ety> <def>To bathe; also, to dry or
heat, as unseasoned wood.</def> <mark>[Obs.]</mark>
<rj><au>Spenser.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beatifical</ent><br/
<ent>Beatific</ent><br/
<mhw>{ <hw>Be`a*tif"ic</hw> <pr>(<?/)</pr>, <hw>Be`a*tif"ic*al</hw>
<pr>(<?/)</pr>, }</mhw> <pos>a.</pos> <ety>[Cf. F.
<ets>b<eacute/atifique</ets>, L. <ets>beatificus</ets>. See
<er>Beatify</er>.]</ety> <def>Having the power to impart or complete
blissful enjoyment; blissful.</def> <ldquo/The <xex>beatific</xex>
vision.<rdquo/ <au>South.</au> -- <wordforms><wf>Be`a*tif"ic*al*ly</wf>,
<pos>adv.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beatificate</ent><br/
<hw>Be`a*tif"i*cate</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <def>To
beatify.</def> <mark>[Obs.]</mark> <rj><au>Fuller.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beatification</ent><br/
<hw>Be*at`i*fi*ca"tion</hw>
<pr>(b<esl/*<acr/t`<icr/*f<icr/*k<amac/"sh<ucr/n)</pr>, <pos>n.</pos>
<ety>[Cf. F. <ets>b<eacute/atification</ets>.]</ety> <def>The act of
beatifying, or the state of being beatified; esp., in the R. C. Church,
the act or process of ascertaining and declaring that a deceased person
is one of <ldquo/the blessed,<rdquo/ or has attained the second degree
of sanctity, -- usually a stage in the process of canonization.</def>
<ldquo/The <xex>beatification</xex> of his spirit.<rdquo/ <rj><au>Jer.
Taylor.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>beatified</ent><br/
<hw>be*at"i*fied</hw> <pr>(b<esl/*<acr/t"<icr/*f<imac/d)</pr>,
<pos>adj.</pos> <fld>(Roman Catholic Church)</fld> <def>proclaimed one
of the blessed and thus worthy of veneration.</def><br/
<syn><b>Syn. --</b> blessed.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Beatify</ent><br/
<hw>Be*at"i*fy</hw> <pr>(b<esl/*<acr/t"<icr/*f<imac/)</pr>, <pos>v.
t.</pos> <vmorph>[<pos>imp. & p. p.</pos> <conjf>Beatified</conjf>
<pr>(b<esl/*<acr/t"<icr/*f<imac/d)</pr>; <pos>p. pr. & vb. n.</pos>
<conjf>Beatifying</conjf>.]</vmorph> <ety>[L. <ets>beatificare</ets>;
<ets>beatus</ets> happy (fr. <ets>beare</ets> to bless, akin to
<ets>bonus</ets> good) + <ets>facere</ets> to make: cf. F.
<ets>b<eacute/atifier</ets>. See <er>Bounty</er>.]</ety> <sn>1.</sn>
<def>To pronounce or regard as happy, or supremely blessed, or as
conferring happiness.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The common conceits and phrases that <qex>beatify</qex>
wealth.</q> <rj><qau>Barrow.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To make happy; to bless with the completion of
celestial enjoyment.</def> <ldquo/<xex>Beatified</xex> spirits.<rdquo/
<rj><au>Dryden.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(R. C. Ch.)</fld> <def>To ascertain and declare, by
a public process and decree, that a deceased person is one of <ldquo/the
blessed,<rdquo/ and is to be reverenced as such, though not
canonized.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beating</ent><br/
<hw>Beat"ing</hw> <pr>(<?/)</pr>, <pos>n.</pos> <sn>1.</sn> <def>The act
of striking or giving blows; punishment or chastisement by
blows.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Pulsation; throbbing; <as>as, the <ex>beating</ex>
of the heart</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Acoustics & Mus.)</fld> <def>Pulsative sounds. See
<er>Beat</er>, <pos>n.</pos></def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <fld>(Naut.)</fld> <def>The process of sailing against
the wind by tacks in zigzag direction.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beatitude</ent><br/
<hw>Be*at"i*tude</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[L.
<ets>beatitudo</ets>: cf. F. <ets>b<eacute/atitude</ets>. See
<er>Beatify</er>.]</ety> <sn>1.</sn> <def>Felicity of the highest kind;
consummate bliss.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Any one of the nine declarations (called <xex>the
Beatitudes</xex>), made in the Sermon on the Mount (<au>Matt. v.
3-12</au>), with regard to the blessedness of those who are
distinguished by certain specified virtues.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(R. C. Ch.)</fld> <def>Beatification.</def>
<rj><au>Milman.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- Blessedness; felicity; happiness.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>beatnik</ent><br/
<hw>beat"nik</hw> <pos>n.</pos> <def>a member of the Beat Generation; a
nonconformist in dress and behavior.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>beat-up</ent><br/
<hw>beat-up</hw> <pos>adj.</pos> <def>same as
<er>beaten-up</er>.</def><br/
<syn><b>Syn. --</b> battered, beaten-up, bedraggled, broken-down,
dilapidated, ramshackle, tumble-down, unsound.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Beau</ent><br/
<hw>Beau</hw> <pr>(b<omac/)</pr>, <pos>n.</pos>; <plu><it>pl.</it> F.
<plw>Beaux</plw> <pr>(E. pron. b<omac/z)</pr>, E. <plw>Beaus</plw>
<pr>(b<omac/z)</pr>.</plu> <ety>[F., a fop, fr. <ets>beau</ets> fine,
beautiful, fr. L. <ets>bellus</ets> pretty, fine, for
<ets>bonulus</ets>, dim. of <ets>bonus</ets> good. See <er>Bounty</er>,
and cf. <er>Belle</er>, <er>Beauty</er>.]</ety> <sn>1.</sn> <def>A man
who takes great care to dress in the latest fashion; a dandy.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A man who escorts, or pays attentions to, a lady; an
escort; a suitor or lover.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beaucatcher</ent><br/
<hw>Beau"catch`er</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>A small flat
curl worn on the temple by women.</def> <mark>[Humorous]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beaufet</ent><br/
<hw>Beau"fet</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[See
<er>Buffet</er>.]</ety> <def>A niche, cupboard, or sideboard for plate,
china, glass, etc.; a buffet.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>A <qex>beaufet</qex> . . . filled with gold and silver
vessels.</q> <rj><qau>Prescott.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beaufin</ent><br/
<hw>Beau"fin</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>See
<er>Biffin</er>.</def> <rj><au>Wright.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beaufort's scale</ent><br/
<hw>Beau"fort's scale`</hw> <pr>(?)</pr>. <fld>(Meteor.)</fld> <def>A
scale of wind force devised by <person>Sir F. <etsep>Beaufort</etsep>,
R. N.</person>, in 1805, in which the force is indicated by numbers from
0 to 12.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ The full scale is as follows: -- 0, calm; 1, light air;
2, light breeze; 3, gentle breeze; 4, moderate breeze; 5, fresh breeze;
6, strong breeze; 7, moderate gale; 8, fresh gale; 9, strong gale; 10,
whole gale; 11, storm; 12, hurricane.</note><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Beau ideal</ent><br/
<hw>Beau" i*de"al</hw> <pr>(b<omac/" <isl/*d<emac/"<ait/l; 277)</pr>.
<ety>[F. <ets>beau</ets> beautiful + <ets>id<eacute/al</ets>
ideal.]</ety> <def>A conception or image of consummate beauty, moral or
physical, formed in the mind, free from all the deformities, defects,
and blemishes seen in actual existence; an ideal or faultless standard
or model.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beauish</ent><br/
<hw>Beau"ish</hw> <pr>(<?/)</pr>, <pos>a.</pos> <def>Like a beau;
characteristic of a beau; foppish; fine.</def> <ldquo/A
<xex>beauish</xex> young spark.<rdquo/ <rj><au>Byrom.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beau monde</ent><br/
\'d8<hw>Beau` monde"</hw> <pr>(<?/)</pr>. <ety>[F. <ets>beau</ets> fine
+ <ets>monde</ets> world.]</ety> <def>The fashionable world; people of
fashion and gayety.</def> <rj><au>Prior.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beaumontague</ent><br/
<hw>Beau`mon"ta*gue</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A cement used
in making joints, filling cracks, etc. For iron, the principal
constituents are iron borings and sal ammoniac; for wood, white lead or
litharge, whiting, and linseed oil.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Beaupere</ent><br/
<hw>Beau"pere`</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[F. <ets>beau
p<eacute/re</ets>; <ets>beau</ets> fair + <ets>p<eacute/re</ets>
father.]</ety> <sn>1.</sn> <def>A father.</def> <mark>[Obs.]</mark>
<rj><au>Wyclif.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A companion.</def> <mark>[Obs.]</mark>
<rj><au>Spenser.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beauseant</ent><br/
\'d8<hw>Beau`se`ant"</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[F.
<ets>beauc<eacute/ant</ets>.]</ety> <def>The black and white standard of
the Knights Templars.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beauship</ent><br/
<hw>Beau"ship</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>The state of being
a beau; the personality of a beau.</def> <mark>[Jocular]</mark>
<rj><au>Dryden.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>beaut</ent><br/
<hw>beaut</hw> <pr>(b<umac/t)</pr>, <pos>n.</pos> <ety>[From
<ets>beauty</ets>.]</ety> <def>an outstanding example of its kind;
<as>as, when I make a mistake it's a <ex>beaut</ex></as>.</def><br/
<syn><b>Syn. --</b> beauty.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Beauteous</ent><br/
<hw>Beau"te*ous</hw> <pr>(b<umac/"t<esl/*<ucr/s)</pr>, <pos>a.</pos>
<def>Full of beauty; beautiful; very handsome.</def> <mark>[Mostly
poetic]</mark> -- <wordforms><wf>Beau"te*ous*ly</wf>, <pos>adv.</pos> --
<wf>Beau"te*ous*ness</wf>, <pos>n.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beautied</ent><br/
<hw>Beau"tied</hw> <pr>(b<umac/"t<icr/d)</pr>, <pos>p. a.</pos>
<def>Beautiful; embellished.</def> <mark>[Poetic]</mark>
<rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>beautification</ent><br/
<hw>beau`ti*fi*ca"tion</hw> <pos>n.</pos> <def>the act of making
something more beautiful.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Beautifier</ent><br/
<hw>Beau"ti*fi`er</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>One who, or
that which, beautifies or makes beautiful.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beautiful</ent><br/
<hw>Beau"ti*ful</hw> <pr>(b<umac/"t<icr/*f<usdot/l)</pr>, <pos>a.</pos>
<def>Having the qualities which constitute beauty; pleasing to the sight
or the mind.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>A circle is more <qex>beautiful</qex> than a square; a square is
more <qex>beautiful</qex> than a parallelogram.</q> <rj><qau>Lord
Kames.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- Handsome; elegant; lovely; fair; charming;
graceful; pretty; delightful.</syn> See <er>Fine</er>.</p>

<p> -- <wordforms><wf>Beau"ti*ful*ly</wf>, <pos>adv.</pos> --
<wf>Beau"ti*ful*ness</wf>, <pos>n.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beautify</ent><br/
<hw>Beau"ti*fy</hw> <pr>(b<umac/"t<icr/*f<imac/)</pr>, <pos>v. t.</pos>
<vmorph>[<pos>imp. & p. p.</pos> <conjf>Beautified</conjf>
<pr>(b<umac/"t<icr/*f<imac/)</pr>; <pos>p. pr. & vb. n.</pos>
<conjf>Beautifying</conjf>.]</vmorph> <ety>[<ets>Beauty</ets> +
<ets>-fy</ets>.]</ety> <def>To make or render beautiful; to add beauty
to; to adorn; to deck; to grace; to embellish.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The arts that <qex>beautify</qex> and polish life.</q>
<rj><qau>Burke.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- To adorn; grace; ornament; deck;
decorate.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beautify</ent><br/
<hw>Beau"ti*fy</hw>, <pos>v. i.</pos> <def>To become beautiful; to
advance in beauty.</def> <rj><au>Addison.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beautiless</ent><br/
<hw>Beau"ti*less</hw>, <pos>a.</pos> <def>Destitute of beauty.</def>
<rj><au>Hammond.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beauty</ent><br/
<hw>Beau"ty</hw> <pr>(b<umac/"t<ycr/)</pr>, <pos>n.</pos>;
<plu><it>pl.</it> <plw>Beauties</plw> <pr>(b<umac/"t<icr/z)</pr>.</plu>
<ety>[OE. <ets>beaute</ets>, <ets>beute</ets>, OF.
<ets>beaut<eacute/</ets>, <ets>biaut<eacute/</ets>, Pr.
<ets>beltat</ets>, F. <ets>beaut<eacute/</ets>, fr. an assumed LL.
<ets>bellitas</ets>, from L. <ets>bellus</ets> pretty. See
<er>Beau</er>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>An assemblage of graces or properties pleasing to
the eye, the ear, the intellect, the <ae/sthetic faculty, or the moral
sense.</def><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>Beauty</qex> consists of a certain composition of color and
figure, causing delight in the beholder.</q>
<rj><qau>Locke.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The production of <qex>beauty</qex> by a multiplicity of
symmetrical parts uniting in a consistent whole.</q>
<rj><qau>Wordsworth.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The old definition of <qex>beauty</qex>, in the Roman school, was,
<ldquo/multitude in unity;<rdquo/ and there is no doubt that such is the
principle of <qex>beauty</qex>.</q> <rj><qau>Coleridge.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A particular grace, feature, ornament, or
excellence; anything beautiful; <as>as, the <ex>beauties</ex> of
nature</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>A beautiful person, esp. a beautiful
woman.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>All the admired <qex>beauties</qex> of Verona.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>Prevailing style or taste; rage; fashion.</def>
<mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>She stained her hair yellow, which was then the
<qex>beauty</qex>.</q> <rj><qau>Jer. Taylor.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Beauty spot</b></col>, <cd>a patch or spot placed on the
face with intent to heighten beauty by contrast.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beaux</ent><br/
<hw>Beaux</hw> <pr>(<?/)</pr>, <pos>n.</pos>, <def><pos>pl.</pos> of
<er>Beau</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beauxite</ent><br/
<hw>Beaux"ite</hw> <pr>(<?/)</pr>, <pos>n.</pos> <fld>(Min.)</fld>
<def>See <er>Bauxite</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beaver</ent><br/
<hw>Bea"ver</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[OE.
<ets>bever</ets>, AS. <ets>beofer</ets>, <ets>befer</ets>; akin to D.
<ets>bever</ets>, OHG. <ets>bibar</ets>, G. <ets>biber</ets>, Sw.
<ets>b<aum/fver</ets>, Dan. <ets>b<ae/ver</ets>, Lith. <ets>bebru</ets>,
Russ. <ets>bobr'</ets>, Gael. <ets>beabhar</ets>, Corn.
<ets>befer</ets>, L. <ets>fiber</ets>, and Skr. <ets>babhrus</ets> large
ichneumon; also as an adj., <ets>brown</ets>, the animal being probably
named from its color. <root/253. See <er>Brown</er>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <fld>(Zool.)</fld> <def>An amphibious rodent, of the
genus <gen>Castor</gen>.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ It has palmated hind feet, and a broad, flat tail. It is
remarkable for its ingenuity in constructing its lodges or
<ldquo/houses,<rdquo/ and dams across streams. It is valued for its fur,
and for the material called <prod>castor</prod>, obtained from two small
bags in the groin of the animal. The European species is <spn>Castor
fiber</spn>, and the American is generally considered a variety of this,
although sometimes called <spn>Castor Canadensis</spn>.</note><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The fur of the beaver.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>A hat, formerly made of the fur of the beaver, but
now usually of silk.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>A brown <qex>beaver</qex> slouched over his eyes.</q>
<rj><qau>Prescott.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>Beaver cloth, a heavy felted woolen cloth, used
chiefly for making overcoats.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>A man's beard.</def><br/
[<source>PJC</source>]</p>

<p><sn>6.</sn> <def>The hair on a woman's pubic area; -- vulgar.</def>
<mark>[vulgar slang]</mark><br/
[<source>PJC</source>]</p>

<p><sn>7.</sn> <def>A woman; -- vulgar and offensive.</def>
<mark>[vulgar slang]</mark><br/
[<source>PJC</source>]</p>

<p><sn>8.</sn> <def>A person who works enthusiastically and diligently;
-- used especially in the phrase <er>eager beaver</er>.</def>
<mark>[informal]</mark><br/
[<source>PJC</source>]</p>

<p><cs><col><b>Beaver rat</b></col> <fld>(Zool.)</fld>, <cd>an aquatic
ratlike quadruped of Tasmania (<spn>Hydromys chrysogaster</spn>).</cd>
-- <col><b>Beaver skin</b></col>, <cd>the furry skin of the beaver.</cd>
-- <col><b>Bank beaver</b></col>. <cd>See under 1st
<er>Bank</er>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beaver</ent><br/
<hw>Bea"ver</hw>, <pos>n.</pos> <ety>[OE. <ets>baviere</ets>,
<ets>bauier</ets>, <ets>beavoir</ets>, <ets>bever</ets>; fr. F.
<ets>bavi<egrave/re</ets>, fr. <ets>bave</ets> slaver, drivel, foam,
OF., prattle, drivel, perh. orig. an imitative word.
<ets>Bavi<egrave/re</ets>, according to Cotgrave, is the bib put before
a (slavering) child.]</ety> <def>That piece of armor which protected the
lower part of the face, whether forming a part of the helmet or fixed to
the breastplate. It was so constructed (with joints or otherwise) that
the wearer could raise or lower it to eat and drink.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beavered</ent><br/
<hw>Bea"vered</hw> <pr>(<?/)</pr>, <pos>a.</pos> <def>Covered with, or
wearing, a beaver or hat.</def> <ldquo/His <xex>beavered</xex>
brow.<rdquo/ <rj><au>Pope.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beaver State</ent><br/
<hw>Bea"ver State</hw>. <def>Oregon; -- a nickname.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Beaverteen</ent><br/
<hw>Bea"ver*teen</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>A kind of
fustian made of coarse twilled cotton, shorn after dyeing.</def>
<rj><au>Simmonds.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 130 --></p>

<p><ent>Bebirine</ent><br/
<ent>Bebeerine</ent><br/
<mhw>{ <hw>Be*bee"rine</hw>, <it>or</it> <hw>Be*bi"rine</hw> }</mhw>
<pr>(b<esl/*b<emac/"r<icr/n <it>or</it> -r<emac/n)</pr>, <pos>n.</pos>
<fld>(Chem.)</fld> <def>An alkaloid got from the bark of the
<prodby>bebeeru</prodby>, or green heart of Guiana (<spn>Nectandra
Rodi<oe/i</spn>). It is a tonic, antiperiodic, and febrifuge, and is
used in medicine as a substitute for quinine.</def> <altsp>[Written also
<asp>bibirine</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><ent>bebeeru</ent><br/
<hw>be*bee"ru</hw> <pr>(b<esl/*b<emac/"r<udd/)</pr>, <pos>n.</pos>
<altsp>[Written also <asp>bibiru</asp>.]</altsp> <ety>[Native
name.]</ety> <fld>(Bot.)</fld> <def>A tropical South American tree
(<spn>Nectandra Rodi<oe/i</spn>), the bark of which yields the alkaloid
bebeerine, and the wood of which is known as <prod>green
heart</prod>.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Bebleed</ent><br/
<hw>Be*bleed"</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <def>To make bloody;
to stain with blood.</def> <mark>[Obs.]</mark>
<rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bebloody</ent><br/
<ent>Beblood</ent><br/
<mhw>{ <hw>Be*blood"</hw> <pr>(<?/)</pr>, <hw>Be*blood"y</hw> }</mhw>
<pr>(<?/)</pr>, <pos>v. t.</pos> <def>To make bloody; to stain with
blood.</def> <mark>[Obs.]</mark> <rj><au>Sheldon.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beblot</ent><br/
<hw>Be*blot"</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <def>To blot; to
stain.</def> <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beblubber</ent><br/
<hw>Be*blub"ber</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <def>To make
swollen and disfigured or sullied by weeping; <as>as, her eyes or cheeks
were <ex>beblubbered</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bebung</ent><br/
\'d8<hw>Be"bung</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[G., lit., a
trembling.]</ety> <fld>(Music)</fld> <def>A tremolo effect, such as that
produced on the piano by vibratory repetition of a note with sustained
use of the pedal.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Becalm</ent><br/
<hw>Be*calm"</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. &
p. p.</pos> <conjf>Becalmed</conjf> (<?/); <pos>p. pr. & vb. n.</pos>
<conjf>Becalming</conjf>.]</vmorph> <sn>1.</sn> <def>To render calm or
quiet; to calm; to still; to appease.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Soft whispering airs . . . <qex>becalm</qex> the mind.</q>
<rj><qau>Philips.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To keep from motion, or stop the progress of, by the
stilling of the wind; <as>as, the fleet was
<ex>becalmed</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Became</ent><br/
<hw>Be*came"</hw> <pr>(<?/)</pr>, <def><pos>imp.</pos> of
<er>Become</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Becard</ent><br/
\'d8<hw>Bec"ard</hw> <pr>(<?/)</pr>, <pos>n.</pos> <fld>(Zool.)</fld>
<def>A South American bird of the flycatcher family. (<spn>Tityra
inquisetor</spn>).</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Because</ent><br/
<hw>Be*cause"</hw> <pr>(<?/)</pr>, <pos>conj.</pos> <ety>[OE.
<ets>bycause</ets>; <ets>by</ets> + <ets>cause</ets>.]</ety> <sn>1.</sn>
<def>By or for the cause that; on this account that; for the reason
that.</def> <rj><au>Milton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>In order that; that.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>And the multitude rebuked them <qex>because</qex> they should hold
their peace.</q> <rj><qau>Matt. xx. 31.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Because of</b></col>, <cd>by reason of, on account
of.</cd> <mark>[Prep. phrase.]</mark></cs><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>Because of</qex> these things cometh the wrath of God upon
the children of disobedience.</q> <rj><qau>Eph. v. 6.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- <er>Because</er>, <er>For</er>, <er>Since</er>,
<er>As</er>, <er>Inasmuch As</er>.</syn> <usage> These particles are
used, in certain connections, to assign the <xex>reason</xex> of a
thing, or that <ldquo/on account of<rdquo/ which it is or takes place.
<xex>Because</xex> (by cause) is the strongest and most emphatic; as, I
hid myself <xex>because</xex> I was afraid. <xex>For</xex> is not quite
so strong; as, in Shakespeare, <ldquo/I hate him, <xex>for</xex> he is a
Christian.<rdquo/ <xex>Since</xex> is less formal and more incidental
than <xex>because</xex>; as, I will do it <xex>since</xex> you request
me. It more commonly begins a sentence; as, <xex>Since</xex> your
decision is made, I will say no more. <xex>As</xex> is still more
incidental than <xex>since</xex>, and points to some existing fact by
way of assigning a reason. Thus we say, <xex>as</xex> I knew him to be
out of town, I did not call. <xex>Inasmuch as</xex> seems to carry with
it a kind of <xex>qualification</xex> which does not belong to the rest.
Thus, if we say, I am ready to accept your proposal, <xex>inasmuch
as</xex> I believe it is the best you can offer, we mean, it is only
with this understanding that we can accept it.</usage><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beccabunga</ent><br/
\'d8<hw>Bec`ca*bun"ga</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[NL. (cf.
It. <ets>beccabunga</ets>, G. <ets>bachbunge</ets>), fr. G.
<ets>bach</ets> brook + <ets>bunge</ets>, OHG. <ets>bungo</ets>, bulb.
See <er>Beck</er> a brook.]</ety> <def>See <er>Brooklime</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beccafico</ent><br/
\'d8<hw>Bec`ca*fi"co</hw> <pr>(<?/)</pr>, <pos>n.</pos>;
<plu><it>pl.</it> <plw>Beccaficos</plw> <pr>(<?/)</pr>.</plu> <ety>[It.,
fr. <ets>beccare</ets> to peck + <ets>fico</ets> fig.]</ety>
<fld>(Zool.)</fld> <def>A small bird. (<spn>Silvia hortensis</spn>),
which is highly prized by the Italians for the delicacy of its flesh in
the autumn, when it has fed on figs, grapes, etc.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Becchi's test</ent><br/
<hw>Bec"chi's test</hw> <pr>(?)</pr>. <ety>[After E.
<etsep>Becchi</etsep>, Italian chemist.]</ety> <fld>(Chem.)</fld> <def>A
qualitative test for cottonseed oil, based on the fact this oil imparts
a maroon color to an alcoholic solution of silver nitrate.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Bechamel</ent><br/
\'d8<hw>Bech"a*mel</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[F.
<ets>b<eacute/chamel</ets>, named from its inventor, Louis de
<etsep>B<eacute/chamel</etsep>.]</ety> <fld>(Cookery)</fld> <def>A rich,
white sauce, prepared with butter and cream.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bechance</ent><br/
<hw>Be*chance"</hw> <pr>(<?/)</pr>, <pos>adv.</pos> <ety>[Pref.
<ets>be-</ets> for <ets>by</ets> + <ets>chance</ets>.]</ety> <def>By
chance; by accident.</def> <mark>[Obs.]</mark>
<rj><au>Grafton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bechance</ent><br/
<hw>Be*chance"</hw>, <pos>v. t. & i.</pos> <def>To befall; to chance; to
happen to.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>God knows what hath <qex>bechanced</qex> them.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Becharm</ent><br/
<hw>Be*charm"</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <def>To charm; to
captivate.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beche de mer</ent><br/
\'d8<hw>B<ecir/che` de mer"</hw> <pr>(<?/)</pr>. <ety>[F., lit., a sea
spade.]</ety> <fld>(Zool.)</fld> <def>The trepang.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bechic</ent><br/
<hw>Be"chic</hw> <pr>(<?/)</pr>, a. <ety>[L. <ets>bechicus</ets>, adj.,
for a cough, Gr. <ets><?/</ets>, fr. <ets><?/</ets> cough: cf. F.
<ets>b<eacute/chique</ets>.]</ety> <fld>(Med.)</fld> <def>Pertaining to,
or relieving, a cough.</def> <au>Thomas.</au> -- <def2><pos>n.</pos>
<def>A medicine for relieving coughs.</def></def2>
<rj><au>Quincy.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bechuanas</ent><br/
<hw>Bech`u*a"nas</hw> <pr>(?)</pr>, <pos>n. pl.</pos> <def>A division of
the Bantus, dwelling between the Orange and Zambezi rivers, supposed to
be the most ancient Bantu population of South Africa. They are divided
into totemic clans; they are intelligent and progressive.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Beck</ent><br/
<hw>Beck</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>See
<er>Beak</er>.</def> <mark>[Obs.]</mark> <rj><au>Spenser.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beck</ent><br/
<hw>Beck</hw>, <pos>n.</pos> <ety>[OE. <ets>bek</ets>, AS.
<ets>becc</ets>; akin to Icel. <ets>bekkr</ets> brook, OHG.
<ets>pah</ets>, G. <ets>bach</ets>.]</ety> <def>A small brook.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The brooks, the <qex>becks</qex>, the rills.</q>
<rj><qau>Drayton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beck</ent><br/
<hw>Beck</hw>, <pos>n.</pos> <def>A vat. See <er>Back</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beck</ent><br/
<hw>Beck</hw>, <pos>v. i.</pos> <vmorph>[<pos>imp. & p. p.</pos>
<conjf>Becked</conjf> <pr>(<?/)</pr>; <pos>p. pr. & vb. n.</pos>
<conjf>Becking</conjf>.]</vmorph> <ety>[<ets>Contr</ets>. <ets>of
beckon</ets>.]</ety> <def>To nod, or make a sign with the head or
hand.</def> <mark>[Archaic]</mark> <rj><au>Drayton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beck</ent><br/
<hw>Beck</hw>, <pos>v. t.</pos> <def>To notify or call by a nod, or a
motion of the head or hand; to intimate a command to.</def>
<mark>[Archaic]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>When gold and silver <qex>becks</qex> me to come on.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beck</ent><br/
<hw>Beck</hw>, <pos>n.</pos> <def>A significant nod, or motion of the
head or hand, esp. as a call or command.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>They have troops of soldiers at their <qex>beck</qex>.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Becker</ent><br/
<hw>Beck"er</hw> <pr>(<?/)</pr>, <pos>n.</pos> <fld>(Zool.)</fld> <def>A
European fish (<spn>Pagellus centrodontus</spn>); the sea bream or
braise.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Becket</ent><br/
<hw>Beck"et</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[Cf. D.
<ets>bek</ets> beak, and E. <ets>beak</ets>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <fld>(Naut.)</fld> <def>A small grommet, or a ring or
loop of rope or metal for holding things in position, as spars, ropes,
etc.; also a bracket, a pocket, or a handle made of rope.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A spade for digging turf.</def> <mark>[Prov.
Eng.]</mark> <rj><au>Wright.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beckon</ent><br/
<hw>Beck"on</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos>
<conjf>Beckoned</conjf> (<?/); <pos>p. pr. & vb. n.</pos>
<conjf>Beckoning</conjf>.]</vmorph> <def>To make a significant sign to;
hence, to summon, as by a motion of the hand.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>His distant friends, he <qex>beckons</qex> near.</q>
<rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>It <qex>beckons</qex> you to go away with it.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beckon</ent><br/
<hw>Beck"on</hw>, <pos>n.</pos> <def>A sign made without words; a
beck.</def> <ldquo/At the first <xex>beckon</xex>.<rdquo/
<rj><au>Bolingbroke.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beck's scale</ent><br/
<hw>Beck's scale</hw> <pr>(?)</pr>. <def>A hydrometer scale on which the
zero point corresponds to sp. gr. 1.00, and the 30<deg/-point to sp. gr.
0.85. From these points the scale is extended both ways, all the degrees
being of equal length.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Beclap</ent><br/
<hw>Be*clap</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <ety>[OE.
<ets>biclappen</ets>.]</ety> <def>To catch; to grasp; to insnare.</def>
<mark>[Obs.]</mark> <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beclip</ent><br/
<hw>Be*clip"</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. &
p. p.</pos> <conjf>Beclipped</conjf> (<?/).]</vmorph> <ety>[AS.
<ets>beclyppan</ets>; pref. <ets>be</ets> + <ets>clyppan</ets> to
embrace.]</ety> <def>To embrace; to surround.</def> <mark>[Obs.]</mark>
<rj><au>Wyclif.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Becloud</ent><br/
<hw>Be*cloud"</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. &
p. p.</pos> <conjf>Beclouded</conjf>; <pos>p. pr. & vb. n.</pos>
<conjf>Beclouding</conjf>.]</vmorph> <def>To cause obscurity or dimness
to; to dim; to cloud.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>If thou <qex>becloud</qex> the sunshine of thine eye.</q>
<rj><qau>Quarles.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Become</ent><br/
<hw>Be*come"</hw> <pr>(<?/)</pr>, <pos>v. i.</pos>
<vmorph>[<pos>imp.</pos> <conjf>Became</conjf> <pr>(<?/)</pr>; <pos>p.
p.</pos> <conjf>Become</conjf>; <pos>p. pr. & vb. n.</pos>
<conjf>Becoming</conjf>.]</vmorph> <ety>[OE. <ets>bicumen</ets>,
<ets>becumen</ets>, AS. <ets>becuman</ets> to come to, to happen; akin
to D. <ets>bekomen</ets>, OHG.a <ets>piqu<eum/man</ets>, Goth.
<ets>biquiman</ets> to come upon, G. <ets>bekommen</ets> to get, suit.
See <er>Be-</er>, and <er>Come</er>.]</ety> <sn>1.</sn> <def>To pass
from one state to another; to enter into some state or condition, by a
change from another state, or by assuming or receiving new properties or
qualities, additional matter, or a new character.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The Lord God . . . breathed into his nostrils the breath of life;
and man <qex>became</qex> a living soul.</q> <rj><qau>Gen. ii.
7.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>That error now which is <qex>become</qex> my crime.</q>
<rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To come; to get.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>But, madam, where is Warwick then <qex>become</qex>!</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>To become of</b></col>, <cd>to be the present state or
place of; to be the fate of; to be the end of; to be the final or
subsequent condition of.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><q>What is then <qex>become of</qex> so huge a multitude?</q>
<rj><qau>Sir W. Raleigh.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Become</ent><br/
<hw>Be*come"</hw>, <pos>v. t.</pos> <def>To suit or be suitable to; to
be congruous with; to befit; to accord with, in character or
circumstances; to be worthy of, or proper for; to cause to appear well;
-- said of persons and things.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>It <qex>becomes</qex> me so to speak of so excellent a poet.</q>
<rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>I have known persons so anxious to have their dress
<qex>become</qex> them, as to convert it, at length, into their proper
self, and thus actually to <qex>become</qex> the dress.</q>
<rj><qau>Coleridge.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Becomed</ent><br/
<hw>Be*com"ed</hw> <pr>(<?/)</pr>, <pos>a.</pos> <def>Proper;
decorous.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>And gave him what <qex>becomed</qex> love I might.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Becoming</ent><br/
<hw>Be*com"ing</hw>, <pos>a.</pos> <def>Appropriate or fit; congruous;
suitable; graceful; befitting.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>A low and <qex>becoming</qex> tone.</q>
<rj><qau>Thackeray.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><note>Formerly sometimes followed by <xex>of</xex>.</note><br/
[<source>1913 Webster</source>]</p>

<p><q>Such discourses as are <qex>becoming</qex> of them.</q>
<rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- Seemly; comely; decorous; decent;
proper.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Becoming</ent><br/
<hw>Be*com"ing</hw>, <pos>n.</pos> <def>That which is becoming or
appropriate.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Becomingly</ent><br/
<hw>Be*com"ing*ly</hw>, <pos>adv.</pos> <def>In a becoming
manner.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Becomingness</ent><br/
<hw>Be*com"ing*ness</hw>, <pos>n.</pos> <def>The quality of being
becoming, appropriate, or fit; congruity; fitness.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The <qex>becomingness</qex> of human nature.</q>
<rj><qau>Grew.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Becquerel rays</ent><br/
<hw>Becque`rel" rays"</hw> <pr>(?)</pr>. <fld>(Physics)</fld>
<def>Radiations first observed by the French physicist Henri Becquerel,
in working with uranium and its compounds. They consist of a mixture of
alpha, beta, and gamma rays.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Becripple</ent><br/
<hw>Be*crip"ple</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <def>To make a
cripple of; to cripple; to lame.</def> <mark>[R.]</mark> <rj><au>Dr. H.
More.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Becuiba nut</ent><br/
<ent>Becuiba</ent><br/
<mhw>{ <hw>Be*cui"ba</hw> <pr>(?)</pr>, <pos>n.</pos>, <hw>Be*cui"ba
nut`</hw> <pr>(?)</pr> }</mhw>. <ety>[Native name.]</ety>
<fld>(Bot.)</fld> <def>The nut of the Brazilian tree <spn>Myristica
Bicuhyba</spn>, which yields a medicinal balsam used for
rheumatism.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Becuna</ent><br/
\'d8<hw>Be*cu"na</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[Sp.]</ety>
<fld>(Zool.)</fld> <def>A fish of the Mediterranean (<spn>Sphyr<ae/na
spet</spn>). See <er>Barracuda</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Becurl</ent><br/
<hw>Be*curl"</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <def>To curl; to
adorn with curls.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bed</ent><br/
<hw>Bed</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[AS. <ets>bed</ets>,
<ets>bedd</ets>; akin to OS. <ets>bed</ets>, D. <ets>bed</ets>,
<ets>bedde</ets>, Icel. <ets>be<edh/r</ets>, Dan. <ets>bed</ets>, Sw.
<ets>b<aum/dd</ets>, Goth. <ets>badi</ets>, OHG. <ets>betti</ets>, G.
<ets>bett</ets>, <ets>bette</ets>, bed, <ets>beet</ets> a plat of
ground; all of uncertain origin.]</ety> <sn>1.</sn> <def>An article of
furniture to sleep or take rest in or on; a couch. Specifically: A sack
or mattress, filled with some soft material, in distinction from the
bedstead on which it is placed (as, a feather <xex>bed</xex>), or this
with the bedclothes added. In a general sense, any thing or place used
for sleeping or reclining on or in, as a quantity of hay, straw, leaves,
or twigs.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>And made for him [a horse] a leafy <qex>bed</qex>.</q>
<rj><qau>Byron.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>I wash, wring, brew, bake, . . . make the <qex>beds</qex>.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>In <qex>bed</qex> he slept not for my urging it.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>(Used as the symbol of matrimony)
Marriage.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>George, the eldest son of his second <qex>bed</qex>.</q>
<rj><qau>Clarendon.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>A plat or level piece of ground in a garden, usually
a little raised above the adjoining ground.</def> <ldquo/<xex>Beds</xex>
of hyacinth and roses.<rdquo/ <rj><au>Milton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>A mass or heap of anything arranged like a bed;
<as>as, a <ex>bed</ex> of ashes or coals</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>The bottom of a watercourse, or of any body of
water; <as>as, the <ex>bed</ex> of a river</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>So sinks the daystar in the ocean <qex>bed</qex>.</q>
<rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <fld>(Geol.)</fld> <def>A layer or seam, or a horizontal
stratum between layers; <as>as, a <ex>bed</ex> of coal, iron,
etc.</as></def><br/
[<source>1913 Webster</source>]</p>

<p><sn>7.</sn> <fld>(Gun.)</fld> <def>See <er>Gun carriage</er>, and
<er>Mortar bed</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>8.</sn> <fld>(Masonry)</fld> <sd>(a)</sd> <def>The horizontal
surface of a building stone; <as>as, the upper and lower
<ex>beds</ex></as>.</def> <sd>(b)</sd> <def>A course of stone or brick
in a wall.</def> <sd>(c)</sd> <def>The place or material in which a
block or brick is laid.</def> <sd>(d)</sd> <def>The lower surface of a
brick, slate, or tile.</def> <rj><au>Knight.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>9.</sn> <fld>(Mech.)</fld> <def>The foundation or the more solid
and fixed part or framing of a machine; or a part on which something is
laid or supported; <as>as, the <ex>bed</ex> of an engine</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>10.</sn> <def>The superficial earthwork, or ballast, of a
railroad.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>11.</sn> <fld>(Printing)</fld> <def>The flat part of the press,
on which the form is laid.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ <xex>Bed</xex> is much used adjectively or in
combination; as, <xex>bed</xex> key or bedkey; <xex>bed</xex> wrench or
<xex>bed</xex>wrench; <xex>bed</xex>chamber; <xex>bed</xex>maker,
etc.</note><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Bed of justice</b></col> <fld>(French Hist.)</fld>,
<cd>the throne (F. <xex>lit</xex> bed) occupied by the king when sitting
in one of his parliaments (judicial courts); hence, a session of a
refractory parliament, at which the king was present for the purpose of
causing his decrees to be registered.</cd> -- <col><b>To be brought to
bed</b></col>, <cd>to be delivered of a child; -- often followed by
<xex>of</xex>; as, to be <xex>brought to bed of</xex> a son.</cd> --
<col><b>To make a bed</b></col>, <cd>to prepare a bed; to arrange or put
in order a bed and its bedding.</cd> -- <col><b>From bed and
board</b></col> <fld>(Law)</fld>, <cd>a phrase applied to a separation
by partial divorce of man and wife, without dissolving the bonds of
matrimony. If such a divorce (now commonly called a <xex>judicial
separation</xex>) be granted at the instance of the wife, she may have
alimony.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bed</ent><br/
<hw>Bed</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos>
<conjf>Bedded</conjf>; <pos>p. pr. & vb. n.</pos>
<conjf>Bedding</conjf>.]</vmorph> <sn>1.</sn> <def>To place in a
bed.</def> <mark>[Obs.]</mark> <rj><au>Bacon.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To make partaker of one's bed; to cohabit
with.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>I'll to the Tuscan wars, and never <qex>bed</qex> her.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To furnish with a bed or bedding.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>To plant or arrange in beds; to set, or cover, as in
a bed of soft earth; <as>as, to <ex>bed</ex> the roots of a plant in
mold</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>To lay or put in any hollow place, or place of rest
and security, surrounded or inclosed; to embed; to furnish with or place
upon a bed or foundation; <as>as, to <ex>bed</ex> a stone; it was
<ex>bedded</ex> on a rock</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Among all chains or clusters of mountains where large bodies of
still water are <qex>bedded</qex>.</q>
<rj><qau>Wordsworth.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <fld>(Masonry)</fld> <def>To dress or prepare the surface
of stone) so as to serve as a bed.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>7.</sn> <def>To lay flat; to lay in order; to place in a
horizontal or recumbent position.</def> <ldquo/<xex>Bedded</xex>
hair.<rdquo/ <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bed</ent><br/
<hw>Bed</hw> <pr>(<?/)</pr>, <pos>v. i.</pos> <def>To go to bed; to
cohabit.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>If he be married, and <qex>bed</qex> with his wife.</q>
<rj><qau>Wiseman.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bedabble</ent><br/
<hw>Be*dab*ble</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp.
& p. p.</pos> <conjf>Bedabbled</conjf> <pr>(<?/)</pr>; <pos>p. pr. & vb.
n.</pos> <conjf>Bedabbling</conjf> <pr>(<?/)</pr>.]</vmorph> <def>To
dabble; to sprinkle or wet.</def> <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bedaff</ent><br/
<hw>Be*daff"</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <def>To make a daff
or fool of.</def> <mark>[Obs.]</mark> <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bedagat</ent><br/
\'d8<hw>Bed"a*gat</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>The sacred
books of the Buddhists in Burmah.</def> <rj><au>Malcom.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bedaggle</ent><br/
<hw>Be*dag"gle</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <def>To
daggle.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bedash</ent><br/
<hw>Be*dash"</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. &
p. p.</pos> <conjf>Bedashed</conjf> (<?/); <pos>p. pr. & vb. n.</pos>
<conjf>Bedashing</conjf>.]</vmorph> <def>To wet by dashing or throwing
water or other liquid upon; to bespatter.</def> <ldquo/Trees
<xex>bedashed</xex> with rain.<rdquo/ <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bedaub</ent><br/
<hw>Be*daub"</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. &
p. p.</pos> <conjf>Bedaubed</conjf> (<?/); <pos>p. pr. & vb. n.</pos>
<conjf>Bedaubing</conjf>.]</vmorph> <def>To daub over; to besmear or
soil with anything thick and dirty.</def><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>Bedaub</qex> foul designs with a fair varnish.</q>
<rj><qau>Barrow.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>bedaubed</ent><br/
<hw>bedaubed</hw> <pos>adj.</pos> <def>ornamented in a vulgar or showy
fashion.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>bedaze</ent><br/
<hw>be*daze"</hw> <pos>v.</pos> <def>to cause to be senseless, groggy,
or dizzy; cause to lose ability to respond normally;
desensitize.</def><br/
<syn><b>Syn. --</b> stun, daze.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Bedazzle</ent><br/
<hw>Be*daz"zle</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp.
& p. p.</pos> <conjf>Bedazzled</conjf> (<?/); <pos>p. pr. & vb. n.</pos>
<conjf>Bedazzling</conjf> (<?/).]</vmorph> <def>To dazzle or make dim by
a strong light.</def> <ldquo/<xex>Bedazzled</xex> with the sun.<rdquo/
<rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bedbug</ent><br/
<hw>Bed"bug`</hw> <pr>(<?/)</pr>, <pos>n.</pos> <fld>(Zool.)</fld>
<def>A wingless, bloodsucking, hemipterous insect (<spn>Cimex
Lectularius</spn>), sometimes infesting houses and especially beds. See
<xex>Illustration</xex> in Appendix.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bedchair</ent><br/
<hw>Bed"chair`</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>A chair with
adjustable back, for the sick, to support them while sitting up in
bed.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bedchamber</ent><br/
<hw>Bed"cham`ber</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>A chamber for a
bed; an apartment form sleeping in.</def> <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Lords of the bedchamber</b></col>, <cd>eight officers of
the royal household, all of noble families, who wait in turn a week
each.</cd> <mark>[Eng.]</mark> -- <col><b>Ladies of the
bedchamber</b></col>, <cd>eight ladies, all titled, holding a similar
official position in the royal household, during the reign of a
queen.</cd> <mark>[Eng.]</mark></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bedclothes</ent><br/
<hw>Bed"clothes`</hw> <pr>(<?/)</pr>, <pos>n. pl.</pos> <def>Blankets,
sheets, coverlets, etc., for a bed.</def> <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bedcord</ent><br/
<hw>Bed"cord`</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>A cord or rope
interwoven in a bedstead so as to support the bed.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bedded</ent><br/
<hw>Bed"ded</hw> <pr>(<?/)</pr>, <pos>a.</pos> <def>Provided with a bed;
<as>as, double-<ex>bedded</ex> room</as>; placed or arranged in a bed or
beds.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>bedder</ent><br/
<hw>bed"der</hw> <pos>n.</pos> <def>an ornamental plant suitable for
planting in a flowerbed.</def><br/
<syn><b>Syn. --</b> bedding plant.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Bedding</ent><br/
<hw>Bed"ding</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[AS.
<ets>bedding</ets>, <ets>beding</ets>. See <er>Bed</er>.]</ety>
<sn>1.</sn> <def>A bed and its furniture; the materials of a bed,
whether for man or beast; bedclothes; litter.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Geol.)</fld> <def>The state or position of beds and
layers.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bede</ent><br/
<hw>Bede</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <ety>[See <er>Bid</er>,
<pos>v. t.</pos>]</ety> <def>To pray; also, to offer; to proffer.</def>
<mark>[Obs.]</mark> <rj><au>R. of Gloucester. Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bede</ent><br/
<hw>Bede</hw>, <pos>n.</pos> <fld>(Mining)</fld> <def>A kind of
pickax.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bedeck</ent><br/
<hw>Be*deck"</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. &
p. p.</pos> <conjf>Bedecked</conjf> (<?/); <pos>p. pr. & vb. n.</pos>
<conjf>Bedecking</conjf>.]</vmorph> <def>To deck, ornament, or adorn; to
grace.</def><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>Bedecked</qex> with boughs, flowers, and garlands.</q>
<rj><qau>Pennant.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bedegar</ent><br/
<ent>Bedeguar</ent><br/
<mhw>{ \'d8<hw>Bed"e*guar</hw>, <hw>Bed"e*gar</hw> }</mhw>
<pr>(<?/)</pr>, <pos>n.</pos> <ety>[F., fr. Per.
<ets>b<amac/d-<amac/ward</ets>, or <ets>b<amac/d-<amac/wardag</ets>,
prop., a kind of white thorn or thistle.]</ety> <def>A gall produced on
rosebushes, esp. on the sweetbrier or eglantine, by a puncture from the
ovipositor of a gallfly (<spn>Rhodites ros<ae/</spn>). It was once
supposed to have medicinal properties.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bedehouse</ent><br/
<hw>Bede"house`</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>Same as
<er>Beadhouse</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bedell</ent><br/
<ent>Bedel</ent><br/
<mhw>{ <hw>Be"del</hw>, <hw>Be"dell</hw> }</mhw> <pr>(<?/)</pr>,
<pos>n.</pos> <def>Same as <er>Beadle</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bedelry</ent><br/
<hw>Be"del*ry</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>Beadleship.</def>
<mark>[Obs.]</mark> <rj><au>Blount.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beden</ent><br/
\'d8<hw>Bed"en</hw> <pr>(<?/)</pr>, <pos>n.</pos> <fld>(Zool.)</fld>
<def>The Abyssinian or Arabian ibex (<spn>Capra Nubiana</spn>). It is
probably the wild goat of the Bible.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bedesman</ent><br/
<hw>Bedes"man</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>Same as
<er>Beadsman</er>.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bedevil</ent><br/
<hw>Be*dev"il</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. &
p. p.</pos> <conjf>Bedevilled</conjf> (<?/); <pos>p. pr. & vb. n.</pos>
<conjf>Bedeviling</conjf> or <conjf>Bedevilling</conjf>.]</vmorph>
<sn>1.</sn> <def>To throw into utter disorder and confusion, as if by
the agency of evil spirits; to bring under diabolical influence; to
torment.</def><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>Bedeviled</qex> and used worse than St. Bartholomew.</q>
<rj><qau>Sterne.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To spoil; to corrupt.</def>
<rj><au>Wright.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bedevilment</ent><br/
<hw>Be*dev"il*ment</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>The state of
being bedeviled; bewildering confusion; vexatious trouble.</def>
<mark>[Colloq.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bedew</ent><br/
<hw>Be*dew"</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. &
p. p.</pos> <conjf>Bedewed</conjf> (<?/); <pos>p. pr. & vb. n.</pos>
<conjf>Bedewing</conjf>.]</vmorph> <def>To moisten with dew, or as with
dew.</def> <ldquo/Falling tears his face <xex>bedew</xex>.<rdquo/
<rj><au>Dryden.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bedewer</ent><br/
<hw>Be*dew"er</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>One who, or that
which, bedews.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bedewy</ent><br/
<hw>Be*dew"y</hw> <pr>(<?/)</pr>, <pos>a.</pos> <def>Moist with dew;
dewy.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>Night with her <qex>bedewy</qex> wings.</q> <rj><qau>A.
Brewer.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bedfellow</ent><br/
<hw>Bed"fel`low</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>One who lies
with another in the same bed; a person who shares one's couch.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bedphere</ent><br/
<ent>Bedfere</ent><br/
<mhw>{ <hw>Bed"fere`</hw> <hw>Bed"phere`</hw> }</mhw> <pr>(<?/)</pr>,
<pos>n.</pos> <ety>[<ets>Bed</ets> + AS. <ets>fera</ets> a
companion.]</ety> <def>A bedfellow.</def> <mark>[Obs.]</mark>
<rj><au>Chapman.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bedgown</ent><br/
<hw>Bed"gown`</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>A
nightgown.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>bedground</ent><br/
<hw>bed"ground`</hw> <pos>n.</pos> <def>an area on which a drove of
cattle or sheep can sleep for a night.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Bedight</ent><br/
<hw>Be*dight"</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <vmorph>[<pos>p.
p.</pos> <conjf>Bedight</conjf>, <conjf>Bedighted</conjf>.]</vmorph>
<def>To bedeck; to array or equip; to adorn.</def>
<mark>[Archaic]</mark> <rj><au>Milton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bedim</ent><br/
<hw>Be*dim"</hw> <pr>(b<esl/*d<icr/m")</pr>, <pos>v. t.</pos>
<vmorph>[<pos>imp. & p. p.</pos> <conjf>Bedimmed</conjf>
<pr>(b<esl/*d<icr/md")</pr>; <pos>p. pr. & vb. n.</pos>
<conjf>Bedimming</conjf>.]</vmorph> <def>To make dim; to obscure or
darken.</def> <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>bedimmed</ent><br/
<hw>be*dimmed</hw> <pr>(b<esl/*d<icr/md")</pr>, <pos>adj.</pos>
<sn>1.</sn> <def>made dim or indistinct.</def> <illu>a sun
<ex>bedimmed</ex> by clouds</illu><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Bedizen</ent><br/
<hw>Be*diz"en</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <def>To dress or
adorn tawdrily or with false taste.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Remnants of tapestried hangings, . . . and shreds of pictures with
which he had <qex>bedizened</qex> his tatters.</q> <rj><qau>Sir W.
Scott.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bedizenment</ent><br/
<hw>Be*diz"en*ment</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>That which
bedizens; the act of dressing, or the state of being dressed,
tawdrily.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bedkey</ent><br/
<hw>Bed"key`</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>An instrument for
tightening the parts of a bedstead.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bedlam</ent><br/
<hw>Bed"lam</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[See
<er>Bethlehem</er>.]</ety> <sn>1.</sn> <def>A place appropriated to the
confinement and care of the insane; a madhouse.</def> <rj><au>Abp.
Tillotson.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>An insane person; a lunatic; a madman.</def>
<mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>Let's get the <qex>bedlam</qex> to lead him.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Any place where uproar and confusion
prevail.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bedlam</ent><br/
<hw>Bed"lam</hw>, <pos>a.</pos> <def>Belonging to, or fit for, a
madhouse.</def> <ldquo/The <xex>bedlam</xex>, brainsick duchess.<rdquo/
<rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bedlamite</ent><br/
<hw>Bed"lam*ite</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>An inhabitant of
a madhouse; a madman.</def> <ldquo/Raving <xex>bedlamites</xex>.<rdquo/
<rj><au>Beattie.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bedmaker</ent><br/
<hw>Bed"mak`er</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>One who makes
beds.</def><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 131 --></p>

<p><ent>Bed-moulding</ent><br/
<ent>Bed-molding</ent><br/
<mhw>{ <hw>Bed"-mold`ing</hw> <hw>Bed"-mould`ing</hw>}</mhw>
<pr>(b<ecr/d"m<omac/ld`<icr/ng)</pr>, <pos>n.</pos> <fld>(Arch.)</fld>
<def>The molding of a cornice immediately below the corona.</def>
<rj><au>Oxf. Gloss.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bedote</ent><br/
<hw>Be*dote"</hw> <pr>(b<esl/*d<omac/t")</pr>, <pos>v. t.</pos> <def>To
cause to dote; to deceive.</def> <mark>[Obs.]</mark>
<rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bedouin</ent><br/
<hw>Bed"ou*in</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[F.
<ets>b<eacute/douin</ets>, OF. <ets>b<eacute/duin</ets>, fr. Ar.
<ets>bedaw<imac/</ets> rural, living in the desert, fr. <ets>badw</ets>
desert, fr. <ets>bad<amac/</ets> to live in the desert, to lead a
nomadic life.]</ety> <def>One of the nomadic Arabs who live in tents,
and are scattered over Arabia, Syria, and northern Africa, esp. in the
deserts.</def> -- <wordforms><wf>Bed"ou*in*ism</wf> <pr>(<?/)</pr>,
<pos>n.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bedouin</ent><br/
<hw>Bed"ou*in</hw>, <pos>a.</pos> <def>Pertaining to the Bedouins;
nomad.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bedpan</ent><br/
<hw>Bed"pan`</hw> <pr>(<?/)</pr>, <pos>n.</pos> <sn>1.</sn> <def>A pan
for warming beds.</def> <rj><au>Nares.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A shallow chamber vessel, so constructed that it can
be used by a sick person in bed.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bedphere</ent><br/
<hw>Bed"phere`</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>See
<er>Bedfere</er>.</def> <mark>[Obs.]</mark> <rj><au>B.
Jonson.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bedplate</ent><br/
<ent>Bedpiece</ent><br/
<mhw>{ <hw>Bed"piece`</hw> <pr>(<?/)</pr>, <hw>Bed"plate`</hw>
<pr>(<?/)</pr>, }</mhw> <pos>n.</pos> <fld>(Mach.)</fld> <def>The
foundation framing or piece, by which the other parts are supported and
held in place; the bed; -- called also <altname>baseplate</altname> and
<altname>soleplate</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bedpost</ent><br/
<hw>Bed"post`</hw> <pr>(<?/)</pr>, <pos>n.</pos> <sn>1.</sn> <def>One of
the four standards that support a bedstead or the canopy over a
bedstead.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Anciently, a post or pin on each side of the bed to
keep the clothes from falling off. See <er>Bedstaff</er>.</def>
<rj><au>Brewer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bedquilt</ent><br/
<hw>Bed"quilt`</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>A quilt for a
bed; a coverlet.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bedrabble</ent><br/
<hw>Be*drab"ble</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <def>To befoul
with rain and mud; to drabble.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bedraggle</ent><br/
<hw>Be*drag"gle</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp.
& p. p.</pos> <conjf>Bedraggled</conjf> <pr>(<?/)</pr>; <pos>p. pr. &
vb. n.</pos> <conjf>Bedraggling</conjf> <pr>(<?/)</pr>.]</vmorph>
<def>To draggle; to soil, as garments which, in walking, are suffered to
drag in dust, mud, etc.</def> <rj><au>Swift.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bedrench</ent><br/
<hw>Be*drench"</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp.
& p. p.</pos> <conjf>Bedrenched</conjf> (<?/); <pos>p. pr. & vb.
n.</pos> <conjf>Bedrenching</conjf>.]</vmorph> <def>To drench; to
saturate with moisture; to soak.</def> <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bedribble</ent><br/
<hw>Be*drib"ble</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <def>To dribble
upon.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bedridden</ent><br/
<ent>Bedrid</ent><br/
<mhw>{ <hw>Bed"rid`</hw> <pr>(<?/)</pr>, <hw>Bed"rid`den</hw>
<pr>(<?/)</pr>, }</mhw> <pos>a.</pos> <ety>[OE. <ets>bedrede</ets>, AS.
<ets>bedreda</ets>, <ets>bedrida</ets>; from <ets>bed</ets>,
<ets>bedd</ets>, a bed or couch + <ets>ridda</ets> a rider; cf. OHG.
<ets>pettiriso</ets>, G. <ets>bettrise</ets>. See <er>Bed</er>,
<pos>n.</pos>, and <er>Ride</er>, <pos>v. i.</pos> ]</ety> <def>Confined
to the bed by sickness or infirmity.</def> <ldquo/Her decrepit, sick,
and <xex>bedrid</xex> father.<rdquo/ <au>Shak.</au> <ldquo/The estate of
a <xex>bedridden</xex> old gentleman.<rdquo/ <au>Macaulay.</au><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bedrite</ent><br/
<ent>Bedright</ent><br/
<mhw>{ <hw>Bed"right`</hw> <hw>Bed"rite`</hw> }</mhw> <pr>(<?/)</pr>,
<pos>n.</pos> <ety>[<ets>Bed</ets> + <ets>right</ets>,
<ets>rite</ets>.]</ety> <def>The duty or privilege of the marriage
bed.</def> <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bedrizzle</ent><br/
<hw>Be*driz"zle</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <def>To drizzle
upon.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bed rock</ent><br/
<hw>Bed" rock"</hw> <pr>(<?/)</pr>. <fld>(Mining)</fld> <def>The solid
rock underlying superficial formations. Also <mark>Fig.</mark></def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bedroom</ent><br/
<hw>Bed"room</hw> <pr>(<?/)</pr>, <pos>n.</pos> <sn>1.</sn> <def>A room
or apartment intended or used for a bed; a lodging room.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Room in a bed.</def> <note>[In this sense preferably
<asp>bed room</asp>.]</note><br/
[<source>1913 Webster</source>]</p>

<p><q>Then by your side no <qex>bed room</qex> me deny.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bedrop</ent><br/
<hw>Be*drop"</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <def>To sprinkle, as
with drops.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The yellow carp, in scales <qex>bedropped</qex> with gold.</q>
<rj><qau>Pope.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bedrug</ent><br/
<hw>Be*drug"</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <def>To drug
abundantly or excessively.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bed screw</ent><br/
<hw>Bed" screw`</hw> <pr>(<?/)</pr>. <sn>1.</sn> <fld>(Naut.)</fld>
<def>A form of jack screw for lifting large bodies, and assisting in
launching.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A long screw formerly used to fasten a bedpost to
one of the adjacent side pieces.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bedside</ent><br/
<hw>Bed"side`</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>The side of a
bed.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>bedsit</ent><br/
<hw>bed"sit</hw> <pos>n.</pos> <def>a furnished sitting room with
sleeping accommodations (and some plumbing).</def><br/
<syn><b>Syn. --</b> bedsitting room, bedsitter.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Bedsite</ent><br/
<hw>Bed"site`</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>A recess in a room
for a bed.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Of the three bedrooms, two have fireplaces, and all are of fair
size, with windows and <qex>bedsite</qex> well placed.</q>
<rj><qau>Quart. Rev.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>bedsitter</ent><br/
<hw>bed"sit*ter</hw> <pos>n.</pos> <def>a furnished sitting room with
sleeping accommodations (and some plumbing).</def><br/
<syn><b>Syn. --</b> bedsitting room, bedsit.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Bedsore</ent><br/
<hw>Bed"sore`</hw> <pr>(<?/)</pr>, <pos>n.</pos> <fld>(Med.)</fld>
<def>A sore on the back or hips caused by lying for a long time in
bed.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bedspread</ent><br/
<hw>Bed"spread`</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>A bedquilt; a
counterpane; a coverlet.</def> <mark>[U. S.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bedstaff</ent><br/
<hw>Bed"staff`</hw> <pr>(<?/)</pr>, <pos>n.</pos>; <plu><it>pl.</it>
<plw>Bedstaves</plw> <pr>(<?/)</pr>.</plu> <def><ldquo/A wooden pin
stuck anciently on the sides of the bedstead, to hold the clothes from
slipping on either side.<rdquo/</def> <rj><au>Johnson.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Hostess, accommodate us with a <qex>bedstaff</qex>.</q>
<rj><qau>B. Jonson.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Say there is no virtue in cudgels and <qex>bedstaves</qex>.</q>
<rj><qau>Brome.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bedstead</ent><br/
<hw>Bed"stead</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[<ets>Bed</ets> +
<ets>stead</ets> a frame.]</ety> <def>A framework for supporting a
bed.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bed steps</ent><br/
<hw>Bed" steps`</hw> <pr>(<?/)</pr>. <def>Steps for mounting a bed of
unusual height.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bedstock</ent><br/
<hw>Bed"stock</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>The front or the
back part of the frame of a bedstead.</def> <mark>[Obs. or Dial.
Eng.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bedstraw</ent><br/
<hw>Bed"straw`</hw> <pr>(<?/)</pr>, <pos>n.</pos> <sn>1.</sn> <def>Straw
put into a bed.</def> <rj><au>Bacon.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Bot.)</fld> <def>A genus of slender herbs, usually
with square stems, whorled leaves, and small white flowers.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Our Lady's bedstraw</b></col>, <cd>which has yellow
flowers, is <spn>Galium verum</spn>.</cd> -- <col><b>White
bedstraw</b></col> <cd>is <spn>Galium mollugo</spn>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bedswerver</ent><br/
<hw>Bed"swerv`er</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>One who swerves
from and is unfaithful to the marriage vow.</def> <mark>[Poetic]</mark>
<rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bedtick</ent><br/
<hw>Bed"tick`</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>A tick or bag made
of cloth, used for inclosing the materials of a bed.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bedtime</ent><br/
<hw>Bed"time`</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>The time to go to
bed.</def> <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beduck</ent><br/
<hw>Be*duck"</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. &
p. p.</pos> <conjf>Beducked</conjf> <pr>(<?/)</pr>.]</vmorph> <def>To
duck; to put the head under water; to immerse.</def> <ldquo/Deep himself
<xex>beducked</xex>.<rdquo/ <rj><au>Spenser.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beduin</ent><br/
<hw>Bed"uin</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>See
<er>Bedouin</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bedung</ent><br/
<hw>Be*dung"</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. &
p. p.</pos> <conjf>Bedunged</conjf> <pr>(<?/)</pr>.]</vmorph> <def>To
cover with dung, as for manuring; to bedaub or defile, literally or
figuratively.</def> <rj><au>Bp. Hall.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bedust</ent><br/
<hw>Be*dust"</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <def>To sprinkle,
soil, or cover with dust.</def> <rj><au>Sherwood.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bedward</ent><br/
<hw>Bed"ward</hw> <pr>(<?/)</pr>, <pos>adv.</pos> <def>Towards
bed.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bedwarf</ent><br/
<hw>Be*dwarf"</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. &
p. p.</pos> <conjf>Bedwarfed</conjf> <pr>(<?/)</pr>.]</vmorph> <def>To
make a dwarf of; to stunt or hinder the growth of; to dwarf.</def>
<rj><au>Donne.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bedye</ent><br/
<hw>Be*dye"</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. &
p. p.</pos> <conjf>Bedyed</conjf> <pr>(<?/)</pr>; <pos>p. pr. & vb.
n.</pos> <conjf>Bedyeing</conjf>.]</vmorph> <def>To dye or
stain.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Briton fields with Sarazin blood <qex>bedyed</qex>.</q>
<rj><qau>Spenser.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bee</ent><br/
<hw>Bee</hw> <pr>(<?/)</pr>, <def><pos>p. p.</pos> of <er>Be</er>; --
used for <xex>been</xex>.</def> <mark>[Obs.]</mark>
<rj><au>Spenser.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bee</ent><br/
<hw>Bee</hw> <pr>(b<emac/)</pr>, <pos>n.</pos> <ety>[AS.
<ets>be<oacute/</ets>; akin to D. <ets>bij</ets> and <ets>bije</ets>,
Icel. <ets>b<ymac/</ets>, Sw. & Dan. <ets>bi</ets>, OHG.
<ets>pini</ets>, G. <ets>biene</ets>, and perh. Ir. <ets>beach</ets>,
Lith. <ets>bitis</ets>, Skr. <ets>bha</ets>. <root/97.]</ety>
<sn>1.</sn> <fld>(Zool.)</fld> <def>An insect of the order
<ord>Hymenoptera</ord>, and family <fam>Apid<ae/</fam> (the honeybees),
or family <fam>Andrenid<ae/</fam> (the solitary bees.) See
<er>Honeybee</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ There are many genera and species. The common honeybee
(<spn>Apis mellifica</spn>) lives in swarms, each of which has its own
queen, its males or drones, and its very numerous workers, which are
barren females. Besides the <spn>Apis mellifica</spn> there are other
species and varieties of honeybees, as the <spn>Apis ligustica</spn> of
Spain and Italy; the <spn>Apis Indica</spn> of India; the <spn>Apis
fasciata</spn> of Egypt. The <stype>bumblebee</stype> is a species of
<gen>Bombus</gen>. The tropical honeybees belong mostly to
<gen>Melipoma</gen> and <gen>Trigona</gen>.</note><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A neighborly gathering of people who engage in
united labor for the benefit of an individual or family; <as>as, a
quilting <ex>bee</ex>; a husking <ex>bee</ex>; a raising
<ex>bee</ex></as>.</def> <mark>[U. S.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>The cellar . . . was dug by a <qex>bee</qex> in a single day.</q>
<rj><qau>S. G. Goodrich.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <pluf>pl.</pluf> <ety>[Prob. fr. AS.
<ets>be<aacute/h</ets> ring, fr. <ets>b<?/gan</ets> to bend. See 1st
<er>Bow</er>.]</ety> <fld>(Naut.)</fld> <def>Pieces of hard wood bolted
to the sides of the bowsprit, to reeve the fore-topmast stays through;
-- called also <altname>bee blocks</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Bee beetle</b></col> <fld>(Zool.)</fld>, <cd>a beetle
(<spn>Trichodes apiarius</spn>) parasitic in beehives.</cd> --
<col><b>Bee bird</b></col> <fld>(Zool.)</fld>, <cd>a bird that eats the
honeybee, as the European flycatcher, and the American kingbird.</cd> --
<col><b>Bee flower</b></col> <fld>(Bot.)</fld>, <cd>an orchidaceous
plant of the genus <gen>Ophrys</gen> (<spn>Ophrys apifera</spn>), whose
flowers have some resemblance to bees, flies, and other insects.</cd> --
<col><b>Bee fly</b></col> <fld>(Zool.)</fld>, <cd>a two winged fly of
the family <fam>Bombyliid<ae/</fam>. Some species, in the larval state,
are parasitic upon bees.</cd> -- <col><b>Bee garden</b></col>, <cd>a
garden or inclosure to set beehives in ; an apiary.</cd>
<au>Mortimer.</au> -- <col><b>Bee glue</b></col>, <cd>a soft, unctuous
matter, with which bees cement the combs to the hives, and close up the
cells; -- called also <altname>propolis</altname>.</cd> -- <col><b>Bee
hawk</b></col> <fld>(Zool.)</fld>, <cd>the honey buzzard.</cd> --
<col><b>Bee killer</b></col> <fld>(Zool.)</fld>, <cd>a large two-winged
fly of the family <fam>Asilid<ae/</fam> (esp. <spn>Trupanea
apivora</spn>) which feeds upon the honeybee. See <er>Robber
fly</er>.</cd> -- <col><b>Bee louse</b></col> <fld>(Zool.)</fld>, <cd>a
minute, wingless, dipterous insect (<spn>Braula c<ae/ca</spn>) parasitic
on hive bees.</cd> -- <col><b>Bee martin</b></col> <fld>(Zool.)</fld>,
<cd>the kingbird (<spn>Tyrannus Carolinensis</spn>) which occasionally
feeds on bees.</cd> -- <col><b>Bee moth</b></col> <fld>(Zool.)</fld>,
<cd>a moth (<spn>Galleria cereana</spn>) whose larv<ae/ feed on
honeycomb, occasioning great damage in beehives.</cd> -- <col><b>Bee
wolf</b></col> <fld>(Zool.)</fld>, <cd>the larva of the bee beetle. See
Illust. of <cref>Bee beetle</cref>.</cd> -- <mcol><col><b>To have a bee
in the head</b></col> <it>or</it> <col><b>To have a bee in the
bonnet</b></col></mcol>. <sd>(a)</sd> <cd>To be choleric.</cd>
<mark>[Obs.]</mark> <sd>(b)</sd> <cd>To be restless or uneasy.</cd>
<au>B. Jonson.</au> <sd>(c)</sd> <cd>To be full of fancies; to be a
little crazy.</cd> <ldquo/She's whiles crack-brained, and <xex>has a bee
in her head</xex>.<rdquo/ <au>Sir W. Scott.</au></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>bee balm</ent><br/
<ent>beebalm</ent><br/
<mhw><hw>beebalm</hw>, <hw>bee balm</hw></mhw> <pos>n.</pos> <sn>1.</sn>
<def>a perennial herb (<spn>Monarda fistulosa</spn>) of North
America.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><sn>2.</sn> <def>a perennial aromatic herb of eastern North America
(<spn>Monarda didyma</spn>) having variously colored tubular flowers in
dense showy heads.</def><br/
<syn><b>Syn. --</b> bee balm, bergamot mint, oswego tea.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><sn>3.</sn> <def>a bushy perennial Old World mint, <spn>Melissa
officinalis</spn>, having small white or yellowish flowers and fragrant
lemon-flavored leaves; a garden escapee in northern Europe and North
America.</def><br/
<syn><b>Syn. --</b> lemon balm, garden balm, sweet balm, bee balm,
Melissa officinalis.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Beebread</ent><br/
<hw>Bee"bread`</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>A brown, bitter
substance found in some of the cells of honeycomb. It is made chiefly
from the pollen of flowers, which is collected by bees as food for their
young.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beech</ent><br/
<hw>Beech</hw> <pr>(<?/)</pr>, <pos>n.</pos>; <plu><it>pl.</it>
<plw>Beeches</plw> <pr>(<?/)</pr>.</plu> <ety>[OE. <ets>beche</ets>, AS.
<ets>b<emac/ce</ets>; akin to D. <ets>beuk</ets>, OHG.
<ets>buocha</ets>, G. <ets>buche</ets>, Icel. <ets>beyki</ets>, Dan.
<ets>b<oum/g</ets>, Sw. <ets>bok</ets>, Russ. <ets>buk</ets>, L.
<ets>fagus</ets>, Gr. <ets><?/</ets> oak, <ets><?/</ets> to eat, Skr.
<ets>bhaksh</ets>; the tree being named originally from the esculent
fruit. See <er>Book</er>, and cf. 7th <er>Buck</er>,
<er>Buckwheat</er>.]</ety> <fld>(Bot.)</fld> <def>A tree of the genus
<gen>Fagus</gen>.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ It grows to a large size, having a smooth bark and thick
foliage, and bears an edible triangular nut, of which swine are fond.
The <spn>Fagus sylvatica</spn> is the European species, and the
<spn>Fagus ferruginea</spn> that of America.</note><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Beech drops</b></col> <fld>(Bot.)</fld>, <cd>a parasitic
plant which grows on the roots of beeches (<spn>Epiphegus
Americana</spn>).</cd> -- <col><b>Beech marten</b></col>
<fld>(Zool.)</fld>, <cd>the stone marten of Europe (<spn>Mustela
foina</spn>).</cd> -- <col><b>Beech mast</b></col>, <cd>the nuts of the
beech, esp. as they lie under the trees, in autumn.</cd> --
<col><b>Beech oil</b></col>, <cd>oil expressed from the mast or nuts of
the beech tree.</cd> -- <col><b>Cooper beech</b></col>, <cd>a variety of
the European beech with copper-colored, shining leaves.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beechen</ent><br/
<hw>Beech"en</hw> <pr>(<?/)</pr>, <pos>a.</pos> <ety>[AS.
<ets>b<emac/cen</ets>.]</ety> <def>Consisting, or made, of the wood or
bark of the beech; belonging to the beech.</def> <ldquo/Plain
<xex>beechen</xex> vessels.<rdquo/ <rj><au>Dryden.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beechnut</ent><br/
<hw>Beech"nut`</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>The nut of the
beech tree.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beech tree</ent><br/
<hw>Beech" tree`</hw> <pr>(<?/)</pr>. <def>The beech.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beechy</ent><br/
<hw>Beech"y</hw> <pr>(<?/)</pr>, <pos>a.</pos> <def>Of or relating to
beeches.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bee-eater</ent><br/
<hw>Bee"-eat`er</hw> <pr>(<?/)</pr>, <pos>n.</pos> <fld>(Zool.)</fld>
<sd>(a)</sd> <def>A bird of the genus <gen>Merops</gen>, that feeds
especially on bees. The European species (<spn>Merops apiaster</spn>) is
remarkable for its brilliant colors.</def> <sd>(b)</sd> <def>An African
bird of the genus <gen>Rhinopomastes</gen>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beef</ent><br/
<hw>Beef</hw> <pr>(b<emac/f)</pr>, <pos>n.</pos> <ety>[OE.
<ets>boef</ets>, <ets>befe</ets>, <ets>beef</ets>, OF. <ets>boef</ets>,
<ets>buef</ets>, F. <ets>b<oe/ef</ets>, fr. L. <ets>bos</ets>,
<ets>bovis</ets>, ox; akin to Gr. <grk>boy^s</grk>, Skr.
<ets>g<omac/</ets> cow, and E. <ets>cow</ets>. See 2d
<er>Cow</er>.]</ety> <sn>1.</sn> <def>An animal of the genus
<gen>Bos</gen>, especially the common species, <spn>Bos taurus</spn>,
including the bull, cow, and ox, in their full grown state; esp., an ox
or cow fattened for food.</def> <note>[In this, which is the original
sense, the word has a plural, <xex>beeves</xex>
<pr>(b<emac/vz)</pr>.]</note><br/
[<source>1913 Webster</source>]</p>

<p><q>A herd of <qex>beeves</qex>, fair oxen and fair kine.</q>
<rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The flesh of an ox, or cow, or of any adult bovine
animal, when slaughtered for food.</def> <note>[In this sense, the word
has no plural.]</note> <ldquo/Great meals of <xex>beef</xex>.<rdquo/
<rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Applied colloquially to human flesh.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beef</ent><br/
<hw>Beef</hw> <pr>(b<emac/f)</pr>, <pos>a.</pos> <def>Of, pertaining to,
or resembling, beef.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Beef tea</b></col>, <cd>essence of beef, or strong beef
broth.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>beefalo</ent><br/
<hw>beef"a*lo</hw> <pr>(b<emac/"f<adot/*l<osl/)</pr>, <pos>n.</pos>
<def>a hardy breed of beef cattle derived as a cross between the
American bison and domestic cattle, usually being genetically <frac38/
bison and <frac58/ domestic bovine; -- it yields leaner beef than
conventional breeds.</def><br/
[<source>WordNet 1.5</source> <source>+PJC</source>]</p>

<p><ent>beefburger</ent><br/
<hw>beef"burg*er</hw> <pos>n.</pos> <def>a fried cake of minced beef
served on a bun.</def><br/
<syn><b>Syn. --</b> hamburger.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Beefeater</ent><br/
<hw>Beef"eat`er</hw> <pr>(b<emac/f"<emac/t`<etil/r)</pr>, <pos>n.</pos>
<ety>[<ets>Beef</ets> + <ets>eater</ets>; prob. one who eats another's
<ets>beef</ets>, as his servant. Cf. AS. <ets>hl<amac/f<aemac/ta</ets>
servant, properly a loaf eater.]</ety> <sn>1.</sn> <def>One who eats
beef; hence, a large, fleshy person.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>One of the yeomen of the guard, in
England.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Zool.)</fld> <def>An African bird of the genus
<gen>Buphaga</gen>, which feeds on the larv<ae/ of botflies hatched
under the skin of oxen, antelopes, etc. Two species are known.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>beefed-up</ent><br/
<hw>beefed-up</hw> <pos>adj.</pos> <def>made greater or stronger.</def>
<illu><ex>beefed-up</ex> sales efforts</illu><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>bee fly</ent><br/
<hw>bee" fly`</hw> <pr>(b<emac/" fl<imac/`)</pr>, <pos>n.</pos> <def>any
dipterous insect of the family <fam>Bombyliidae</fam>, which eat nectar
and in some cases resemble bees. Their larvae are parasitic on the
larvae of bees and other insects.</def><br/
[<source>WordNet 1.5</source> + <source>PJC</source>]</p>

<p><ent>Beefsteak</ent><br/
<hw>Beef"steak`</hw> <pr>(b<emac/f"st<amac/k)</pr>, <pos>n.</pos> <def>A
steak of beef; a slice of beef broiled or suitable for
broiling.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beef-witted</ent><br/
<hw>Beef"-wit`ted</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>Stupid;
dull.</def> <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beefwood</ent><br/
<hw>Beef"wood`</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>An Australian
tree (<gen>Casuarina</gen>), and its red wood, used for cabinetwork;
also, the trees <spn>Stenocarpus salignus</spn> of New South Wales, and
<spn>Banksia compar</spn> of Queensland.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beefy</ent><br/
<hw>Beef"y</hw>, <pos>a.</pos> <def>Having much beef; of the nature of
beef; resembling beef; fleshy.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beehive</ent><br/
<hw>Bee"hive`</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>A hive for a swarm
of bees. Also used figuratively.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ A common and typical form of <xex>beehive</xex> was a
domeshaped inverted basket, whence certain ancient Irish and Scotch
architectural remains are called <xex>beehive houses</xex>.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beehouse</ent><br/
<hw>Bee"house`</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>A house for bees;
an apiary.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bee larkspur</ent><br/
<hw>Bee" lark`spur</hw> <pr>(<?/)</pr>. <def><fld>(Bot.)</fld> See
<er>Larkspur</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beeld</ent><br/
<hw>Beeld</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>Same as
<er>Beild</er>.</def> <rj><au>Fairfax.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bee line</ent><br/
<hw>Bee" line`</hw> <pr>(<?/)</pr>. <def>The shortest line from one
place to another, like that of a bee to its hive when loaded with honey;
an air line.</def> <ldquo/A <xex>bee line</xex> for the brig.<rdquo/
<rj><au>Kane.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beelzebub</ent><br/
<hw>Be*el"ze*bub</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>The title of a
heathen deity to whom the Jews ascribed the sovereignty of the evil
spirits; hence, the Devil or a devil. See <er>Baal</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beem</ent><br/
<hw>Beem</hw> <pr>(b<emac/m)</pr>, <pos>n.</pos> <ety>[AS.
<ets>b<emac/me</ets>, <ets>b<ymac/me</ets>.]</ety> <def>A trumpet.</def>
<mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beemaster</ent><br/
<hw>Bee"mas`ter</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>One who keeps
bees.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Been</ent><br/
<hw>Been</hw> <pr>(<?/)</pr>. <ety>[OE. <ets>beon</ets>, <ets>ben</ets>,
<ets>bin</ets>, p. p. of <ets>been</ets>, <ets>beon</ets>, to be. See
<er>Be</er>.]</ety> <def>The past participle of <er>Be</er>. In old
authors it is also the pr. tense plural of <er>Be</er>. See 1st
<er>Bee</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Assembled <qex>been</qex> a senate grave and stout.</q>
<rj><qau>Fairfax.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beer</ent><br/
<hw>Beer</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[OE. <ets>beor</ets>,
<ets>ber</ets>, AS. <ets>be<oacute/r</ets>; akin to Fries.
<ets>biar</ets>, Icel. <ets>bj<oacute/rr</ets>, OHG. <ets>bior</ets>, D.
& G. <ets>bier</ets>, and possibly E. <ets>brew</ets>. <root/93, See
<er>Brew</er>.]</ety> <sn>1.</sn> <def>A fermented liquor made from any
malted grain, but commonly from barley malt, with hops or some other
substance to impart a bitter flavor.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ Beer has different names, as <stype>small beer</stype>,
<stype>ale</stype>, <stype>porter</stype>, <stype>brown stout</stype>,
<stype>lager beer</stype>, according to its strength, or other
qualities. See <er>Ale</er>.</note><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A fermented extract of the roots and other parts of
various plants, as spruce, ginger, sassafras, etc.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Small beer</b></col>, <cd>weak beer</cd>;
(<mark>fig.</mark>) <cd>insignificant matters.</cd> <ldquo/To suckle
fools, and chronicle <xex>small beer</xex>.<rdquo/
<rj><au>Shak.</au></rj></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>beer belly</ent><br/
<hw>beer" bel`ly</hw> <pos>n.</pos> <def>a protruding potbelly caused by
excessive drinking of beer.</def><br/
<syn><b>Syn. --</b> beer gut.</syn><br/
[<source>PJC</source>]</p>

<p><q>In one of the less surprising revelations of the year, researchers
at the University of North Carolina (UNC) and colleagues have confirmed
that excessive consumption of beer can lead to the condition commonly
known as <qex>beer belly</qex>. At the same time, however, they
discovered that, beyond aesthetic concerns, the condition may point to
health hazards of a more serious nature. In a comparison of beer
drinkers and wine drinkers, the scientists found that beer tends to
build a central paunch, or <ldquo/potbelly<rdquo/, while wine drinkers
tend to have narrower waists, even when the same amount of alcohol and
calories is consumed by both.</q> <rj><qau>The Scientist -- December 11,
1995.</qau></rj></p>

<p><ent>Beeregar</ent><br/
<hw>Beer"e*gar</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[<ets>Beer</ets>
+ <ets>eager</ets>.]</ety> <def>Sour beer.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>beer gut</ent><br/
<hw>beer gut</hw> <pos>n.</pos> <def>same as <er>beer
belly</er>.</def><br/
<syn><b>Syn. --</b> beer gut.</syn><br/
[<source>PJC</source>]</p>

<p><ent>Beerhouse</ent><br/
<hw>Beer"house`</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>A house where
malt liquors are sold; an alehouse.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beeriness</ent><br/
<hw>Beer"i*ness</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>Beery
condition.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beery</ent><br/
<hw>Beer"y</hw> <pr>(<?/)</pr>, <pos>a.</pos> <def>Of or resembling
beer; affected by beer; maudlin.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beestings</ent><br/
<hw>Beest"ings</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>Same as
<er>Biestings</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beeswax</ent><br/
<hw>Bees"wax`</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>The wax secreted
by bees, and of which their cells are constructed.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beeswing</ent><br/
<hw>Bees"wing`</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>The second crust
formed in port and some other wines after long keeping. It consists of
pure, shining scales of tartar, supposed to resemble the wing of a
bee.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beet</ent><br/
<hw>Beet</hw> <pr>(b<emac/t)</pr>, <pos>n.</pos> <ety>[AS.
<ets>bete</ets>, from L. <ets>beta</ets>.]</ety> <sn>1.</sn>
<fld>(Bot.)</fld> <def>A biennial plant of the genus <gen>Beta</gen>,
which produces an edible root the first year and seed the second
year.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The root of plants of the genus <gen>Beta</gen>,
different species and varieties of which are used for the table, for
feeding stock, or in making sugar.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ There are many varieties of the common beet (<spn>Beta
vulgaris</spn>). The Old <ldquo/white beet<rdquo/, cultivated for its
edible leafstalks, is a distinct species (<spn>Beta
Cicla</spn>).</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bete</ent><br/
<ent>Beete</ent><br/
<mhw>{ <hw>Beete</hw>, <hw>Bete</hw> }</mhw> <pr>(b<emac/t)</pr>,
<pos>v. t.</pos> <ety>[AS. <ets>b<emac/tan</ets> to mend. See
<er>Better</er>.]</ety> <sn>1.</sn> <def>To mend; to repair.</def>
<mark>[Obs.]</mark> <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To renew or enkindle (a fire).</def>
<mark>[Obs.]</mark> <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beethoven</ent><br/
<hw>Beethoven</hw> <pos>n.</pos> <sn>1.</sn> <def><person>Ludwig van
Beethoven</person>, a renowned German composer, born 1770, died
1827.</def><br/
<syn><b>Syn. --</b> van Beethoven.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><sn>2.</sn> <def>the music of Beethoven.</def> <illu>He enjoyed
<ex>Beethoven</ex> most of all.</illu><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Beethovenian</ent><br/
<hw>Beethovenian</hw> <pos>adj.</pos> <def>of or pertaining to
<person>Ludwig van Beethoven</person>.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Beetle</ent><br/
<hw>Bee"tle</hw> <pr>(b<emac/"t'l)</pr>, <pos>n.</pos> <ety>[OE.
<ets>betel</ets>, AS. <ets>b<imac/tl</ets>, mallet, hammer, fr.
<ets>be<aacute/tan</ets> to beat. See <er>Beat</er>, <pos>v.
t.</pos>]</ety> <sn>1.</sn> <def>A heavy mallet, used to drive wedges,
beat pavements, etc.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A machine in which fabrics are subjected to a
hammering process while passing over rollers, as in cotton mills; --
called also <altname>beetling machine</altname>.</def>
<rj><au>Knight.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 132 --></p>

<p><ent>Beetle</ent><br/
<hw>Bee"tle</hw> <pr>(b<emac/"t'l)</pr>, <pos>v. t.</pos>
<vmorph>[<pos>imp. & p. p.</pos> <conjf>Beetled</conjf>
<pr>(-t'ld)</pr>; <pos>p. pr. & vb. n.</pos>
<conjf>Beetling</conjf>.]</vmorph> <sn>1.</sn> <def>To beat with a heavy
mallet.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To finish by subjecting to a hammering process in a
beetle or beetling machine; <as>as, to <ex>beetle</ex> cotton
goods</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beetle</ent><br/
<hw>Bee"tle</hw>, <pos>n.</pos> <ety>[OE. <ets>bityl</ets>,
<ets>bittle</ets>, AS. <ets>b<imac/tel</ets>, fr. <ets>b<imac/tan</ets>
to bite. See <er>Bite</er>, <pos>v. t.</pos>]</ety> <def>Any insect of
the order Coleoptera, having four wings, the outer pair being stiff
cases for covering the others when they are folded up. See
<er>Coleoptera</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Beetle mite</b></col> <fld>(Zool.)</fld>, <cd>one of many
species of mites, of the family <fam>Oribatid<ae/</fam>, parasitic on
beetles.</cd> -- <col><b>Black beetle</b></col>, <cd>the common large
black cockroach (<spn>Blatta orientalis</spn>).</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beetle</ent><br/
<hw>Bee"tle</hw>, <pos>v. i.</pos> <ety>[See
<er>Beetlebrowed</er>.]</ety> <def>To extend over and beyond the base or
support; to overhang; to jut.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>To the dreadful summit of the cliff<br/
That <qex>beetles</qex> o'er his base into the sea.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Each <qex>beetling</qex> rampart, and each tower sublime.</q>
<rj><qau>Wordsworth.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beetle brow</ent><br/
<hw>Bee"tle brow`</hw> <pr>(<?/)</pr>. <def>An overhanging
brow.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beetle-browed</ent><br/
<hw>Bee"tle-browed`</hw> <pr>(<?/)</pr>, a. <ety>[OE.
<ets>bitelbrowed</ets>; cf. OE. <ets>bitel</ets>, adj., sharp,
projecting, n., a beetle. See <er>Beetle</er> an insect.]</ety>
<def>Having prominent, overhanging brows; hence, lowering or
sullen.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ The earlier meaning was, <ldquo/Having bushy or
overhanging eyebrows.<rdquo/</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beetlehead</ent><br/
<hw>Bee"tle*head`</hw> <pr>(<?/)</pr>, <pos>n.</pos>
<ety>[<ets>Beetle</ets> a mallet + <ets>head</ets>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>A stupid fellow; a blockhead.</def> <rj><au>Sir W.
Scott.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Zool.)</fld> <def>The black-bellied plover, or
bullhead (<spn>Squatarola helvetica</spn>). See
<er>Plover</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beetle-headed</ent><br/
<hw>Bee"tle-head`ed</hw> <pr>(<?/)</pr>, <pos>a.</pos> <def>Dull;
stupid.</def> <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beetlestock</ent><br/
<hw>Bee"tle*stock`</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>The handle of
a beetle.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beet radish</ent><br/
<hw>Beet" rad`ish</hw> <pr>(<?/)</pr>. <def>Same as
<er>Beetrave</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beetrave</ent><br/
<hw>Beet"rave`</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[F.
<ets>betterave</ets>; <ets>bette</ets> beet + <ets>rave</ets>
radish.]</ety> <def>The common beet (<spn>Beta
vulgaris</spn>).</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beeve</ent><br/
<hw>Beeve</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[Formed from
<ets>beeves</ets>, pl. of <ets>beef</ets>.]</ety> <def>A beef; a beef
creature.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>They would knock down the first <qex>beeve</qex> they met
with.</q> <rj><qau>W. Irving.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beeves</ent><br/
<hw>Beeves</hw> <pr>(b<emac/vz)</pr>, <pos>n.</pos> <def>plural of
<er>Beef</er>, the animal.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Befall</ent><br/
<hw>Be*fall"</hw> <pr>(<?/)</pr>, <pos>v. t.</pos>
<vmorph>[<pos>imp.</pos> <conjf>Befell</conjf> <pr>(<?/)</pr>; <pos>p.
p.</pos> <conjf>Befallen</conjf> <pr>(<?/)</pr>; <pos>p. pr. & vb.
n.</pos> <conjf>Befalling</conjf>.]</vmorph> <ety>[AS.
<ets>befeallan</ets>; pref. <ets>be-</ets> + <ets>feallan</ets> to
fall.]</ety> <def>To happen to.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>I beseech your grace that I may know<br/
The worst that may <qex>befall</qex> me.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Befall</ent><br/
<hw>Be*fall"</hw>, <pos>v. i.</pos> <def>To come to pass; to
happen.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>I have revealed . . . the discord which <qex>befell</qex>.</q>
<rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Befit</ent><br/
<hw>Be*fit"</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. &
p. p.</pos> <conjf>Befitted</conjf>; <pos>p. pr. & vb. n.</pos>
<conjf>Befitting</conjf>.]</vmorph> <def>To be suitable to; to suit; to
become.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>That name best <qex>befits</qex> thee.</q>
<rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Befitting</ent><br/
<hw>Be*fit"ting</hw>, <pos>a.</pos> <def>Suitable; proper; becoming;
fitting.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Befittingly</ent><br/
<hw>Be*fit"ting*ly</hw>, <pos>adv.</pos> <def>In a befitting manner;
suitably.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beflatter</ent><br/
<hw>Be*flat"ter</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <def>To flatter
excessively.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beflower</ent><br/
<hw>Be*flow"er</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <def>To besprinkle
or scatter over with, or as with, flowers.</def>
<rj><au>Hobbes.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Befog</ent><br/
<hw>Be*fog"</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. &
p. p.</pos> <conjf>Befogged</conjf> <pr>(<?/)</pr>; <pos>p. pr. & vb.
n.</pos> <conjf>Befogging</conjf> <pr>(<?/)</pr>.]</vmorph> <sn>1.</sn>
<def>To involve in a fog; -- mostly as a participle or part.
adj.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Hence: To confuse; to mystify.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>befogged</ent><br/
<hw>befogged</hw> <pos>adj.</pos> <def>confused and vague; used
especially of thinking.</def> <illu>a mind <ex>befogged</ex> with
drink</illu><br/
<syn><b>Syn. --</b> addled, befuddled, muddled, muzzy, unclear, woolly,
wooly, woolly-headed, wooly-minded.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Befool</ent><br/
<hw>Be*fool"</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. &
p. p.</pos> <conjf>Befooled</conjf> <pr>(<?/)</pr>; <pos>p. pr. & vb.
n.</pos> <conjf>Befooling</conjf>.]</vmorph> <ety>[OE.
<ets>befolen</ets>; pref. <ets>be-</ets> + <ets>fol</ets> fool.]</ety>
<sn>1.</sn> <def>To fool; to delude or lead into error; to infatuate; to
deceive.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>This story . . . contrived to <qex>befool</qex> credulous men.</q>
<rj><qau>Fuller.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To cause to behave like a fool; to make
foolish.</def> <ldquo/Some <xex>befooling</xex> drug.<rdquo/ <rj><au>G.
Eliot.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Before</ent><br/
<hw>Be*fore"</hw> <pr>(<?/)</pr>, <pos>prep.</pos> <ety>[OE.
<ets>beforen</ets>, <ets>biforen</ets>, <ets>before</ets>, AS.
<ets>beforan</ets>; pref. <ets>be-</ets> + <ets>foran</ets>,
<ets>fore</ets>, before. See <er>Be-</er>, and <er>Fore</er>.]</ety>
<sn>1.</sn> <def>In front of; preceding in space; ahead of; <as>as, to
stand <ex>before</ex> the fire; <ex>before</ex> the
house</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>His angel, who shall go<br/
<qex>Before</qex> them in a cloud and pillar of fire.</q>
<rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Preceding in time; earlier than; previously to;
anterior to the time when; -- sometimes with the additional idea of
purpose; in order that.</def><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>Before</qex> Abraham was, I am.</q> <rj><qau>John viii.
58.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>Before</qex> this treatise can become of use, two points are
necessary.</q> <rj><qau>Swift.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ Formerly <xex>before</xex>, in this sense, was followed
by <xex>that</xex>. <ldquo/<xex>Before that</xex> Philip called thee . .
. I saw thee.<rdquo/</note> <rj><au>John i. 48.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>An advance of; farther onward, in place or
time.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The golden age . . . is <qex>before</qex> us.</q>
<rj><qau>Carlyle.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>Prior or preceding in dignity, order, rank, right,
or worth; rather than.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>He that cometh after me is preferred <qex>before</qex> me.</q>
<rj><qau>John i. 15.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The eldest son is <qex>before</qex> the younger in succession.</q>
<rj><qau>Johnson.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>In presence or sight of; face to face with;
facing.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Abraham bowed down himself <qex>before</qex> the people.</q>
<rj><qau>Gen. xxiii. 12.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Wherewith shall I come <qex>before</qex> the Lord?</q>
<rj><qau>Micah vi. 6.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <def>Under the cognizance or jurisdiction of.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>If a suit be begun <qex>before</qex> an archdeacon.</q>
<rj><qau>Ayliffe.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>7.</sn> <def>Open for; free of access to; in the power
of.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The world was all <qex>before</qex> them where to choose.</q>
<rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Before the mast</b></col> <fld>(Naut.)</fld>, <cd>as a
common sailor, -- because the sailors live in the forecastle, forward of
the foremast.</cd> -- <col><b>Before the wind</b></col>
<fld>(Naut.)</fld>, <cd>in the direction of the wind and by its impulse;
having the wind aft.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Before</ent><br/
<hw>Be*fore"</hw>, <pos>adv.</pos> <sn>1.</sn> <def>On the fore part; in
front, or in the direction of the front; -- opposed to <ant>in the
rear</ant>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The battle was <qex>before</qex> and behind.</q> <rj><qau>2 Chron.
xiii. 14.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>In advance.</def> <ldquo/I come <xex>before</xex> to
tell you.<rdquo/ <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>In time past; previously; already.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>You tell me, mother, what I knew <qex>before</qex>.</q>
<rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>Earlier; sooner than; until then.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>When the butt is out, we will drink water; not a drop
<qex>before</qex>.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ <xex>Before</xex> is often used in self-explaining
compounds; as, <xex>before</xex>-cited, <xex>before</xex>-mentioned;
<xex>before</xex>said.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beforehand</ent><br/
<hw>Be*fore"hand`</hw> <pr>(<?/)</pr>, <pos>adv.</pos>
<ety>[<ets>Before</ets> + <ets>hand</ets>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>In a state of anticipation ore preoccupation; in
advance; -- often followed by <xex>with</xex>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Agricola . . . resolves to be <qex>beforehand</qex> with the
danger.</q> <rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The last cited author has been <qex>beforehand</qex> with me.</q>
<rj><qau>Addison.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>By way of preparation, or preliminary; previously;
aforetime.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>They may be taught <qex>beforehand</qex> the skill of
speaking.</q> <rj><qau>Hooker.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beforehand</ent><br/
<hw>Be*fore"hand`</hw>, <pos>a.</pos> <def>In comfortable circumstances
as regards property; forehanded.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Rich and much <qex>beforehand</qex>.</q>
<rj><qau>Bacon.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beforetime</ent><br/
<hw>Be*fore"time`</hw> <pr>(<?/)</pr>, <pos>adv.</pos> <def>Formerly;
aforetime.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>[They] dwelt in their tents, as <qex>beforetime</qex>.</q>
<rj><qau>2 Kings xiii. 5.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Befortune</ent><br/
<hw>Be*for"tune</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <def>To
befall.</def> <mark>[Poetic]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>I wish all good <qex>befortune</qex> you.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Befoul</ent><br/
<hw>Be*foul"</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. &
p. p.</pos> <conjf>Befouled</conjf> <pr>(<?/)</pr>; <pos>p. pr. & vb.
n.</pos> <conjf>Befouling</conjf>.]</vmorph> <ety>[Cf. AS.
<ets>bef<umac/lan</ets>; pref. <ets>be-</ets> + <ets>f<umac/lan</ets> to
foul. See <er>Foul</er>, <pos>a.</pos>]</ety> <sn>1.</sn> <def>To make
foul; to soil.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To entangle or run against so as to impede
motion.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>befouled</ent><br/
<hw>befouled</hw> <pos>adj.</pos> <def>made disgustingly dirty.</def>
<illu>a building <ex>befouled</ex> with soot</illu><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Befriend</ent><br/
<hw>Be*friend"</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp.
& p. p.</pos> <conjf>Befriended</conjf>; <pos>p. pr. & vb. n.</pos>
<conjf>Befriending</conjf>.]</vmorph> <def>To act as a friend to; to
favor; to aid, benefit, or countenance.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>By the darkness <qex>befriended</qex>.</q>
<rj><qau>Longfellow.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Befriendment</ent><br/
<hw>Be*friend"ment</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>Act of
befriending.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Befrill</ent><br/
<hw>Be*frill"</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <def>To furnish or
deck with a frill.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Befringe</ent><br/
<hw>Be*fringe"</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <def>To furnish
with a fringe; to form a fringe upon; to adorn as with fringe.</def>
<rj><au>Fuller.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Befuddle</ent><br/
<hw>Be*fud"dle</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp.
& p. p.</pos> <conjf>Befuddled</conjf> <pr>(<?/)</pr>]</vmorph> <def>To
becloud and confuse, as with liquor.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>befuddled</ent><br/
<hw>befuddled</hw> <pos>adj.</pos> <sn>1.</sn> <def>dazed by alcoholic
drink.</def> <illu>the wino's poor <ex>befuddled</ex> mind</illu><br/
<syn><b>Syn. --</b> stupefied.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><sn>2.</sn> <def>unclear in mind or intent; filled with
bewilderment.</def><br/
<syn><b>Syn. --</b> at sea, bemused, bewildered, confounded, confused,
mazed, mixed-up.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><sn>3.</sn> <def>confused and vague; used especially of
thinking.</def><br/
<syn><b>Syn. --</b> addled, befogged, muddled, muzzy, unclear, woolly,
wooly, woolly-headed, wooly-minded.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Beg</ent><br/
<hw>Beg</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[Turk. <ets>beg</ets>,
pronounced <ets>bay</ets>. Cf. <er>Bey</er>, <er>Begum</er>.]</ety>
<def>A title of honor in Turkey and in some other parts of the East; a
bey.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beg</ent><br/
<hw>Beg</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p.
p.</pos> <conjf>Begged</conjf> <pr>(<?/)</pr>; <pos>p. pr. & vb.
n.</pos> <conjf>Begging</conjf>.]</vmorph> <ety>[OE. <ets>beggen</ets>,
perh. fr. AS. <ets>bedecian</ets> (akin to Goth. <ets>bedagwa</ets>
beggar), <ets>biddan</ets> to ask. (Cf. <er>Bid</er>, <pos>v. t.</pos>);
or cf. <ets>beghard</ets>, <ets>beguin</ets>.]</ety> <sn>1.</sn> <def>To
ask earnestly for; to entreat or supplicate for; to beseech.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>I do <qex>beg</qex> your good will in this case.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>[Joseph] <qex>begged</qex> the body of Jesus.</q> <rj><qau>Matt.
xxvii. 58.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><note>Sometimes implying deferential and respectful, rather than
earnest, asking; as, I <xex>beg</xex> your pardon; I <xex>beg</xex>
leave to disagree with you.</note><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To ask for as a charity, esp. to ask for habitually
or from house to house.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Yet have I not seen the righteous forsaken, nor his seed
<qex>begging</qex> bread.</q> <rj><qau>Ps. xxxvii. 25.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To make petition to; to entreat; <as>as, to
<ex>beg</ex> a person to grant a favor</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>To take for granted; to assume without
proof.</def><-- see <cref>beg the question</cref>, below --><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <fld>(Old Law)</fld> <def>To ask to be appointed guardian
for, or to also to have a guardian appointed for.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Else some will <qex>beg</qex> thee, in the court of wards.</q>
<rj><qau>Harrington.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs>Hence: <col><b>To beg (one) for a fool</b></col>, <cd>to take him
for a fool.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>I beg to</b></col>, <cd>is an elliptical expression for
<xex>I beg leave to</xex>; <as>as, <ex>I beg to</ex> inform
you</as>.</cd> -- <col><b>To beg the question</b></col>, <cd>to assume
that which was to be proved in a discussion, instead of adducing the
proof or sustaining the point by argument.</cd> -- <col><b>To go
a-begging</b></col>, <cd>a figurative phrase to express the absence of
demand for something which elsewhere brings a price; <as>as, grapes are
so plentiful there that they <ex>go a-begging</ex></as>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- To <er>Beg</er>, <er>Ask</er>,
<er>Request</er>.</syn> <usage> To <xex>ask</xex> (not in the sense of
inquiring) is the generic term which embraces all these words. To
<xex>request</xex> is only a polite mode of asking. To <xex>beg</xex>,
in its original sense, was to ask with earnestness, and implied
submission, or at least deference. At present, however, in polite life,
<xex>beg</xex> has dropped its original meaning, and has taken the place
of both <xex>ask</xex> and <xex>request</xex>, on the ground of its
expressing more of deference and respect. Thus, we <xex>beg</xex> a
person's acceptance of a present; we <xex>beg</xex> him to favor us with
his company; a tradesman <xex>begs</xex> to announce the arrival of new
goods, etc. Crabb remarks that, according to present usage, <ldquo/we
can never talk of <xex>asking</xex> a person's acceptance of a thing, or
of <xex>asking</xex> him to do us a favor.<rdquo/ This can be more truly
said of usage in England than in America.</usage><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beg</ent><br/
<hw>Beg</hw>, <pos>v. i.</pos> <def>To ask alms or charity, especially
to ask habitually by the wayside or from house to house; to live by
asking alms.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>I can not dig; to <qex>beg</qex> I am ashamed.</q> <rj><qau>Luke
xvi. 3.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bega</ent><br/
\'d8<hw>Be"ga</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>See
<er>Bigha</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Begem</ent><br/
<hw>Be*gem"</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. &
p. p.</pos> <conjf>Begemmed</conjf> <pr>(<?/)</pr>; <pos>p. pr. & vb.
n.</pos> <conjf>Begemming</conjf>.]</vmorph> <def>To adorn with gems, or
as with gems.</def><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>Begemmed</qex> with dewdrops.</q> <rj><qau>Sir W.
Scott.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Those lonely realms bright garden isles <qex>begem</qex>.</q>
<rj><qau>Shelley.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beget</ent><br/
<hw>Be*get"</hw> <pr>(<?/)</pr>, <pos>v. t.</pos>
<vmorph>[<pos>imp.</pos> <conjf>Begot</conjf> <pr>(<?/)</pr>,
<mark>(Archaic)</mark> <conjf>Begat</conjf> <pr>(<?/)</pr>; <pos>p.
p.</pos> <conjf>Begot</conjf>, <conjf>Begotten</conjf> <pr>(<?/)</pr>;
<pos>p. pr. & vb. n.</pos> <conjf>Begetting</conjf>.]</vmorph> <ety>[OE.
<ets>bigiten</ets>, <ets>bigeten</ets>, to get, beget, AS.
<ets>begitan</ets> to get; pref. <ets>be-</ets> + <ets>gitan</ets>. See
<er>Get</er>, <pos>v. t.</pos> ]</ety> <sn>1.</sn> <def>To procreate, as
a father or sire; to generate; -- commonly said of the father.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Yet they a beauteous offspring shall <qex>beget</qex>.</q>
<rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To get (with child.)</def> <mark>[Obs.]</mark>
<rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To produce as an effect; to cause to
exist.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Love is <qex>begot</qex> by fancy.</q>
<rj><qau>Granville.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Begetter</ent><br/
<hw>Be*get"ter</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>One who begets; a
father.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beggable</ent><br/
<hw>Beg"ga*ble</hw> <pr>(<?/)</pr>, <pos>a.</pos> <def>Capable of being
begged.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beggar</ent><br/
<hw>Beg"gar</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[OE.
<ets>beggere</ets>, fr. <ets>beg</ets>.]</ety> <sn>1.</sn> <def>One who
begs; one who asks or entreats earnestly, or with humility; a
petitioner.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>One who makes it his business to ask alms.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>One who is dependent upon others for support; -- a
contemptuous or sarcastic use.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>One who assumes in argument what he does not
prove.</def> <rj><au>Abp. Tillotson.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beggar</ent><br/
<hw>Beg"gar</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos>
<conjf>Beggared</conjf> <pr>(<?/)</pr>; <pos>p. pr. & vb. n.</pos>
<conjf>Beggaring</conjf>.]</vmorph> <sn>1.</sn> <def>To reduce to
beggary; to impoverish; <as>as, he had <ex>beggared</ex>
himself</as>.</def> <rj><au>Milton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To cause to seem very poor and inadequate.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>It <qex>beggared</qex> all description.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beggarhood</ent><br/
<hw>Beg"gar*hood</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>The condition
of being a beggar; also, the class of beggars.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beggarism</ent><br/
<hw>Beg"gar*ism</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>Beggary.</def>
<mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>beggar-lice</ent><br/
<hw>beggar-lice</hw> <pos>n.</pos> <sn>1.</sn> <def>any of various
Eurasian and North American plants having small prickly nutlets that
stick to clothing.</def><br/
<syn><b>Syn. --</b> beggar's lice, beggar's-lice, beggar lice.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><sn>2.</sn> <def>any of various tropical and subtropical plants
having trifoliate leaves and rough sticky pod sections or
loments.</def><br/
<syn><b>Syn. --</b> tick trefoil, tick-trefoil, beggar's-lice.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Beggarliness</ent><br/
<hw>Beg"gar*li*ness</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>The quality
or state of being beggarly; meanness.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beggarly</ent><br/
<hw>Beg"gar*ly</hw> <pr>(<?/)</pr>, <pos>a.</pos> <sn>1.</sn> <def>In
the condition of, or like, a beggar; suitable for a beggar; extremely
indigent; poverty-stricken; mean; poor; contemptible.</def> <ldquo/A
bankrupt, <xex>beggarly</xex> fellow.<rdquo/ <au>South.</au> <ldquo/A
<xex>beggarly</xex> fellowship.<rdquo/ <au>Swift.</au>
<ldquo/<xex>Beggarly</xex> elements.<rdquo/ <au>Gal. iv. 9.</au><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Produced or occasioned by beggary.</def>
<mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>Beggarly</qex> sins, that is, those sins which idleness and
beggary usually betray men to; such as lying, flattery, stealing, and
dissimulation.</q> <rj><qau>Jer. Taylor.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beggarly</ent><br/
<hw>Beg"gar*ly</hw>, <pos>adv.</pos> <def>In an indigent, mean, or
despicable manner; in the manner of a beggar.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beggar's lice</ent><br/
<hw>Beg"gar's lice`</hw> <pr>(<?/)</pr>. <fld>(Bot.)</fld> <def>The
prickly fruit or seed of certain plants (as some species of
<gen>Echinospermum</gen> and <gen>Cynoglossum</gen>) which cling to the
clothing of those who brush by them.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beggar's ticks</ent><br/
<hw>Beg"gar's ticks`</hw> <pr>(<?/)</pr>. <def>The bur marigold
(<gen>Bidens</gen>) and its achenes, which are armed with barbed awns,
and adhere to clothing and fleeces with unpleasant tenacity; -- also
called <altname>beggar-ticks</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>beggar-ticks</ent><br/
<hw>beggar-ticks</hw> <pos>n.</pos> <sn>1.</sn> <def>the seed of bur
marigolds.</def><br/
<syn><b>Syn. --</b> spanish needles.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><sn>2.</sn> <def>any of several plants of the genus Bidens having
yellow flowers and pricky fruits that cling to fur and clothing; -- also
called <altname>beggar's-ticks</altname>.</def><br/
<syn><b>Syn. --</b> bur marigold, burr marigold, beggar's-ticks,
sticktight.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>beggarwoman</ent><br/
<hw>beggarwoman</hw> <pos>n.</pos> <sn>1.</sn> <def>a woman who is a
beggar.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Beggary</ent><br/
<hw>Beg"gar*y</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[OE.
<ets>beggerie</ets>. See <er>Beggar</er>, <pos>n.</pos>]</ety>
<sn>1.</sn> <def>The act of begging; the state of being a beggar;
mendicancy; extreme poverty.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Beggarly appearance.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>The freedom and the <qex>beggary</qex> of the old studio.</q>
<rj><qau>Thackeray.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- Indigence; want; penury; mendicancy.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beggary</ent><br/
<hw>Beg"gar*y</hw>, <pos>a.</pos> <def>Beggarly.</def>
<mark>[Obs.]</mark> <rj><au>B. Jonson.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beggestere</ent><br/
<hw>Beg"ge*stere</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[<ets>Beg</ets>
+ <ets>-ster</ets>.]</ety> <def>A beggar.</def> <mark>[Obs.]</mark>
<rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beguard</ent><br/
<ent>Beghard</ent><br/
<mhw>{ <hw>Be*ghard"</hw> <hw>Be*guard"</hw> }</mhw> <pr>(<?/)</pr>,
<pos>n.</pos> <ety>[F. <ets>b<eacute/gard</ets>,
<ets>b<eacute/guard</ets>; cf. G. <ets>beghard</ets>, LL.
<ets>Beghardus</ets>, <ets>Begihardus</ets>, <ets>Begardus</ets>. Prob.
from the root of <ets>beguine</ets> + <ets>-ard</ets> or
<ets>-hard</ets>. See <er>Beguine</er>.]</ety> <fld>(Eccl. Hist.)</fld>
<def>One of an association of religious laymen living in imitation of
the Beguines. They arose in the thirteenth century, were afterward
subjected to much persecution, and were suppressed by Innocent X. in
1650. Called also <xex>Beguins</xex>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Begild</ent><br/
<hw>Be*gild"</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. &
p. p.</pos> <conjf>Begilded</conjf> or <conjf>Begilt</conjf>
<pr>(<?/)</pr>.]</vmorph> <def>To gild.</def> <rj><au>B.
Jonson.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Begin</ent><br/
<hw>Be*gin"</hw> <pr>(<?/)</pr>, <pos>v. i.</pos> <vmorph>[<pos>imp. &
p. p.</pos> <conjf>Began</conjf> <pr>(<?/)</pr>, <conjf>Begun</conjf>
<pr>(<?/)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Beginning</conjf>
<pr>(<?/)</pr>.]</vmorph> <ety>[AS. <ets>beginnan</ets> (akin to OS.
<ets>biginnan</ets>, D. & G. <ets>beginnen</ets>, OHG.
<ets>biginnan</ets>, Goth., <ets>du-ginnan</ets>, Sw.
<ets>begynna</ets>, Dan. <ets>begynde</ets>); pref. <ets>be-</ets> + an
assumed <ets>ginnan</ets>. <root/31. See <er>Gin</er> to begin.]</ety>
<sn>1.</sn> <def>To have or commence an independent or first existence;
to take rise; to commence.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Vast chain of being! which from God <qex>began</qex>.</q>
<rj><qau>Pope.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To do the first act or the first part of an action;
to enter upon or commence something new, as a new form or state of
being, or course of action; to take the first step; to start.</def>
<ldquo/Tears <xex>began</xex> to flow.<rdquo/
<rj><au>Dryden.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>When I <qex>begin</qex>, I will also make an end.</q> <rj><qau>1
Sam. iii. 12.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Begin</ent><br/
<hw>Be*gin"</hw>, <pos>v. t.</pos> <sn>1.</sn> <def>To enter on; to
commence.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Ye nymphs of Solyma ! <qex>begin</qex> the song.</q>
<rj><qau>Pope.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To trace or lay the foundation of; to make or place
a beginning of.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The apostle <qex>begins</qex> our knowledge in the creatures,
which leads us to the knowledge of God.</q>
<rj><qau>Locke.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- To commence; originate; set about;
start.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Begin</ent><br/
<hw>Be*gin"</hw>, <pos>n.</pos> <def>Beginning.</def> <mark>[Poetic &
Obs.]</mark> <rj><au>Spenser.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beginner</ent><br/
<hw>Be*gin"ner</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>One who begins or
originates anything. Specifically: A young or inexperienced practitioner
or student; a tyro.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>A sermon of a new <qex>beginner</qex>.</q>
<rj><qau>Swift.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beginning</ent><br/
<hw>Be*gin"ning</hw> <pr>(<?/)</pr>, <pos>n.</pos> <sn>1.</sn> <def>The
act of doing that which begins anything; commencement of an action,
state, or space of time; entrance into being or upon a course; the first
act, effort, or state of a succession of acts or states.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>In the <qex>beginning</qex> God created the heaven and the
earth.</q> <rj><qau>Gen. i. 1.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>That which begins or originates something; the first
cause; origin; source.</def><br/
[<source>1913 Webster</source>]</p>

<p><q> I am . . . the <qex>beginning</qex> and the ending.</q>
<rj><qau>Rev. i. 8.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>That which is begun; a rudiment or
element.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Mighty things from small <qex>beginnings</qex> grow.</q>
<rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>Enterprise.</def> <ldquo/To hinder our
<xex>beginnings</xex>.<rdquo/ <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- Inception; prelude; opening; threshold; origin;
outset; foundation.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Begird</ent><br/
<hw>Be*gird"</hw> <pr>(<?/)</pr>, <pos>v. t.</pos>
<vmorph>[<pos>imp.</pos> <conjf>Begirt</conjf> <pr>(<?/)</pr>,
<conjf>Begirded</conjf>; <pos>p. p.</pos> <conjf>Begirt</conjf>; <pos>p.
pr. & vb. n.</pos> <conjf>Begirding</conjf>.]</vmorph> <ety>[AS.
<ets>begyrdan</ets> (akin to Goth. <ets>bigairdan</ets>); pref.
<ets>be-</ets> + <ets>gyrdan</ets> to gird.]</ety> <sn>1.</sn> <def>To
bind with a band or girdle; to gird.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To surround as with a band; to encompass.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Begirdle</ent><br/
<hw>Be*gir"dle</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <def>To surround as
with a girdle.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Begirt</ent><br/
<hw>Be*girt"</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <def>To encompass; to
begird.</def> <rj><au>Milton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beglerbeg</ent><br/
\'d8<hw>Beg"ler*beg`</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[Turk.
<ets>beglerbeg</ets>, fr. <ets>beg</ets>, pl. <ets>begler</ets>. See
<er>Beg</er>, <pos>n.</pos>]</ety> <def>The governor of a province of
the Ottoman empire, next in dignity to the grand vizier.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Begnaw</ent><br/
<hw>Be*gnaw"</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <vmorph>[<pos>p.
p.</pos> <conjf>Begnawed</conjf> <pr>(<?/)</pr>, <mark>(R.)</mark>
<conjf>Begnawn</conjf> <pr>(<?/)</pr>.]</vmorph> <ety>[AS.
<ets>begnagan</ets>; pref. <ets>be-</ets> + <ets>gnagan</ets> to
gnaw.]</ety> <def>To gnaw; to eat away; to corrode.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The worm of conscience still <qex>begnaw</qex> thy soul.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Begod</ent><br/
<hw>Be*god"</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. &
p. p.</pos> <conjf>Begodded</conjf>.]</vmorph> <def>To exalt to the
dignity of a god; to deify.</def> <mark>[Obs.]</mark>
<ldquo/<xex>Begodded</xex> saints.<rdquo/ <rj><au>South.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Begohm</ent><br/
<hw>Beg"ohm`</hw> <pr>(?)</pr>, <pos>n.</pos> <fld>(Elec.)</fld> <def>A
unit of resistance equal to one billion ohms, or one thousand
megohms.</def><-- ##?? still used?? is gigohm used?--><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Begone</ent><br/
<hw>Be*gone"</hw> <pr>(<?/)</pr>, <pos>interj.</pos>
<ety>[<ets>Be</ets>, v. i. + <ets>gone</ets>, p. p.]</ety> <def>Go away;
depart; get you gone.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Begone</ent><br/
<hw>Be*gone"</hw>, <pos>p. p.</pos> <ety>[OE. <ets>begon</ets>, AS.
<ets>big<amac/n</ets>; pref. <ets>be-</ets> + <ets>g<amac/n</ets> to
go.]</ety> <def>Surrounded; furnished; beset; environed (as in
woe-<xex>begone</xex>).</def> <mark>[Obs.]</mark> <rj><au>Gower.
Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Begonia</ent><br/
<hw>Be*go"ni*a</hw> <pr>(b<esl/*g<omac/"n<icr/*<adot/)</pr>,
<pos>n.</pos> <ety>[From Michel <etsep>Begon</etsep>, a promoter of
botany.]</ety> <fld>(Bot.)</fld> <def>A genus of plants, mostly of
tropical America, many species of which are grown as ornamental plants.
The leaves are curiously one-sided, and often exhibit brilliant
colors.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Begoniaceae</ent><br/
<hw>Begoniaceae</hw> <pos>n.</pos> <def>a natural family of monoecious
succulent herbs or shrubs of tropical and warm regions especially
America.</def><br/
<syn><b>Syn. --</b> family <fam>Begoniaceae</fam>, begonia
family.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><-- p. 133 --></p>

<p><ent>Begore</ent><br/
<hw>Be*gore"</hw> <pr>(b<esl/*g<omac/r")</pr>, <pos>v. t.</pos> <def>To
besmear with gore.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Begot</ent><br/
<hw>Be*got"</hw> <pr>(b<esl/*g<ocr/t")</pr>, <def><pos>imp. & p.
p.</pos> of <er>Beget</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Begotten</ent><br/
<hw>Be*got"ten</hw> <pr>(<?/)</pr>, <def><pos>p. p.</pos> of
<er>Beget</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Begrave</ent><br/
<hw>Be*grave"</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <ety>[Pref.
<ets>be-</ets> + <ets>grave</ets>; akin to G. <ets>begraben</ets>, Goth.
<ets>bigraban</ets> to dig a ditch around.]</ety> <def>To bury; also, to
engrave.</def> <mark>[Obs.]</mark> <rj><au>Gower.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Begrease</ent><br/
<hw>Be*grease"</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <def>To soil or
daub with grease or other oily matter.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Begrime</ent><br/
<hw>Be*grime"</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. &
p. p.</pos> <conjf>Begrimed</conjf> <pr>(<?/)</pr>; <pos>p. pr. & vb.
n.</pos> <conjf>Begriming</conjf>.]</vmorph> <def>To soil with grime or
dirt deeply impressed or rubbed in.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Books falling to pieces and <qex>begrimed</qex> with dust.</q>
<rj><qau>Macaulay.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Begrimer</ent><br/
<hw>Be*grim"er</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>One who, or that
which, begrimes.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Begrudge</ent><br/
<hw>Be*grudge"</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp.
& p. p.</pos> <conjf>Begrudged</conjf> <pr>(<?/)</pr>; <pos>p. pr. & vb.
n.</pos> <conjf>Begrudging</conjf>.]</vmorph> <def>To grudge; to envy
the possession of.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>begrudging</ent><br/
<hw>begrudging</hw> <pos>adj.</pos> <def>being given reluctantly or with
displeasure.</def><br/
<syn><b>Syn. --</b> envious, grudging.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Beguile</ent><br/
<hw>Be*guile"</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. &
p. p.</pos> <conjf>Beguiled</conjf> <pr>(<?/)</pr>; <pos>p. pr. & vb.
n.</pos> <conjf>Beguiling</conjf>.]</vmorph> <sn>1.</sn> <def>To delude
by guile, artifice, or craft; to deceive or impose on, as by a false
statement; to lure.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The serpent <qex>beguiled</qex> me, and I did eat.</q>
<rj><qau>Gen. iii. 13.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To elude, or evade by craft; to foil.</def>
<mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>When misery could <qex>beguile</qex> the tyrant's rage.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To cause the time of to pass without notice; to
relieve the tedium or weariness of; to while away; to divert.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Ballads . . . to <qex>beguile</qex> his incessant wayfaring.</q>
<rj><qau>W. Irving.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- To delude; deceive; cheat; insnare; mislead;
amuse; divert; entertain.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>beguiled</ent><br/
<hw>beguiled</hw> <pos>adj.</pos> <def>filled with wonder and
delight.</def><br/
<syn><b>Syn. --</b> captivated, charmed, delighted, enthralled,
entranced.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Beguilement</ent><br/
<hw>Be*guile"ment</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>The act of
beguiling, or the state of being beguiled.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beguiler</ent><br/
<hw>Be*guil"er</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>One who, or that
which, beguiles.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beguiling</ent><br/
<hw>Be*guil"ing</hw>, <pos>a.</pos> <def>Alluring by guile; deluding;
misleading; diverting.</def> -- <wordforms><wf>Be*guil"ing*ly</wf>,
<pos>adv.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beguin</ent><br/
\'d8<hw>Be`guin"</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[F.]</ety>
<def>See <er>Beghard</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beguinage</ent><br/
\'d8<hw>Be`gui`nage"</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[F.]</ety>
<def>A collection of small houses surrounded by a wall and occupied by a
community of Beguines.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beguine</ent><br/
\'d8<hw>Be`guine"</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[F.
<ets>b<eacute/guine</ets>; LL. <ets>beguina</ets>, <ets>beghina</ets>;
fr. Lambert <ets>le B<egrave/gue</ets> (the Stammerer) the founder of
the order. (<ets>Du Cange</ets>.)]</ety> <def>A woman belonging to one
of the religious and charitable associations or communities in the
Netherlands, and elsewhere, whose members live in beguinages and are not
bound by perpetual vows.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Begum</ent><br/
\'d8<hw>Be"gum</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[Per., fr. Turk.,
perh. properly queen mother, fr. Turk. <ets>beg</ets> (see <er>Beg</er>,
<pos>n.</pos>) + Ar. <ets>umm</ets> mother.]</ety> <def>In the East
Indies, a princess or lady of high rank.</def>
<rj><au>Malcom.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Begun</ent><br/
<hw>Be*gun"</hw> <pr>(<?/)</pr>, <def><pos>p. p.</pos> of
<er>Begin</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Behalf</ent><br/
<hw>Be*half"</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[OE.
<ets>on-behalve</ets> in the name of, <ets>bihalven</ets> by the side
of, fr. AS. <ets>healf</ets> half, also side, part: akin to G.
<ets>halb</ets> half, <ets>halber</ets> on account of. See <er>Be-</er>,
and <er>Half</er>, <pos>n.</pos>]</ety> <def>Advantage; favor; stead;
benefit; interest; profit; support; defense; vindication.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>In <qex>behalf</qex> of his mistress's beauty.</q> <rj><qau>Sir P.
Sidney.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Against whom he had contracted some prejudice in <qex>behalf</qex>
of his nation.</q> <rj><qau>Clarendon.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>In behalf of</b></col>, <cd>in the interest of.</cd> --
<col><b>On behalf of</b></col>, <cd>on account of; on the part
of.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Behappen</ent><br/
<hw>Be*hap"pen</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <def>To happen
to.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Behave</ent><br/
<hw>Be*have"</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. &
p. p.</pos> <conjf>Behaved</conjf> <pr>(<?/)</pr>; <pos>p. pr. & vb.
n.</pos> <conjf>Behaving</conjf>.]</vmorph> <ety>[AS.
<ets>behabban</ets> to surround, restrain, detain (akin to G.
<ets>gehaben</ets> (obs.) to have, <ets>sich gehaben</ets> to behave or
carry one's self); pref. <ets>be-</ets> + <ets>habban</ets> to have. See
<er>Have</er>, <pos>v. t.</pos> ]</ety> <sn>1.</sn> <def>To manage or
govern in point of behavior; to discipline; to handle; to
restrain.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>He did <qex>behave</qex> his anger ere 't was spent.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To carry; to conduct; to comport; to manage; to
bear; -- used reflexively.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Those that <qex>behaved</qex> themselves manfully.</q> <rj><qau>2
Macc. ii. 21.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Behave</ent><br/
<hw>Be*have"</hw>, <pos>v. i.</pos> <def>To act; to conduct; to bear or
carry one's self; <as>as, to <ex>behave</ex> well or ill</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ This verb is often used colloquially without an adverb
of manner; as, if he does not <xex>behave</xex>, he will be punished. It
is also often applied to inanimate objects; as, the ship
<xex>behaved</xex> splendidly.</note><br/
[<source>1913 Webster</source>]</p>

<p><ent>Behavior</ent><br/
<hw>Be*hav"ior</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>Manner of
behaving, whether good or bad; mode of conducting one's self; conduct;
deportment; carriage; -- used also of inanimate objects; <as>as, the
<ex>behavior</ex> of a ship in a storm; the <ex>behavior</ex> of the
magnetic needle</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>A gentleman that is very singular in his <qex>behavior</qex>.</q>
<rj><qau>Steele.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><mcol><col><b>To be upon one's good behavior</b></col>,
<col><b>To be put upon one's good behavior</b></col></mcol>, <cd>to be
in a state of trial, in which something important depends on propriety
of conduct.</cd> -- <col><b>During good behavior</b></col>, <cd>while
(or so long as) one conducts one's self with integrity and fidelity or
with propriety.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- Bearing; demeanor; manner.</syn> <usage> --
<er>Behavior</er>, <er>Conduct</er>. <xex>Behavior</xex> is the mode in
which we <xex>have</xex> or <xex>bear</xex> ourselves in the presence of
others or toward them; <xex>conduct</xex> is the mode of our carrying
ourselves forward in the concerns of life. <xex>Behavior</xex> respects
our manner of acting in particular cases; <xex>conduct</xex> refers to
the general tenor of our actions. We may say of soldiers, that their
<xex>conduct</xex> had been praiseworthy during the whole campaign, and
their <xex>behavior</xex> admirable in every instance when they met the
enemy.</usage><br/
[<source>1913 Webster</source>]</p>

<p><ent>behavioral</ent><br/
<hw>behavioral</hw> <pos>adj.</pos> <def>of or pertaining to
behavior.</def> <illu><ex>behavioral</ex> sciences</illu><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>behaviorism</ent><br/
<hw>behaviorism</hw> <pos>n.</pos> <def>an approach to psychology that
emphasizes observable measurable behavior.</def><br/
<syn><b>Syn. --</b> behaviourism, behavioristic psychology,
behaviouristic psychology.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>behaviorist</ent><br/
<hw>behaviorist</hw> <pos>n.</pos> <def>a psychologist who subscribes to
behaviorism.</def><br/
<syn><b>Syn. --</b> behaviourist.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>behaviourism</ent><br/
<hw>behaviourism</hw> <pos>n.</pos> <def>same as
<er>behaviorism</er>.</def><br/
<syn><b>Syn. --</b> behaviorism, behavioristic psychology,
behaviouristic psychology.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>behaviourist</ent><br/
<hw>behaviourist</hw> <pos>n.</pos> <def>same as
<er>behaviorist</er>.</def><br/
<syn><b>Syn. --</b> behaviorist.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>behavioristic</ent><br/
<ent>behaviorist</ent><br/
<mhw><hw>behaviorist</hw> <hw>behavioristic</hw></mhw> <pos>adj.</pos>
<def>of, pertaining to, or characteristic of behaviorists or
behaviorism.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Behead</ent><br/
<hw>Be*head"</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. &
p. p.</pos> <conjf>Beheaded</conjf>; <pos>p. pr. & vb. n.</pos>
<conjf>Beheading</conjf>.]</vmorph> <ety>[OE. <ets>bihefden</ets>, AS.
<ets>behe<aacute/fdian</ets>; pref. <ets>be-</ets> +
<ets>he<aacute/fod</ets> head. See <er>Head</er>.]</ety> <def>To sever
the head from; to take off the head of.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beheadal</ent><br/
<hw>Be*head"al</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>Beheading.</def>
<mark>[Modern]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beheld</ent><br/
<hw>Be*held"</hw> <pr>(<?/)</pr>, <def><pos>imp. & p. p.</pos> of
<er>Behold</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Behemoth</ent><br/
<hw>Be"he*moth</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[Heb.
<ets>behem<omac/th</ets>, fr. Egyptian <ets>P-ehe-maut</ets>
hippopotamus.]</ety> <sn>1.</sn> <def>An animal, probably the
hippopotamus, described in <au>Job xl. 15-24.</au></def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>something of large size or great power.</def><br/
[<source>PJC</source>]</p>

<p><ent>Behn</ent><br/
<ent>Behen</ent><br/
<mhw>{ <hw>Be"hen</hw> <pr>(<?/)</pr>, <hw>Behn</hw> }</mhw>
<pr>(<?/)</pr>, <pos>n.</pos> <ety>[Per. & Ar. <ets>bahman</ets>,
<ets>behmen</ets>, an herb, whose leaves resemble ears of corn,
saffron.]</ety> <fld>(Bot.)</fld> <sd>(a)</sd> <def>The <spn>Centaurea
behen</spn>, or saw-leaved centaury.</def> <sd>(b)</sd> <def>The
<spn>Cucubalus behen</spn>, or bladder campion, now called <spn>Silene
inflata</spn>.</def> <sd>(c)</sd> <def>The <spn>Statice limonium</spn>,
or sea lavender.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Behest</ent><br/
<hw>Be*hest"</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[OE.
<ets>biheste</ets> promise, command, AS. <ets>beh<aemac/s</ets> promise;
pref. <ets>be-</ets> + <ets>h<aemac/s</ets> command. See <er>Hest</er>,
<er>Hight</er>.]</ety> <sn>1.</sn> <def>That which is willed or ordered;
a command; a mandate; an injunction.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>To do his master's high <qex>behest</qex>.</q> <rj><qau>Sir W.
Scott.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A vow; a promise.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>The time is come that I should send it her, if I keep the
<qex>behest</qex> that I have made.</q> <rj><qau>Paston.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Behest</ent><br/
<hw>Be*hest"</hw>, <pos>v. t.</pos> <def>To vow.</def>
<mark>[Obs.]</mark> <rj><au>Paston.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Behete</ent><br/
<hw>Be*hete"</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <def>See
<er>Behight</er>.</def> <mark>[Obs.]</mark>
<rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Behight</ent><br/
<hw>Be*hight"</hw> <pr>(<?/)</pr>, <pos>v. t.</pos>
<vmorph>[<pos>imp.</pos> <conjf>Behight</conjf>; <pos>p. p.</pos>
<conjf>Behight</conjf>, <conjf>Behoten</conjf>.]</vmorph> <ety>[OE.
<ets>bihaten</ets>, AS. <ets>beh<amac/tan</ets> to vow, promise; pref.
<ets>be-</ets> + <ets>h<amac/tan</ets> to call, command. See
<er>Hight</er>, <pos>v.</pos>]</ety> <mark>[Obs. in all its
senses.]</mark> <sn>1.</sn> <def>To promise; to vow.</def><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>Behight</qex> by vow unto the chaste Minerve.</q>
<rj><qau>Surrey.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To give in trust; to commit; to intrust.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The keys are to thy hand <qex>behight</qex>.</q>
<rj><qau>Spenser.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To adjudge; to assign by authority.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The second was to Triamond <qex>behight</qex>.</q>
<rj><qau>Spenser.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>To mean, or intend.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>More than heart <qex>behighteth</qex>.</q> <rj><qau>Mir. for
Mag.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>To consider or esteem to be; to declare to
be.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>All the lookers-on him dead <qex>behight</qex>.</q>
<rj><qau>Spenser.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <def>To call; to name; to address.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Whom . . . he knew and thus <qex>behight</qex>.</q>
<rj><qau>Spenser.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>7.</sn> <def>To command; to order.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>He <qex>behight</qex> those gates to be unbarred.</q>
<rj><qau>Spenser.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Behight</ent><br/
<hw>Be*hight"</hw>, <pos>n.</pos> <def>A vow; a promise.</def>
<mark>[Obs.]</mark> <rj><au>Surrey.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Behind</ent><br/
<hw>Be*hind"</hw> <pr>(<?/)</pr>, <pos>prep.</pos> <ety>[AS.
<ets>behindan</ets>; pref. <ets>be-</ets> + <ets>hindan</ets>. See
<er>Hind</er>, <pos>a.</pos>]</ety> <sn>1.</sn> <def>On the side
opposite the front or nearest part; on the back side of; at the back of;
on the other side of; <as>as, <ex>behind</ex> a door; <ex>behind</ex> a
hill</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>A tall Brabanter, <qex>behind</qex> whom I stood.</q> <rj><qau>Bp.
Hall.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Left after the departure of, whether this be by
removing to a distance or by death.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>A small part of what he left <qex>behind</qex> him.</q>
<rj><qau>Pope.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Left a distance by, in progress of improvement
Hence: Inferior to in dignity, rank, knowledge, or excellence, or in any
achievement.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>I was not a whit <qex>behind</qex> the very chiefest apostles.</q>
<rj><qau>2 Cor. xi. 5.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Behind</ent><br/
<hw>Be*hind"</hw>, <pos>adv.</pos> <sn>1.</sn> <def>At the back part; in
the rear.</def> <ldquo/I shall not lag <xex>behind</xex>.<rdquo/
<rj><au>Milton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Toward the back part or rear; backward; <as>as, to
look <ex>behind</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Not yet brought forward, produced, or exhibited to
view; out of sight; remaining.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>We can not be sure that there is no evidence
<qex>behind</qex>.</q> <rj><qau>Locke.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>Backward in time or order of succession;
past.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Forgetting those things which are <qex>behind</qex>.</q>
<rj><qau>Phil. ii. 13.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>After the departure of another; <as>as, to stay
<ex>behind</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Leave not a rack <qex>behind</qex>.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Behind</ent><br/
<hw>Be*hind"</hw>, <pos>n.</pos> <def>The backside; the rump.</def>
<mark>[Low]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Behindhand</ent><br/
<hw>Be*hind"hand`</hw> <pr>(<?/)</pr>, <pos>adv. & a.</pos>
<ety>[<ets>Behind</ets> + <ets>hand</ets>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>In arrears financially; in a state where
expenditures have exceeded the receipt of funds.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>In a state of backwardness, in respect to what is
seasonable or appropriate, or as to what should have been accomplished;
not equally forward with some other person or thing; dilatory; backward;
late; tardy; <as>as, <ex>behindhand</ex> in studies or in
work</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>In this also [dress] the country are very much
<qex>behindhand</qex>.</q> <rj><qau>Addison.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Behither</ent><br/
<hw>Be*hith"er</hw> <pr>(<?/)</pr>, <pos>prep.</pos> <def>On this side
of.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>Two miles <qex>behither</qex> Clifden.</q>
<rj><qau>Evelyn.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Behold</ent><br/
<hw>Be*hold"</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. &
p. p.</pos> <conjf>Beheld</conjf> <pr>(<?/)</pr> (<pos>p. p.</pos>
formerly <conjf>Beholden</conjf> <pr>(<?/)</pr>, now used only as a
<pos>p. a.</pos>); <pos>p. pr. & vb. n.</pos>
<conjf>Beholding</conjf>.]</vmorph> <ety>[OE. <ets>bihalden</ets>,
<ets>biholden</ets>, AS. <ets>behealdan</ets> to hold, have in sight;
pref. <ets>be-</ets> + <ets>healdan</ets> to hold, keep; akin to G.
<ets>behalten</ets> to hold, keep. See <er>Hold</er>.]</ety> <def>To
have in sight; to see clearly; to look at; to regard with the
eyes.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>When he <qex>beheld</qex> the serpent of brass, he lived.</q>
<rj><qau>Num. xxi. 9.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>Behold</qex> the Lamb of God, which taketh away the sin of
the world.</q> <rj><qau>John. i. 29.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- To scan; gaze; regard; descry; view;
discern.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Behold</ent><br/
<hw>Be*hold"</hw>, <pos>v. i.</pos> <def>To direct the eyes to, or fix
them upon, an object; to look; to see.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>And I <qex>beheld</qex>, and, lo, in the midst of the throne, . .
. a lamb as it had been slain.</q> <rj><qau>Rev. v. 6.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beholden</ent><br/
<hw>Be*hold"en</hw> <pr>(<?/)</pr>, <pos>p. a.</pos> <ety>[Old p. p. of
<ets>behold</ets>, used in the primitive sense of the simple verb
<ets>hold</ets>.]</ety> <def>Obliged; bound in gratitude;
indebted.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>But being so <qex>beholden</qex> to the Prince.</q>
<rj><qau>Tennyson.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beholder</ent><br/
<hw>Be*hold"er</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>One who beholds;
a spectator.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beholding</ent><br/
<hw>Be*hold"ing</hw>, <pos>a.</pos> <def>Obliged; beholden.</def>
<mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>I was much bound and <qex>beholding</qex> to the right reverend
father.</q> <rj><qau>Robynson (More's Utopia).</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>So much hath Oxford been <qex>beholding</qex> to her nephews, or
sister's children.</q> <rj><qau>Fuller.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beholding</ent><br/
<hw>Be*hold"ing</hw>, <pos>n.</pos> <def>The act of seeing; sight; also,
that which is beheld.</def> <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beholdingness</ent><br/
<hw>Be*hold"ing*ness</hw>, <pos>n.</pos>, <def>The state of being
obliged or beholden.</def> <mark>[Obs.]</mark> <rj><au>Sir P.
Sidney.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Behoof</ent><br/
<hw>Be*hoof"</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[OE. <ets>to
bihove</ets> for the use of, AS. <ets>beh<omac/f</ets> advantage, a word
implied in <ets>beh<omac/fl<imac/c</ets> necessary; akin to Sw.
<ets>behof</ets>, Dan. <ets>behov</ets>, G. <ets>behuf</ets>, and E.
<ets>heave</ets>, the root meaning <ets>to seize</ets>, hence the
meanings <ldquo/to hold, make use of.<rdquo/ See <er>Heave</er>, <pos>v.
t.</pos>]</ety> <def>Advantage; profit; benefit; interest;
use.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>No mean recompense it brings<br/
To your <qex>behoof</qex>.</q> <rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Behoovable</ent><br/
<hw>Be*hoov"a*ble</hw> <pr>(<?/)</pr>, <pos>a.</pos> <def>Supplying
need; profitable; advantageous.</def> <mark>[Obs.]</mark>
<rj><au>Udall.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Behoove</ent><br/
<hw>Be*hoove"</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. &
p. p.</pos> <conjf>Behooved</conjf> <pr>(<?/)</pr>; <pos>p. pr. & vb.
n.</pos> <conjf>Behooving</conjf>.]</vmorph> <ety>[OE.
<ets>bihoven</ets>, <ets>behoven</ets>, AS. <ets>beh<omac/fian</ets> to
have need of, fr. <ets>beh<omac/f</ets>. See <er>Behoof</er>.]</ety>
<def>To be necessary for; to be fit for; to be meet for, with respect to
necessity, duty, or convenience; -- mostly used impersonally.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>And thus it <qex>behooved</qex> Christ to suffer.</q>
<rj><qau>Luke xxiv. 46.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><altsp>[Also written <asp>behove</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><ent>Behoove</ent><br/
<hw>Be*hoove"</hw> <pr>(<?/)</pr>, <pos>v. i.</pos> <def>To be
necessary, fit, or suitable; to befit; to belong as due.</def>
<rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Behoove</ent><br/
<hw>Be*hoove"</hw>, <pos>n.</pos> <def>Advantage; behoof.</def>
<mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>It shall not be to his <qex>behoove</qex>.</q>
<rj><qau>Gower.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Behooveful</ent><br/
<hw>Be*hoove"ful</hw> <pr>(<?/)</pr>, <pos>a.</pos> <def>Advantageous;
useful; profitable.</def> <mark>[Archaic]</mark> --
<wordforms><wf>Be*hoove"ful*ly</wf>, <pos>adv.</pos> --
<wf>Be*hoove"ful*ness</wf>, <pos>n.</pos>
<mark>[Archaic]</mark></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Behove</ent><br/
<hw>Be*hove"</hw> <pr>(<?/)</pr>, <pos>v.</pos>, <def>and derivatives.
See <er>Behoove</er>, &c.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Behovely</ent><br/
<hw>Be*hove"ly</hw>, <pos>a. & adv.</pos> <def>Useful, or
usefully.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Behowl</ent><br/
<hw>Be*howl"</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <def>To howl
at.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>The wolf <qex>behowls</qex> the moon.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beige</ent><br/
\'d8<hw>Beige</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[F.]</ety>
<def>Debeige.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beijing</ent><br/
<hw>Beijing</hw> <pos>prop. n.</pos> <fld>(Geography)</fld> <def>The
capital <isa>city</isa> of <country>China</country>. Formerly called
<altname>Peking</altname>. Population (2000) = 12,033,000.</def><br/
[<source>PJC</source>]</p>

<p><ent>Beild</ent><br/
<hw>Beild</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[Prob. from the same
root as <ets>build</ets>, v. t.]</ety> <def>A place of shelter;
protection; refuge.</def> <mark>[Scot. & Prov. Eng.]</mark> <altsp>[Also
written <asp>bield</asp> and <asp>beeld</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><q>The random <qex>beild</qex> o' clod or stane.</q>
<rj><qau>Burns.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Being</ent><br/
<hw>Be"ing</hw> <pr>(<?/)</pr>, <pos>p. pr.</pos> from <er>Be</er>.
<def>Existing.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ <xex>Being</xex> was formerly used where we now use
<xex>having</xex>. <ldquo/<xex>Being</xex> to go to a ball in a few
days.<rdquo/ <au>Miss Edgeworth.</au></note><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ In modern usage, <xex>is</xex>, <xex>are</xex>,
<xex>was</xex> or <xex>were being</xex>, with a past participle
following (as <xex>built</xex>, <xex>made</xex>, etc.) indicates the
process toward the completed result expressed by the participle. The
form <xex>is</xex> or <xex>was building</xex>, in this passive
signification, is idiomatic, and, if free from ambiguity, is commonly
preferable to the modern <xex>is</xex> or <xex>was being built</xex>.
The last form of speech is, however, sufficiently authorized by approved
writers. The older expression was <xex>is</xex>, or <xex>was</xex>,
<xex>a-building</xex> or <xex>in building</xex>.</note><br/
[<source>1913 Webster</source>]</p>

<p><q>A man who <qex>is being</qex> strangled.</q>
<rj><qau>Lamb.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>While the article on Burns <qex>was being</qex> written.</q>
<rj><qau>Froude.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Fresh experience <qex>is</qex> always <qex>being</qex> gained.</q>
<rj><qau>Jowett (Thucyd. )</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Being</ent><br/
<hw>Be"ing</hw>, <pos>n.</pos> <sn>1.</sn> <def>Existence, as opposed to
nonexistence; state or sphere of existence.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>In Him we live, and move, and have our <qex>being</qex>.</q>
<rj><qau>Acts xvii. 28.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>That which exists in any form, whether it be
material or spiritual, actual or ideal; living existence, as
distinguished from a thing without life; <as>as, a human <ex>being</ex>;
spiritual <ex>beings</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>What a sweet <qex>being</qex> is an honest mind !</q>
<rj><qau>Beau. & Fl.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>A <qex>Being</qex> of infinite benevolence and power.</q>
<rj><qau>Wordsworth.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Lifetime; mortal existence.</def>
<mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>Claudius, thou<br/
Wast follower of his fortunes in his <qex>being</qex>.</q>
<rj><qau>Webster (1654).</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>An abode; a cottage.</def> <mark>[Prov. Eng.]</mark>
<rj><au>Wright.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>It was a relief to dismiss them [Sir Roger's servants] into little
<qex>beings</qex> within my manor.</q> <rj><qau>Steele.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Being</ent><br/
<hw>Be"ing</hw>, <pos>adv.</pos> <def>Since; inasmuch as.</def>
<mark>[Obs. or Colloq.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>And <qex>being</qex> you have<br/
Declined his means, you have increased his malice.</q> <rj><qau>Beau. &
Fl.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beirut</ent><br/
<hw>Beirut</hw> <pos>prop. n.</pos> <fld>(Geography)</fld> <def>The
capital <isa>city</isa> of <country>Lebanon</country>. Population (2000)
= 1,100,000.</def><br/
[<source>PJC</source>]</p>

<p><ent>Bejade</ent><br/
<hw>Be*jade"</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <def>To jade or
tire.</def> <mark>[Obs.]</mark> <rj><au>Milton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bejape</ent><br/
<hw>Be*jape"</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <def>To jape; to
laugh at; to deceive.</def> <mark>[Obs.]</mark>
<rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bejaundice</ent><br/
<hw>Be*jaun"dice</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <def>To infect
with jaundice.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bejewel</ent><br/
<hw>Be*jew"el</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. &
p. p.</pos> <conjf>Bejeweled</conjf> or <conjf>Bejewelled</conjf>
<pr>(<?/)</pr>; <pos>p. pr. & vb. n.</pos> <conjf>Bejeweling</conjf> or
<conjf>Bejewelling</conjf>.]</vmorph> <def>To ornament with a jewel or
with jewels; to spangle.</def> <ldquo/<xex>Bejeweled</xex> hands.<rdquo/
<rj><au>Thackeray.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bejuco</ent><br/
\'d8<hw>Be*ju"co</hw> <pr>(?)</pr>, <pos>n.</pos> <ety>[Sp., a reed or
woody vine.]</ety> <def>Any climbing woody vine of the tropics with the
habit of a liane; in the Philippines, esp. any of various species of
<gen>Calamus</gen>, the cane or rattan palm.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Bejumble</ent><br/
<hw>Be*jum"ble</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <def>To jumble
together.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bekah</ent><br/
\'d8<hw>Be"kah</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[Heb.]</ety>
<def>Half a shekel.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beknave</ent><br/
<hw>Be*knave"</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <def>To call
knave.</def> <mark>[Obs.]</mark> <rj><au>Pope.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beknow</ent><br/
<hw>Be*know"</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <def>To confess; to
acknowledge.</def> <mark>[Obs.]</mark> <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bel</ent><br/
<hw>Bel</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>The Babylonian name of
the god known among the Hebrews as <altname>Baal</altname>. See
<er>Baal</er>.</def> <rj><au>Baruch vi. 41.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bel</ent><br/
<hw>Bel</hw> <pr>(b<ecr/l)</pr>, <pos>n.</pos> <ety>[Hind., fr. Skr.
<ets>bilva</ets>.]</ety> <def>A thorny rutaceous tree (<spn><AE/gle
marmelos</spn>) of India, and its aromatic, orange-like fruit; -- called
also <altname>Bengal quince</altname>, <altname>golden apple</altname>,
<altname>wood apple</altname>. The fruit is used medicinally, and the
rind yields a perfume and a yellow dye.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Bel</ent><br/
<hw>Bel</hw> <pr>(b<ecr/l)</pr>, <pos>n.</pos> <ety>[from Alexander
Graham <etsep>Bell</etsep>.]</ety> <def>a unit of sound intensity equal
to ten decibels.</def><br/
[<source>PJC</source>]</p>

<p><ent>Belabor</ent><br/
<hw>Be*la"bor</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. &
p. p.</pos> <conjf>Belabored</conjf> <pr>(<?/)</pr>; <pos>p. pr. & vb.
n.</pos> <conjf>Belaboring</conjf>.]</vmorph> <sn>1.</sn> <def>To ply
diligently; to work carefully upon.</def> <ldquo/If the earth is
<xex>belabored</xex> with culture, it yieldeth corn.<rdquo/
<rj><au>Barrow.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To beat soundly; to cudgel.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Ajax <qex>belabors</qex> there a harmless ox.</q>
<rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bel-accoyle</ent><br/
<hw>Bel`-ac*coyle"</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[F.
<ets>bel</ets> beautiful + <ets>accueil</ets> reception.]</ety> <def>A
kind or favorable reception or salutation.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Belace</ent><br/
<hw>Be*lace"</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. &
p. p.</pos> <conjf>Belaced</conjf> <pr>(<?/)</pr>.]</vmorph><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>To fasten, as with a lace or cord.</def>
<mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To cover or adorn with lace.</def>
<mark>[Obs.]</mark> <rj><au>Beaumont.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To beat with a strap. See <er>Lace</er>.</def>
<mark>[Obs.]</mark> <rj><au>Wright.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Belam</ent><br/
<hw>Be*lam"</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <ety>[See
<er>Lam</er>.]</ety> <def>To beat or bang.</def> <mark>[Prov. & Low,
Eng.]</mark> <rj><au>Todd.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Belamour</ent><br/
<hw>Bel"a*mour</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[F. <ets>bel
amour</ets> fair love.]</ety> <sn>1.</sn> <def>A lover.</def>
<mark>[Obs.]</mark> <rj><au>Spenser.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A flower, but of what kind is unknown.</def>
<mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>Her snowy brows, like budded <qex>belamours</qex>.</q>
<rj><qau>Spenser.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Belamy</ent><br/
<hw>Bel"a*my</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[F. <ets>bel
ami</ets> fair friend.]</ety> <def>Good friend; dear friend.</def>
<mark>[Obs.]</mark> <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Belate</ent><br/
<hw>Be*late"</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. &
p. p.</pos> <conjf>Belated</conjf>; <pos>p. pr. & vb. n.</pos>
<conjf>Belating</conjf>.]</vmorph> <def>To retard or make too
late.</def> <rj><au>Davenant.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Belated</ent><br/
<hw>Be*lat"ed</hw>, <pos>a.</pos> <def>Delayed beyond the usual time;
too late; overtaken by night; benighted.</def> <ldquo/Some
<xex>belated</xex> peasant.<rdquo/ <au>Milton.</au> --
<wordforms><wf>Be*lat"ed*ness</wf>, <pos>n.</pos></wordforms>
<au>Milton.</au><br/
[<source>1913 Webster</source>]</p>

<p><ent>Belaud</ent><br/
<hw>Be*laud"</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <def>To laud or
praise greatly.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Belay</ent><br/
<hw>Be*lay"</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. &
p. p.</pos> <conjf>Belaid</conjf>, <conjf>Belayed</conjf>
<pr>(<?/)</pr>; <pos>p. pr. & vb. n.</pos>
<conjf>Belaying</conjf>.]</vmorph> <ety>[For senses 1 & 2, D.
<ets>beleggen</ets> to cover, belay; akin to E. pref. <ets>be-</ets>,
and <ets>lay</ets> to place: for sense 3, OE. <ets>beleggen</ets>, AS.
<ets>belecgan</ets>. See pref. <er>Be-</er>, and <er>Lay</er> to
place.]</ety> <sn>1.</sn> <def>To lay on or cover; to adorn.</def>
<mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>Jacket . . . <qex>belayed</qex> with silver lace.</q>
<rj><qau>Spenser.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Naut.)</fld> <def>To make fast, as a rope, by
taking several turns with it round a pin, cleat, or kevel.</def>
<rj><au>Totten.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To lie in wait for with a view to assault. Hence: to
block up or obstruct.</def> <mark>[Obs.]</mark>
<rj><au>Dryden.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Belay thee!</b></col> <cd>Stop.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 134 --></p>

<p><ent>Belaying pin</ent><br/
<hw>Be*lay"ing pin`</hw> <pr>(b<esl/*l<amac/"<icr/ng p<icr/n`)</pr>.
<fld>(Naut.)</fld> <def>A strong pin in the side of a vessel, or by the
mast, round which ropes are wound when they are fastened or
belayed.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>bel canto</ent><br/
\'d8<hw>bel canto</hw> <pr>(b<ecr/l k<aum/n"t<osl/)</pr>, <pos>n.</pos>
<ety>[It., beautiful singing.]</ety> <fld>(Music)</fld> <def>a cantabile
style of operatic singing characterized by purity and evenness of tone,
and a precise but brilliant vocal technique displaying ease and
agility.</def><br/
[<source>PJC</source>]</p>

<p><ent>Belch</ent><br/
<hw>Belch</hw> <pr>(b<ecr/lch; 224)</pr>, <pos>v. t.</pos>
<vmorph>[<pos>imp. & p. p.</pos> <conjf>Belched</conjf>
<pr>(b<ecr/lch)</pr>; <pos>p. pr. & vb. n.</pos>
<conjf>Belching</conjf>.]</vmorph> <ety>[OE. <ets>belken</ets>, AS.
<ets>bealcan</ets>, akin to E. <ets>bellow</ets>. See <er>Bellow</er>,
<pos>v. i.</pos>]</ety> <sn>1.</sn> <def>To eject or throw up from the
stomach with violence; to eruct.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>I <qex>belched</qex> a hurricane of wind.</q>
<rj><qau>Swift.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To eject violently from within; to cast forth; to
emit; to give vent to; to vent.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Within the gates that now<br/
Stood open wide, <qex>belching</qex> outrageous flame.</q>
<rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Belch</ent><br/
<hw>Belch</hw>, <pos>v. i.</pos> <sn>1.</sn> <def>To eject wind from the
stomach through the mouth; to eructate.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To issue with spasmodic force or noise.</def>
<rj><au>Dryden.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Belch</ent><br/
<hw>Belch</hw>, <pos>n.</pos> <sn>1.</sn> <def>The act of belching;
also, that which is belched; an eructation.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Malt liquor; -- vulgarly so called as causing
eructation.</def> <mark>[Obs.]</mark> <rj><au>Dennis.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Belcher</ent><br/
<hw>Belch"er</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>One who, or that
which, belches.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beldame</ent><br/
<ent>Beldam</ent><br/
<mhw>{ <hw>Bel"dam</hw> <hw>Bel"dame</hw> }</mhw> <pr>(<?/)</pr>,
<pos>n.</pos> <ety>[Pref. <ets>bel-</ets>, denoting relationship +
<ets>dame</ets> mother: cf. F. <ets>belledame</ets> fair lady, It.
<ets>belladonna</ets>. See <er>Belle</er>, and <er>Dame</er>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>Grandmother; -- corresponding to belsire.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>To show the <qex>beldam</qex> daughters of her daughter.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>An old woman in general; especially, an ugly old
woman; a hag.</def><br/
<syn><b>Syn. --</b> hag, beldam, witch, crone.</syn><br/
[<source>1913 Webster</source>]</p>

<p><q>Around the <qex>beldam</qex> all erect they hang.</q>
<rj><qau>Akenside.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beleaguer</ent><br/
<hw>Be*lea"guer</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp.
& p. p.</pos> <conjf>Beleaguered</conjf> <pr>(<?/)</pr>; <pos>p. pr. &
vb. n.</pos> <conjf>Beleaguering</conjf>.]</vmorph> <ety>[D.
<ets>belegeren</ets> (akin to G. <ets>belagern</ets>, Sw.
<ets>bel<aum/gra</ets>, Dan. <ets>beleire</ets>); pref. <ets>be-</ets> =
E. <ets>be-</ets> + <ets>leger</ets> bed, camp, army, akin to E.
<ets>lair</ets>. See <er>Lair</er>.]</ety> <def>To surround with an army
so as to preclude escape; to besiege; to blockade.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The wail of famine in <qex>beleaguered</qex> towns.</q>
<rj><qau>Longfellow.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- To block up; environ; invest;
encompass.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beleaguerer</ent><br/
<hw>Be*lea"guer*er</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>One who
beleaguers.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beleave</ent><br/
<hw>Be*leave"</hw> <pr>(<?/)</pr>, <pos>v. t. & i.</pos>
<vmorph>[<pos>imp. & p. p.</pos> <conjf>Beleft</conjf>
<pr>(<?/)</pr>.]</vmorph> <def>To leave or to be left.</def>
<mark>[Obs.]</mark> <rj><au>May.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Belecture</ent><br/
<hw>Be*lec"ture</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp.
& p. p.</pos> <conjf>Belectured</conjf> <pr>(<?/)</pr>; <pos>p. pr. &
vb. n.</pos> <conjf>Belecturing</conjf>.]</vmorph> <def>To vex with
lectures; to lecture frequently.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Belee</ent><br/
<hw>Be*lee"</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <def>To place under
the lee, or unfavorably to the wind.</def> <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Belemnite</ent><br/
<hw>Be*lem"nite</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[Gr.
<ets><?/</ets> dart, fr. <ets><?/</ets> dart, fr. <ets><?/</ets> to
throw: cf. F. <ets>b<eacute/lemnite</ets>.]</ety> <fld>(Paleon.)</fld>
<def>A conical calcareous fossil, tapering to a point at the lower
extremity, with a conical cavity at the other end, where it is
ordinarily broken; but when perfect it contains a small chambered cone,
called the phragmocone, prolonged, on one side, into a delicate concave
blade; the thunderstone. It is the internal shell of a cephalopod
related to the sepia, and belonging to an extinct family. The belemnites
are found in rocks of the Jurassic and Cretaceous ages.</def> --
<wordforms><wf>Bel*em*nit"ic</wf>, <pos>a.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Belemnoidea</ent><br/
<hw>Belemnoidea</hw> <pos>n.</pos> <def>an order of extinct dibranchiate
cephalopods related to the surviving spirulas.</def><br/
<syn><b>Syn. --</b> order <ord>Belemnoidea</ord>.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Beleper</ent><br/
<hw>Be*lep"er</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. &
p. p.</pos> <conjf>Belepered</conjf> <pr>(<?/)</pr>.]</vmorph> <def>To
infect with leprosy.</def> <mark>[Obs.]</mark> <rj><au>Beau. &
Fl.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bel-esprit</ent><br/
\'d8<hw>Bel"-es*prit"</hw> <pr>(<?/)</pr>, <pos>n.</pos>;
<plu><it>pl.</it> <plw>Beaux-esprits</plw> <pr>(<?/)</pr>.</plu>
<ety>[F., fine wit.]</ety> <def>A fine genius, or man of wit.</def>
<ldquo/A man of letters and a <xex>bel esprit</xex>.<rdquo/ <rj><au>W.
Irving.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Belfast</ent><br/
<hw>Belfast</hw> <pos>n.</pos> <def>the capital of Northern Ireland; --
the center of Irish Protestantism.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Belfry</ent><br/
<hw>Bel"fry</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[OE.
<ets>berfray</ets> movable tower used in sieges, OF.
<ets>berfreit</ets>, <ets>berfroit</ets>, F. <ets>beffroi</ets>, fr.
MHG. <ets>bervrit</ets>, <ets>bercvrit</ets>, G. <ets>bergfriede</ets>,
fr. MHG. <ets>bergen</ets> to protect (G. <ets>bergen</ets> to conceal)
+ <ets>vride</ets> peace, protection, G. <ets>friede</ets> peace; in
compounds often taken in the sense of security, or place of security;
orig. therefore a place affording security. G. <ets>friede</ets> is akin
to E. <ets>free</ets>. See <er>Burg</er>, and <er>Free</er>.]</ety>
<sn>1.</sn> <fld>(Mil. Antiq.)</fld> <def>A movable tower erected by
besiegers for purposes of attack and defense.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A bell tower, usually attached to a church or other
building, but sometimes separate; a campanile.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>A room in a tower in which a bell is or may be hung;
or a cupola or turret for the same purpose.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <fld>(Naut.)</fld> <def>The framing on which a bell is
suspended.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Belgard</ent><br/
<hw>Bel*gard"</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[It. <ets>bel
guardo</ets>.]</ety> <def>A sweet or loving look.</def>
<mark>[Obs.]</mark> <rj><au>Spenser.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Belgian</ent><br/
<hw>Bel"gi*an</hw> <pr>(<?/)</pr>, <pos>a.</pos> <def>Of or pertaining
to Belgium.</def> -- <def2><pos>n.</pos> <def>A native or inhabitant of
Belgium.</def></def2><br/
[<source>1913 Webster</source>]</p>

<p><ent>Belgian block</ent><br/
<hw>Belgian block</hw>. <def>An oblong, often nearly cubical, block of
some tough stone, esp. granite, used as a material for street pavements.
Its usual diameter is 5 to 7 inches.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Belgic</ent><br/
<hw>Bel"gic</hw> <pr>(<?/)</pr>, <pos>a.</pos> <ety>[L.
<ets>Belgicus</ets>, fr. <ets>Belgae</ets> the Belgians.]</ety>
<sn>1.</sn> <def>Of or pertaining to the <xex>Belg<ae/</xex>, a German
tribe who anciently possessed the country between the Rhine, the Seine,
and the ocean.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>How unlike their <qex>Belgic</qex> sires of old.</q>
<rj><qau>Goldsmith.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Of or pertaining to the Netherlands or to
Belgium.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Belgrade</ent><br/
<hw>Belgrade</hw> <pos>prop. n.</pos> <fld>(Geography)</fld> <def>The
capital <isa>city</isa> of <country>Yugoslavia</country>. Population
(2000) = 1,168,454.</def><br/
[<source>PJC</source>]</p>

<p><ent>Belgravian</ent><br/
<hw>Bel*gra"vi*an</hw> <pr>(<?/)</pr>, <pos>a.</pos> <def>Belonging to
Belgravia (a fashionable quarter of London, around Pimlico), or to
fashionable life; aristocratic.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Belial</ent><br/
<hw>Be"li*al</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[Heb. <ets>beli
ya'al</ets>; <ets>beli</ets> without + <ets>ya'al</ets> profit.]</ety>
<def>An evil spirit; a wicked and unprincipled person; the
personification of evil.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>What concord hath Christ with <qex>Belia</qex> ?</q> <rj><qau>2
Cor. vi. 15.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><mcol><col><b>A son</b></col> (or man) <col><b>of
Belial</b></col></mcol>, <cd>a worthless, wicked, or thoroughly depraved
person.</cd> <au>1 Sam. ii. 12.</au></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Belibel</ent><br/
<hw>Be*li"bel</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <ety>[See
<er>Libel</er>, <pos>v. t.</pos> ]</ety> <def>To libel or traduce; to
calumniate.</def> <rj><au>Fuller.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Belie</ent><br/
<hw>Be*lie"</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. &
p. p.</pos> <conjf>Belied</conjf> <pr>(<?/)</pr>; <pos>p. pr. & vb.
n.</pos> <conjf>Belying</conjf> <pr>(<?/)</pr>.]</vmorph> <ety>[OE.
<ets>bilien</ets>, <ets>bili<?/en</ets>, AS. <ets>bele<oacute/gan</ets>;
pref. <ets>be-</ets> + <ets>le<oacute/gan</ets> to lie. See
<er>Lie</er>, <pos>n.</pos>]</ety> <sn>1.</sn> <def>To show to be false;
to convict of, or charge with, falsehood.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Their trembling hearts <qex>belie</qex> their boastful
tongues.</q> <rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To give a false representation or account
of.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Should I do so, I should <qex>belie</qex> my thoughts.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To tell lie about; to calumniate; to
slander.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Thou dost <qex>belie</qex> him, Percy, thou dost belie him.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>To mimic; to counterfeit.</def> <mark>[Obs.]</mark>
<rj><au>Dryden.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>To fill with lies.</def> <mark>[Obs.]</mark>
<ldquo/The breath of slander doth <xex>belie</xex> all corners of the
world.<rdquo/ <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Belief</ent><br/
<hw>Be*lief"</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[OE.
<ets>bileafe</ets>, <ets>bileve</ets>; cf. AS.
<ets>gele<aacute/fa</ets>. See <er>Believe</er>.]</ety> <sn>1.</sn>
<def>Assent to a proposition or affirmation, or the acceptance of a
fact, opinion, or assertion as real or true, without immediate personal
knowledge; reliance upon word or testimony; partial or full assurance
without positive knowledge or absolute certainty; persuasion;
conviction; confidence; <as>as, <ex>belief</ex> of a witness; the
<ex>belief</ex> of our senses</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>Belief</qex> admits of all degrees, from the slightest
suspicion to the fullest assurance.</q> <rj><qau>Reid.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Theol.)</fld> <def>A persuasion of the truths of
religion; faith.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>No man can attain [to] <qex>belief</qex> by the bare contemplation
of heaven and earth.</q> <rj><qau>Hooker.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>The thing believed; the object of belief.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Superstitious prophecies are not only the <qex>belief</qex> of
fools, but the talk sometimes of wise men.</q>
<rj><qau>Bacon.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>A tenet, or the body of tenets, held by the
advocates of any class of views; doctrine; creed.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>In the heat of persecution to which Christian <qex>belief</qex>
was subject upon its first promulgation.</q>
<rj><qau>Hooker.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Ultimate belief</b></col>, <cd>a first principle
incapable of proof; an intuitive truth; an intuition.</cd> <rj><au>Sir
W. Hamilton.</au></rj></cs><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- Credence; trust; reliance; assurance;
opinion.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beliefful</ent><br/
<hw>Be*lief"ful</hw> <pr>(<?/)</pr>, <pos>a.</pos> <def>Having belief or
faith.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Believable</ent><br/
<hw>Be*liev"a*ble</hw> <pr>(<?/)</pr>, <pos>a.</pos> <def>Capable of
being believed; credible.</def> --
<wordforms><wf>Be*liev"a*ble*ness</wf>, <pos>n.</pos> --
<wf>Be*liev`a*bil"i*ty</wf> <pr>(<?/)</pr>,
<pos>n.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Believe</ent><br/
<hw>Be*lieve"</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. &
p. p.</pos> <conjf>Believed</conjf> <pr>(<?/)</pr>; <pos>p. pr. & vb.
n.</pos> <conjf>Believing</conjf>.]</vmorph> <ety>[OE.
<ets>bileven</ets> (with pref. <ets>be-</ets> for AS. <ets>ge-</ets>),
fr. AS. <ets>gel<imac/fan</ets>, <ets>gel<imac/fan</ets>; akin to D.
<ets>gelooven</ets>, OHG. <ets>gilouban</ets>, G. <ets>glauben</ets>,
OS. <ets>gil<imac/bian</ets>, Goth. <ets>galaubjan</ets>, and Goth.
<ets>liubs</ets> dear. See <er>Lief</er>, <pos>a.</pos>, <er>Leave</er>,
<pos>n.</pos>]</ety> <def>To exercise belief in; to credit upon the
authority or testimony of another; to be persuaded of the truth of, upon
evidence furnished by reasons, arguments, and deductions of the mind, or
by circumstances other than personal knowledge; to regard or accept as
true; to place confidence in; to think; to consider; <as>as, to
<ex>believe</ex> a person, a statement, or a doctrine</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Our conqueror (whom I now<br/
Of force <qex>believe</qex> almighty).</q>
<rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>King Agrippa, <qex>believest</qex> thou the prophets ?</q>
<rj><qau>Acts xxvi. 27.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Often followed by a dependent clause.<br/
I <qex>believe</qex> that Jesus Christ is the Son of God.</q>
<rj><qau>Acts viii. 37.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- See <er>Expect</er>.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Believe</ent><br/
<hw>Be*lieve"</hw>, <pos>v. i.</pos> <sn>1.</sn> <def>To have a firm
persuasion, esp. of the truths of religion; to have a persuasion
approaching to certainty; to exercise belief or faith.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Lord, I <qex>believe</qex>; help thou mine unbelief.</q>
<rj><qau>Mark ix. 24.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>With the heart man <qex>believeth</qex> unto righteousness.</q>
<rj><qau>Rom. x. 10.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To think; to suppose.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>I will not <qex>believe</qex> so meanly of you.</q>
<rj><qau>Fielding.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>To believe in</b></col>. <sd>(a)</sd> <cd>To believe that
the subject of the thought (if a person or thing) exists, or (if an
event) that it has occurred, or will occur; -- as, to <xex>believe
in</xex> the resurrection of the dead.</cd> <ldquo/She does not
<xex>believe in</xex> Jupiter.<rdquo/ <au>J. H. Newman.</au>
<sd>(b)</sd> <cd>To believe that the character, abilities, and purposes
of a person are worthy of entire confidence; -- especially that his
promises are wholly trustworthy.</cd> <ldquo/Let not your heart be
troubled: ye <xex>believe in</xex> God, <xex>believe</xex> also
<xex>in</xex> me.<rdquo/ <au>John xiv. 1.</au> <sd>(c)</sd> <cd>To
believe that the qualities or effects of an action or state are
beneficial: as, to <xex>believe in</xex> sea bathing, or <xex>in</xex>
abstinence from alcoholic beverages.</cd> -- <col><b>To believe
on</b></col>, <cd>to accept implicitly as an object of religious trust
or obedience; to have faith in.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Believer</ent><br/
<hw>Be*liev"er</hw> <pr>(<?/)</pr>, <pos>n.</pos> <sn>1.</sn> <def>One
who believes; one who is persuaded of the truth or reality of some
doctrine, person, or thing.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Theol.)</fld> <def>One who gives credit to the
truth of the Scriptures, as a revelation from God; a Christian; -- in a
more restricted sense, one who receives Christ as his Savior, and
accepts the way of salvation unfolded in the gospel.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Thou didst open the Kingdom of Heaven to all
<qex>believers</qex>.</q> <rj><qau>Book of Com. Prayer.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Eccl. Hist.)</fld> <def>One who was admitted to all
the rights of divine worship and instructed in all the mysteries of the
Christian religion, in distinction from a catechumen, or one yet under
instruction.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Believing</ent><br/
<hw>Be*liev"ing</hw>, <pos>a.</pos> <def>That believes; having
belief.</def> -- <wordforms><wf>Be*liev"ing*ly</wf>,
<pos>adv.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><ent>Belight</ent><br/
<hw>Be*light"</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <def>To
illuminate.</def> <mark>[Obs.]</mark> <rj><au>Cowley.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Belike</ent><br/
<hw>Be*like"</hw> <pr>(<?/)</pr>, <pos>adv.</pos> <ety>[Pref.
<ets>be-</ets> (for <ets>by</ets>) + <ets>like</ets>.]</ety> <def>It is
likely or probably; perhaps.</def> <mark>[Obs. or Archaic]</mark> --
<wordforms><wf>Be*like"ly</wf>, <pos>adv.</pos></wordforms><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>Belike</qex>, boy, then you are in love.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Belime</ent><br/
<hw>Be*lime"</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. &
p. p.</pos> <conjf>Belimed</conjf> <pr>(<?/)</pr>.]</vmorph> <def>To
besmear or insnare with birdlime.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Belittle</ent><br/
<hw>Be*lit"tle</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp.
& p. p.</pos> <conjf>Belittled</conjf> <pr>(<?/)</pr>; <pos>p. pr. & vb.
n.</pos> <conjf>Belittling</conjf>.]</vmorph> <def>To make little or
less in a moral sense; to speak of in a depreciatory or contemptuous
way.</def> <rj><au>T. Jefferson.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Belive</ent><br/
<hw>Be*live"</hw> <pr>(<?/)</pr>, <pos>adv.</pos> <ety>[Cf.
<er>Live</er>, <pos>a.</pos>]</ety> <def>Forthwith; speedily;
quickly.</def> <mark>[Obs.]</mark> <rj><au>Chaucer.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Belk</ent><br/
<hw>Belk</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <ety>[See
<er>Belch</er>.]</ety> <def>To vomit.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bell</ent><br/
<hw>Bell</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[AS. <ets>belle</ets>,
fr. <ets>bellan</ets> to bellow. See <er>Bellow</er>.]</ety> <sn>1.</sn>
<def>A hollow metallic vessel, usually shaped somewhat like a cup with a
flaring mouth, containing a clapper or tongue, and giving forth a
ringing sound on being struck.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ Bells have been made of various metals, but the best
have always been, as now, of an alloy of copper and tin.</note><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>The Liberty Bell</b></col>, <cd>the famous bell of the
Philadelphia State House, which rang when the Continental Congress
declared the Independence of the United States, in 1776. It had been
cast in 1753, and upon it were the words <ldquo/Proclaim liberty
throughout all the land, to all the inhabitants
thereof.<rdquo/</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A hollow perforated sphere of metal containing a
loose ball which causes it to sound when moved.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Anything in the form of a bell, as the cup or corol
of a flower.</def> <ldquo/In a cowslip's <xex>bell</xex> I lie.<rdquo/
<rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <fld>(Arch.)</fld> <def>That part of the capital of a
column included between the abacus and neck molding; also used for the
naked core of nearly cylindrical shape, assumed to exist within the
leafage of a capital.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <pluf>pl.</pluf> <fld>(Naut.)</fld> <def>The strikes of
the bell which mark the time; or the time so designated.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ On shipboard, time is marked by a bell, which is struck
eight times at 4, 8, and 12 o'clock. Half an hour after it has struck
<ldquo/eight bells<rdquo/ it is struck once, and at every succeeding
half hour the number of strokes is increased by one, till at the end of
the four hours, which constitute a watch, it is struck eight
times.</note><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>To bear away the bell</b></col>, <cd>to win the prize at
a race where the prize was a bell; hence, to be superior in
something.</cd> <au>Fuller.</au> -- <col><b>To bear the bell</b></col>,
<cd>to be the first or leader; -- in allusion to the bellwether or a
flock, or the leading animal of a team or drove, when wearing a
bell.</cd> -- <mcol><col><b>To curse by bell</b></col>,
<col><b>book</b></col>, <col><b>and candle</b></col></mcol>, <cd>a
solemn form of excommunication used in the Roman Catholic church, the
bell being tolled, the book of offices for the purpose being used, and
three candles being extinguished with certain ceremonies.</cd>
<au>Nares.</au> -- <col><b>To lose the bell</b></col>, <cd>to be worsted
in a contest.</cd> <ldquo/In single fight he <xex>lost the
bell</xex>.<rdquo/ <au>Fairfax.</au> -- <col><b>To shake the
bells</b></col>, <cd>to move, give notice, or alarm.</cd>
<rj><au>Shak.</au></rj></cs><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ <xex>Bell</xex> is much used adjectively or in
combinations; as, <xex>bell</xex> clapper; <xex>bell</xex> foundry;
<xex>bell</xex> hanger; <xex>bell-</xex>mouthed; <xex>bell</xex> tower,
etc., which, for the most part, are self-explaining.</note><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Bell arch</b></col> <fld>(Arch.)</fld>, <cd>an arch of
unusual form, following the curve of an ogee.</cd> -- <mcol><col><b>Bell
cage</b></col>, or <col><b>Bell carriage</b></col></mcol>
<fld>(Arch.)</fld>, <cd>a timber frame constructed to carry one or more
large bells.</cd> -- <col><b>Bell cot</b></col> <fld>(Arch.)</fld>,
<cd>a small or subsidiary construction, frequently corbeled out from the
walls of a structure, and used to contain and support one or more
bells.</cd> -- <col><b>Bell deck</b></col> <fld>(Arch.)</fld>, <cd>the
floor of a belfry made to serve as a roof to the rooms below.</cd> --
<col><b>Bell founder</b></col>, <cd>one whose occupation it is to found
or cast bells.</cd> -- <mcol><col><b>Bell foundry</b></col>, or
<col><b>Bell foundery</b></col></mcol>, <cd>a place where bells are
founded or cast.</cd> -- <col><b>Bell gable</b></col>
<fld>(Arch.)</fld>, <cd>a small gable-shaped construction, pierced with
one or more openings, and used to contain bells.</cd> -- <col><b>Bell
glass</b></col>. <cd>See <er>Bell jar</er>.</cd> -- <col><b>Bell
hanger</b></col>, <cd>a man who hangs or puts up bells.</cd> --
<col><b>Bell pull</b></col>, <cd>a cord, handle, or knob, connecting
with a bell or bell wire, and which will ring the bell when pulled.</cd>
<au>Aytoun.</au> -- <col><b>Bell punch</b></col>, <cd>a kind of
conductor's punch which rings a bell when used.</cd> -- <col><b>Bell
ringer</b></col>, <cd>one who rings a bell or bells, esp. one whose
business it is to ring a church bell or chime, or a set of musical bells
for public entertainment.</cd> -- <col><b>Bell roof</b></col>
<fld>(Arch.)</fld>, <cd>a roof shaped according to the general lines of
a bell.</cd> -- <col><b>Bell rope</b></col>, <cd>a rope by which a
church or other bell is rung.</cd> -- <col><b>Bell tent</b></col>, <cd>a
circular conical-topped tent.</cd> -- <col><b>Bell trap</b></col>, <cd>a
kind of bell shaped stench trap.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bell</ent><br/
<hw>Bell</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p.
p.</pos> <conjf>Belled</conjf> <pr>(<?/)</pr>; <pos>p. pr. & vb.
n.</pos> <conjf>Belling</conjf>.]</vmorph> <def>To put a bell upon;
<as>as, to <ex>bell</ex> the cat</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To make bell-mouthed; <as>as, to <ex>bell</ex> a
tube</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bell</ent><br/
<hw>Bell</hw>, <pos>v. i.</pos> <def>To develop bells or corollas; to
take the form of a bell; to blossom; <as>as, hops
<ex>bell</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bell</ent><br/
<hw>Bell</hw>, <pos>v. t.</pos> <ety>[AS. <ets>bellan</ets>. See
<er>Bellow</er>.]</ety> <def>To utter by bellowing.</def>
<mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bell</ent><br/
<hw>Bell</hw>, <pos>v. i.</pos> <def>To call or bellow, as the deer in
rutting time; to make a bellowing sound; to roar.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>As loud as <qex>belleth</qex> wind in hell.</q>
<rj><qau>Chaucer.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The wild buck <qex>bells</qex> from ferny brake.</q> <rj><qau>Sir
W. Scott.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Belladonna</ent><br/
<hw>Bel`la*don"na</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[It.,
literally fine lady; <ets>bella</ets> beautiful + <ets>donna</ets>
lady.]</ety> <fld>(Bot.)</fld> <sd>(a)</sd> <def>An herbaceous European
plant (<spn>Atropa belladonna</spn>) with reddish bell-shaped flowers
and shining black berries. The whole plant and its fruit are very
poisonous, and the root and leaves are used as powerful medicinal
agents. Its properties are largely due to the alkaloid atropine which it
contains. Called also <altname>deadly nightshade</altname>.</def>
<sd>(b)</sd> <def>A species of <gen>Amaryllis</gen> (<spn>Amaryllis
belladonna</spn>); the belladonna lily.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bell animalcule</ent><br/
<hw>Bell" an`i*mal"cule</hw> <pr>(<?/)</pr>. <fld>(Zool.)</fld> <def>An
infusorian of the family <fam>Vorticellid<ae/</fam>, common in
fresh-water ponds.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bellarmine</ent><br/
<hw>Bel"lar*mine</hw> <pr>(?)</pr>, <pos>n.</pos> <def>A stoneware jug
of a pattern originated in the neighborhood of Cologne, Germany, in the
16th century. It has a bearded face or mask supposed to represent
Cardinal Bellarmine, a leader in the Roman Catholic Counter Reformation,
following the Reformation; -- called also <altname>graybeard</altname>,
<altname>longbeard</altname>.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Bell bearer</ent><br/
<hw>Bell" bear`er</hw> <pr>(<?/)</pr>. <fld>(Zool.)</fld> <def>A
Brazilian leaf hopper (<spn>Bocydium tintinnabuliferum</spn>),
remarkable for the four bell-shaped appendages of its thorax.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bellbird</ent><br/
<hw>Bell"bird`</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[So called from
their notes.]</ety> <fld>(Zool.)</fld> <sd>(a)</sd> <def>A South and
Central American bird of the genus <gen>Casmarhincos</gen>, and family
<fam>Cotingid<ae/</fam>, of several species; the campanero.</def>
<sd>(b)</sd> <def>The <spn>Myzantha melanophrys</spn> of
Australia.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>bell-bottom</ent><br/
<ent>bell-bottomed</ent><br/
<mhw><hw>bell"-bot`tomed</hw> <hw>bell"-bot`tom</hw></mhw>
<pos>adj.</pos> <def>having legs that flare at the bottom; -- of
trousers.</def> <illu><ex>bell-bottomed</ex> trousers</illu><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>bellbottoms</ent><br/
<hw>bellbottoms</hw> <pos>n.</pos> <def>trousers with legs that flare;
commonly worn as part of a sailor's uniform; -- such absurdly wide hems
were also fashionable in the 1960s.</def><br/
<syn><b>Syn. --</b> bellbottom trousers.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>bellboy</ent><br/
<hw>bellboy</hw> <pos>n.</pos> <def>someone employed as an errand boy
and luggage carrier around hotels.</def><br/
<syn><b>Syn. --</b> bellman, bellhop.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Bell crank</ent><br/
<hw>Bell" crank`</hw> <pr>(<?/)</pr>. <def>A lever whose two arms form a
right angle, or nearly a right angle, having its fulcrum at the apex of
the angle. It is used in bell pulls and in changing the direction of
bell wires at angles of rooms, etc., and also in machinery.</def><br/
[<source>1913 Webster</source>]</p>

<p><-- p. 135 --></p>

<p><ent>Belle</ent><br/
<hw>Belle</hw> <pr>(b<ecr/l)</pr>, <pos>n.</pos> <ety>[F.
<ets>belle</ets>, fem. of <ets>bel</ets>, <ets>beau</ets>, beautiful,
fine. See <er>Beau</er>.]</ety> <def>A young lady of superior beauty and
attractions; a handsome lady, or one who attracts notice in society; a
fair lady.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Belled</ent><br/
<hw>Belled</hw> <pr>(b<ecr/ld)</pr>, <pos>a.</pos> <def>Hung with a bell
or bells.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Belleek ware</ent><br/
<hw>Bel*leek" ware</hw> <pr>(?)</pr>. <def>A porcelainlike kind of
decorative pottery with a high gloss, which is sometimes iridescent. A
very fine kind is made at Belleek in Ireland.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Belle-lettrist</ent><br/
<hw>Belle-let"trist</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>One versed
in belles-lettres.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bellerophon</ent><br/
\'d8<hw>Bel*ler"o*phon</hw> <pr>(<?/)</pr>, <pos>n.</pos>
<fld>(Paleon.)</fld> <def>A genus of fossil univalve shells, believed to
belong to the Heteropoda, peculiar to the Paleozoic age.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Belles-lettres</ent><br/
\'d8<hw>Belles-let"tres</hw> <pr>(<?/)</pr>, <pos>n. pl.</pos>
<ety>[F.]</ety> <def>Polite or elegant literature; the humanities; --
used somewhat vaguely for literary works in which imagination and taste
are predominant.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Belletristical</ent><br/
<ent>Belletristic</ent><br/
<mhw>{ <hw>Bel`le*tris"tic</hw> <pr>(<?/)</pr>,
<hw>Bel`le*tris"tic*al</hw> <pr>(<?/)</pr>, }</mhw> <pos>a.</pos>
<def>Occupied with, or pertaining to, belles-lettres.</def> <ldquo/An
unlearned, <xex>belletristic</xex> trifler.<rdquo/ <rj><au>M.
Arnold.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bell-faced</ent><br/
<hw>Bell"-faced`</hw> <pr>(<?/)</pr>, <pos>a.</pos> <def>Having the
striking surface convex; -- said of hammers.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bellflower</ent><br/
<hw>Bell"flow`er</hw> <pr>(<?/)</pr>, <pos>n.</pos> <fld>(Bot.)</fld>
<def>A plant of the genus Campanula; -- so named from its bell-shaped
flowers.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bellflower</ent><br/
<hw>Bell"flow`er</hw>, <pos>n.</pos> <ety>[F. <ets>bellefleur</ets>,
lit., beautiful flower.]</ety> <def>A kind of apple. The yellow
bellflower is a large, yellow winter apple.</def> <altsp>[Written also
<asp>bellefleur</asp>.]</altsp><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bellibone</ent><br/
<hw>Bel"li*bone</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[F. <ets>belle
et bonne</ets>, beautiful and good.]</ety> <def>A woman excelling both
in beauty and goodness; a fair maid.</def> <mark>[Obs.]</mark>
<rj><au>Spenser.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bellical</ent><br/
<ent>Bellic</ent><br/
<mhw>{ <hw>Bel"lic</hw> <pr>(<?/)</pr>, <hw>Bel"li*cal</hw>
<pr>(<?/)</pr>, }</mhw> <pos>a.</pos> <ety>[L. <ets>bellicus</ets>. See
<er>Bellicose</er>.]</ety> <def>Of or pertaining to war; warlike;
martial.</def> <mark>[Obs.]</mark> <ldquo/<xex>Bellic</xex>
C<ae/sar.<rdquo/ <rj><au>Feltham.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bellicose</ent><br/
<hw>Bel"li*cose`</hw> <pr>(<?/)</pr>, <pos>a.</pos> <ety>[L.
<ets>bellicosu</ets>s, fr. <ets>bellicus</ets> of war, fr.
<ets>bellum</ets> war. See <er>Duel</er>.]</ety> <def>Inclined to war or
contention; warlike; pugnacious.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Arnold was, in fact, in a <qex>bellicose</qex> vein.</q>
<rj><qau>W. Irving.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bellicosely</ent><br/
<hw>Bel"li*cose`ly</hw>, <pos>adv.</pos> <def>In a bellicose
manner.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bellicous</ent><br/
<hw>Bel"li*cous</hw> <pr>(<?/)</pr>, <pos>a.</pos> <def>Bellicose.</def>
<mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bellied</ent><br/
<hw>Bel"lied</hw> <pr>(<?/)</pr>, <pos>a.</pos> <def>Having (such) a
belly; puffed out; -- used in composition; <as>as, pot-<ex>bellied</ex>;
shad-<ex>bellied</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Belligerency</ent><br/
<ent>Belligerence</ent><br/
<mhw>{ <hw>Bel*lig"er*ence</hw> <pr>(<?/)</pr>,
<hw>Bel*lig"er*en*cy</hw> <pr>(<?/)</pr>, }</mhw> <pos>n.</pos> <def>The
quality of being belligerent.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>the act or state of being engaged in war or a
warlike conflict; warfare.</def><br/
<syn><b>Syn. --</b> hostilities.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><sn>3.</sn> <def>an aggressively hostile or warlike attitude or
nature; a readiness to fight or offend, with little or no
provocation.</def><br/
[<source>WordNet 1.5</source> <source>+PJC</source>]</p>

<p><ent>Belligerent</ent><br/
<hw>Bel*lig"er*ent</hw> <pr>(<?/)</pr>, <pos>a.</pos> <ety>[L.
<ets>bellum</ets> war + <ets>gerens</ets>, <ets>-entis</ets>, waging,
<pos>p. pr.</pos> of <ets>gerere</ets> to wage: cf. F.
<ets>bellig<eacute/rant</ets>. See <er>Bellicose</er>,
<er>Jest</er>.]</ety> <sn>1.</sn> <def>Waging war; carrying on
war.</def> <ldquo/<xex>Belligerent</xex> powers.<rdquo/ <rj><au>E.
Everett.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Pertaining, or tending, to war; of or relating to
belligerents; <as>as, a <ex>belligerent</ex> tone; <ex>belligerent</ex>
rights</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Belligerent</ent><br/
<hw>Bel*lig"er*ent</hw>, <pos>n.</pos> <def>A nation or state recognized
as carrying on war; a person engaged in warfare.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Belligerently</ent><br/
<hw>Bel*lig"er*ent*ly</hw>, <pos>adv.</pos> <def>In a belligerent
manner; hostilely.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Belling</ent><br/
<hw>Bell"ing</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[From <er>Bell</er>
to bellow.]</ety> <def>A bellowing, as of a deer in rutting time.</def>
<rj><au>Johnson.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bellipotent</ent><br/
<hw>Bel*lip"o*tent</hw> <pr>(<?/)</pr>, <pos>a.</pos> <ety>[L.
<ets>bellipotens</ets>; <ets>bellum</ets> war + <ets>potens</ets>
powerful, <pos>p. pr.</pos> of <ets>posse</ets> to be able.]</ety>
<def>Mighty in war; armipotent.</def> <mark>[R.]</mark>
<rj><au>Blount.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bell jar</ent><br/
<hw>Bell" jar`</hw> <pr>(<?/)</pr>. <fld>(Phys.)</fld> <def>A glass
vessel, varying in size, open at the bottom and closed at the top like a
bell, and having a knob or handle at the top for lifting it. It is used
for a great variety of purposes; as, with the air pump, and for holding
gases, also for keeping the dust from articles exposed to
view.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bellman</ent><br/
<hw>Bell"man</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>A man who rings a
bell, especially to give notice of anything in the streets. Formerly,
also, a night watchman who called the hours.</def>
<rj><au>Milton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bell metal</ent><br/
<hw>Bell" met`al</hw> <pr>(<?/)</pr>. <def>A hard alloy or bronze,
consisting usually of about three parts of copper to one of tin; -- used
for making bells.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Bell metal ore</b></col>, <cd>a sulphide of tin, copper,
and iron; the mineral stannite.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bell-mouthed</ent><br/
<hw>Bell"-mouthed`</hw> <pr>(<?/)</pr>, <pos>a.</pos> <def>Expanding at
the mouth; <as>as, a <ex>bell-mouthed</ex> gun</as>.</def>
<rj><au>Byron.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bellon</ent><br/
<hw>Bel"lon</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>Lead
colic.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bellona</ent><br/
\'d8<hw>Bel*lo"na</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[L., from
<ets>bellum</ets> war.]</ety> <fld>(Rom. Myth.)</fld> <def>The goddess
of war.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bellow</ent><br/
<hw>Bel"low</hw> <pr>(<?/)</pr>, <pos>v. i.</pos> <vmorph>[<pos>imp. &
p. p.</pos> <conjf>Bellowed</conjf> ; <pos>p. pr. & vb. n.</pos>
<conjf>Bellowing</conjf>.]</vmorph> <ety>[OE. <ets>belwen</ets>,
<ets>belowen</ets>, AS. <ets>bylgean</ets>, fr. <ets>bellan</ets>; akin
to G. <ets>bellen</ets>, and perh. to L. <ets>flere</ets> to weep,
OSlav. <ets>bleja</ets> to bleat, Lith. <ets>balsas</ets> voice. Cf.
<er>Bell</er>, <pos>n.</pos> & <pos>v.</pos>, <er>Bawl</er>,
<er>Bull</er>.]</ety> <sn>1.</sn> <def>To make a hollow, loud noise, as
an enraged bull.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To bowl; to vociferate; to clamor.</def>
<rj><au>Dryden.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To roar; as the sea in a tempest, or as the wind
when violent; to make a loud, hollow, continued sound.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The <qex>bellowing</qex> voice of boiling seas.</q>
<rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bellow</ent><br/
<hw>Bel"low</hw>, <pos>v. t.</pos> <def>To emit with a loud voice; to
shout; -- used with <xex>out</xex>.</def> <ldquo/Would <xex>bellow</xex>
out a laugh.<rdquo/ <rj><au>Dryden.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bellow</ent><br/
<hw>Bel"low</hw>, <pos>n.</pos> <def>A loud resounding outcry or noise,
as of an enraged bull; a roar.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bellower</ent><br/
<hw>Bel"low*er</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>One who, or that
which, bellows.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bellows</ent><br/
<hw>Bel"lows</hw> <pr>(<?/)</pr>, <pos>n. sing. & pl.</pos> <ety>[OE.
<ets>bely</ets>, <ets>below</ets>, belly, bellows, AS.
<ets>b<ae/lg</ets>, <ets>b<ae/lig</ets>, bag, bellows, belly. Bellows is
prop. a pl. and the orig. sense is bag. See <er>Belly</er>.]</ety>
<def>An instrument, utensil, or machine, which, by alternate expansion
and contraction, or by rise and fall of the top, draws in air through a
valve and expels it through a tube for various purposes, as blowing
fires, ventilating mines, or filling the pipes of an organ with
wind.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Bellows camera</b></col>, <cd>in photography, a form of
camera, which can be drawn out like an accordion or
<xex>bellows</xex>.</cd> -- <col><b>Hydrostatic bellows</b></col>.
<cd>See <er>Hydrostatic</er>.</cd> -- <col><b>A pair of
bellows</b></col>, <cd>the ordinary household instrument for blowing
fires, consisting of two nearly heart-shaped boards with handles,
connected by leather, and having a valve and tube.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bellows fish</ent><br/
<hw>Bel"lows fish`</hw> <pr>(<?/)</pr>. <fld>(Zool.)</fld> <def>A
European fish (<spn>Centriscus scolopax</spn>), distinguished by a long
tubular snout, like the pipe of a bellows; -- called also
<altname>trumpet fish</altname>, and <altname>snipe
fish</altname>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bell pepper</ent><br/
<hw>Bell" pep`per</hw> <pr>(<?/)</pr>. <fld>(Bot.)</fld> <def>A species
of Capsicum, or Guinea pepper (<spn>Capsicum annuum</spn>). It is the
red pepper of the gardens.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bell process</ent><br/
<hw>Bell process</hw>. <fld>(Iron Metal.)</fld> <def>The process of
washing molten pig iron by adding iron oxide, proposed by <person>I.
Lowthian <etsep>Bell</etsep></person> of England about 1875.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>bell-ringer</ent><br/
<hw>bell-ringer</hw> <pos>n.</pos> <sn>1.</sn> <def>a person who rings
church bells (as for summoning the congregation).</def><br/
<syn><b>Syn. --</b> toller.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><sn>2.</sn> <def>someone who plays musical handbells.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>bell-ringing</ent><br/
<hw>bell-ringing</hw> <pos>n.</pos> <def>playing a set of bells that are
(usually) hung in a tower.</def><br/
<syn><b>Syn. --</b> carillon, carillon playing.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Bell-shaped</ent><br/
<hw>Bell"-shaped`</hw> <pr>(-sh<amac/pt`)</pr>, <pos>a.</pos>
<def>Having the shape of a wide-mouthed bell; campanulate.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bell's palsy</ent><br/
<hw>Bell's palsy</hw>. <def>Paralysis of the facial nerve, producing
distortion of one side of the face.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Bell system of control</ent><br/
<hw>Bell system of control</hw>. <fld>(A<eum/ronautics)</fld> <def>See
<er>Cloche</er>.</def><br/
[<source>Webster 1913 Suppl.</source>]</p>

<p><ent>Belluine</ent><br/
<hw>Bel"lu*ine</hw> <pr>(<?/)</pr>, <pos>a.</pos> <ety>[L.
<ets>belluinus</ets>, fr. <ets>bellua</ets> beast.]</ety>
<def>Pertaining to, or like, a beast; brutal.</def>
<mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>Animal and <qex>belluine</qex> life.</q>
<rj><qau>Atterbury.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bellwether</ent><br/
<hw>Bell"weth`er</hw> <pr>(<?/)</pr>, <pos>n.</pos> <sn>1.</sn> <def>A
wether, or sheep, which leads the flock, with a bell on his
neck.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Hence: A leader.</def> <mark>[Contemptuous]</mark>
<rj><au>Swift.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bellwort</ent><br/
<hw>Bell"wort"</hw> <pr>(<?/)</pr>, <pos>n.</pos> <fld>(Bot.)</fld>
<def>A genus of plants (<gen>Uvularia</gen>) with yellowish bell-shaped
flowers.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Belly</ent><br/
<hw>Bel"ly</hw> <pr>(b<ecr/l"l<ycr/)</pr>, <pos>n.</pos>;
<plu><it>pl.</it> <plw>Bellies</plw> <pr>(-l<icr/z)</pr>.</plu>
<ety>[OE. <ets>bali</ets>, <ets>bely</ets>, AS. <ets>belg</ets>,
<ets>b<ae/lg</ets>, <ets>b<ae/lig</ets>, bag, bellows, belly; akin to
Icel. <ets>belgr</ets> bag, bellows, Sw. <ets>b<aum/lg</ets>, Dan.
<ets>b<ae/lg</ets>, D. & G. <ets>balg</ets>, cf. W. <ets>bol</ets> the
paunch or belly, dim. <ets>boly</ets>, Ir. <ets>bolg</ets>. Cf.
<er>Bellows</er>, <er>Follicle</er>, <er>Fool</er>,
<er>Bilge</er>.]</ety> <sn>1.</sn> <def>That part of the human body
which extends downward from the breast to the thighs, and contains the
bowels, or intestines; the abdomen.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ Formerly all the splanchnic or visceral cavities were
called bellies; -- the <xex>lower belly</xex> being the abdomen; the
<xex>middle belly</xex>, the thorax; and the <xex>upper belly</xex>, the
head.</note> <rj><au>Dunglison.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>The under part of the body of animals, corresponding
to the human belly.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Underneath the <qex>belly</qex> of their steeds.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>The womb.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>Before I formed thee in the <qex>belly</qex> I knew thee.</q>
<rj><qau>Jer. i. 5.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>The part of anything which resembles the human belly
in protuberance or in cavity; the innermost part; <as>as, the
<ex>belly</ex> of a flask, muscle, sail, ship</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Out of the <qex>belly</qex> of hell cried I.</q> <rj><qau>Jonah
ii. 2.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <fld>(Arch.)</fld> <def>The hollow part of a curved or
bent timber, the convex part of which is the back.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Belly doublet</b></col>, <cd>a doublet of the 16th
century, hanging down so as to cover the belly.</cd> <au>Shak.</au> --
<col><b>Belly fretting</b></col>, <cd>the chafing of a horse's belly
with a girth.</cd> <au>Johnson.</au> -- <col><b>Belly timber</b></col>,
<cd>food.</cd> <mark>[Ludicrous]</mark> <au>Prior.</au> -- <col><b>Belly
worm</b></col>, <cd>a worm that breeds or lives in the belly (stomach or
intestines).</cd> <au>Johnson.</au></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Belly</ent><br/
<hw>Bel"ly</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos>
<conjf>Bellied</conjf> <pr>(<?/)</pr>; <pos>p. pr. & vb. n.</pos>
<conjf>Bellying</conjf>.]</vmorph> <def>To cause to swell out; to
fill.</def> <mark>[R.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>Your breath of full consent <qex>bellied</qex> his sails.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Belly</ent><br/
<hw>Bel"ly</hw>, <pos>v. i.</pos> <def>To swell and become protuberant,
like the belly; to bulge.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The <qex>bellying</qex> canvas strutted with the gale.</q>
<rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bellyache</ent><br/
<hw>Bel"ly*ache`</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>Pain in the
bowels; colic.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bellyache</ent><br/
<hw>Bel"ly*ache`</hw> <pr>(<?/)</pr>, <pos>v. i.</pos> <def>to complain,
especially in a whining or grumbling manner; to gripe.</def><br/
<syn><b>Syn. --</b> gripe, whine, complain, moan, snivel, grumble,
squawk.</syn><br/
[<source>PJC</source> + <source>WordNet 1.5</source>]</p>

<p><ent>bellyacher</ent><br/
<hw>bel"ly*ach`er</hw> <pos>n.</pos> <def>a person who complains
habitually, usually about everyday minor problems.</def><br/
<syn><b>Syn. --</b> whiner, complainer, moaner, sniveler, crybaby,
grumbler, squawker.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Bellyband</ent><br/
<hw>Bel"ly*band`</hw> <pr>(<?/)</pr>, <pos>n.</pos> <sn>1.</sn> <def>A
band that passes under the belly of a horse and holds the saddle or
harness in place; a girth.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A band of flannel or other cloth about the
belly.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <fld>(Naut.)</fld> <def>A band of canvas, to strengthen a
sail.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bellybound</ent><br/
<hw>Bel"ly*bound`</hw> <pr>(<?/)</pr>, <pos>a.</pos> <def>Costive;
constipated.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>belly button</ent><br/
<ent>bellybutton</ent><br/
<mhw><hw>bel"ly*but`ton</hw>, <hw>bel"ly but`ton</hw></mhw>,
<pos>n.</pos> <def>The depression in the middle of the abdomen in humans
left as a residue of the umbilical cord; the umbilicus; the
navel{1}.</def><br/
[<source>PJC</source>]</p>

<p><ent>Bellycheat</ent><br/
<hw>Bel"ly*cheat`</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>An apron or
covering for the front of the person.</def> <mark>[Obs.]</mark>
<rj><au>Beau. & Fl.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bellycheer</ent><br/
<hw>Bel"ly*cheer`</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[Perh. from F.
<ets>belle ch<egrave/re</ets>.]</ety> <def>Good cheer; viands.</def>
<mark>[Obs.]</mark> <ldquo/<xex>Bellycheer</xex> and banquets.<rdquo/
<au>Rowlands.</au> <ldquo/Loaves and <xex>bellycheer</xex>.<rdquo/
<au>Milton.</au><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bellycheer</ent><br/
<hw>Bel"ly*cheer`</hw>, <pos>v. i.</pos> <def>To revel; to feast.</def>
<mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>A pack of clergymen [assembled] by themselves to
<qex>bellycheer</qex> in their presumptuous Sion.</q>
<rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bellyful</ent><br/
<hw>Bel"ly*ful</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>As much as
satisfies the appetite. Hence: A great abundance; more than
enough.</def> <rj><au>Lloyd.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>King James told his son that he would have his <qex>bellyful</qex>
of parliamentary impeachments.</q> <rj><qau>Johnson.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Belly-god</ent><br/
<hw>Bel"ly-god`</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>One whose great
pleasure it is to gratify his appetite; a glutton; an epicure.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>belly-land</ent><br/
<ent>bellyland</ent><br/
<mhw><hw>bellyland</hw>, <hw>belly-land</hw></mhw> <pos>v.</pos> <def>to
land on the underside without the landing gear; -- of
airplanes.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>belly-laugh</ent><br/
<ent>bellylaugh</ent><br/
<mhw><hw>bel"ly*laugh`</hw>, <hw>bel"ly-laugh`</hw></mhw> <pos>v.</pos>
<def>to laugh a deep, hearty laugh.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>belly laugh</ent><br/
<hw>bel"ly laugh`</hw>, <pos>n.</pos> <def>a vigorous, loud laugh,
expressing a strong amusement.</def><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Belly-pinched</ent><br/
<hw>Bel"ly-pinched`</hw> <pr>(<?/)</pr>, <pos>a.</pos> <def>Pinched with
hunger; starved.</def> <ldquo/The <xex>belly-pinched</xex> wolf.<rdquo/
<rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>belly up</ent><br/
<hw>bel"ly up`</hw>, <pos>v. i.</pos> <def>to approach (a counter) and
stand in front of it; -- used mostly in the phrase <col><b>belly up to
the bar</b></col> (i.e. to a counter in a saloon).</def><br/
[<source>PJC</source>]</p>

<p><ent>belly-up</ent><br/
<ent>belly up</ent><br/
<mhw><hw>bel"ly up`</hw>, <hw>bel"ly-up`</hw></mhw>, <pos>a.</pos>
<ety>[from analogy to the position of a floating dead fish.]</ety>
<def>defunct; bankrupt; -- used mostly of commercial organizations;
often used in the phrase <col><b>go belly-up</b></col>, i. e. to go
bankrupt.</def><br/
[<source>PJC</source>]</p>

<p><ent>Bel-Merodach</ent><br/
<hw>Bel-Merodach</hw> <pos>n.</pos> <sn>1.</sn> <def>(Babylonian) the
chief Babylonian god; his consort was Sarpanitu.</def><br/
<syn><b>Syn. --</b> Marduk, Merodach, Baal Merodach.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><ent>Belmopan</ent><br/
<hw>Belmopan</hw> <pos>prop. n.</pos> <fld>(Geography)</fld> <def>The
capital <isa>city</isa> of <country>Belize</country>. Population (2000)
= 5,845.</def><br/
[<source>PJC</source>]</p>

<p><ent>Belock</ent><br/
<hw>Be*lock"</hw> <pr>(b<esl/*l<ocr/k")</pr>, <pos>v. t.</pos>
<vmorph>[<pos>imp. & p. p.</pos> <conjf>Belocked</conjf>
<pr>(b<esl/*l<ocr/kt")</pr>.]</vmorph> <ety>[Pref. <ets>be-</ets> +
<ets>lock</ets>: cf. AS. <ets>bel<umac/can</ets>.]</ety> <def>To lock,
or fasten as with a lock.</def> <mark>[Obs.]</mark>
<rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Belomancy</ent><br/
<hw>Bel"o*man`cy</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[Gr.
<ets><?/</ets>; <ets><?/</ets> arrow + <ets><?/</ets> a diviner: cf. F.
<ets>b<eacute/lomancie</ets>.]</ety> <def>A kind of divination anciently
practiced by means of marked arrows drawn at random from a bag or
quiver, the marks on the arrows drawn being supposed to foreshow the
future.</def> <rj><au>Encyc. Brit.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Belong</ent><br/
<hw>Be*long"</hw> <pr>(<?/)</pr>, <pos>v. i.</pos> <vmorph>[<pos>imp. &
p. p.</pos> <conjf>Belonged</conjf> <pr>(<?/)</pr>; <pos>p. pr. & vb.
n.</pos> <conjf>Belonging</conjf>.]</vmorph> <ety>[OE.
<ets>belongen</ets> (akin to D. <ets>belangen</ets> to concern, G.
<ets>belangen</ets> to attain to, to concern); pref. <ets>be-</ets> +
<ets>longen</ets> to desire. See <er>Long</er>, <pos>v. i.</pos>]</ety>
<note>[Usually construed with <xex>to</xex>.]</note> <sn>1.</sn> <def>To
be the property <xex>of</xex>; <as>as, Jamaica <ex>belongs</ex> to Great
Britain</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To be a part <xex>of</xex>, or connected
<xex>with</xex>; to be appendant or related; to owe allegiance or
service.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>A desert place <qex>belonging</qex> to . . . Bethsaids.</q>
<rj><qau>Luke ix. 10.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>The mighty men which <qex>belonged</qex> to David.</q> <rj><qau>1
Kings i. 8.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>To be the concern or proper business or function
<xex>of</xex>; to appertain <xex>to</xex>.</def> <ldquo/Do not
interpretations <xex>belong</xex> to God ?<rdquo/ <rj><au>Gen. xl.
8.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>To be suitable <xex>for</xex>; to be due
<xex>to</xex>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Strong meat <qex>belongeth</qex> to them that are of full age.</q>
<rj><qau>Heb. v. 14.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>No blame <qex>belongs</qex> to thee.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>To be native <xex>to</xex>, or an inhabitant
<xex>of</xex>; esp. to have a legal residence, settlement, or
inhabitancy, whether by birth or operation of law, so as to be entitled
to maintenance by the parish or town.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Bastards also are settled in the parishes to which the mothers
<qex>belong</qex>.</q> <rj><qau>Blackstone.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Belong</ent><br/
<hw>Be*long"</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <def>To be deserved
by.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>More evils <qex>belong</qex> us than happen to us.</q> <rj><qau>B.
Jonson.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Belonging</ent><br/
<hw>Be*long"ing</hw>, <pos>n.</pos> <ety>[Commonly in the
<ets>pl</ets>.]</ety> <sn>1.</sn> <def>That which belongs to one; that
which pertains to one; hence, goods or effects.</def> <ldquo/Thyself and
thy <xex>belongings</xex>.<rdquo/ <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>That which is connected with a principal or greater
thing; an appendage; an appurtenance.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Family; relations; household.</def>
<mark>[Colloq.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>Few persons of her ladyship's <qex>belongings</qex> stopped,
before they did her bidding, to ask her reasons.</q>
<rj><qau>Thackeray.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Belonite</ent><br/
<hw>Bel"o*nite</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[Gr.
<ets><?/</ets> a needle.]</ety> <fld>(Min.)</fld> <def>Minute acicular
or dendritic crystalline forms sometimes observed in glassy volcanic
rocks.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Belooche Beloochee</ent><br/
<mhw>{ <hw>Bel*oo"che Bel*oo"chee</hw> }</mhw> <pr>(<?/)</pr>,
<pos>a.</pos> <def>Of or pertaining to Beloochistan, or to its
inhabitants.</def> -- <def2><pos>n.</pos> <def>A native or an inhabitant
of Beloochistan.</def></def2><br/
[<source>1913 Webster</source>]</p>

<p><ent>Belord</ent><br/
<hw>Be*lord"</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <sn>1.</sn> <def>To
act the lord over.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To address by the title of
<ldquo/lord<rdquo/.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Belove</ent><br/
<hw>Be*love"</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. &
p. p.</pos> <conjf>Beloved</conjf> <pr>(<?/)</pr>.]</vmorph> <ety>[OE.
<ets>bilufien</ets>. See pref. <er>Be-</er>, and <er>Love</er>, <pos>v.
t.</pos>]</ety> <def>To love.</def> <mark>[Obs.]</mark>
<rj><au>Wodroephe.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beloved</ent><br/
<hw>Be*loved"</hw> <pr>(<?/)</pr>, <pos>p. p. & a.</pos> <def>Greatly
loved; dear to the heart.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Antony, so well <qex>beloved</qex> of C<ae/sar.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>This is my <qex>beloved</qex> Son.</q> <rj><qau>Matt. iii.
17.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beloved</ent><br/
<hw>Be*lov"ed</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>One greatly
loved.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>My <qex>beloved</qex> is mine, and I am his.</q> <rj><qau>Cant.
ii. 16.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Below</ent><br/
<hw>Be*low"</hw> <pr>(<?/)</pr>, <pos>prep.</pos> <ety>[Pref.
<ets>be-</ets> by + <ets>low</ets>.]</ety> <sn>1.</sn> <def>Under, or
lower in place; beneath not so high; <as>as, <ex>below</ex> the moon;
<ex>below</ex> the knee</as>.</def> <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Inferior to in rank, excellence, dignity, value,
amount, price, etc.; lower in quality.</def> <ldquo/One degree
<xex>below</xex> kings.<rdquo/ <rj><au>Addison.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Unworthy of; unbefitting; beneath.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>They beheld, with a just loathing and disdain, . . . how
<qex>below</qex> all history the persons and their actions were.</q>
<rj><qau>Milton.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Who thinks no fact <qex>below</qex> his regard.</q>
<rj><qau>Hallam.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- Underneath; under; beneath.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Below</ent><br/
<hw>Be*low"</hw>, <pos>adv.</pos> <sn>1.</sn> <def>In a lower place,
with respect to any object; in a lower room; beneath.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Lord Marmion waits <qex>below</qex>.</q> <rj><qau>Sir W.
Scott.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>On the earth, as opposed to the heavens.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The fairest child of Jove <qex>below</qex>.</q>
<rj><qau>Prior.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>In hell, or the regions of the dead.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>What business brought him to the realms <qex>below</qex>.</q>
<rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>In court or tribunal of inferior jurisdiction;
<as>as, at the trial <ex>below</ex></as>.</def>
<rj><au>Wheaton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>In some part or page following.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Belowt</ent><br/
<hw>Be*lowt"</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <def>To treat as a
lout; to talk abusively to.</def> <mark>[Obs.]</mark>
<rj><au>Camden.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Belsire</ent><br/
<hw>Bel"sire`</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[Pref.
<ets>bel-</ets> + <ets>sire</ets>. Cf. <er>Beldam</er>.]</ety> <def>A
grandfather, or ancestor.</def> <ldquo/His great <xex>belsir</xex>e
Brute.<rdquo/ <mark>[Obs.]</mark> <rj><au>Drayton.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Belswagger</ent><br/
<hw>Bel"swag`ger</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[Contr. from
<ets>bellyswagger</ets>.]</ety> <def>A lewd man; also, a bully.</def>
<mark>[Obs.]</mark> <rj><au>Dryden.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Belt</ent><br/
<hw>Belt</hw> <pr>(b<ecr/lt)</pr>, <pos>n.</pos> <ety>[AS.
<ets>belt</ets>; akin to Icel. <ets>belti</ets>, Sw.
<ets>b<aum/lte</ets>, Dan. <ets>b<ae/lte</ets>, OHG. <ets>balz</ets>, L.
<ets>balteus</ets>, Ir. & Gael. <ets>balt</ets> border, belt.]</ety>
<sn>1.</sn> <def>That which engirdles a person or thing; a band or
girdle; <as>as, a lady's <ex>belt</ex>; a sword
<ex>belt</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The shining <qex>belt</qex> with gold inlaid.</q>
<rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>That which restrains or confines as a
girdle.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>He cannot buckle his distempered cause<br/
Within the <qex>belt</qex> of rule.</q> <rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Anything that resembles a belt, or that encircles or
crosses like a belt; a strip or stripe; <as>as, a <ex>belt</ex> of
trees; a <ex>belt</ex> of sand</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <fld>(Arch.)</fld> <def>Same as <er>Band</er>,
<pos>n.</pos>, 2. A very broad band is more properly termed a
<xex>belt</xex>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <fld>(Astron.)</fld> <def>One of certain girdles or zones
on the surface of the planets Jupiter and Saturn, supposed to be of the
nature of clouds.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <fld>(Geog.)</fld> <def>A narrow passage or strait;
<as>as, the Great <ex>Belt</ex> and the Lesser <ex>Belt</ex>, leading to
the Baltic Sea</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>7.</sn> <fld>(Her.)</fld> <def>A token or badge of knightly
rank.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>8.</sn> <fld>(Mech.)</fld> <def>A band of leather, or other
flexible substance, passing around two wheels, and communicating motion
from one to the other.</def> <note>[See <xex>Illust.</xex> of
<er>Pulley</er>.]</note><br/
[<source>1913 Webster</source>]</p>

<p><sn>9.</sn> <fld>(Nat. Hist.)</fld> <def>A band or stripe, as of
color, round any organ; or any circular ridge or series of
ridges.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Belt lacing</b></col>, <cd>thongs used for lacing
together the ends of machine belting.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Belt</ent><br/
<hw>Belt</hw>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p. p.</pos>
<conjf>Belted</conjf>; <pos>p. pr. & vb. n.</pos>
<conjf>Belting</conjf>.]</vmorph> <def>To encircle with, or as with, a
belt; to encompass; to surround.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>A coarse black robe <qex>belted</qex> round the waist.</q>
<rj><qau>C. Reade.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>They <qex>belt</qex> him round with hearts undaunted.</q>
<rj><qau>Wordsworth.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To shear, as the buttocks and tails of sheep.</def>
<mark>[Prov. Eng.]</mark> <rj><au>Halliwell.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beltane</ent><br/
<hw>Bel"tane</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[Gael.
<ets>bealltainn</ets>, <ets>bealltuinn</ets>.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <def>The first day of May (Old Style).</def><br/
[<source>1913 Webster</source>]</p>

<p><q>The quarter-days anciently in Scotland were Hallowmas, Candlemas,
<qex>Beltane</qex>, and Lammas.</q> <rj><qau>New English
Dict.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A festival of the heathen Celts on the first day of
May, in the observance of which great bonfires were kindled. It still
exists in a modified form in some parts of Scotland and
Ireland.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Belted</ent><br/
<hw>Belt"ed</hw> <pr>(<?/)</pr>, <pos>a.</pos> <sn>1.</sn>
<def>Encircled by, or secured with, a belt; <as>as, a <ex>belted</ex>
plaid</as>; girt with a belt, as an honorary distinction; <as>as, a
<ex>belted</ex> knight; a <ex>belted</ex> earl</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>Marked with a band or circle; <as>as, a
<ex>belted</ex> stalk</as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>Worn in, or suspended from, the belt.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Three men with <qex>belted</qex> brands.</q> <rj><qau>Sir W.
Scott.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Belted cattle</b></col>, <cd>cattle originally from Dutch
stock, having a broad band of white round the middle, while the rest of
the body is black; -- called also <altname>blanketed
cattle</altname>.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Beltin</ent><br/
<ent>Beltein</ent><br/
<mhw>{ <hw>Bel"tein</hw> <pr>(<?/)</pr>, <hw>Bel"tin</hw> }</mhw>
<pr>(<?/)</pr>, <pos>n.</pos> <def>See <er>Beltane</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Belting</ent><br/
<hw>Belt"ing</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>The material of
which belts for machinery are made; also, belts, taken
collectively.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>beltless</ent><br/
<hw>belt"less</hw> <pos>adj.</pos> <def>lacking a belt.</def>
<illu><ex>beltless</ex> jackets are in this season</illu>
<ant>belted</ant><br/
<syn><b>Syn. --</b> unbelted.</syn><br/
[<source>WordNet 1.5</source>]</p>

<p><-- p. 136 --></p>

<p><ent>Beluga</ent><br/
<hw>Be*lu"ga</hw> <pr>(b<esl/*l<umac/"g<adot/)</pr>, <pos>n.</pos>
<ety>[Russ. <ets>bieluga</ets> a sort of large sturgeon, prop. white
fish, fr. <ets>bieluii</ets> white. The whale is now commonly called
<ets>bieluka</ets> in Russian.]</ety> <sn>1.</sn> <fld>(Zool.)</fld>
<def>A cetacean allied to the dolphins.</def><br/
[<source>1913 Webster</source>]</p>

<p><note><hand/ The northern <xex>beluga</xex> (<spn>Delphinapterus
catodon</spn>) is the <altname>white whale</altname> and <altname>white
fish</altname> of the whalers. It grows to be from twelve to eighteen
feet long.</note><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>the sturgeon (<spn>Huso huso</spn>) native to the
Black Sea and Caspian Sea; -- also called <altname>hausen</altname>. It
is valued for its roe, sold as <prod>caviar</prod>, and is also used for
production of isinglass. See also <er>sturgeon</er>.</def><br/
[<source>PJC</source>]</p>

<p><sn>3.</sn> <def>the caviar obtained from the beluga{2}; -- also
called <altname>beluga caviar</altname>. The caviar of the
<ex>beluga</ex> is considered the finest sort, larger and of a taste
superior to that obtained from other sturgeon. See also
<er>sturgeon</er> and <er>caviar</er>.</def><br/
[<source>PJC</source>]</p>

<p><ent>Belute</ent><br/
<hw>Be*lute"</hw> <pr>(b<esl/*l<umac/t")</pr>, <pos>v. t.</pos>
<vmorph>[<pos>imp. & p. p.</pos> <conjf>Beluted</conjf>; <pos>p. pr. &
vb. n.</pos> <conjf>Beluting</conjf>.]</vmorph> <ety>[Pref.
<ets>be-</ets> + L. <ets>lutum</ets> mud.]</ety> <def>To bespatter, as
with mud.</def> <mark>[R.]</mark> <rj><au>Sterne.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Belvedere</ent><br/
<hw>Bel`ve*dere"</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[It., fr.
<ets>bello</ets>, <ets>bel</ets>, beautiful + <ets>vedere</ets> to
see.]</ety> <fld>(Arch.)</fld> <def>A small building, or a part of a
building, more or less open, constructed in a place commanding a fine
prospect.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Belzebuth</ent><br/
\'d8<hw>Bel"ze*buth</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[From
<ets>Beelzebub</ets>.]</ety> <fld>(Zool.)</fld> <def>A spider monkey
(<spn>Ateles belzebuth</spn>) of Brazil.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bema</ent><br/
\'d8<hw>Be"ma</hw> <pr>(<?/)</pr>, <pos>n.</pos> <ety>[Gr.
<ets><?/</ets> step, platform.]</ety><br/
[<source>1913 Webster</source>]</p>

<p><sn>1.</sn> <fld>(Gr. Antiq.)</fld> <def>A platform from which
speakers addressed an assembly.</def> <rj><au>Mitford.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <fld>(Arch.)</fld> <sd>(a)</sd> <def>That part of an
early Christian church which was reserved for the higher clergy; the
inner or eastern part of the chancel.</def> <sd>(b)</sd>
<def>Erroneously: A pulpit.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bemad</ent><br/
<hw>Be*mad"</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <def>To make
mad.</def> <mark>[Obs.]</mark> <rj><au>Fuller.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bemangle</ent><br/
<hw>Be*man"gle</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <def>To mangle; to
tear asunder.</def> <mark>[R.]</mark> <rj><au>Beaumont.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bemask</ent><br/
<hw>Be*mask"</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <def>To mask; to
conceal.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bemaster</ent><br/
<hw>Be*mas"ter</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <def>To master
thoroughly.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bemaul</ent><br/
<hw>Be*maul"</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <def>To maul or beat
severely; to bruise.</def> <ldquo/In order to <xex>bemaul</xex>
Yorick.<rdquo/ <rj><au>Sterne.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bemaze</ent><br/
<hw>Be*maze</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <ety>[OE.
<ets>bimasen</ets>; pref. <ets>be-</ets> + <ets>masen</ets> to
maze.]</ety> <def>To bewilder.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Intellects <qex>bemazed</qex> in endless doubt.</q>
<rj><qau>Cowper.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bemean</ent><br/
<hw>Be*mean"</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <def>To make mean; to
lower.</def> <rj><au>C. Reade.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bemeet</ent><br/
<hw>Be*meet"</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. &
p. p.</pos> <conjf>Bemet</conjf> <pr>(<?/)</pr>; <pos>p. pr. & vb.
n.</pos> <conjf>Bemeeting</conjf>.]</vmorph> <def>To meet.</def>
<mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><q>Our very loving sister, well <qex>bemet</qex>.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bemete</ent><br/
<hw>Be*mete"</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <def>To mete.</def>
<mark>[Obs.]</mark> <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bemingle</ent><br/
<hw>Be*min"gle</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <def>To mingle; to
mix.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bemire</ent><br/
<hw>Be*mire"</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. &
p. p.</pos> <conjf>Bemired</conjf> <pr>(<?/)</pr>; <pos>p. pr. & vb.
n.</pos> <conjf>Bemiring</conjf>.]</vmorph> <def>To drag through,
encumber with, or fix in, the mire; to soil by passing through mud or
dirt.</def><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>Bemired</qex> and benighted in the dog.</q>
<rj><qau>Burke.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bemist</ent><br/
<hw>Be*mist"</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <def>To envelop in
mist.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bemoan</ent><br/
<hw>Be*moan"</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. &
p. p.</pos> <conjf>Bemoaned</conjf> <pr>(<?/)</pr>; <pos>p. pr. & vb.
n.</pos> <conjf>Bemoaning</conjf>.]</vmorph> <ety>[OE.
<ets>bimenen</ets>, AS. <ets>bem<?/nan</ets>; pref. <ets>be-</ets> +
<ets>m<aemac/nan</ets> to moan. See <er>Moan</er>.]</ety> <def>To
express deep grief for by moaning; to express sorrow for; to lament; to
bewail; to pity or sympathize with.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Implores their pity, and his pain <qex>bemoans</qex>.</q>
<rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><syn><b>Syn.</b> -- See <er>Deplore</er>.</syn><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bemoaner</ent><br/
<hw>Be*moan"er</hw> <pr>(<?/)</pr>, <pos>n.</pos> <def>One who
bemoans.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bemock</ent><br/
<hw>Be*mock"</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <def>To mock; to
ridicule.</def><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>Bemock</qex> the modest moon.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bemoil</ent><br/
<hw>Be*moil"</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <ety>[Pref.
<ets>be-</ets> + <ets>moil</ets>, fr. F. <ets>mouiller</ets> to wet; but
cf. also OE. <ets>bimolen</ets> to soil, fr. AS. <ets>m<amac/l</ets>
spot: cf. E. <ets>mole</ets>.]</ety> <def>To soil or encumber with mire
and dirt.</def> <mark>[Obs.]</mark> <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bemol</ent><br/
<hw>Be"mol</hw> <pr>(b<emac/"m<ocr/l)</pr>, <pos>n.</pos> <ety>[F.
<ets>b<eacute/mol</ets>, fr. <ets>b<eacute/</ets> <flat/ +
<ets>mol</ets> soft.]</ety> <fld>(Mus.)</fld> <def>The sign <flat/; the
same as B flat.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bemonster</ent><br/
<hw>Be*mon"ster</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <def>To make
monstrous or like a monster.</def> <mark>[Obs.]</mark>
<rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bemourn</ent><br/
<hw>Be*mourn"</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <def>To mourn
over.</def> <rj><au>Wyclif.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bemuddle</ent><br/
<hw>Be*mud"dle</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <def>To muddle; to
stupefy or bewilder; to confuse.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bemuffle</ent><br/
<hw>Be*muf"fle</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <def>To cover as
with a muffler; to wrap up.</def><br/
[<source>1913 Webster</source>]</p>

<p><q><qex>Bemuffled</qex> with the externals of religion.</q>
<rj><qau>Sterne.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bemuse</ent><br/
<hw>Be*muse"</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <def>To muddle, daze,
or partially stupefy, as with liquor.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>A parson much <qex>bemused</qex> in beer.</q>
<rj><qau>Pope.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ben nut</ent><br/
<ent>Ben</ent><br/
<mhw>{ <hw>Ben</hw> <pr>(<?/)</pr>, <hw>Ben" nut`</hw> }</mhw>
<pr>(<?/)</pr>. <ety>[Ar. <ets>b<amac/n</ets>, name of the tree.]</ety>
<fld>(Bot.)</fld> <def>The seed of one or more species of moringa;
<as>as, oil of <ex>ben</ex></as>. See <er>Moringa</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ben</ent><br/
<hw>Ben</hw>, <pos>adv. & prep.</pos> <ety>[AS. <ets>binnan</ets>; pref.
<ets>be-</ets> by + <ets>innan</ets> within, <ets>in</ets> in.]</ety>
<def>Within; in; in or into the interior; toward the inner
apartment.</def> <mark>[Scot.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ben</ent><br/
<hw>Ben</hw>, <pos>n.</pos> <ety>[See <er>Ben</er>,
<pos>adv.</pos>]</ety> <def>The inner or principal room in a hut or
house of two rooms; -- opposed to <contr>but</contr>, the outer
apartment.</def> <mark>[Scot.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Ben</ent><br/
<hw>Ben</hw>. <def>An old form of the <pos>pl. indic. pr.</pos> of
<er>Be</er>.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bename</ent><br/
<hw>Be*name"</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <vmorph>[<pos>p.
p.</pos> <conjf>Benamed</conjf>, <conjf>Benempt</conjf>.]</vmorph>
<def>To promise; to name.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bench</ent><br/
<hw>Bench</hw> <pr>(<?/)</pr>, <pos>n.</pos>; <plu><it>pl.</it>
<plw>Benches</plw> <pr>(<?/)</pr>.</plu> <ety>[OE. <ets>bench</ets>,
<ets>benk</ets>, AS. <ets>benc</ets>; akin to Sw. <ets>b<aum/nk</ets>,
Dan <ets>b<ae/nk</ets>, Icel. <ets>bekkr</ets>, OS., D., & G.
<ets>bank</ets>. Cf. <er>Bank</er>, <er>Beach</er>.]</ety> <sn>1.</sn>
<def>A long seat, differing from a stool in its greater
length.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Mossy <qex>benches</qex> supplied the place of chairs.</q>
<rj><qau>Sir W. Scott.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>A long table at which mechanics and other work;
<as>as, a carpenter's <ex>bench</ex></as>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>The seat where judges sit in court.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>To pluck down justice from your awful <qex>bench</qex>.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>The persons who sit as judges; the court; <as>as,
the opinion of the full <ex>bench</ex></as>. See <er>King's
Bench</er>.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>5.</sn> <def>A collection or group of dogs exhibited to the
public; -- so named because the animals are usually placed on benches or
raised platforms.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>6.</sn> <def>A conformation like a bench; a long stretch of flat
ground, or a kind of natural terrace, near a lake or river.</def><br/
[<source>1913 Webster</source>]</p>

<p><cs><col><b>Bench mark</b></col> <fld>(Leveling)</fld>, <cd>one of a
number of marks along a line of survey, affixed to permanent objects, to
show where leveling staffs were placed. See <er>bench mark</er> in the
vocabulary.</cd> -- <col><b>Bench of bishops</b></col>, <cd>the whole
body of English prelates assembled in council.</cd> -- <col><b>Bench
plane</b></col>, <cd>any plane used by carpenters and joiners for
working a flat surface, as jack planes, long planes.</cd> --
<col><b>Bench show</b></col>, <cd>an exhibition of dogs.</cd> --
<col><b>Bench table</b></col> <fld>(Arch.)</fld>, <cd>a projecting
course at the base of a building, or round a pillar, sufficient to form
a seat.</cd></cs><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bench</ent><br/
<hw>Bench</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p.
p.</pos> <conjf>Benched</conjf> <pr>(<?/)</pr>; <pos>p. pr. & vb.
n.</pos> <conjf>Benching</conjf>.]</vmorph> <sn>1.</sn> <def>To furnish
with benches.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>'T was <qex>benched</qex> with turf.</q>
<rj><qau>Dryden.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><q>Stately theaters <qex>benched</qex> crescentwise.</q>
<rj><qau>Tennyson.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>To place on a bench or seat of honor.</def><br/
[<source>1913 Webster</source>]</p>

<p><q>Whom I . . . have <qex>benched</qex> and reared to worship.</q>
<rj><qau>Shak.</qau></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bench</ent><br/
<hw>Bench</hw>, <pos>v. i.</pos> <def>To sit on a seat of justice.</def>
<mark>[R.]</mark> <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bencher</ent><br/
<hw>Bench"er</hw> <pr>(<?/)</pr>, <pos>n.</pos> <sn>1.</sn> <fld>(Eng.
Law)</fld> <def>One of the senior and governing members of an Inn of
Court.</def><br/
[<source>1913 Webster</source>]</p>

<p><sn>2.</sn> <def>An alderman of a corporation.</def>
<mark>[Eng.]</mark> <rj><au>Ashmole.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>3.</sn> <def>A member of a court or council.</def>
<mark>[Obs.]</mark> <rj><au>Shak.</au></rj><br/
[<source>1913 Webster</source>]</p>

<p><sn>4.</sn> <def>One who frequents the benches of a tavern; an
idler.</def> <mark>[Obs.]</mark><br/
[<source>1913 Webster</source>]</p>

<p><ent>bench mark</ent><br/
<ent>benchmark</ent><br/
<mhw><hw>benchmark</hw>, <hw>bench mark</hw></mhw>.
<fld>(Surveying)</fld> <sn>1.</sn> <def>Any permanent mark to which
other levels may be referred.</def> <specif>such as</specif>:
<sd>(a)</sd> <def>A horizontal mark at the water's edge with reference
to which the height of tides and floods may be measured.</def>
<sd>(b)</sd> <def>a surveyer's mark on a permanent object of
predetermined position and elevation used as a reference
point.</def><br/
[<source>Webster 1913 Suppl.</source> + <source>WordNet 1.5</source>]</p>

<p><sn>2.</sn> <def>something serving as a standard by which related
items may be judged; <as>as, his painting sets the <ex>benchmark</ex> of
quality</as>.</def><br/
[<source>PJC</source> + <source>WordNet 1.5</source>]</p>

<p><sn>3.</sn> <def>a test or series of tests designed to compare the
qualities or performance of different devices of the same type. Certain
sets of computer programs are much used as <ex>benchmarks</ex> for
comparing the performance of different computers, especially by
comparing the time it takes to complete a test.</def><br/
[<source>PJC</source>]</p>

<p><ent>Bench warrant</ent><br/
<hw>Bench" war`rant</hw> <pr>(<?/)</pr>. <fld>(Law)</fld> <def>A process
issued by a presiding judge or by a court against a person guilty of
some contempt, or indicted for some crime; -- so called in distinction
from a <xex>justice's warrant</xex>.</def><br/
[<source>1913 Webster</source>]</p>

<p><ent>Bend</ent><br/
<hw>Bend</hw> <pr>(<?/)</pr>, <pos>v. t.</pos> <vmorph>[<pos>imp. & p.
p.</pos> <conjf>Bended</conjf> or <conjf>Bent</conjf> <pr>(<?/)</pr>;
<pos>p. pr. & vb. n.</pos> <conjf>Bending</conjf>.]</vmorph> <ety>[AS.
<ets>bendan</ets> to bend, fr. <ets>bend<