/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.RadiotapPacket;
import org.pcap4j.util.ByteArrays;

public final class RadiotapDataAntennaNoise
implements RadiotapPacket.RadiotapData {
    private static final long serialVersionUID = -7455538178480770078L;
    private static final int LENGTH = 1;
    private final byte antennaNoise;

    public static RadiotapDataAntennaNoise newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new RadiotapDataAntennaNoise(rawData, offset, length);
    }

    private RadiotapDataAntennaNoise(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        if (length < 1) {
            StringBuilder sb = new StringBuilder(200);
            sb.append("The data is too short to build a RadiotapAntennaNoise (").append(1).append(" bytes). data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
            throw new IllegalRawDataException(sb.toString());
        }
        this.antennaNoise = ByteArrays.getByte(rawData, offset);
    }

    private RadiotapDataAntennaNoise(Builder builder2) {
        if (builder2 == null) {
            throw new NullPointerException("builder is null.");
        }
        this.antennaNoise = builder2.antennaNoise;
    }

    public byte getAntennaNoise() {
        return this.antennaNoise;
    }

    public int getAntennaNoiseAsInt() {
        return this.antennaNoise;
    }

    @Override
    public int length() {
        return 1;
    }

    @Override
    public byte[] getRawData() {
        return ByteArrays.toByteArray(this.antennaNoise);
    }

    public Builder getBuilder() {
        return new Builder(this);
    }

    public String toString() {
        return this.toString("");
    }

    @Override
    public String toString(String indent) {
        StringBuilder sb = new StringBuilder();
        String ls = System.getProperty("line.separator");
        sb.append(indent).append("Antenna noise: ").append(ls).append(indent).append("  Antenna noise: ").append(this.antennaNoise).append(" dBm").append(ls);
        return sb.toString();
    }

    public int hashCode() {
        return this.antennaNoise;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        RadiotapDataAntennaNoise other = (RadiotapDataAntennaNoise)obj;
        return this.antennaNoise == other.antennaNoise;
    }

    public static final class Builder {
        private byte antennaNoise;

        public Builder() {
        }

        private Builder(RadiotapDataAntennaNoise obj) {
            this.antennaNoise = obj.antennaNoise;
        }

        public Builder antennaNoise(byte antennaNoise) {
            this.antennaNoise = antennaNoise;
            return this;
        }

        public RadiotapDataAntennaNoise build() {
            return new RadiotapDataAntennaNoise(this);
        }
    }
}

