/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import org.openstreetmap.josm.actions.mapmode.DrawAction;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.IOsmDataManager;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.OsmData;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;

public final class OsmDataManager
implements IOsmDataManager {
    private OsmDataManager() {
    }

    public static OsmDataManager getInstance() {
        return InstanceHolder.INSTANCE;
    }

    @Override
    public Collection<OsmPrimitive> getInProgressSelection() {
        MapFrame map = MainApplication.getMap();
        if (map != null && map.mapMode instanceof DrawAction) {
            return ((DrawAction)map.mapMode).getInProgressSelection();
        }
        DataSet ds = MainApplication.getLayerManager().getActiveDataSet();
        if (ds == null) {
            return Collections.emptyList();
        }
        return ds.getSelected();
    }

    @Override
    public Collection<? extends IPrimitive> getInProgressISelection() {
        MapFrame map = MainApplication.getMap();
        if (map != null && map.mapMode instanceof DrawAction) {
            return ((DrawAction)map.mapMode).getInProgressSelection();
        }
        OsmData<?, ?, ?, ?> ds = MainApplication.getLayerManager().getActiveData();
        if (ds == null) {
            return Collections.emptyList();
        }
        return ds.getSelected();
    }

    @Override
    public DataSet getEditDataSet() {
        return MainApplication.getLayerManager().getEditDataSet();
    }

    @Override
    public DataSet getActiveDataSet() {
        return MainApplication.getLayerManager().getActiveDataSet();
    }

    @Override
    public void setActiveDataSet(DataSet ds) {
        Optional<OsmDataLayer> layer = MainApplication.getLayerManager().getLayersOfType(OsmDataLayer.class).stream().filter(l -> l.data.equals(ds)).findFirst();
        layer.ifPresent(osmDataLayer -> MainApplication.getLayerManager().setActiveLayer((Layer)osmDataLayer));
    }

    @Override
    public boolean containsDataSet(DataSet ds) {
        return MainApplication.getLayerManager().getLayersOfType(OsmDataLayer.class).stream().anyMatch(l -> l.data.equals(ds));
    }

    private static final class InstanceHolder {
        static final OsmDataManager INSTANCE = new OsmDataManager();

        private InstanceHolder() {
        }
    }
}

