/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.broker.jwtauthorizationgrant;

import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.broker.jwtauthorizationgrant.JWTAuthorizationGrantConfig;
import org.keycloak.broker.jwtauthorizationgrant.JWTAuthorizationGrantIdentityProviderConfig;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.broker.provider.IdentityBrokerException;
import org.keycloak.broker.provider.JWTAuthorizationGrantProvider;
import org.keycloak.crypto.KeyWrapper;
import org.keycloak.crypto.SignatureProvider;
import org.keycloak.jose.jws.JWSHeader;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.keys.loader.PublicKeyStorageManager;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.protocol.oidc.JWTAuthorizationGrantValidationContext;
import org.keycloak.services.Urls;
import org.keycloak.utils.StringUtil;

public class JWTAuthorizationGrantIdentityProvider
implements JWTAuthorizationGrantProvider<JWTAuthorizationGrantIdentityProviderConfig> {
    private static final Logger LOGGER = Logger.getLogger(JWTAuthorizationGrantIdentityProvider.class);
    private final KeycloakSession session;
    private final JWTAuthorizationGrantConfig config;

    public JWTAuthorizationGrantIdentityProvider(KeycloakSession session, JWTAuthorizationGrantConfig config) {
        this.session = session;
        this.config = config;
    }

    public BrokeredIdentityContext validateAuthorizationGrantAssertion(JWTAuthorizationGrantValidationContext context) throws IdentityBrokerException {
        if (!this.verifySignature(context.getJws())) {
            throw new IdentityBrokerException("Invalid signature");
        }
        BrokeredIdentityContext user = new BrokeredIdentityContext(context.getJWT().getSubject(), (IdentityProviderModel)this.getConfig());
        user.setUsername(context.getJWT().getSubject());
        return user;
    }

    public int getAllowedClockSkew() {
        return this.config.getJWTAuthorizationGrantAllowedClockSkew();
    }

    public boolean isAssertionReuseAllowed() {
        return this.config.isJWTAuthorizationGrantAssertionReuseAllowed();
    }

    public List<String> getAllowedAudienceForJWTGrant() {
        RealmModel realm = this.session.getContext().getRealm();
        URI baseUri = this.session.getContext().getUri().getBaseUri();
        String issuer = Urls.realmIssuer(baseUri, realm.getName());
        String tokenEndpoint = Urls.tokenEndpoint(baseUri, realm.getName()).toString();
        return List.of(issuer, tokenEndpoint);
    }

    public int getMaxAllowedExpiration() {
        return this.config.getJWTAuthorizationGrantMaxAllowedAssertionExpiration();
    }

    public String getAssertionSignatureAlg() {
        String alg = this.config.getJWTAuthorizationGrantAssertionSignatureAlg();
        return StringUtil.isBlank((String)alg) ? null : alg;
    }

    public boolean isLimitAccessTokenExpiration() {
        return this.getConfig().isJwtAuthorizationGrantLimitAccessTokenExp();
    }

    public JWTAuthorizationGrantIdentityProviderConfig getConfig() {
        return this.config instanceof JWTAuthorizationGrantIdentityProviderConfig ? (JWTAuthorizationGrantIdentityProviderConfig)this.config : null;
    }

    private boolean verifySignature(JWSInput jws) {
        try {
            JWSHeader header = jws.getHeader();
            String alg = header.getRawAlgorithm();
            KeyWrapper publicKey = PublicKeyStorageManager.getIdentityProviderKeyWrapper(this.session, this.session.getContext().getRealm(), this.getConfig(), jws);
            if (publicKey == null) {
                LOGGER.debugf("Failed to verify token, key not found for algorithm %s", (Object)alg);
                return false;
            }
            SignatureProvider signatureProvider = (SignatureProvider)this.session.getProvider(SignatureProvider.class, alg);
            if (signatureProvider == null) {
                LOGGER.debugf("Failed to verify token signature, signature provider not found for algorithm %s", (Object)alg);
                return false;
            }
            return signatureProvider.verifier(publicKey).verify(jws.getEncodedSignatureInput().getBytes(StandardCharsets.UTF_8), jws.getSignature());
        }
        catch (Exception e) {
            LOGGER.debug((Object)"Failed to verify token signature", (Throwable)e);
            return false;
        }
    }

    public void close() {
    }
}

