/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.broker.provider;

import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.Arrays;
import java.util.List;
import org.keycloak.broker.provider.IdentityProviderMapper;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.RealmModel;
import org.keycloak.provider.Provider;

public interface IdentityProvider<C extends IdentityProviderModel>
extends Provider {
    public C getConfig();

    default public Response export(UriInfo uriInfo, RealmModel realm, String format) {
        return Response.noContent().build();
    }

    default public boolean isMapperSupported(IdentityProviderMapper mapper) {
        List<String> compatibleIdps = Arrays.asList(mapper.getCompatibleProviders());
        return compatibleIdps.contains("*") || compatibleIdps.contains(this.getConfig().getProviderId());
    }

    default public boolean reloadKeys() {
        return false;
    }
}

