/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.sql.BatchUpdateException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mariadb.jdbc.MariaDbConnection;
import org.mariadb.jdbc.internal.com.read.dao.Results;
import org.mariadb.jdbc.internal.com.read.resultset.SelectResultSet;
import org.mariadb.jdbc.internal.logging.Logger;
import org.mariadb.jdbc.internal.logging.LoggerFactory;
import org.mariadb.jdbc.internal.protocol.Protocol;
import org.mariadb.jdbc.internal.util.Utils;
import org.mariadb.jdbc.internal.util.exceptions.ExceptionFactory;
import org.mariadb.jdbc.internal.util.scheduler.SchedulerServiceProviderHolder;
import org.mariadb.jdbc.util.Options;

public class MariaDbStatement
implements Statement,
Cloneable {
    private static final Pattern identifierPattern = Pattern.compile("[0-9a-zA-Z\\$_\\u0080-\\uFFFF]*", 192);
    private static final Pattern escapePattern = Pattern.compile("[\u0000'\"\b\n\r\t\u001a\\\\]");
    private static final Map<String, String> mapper = new HashMap<String, String>();
    private static final Logger logger = LoggerFactory.getLogger(MariaDbStatement.class);
    protected final ReentrantLock lock;
    protected final int resultSetScrollType;
    protected final int resultSetConcurrency;
    protected final Options options;
    protected final boolean canUseServerTimeout;
    protected Protocol protocol;
    protected MariaDbConnection connection;
    protected volatile boolean closed = false;
    protected int queryTimeout;
    protected long maxRows;
    protected Results results;
    protected int fetchSize;
    protected volatile boolean executing;
    protected ExceptionFactory exceptionFactory;
    private ScheduledExecutorService timeoutScheduler;
    private boolean warningsCleared;
    private boolean mustCloseOnCompletion = false;
    private List<String> batchQueries;
    private Future<?> timerTaskFuture;
    private boolean isTimedout;
    private int maxFieldSize;
    private boolean escape = true;

    public MariaDbStatement(MariaDbConnection connection, int resultSetScrollType, int resultSetConcurrency, ExceptionFactory exceptionFactory) {
        this.protocol = connection.getProtocol();
        this.connection = connection;
        this.canUseServerTimeout = connection.canUseServerTimeout();
        this.resultSetScrollType = resultSetScrollType;
        this.resultSetConcurrency = resultSetConcurrency;
        this.lock = this.connection.lock;
        this.options = this.protocol.getOptions();
        this.exceptionFactory = exceptionFactory;
        this.fetchSize = this.options.defaultFetchSize;
    }

    public MariaDbStatement clone(MariaDbConnection connection) throws CloneNotSupportedException {
        MariaDbStatement clone = (MariaDbStatement)super.clone();
        clone.connection = connection;
        clone.protocol = connection.getProtocol();
        clone.timerTaskFuture = null;
        clone.batchQueries = new ArrayList<String>();
        clone.closed = false;
        clone.warningsCleared = true;
        clone.maxRows = 0L;
        clone.fetchSize = this.options.defaultFetchSize;
        clone.exceptionFactory = ExceptionFactory.of(this.exceptionFactory.getThreadId(), this.exceptionFactory.getOptions());
        return clone;
    }

    protected void setTimerTask(boolean isBatch) {
        assert (this.timerTaskFuture == null);
        if (this.timeoutScheduler == null) {
            this.timeoutScheduler = SchedulerServiceProviderHolder.getTimeoutScheduler();
        }
        this.timerTaskFuture = this.timeoutScheduler.schedule(() -> {
            try {
                this.isTimedout = true;
                if (!isBatch) {
                    this.protocol.cancelCurrentQuery();
                }
                this.protocol.interrupt();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }, (long)this.queryTimeout, TimeUnit.SECONDS);
    }

    protected void executeQueryPrologue(boolean isBatch) throws SQLException {
        this.executing = true;
        if (this.closed) {
            throw this.exceptionFactory.raiseStatementError(this.connection, this).create("execute() is called on closed statement");
        }
        this.protocol.prolog(this.maxRows, this.protocol.getProxy() != null, this.connection, this);
        if (this.queryTimeout != 0 && (!this.canUseServerTimeout || isBatch)) {
            this.setTimerTask(isBatch);
        }
    }

    private void stopTimeoutTask() {
        if (this.timerTaskFuture != null) {
            if (!this.timerTaskFuture.cancel(true)) {
                try {
                    this.timerTaskFuture.get();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException executionException) {
                    // empty catch block
                }
            }
            this.timerTaskFuture = null;
        }
    }

    protected SQLException executeExceptionEpilogue(SQLException sqle) {
        if (sqle.getSQLState() != null && sqle.getSQLState().startsWith("08")) {
            try {
                this.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (sqle.getErrorCode() == 1148 && !this.options.allowLocalInfile) {
            return this.exceptionFactory.raiseStatementError(this.connection, this).create("Usage of LOCAL INFILE is disabled. To use it enable it via the connection property allowLocalInfile=true", "42000", 1148, sqle);
        }
        if (this.isTimedout) {
            return this.exceptionFactory.raiseStatementError(this.connection, this).create("Query timed out", "70100", 1317, sqle);
        }
        SQLException sqlException = this.exceptionFactory.raiseStatementError(this.connection, this).create(sqle);
        logger.error("error executing query", sqlException);
        return sqlException;
    }

    protected void executeEpilogue() {
        this.stopTimeoutTask();
        this.isTimedout = false;
        this.executing = false;
    }

    protected void executeBatchEpilogue() {
        this.executing = false;
        this.stopTimeoutTask();
        this.isTimedout = false;
        this.clearBatch();
    }

    private SQLException handleFailoverAndTimeout(SQLException sqle) {
        if (sqle.getSQLState() != null && sqle.getSQLState().startsWith("08")) {
            try {
                this.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (this.isTimedout) {
            return this.exceptionFactory.raiseStatementError(this.connection, this).create("Query timed out", "70100", 1317, sqle);
        }
        return sqle;
    }

    protected BatchUpdateException executeBatchExceptionEpilogue(SQLException initialSqle, int size) {
        int[] ret;
        SQLException sqle = this.handleFailoverAndTimeout(initialSqle);
        if (this.results == null || !this.results.commandEnd()) {
            ret = new int[size];
            Arrays.fill(ret, -3);
        } else {
            ret = this.results.getCmdInformation().getUpdateCounts();
        }
        sqle = this.exceptionFactory.raiseStatementError(this.connection, this).create(sqle);
        logger.error("error executing query", sqle);
        return new BatchUpdateException(sqle.getMessage(), sqle.getSQLState(), sqle.getErrorCode(), ret, (Throwable)sqle);
    }

    private boolean executeInternal(String sql, int fetchSize, int autoGeneratedKeys) throws SQLException {
        this.lock.lock();
        try {
            this.executeQueryPrologue(false);
            this.results = new Results(this, fetchSize, false, 1, false, this.resultSetScrollType, this.resultSetConcurrency, autoGeneratedKeys, this.protocol.getAutoIncrementIncrement(), sql, null);
            this.protocol.executeQuery(this.protocol.isMasterConnection(), this.results, this.getTimeoutSql(this.nativeSql(sql, this.protocol)));
            this.results.commandEnd();
            boolean bl = this.results.getResultSet() != null;
            return bl;
        }
        catch (SQLException exception) {
            throw this.executeExceptionEpilogue(exception);
        }
        finally {
            this.executeEpilogue();
            this.lock.unlock();
        }
    }

    @Override
    public String enquoteLiteral(String val) throws SQLException {
        Matcher matcher = escapePattern.matcher(val);
        StringBuffer escapedVal = new StringBuffer("'");
        while (matcher.find()) {
            matcher.appendReplacement(escapedVal, mapper.get(matcher.group()));
        }
        matcher.appendTail(escapedVal);
        escapedVal.append("'");
        return escapedVal.toString();
    }

    @Override
    public String enquoteIdentifier(String identifier, boolean alwaysQuote) throws SQLException {
        if (this.isSimpleIdentifier(identifier)) {
            return alwaysQuote ? "`" + identifier + "`" : identifier;
        }
        if (identifier.contains("\u0000")) {
            throw this.exceptionFactory.raiseStatementError(this.connection, this).create("Invalid name - containing u0000 character", "42000");
        }
        if (identifier.matches("^`.+`$")) {
            identifier = identifier.substring(1, identifier.length() - 1);
        }
        return "`" + identifier.replace("`", "``") + "`";
    }

    @Override
    public boolean isSimpleIdentifier(String identifier) throws SQLException {
        return identifier != null && !identifier.isEmpty() && identifierPattern.matcher(identifier).matches();
    }

    @Override
    public String enquoteNCharLiteral(String val) throws SQLException {
        return "N'" + val.replace("'", "''") + "'";
    }

    private String getTimeoutSql(String sql) {
        if (this.queryTimeout != 0 && this.canUseServerTimeout) {
            return "SET STATEMENT max_statement_time=" + this.queryTimeout + " FOR " + sql;
        }
        return sql;
    }

    private String nativeSql(String sql, Protocol protocol) throws SQLException {
        return this.escape ? Utils.nativeSql(sql, protocol) : sql;
    }

    public boolean testExecute(String sql, Charset charset) throws SQLException {
        this.lock.lock();
        try {
            this.executeQueryPrologue(false);
            this.results = new Results(this, this.fetchSize, false, 1, false, this.resultSetScrollType, this.resultSetConcurrency, 2, this.protocol.getAutoIncrementIncrement(), sql, null);
            this.protocol.executeQuery(this.protocol.isMasterConnection(), this.results, this.getTimeoutSql(this.nativeSql(sql, this.protocol)), charset);
            this.results.commandEnd();
            boolean bl = this.results.getResultSet() != null;
            return bl;
        }
        catch (SQLException exception) {
            throw this.executeExceptionEpilogue(exception);
        }
        finally {
            this.executeEpilogue();
            this.lock.unlock();
        }
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        return this.executeInternal(sql, this.fetchSize, 2);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return this.executeInternal(sql, this.fetchSize, autoGeneratedKeys);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return this.executeInternal(sql, this.fetchSize, 1);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return this.executeInternal(sql, this.fetchSize, 1);
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        if (this.executeInternal(sql, this.fetchSize, 2)) {
            return this.results.getResultSet();
        }
        return SelectResultSet.createEmptyResultSet();
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        if (this.executeInternal(sql, this.fetchSize, 2)) {
            return 0;
        }
        return this.getUpdateCount();
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        if (this.executeInternal(sql, this.fetchSize, autoGeneratedKeys)) {
            return 0;
        }
        return this.getUpdateCount();
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return this.executeUpdate(sql, 1);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return this.executeUpdate(sql, 1);
    }

    @Override
    public long executeLargeUpdate(String sql) throws SQLException {
        if (this.executeInternal(sql, this.fetchSize, 2)) {
            return 0L;
        }
        return this.getLargeUpdateCount();
    }

    @Override
    public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        if (this.executeInternal(sql, this.fetchSize, autoGeneratedKeys)) {
            return 0L;
        }
        return this.getLargeUpdateCount();
    }

    @Override
    public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return this.executeLargeUpdate(sql, 1);
    }

    @Override
    public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        return this.executeLargeUpdate(sql, 1);
    }

    @Override
    public void close() throws SQLException {
        this.lock.lock();
        try {
            this.closed = true;
            if (this.results != null) {
                if (this.results.getFetchSize() != 0) {
                    this.skipMoreResults();
                }
                this.results.close();
            }
            if (this.connection == null || this.connection.pooledConnection == null || this.connection.pooledConnection.noStmtEventListeners()) {
                return;
            }
            this.connection.pooledConnection.fireStatementClosed(this);
        }
        finally {
            this.protocol = null;
            this.connection = null;
            this.lock.unlock();
        }
    }

    @Override
    public int getMaxFieldSize() {
        return this.maxFieldSize;
    }

    @Override
    public void setMaxFieldSize(int max) {
        this.maxFieldSize = max;
    }

    @Override
    public int getMaxRows() {
        return (int)this.maxRows;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        if (max < 0) {
            throw this.exceptionFactory.raiseStatementError(this.connection, this).create("max rows cannot be negative : asked for " + max, "42000");
        }
        this.maxRows = max;
    }

    @Override
    public long getLargeMaxRows() {
        return this.maxRows;
    }

    @Override
    public void setLargeMaxRows(long max) throws SQLException {
        if (max < 0L) {
            throw this.exceptionFactory.raiseStatementError(this.connection, this).create("max rows cannot be negative : setLargeMaxRows value is " + max, "42000");
        }
        this.maxRows = max;
    }

    @Override
    public void setEscapeProcessing(boolean enable) {
        this.escape = enable;
    }

    @Override
    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        if (seconds < 0) {
            throw this.exceptionFactory.raiseStatementError(this.connection, this).create("Query timeout cannot be negative : asked for " + seconds, "42000");
        }
        this.queryTimeout = seconds;
    }

    public void setLocalInfileInputStream(InputStream inputStream) throws SQLException {
        this.checkClose();
        this.protocol.setLocalInfileInputStream(inputStream);
    }

    @Override
    public void cancel() throws SQLException {
        block9: {
            this.checkClose();
            boolean locked = this.lock.tryLock();
            try {
                if (this.executing) {
                    this.protocol.cancelCurrentQuery();
                    break block9;
                }
                if (this.results == null || this.results.getFetchSize() == 0 || this.results.isFullyLoaded(this.protocol)) break block9;
                try {
                    this.protocol.cancelCurrentQuery();
                    this.skipMoreResults();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                this.results.removeFetchSize();
            }
            catch (SQLException e) {
                logger.error("error cancelling query", e);
                throw this.exceptionFactory.raiseStatementError(this.connection, this).create(e);
            }
            finally {
                if (locked) {
                    this.lock.unlock();
                }
            }
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkClose();
        if (!this.warningsCleared) {
            return this.connection.getWarnings();
        }
        return null;
    }

    @Override
    public void clearWarnings() {
        this.warningsCleared = true;
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        throw this.exceptionFactory.raiseStatementError(this.connection, this).notSupported("Cursors are not supported");
    }

    @Override
    public MariaDbConnection getConnection() {
        return this.connection;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        if (this.results != null) {
            return this.results.getGeneratedKeys(this.protocol);
        }
        return SelectResultSet.createEmptyResultSet();
    }

    @Override
    public int getResultSetHoldability() {
        return 1;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public boolean isPoolable() {
        return false;
    }

    @Override
    public void setPoolable(boolean poolable) {
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.checkClose();
        return this.results != null ? this.results.getResultSet() : null;
    }

    @Override
    public int getUpdateCount() {
        if (this.results != null && this.results.getCmdInformation() != null && !this.results.isBatch()) {
            return this.results.getCmdInformation().getUpdateCount();
        }
        return -1;
    }

    @Override
    public long getLargeUpdateCount() {
        if (this.results != null && this.results.getCmdInformation() != null && !this.results.isBatch()) {
            return this.results.getCmdInformation().getLargeUpdateCount();
        }
        return -1L;
    }

    protected void skipMoreResults() throws SQLException {
        try {
            this.protocol.skip();
            this.warningsCleared = false;
            this.connection.reenableWarnings();
        }
        catch (SQLException e) {
            logger.debug("error skipMoreResults", e);
            throw this.exceptionFactory.raiseStatementError(this.connection, this).create(e);
        }
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.getMoreResults(1);
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        this.checkClose();
        return this.results != null && this.results.getMoreResults(current, this.protocol);
    }

    @Override
    public int getFetchDirection() {
        return 1000;
    }

    @Override
    public void setFetchDirection(int direction) {
    }

    @Override
    public int getFetchSize() {
        return this.fetchSize;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        if (rows < 0 && rows != Integer.MIN_VALUE) {
            throw this.exceptionFactory.raiseStatementError(this.connection, this).create("invalid fetch size");
        }
        if (rows == Integer.MIN_VALUE) {
            this.fetchSize = 1;
            return;
        }
        this.fetchSize = rows;
    }

    @Override
    public int getResultSetConcurrency() {
        return this.resultSetConcurrency;
    }

    @Override
    public int getResultSetType() {
        return this.resultSetScrollType;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        if (this.batchQueries == null) {
            this.batchQueries = new ArrayList<String>();
        }
        if (sql == null) {
            throw this.exceptionFactory.raiseStatementError(this.connection, this).create("null cannot be set to addBatch( String sql)");
        }
        this.batchQueries.add(sql);
    }

    @Override
    public void clearBatch() {
        if (this.batchQueries != null) {
            this.batchQueries.clear();
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        int size;
        this.checkClose();
        if (this.batchQueries == null || (size = this.batchQueries.size()) == 0) {
            return new int[0];
        }
        this.lock.lock();
        try {
            this.internalBatchExecution(size);
            int[] nArray = this.results.getCmdInformation().getUpdateCounts();
            return nArray;
        }
        catch (SQLException initialSqlEx) {
            throw this.executeBatchExceptionEpilogue(initialSqlEx, size);
        }
        finally {
            this.executeBatchEpilogue();
            this.lock.unlock();
        }
    }

    @Override
    public long[] executeLargeBatch() throws SQLException {
        int size;
        this.checkClose();
        if (this.batchQueries == null || (size = this.batchQueries.size()) == 0) {
            return new long[0];
        }
        this.lock.lock();
        try {
            this.internalBatchExecution(size);
            long[] lArray = this.results.getCmdInformation().getLargeUpdateCounts();
            return lArray;
        }
        catch (SQLException initialSqlEx) {
            throw this.executeBatchExceptionEpilogue(initialSqlEx, size);
        }
        finally {
            this.executeBatchEpilogue();
            this.lock.unlock();
        }
    }

    private void internalBatchExecution(int size) throws SQLException {
        this.executeQueryPrologue(true);
        this.results = new Results(this, 0, true, size, false, this.resultSetScrollType, this.resultSetConcurrency, 1, this.protocol.getAutoIncrementIncrement(), null, null);
        this.protocol.executeBatchStmt(this.protocol.isMasterConnection(), this.results, this.batchQueries);
        this.results.commandEnd();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            if (this.isWrapperFor(iface)) {
                return (T)this;
            }
            throw this.exceptionFactory.raiseStatementError(this.connection, this).create("The receiver is not a wrapper and does not implement the interface", "42000");
        }
        catch (Exception e) {
            throw this.exceptionFactory.raiseStatementError(this.connection, this).create("The receiver is not a wrapper and does not implement the interface", "42000");
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> interfaceOrWrapper) throws SQLException {
        return interfaceOrWrapper.isInstance(this);
    }

    @Override
    public void closeOnCompletion() {
        this.mustCloseOnCompletion = true;
    }

    @Override
    public boolean isCloseOnCompletion() {
        return this.mustCloseOnCompletion;
    }

    public void checkCloseOnCompletion(ResultSet resultSet) throws SQLException {
        if (this.mustCloseOnCompletion && !this.closed && this.results != null && resultSet.equals(this.results.getResultSet())) {
            this.close();
        }
    }

    protected void checkClose() throws SQLException {
        if (this.closed) {
            throw this.exceptionFactory.raiseStatementError(this.connection, this).create("Cannot do an operation on a closed statement");
        }
    }

    static {
        mapper.put("\u0000", "\\0");
        mapper.put("'", "\\\\'");
        mapper.put("\"", "\\\\\"");
        mapper.put("\b", "\\\\b");
        mapper.put("\n", "\\\\n");
        mapper.put("\r", "\\\\r");
        mapper.put("\t", "\\\\t");
        mapper.put("\u001a", "\\\\Z");
        mapper.put("\\", "\\\\");
    }
}

