/* -*-  mode:c; tab-width:8; c-basic-offset:8; indent-tabs-mode:nil;  -*- */
/*
   Copyright (C) 2016 by Ronnie Sahlberg <ronniesahlberg@gmail.com>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU Lesser General Public License as published by
   the Free Software Foundation; either version 2.1 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public License
   along with this program; if not, see <http://www.gnu.org/licenses/>.
*/

/*
 * NTSTATUS fields
 */
#define SMB2_STATUS_SEVERITY_MASK    0xc0000000
#define SMB2_STATUS_SEVERITY_SUCCESS 0x00000000
#define SMB2_STATUS_SEVERITY_INFO    0x40000000
#define SMB2_STATUS_SEVERITY_WARNING 0x80000000
#define SMB2_STATUS_SEVERITY_ERROR   0xc0000000

#define SMB2_STATUS_CUSTOMER_MASK    0x20000000

#define SMB2_STATUS_FACILITY_MASK    0x0fff0000

#define SMB2_STATUS_CODE_MASK        0x0000ffff


/* Error codes */
#define SMB2_STATUS_SUCCESS                            0x00000000
#define SMB2_STATUS_SHUTDOWN                           0xffffffff
#define SMB2_STATUS_PENDING                            0x00000103
#define SMB2_STATUS_SMB_BAD_FID                        0x00060001
#define SMB2_STATUS_NO_MORE_FILES                      0x80000006
#define SMB2_STATUS_UNSUCCESSFUL                       0xC0000001
#define SMB2_STATUS_NOT_IMPLEMENTED                    0xC0000002
#define SMB2_STATUS_INVALID_INFO_CLASS                 0xC0000003
#define SMB2_STATUS_INFO_LENGTH_MISMATCH               0xC0000004
#define SMB2_STATUS_ACCESS_VIOLATION                   0xC0000005
#define SMB2_STATUS_IN_PAGE_ERROR                      0xC0000006
#define SMB2_STATUS_PAGEFILE_QUOTA                     0xC0000007
#define SMB2_STATUS_INVALID_HANDLE                     0xC0000008
#define SMB2_STATUS_BAD_INITIAL_STACK                  0xC0000009
#define SMB2_STATUS_BAD_INITIAL_PC                     0xC000000A
#define SMB2_STATUS_INVALID_CID                        0xC000000B
#define SMB2_STATUS_TIMER_NOT_CANCELED                 0xC000000C
#define SMB2_STATUS_INVALID_PARAMETER                  0xC000000D
#define SMB2_STATUS_NO_SUCH_DEVICE                     0xC000000E
#define SMB2_STATUS_NO_SUCH_FILE                       0xC000000F
#define SMB2_STATUS_INVALID_DEVICE_REQUEST             0xC0000010
#define SMB2_STATUS_END_OF_FILE                        0xC0000011
#define SMB2_STATUS_WRONG_VOLUME                       0xC0000012
#define SMB2_STATUS_NO_MEDIA_IN_DEVICE                 0xC0000013
#define SMB2_STATUS_UNRECOGNIZED_MEDIA                 0xC0000014
#define SMB2_STATUS_NONEXISTENT_SECTOR                 0xC0000015
#define SMB2_STATUS_MORE_PROCESSING_REQUIRED           0xC0000016
#define SMB2_STATUS_NO_MEMORY                          0xC0000017
#define SMB2_STATUS_CONFLICTING_ADDRESSES              0xC0000018
#define SMB2_STATUS_NOT_MAPPED_VIEW                    0xC0000019
#define SMB2_STATUS_UNABLE_TO_FREE_VM                  0xC000001A
#define SMB2_STATUS_UNABLE_TO_DELETE_SECTION           0xC000001B
#define SMB2_STATUS_INVALID_SYSTEM_SERVICE             0xC000001C
#define SMB2_STATUS_ILLEGAL_INSTRUCTION                0xC000001D
#define SMB2_STATUS_INVALID_LOCK_SEQUENCE              0xC000001E
#define SMB2_STATUS_INVALID_VIEW_SIZE                  0xC000001F
#define SMB2_STATUS_INVALID_FILE_FOR_SECTION           0xC0000020
#define SMB2_STATUS_ALREADY_COMMITTED                  0xC0000021
#define SMB2_STATUS_ACCESS_DENIED                      0xC0000022
#define SMB2_STATUS_BUFFER_TOO_SMALL                   0xC0000023
#define SMB2_STATUS_OBJECT_TYPE_MISMATCH               0xC0000024
#define SMB2_STATUS_NONCONTINUABLE_EXCEPTION           0xC0000025
#define SMB2_STATUS_INVALID_DISPOSITION                0xC0000026
#define SMB2_STATUS_UNWIND                             0xC0000027
#define SMB2_STATUS_BAD_STACK                          0xC0000028
#define SMB2_STATUS_INVALID_UNWIND_TARGET              0xC0000029
#define SMB2_STATUS_NOT_LOCKED                         0xC000002A
#define SMB2_STATUS_PARITY_ERROR                       0xC000002B
#define SMB2_STATUS_UNABLE_TO_DECOMMIT_VM              0xC000002C
#define SMB2_STATUS_NOT_COMMITTED                      0xC000002D
#define SMB2_STATUS_INVALID_PORT_ATTRIBUTES            0xC000002E
#define SMB2_STATUS_PORT_MESSAGE_TOO_LONG              0xC000002F
#define SMB2_STATUS_INVALID_PARAMETER_MIX              0xC0000030
#define SMB2_STATUS_INVALID_QUOTA_LOWER                0xC0000031
#define SMB2_STATUS_DISK_CORRUPT_ERROR                 0xC0000032
#define SMB2_STATUS_OBJECT_NAME_INVALID                0xC0000033
#define SMB2_STATUS_OBJECT_NAME_NOT_FOUND              0xC0000034
#define SMB2_STATUS_OBJECT_NAME_COLLISION              0xC0000035
#define SMB2_STATUS_HANDLE_NOT_WAITABLE                0xC0000036
#define SMB2_STATUS_PORT_DISCONNECTED                  0xC0000037
#define SMB2_STATUS_DEVICE_ALREADY_ATTACHED            0xC0000038
#define SMB2_STATUS_OBJECT_PATH_INVALID                0xC0000039
#define SMB2_STATUS_OBJECT_PATH_NOT_FOUND              0xC000003A
#define SMB2_STATUS_OBJECT_PATH_SYNTAX_BAD             0xC000003B
#define SMB2_STATUS_DATA_OVERRUN                       0xC000003C
#define SMB2_STATUS_DATA_LATE_ERROR                    0xC000003D
#define SMB2_STATUS_DATA_ERROR                         0xC000003E
#define SMB2_STATUS_CRC_ERROR                          0xC000003F
#define SMB2_STATUS_SECTION_TOO_BIG                    0xC0000040
#define SMB2_STATUS_PORT_CONNECTION_REFUSED            0xC0000041
#define SMB2_STATUS_INVALID_PORT_HANDLE                0xC0000042
#define SMB2_STATUS_SHARING_VIOLATION                  0xC0000043
#define SMB2_STATUS_QUOTA_EXCEEDED                     0xC0000044
#define SMB2_STATUS_INVALID_PAGE_PROTECTION            0xC0000045
#define SMB2_STATUS_MUTANT_NOT_OWNED                   0xC0000046
#define SMB2_STATUS_SEMAPHORE_LIMIT_EXCEEDED           0xC0000047
#define SMB2_STATUS_PORT_ALREADY_SET                   0xC0000048
#define SMB2_STATUS_SECTION_NOT_IMAGE                  0xC0000049
#define SMB2_STATUS_SUSPEND_COUNT_EXCEEDED             0xC000004A
#define SMB2_STATUS_THREAD_IS_TERMINATING              0xC000004B
#define SMB2_STATUS_BAD_WORKING_SET_LIMIT              0xC000004C
#define SMB2_STATUS_INCOMPATIBLE_FILE_MAP              0xC000004D
#define SMB2_STATUS_SECTION_PROTECTION                 0xC000004E
#define SMB2_STATUS_EAS_NOT_SUPPORTED                  0xC000004F
#define SMB2_STATUS_EA_TOO_LARGE                       0xC0000050
#define SMB2_STATUS_NONEXISTENT_EA_ENTRY               0xC0000051
#define SMB2_STATUS_NO_EAS_ON_FILE                     0xC0000052
#define SMB2_STATUS_EA_CORRUPT_ERROR                   0xC0000053
#define SMB2_STATUS_FILE_LOCK_CONFLICT                 0xC0000054
#define SMB2_STATUS_LOCK_NOT_GRANTED                   0xC0000055
#define SMB2_STATUS_DELETE_PENDING                     0xC0000056
#define SMB2_STATUS_CTL_FILE_NOT_SUPPORTED             0xC0000057
#define SMB2_STATUS_UNKNOWN_REVISION                   0xC0000058
#define SMB2_STATUS_REVISION_MISMATCH                  0xC0000059
#define SMB2_STATUS_INVALID_OWNER                      0xC000005A
#define SMB2_STATUS_INVALID_PRIMARY_GROUP              0xC000005B
#define SMB2_STATUS_NO_IMPERSONATION_TOKEN             0xC000005C
#define SMB2_STATUS_CANT_DISABLE_MANDATORY             0xC000005D
#define SMB2_STATUS_NO_LOGON_SERVERS                   0xC000005E
#define SMB2_STATUS_NO_SUCH_LOGON_SESSION              0xC000005F
#define SMB2_STATUS_NO_SUCH_PRIVILEGE                  0xC0000060
#define SMB2_STATUS_PRIVILEGE_NOT_HELD                 0xC0000061
#define SMB2_STATUS_INVALID_ACCOUNT_NAME               0xC0000062
#define SMB2_STATUS_USER_EXISTS                        0xC0000063
#define SMB2_STATUS_NO_SUCH_USER                       0xC0000064
#define SMB2_STATUS_GROUP_EXISTS                       0xC0000065
#define SMB2_STATUS_NO_SUCH_GROUP                      0xC0000066
#define SMB2_STATUS_MEMBER_IN_GROUP                    0xC0000067
#define SMB2_STATUS_MEMBER_NOT_IN_GROUP                0xC0000068
#define SMB2_STATUS_LAST_ADMIN                         0xC0000069
#define SMB2_STATUS_WRONG_PASSWORD                     0xC000006A
#define SMB2_STATUS_ILL_FORMED_PASSWORD                0xC000006B
#define SMB2_STATUS_PASSWORD_RESTRICTION               0xC000006C
#define SMB2_STATUS_LOGON_FAILURE                      0xC000006D
#define SMB2_STATUS_ACCOUNT_RESTRICTION                0xC000006E
#define SMB2_STATUS_INVALID_LOGON_HOURS                0xC000006F
#define SMB2_STATUS_INVALID_WORKSTATION                0xC0000070
#define SMB2_STATUS_PASSWORD_EXPIRED                   0xC0000071
#define SMB2_STATUS_ACCOUNT_DISABLED                   0xC0000072
#define SMB2_STATUS_NONE_MAPPED                        0xC0000073
#define SMB2_STATUS_TOO_MANY_LUIDS_REQUESTED           0xC0000074
#define SMB2_STATUS_LUIDS_EXHAUSTED                    0xC0000075
#define SMB2_STATUS_INVALID_SUB_AUTHORITY              0xC0000076
#define SMB2_STATUS_INVALID_ACL                        0xC0000077
#define SMB2_STATUS_INVALID_SID                        0xC0000078
#define SMB2_STATUS_INVALID_SECURITY_DESCR             0xC0000079
#define SMB2_STATUS_PROCEDURE_NOT_FOUND                0xC000007A
#define SMB2_STATUS_INVALID_IMAGE_FORMAT               0xC000007B
#define SMB2_STATUS_NO_TOKEN                           0xC000007C
#define SMB2_STATUS_BAD_INHERITANCE_ACL                0xC000007D
#define SMB2_STATUS_RANGE_NOT_LOCKED                   0xC000007E
#define SMB2_STATUS_DISK_FULL                          0xC000007F
#define SMB2_STATUS_SERVER_DISABLED                    0xC0000080
#define SMB2_STATUS_SERVER_NOT_DISABLED                0xC0000081
#define SMB2_STATUS_TOO_MANY_GUIDS_REQUESTED           0xC0000082
#define SMB2_STATUS_GUIDS_EXHAUSTED                    0xC0000083
#define SMB2_STATUS_INVALID_ID_AUTHORITY               0xC0000084
#define SMB2_STATUS_AGENTS_EXHAUSTED                   0xC0000085
#define SMB2_STATUS_INVALID_VOLUME_LABEL               0xC0000086
#define SMB2_STATUS_SECTION_NOT_EXTENDED               0xC0000087
#define SMB2_STATUS_NOT_MAPPED_DATA                    0xC0000088
#define SMB2_STATUS_RESOURCE_DATA_NOT_FOUND            0xC0000089
#define SMB2_STATUS_RESOURCE_TYPE_NOT_FOUND            0xC000008A
#define SMB2_STATUS_RESOURCE_NAME_NOT_FOUND            0xC000008B
#define SMB2_STATUS_ARRAY_BOUNDS_EXCEEDED              0xC000008C
#define SMB2_STATUS_FLOAT_DENORMAL_OPERAND             0xC000008D
#define SMB2_STATUS_FLOAT_DIVIDE_BY_ZERO               0xC000008E
#define SMB2_STATUS_FLOAT_INEXACT_RESULT               0xC000008F
#define SMB2_STATUS_FLOAT_INVALID_OPERATION            0xC0000090
#define SMB2_STATUS_FLOAT_OVERFLOW                     0xC0000091
#define SMB2_STATUS_FLOAT_STACK_CHECK                  0xC0000092
#define SMB2_STATUS_FLOAT_UNDERFLOW                    0xC0000093
#define SMB2_STATUS_INTEGER_DIVIDE_BY_ZERO             0xC0000094
#define SMB2_STATUS_INTEGER_OVERFLOW                   0xC0000095
#define SMB2_STATUS_PRIVILEGED_INSTRUCTION             0xC0000096
#define SMB2_STATUS_TOO_MANY_PAGING_FILES              0xC0000097
#define SMB2_STATUS_FILE_INVALID                       0xC0000098
#define SMB2_STATUS_ALLOTTED_SPACE_EXCEEDED            0xC0000099
#define SMB2_STATUS_INSUFFICIENT_RESOURCES             0xC000009A
#define SMB2_STATUS_DFS_EXIT_PATH_FOUND                0xC000009B
#define SMB2_STATUS_DEVICE_DATA_ERROR                  0xC000009C
#define SMB2_STATUS_DEVICE_NOT_CONNECTED               0xC000009D
#define SMB2_STATUS_DEVICE_POWER_FAILURE               0xC000009E
#define SMB2_STATUS_FREE_VM_NOT_AT_BASE                0xC000009F
#define SMB2_STATUS_MEMORY_NOT_ALLOCATED               0xC00000A0
#define SMB2_STATUS_WORKING_SET_QUOTA                  0xC00000A1
#define SMB2_STATUS_MEDIA_WRITE_PROTECTED              0xC00000A2
#define SMB2_STATUS_DEVICE_NOT_READY                   0xC00000A3
#define SMB2_STATUS_INVALID_GROUP_ATTRIBUTES           0xC00000A4
#define SMB2_STATUS_BAD_IMPERSONATION_LEVEL            0xC00000A5
#define SMB2_STATUS_CANT_OPEN_ANONYMOUS                0xC00000A6
#define SMB2_STATUS_BAD_VALIDATION_CLASS               0xC00000A7
#define SMB2_STATUS_BAD_TOKEN_TYPE                     0xC00000A8
#define SMB2_STATUS_BAD_MASTER_BOOT_RECORD             0xC00000A9
#define SMB2_STATUS_INSTRUCTION_MISALIGNMENT           0xC00000AA
#define SMB2_STATUS_INSTANCE_NOT_AVAILABLE             0xC00000AB
#define SMB2_STATUS_PIPE_NOT_AVAILABLE                 0xC00000AC
#define SMB2_STATUS_INVALID_PIPE_STATE                 0xC00000AD
#define SMB2_STATUS_PIPE_BUSY                          0xC00000AE
#define SMB2_STATUS_ILLEGAL_FUNCTION                   0xC00000AF
#define SMB2_STATUS_PIPE_DISCONNECTED                  0xC00000B0
#define SMB2_STATUS_PIPE_CLOSING                       0xC00000B1
#define SMB2_STATUS_PIPE_CONNECTED                     0xC00000B2
#define SMB2_STATUS_PIPE_LISTENING                     0xC00000B3
#define SMB2_STATUS_INVALID_READ_MODE                  0xC00000B4
#define SMB2_STATUS_IO_TIMEOUT                         0xC00000B5
#define SMB2_STATUS_FILE_FORCED_CLOSED                 0xC00000B6
#define SMB2_STATUS_PROFILING_NOT_STARTED              0xC00000B7
#define SMB2_STATUS_PROFILING_NOT_STOPPED              0xC00000B8
#define SMB2_STATUS_COULD_NOT_INTERPRET                0xC00000B9
#define SMB2_STATUS_FILE_IS_A_DIRECTORY                0xC00000BA
#define SMB2_STATUS_NOT_SUPPORTED                      0xC00000BB
#define SMB2_STATUS_REMOTE_NOT_LISTENING               0xC00000BC
#define SMB2_STATUS_DUPLICATE_NAME                     0xC00000BD
#define SMB2_STATUS_BAD_NETWORK_PATH                   0xC00000BE
#define SMB2_STATUS_NETWORK_BUSY                       0xC00000BF
#define SMB2_STATUS_DEVICE_DOES_NOT_EXIST              0xC00000C0
#define SMB2_STATUS_TOO_MANY_COMMANDS                  0xC00000C1
#define SMB2_STATUS_ADAPTER_HARDWARE_ERROR             0xC00000C2
#define SMB2_STATUS_INVALID_NETWORK_RESPONSE           0xC00000C3
#define SMB2_STATUS_UNEXPECTED_NETWORK_ERROR           0xC00000C4
#define SMB2_STATUS_BAD_REMOTE_ADAPTER                 0xC00000C5
#define SMB2_STATUS_PRINT_QUEUE_FULL                   0xC00000C6
#define SMB2_STATUS_NO_SPOOL_SPACE                     0xC00000C7
#define SMB2_STATUS_PRINT_CANCELLED                    0xC00000C8
#define SMB2_STATUS_NETWORK_NAME_DELETED               0xC00000C9
#define SMB2_STATUS_NETWORK_ACCESS_DENIED              0xC00000CA
#define SMB2_STATUS_BAD_DEVICE_TYPE                    0xC00000CB
#define SMB2_STATUS_BAD_NETWORK_NAME                   0xC00000CC
#define SMB2_STATUS_TOO_MANY_NAMES                     0xC00000CD
#define SMB2_STATUS_TOO_MANY_SESSIONS                  0xC00000CE
#define SMB2_STATUS_SHARING_PAUSED                     0xC00000CF
#define SMB2_STATUS_REQUEST_NOT_ACCEPTED               0xC00000D0
#define SMB2_STATUS_REDIRECTOR_PAUSED                  0xC00000D1
#define SMB2_STATUS_NET_WRITE_FAULT                    0xC00000D2
#define SMB2_STATUS_PROFILING_AT_LIMIT                 0xC00000D3
#define SMB2_STATUS_NOT_SAME_DEVICE                    0xC00000D4
#define SMB2_STATUS_FILE_RENAMED                       0xC00000D5
#define SMB2_STATUS_VIRTUAL_CIRCUIT_CLOSED             0xC00000D6
#define SMB2_STATUS_NO_SECURITY_ON_OBJECT              0xC00000D7
#define SMB2_STATUS_CANT_WAIT                          0xC00000D8
#define SMB2_STATUS_PIPE_EMPTY                         0xC00000D9
#define SMB2_STATUS_CANT_ACCESS_DOMAIN_INFO            0xC00000DA
#define SMB2_STATUS_CANT_TERMINATE_SELF                0xC00000DB
#define SMB2_STATUS_INVALID_SERVER_STATE               0xC00000DC
#define SMB2_STATUS_INVALID_DOMAIN_STATE               0xC00000DD
#define SMB2_STATUS_INVALID_DOMAIN_ROLE                0xC00000DE
#define SMB2_STATUS_NO_SUCH_DOMAIN                     0xC00000DF
#define SMB2_STATUS_DOMAIN_EXISTS                      0xC00000E0
#define SMB2_STATUS_DOMAIN_LIMIT_EXCEEDED              0xC00000E1
#define SMB2_STATUS_OPLOCK_NOT_GRANTED                 0xC00000E2
#define SMB2_STATUS_INVALID_OPLOCK_PROTOCOL            0xC00000E3
#define SMB2_STATUS_INTERNAL_DB_CORRUPTION             0xC00000E4
#define SMB2_STATUS_INTERNAL_ERROR                     0xC00000E5
#define SMB2_STATUS_GENERIC_NOT_MAPPED                 0xC00000E6
#define SMB2_STATUS_BAD_DESCRIPTOR_FORMAT              0xC00000E7
#define SMB2_STATUS_INVALID_USER_BUFFER                0xC00000E8
#define SMB2_STATUS_UNEXPECTED_IO_ERROR                0xC00000E9
#define SMB2_STATUS_UNEXPECTED_MM_CREATE_ERR           0xC00000EA
#define SMB2_STATUS_UNEXPECTED_MM_MAP_ERROR            0xC00000EB
#define SMB2_STATUS_UNEXPECTED_MM_EXTEND_ERR           0xC00000EC
#define SMB2_STATUS_NOT_LOGON_PROCESS                  0xC00000ED
#define SMB2_STATUS_LOGON_SESSION_EXISTS               0xC00000EE
#define SMB2_STATUS_INVALID_PARAMETER_1                0xC00000EF
#define SMB2_STATUS_INVALID_PARAMETER_2                0xC00000F0
#define SMB2_STATUS_INVALID_PARAMETER_3                0xC00000F1
#define SMB2_STATUS_INVALID_PARAMETER_4                0xC00000F2
#define SMB2_STATUS_INVALID_PARAMETER_5                0xC00000F3
#define SMB2_STATUS_INVALID_PARAMETER_6                0xC00000F4
#define SMB2_STATUS_INVALID_PARAMETER_7                0xC00000F5
#define SMB2_STATUS_INVALID_PARAMETER_8                0xC00000F6
#define SMB2_STATUS_INVALID_PARAMETER_9                0xC00000F7
#define SMB2_STATUS_INVALID_PARAMETER_10               0xC00000F8
#define SMB2_STATUS_INVALID_PARAMETER_11               0xC00000F9
#define SMB2_STATUS_INVALID_PARAMETER_12               0xC00000FA
#define SMB2_STATUS_REDIRECTOR_NOT_STARTED             0xC00000FB
#define SMB2_STATUS_REDIRECTOR_STARTED                 0xC00000FC
#define SMB2_STATUS_STACK_OVERFLOW                     0xC00000FD
#define SMB2_STATUS_NO_SUCH_PACKAGE                    0xC00000FE
#define SMB2_STATUS_BAD_FUNCTION_TABLE                 0xC00000FF
#define SMB2_STATUS_DIRECTORY_NOT_EMPTY                0xC0000101
#define SMB2_STATUS_FILE_CORRUPT_ERROR                 0xC0000102
#define SMB2_STATUS_NOT_A_DIRECTORY                    0xC0000103
#define SMB2_STATUS_BAD_LOGON_SESSION_STATE            0xC0000104
#define SMB2_STATUS_LOGON_SESSION_COLLISION            0xC0000105
#define SMB2_STATUS_NAME_TOO_LONG                      0xC0000106
#define SMB2_STATUS_FILES_OPEN                         0xC0000107
#define SMB2_STATUS_CONNECTION_IN_USE                  0xC0000108
#define SMB2_STATUS_MESSAGE_NOT_FOUND                  0xC0000109
#define SMB2_STATUS_PROCESS_IS_TERMINATING             0xC000010A
#define SMB2_STATUS_INVALID_LOGON_TYPE                 0xC000010B
#define SMB2_STATUS_NO_GUID_TRANSLATION                0xC000010C
#define SMB2_STATUS_CANNOT_IMPERSONATE                 0xC000010D
#define SMB2_STATUS_IMAGE_ALREADY_LOADED               0xC000010E
#define SMB2_STATUS_ABIOS_NOT_PRESENT                  0xC000010F
#define SMB2_STATUS_ABIOS_LID_NOT_EXIST                0xC0000110
#define SMB2_STATUS_ABIOS_LID_ALREADY_OWNED            0xC0000111
#define SMB2_STATUS_ABIOS_NOT_LID_OWNER                0xC0000112
#define SMB2_STATUS_ABIOS_INVALID_COMMAND              0xC0000113
#define SMB2_STATUS_ABIOS_INVALID_LID                  0xC0000114
#define SMB2_STATUS_ABIOS_SELECTOR_NOT_AVAILABLE       0xC0000115
#define SMB2_STATUS_ABIOS_INVALID_SELECTOR             0xC0000116
#define SMB2_STATUS_NO_LDT                             0xC0000117
#define SMB2_STATUS_INVALID_LDT_SIZE                   0xC0000118
#define SMB2_STATUS_INVALID_LDT_OFFSET                 0xC0000119
#define SMB2_STATUS_INVALID_LDT_DESCRIPTOR             0xC000011A
#define SMB2_STATUS_INVALID_IMAGE_NE_FORMAT            0xC000011B
#define SMB2_STATUS_RXACT_INVALID_STATE                0xC000011C
#define SMB2_STATUS_RXACT_COMMIT_FAILURE               0xC000011D
#define SMB2_STATUS_MAPPED_FILE_SIZE_ZERO              0xC000011E
#define SMB2_STATUS_TOO_MANY_OPENED_FILES              0xC000011F
#define SMB2_STATUS_CANCELLED                          0xC0000120
#define SMB2_STATUS_CANNOT_DELETE                      0xC0000121
#define SMB2_STATUS_INVALID_COMPUTER_NAME              0xC0000122
#define SMB2_STATUS_FILE_DELETED                       0xC0000123
#define SMB2_STATUS_SPECIAL_ACCOUNT                    0xC0000124
#define SMB2_STATUS_SPECIAL_GROUP                      0xC0000125
#define SMB2_STATUS_SPECIAL_USER                       0xC0000126
#define SMB2_STATUS_MEMBERS_PRIMARY_GROUP              0xC0000127
#define SMB2_STATUS_FILE_CLOSED                        0xC0000128
#define SMB2_STATUS_TOO_MANY_THREADS                   0xC0000129
#define SMB2_STATUS_THREAD_NOT_IN_PROCESS              0xC000012A
#define SMB2_STATUS_TOKEN_ALREADY_IN_USE               0xC000012B
#define SMB2_STATUS_PAGEFILE_QUOTA_EXCEEDED            0xC000012C
#define SMB2_STATUS_COMMITMENT_LIMIT                   0xC000012D
#define SMB2_STATUS_INVALID_IMAGE_LE_FORMAT            0xC000012E
#define SMB2_STATUS_INVALID_IMAGE_NOT_MZ               0xC000012F
#define SMB2_STATUS_INVALID_IMAGE_PROTECT              0xC0000130
#define SMB2_STATUS_INVALID_IMAGE_WIN_16               0xC0000131
#define SMB2_STATUS_LOGON_SERVER_CONFLICT              0xC0000132
#define SMB2_STATUS_TIME_DIFFERENCE_AT_DC              0xC0000133
#define SMB2_STATUS_SYNCHRONIZATION_REQUIRED           0xC0000134
#define SMB2_STATUS_DLL_NOT_FOUND                      0xC0000135
#define SMB2_STATUS_OPEN_FAILED                        0xC0000136
#define SMB2_STATUS_IO_PRIVILEGE_FAILED                0xC0000137
#define SMB2_STATUS_ORDINAL_NOT_FOUND                  0xC0000138
#define SMB2_STATUS_ENTRYPOINT_NOT_FOUND               0xC0000139
#define SMB2_STATUS_CONTROL_C_EXIT                     0xC000013A
#define SMB2_STATUS_LOCAL_DISCONNECT                   0xC000013B
#define SMB2_STATUS_REMOTE_DISCONNECT                  0xC000013C
#define SMB2_STATUS_REMOTE_RESOURCES                   0xC000013D
#define SMB2_STATUS_LINK_FAILED                        0xC000013E
#define SMB2_STATUS_LINK_TIMEOUT                       0xC000013F
#define SMB2_STATUS_INVALID_CONNECTION                 0xC0000140
#define SMB2_STATUS_INVALID_ADDRESS                    0xC0000141
#define SMB2_STATUS_DLL_INIT_FAILED                    0xC0000142
#define SMB2_STATUS_MISSING_SYSTEMFILE                 0xC0000143
#define SMB2_STATUS_UNHANDLED_EXCEPTION                0xC0000144
#define SMB2_STATUS_APP_INIT_FAILURE                   0xC0000145
#define SMB2_STATUS_PAGEFILE_CREATE_FAILED             0xC0000146
#define SMB2_STATUS_NO_PAGEFILE                        0xC0000147
#define SMB2_STATUS_INVALID_LEVEL                      0xC0000148
#define SMB2_STATUS_WRONG_PASSWORD_CORE                0xC0000149
#define SMB2_STATUS_ILLEGAL_FLOAT_CONTEXT              0xC000014A
#define SMB2_STATUS_PIPE_BROKEN                        0xC000014B
#define SMB2_STATUS_REGISTRY_CORRUPT                   0xC000014C
#define SMB2_STATUS_REGISTRY_IO_FAILED                 0xC000014D
#define SMB2_STATUS_NO_EVENT_PAIR                      0xC000014E
#define SMB2_STATUS_UNRECOGNIZED_VOLUME                0xC000014F
#define SMB2_STATUS_SERIAL_NO_DEVICE_INITED            0xC0000150
#define SMB2_STATUS_NO_SUCH_ALIAS                      0xC0000151
#define SMB2_STATUS_MEMBER_NOT_IN_ALIAS                0xC0000152
#define SMB2_STATUS_MEMBER_IN_ALIAS                    0xC0000153
#define SMB2_STATUS_ALIAS_EXISTS                       0xC0000154
#define SMB2_STATUS_LOGON_NOT_GRANTED                  0xC0000155
#define SMB2_STATUS_TOO_MANY_SECRETS                   0xC0000156
#define SMB2_STATUS_SECRET_TOO_LONG                    0xC0000157
#define SMB2_STATUS_INTERNAL_DB_ERROR                  0xC0000158
#define SMB2_STATUS_FULLSCREEN_MODE                    0xC0000159
#define SMB2_STATUS_TOO_MANY_CONTEXT_IDS               0xC000015A
#define SMB2_STATUS_LOGON_TYPE_NOT_GRANTED             0xC000015B
#define SMB2_STATUS_NOT_REGISTRY_FILE                  0xC000015C
#define SMB2_STATUS_NT_CROSS_ENCRYPTION_REQUIRED       0xC000015D
#define SMB2_STATUS_DOMAIN_CTRLR_CONFIG_ERROR          0xC000015E
#define SMB2_STATUS_FT_MISSING_MEMBER                  0xC000015F
#define SMB2_STATUS_ILL_FORMED_SERVICE_ENTRY           0xC0000160
#define SMB2_STATUS_ILLEGAL_CHARACTER                  0xC0000161
#define SMB2_STATUS_UNMAPPABLE_CHARACTER               0xC0000162
#define SMB2_STATUS_UNDEFINED_CHARACTER                0xC0000163
#define SMB2_STATUS_FLOPPY_VOLUME                      0xC0000164
#define SMB2_STATUS_FLOPPY_ID_MARK_NOT_FOUND           0xC0000165
#define SMB2_STATUS_FLOPPY_WRONG_CYLINDER              0xC0000166
#define SMB2_STATUS_FLOPPY_UNKNOWN_ERROR               0xC0000167
#define SMB2_STATUS_FLOPPY_BAD_REGISTERS               0xC0000168
#define SMB2_STATUS_DISK_RECALIBRATE_FAILED            0xC0000169
#define SMB2_STATUS_DISK_OPERATION_FAILED              0xC000016A
#define SMB2_STATUS_DISK_RESET_FAILED                  0xC000016B
#define SMB2_STATUS_SHARED_IRQ_BUSY                    0xC000016C
#define SMB2_STATUS_FT_ORPHANING                       0xC000016D
#define SMB2_STATUS_PARTITION_FAILURE                  0xC0000172
#define SMB2_STATUS_INVALID_BLOCK_LENGTH               0xC0000173
#define SMB2_STATUS_DEVICE_NOT_PARTITIONED             0xC0000174
#define SMB2_STATUS_UNABLE_TO_LOCK_MEDIA               0xC0000175
#define SMB2_STATUS_UNABLE_TO_UNLOAD_MEDIA             0xC0000176
#define SMB2_STATUS_EOM_OVERFLOW                       0xC0000177
#define SMB2_STATUS_NO_MEDIA                           0xC0000178
#define SMB2_STATUS_NO_SUCH_MEMBER                     0xC000017A
#define SMB2_STATUS_INVALID_MEMBER                     0xC000017B
#define SMB2_STATUS_KEY_DELETED                        0xC000017C
#define SMB2_STATUS_NO_LOG_SPACE                       0xC000017D
#define SMB2_STATUS_TOO_MANY_SIDS                      0xC000017E
#define SMB2_STATUS_LM_CROSS_ENCRYPTION_REQUIRED       0xC000017F
#define SMB2_STATUS_KEY_HAS_CHILDREN                   0xC0000180
#define SMB2_STATUS_CHILD_MUST_BE_VOLATILE             0xC0000181
#define SMB2_STATUS_DEVICE_CONFIGURATION_ERROR         0xC0000182
#define SMB2_STATUS_DRIVER_INTERNAL_ERROR              0xC0000183
#define SMB2_STATUS_INVALID_DEVICE_STATE               0xC0000184
#define SMB2_STATUS_IO_DEVICE_ERROR                    0xC0000185
#define SMB2_STATUS_DEVICE_PROTOCOL_ERROR              0xC0000186
#define SMB2_STATUS_BACKUP_CONTROLLER                  0xC0000187
#define SMB2_STATUS_LOG_FILE_FULL                      0xC0000188
#define SMB2_STATUS_TOO_LATE                           0xC0000189
#define SMB2_STATUS_NO_TRUST_LSA_SECRET                0xC000018A
#define SMB2_STATUS_NO_TRUST_SAM_ACCOUNT               0xC000018B
#define SMB2_STATUS_TRUSTED_DOMAIN_FAILURE             0xC000018C
#define SMB2_STATUS_TRUSTED_RELATIONSHIP_FAILURE       0xC000018D
#define SMB2_STATUS_EVENTLOG_FILE_CORRUPT              0xC000018E
#define SMB2_STATUS_EVENTLOG_CANT_START                0xC000018F
#define SMB2_STATUS_TRUST_FAILURE                      0xC0000190
#define SMB2_STATUS_MUTANT_LIMIT_EXCEEDED              0xC0000191
#define SMB2_STATUS_NETLOGON_NOT_STARTED               0xC0000192
#define SMB2_STATUS_ACCOUNT_EXPIRED                    0xC0000193
#define SMB2_STATUS_POSSIBLE_DEADLOCK                  0xC0000194
#define SMB2_STATUS_NETWORK_CREDENTIAL_CONFLICT        0xC0000195
#define SMB2_STATUS_REMOTE_SESSION_LIMIT               0xC0000196
#define SMB2_STATUS_EVENTLOG_FILE_CHANGED              0xC0000197
#define SMB2_STATUS_NOLOGON_INTERDOMAIN_TRUST_ACCOUNT  0xC0000198
#define SMB2_STATUS_NOLOGON_WORKSTATION_TRUST_ACCOUNT  0xC0000199
#define SMB2_STATUS_NOLOGON_SERVER_TRUST_ACCOUNT       0xC000019A
#define SMB2_STATUS_DOMAIN_TRUST_INCONSISTENT          0xC000019B
#define SMB2_STATUS_FS_DRIVER_REQUIRED                 0xC000019C
#define SMB2_STATUS_NO_USER_SESSION_KEY                0xC0000202
#define SMB2_STATUS_USER_SESSION_DELETED               0xC0000203
#define SMB2_STATUS_RESOURCE_LANG_NOT_FOUND            0xC0000204
#define SMB2_STATUS_INSUFF_SERVER_RESOURCES            0xC0000205
#define SMB2_STATUS_INVALID_BUFFER_SIZE                0xC0000206
#define SMB2_STATUS_INVALID_ADDRESS_COMPONENT          0xC0000207
#define SMB2_STATUS_INVALID_ADDRESS_WILDCARD           0xC0000208
#define SMB2_STATUS_TOO_MANY_ADDRESSES                 0xC0000209
#define SMB2_STATUS_ADDRESS_ALREADY_EXISTS             0xC000020A
#define SMB2_STATUS_ADDRESS_CLOSED                     0xC000020B
#define SMB2_STATUS_CONNECTION_DISCONNECTED            0xC000020C
#define SMB2_STATUS_CONNECTION_RESET                   0xC000020D
#define SMB2_STATUS_TOO_MANY_NODES                     0xC000020E
#define SMB2_STATUS_TRANSACTION_ABORTED                0xC000020F
#define SMB2_STATUS_TRANSACTION_TIMED_OUT              0xC0000210
#define SMB2_STATUS_TRANSACTION_NO_RELEASE             0xC0000211
#define SMB2_STATUS_TRANSACTION_NO_MATCH               0xC0000212
#define SMB2_STATUS_TRANSACTION_RESPONDED              0xC0000213
#define SMB2_STATUS_TRANSACTION_INVALID_ID             0xC0000214
#define SMB2_STATUS_TRANSACTION_INVALID_TYPE           0xC0000215
#define SMB2_STATUS_NOT_SERVER_SESSION                 0xC0000216
#define SMB2_STATUS_NOT_CLIENT_SESSION                 0xC0000217
#define SMB2_STATUS_CANNOT_LOAD_REGISTRY_FILE          0xC0000218
#define SMB2_STATUS_DEBUG_ATTACH_FAILED                0xC0000219
#define SMB2_STATUS_SYSTEM_PROCESS_TERMINATED          0xC000021A
#define SMB2_STATUS_DATA_NOT_ACCEPTED                  0xC000021B
#define SMB2_STATUS_NO_BROWSER_SERVERS_FOUND           0xC000021C
#define SMB2_STATUS_VDM_HARD_ERROR                     0xC000021D
#define SMB2_STATUS_DRIVER_CANCEL_TIMEOUT              0xC000021E
#define SMB2_STATUS_REPLY_MESSAGE_MISMATCH             0xC000021F
#define SMB2_STATUS_MAPPED_ALIGNMENT                   0xC0000220
#define SMB2_STATUS_IMAGE_CHECKSUM_MISMATCH            0xC0000221
#define SMB2_STATUS_LOST_WRITEBEHIND_DATA              0xC0000222
#define SMB2_STATUS_CLIENT_SERVER_PARAMETERS_INVALID   0xC0000223
#define SMB2_STATUS_PASSWORD_MUST_CHANGE               0xC0000224
#define SMB2_STATUS_NOT_FOUND                          0xC0000225
#define SMB2_STATUS_NOT_TINY_STREAM                    0xC0000226
#define SMB2_STATUS_RECOVERY_FAILURE                   0xC0000227
#define SMB2_STATUS_STACK_OVERFLOW_READ                0xC0000228
#define SMB2_STATUS_FAIL_CHECK                         0xC0000229
#define SMB2_STATUS_DUPLICATE_OBJECTID                 0xC000022A
#define SMB2_STATUS_OBJECTID_EXISTS                    0xC000022B
#define SMB2_STATUS_CONVERT_TO_LARGE                   0xC000022C
#define SMB2_STATUS_RETRY                              0xC000022D
#define SMB2_STATUS_FOUND_OUT_OF_SCOPE                 0xC000022E
#define SMB2_STATUS_ALLOCATE_BUCKET                    0xC000022F
#define SMB2_STATUS_PROPSET_NOT_FOUND                  0xC0000230
#define SMB2_STATUS_MARSHALL_OVERFLOW                  0xC0000231
#define SMB2_STATUS_INVALID_VARIANT                    0xC0000232
#define SMB2_STATUS_DOMAIN_CONTROLLER_NOT_FOUND        0xC0000233
#define SMB2_STATUS_ACCOUNT_LOCKED_OUT                 0xC0000234
#define SMB2_STATUS_HANDLE_NOT_CLOSABLE                0xC0000235
#define SMB2_STATUS_CONNECTION_REFUSED                 0xC0000236
#define SMB2_STATUS_GRACEFUL_DISCONNECT                0xC0000237
#define SMB2_STATUS_ADDRESS_ALREADY_ASSOCIATED         0xC0000238
#define SMB2_STATUS_ADDRESS_NOT_ASSOCIATED             0xC0000239
#define SMB2_STATUS_CONNECTION_INVALID                 0xC000023A
#define SMB2_STATUS_CONNECTION_ACTIVE                  0xC000023B
#define SMB2_STATUS_NETWORK_UNREACHABLE                0xC000023C
#define SMB2_STATUS_HOST_UNREACHABLE                   0xC000023D
#define SMB2_STATUS_PROTOCOL_UNREACHABLE               0xC000023E
#define SMB2_STATUS_PORT_UNREACHABLE                   0xC000023F
#define SMB2_STATUS_REQUEST_ABORTED                    0xC0000240
#define SMB2_STATUS_CONNECTION_ABORTED                 0xC0000241
#define SMB2_STATUS_BAD_COMPRESSION_BUFFER             0xC0000242
#define SMB2_STATUS_USER_MAPPED_FILE                   0xC0000243
#define SMB2_STATUS_AUDIT_FAILED                       0xC0000244
#define SMB2_STATUS_TIMER_RESOLUTION_NOT_SET           0xC0000245
#define SMB2_STATUS_CONNECTION_COUNT_LIMIT             0xC0000246
#define SMB2_STATUS_LOGIN_TIME_RESTRICTION             0xC0000247
#define SMB2_STATUS_LOGIN_WKSTA_RESTRICTION            0xC0000248
#define SMB2_STATUS_IMAGE_MP_UP_MISMATCH               0xC0000249
#define SMB2_STATUS_INSUFFICIENT_LOGON_INFO            0xC0000250
#define SMB2_STATUS_BAD_DLL_ENTRYPOINT                 0xC0000251
#define SMB2_STATUS_BAD_SERVICE_ENTRYPOINT             0xC0000252
#define SMB2_STATUS_LPC_REPLY_LOST                     0xC0000253
#define SMB2_STATUS_IP_ADDRESS_CONFLICT1               0xC0000254
#define SMB2_STATUS_IP_ADDRESS_CONFLICT2               0xC0000255
#define SMB2_STATUS_REGISTRY_QUOTA_LIMIT               0xC0000256
#define SMB2_STATUS_PATH_NOT_COVERED                   0xC0000257
#define SMB2_STATUS_NO_CALLBACK_ACTIVE                 0xC0000258
#define SMB2_STATUS_LICENSE_QUOTA_EXCEEDED             0xC0000259
#define SMB2_STATUS_PWD_TOO_SHORT                      0xC000025A
#define SMB2_STATUS_PWD_TOO_RECENT                     0xC000025B
#define SMB2_STATUS_PWD_HISTORY_CONFLICT               0xC000025C
#define SMB2_STATUS_PLUGPLAY_NO_DEVICE                 0xC000025E
#define SMB2_STATUS_UNSUPPORTED_COMPRESSION            0xC000025F
#define SMB2_STATUS_INVALID_HW_PROFILE                 0xC0000260
#define SMB2_STATUS_INVALID_PLUGPLAY_DEVICE_PATH       0xC0000261
#define SMB2_STATUS_DRIVER_ORDINAL_NOT_FOUND           0xC0000262
#define SMB2_STATUS_DRIVER_ENTRYPOINT_NOT_FOUND        0xC0000263
#define SMB2_STATUS_RESOURCE_NOT_OWNED                 0xC0000264
#define SMB2_STATUS_TOO_MANY_LINKS                     0xC0000265
#define SMB2_STATUS_QUOTA_LIST_INCONSISTENT            0xC0000266
#define SMB2_STATUS_FILE_IS_OFFLINE                    0xC0000267
#define SMB2_STATUS_VOLUME_DISMOUNTED                  0xC000026E
#define SMB2_STATUS_NOT_A_REPARSE_POINT                0xC0000275
#define SMB2_STATUS_SERVER_UNAVAILABLE                 0xC0000466

/* Warning codes */
#define SMB2_STATUS_BUFFER_OVERFLOW                    0x80000005
#define SMB2_STATUS_STOPPED_ON_SYMLINK                 0x8000002D

