/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.blockdevicelib.vhd;

import com.amazon.aes.webservices.client.blockdevicelib.DiskImage;
import com.amazon.aes.webservices.client.blockdevicelib.ImageVerificationException;
import java.nio.ByteBuffer;

public class HardDiskFooter {
    protected String UNSUPPORTED_FORMAT_ERRMSG = " is unsupported format. Only dynamic VHD image is supported.";
    public final String cookie;
    public final int features;
    public final int fileFormatVersion;
    public final long dataOffset;
    public final int timeStamp;
    public final int creatorApplication;
    public final int creatorVersion;
    public final int creatorHostOS;
    public final long originalSize;
    public final long currentSize;
    public final int diskGeometry;
    public final int diskType;
    public final int checkSum;
    public final long uniqueId1;
    public final long uniqueId2;
    public final byte savedState;
    public final int computedChecksum;

    public HardDiskFooter(ByteBuffer buff) {
        this.computedChecksum = HardDiskFooter.computeChecksum(buff, 64, 4);
        byte[] cookieArray = new byte["conectix".length()];
        buff.get(cookieArray);
        this.cookie = new String(cookieArray);
        this.features = buff.getInt();
        this.fileFormatVersion = buff.getInt();
        this.dataOffset = buff.getLong();
        this.timeStamp = buff.getInt();
        this.creatorApplication = buff.getInt();
        this.creatorVersion = buff.getInt();
        this.creatorHostOS = buff.getInt();
        this.originalSize = buff.getLong();
        this.currentSize = buff.getLong();
        this.diskGeometry = buff.getInt();
        this.diskType = buff.getInt();
        this.checkSum = buff.getInt();
        this.uniqueId1 = buff.getLong();
        this.uniqueId2 = buff.getLong();
        this.savedState = buff.get();
    }

    public void verifyFooter() throws ImageVerificationException {
        if (!"conectix".equals(this.cookie)) {
            throw new ImageVerificationException("This does not appear to be a dynamic VHD image. Image starts with " + this.cookie);
        }
        if (this.diskType != 3) {
            if (this.diskType == 2) {
                throw new ImageVerificationException("Fixed VHD " + this.UNSUPPORTED_FORMAT_ERRMSG);
            }
            if (this.diskType == 4) {
                throw new ImageVerificationException("Differencing VHD " + this.UNSUPPORTED_FORMAT_ERRMSG);
            }
            throw new ImageVerificationException("Disk type " + this.diskType + this.UNSUPPORTED_FORMAT_ERRMSG);
        }
        if (this.computedChecksum != this.checkSum) {
            throw new ImageVerificationException("Corrupt image. VHD disk footer failed checksum validation.");
        }
    }

    protected static int computeChecksum(ByteBuffer buff, int checksum_offset, int checksum_length) {
        byte[] everyByte = new byte[buff.remaining()];
        buff.get(everyByte);
        buff.rewind();
        for (int i = checksum_offset; i < checksum_offset + checksum_length; ++i) {
            everyByte[i] = 0;
        }
        int sum = 0;
        for (byte eachByte : everyByte) {
            sum += DiskImage.getUnsignedByte(eachByte);
        }
        return sum ^= 0xFFFFFFFF;
    }
}

