/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import javax.xml.stream.XMLStreamException;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.DiplomaticTrade;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.ChangeSet;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.common.networking.ObjectMessage;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.ai.AIPlayer;
import net.sf.freecol.server.control.InGameController;
import net.sf.freecol.server.model.ServerGame;
import net.sf.freecol.server.model.ServerPlayer;

public class DiplomacyMessage
extends ObjectMessage {
    public static final String TAG = "diplomacy";
    private static final String OTHER_ID_TAG = "otherId";
    private static final String OUR_ID_TAG = "ourId";

    public DiplomacyMessage(FreeColGameObject our, FreeColGameObject other, DiplomaticTrade agreement) {
        super(TAG, OUR_ID_TAG, our.getId(), OTHER_ID_TAG, other.getId());
        this.appendChild(agreement);
    }

    public DiplomacyMessage(Unit unit, Unit otherUnit, DiplomaticTrade agreement) {
        this((FreeColGameObject)unit, (FreeColGameObject)otherUnit, agreement);
    }

    public DiplomacyMessage(Unit unit, Colony colony, DiplomaticTrade agreement) {
        this((FreeColGameObject)unit, (FreeColGameObject)colony, agreement);
    }

    public DiplomacyMessage(Colony colony, Unit unit, DiplomaticTrade agreement) {
        this((FreeColGameObject)colony, (FreeColGameObject)unit, agreement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DiplomacyMessage(Game game, FreeColXMLReader xr) throws XMLStreamException {
        super(TAG, xr, OUR_ID_TAG, OTHER_ID_TAG);
        FreeColXMLReader.ReadScope rs = xr.replaceScope(FreeColXMLReader.ReadScope.NOINTERN);
        DiplomaticTrade agreement = null;
        Unit extraUnit = null;
        try {
            while (xr.moreTags()) {
                String tag = xr.getLocalName();
                if ("diplomaticTrade".equals(tag)) {
                    if (agreement == null) {
                        agreement = xr.readFreeColObject(game, DiplomaticTrade.class);
                    } else {
                        this.expected(TAG, tag);
                    }
                } else if ("unit".equals(tag)) {
                    if (extraUnit == null) {
                        extraUnit = xr.readFreeColObject(game, Unit.class);
                    } else {
                        this.expected(TAG, tag);
                    }
                } else {
                    this.expected(agreement == null ? "diplomaticTrade" : "unit", tag);
                }
                xr.expectTag(tag);
            }
            xr.expectTag(TAG);
        }
        finally {
            xr.replaceScope(rs);
        }
        this.appendChild(agreement);
        this.appendChild(extraUnit);
    }

    private FreeColGameObject getOurFCGO(Game game) {
        return game.getFreeColGameObject(this.getStringAttribute(OUR_ID_TAG));
    }

    private FreeColGameObject getOtherFCGO(Game game) {
        return game.getFreeColGameObject(this.getStringAttribute(OTHER_ID_TAG));
    }

    private DiplomaticTrade getAgreement() {
        return this.getChild(0, DiplomaticTrade.class);
    }

    private Unit getExtraUnit() {
        return this.getChild(1, Unit.class);
    }

    @Override
    public Message.MessagePriority getPriority() {
        return Message.MessagePriority.LATE;
    }

    @Override
    public void aiHandler(FreeColServer freeColServer, AIPlayer aiPlayer) {
        ServerGame game = freeColServer.getGame();
        FreeColGameObject our = this.getOurFCGO(game);
        FreeColGameObject other = this.getOtherFCGO(game);
        DiplomaticTrade agreement = this.getAgreement();
        aiPlayer.diplomacyHandler(our, other, agreement);
    }

    @Override
    public void clientHandler(FreeColClient freeColClient) {
        Game game = freeColClient.getGame();
        DiplomaticTrade agreement = this.getAgreement();
        FreeColGameObject our = this.getOurFCGO(game);
        FreeColGameObject other = this.getOtherFCGO(game);
        Unit extraUnit = this.getExtraUnit();
        if (our == null) {
            logger.warning("Our FCGO omitted from diplomacy message.");
            return;
        }
        if (other == null) {
            logger.warning("Other FCGO omitted from diplomacy message.");
            return;
        }
        if (extraUnit != null) {
            extraUnit.intern();
        }
        this.igc(freeColClient).diplomacyHandler(our, other, agreement);
        this.clientGeneric(freeColClient);
    }

    @Override
    public ChangeSet serverHandler(FreeColServer freeColServer, ServerPlayer serverPlayer) {
        ServerGame game = freeColServer.getGame();
        DiplomaticTrade agreement = this.getAgreement();
        if (agreement == null) {
            return serverPlayer.clientError("Null diplomatic agreement");
        }
        Unit ourUnit = null;
        Colony ourColony = null;
        FreeColGameObject our = this.getOurFCGO(game);
        ChangeSet cs = null;
        String ourId = this.getStringAttribute(OUR_ID_TAG);
        String otherId = this.getStringAttribute(OTHER_ID_TAG);
        if (our == null) {
            cs = serverPlayer.clientError("Missing our object: " + ourId);
        } else if (our instanceof Unit) {
            ourUnit = (Unit)our;
            if (!serverPlayer.owns(ourUnit)) {
                cs = serverPlayer.clientError("Not our unit: " + ourId);
            } else if (!ourUnit.hasTile()) {
                cs = serverPlayer.clientError("Our unit is not on the map: " + ourId);
            }
        } else if (our instanceof Colony) {
            ourColony = (Colony)our;
            if (!serverPlayer.owns(ourColony)) {
                cs = serverPlayer.clientError("Not our settlement: " + ourId);
            }
        } else {
            cs = serverPlayer.clientError("Our object is bogus: " + our);
        }
        if (cs != null) {
            return cs;
        }
        Unit otherUnit = null;
        Colony otherColony = null;
        Player otherPlayer = null;
        FreeColGameObject other = this.getOtherFCGO(game);
        if (other == null) {
            cs = serverPlayer.clientError("Missing other object: " + otherId);
        } else if (other instanceof Unit) {
            otherUnit = (Unit)other;
            if (serverPlayer.owns(otherUnit)) {
                cs = serverPlayer.clientError("Contacting our unit? " + otherId);
            } else if (!otherUnit.hasTile()) {
                cs = serverPlayer.clientError("Other unit is not on the map: " + otherId);
            } else if (ourUnit != null && !ourUnit.getTile().isAdjacent(otherUnit.getTile())) {
                cs = serverPlayer.clientError("Our unit " + ourId + " is not adjacent to other unit " + otherId);
            } else if (ourColony != null && !ourColony.getTile().isAdjacent(otherUnit.getTile())) {
                cs = serverPlayer.clientError("Our colony " + ourId + " is not adjacent to other unit " + otherId);
            } else {
                otherPlayer = otherUnit.getOwner();
            }
        } else if (other instanceof Colony) {
            otherColony = (Colony)other;
            if (serverPlayer.owns(otherColony)) {
                cs = serverPlayer.clientError("Contacting our colony? " + otherId);
            } else if (ourUnit != null && !ourUnit.getTile().isAdjacent(otherColony.getTile())) {
                cs = serverPlayer.clientError("Our unit " + ourId + " is not adjacent to other colony " + otherId);
            } else if (ourColony != null && !ourColony.getTile().isAdjacent(otherColony.getTile())) {
                cs = serverPlayer.clientError("Our colony " + ourId + " is not adjacent to other colony " + otherId);
            } else {
                otherPlayer = otherColony.getOwner();
            }
        } else {
            cs = serverPlayer.clientError("Other object is bogus: " + other);
        }
        if (cs != null) {
            return cs;
        }
        if (ourUnit == null && otherUnit == null) {
            return serverPlayer.clientError("Both units null");
        }
        Player senderPlayer = agreement.getSender();
        Player recipientPlayer = agreement.getRecipient();
        if (senderPlayer == null) {
            cs = serverPlayer.clientError("Null sender in agreement.");
        } else if (recipientPlayer == null) {
            cs = serverPlayer.clientError("Null recipient in agreement.");
        } else if (senderPlayer.isREF() || recipientPlayer.isREF()) {
            cs = serverPlayer.clientError("The REF does not negotiate");
        }
        if (cs != null) {
            return cs;
        }
        InGameController igc = freeColServer.getInGameController();
        switch (agreement.getContext()) {
            case CONTACT: {
                cs = igc.europeanFirstContact(serverPlayer, ourUnit, ourColony, otherUnit, otherColony, agreement);
                break;
            }
            case DIPLOMATIC: {
                cs = ourUnit != null ? (!ourUnit.hasAbility("model.ability.negotiate") ? serverPlayer.clientError("Unit lacks ability to negotiate: " + ourUnit) : (otherColony == null ? serverPlayer.clientError("Null other settlement") : igc.diplomacy(serverPlayer, ourUnit, otherColony, agreement))) : (!otherUnit.hasAbility("model.ability.negotiate") ? serverPlayer.clientError("Unit lacks ability to negotiate: " + otherUnit) : igc.diplomacy(serverPlayer, ourColony, otherUnit, agreement));
                break;
            }
            case TRADE: {
                cs = ourUnit != null ? (!ourUnit.isCarrier() ? serverPlayer.clientError("Unit is not a carrier: " + ourUnit) : (!serverPlayer.hasAbility("model.ability.tradeWithForeignColonies") ? serverPlayer.clientError("Player lacks ability to trade with other Europeans: " + serverPlayer) : (otherColony == null ? serverPlayer.clientError("Null other settlement") : igc.diplomacy(serverPlayer, ourUnit, otherColony, agreement)))) : (!otherUnit.isCarrier() ? serverPlayer.clientError("Unit is not a carrier: " + otherUnit) : (!otherPlayer.hasAbility("model.ability.tradeWithForeignColonies") ? serverPlayer.clientError("Player lacks ability to trade with other Europeans: " + otherPlayer) : igc.diplomacy(serverPlayer, ourColony, otherUnit, agreement)));
                break;
            }
            case TRIBUTE: {
                cs = ourUnit != null ? (!ourUnit.isOffensiveUnit() || ourUnit.isNaval() ? serverPlayer.clientError("Unit is not an offensive land unit: " + ourUnit) : (otherColony == null ? serverPlayer.clientError("Null other settlement") : igc.diplomacy(serverPlayer, ourUnit, otherColony, agreement))) : (!otherUnit.isOffensiveUnit() || otherUnit.isNaval() ? serverPlayer.clientError("Unit is not an offensive land unit: " + otherUnit) : igc.diplomacy(serverPlayer, ourColony, otherUnit, agreement));
                break;
            }
        }
        if (cs == null) {
            cs = serverPlayer.clientError("Invalid diplomacy for " + agreement.getContext());
        }
        return cs;
    }
}

