/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.util.Iterator;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.ContextMappingFunction;
import net.sf.saxon.expr.ContextMappingIterator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.PairIterator;
import net.sf.saxon.expr.PathMap;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.instruct.TailCallReturner;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trace.TraceListener;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.TypeHierarchy;

public class ForEach
extends Instruction
implements ContextMappingFunction {
    private Expression select;
    private Expression action;
    private boolean containsTailCall;

    public ForEach(Expression select, Expression action, boolean containsTailCall) {
        this.select = select;
        this.action = action;
        this.containsTailCall = containsTailCall && action instanceof TailCallReturner;
        this.adoptChildExpression(select);
        this.adoptChildExpression(action);
    }

    public int getInstructionNameCode() {
        return 145;
    }

    public Expression getActionExpression() {
        return this.action;
    }

    public final ItemType getItemType(TypeHierarchy th) {
        return this.action.getItemType(th);
    }

    public final boolean createsNewNodes() {
        int props = this.action.getSpecialProperties();
        return (props & 0x400000) == 0;
    }

    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        this.select = visitor.simplify(this.select);
        this.action = visitor.simplify(this.action);
        return this;
    }

    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        this.select = visitor.typeCheck(this.select, contextItemType);
        this.adoptChildExpression(this.select);
        this.action = visitor.typeCheck(this.action, this.select.getItemType(th));
        this.adoptChildExpression(this.action);
        if (Literal.isEmptySequence(this.select)) {
            return this.select;
        }
        if (Literal.isEmptySequence(this.action)) {
            return this.action;
        }
        return this;
    }

    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        this.select = visitor.optimize(this.select, contextItemType);
        this.adoptChildExpression(this.select);
        this.action = this.action.optimize(visitor, this.select.getItemType(th));
        this.adoptChildExpression(this.action);
        if (Literal.isEmptySequence(this.select)) {
            return this.select;
        }
        if (Literal.isEmptySequence(this.action)) {
            return this.action;
        }
        PromotionOffer offer = new PromotionOffer(visitor.getConfiguration().getOptimizer());
        offer.action = 10;
        offer.promoteDocumentDependent = (this.select.getSpecialProperties() & 0x10000) != 0;
        offer.promoteXSLTFunctions = false;
        offer.containingExpression = this;
        this.action = this.doPromotion(this.action, offer);
        if (offer.containingExpression instanceof LetExpression) {
            offer.containingExpression = visitor.optimize(offer.containingExpression, contextItemType);
        }
        return offer.containingExpression;
    }

    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        PathMap.PathMapNodeSet target = this.select.addToPathMap(pathMap, pathMapNodeSet);
        return this.action.addToPathMap(pathMap, target);
    }

    public Expression copy() {
        return new ForEach(this.select.copy(), this.action.copy(), this.containsTailCall);
    }

    public int computeDependencies() {
        int dependencies = 0;
        dependencies |= this.select.getDependencies();
        return dependencies |= this.action.getDependencies() & 0xFFFFFFE1;
    }

    protected void promoteInst(PromotionOffer offer) throws XPathException {
        this.select = this.doPromotion(this.select, offer);
        this.action = this.doPromotion(this.action, offer);
    }

    public Iterator iterateSubExpressions() {
        return new PairIterator(this.select, this.action);
    }

    public boolean hasLoopingSubexpression(Expression child) {
        return child == this.action;
    }

    public boolean replaceSubExpression(Expression original, Expression replacement) {
        boolean found = false;
        if (this.select == original) {
            this.select = replacement;
            found = true;
        }
        if (this.action == original) {
            this.action = replacement;
            found = true;
        }
        return found;
    }

    public int getImplementationMethod() {
        return 6;
    }

    public void checkPermittedContents(SchemaType parentType, StaticContext env, boolean whole) throws XPathException {
        this.action.checkPermittedContents(parentType, env, false);
    }

    public TailCall processLeavingTail(XPathContext context) throws XPathException {
        Controller controller = context.getController();
        SequenceIterator iter = this.select.iterate(context);
        XPathContextMajor c2 = context.newContext();
        c2.setOrigin(this);
        c2.setCurrentIterator(iter);
        c2.setCurrentTemplateRule(null);
        if (this.containsTailCall) {
            if (controller.isTracing()) {
                TraceListener listener = controller.getTraceListener();
                Item item = iter.next();
                if (item == null) {
                    return null;
                }
                listener.startCurrentItem(item);
                TailCall tc = ((TailCallReturner)((Object)this.action)).processLeavingTail(c2);
                listener.endCurrentItem(item);
                return tc;
            }
            Item item = iter.next();
            if (item == null) {
                return null;
            }
            return ((TailCallReturner)((Object)this.action)).processLeavingTail(c2);
        }
        if (controller.isTracing()) {
            Item item;
            TraceListener listener = controller.getTraceListener();
            while ((item = iter.next()) != null) {
                listener.startCurrentItem(item);
                this.action.process(c2);
                listener.endCurrentItem(item);
            }
        } else {
            Item item;
            while ((item = iter.next()) != null) {
                this.action.process(c2);
            }
        }
        return null;
    }

    public SequenceIterator iterate(XPathContext context) throws XPathException {
        SequenceIterator master = this.select.iterate(context);
        XPathContextMajor c2 = context.newContext();
        c2.setOrigin(this);
        c2.setCurrentTemplateRule(null);
        c2.setCurrentIterator(master);
        master = new ContextMappingIterator(this, c2);
        return master;
    }

    public SequenceIterator map(XPathContext context) throws XPathException {
        return this.action.iterate(context);
    }

    public void explain(ExpressionPresenter out) {
        out.startElement("forEach");
        this.select.explain(out);
        out.startSubsidiaryElement("return");
        this.action.explain(out);
        out.endSubsidiaryElement();
        out.endElement();
    }
}

