untrusted comment: signature from openbsd 6.1 base secret key
RWQEQa33SgQSEnjuBbYWBP1aryNaTWrB0VwAAo398HD7iabzcF07zWLHurL65hllttYH9i9SmmDdjeEZB4WdPoxfJbCdB7OeCg8=

OpenBSD 6.1 errata 017, August 3, 2017:

An out-of-bound read in vfs_getcwd_scandir() (mainly used for FUSE)
may result in a kernel panic or info leak.

Apply by doing:
    signify -Vep /etc/signify/openbsd-61-base.pub -x 017_fuse.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/kern/vfs_getcwd.c
===================================================================
RCS file: /cvs/src/sys/kern/vfs_getcwd.c,v
--- sys/kern/vfs_getcwd.c	19 Mar 2016 12:04:15 -0000	1.26
+++ sys/kern/vfs_getcwd.c	28 Jul 2017 21:54:49 -0000	1.27
@@ -102,18 +102,20 @@ vfs_getcwd_scandir(struct vnode **lvpp, 
 
 	/* If we don't care about the pathname, we're done */
 	if (bufp == NULL) {
-		vrele(lvp);
-		*lvpp = NULL;
-		return (0);
+		error = 0;
+		goto out;
 	}
 
 	fileno = va.va_fileid;
 
 	dirbuflen = DIRBLKSIZ;
-
 	if (dirbuflen < va.va_blocksize)
 		dirbuflen = va.va_blocksize;
-
+	/* XXX we need some limit for fuse, 1 MB should be enough */
+	if (dirbuflen > 0xfffff) {
+		error = EINVAL;
+		goto out;
+	}
 	dirbuf = malloc(dirbuflen, M_TEMP, M_WAITOK);
 
 	off = 0;
@@ -159,15 +161,20 @@ vfs_getcwd_scandir(struct vnode **lvpp, 
 			reclen = dp->d_reclen;
 
 			/* Check for malformed directory */
-			if (reclen < DIRENT_RECSIZE(1)) {
+			if (reclen < DIRENT_RECSIZE(1) || reclen > len) {
 				error = EINVAL;
 				goto out;
 			}
 
 			if (dp->d_fileno == fileno) {
 				char *bp = *bpp;
-				bp -= dp->d_namlen;
 
+				if (offsetof(struct dirent, d_name) +
+				    dp->d_namlen > reclen) {
+					error = EINVAL;
+					goto out;
+				}
+				bp -= dp->d_namlen;
 				if (bp <= bufp) {
 					error = ERANGE;
 					goto out;
