untrusted comment: signature from openbsd 6.2 base secret key
RWRVWzAMgtyg7lk3Sa8qwn7lZ91Fznk18v3jfrW7FsEdfzB1lGwH/+Fj6ldLQcq7rBEEEmNUOEx9DKjbCNrPWB905blMu0NilQw=

OpenBSD 6.2 errata 018, July 25, 2018:

A regular user could trigger a kernel panic by executing an invalid
ELF binary.

Apply by doing:
    signify -Vep /etc/signify/openbsd-62-base.pub -x 018_execsize.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install the kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/kern/exec_elf.c
===================================================================
RCS file: /cvs/src/sys/kern/exec_elf.c,v
retrieving revision 1.141
diff -u -p -r1.141 exec_elf.c
--- sys/kern/exec_elf.c	7 Sep 2017 11:32:14 -0000	1.141
+++ sys/kern/exec_elf.c	23 Jul 2018 12:11:10 -0000
@@ -366,8 +366,11 @@ elf_load_file(struct proc *p, char *path
 
 	for (i = 0; i < eh.e_phnum; i++) {
 		if (ph[i].p_type == PT_LOAD) {
-			if (ph[i].p_filesz > ph[i].p_memsz)
+			if (ph[i].p_filesz > ph[i].p_memsz ||
+			    ph[i].p_memsz == 0) {
+				error = EINVAL;
 				goto bad1;
+			}
 			loadmap[idx].vaddr = trunc_page(ph[i].p_vaddr);
 			loadmap[idx].memsz = round_page (ph[i].p_vaddr +
 			    ph[i].p_memsz - loadmap[idx].vaddr);
@@ -562,7 +565,8 @@ exec_elf_makecmds(struct proc *p, struct
 			if (interp[pp->p_filesz - 1] != '\0')
 				goto bad;
 		} else if (pp->p_type == PT_LOAD) {
-			if (pp->p_filesz > pp->p_memsz) {
+			if (pp->p_filesz > pp->p_memsz ||
+			    pp->p_memsz == 0) {
 				error = EINVAL;
 				goto bad;
 			}
