untrusted comment: verify with openbsd-63-base.pub
RWRxzbLwAd76ZZ8sTE2Mz/YlvqiFW8NMR4ZhbYt1eKtwBPnKBbftDraUnQ1bKn8Vt1rU877l44wLY5oEqZABpD3gnu6sIMwHaws=

OpenBSD 6.3 errata 027, December 22, 2018:

The setsockopt(2) system call could overflow mbuf cluster kernel
memory by 4 bytes.

Apply by doing:
    signify -Vep /etc/signify/openbsd-63-base.pub -x 027_pcbopts.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/netinet/ip_output.c
===================================================================
RCS file: /cvs/src/sys/netinet/ip_output.c,v
retrieving revision 1.346
diff -u -p -r1.346 ip_output.c
--- sys/netinet/ip_output.c	21 Mar 2018 14:42:41 -0000	1.346
+++ sys/netinet/ip_output.c	20 Dec 2018 12:23:48 -0000
@@ -1249,7 +1249,7 @@ ip_pcbopts(struct mbuf **pcbopt, struct 
 	 * actual options; move other options back
 	 * and clear it when none present.
 	 */
-	if (m->m_data + m->m_len + sizeof(struct in_addr) >= &m->m_dat[MLEN])
+	if (m_trailingspace(m) < sizeof(struct in_addr))
 		return (EINVAL);
 	cnt = m->m_len;
 	m->m_len += sizeof(struct in_addr);
