untrusted comment: verify with openbsd-65-base.pub
RWSZaRmt1LEQT9CHHxUGfGozSoRJkH2DGkUBG+qn+F+qDMP5SqRC2535hL7+27ihcsnC06elqOjuUmxYfWZ6YZL0PvJkqHf6rAg=

OpenBSD 6.5 errata 007, August 2, 2019

smtpd can crash on excessively large input, causing a denial of service.

Apply by doing:
    signify -Vep /etc/signify/openbsd-65-base.pub -x 007_smtpd.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install smtpd:
    cd /usr/src/usr.sbin/smtpd
    make obj
    make
    make install

Index: usr.sbin/smtpd/smtp_session.c
===================================================================
RCS file: /cvs/src/usr.sbin/smtpd/smtp_session.c,v
retrieving revision 1.389
diff -u -p -r1.389 smtp_session.c
--- usr.sbin/smtpd/smtp_session.c	20 Feb 2019 11:56:27 -0000	1.389
+++ usr.sbin/smtpd/smtp_session.c	1 Aug 2019 21:22:12 -0000
@@ -2032,15 +2032,21 @@ smtp_reply(struct smtp_session *s, char 
 {
 	va_list	 ap;
 	int	 n;
-	char	 buf[LINE_MAX], tmp[LINE_MAX];
+	char	 buf[LINE_MAX*2], tmp[LINE_MAX*2];
 
 	va_start(ap, fmt);
 	n = vsnprintf(buf, sizeof buf, fmt, ap);
 	va_end(ap);
-	if (n == -1 || n >= LINE_MAX)
-		fatalx("smtp_reply: line too long");
+	if (n < 0)
+		fatalx("smtp_reply: response format error");
 	if (n < 4)
 		fatalx("smtp_reply: response too short");
+	if (n >= (int)sizeof buf) {
+		/* only first three bytes are used by SMTP logic,
+		 * so if _our_ reply does not fit entirely in the
+		 * buffer, it's ok to truncate.
+		 */
+	}
 
 	log_trace(TRACE_SMTP, "smtp: %p: >>> %s", s, buf);
 
