untrusted comment: verify with openbsd-65-base.pub
RWSZaRmt1LEQT4ykiyYgtwMqYQCOSNOOBEgcjvPDdzpXoIe5UOLgJEGxd5M7VrruyXY9+x1dYGIeMbow5uVkAkvmHs2nK4bzeQM=

OpenBSD 6.5 errata 015, November 16, 2019:

The kernel could crash due to a NULL pointer dereference in net80211.

Apply by doing:
    signify -Vep /etc/signify/openbsd-65-base.pub -x 015_net80211.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/net80211/ieee80211_ioctl.c
===================================================================
RCS file: /cvs/src/sys/net80211/ieee80211_ioctl.c,v
retrieving revision 1.73
diff -u -p -r1.73 ieee80211_ioctl.c
--- sys/net80211/ieee80211_ioctl.c	19 Feb 2019 08:12:30 -0000	1.73
+++ sys/net80211/ieee80211_ioctl.c	11 Nov 2019 18:21:29 -0000
@@ -74,7 +74,8 @@ ieee80211_node2req(struct ieee80211com *
 
 	/* Channel and rates */
 	nr->nr_channel = ieee80211_chan2ieee(ic, ni->ni_chan);
-	nr->nr_chan_flags = ni->ni_chan->ic_flags;
+	if (ni->ni_chan != IEEE80211_CHAN_ANYC)
+		nr->nr_chan_flags = ni->ni_chan->ic_flags;
 	if (ic->ic_curmode != IEEE80211_MODE_11N)
 		nr->nr_chan_flags &= ~IEEE80211_CHAN_HT;
 	nr->nr_nrates = ni->ni_rates.rs_nrates;
