untrusted comment: verify with openbsd-71-base.pub
RWR2eHwZTOEiTQWgtdqynsVaqg6Ly6W5lelWX0xK9JGBt2i5eJgyZs6etxEWPveI5nWaLdhLZXdJOBC9xPg31upyYL0lLo0DRgk=

OpenBSD 7.1 errata 015, December 14, 2022:

In X11 server fix local privileges elevation and and remote code
execution for ssh X forwarding sessions.  This addresses CVE-2022-46340
CVE-2022-46341 CVE-2022-46342 CVE-2022-46343 CVE-2022-46344.

Apply by doing:
    signify -Vep /etc/signify/openbsd-71-base.pub -x 015_xserver.patch.sig \
        -m - | (cd /usr/xenocara && patch -p0)

And then rebuild and install the X server:
    cd /usr/xenocara/xserver
    make -f Makefile.bsd-wrapper obj
    make -f Makefile.bsd-wrapper build

Index: xserver/Xext/saver.c
===================================================================
RCS file: /cvs/xenocara/xserver/Xext/saver.c,v
retrieving revision 1.20
diff -u -p -r1.20 saver.c
--- xserver/Xext/saver.c	14 Dec 2021 13:42:21 -0000	1.20
+++ xserver/Xext/saver.c	5 Dec 2022 18:27:13 -0000
@@ -1051,7 +1051,7 @@ ScreenSaverSetAttributes(ClientPtr clien
         pVlist++;
     }
     if (pPriv->attr)
-        FreeScreenAttr(pPriv->attr);
+        FreeResource(pPriv->attr->resource, AttrType);
     pPriv->attr = pAttr;
     pAttr->resource = FakeClientID(client->index);
     if (!AddResource(pAttr->resource, AttrType, (void *) pAttr))
Index: xserver/Xext/xtest.c
===================================================================
RCS file: /cvs/xenocara/xserver/Xext/xtest.c,v
retrieving revision 1.13
diff -u -p -r1.13 xtest.c
--- xserver/Xext/xtest.c	11 Nov 2021 09:03:02 -0000	1.13
+++ xserver/Xext/xtest.c	5 Dec 2022 18:27:13 -0000
@@ -502,10 +502,11 @@ XTestSwapFakeInput(ClientPtr client, xRe
 
     nev = ((req->length << 2) - sizeof(xReq)) / sizeof(xEvent);
     for (ev = (xEvent *) &req[1]; --nev >= 0; ev++) {
+        int evtype = ev->u.u.type & 0x177;
         /* Swap event */
-        proc = EventSwapVector[ev->u.u.type & 0177];
+        proc = EventSwapVector[evtype];
         /* no swapping proc; invalid event type? */
-        if (!proc || proc == NotImplemented) {
+        if (!proc || proc == NotImplemented || evtype == GenericEvent) {
             client->errorValue = ev->u.u.type;
             return BadValue;
         }
Index: xserver/Xext/xvmain.c
===================================================================
RCS file: /cvs/xenocara/xserver/Xext/xvmain.c,v
retrieving revision 1.14
diff -u -p -r1.14 xvmain.c
--- xserver/Xext/xvmain.c	11 Nov 2021 09:03:02 -0000	1.14
+++ xserver/Xext/xvmain.c	5 Dec 2022 18:27:13 -0000
@@ -811,8 +811,10 @@ XvdiSelectVideoNotify(ClientPtr client, 
         tpn = pn;
         while (tpn) {
             if (tpn->client == client) {
-                if (!onoff)
+                if (!onoff) {
                     tpn->client = NULL;
+                    FreeResource(tpn->id, XvRTVideoNotify);
+                }
                 return Success;
             }
             if (!tpn->client)
Index: xserver/Xi/xipassivegrab.c
===================================================================
RCS file: /cvs/xenocara/xserver/Xi/xipassivegrab.c,v
retrieving revision 1.12
diff -u -p -r1.12 xipassivegrab.c
--- xserver/Xi/xipassivegrab.c	11 Nov 2021 09:03:02 -0000	1.12
+++ xserver/Xi/xipassivegrab.c	5 Dec 2022 18:27:13 -0000
@@ -137,6 +137,12 @@ ProcXIPassiveGrabDevice(ClientPtr client
         return BadValue;
     }
 
+    /* XI2 allows 32-bit keycodes but thanks to XKB we can never
+     * implement this. Just return an error for all keycodes that
+     * cannot work anyway, same for buttons > 255. */
+    if (stuff->detail > 255)
+        return XIAlreadyGrabbed;
+
     if (XICheckInvalidMaskBits(client, (unsigned char *) &stuff[1],
                                stuff->mask_len * 4) != Success)
         return BadValue;
@@ -207,14 +213,8 @@ ProcXIPassiveGrabDevice(ClientPtr client
                                 &param, XI2, &mask);
             break;
         case XIGrabtypeKeycode:
-            /* XI2 allows 32-bit keycodes but thanks to XKB we can never
-             * implement this. Just return an error for all keycodes that
-             * cannot work anyway */
-            if (stuff->detail > 255)
-                status = XIAlreadyGrabbed;
-            else
-                status = GrabKey(client, dev, mod_dev, stuff->detail,
-                                 &param, XI2, &mask);
+            status = GrabKey(client, dev, mod_dev, stuff->detail,
+                             &param, XI2, &mask);
             break;
         case XIGrabtypeEnter:
         case XIGrabtypeFocusIn:
@@ -330,6 +330,12 @@ ProcXIPassiveUngrabDevice(ClientPtr clie
     if ((stuff->grab_type == XIGrabtypeEnter ||
          stuff->grab_type == XIGrabtypeFocusIn ||
          stuff->grab_type == XIGrabtypeTouchBegin) && stuff->detail != 0) {
+        client->errorValue = stuff->detail;
+        return BadValue;
+    }
+
+    /* We don't allow passive grabs for details > 255 anyway */
+    if (stuff->detail > 255) {
         client->errorValue = stuff->detail;
         return BadValue;
     }
Index: xserver/Xi/xiproperty.c
===================================================================
RCS file: /cvs/xenocara/xserver/Xi/xiproperty.c,v
retrieving revision 1.12
diff -u -p -r1.12 xiproperty.c
--- xserver/Xi/xiproperty.c	11 Nov 2021 09:03:02 -0000	1.12
+++ xserver/Xi/xiproperty.c	5 Dec 2022 18:27:13 -0000
@@ -890,7 +890,7 @@ ProcXChangeDeviceProperty(ClientPtr clie
     REQUEST(xChangeDevicePropertyReq);
     DeviceIntPtr dev;
     unsigned long len;
-    int totalSize;
+    uint64_t totalSize;
     int rc;
 
     REQUEST_AT_LEAST_SIZE(xChangeDevicePropertyReq);
@@ -902,6 +902,8 @@ ProcXChangeDeviceProperty(ClientPtr clie
 
     rc = check_change_property(client, stuff->property, stuff->type,
                                stuff->format, stuff->mode, stuff->nUnits);
+    if (rc != Success)
+        return rc;
 
     len = stuff->nUnits;
     if (len > (bytes_to_int32(0xffffffff - sizeof(xChangeDevicePropertyReq))))
@@ -1128,7 +1130,7 @@ ProcXIChangeProperty(ClientPtr client)
 {
     int rc;
     DeviceIntPtr dev;
-    int totalSize;
+    uint64_t totalSize;
     unsigned long len;
 
     REQUEST(xXIChangePropertyReq);
@@ -1141,6 +1143,9 @@ ProcXIChangeProperty(ClientPtr client)
 
     rc = check_change_property(client, stuff->property, stuff->type,
                                stuff->format, stuff->mode, stuff->num_items);
+    if (rc != Success)
+        return rc;
+
     len = stuff->num_items;
     if (len > bytes_to_int32(0xffffffff - sizeof(xXIChangePropertyReq)))
         return BadLength;
Index: xserver/dix/property.c
===================================================================
RCS file: /cvs/xenocara/xserver/dix/property.c,v
retrieving revision 1.14
diff -u -p -r1.14 property.c
--- xserver/dix/property.c	11 Nov 2021 09:03:03 -0000	1.14
+++ xserver/dix/property.c	5 Dec 2022 18:27:13 -0000
@@ -205,7 +205,8 @@ ProcChangeProperty(ClientPtr client)
     WindowPtr pWin;
     char format, mode;
     unsigned long len;
-    int sizeInBytes, totalSize, err;
+    int sizeInBytes, err;
+    uint64_t totalSize;
 
     REQUEST(xChangePropertyReq);
 
Index: xserver/xkb/xkbUtils.c
===================================================================
RCS file: /cvs/xenocara/xserver/xkb/xkbUtils.c,v
retrieving revision 1.13
diff -u -p -r1.13 xkbUtils.c
--- xserver/xkb/xkbUtils.c	18 Feb 2018 17:16:38 -0000	1.13
+++ xserver/xkb/xkbUtils.c	5 Dec 2022 18:27:15 -0000
@@ -1327,6 +1327,7 @@ _XkbCopyNames(XkbDescPtr src, XkbDescPtr
         }
         else {
             free(dst->names->radio_groups);
+            dst->names->radio_groups = NULL;
         }
         dst->names->num_rg = src->names->num_rg;
 
