untrusted comment: verify with openbsd-72-base.pub
RWQTKNnK3CZZ8P0Skdx8m3yQsYTO9lGojg6b3AGuMotbhdTsWV0iIIHiPeBeVPfpdo+yvfZX03DtoFC1oPtwUJhyI3C6z1FPYQE=

OpenBSD 7.2 errata 030, July 12, 2023:

Incomplete validation of ELF headers in execve(2).

Apply by doing:
    signify -Vep /etc/signify/openbsd-72-base.pub -x 030_elf.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/kern/exec_elf.c
===================================================================
RCS file: /cvs/src/sys/kern/exec_elf.c,v
diff -u -p -u -r1.168 exec_elf.c
--- sys/kern/exec_elf.c	29 Aug 2022 16:53:46 -0000	1.168
+++ sys/kern/exec_elf.c	10 Jul 2023 16:34:33 -0000
@@ -312,6 +312,11 @@ elf_load_file(struct proc *p, char *path
 		goto bad1;
 
 	for (i = 0; i < eh.e_phnum; i++) {
+		if ((ph[i].p_align > 1) && !powerof2(ph[i].p_align)) {
+			error = EINVAL;
+			goto bad1;
+		}
+
 		if (ph[i].p_type == PT_LOAD) {
 			if (ph[i].p_filesz > ph[i].p_memsz ||
 			    ph[i].p_memsz == 0) {
@@ -501,6 +506,11 @@ exec_elf_makecmds(struct proc *p, struct
 	epp->ep_dsize = ELF_NO_ADDR;
 
 	for (i = 0, pp = ph; i < eh->e_phnum; i++, pp++) {
+		if ((pp->p_align > 1) && !powerof2(pp->p_align)) {
+			error = EINVAL;
+			goto bad;
+		}
+
 		if (pp->p_type == PT_INTERP && !interp) {
 			if (pp->p_filesz < 2 || pp->p_filesz > MAXPATHLEN)
 				goto bad;
@@ -526,7 +536,7 @@ exec_elf_makecmds(struct proc *p, struct
 
 	if (eh->e_type == ET_DYN) {
 		/* need phdr and load sections for PIE */
-		if (!has_phdr || base_ph == NULL) {
+		if (!has_phdr || base_ph == NULL || base_ph->p_vaddr != 0) {
 			error = EINVAL;
 			goto bad;
 		}
