untrusted comment: verify with openbsd-74-base.pub
RWRoyQmAD08ajafFHaVVlv0n7cJlrYq/ECKmo1p4WI7Lfg5J2bkOiV/+DtduANybesnyxL7hEVYqTZP4GqXX/s0RSDP24fxtAgA=

OpenBSD 7.4 errata 016, April 8, 2024:

Fix multiple heap buffer overread and data leakage in the X11 server
Xi extension and use after free in the Render extention.
CVE-2024-31080 CVE-2024-31081 CVE-2024-31083

Apply by doing:
    signify -Vep /etc/signify/openbsd-74-base.pub -x 016_xserver.patch.sig \
        -m - | (cd /usr/xenocara && patch -p0)

And then rebuild and install the X server:
    cd /usr/xenocara/xserver
    make -f Makefile.bsd-wrapper obj
    make -f Makefile.bsd-wrapper build

Index: xserver/Xi/xipassivegrab.c
===================================================================
RCS file: /cvs/xenocara/xserver/Xi/xipassivegrab.c,v
diff -u -p -r1.13 xipassivegrab.c
--- xserver/Xi/xipassivegrab.c	14 Dec 2022 10:29:00 -0000	1.13
+++ xserver/Xi/xipassivegrab.c	30 Mar 2024 14:33:04 -0000
@@ -247,9 +247,18 @@ ProcXIPassiveGrabDevice(ClientPtr client
         }
     }
 
-    WriteReplyToClient(client, sizeof(rep), &rep);
-    if (rep.num_modifiers)
-        WriteToClient(client, rep.length * 4, modifiers_failed);
+    if (client->swapped) {
+        /* save the value before SRepXIPassiveGrabDevice swaps it */
+        uint32_t length = rep.length;
+        WriteReplyToClient(client, sizeof(rep), &rep);
+        if (length)
+            WriteToClient(client, length * 4, modifiers_failed);
+    }
+    else {
+        WriteReplyToClient(client, sizeof(rep), &rep);
+        if (rep.num_modifiers)
+            WriteToClient(client, rep.length * 4, modifiers_failed);
+    }
 
  out:
     free(modifiers_failed);
Index: xserver/Xi/xiselectev.c
===================================================================
RCS file: /cvs/xenocara/xserver/Xi/xiselectev.c,v
diff -u -p -r1.9 xiselectev.c
--- xserver/Xi/xiselectev.c	11 Nov 2021 09:03:02 -0000	1.9
+++ xserver/Xi/xiselectev.c	30 Mar 2024 14:33:04 -0000
@@ -418,10 +418,21 @@ ProcXIGetSelectedEvents(ClientPtr client
         }
     }
 
-    WriteReplyToClient(client, sizeof(xXIGetSelectedEventsReply), &reply);
+    if (client->swapped) {
+        /* save the value before SRepXIGetSelectedEvents swaps it */
+        uint32_t length = reply.length;
 
-    if (reply.num_masks)
-        WriteToClient(client, reply.length * 4, buffer);
+        WriteReplyToClient(client, sizeof(xXIGetSelectedEventsReply), &reply);
+
+        if (length)
+            WriteToClient(client, length * 4, buffer);
+    }
+    else {
+        WriteReplyToClient(client, sizeof(xXIGetSelectedEventsReply), &reply);
+
+        if (reply.num_masks)
+            WriteToClient(client, reply.length * 4, buffer);
+    }
 
     free(buffer);
     return Success;
Index: xserver/render/glyph.c
===================================================================
RCS file: /cvs/xenocara/xserver/render/glyph.c,v
diff -u -p -r1.12 glyph.c
--- xserver/render/glyph.c	27 Jul 2019 07:57:25 -0000	1.12
+++ xserver/render/glyph.c	30 Mar 2024 14:33:05 -0000
@@ -245,10 +245,11 @@ FreeGlyphPicture(GlyphPtr glyph)
     }
 }
 
-static void
+void
 FreeGlyph(GlyphPtr glyph, int format)
 {
     CheckDuplicates(&globalGlyphs[format], "FreeGlyph");
+    BUG_RETURN(glyph->refcnt == 0);
     if (--glyph->refcnt == 0) {
         GlyphRefPtr gr;
         int i;
@@ -354,7 +355,7 @@ AllocateGlyph(xGlyphInfo * gi, int fdept
     glyph = (GlyphPtr) malloc(size);
     if (!glyph)
         return 0;
-    glyph->refcnt = 0;
+    glyph->refcnt = 1;
     glyph->size = size + sizeof(xGlyphInfo);
     glyph->info = *gi;
     dixInitPrivates(glyph, (char *) glyph + head_size, PRIVATE_GLYPH);
Index: xserver/render/glyphstr.h
===================================================================
RCS file: /cvs/xenocara/xserver/render/glyphstr.h,v
diff -u -p -r1.9 glyphstr.h
--- xserver/render/glyphstr.h	29 May 2016 12:02:40 -0000	1.9
+++ xserver/render/glyphstr.h	30 Mar 2024 14:33:05 -0000
@@ -109,6 +109,8 @@ extern GlyphPtr FindGlyph(GlyphSetPtr gl
 
 extern GlyphPtr AllocateGlyph(xGlyphInfo * gi, int format);
 
+extern void FreeGlyph(GlyphPtr glyph, int format);
+
 extern Bool
  ResizeGlyphSet(GlyphSetPtr glyphSet, CARD32 change);
 
Index: xserver/render/render.c
===================================================================
RCS file: /cvs/xenocara/xserver/render/render.c,v
diff -u -p -r1.26 render.c
--- xserver/render/render.c	20 Feb 2022 17:41:35 -0000	1.26
+++ xserver/render/render.c	30 Mar 2024 14:33:05 -0000
@@ -1076,6 +1076,7 @@ ProcRenderAddGlyphs(ClientPtr client)
 
         if (glyph_new->glyph && glyph_new->glyph != DeletedGlyph) {
             glyph_new->found = TRUE;
+            ++glyph_new->glyph->refcnt;
         }
         else {
             GlyphPtr glyph;
@@ -1168,8 +1169,10 @@ ProcRenderAddGlyphs(ClientPtr client)
         err = BadAlloc;
         goto bail;
     }
-    for (i = 0; i < nglyphs; i++)
+    for (i = 0; i < nglyphs; i++) {
         AddGlyph(glyphSet, glyphs[i].glyph, glyphs[i].id);
+        FreeGlyph(glyphs[i].glyph, glyphSet->fdepth);
+    }
 
     if (glyphsBase != glyphsLocal)
         free(glyphsBase);
@@ -1179,9 +1182,13 @@ ProcRenderAddGlyphs(ClientPtr client)
         FreePicture((void *) pSrc, 0);
     if (pSrcPix)
         FreeScratchPixmapHeader(pSrcPix);
-    for (i = 0; i < nglyphs; i++)
-        if (glyphs[i].glyph && !glyphs[i].found)
-            free(glyphs[i].glyph);
+    for (i = 0; i < nglyphs; i++) {
+        if (glyphs[i].glyph) {
+            --glyphs[i].glyph->refcnt;
+            if (!glyphs[i].found)
+                free(glyphs[i].glyph);
+        }
+    }
     if (glyphsBase != glyphsLocal)
         free(glyphsBase);
     return err;
